/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template.dates;

import info.bliki.wiki.template.dates.StringToTimeException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringToTime
extends Date {
    private static final long serialVersionUID = 7889493424407815134L;
    private static final String defaultSimpleDateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final String timeExpr = "(\\d{1,2})(:(\\d{1,2}))?(:(\\d{1,2})(\\.(\\d{1,3}))?)?( *(am?|pm?))?( *\\-\\d{4})?";
    private static final PatternAndFormat[] known = new PatternAndFormat[]{new PatternAndFormat(Pattern.compile("\\d{4}"), new Format(FormatType.YEAR)), new PatternAndFormat(Pattern.compile("\\-( *\\d{1,} +[^ ]+){1,}", 2), new Format(FormatType.DECREMENT)), new PatternAndFormat(Pattern.compile("\\+?( *\\d{1,} +[^ ]+){1,}", 2), new Format(FormatType.INCREMENT)), new PatternAndFormat(Pattern.compile("([a-z]+) +(\\d{1,2})", 2), new Format(FormatType.MONTH_AND_DATE)), new PatternAndFormat(Pattern.compile("\\d{1,2} +[a-z]+ +(\\d{2}|\\d{4})", 2), new Format("d MMM y")), new PatternAndFormat(Pattern.compile("(midnight|now|today|(this +)?(morning|afternoon|evening)|tonight|noon( +tomorrow)?|tomorrow|tomorrow +(morning|afternoon|evening|night|noon)?|yesterday|yesterday +(morning|afternoon|evening|night)?)", 2), new Format(FormatType.WORD)), new PatternAndFormat(Pattern.compile("(\\d{1,2})(:(\\d{1,2}))?(:(\\d{1,2})(\\.(\\d{1,3}))?)?( *(am?|pm?))?( *\\-\\d{4})?", 2), new Format(FormatType.TIME)), new PatternAndFormat(Pattern.compile("[a-z]+ +\\d{1,2} *, *(\\d{2}|\\d{4})", 2), new Format("MMM d, y")), new PatternAndFormat(Pattern.compile("\\d{1,2}/\\d{1,2}/\\d{2,4}"), new Format("M/d/y")), new PatternAndFormat(Pattern.compile("\\d{1,2}\\-\\d{1,2}\\-\\d{2,4}"), new Format("M-d-y")), new PatternAndFormat(Pattern.compile("(\\d{1,2})(/|\\-)(\\d{1,2})"), new Format(FormatType.MONTH_AND_DATE_WITH_SLASHES)), new PatternAndFormat(Pattern.compile("\\d{4}/\\d{1,2}/\\d{1,2}"), new Format("y/M/d")), new PatternAndFormat(Pattern.compile("\\d{4}\\-\\d{1,2}\\-\\d{1,2}"), new Format("y-M-d")), new PatternAndFormat(Pattern.compile("(Jan(uary)?|Feb(ruary)?|Mar(ch)?|Apr(il)?|May|Jun(e)?|Jul(y)?|Aug(ust)?|Sep(tember)?|Oct(ober)?|Nov(ember)?|Dec(ember)?)", 2), new Format(FormatType.MONTH)), new PatternAndFormat(Pattern.compile("(Sun(day)?|Mon(day)?|Tue(sday)?|Wed(nesday)?|Thu(rsday)?|Fri(day)?|Sat(urday)?)", 2), new Format(FormatType.DAY_OF_WEEK)), new PatternAndFormat(Pattern.compile("next +(.*)", 2), new Format(FormatType.NEXT)), new PatternAndFormat(Pattern.compile("last +(.*)", 2), new Format(FormatType.LAST)), new PatternAndFormat(Pattern.compile("(.*) +(((\\+|\\-){1}.*)|(\\d{1,2})(:(\\d{1,2}))?(:(\\d{1,2})(\\.(\\d{1,3}))?)?( *(am?|pm?))?( *\\-\\d{4})?)$", 2), new Format(FormatType.COMPOUND))};
    private Object dateTimeString;
    private String simpleDateFormat;
    private Object date;

    public StringToTime() {
        this.date = new Date(this.getTime());
    }

    public StringToTime(Date date) {
        super(date.getTime());
        this.date = new Date(this.getTime());
    }

    public StringToTime(Object dateTimeString) {
        this(dateTimeString, new Date(), defaultSimpleDateFormat);
    }

    public StringToTime(Object dateTimeString, String simpleDateFormat) {
        this(dateTimeString, new Date(), simpleDateFormat);
    }

    public StringToTime(Object dateTimeString, Date now) {
        this(dateTimeString, now, defaultSimpleDateFormat);
    }

    public StringToTime(Object dateTimeString, Long now) {
        this(dateTimeString, new Date(now), defaultSimpleDateFormat);
    }

    public StringToTime(Object dateTimeString, Integer now) {
        this(dateTimeString, new Date(new Long(now.intValue())), defaultSimpleDateFormat);
    }

    public StringToTime(Object dateTimeString, Date now, String simpleDateFormat) {
        super(0L);
        assert (dateTimeString != null);
        assert (now != null);
        assert (simpleDateFormat != null);
        this.dateTimeString = dateTimeString;
        this.simpleDateFormat = simpleDateFormat;
        this.date = StringToTime.date(dateTimeString, now);
        if (Boolean.FALSE.equals(this.date)) {
            throw new StringToTimeException(dateTimeString);
        }
        this.setTime(((Date)this.date).getTime());
    }

    @Override
    public long getTime() {
        return super.getTime();
    }

    public Calendar getCal() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(super.getTime());
        return cal;
    }

    public String format(String simpleDateFormat) {
        return new SimpleDateFormat(simpleDateFormat, DEFAULT_LOCALE).format(this);
    }

    @Override
    public String toString() {
        if (this.simpleDateFormat != null) {
            return new SimpleDateFormat(this.simpleDateFormat, DEFAULT_LOCALE).format(this);
        }
        return new SimpleDateFormat("yyyy/dd/MM", DEFAULT_LOCALE).format(this);
    }

    public static Object time(Object dateTimeString) {
        return StringToTime.time(dateTimeString, new Date());
    }

    public static Object time(Object dateTimeString, Date now) {
        try {
            if (dateTimeString == null) {
                return Boolean.FALSE;
            }
            String trimmed = String.valueOf(dateTimeString).trim();
            for (PatternAndFormat paf : known) {
                Matcher m = paf.matches(trimmed);
                if (!m.matches()) continue;
                Long time = paf.parse(trimmed, now, m);
                return time;
            }
            return Boolean.FALSE;
        }
        catch (Exception e) {
            if (!Boolean.parseBoolean(System.getProperty(StringToTime.class + ".EXCEPTION_ON_PARSE_FAILURE", "false"))) {
                return Boolean.FALSE;
            }
            throw new StringToTimeException(dateTimeString, (Throwable)e);
        }
    }

    private static ParserResult getParserResult(String trimmedDateTimeString, Date now) throws ParseException {
        for (PatternAndFormat paf : known) {
            Matcher m = paf.matches(trimmedDateTimeString);
            if (!m.matches()) continue;
            return new ParserResult(paf.parse(trimmedDateTimeString, now, m), paf.f.type);
        }
        return null;
    }

    public static Object date(Object dateTimeString) {
        return StringToTime.date(dateTimeString, new Date());
    }

    public static Object date(Object dateTimeString, Date now) {
        Object time = StringToTime.time(dateTimeString, now);
        return Boolean.FALSE.equals(time) ? Boolean.FALSE : new Date((Long)time);
    }

    public static Object cal(Object dateTimeString) {
        return StringToTime.cal(dateTimeString, new Date());
    }

    public static Object cal(Object dateTimeString, Date now) {
        Object date = StringToTime.date(dateTimeString, now);
        if (Boolean.FALSE.equals(date)) {
            return Boolean.FALSE;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)date);
        return cal;
    }

    private static enum FormatType {
        COMPOUND,
        MONTH_AND_DATE_WITH_SLASHES,
        MONTH_AND_DATE,
        MONTH,
        DAY_OF_WEEK,
        NEXT,
        LAST,
        INCREMENT,
        DECREMENT,
        WORD,
        TIME,
        YEAR;

    }

    private static class Format {
        private static Pattern unit = Pattern.compile("(\\d{1,}) +(s(ec(ond)?)?|mo(n(th)?)?|(hour|hr?)|d(ay)?|(w(eek)?|wk)|m(in(ute)?)?|(y(ear)?|yr))s?");
        private static Pattern removeExtraSpaces = Pattern.compile(" +");
        private static Map<String, Integer> translateDayOfWeek = new HashMap<String, Integer>();
        private String sdf;
        private FormatType type;

        public Format(FormatType type) {
            this.type = type;
        }

        public Format(String sdf) {
            this.sdf = sdf;
        }

        public String toString() {
            if (this.sdf != null) {
                return this.sdf;
            }
            return this.type.toString();
        }

        public Date parse(String dateTimeString, Date now, Matcher m) throws ParseException {
            if (this.sdf != null) {
                return new SimpleDateFormat(this.sdf, DEFAULT_LOCALE).parse(dateTimeString);
            }
            dateTimeString = removeExtraSpaces.matcher(dateTimeString).replaceAll(" ").toLowerCase();
            try {
                Calendar cal = Calendar.getInstance();
                cal.setTime(now);
                if (this.type == FormatType.WORD) {
                    if ("now".equals(dateTimeString)) {
                        return now != null ? now : new Date();
                    }
                    if ("today".equals(dateTimeString)) {
                        cal.set(11, 0);
                        cal.set(12, 0);
                        cal.set(13, 0);
                        cal.set(14, 0);
                        return new Date(cal.getTimeInMillis());
                    }
                    if ("morning".equals(dateTimeString) || "this morning".equals(dateTimeString)) {
                        int thisMorningBeginsAt = Integer.parseInt(System.getProperty(StringToTime.class + ".THIS_MORNING_BEGINS_AT", "7"));
                        cal.set(11, thisMorningBeginsAt);
                        cal.set(12, 0);
                        cal.set(13, 0);
                        cal.set(14, 0);
                        return new Date(cal.getTimeInMillis());
                    }
                    if ("noon".equals(dateTimeString)) {
                        cal.set(11, 12);
                        cal.set(12, 0);
                        cal.set(13, 0);
                        cal.set(14, 0);
                        return new Date(cal.getTimeInMillis());
                    }
                    if ("afternoon".equals(dateTimeString) || "this afternoon".equals(dateTimeString)) {
                        int thisAfternoonBeginsAt = Integer.parseInt(System.getProperty(StringToTime.class + ".THIS_AFTERNOON_BEGINS_AT", "13"));
                        cal.set(11, thisAfternoonBeginsAt);
                        cal.set(12, 0);
                        cal.set(13, 0);
                        cal.set(14, 0);
                        return new Date(cal.getTimeInMillis());
                    }
                    if ("evening".equals(dateTimeString) || "this evening".equals(dateTimeString)) {
                        int thisEveningBeginsAt = Integer.parseInt(System.getProperty(StringToTime.class + ".THIS_EVENING_BEGINS_AT", "17"));
                        cal.set(11, thisEveningBeginsAt);
                        cal.set(12, 0);
                        cal.set(13, 0);
                        cal.set(14, 0);
                        return new Date(cal.getTimeInMillis());
                    }
                    if ("tonight".equals(dateTimeString)) {
                        int tonightBeginsAt = Integer.parseInt(System.getProperty(StringToTime.class + ".TONIGHT_BEGINS_AT", "20"));
                        cal.set(11, tonightBeginsAt);
                        cal.set(12, 0);
                        cal.set(13, 0);
                        cal.set(14, 0);
                        return new Date(cal.getTimeInMillis());
                    }
                    if ("midnight".equals(dateTimeString)) {
                        return new StringToTime((Object)"00:00:00 +24 hours", now);
                    }
                    if ("tomorrow".equals(dateTimeString)) {
                        return new StringToTime((Object)"now +24 hours", now);
                    }
                    if ("tomorrow morning".equals(dateTimeString)) {
                        return new StringToTime((Object)"morning +24 hours", now);
                    }
                    if ("tomorrow noon".equals(dateTimeString) || "noon tomorrow".equals(dateTimeString)) {
                        return new StringToTime((Object)"noon +24 hours", now);
                    }
                    if ("tomorrow afternoon".equals(dateTimeString)) {
                        return new StringToTime((Object)"afternoon +24 hours", now);
                    }
                    if ("tomorrow evening".equals(dateTimeString)) {
                        return new StringToTime((Object)"evening +24 hours", now);
                    }
                    if ("tomorrow night".equals(dateTimeString)) {
                        return new StringToTime((Object)"tonight +24 hours", now);
                    }
                    if ("yesterday".equals(dateTimeString)) {
                        return new StringToTime((Object)"now -24 hours", now);
                    }
                    if ("yesterday morning".equals(dateTimeString)) {
                        return new StringToTime((Object)"morning -24 hours", now);
                    }
                    if ("yesterday noon".equals(dateTimeString) || "noon yesterday".equals(dateTimeString)) {
                        return new StringToTime((Object)"noon -24 hours", now);
                    }
                    if ("yesterday afternoon".equals(dateTimeString)) {
                        return new StringToTime((Object)"afternoon -24 hours", now);
                    }
                    if ("yesterday evening".equals(dateTimeString)) {
                        return new StringToTime((Object)"evening -24 hours", now);
                    }
                    if ("yesterday night".equals(dateTimeString)) {
                        return new StringToTime((Object)"tonight -24 hours", now);
                    }
                    throw new ParseException(String.format("Unrecognized date word: %s", dateTimeString), 0);
                }
                if (this.type == FormatType.TIME) {
                    String hour = m.group(1);
                    String min = m.group(3);
                    String sec = m.group(5);
                    String ms = m.group(7);
                    String amOrPm = m.group(8);
                    if (hour != null) {
                        if (amOrPm != null) {
                            cal.set(10, new Integer(hour));
                        } else {
                            cal.set(11, new Integer(hour));
                        }
                    } else {
                        cal.set(10, 0);
                    }
                    cal.set(12, min != null ? new Integer(min) : 0);
                    cal.set(13, sec != null ? new Integer(sec) : 0);
                    cal.set(14, ms != null ? new Integer(ms) : 0);
                    if (amOrPm != null) {
                        cal.set(9, amOrPm.equals("a") || amOrPm.equals("am") ? 0 : 1);
                    }
                    return new Date(cal.getTimeInMillis());
                }
                if (this.type == FormatType.INCREMENT || this.type == FormatType.DECREMENT) {
                    Matcher units = unit.matcher(dateTimeString);
                    while (units.find()) {
                        Integer val = new Integer(units.group(1)) * (this.type == FormatType.DECREMENT ? -1 : 1);
                        String u = units.group(2);
                        if ("s".equals(u) || "sec".equals(u) || "second".equals(u)) {
                            cal.set(13, cal.get(13) + val);
                            continue;
                        }
                        if ("m".equals(u) || "min".equals(u) || "minute".equals(u)) {
                            cal.set(12, cal.get(12) + val);
                            continue;
                        }
                        if ("h".equals(u) || "hr".equals(u) || "hour".equals(u)) {
                            cal.set(11, cal.get(11) + val);
                            continue;
                        }
                        if ("d".equals(u) || "day".equals(u)) {
                            cal.set(5, cal.get(5) + val);
                            continue;
                        }
                        if ("w".equals(u) || "wk".equals(u) || "week".equals(u)) {
                            cal.set(3, cal.get(3) + val);
                            continue;
                        }
                        if ("mo".equals(u) || "mon".equals(u) || "month".equals(u)) {
                            cal.set(2, cal.get(2) + val);
                            continue;
                        }
                        if ("y".equals(u) || "yr".equals(u) || "year".equals(u)) {
                            cal.set(1, cal.get(1) + val);
                            continue;
                        }
                        throw new IllegalArgumentException(String.format("Unrecognized %s unit: [%s]", new Object[]{this.type, u}));
                    }
                    return new Date(cal.getTimeInMillis());
                }
                if (this.type == FormatType.COMPOUND) {
                    Object date = StringToTime.date(m.group(1), now);
                    if (!Boolean.FALSE.equals(date)) {
                        return (Date)StringToTime.date(m.group(2), (Date)date);
                    }
                    throw new IllegalArgumentException(String.format("Couldn't parse %s, so couldn't compound with %s", m.group(1), m.group(2)));
                }
                if (this.type == FormatType.MONTH) {
                    Calendar ref = Calendar.getInstance();
                    ref.setTime(new SimpleDateFormat("MMM d, y", DEFAULT_LOCALE).parse(String.format("%s 1, 1970", m.group(1))));
                    cal.set(2, ref.get(2));
                    return new Date(cal.getTimeInMillis());
                }
                if (this.type == FormatType.DAY_OF_WEEK) {
                    Integer ref = translateDayOfWeek.get(dateTimeString);
                    if (cal.get(7) >= ref) {
                        cal.set(3, cal.get(3) + 1);
                    }
                    cal.set(7, ref);
                    return new Date(cal.getTimeInMillis());
                }
                if (this.type == FormatType.MONTH_AND_DATE_WITH_SLASHES) {
                    Calendar ref = Calendar.getInstance();
                    ref.setTime(new SimpleDateFormat("M/d/y", DEFAULT_LOCALE).parse(String.format("%s/%s/1970", m.group(1), m.group(3))));
                    cal.set(2, ref.get(2));
                    cal.set(5, ref.get(5));
                    return new Date(cal.getTimeInMillis());
                }
                if (this.type == FormatType.MONTH_AND_DATE) {
                    Calendar ref = Calendar.getInstance();
                    ref.setTime(new SimpleDateFormat("MMM d, y", DEFAULT_LOCALE).parse(String.format("%s %s, 1970", m.group(1), m.group(2))));
                    cal.set(2, ref.get(2));
                    cal.set(5, ref.get(5));
                    return new Date(cal.getTimeInMillis());
                }
                if (this.type == FormatType.NEXT) {
                    String expr = m.group(1);
                    ParserResult parsed = StringToTime.getParserResult(expr, now);
                    if (parsed != null && (FormatType.MONTH.equals((Object)parsed.type) || FormatType.DAY_OF_WEEK.equals((Object)parsed.type) || FormatType.MONTH_AND_DATE.equals((Object)parsed.type))) {
                        return new Date(parsed.timestamp);
                    }
                    if ("week".equals(expr)) {
                        cal.set(3, cal.get(3) + 1);
                    } else if ("month".equals(expr)) {
                        cal.set(2, cal.get(2) + 1);
                    } else if ("year".equals(expr)) {
                        cal.set(1, cal.get(1) + 1);
                    } else {
                        throw new IllegalArgumentException(String.format("Invalid expression of time: %s", dateTimeString));
                    }
                    return new Date(cal.getTimeInMillis());
                }
                if (this.type == FormatType.LAST) {
                    String expr = m.group(1);
                    ParserResult parsed = StringToTime.getParserResult(expr, now);
                    if (parsed != null && (FormatType.MONTH.equals((Object)parsed.type) || FormatType.MONTH_AND_DATE.equals((Object)parsed.type))) {
                        return new StringToTime((Object)"-1 year", new Date(parsed.timestamp));
                    }
                    if (parsed != null && FormatType.DAY_OF_WEEK.equals((Object)parsed.type)) {
                        return new StringToTime((Object)"-1 week", new Date(parsed.timestamp));
                    }
                    if ("week".equals(expr)) {
                        cal.set(3, cal.get(3) - 1);
                    } else if ("month".equals(expr)) {
                        cal.set(2, cal.get(2) - 1);
                    } else if ("year".equals(expr)) {
                        cal.set(1, cal.get(1) - 1);
                    } else {
                        throw new IllegalArgumentException(String.format("Invalid expression of time: %s", dateTimeString));
                    }
                    return new Date(cal.getTimeInMillis());
                }
                if (this.type == FormatType.YEAR) {
                    cal.set(1, new Integer(m.group(0)));
                    return new Date(cal.getTimeInMillis());
                }
                throw new IllegalStateException(String.format("Unimplemented FormatType: %s", new Object[]{this.type}));
            }
            catch (IllegalArgumentException | IllegalStateException | ParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unknown failure in string-to-time conversion: %s", e.getMessage()), e);
            }
        }

        static {
            translateDayOfWeek.put("sunday", 1);
            translateDayOfWeek.put("sun", 1);
            translateDayOfWeek.put("monday", 2);
            translateDayOfWeek.put("mon", 2);
            translateDayOfWeek.put("tuesday", 3);
            translateDayOfWeek.put("tue", 3);
            translateDayOfWeek.put("wednesday", 4);
            translateDayOfWeek.put("wed", 4);
            translateDayOfWeek.put("thursday", 5);
            translateDayOfWeek.put("thu", 5);
            translateDayOfWeek.put("friday", 6);
            translateDayOfWeek.put("fri", 6);
            translateDayOfWeek.put("saturday", 7);
            translateDayOfWeek.put("sat", 7);
        }
    }

    private static class ParserResult {
        public FormatType type;
        public Long timestamp;

        public ParserResult(Long timestamp, FormatType type) {
            this.timestamp = timestamp;
            this.type = type;
        }
    }

    private static class PatternAndFormat {
        public Pattern p;
        public Format f;

        public PatternAndFormat(Pattern p, Format f) {
            this.p = p;
            this.f = f;
        }

        public Matcher matches(String dateTimeString) {
            return this.p.matcher(dateTimeString);
        }

        public Long parse(String dateTimeString, Date now, Matcher m) throws ParseException {
            return this.f.parse(dateTimeString, now, m).getTime();
        }
    }
}

