/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import java.math.BigInteger;
import net.osmand.core.jni.IMapStylesCollection;
import net.osmand.core.jni.IObfsCollection;
import net.osmand.core.jni.IOnlineTileSources;
import net.osmand.core.jni.IWebClient;
import net.osmand.core.jni.ObfFile;
import net.osmand.core.jni.OnlineTileSources;
import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.QStringList;
import net.osmand.core.jni.ResourcesManagerLocalResourcesChangedObservable;
import net.osmand.core.jni.ResourcesManagerRepositoryUpdatedObservable;
import net.osmand.core.jni.SWIGTYPE_p_OsmAnd__ResourcesManager__LocalResourcesChanged;
import net.osmand.core.jni.SWIGTYPE_p_OsmAnd__ResourcesManager__RepositoryUpdated;
import net.osmand.core.jni.SWIGTYPE_p_QHashT_BandIndex_std__shared_ptrT_GeoBandSettings_const_t_t;
import net.osmand.core.jni.SWIGTYPE_p_QHashT_QString_std__shared_ptrT_OsmAnd__ResourcesManager__BuiltinResource_const_t_t;
import net.osmand.core.jni.SWIGTYPE_p_QHashT_QString_std__shared_ptrT_OsmAnd__ResourcesManager__LocalResource_const_t_t;
import net.osmand.core.jni.SWIGTYPE_p_QHashT_QString_std__shared_ptrT_OsmAnd__ResourcesManager__ResourceInRepository_const_t_t;
import net.osmand.core.jni.SWIGTYPE_p_QListT_std__shared_ptrT_OsmAnd__ResourcesManager__LocalResource_const_t_t;
import net.osmand.core.jni.SWIGTYPE_p_QStringRef;
import net.osmand.core.jni.SWIGTYPE_p_QUrl;
import net.osmand.core.jni.SWIGTYPE_p_std__functionT_void_funsigned_long_long_const_unsigned_long_long_constF_t;
import net.osmand.core.jni.SWIGTYPE_p_std__shared_ptrT_OsmAnd__IncrementalChangesManager_t;
import net.osmand.core.jni.UnresolvedMapStyle;
import net.osmand.core.jni.WeatherTileResourcesManager;

public class ResourcesManager {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected ResourcesManager(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(ResourcesManager resourcesManager) {
        return resourcesManager == null ? 0L : resourcesManager.swigCPtr;
    }

    protected static long swigRelease(ResourcesManager resourcesManager) {
        long l = 0L;
        if (resourcesManager != null) {
            if (!resourcesManager.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = resourcesManager.swigCPtr;
            resourcesManager.swigCMemOwn = false;
            resourcesManager.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_ResourcesManager(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public ResourcesManager(String string, String string2, QStringList qStringList, String string3, String string4, String string5, String string6, String string7, String string8, String string9, IWebClient iWebClient) {
        this(OsmAndCoreJNI.new_ResourcesManager__SWIG_0(string, string2, QStringList.getCPtr(qStringList), qStringList, string3, string4, string5, string6, string7, string8, string9, IWebClient.getCPtr(iWebClient), iWebClient), true);
    }

    public ResourcesManager(String string, String string2, QStringList qStringList, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        this(OsmAndCoreJNI.new_ResourcesManager__SWIG_1(string, string2, QStringList.getCPtr(qStringList), qStringList, string3, string4, string5, string6, string7, string8, string9), true);
    }

    public ResourcesManager(String string, String string2, QStringList qStringList, String string3, String string4, String string5, String string6, String string7, String string8) {
        this(OsmAndCoreJNI.new_ResourcesManager__SWIG_2(string, string2, QStringList.getCPtr(qStringList), qStringList, string3, string4, string5, string6, string7, string8), true);
    }

    public ResourcesManager(String string, String string2, QStringList qStringList, String string3, String string4, String string5, String string6, String string7) {
        this(OsmAndCoreJNI.new_ResourcesManager__SWIG_3(string, string2, QStringList.getCPtr(qStringList), qStringList, string3, string4, string5, string6, string7), true);
    }

    public ResourcesManager(String string, String string2, QStringList qStringList, String string3, String string4, String string5, String string6) {
        this(OsmAndCoreJNI.new_ResourcesManager__SWIG_4(string, string2, QStringList.getCPtr(qStringList), qStringList, string3, string4, string5, string6), true);
    }

    public ResourcesManager(String string, String string2, QStringList qStringList, String string3, String string4, String string5) {
        this(OsmAndCoreJNI.new_ResourcesManager__SWIG_5(string, string2, QStringList.getCPtr(qStringList), qStringList, string3, string4, string5), true);
    }

    public ResourcesManager(String string, String string2, QStringList qStringList, String string3, String string4) {
        this(OsmAndCoreJNI.new_ResourcesManager__SWIG_6(string, string2, QStringList.getCPtr(qStringList), qStringList, string3, string4), true);
    }

    public ResourcesManager(String string, String string2, QStringList qStringList, String string3) {
        this(OsmAndCoreJNI.new_ResourcesManager__SWIG_7(string, string2, QStringList.getCPtr(qStringList), qStringList, string3), true);
    }

    public ResourcesManager(String string, String string2, QStringList qStringList) {
        this(OsmAndCoreJNI.new_ResourcesManager__SWIG_8(string, string2, QStringList.getCPtr(qStringList), qStringList), true);
    }

    public ResourcesManager(String string, String string2) {
        this(OsmAndCoreJNI.new_ResourcesManager__SWIG_9(string, string2), true);
    }

    public ResourcesManager(String string) {
        this(OsmAndCoreJNI.new_ResourcesManager__SWIG_10(string), true);
    }

    public String getLocalStoragePath() {
        return OsmAndCoreJNI.ResourcesManager_localStoragePath_get(this.swigCPtr, this);
    }

    public String getUserStoragePath() {
        return OsmAndCoreJNI.ResourcesManager_userStoragePath_get(this.swigCPtr, this);
    }

    public QStringList getReadonlyExternalStoragePaths() {
        long l = OsmAndCoreJNI.ResourcesManager_readonlyExternalStoragePaths_get(this.swigCPtr, this);
        return l == 0L ? null : new QStringList(l, false);
    }

    public String getMiniBasemapFilename() {
        return OsmAndCoreJNI.ResourcesManager_miniBasemapFilename_get(this.swigCPtr, this);
    }

    public String getLocalTemporaryPath() {
        return OsmAndCoreJNI.ResourcesManager_localTemporaryPath_get(this.swigCPtr, this);
    }

    public String getRepositoryBaseUrl() {
        return OsmAndCoreJNI.ResourcesManager_repositoryBaseUrl_get(this.swigCPtr, this);
    }

    public String getIndexesUrl() {
        return OsmAndCoreJNI.ResourcesManager_indexesUrl_get(this.swigCPtr, this);
    }

    public String getHiddenMapsPath() {
        return OsmAndCoreJNI.ResourcesManager_hiddenMapsPath_get(this.swigCPtr, this);
    }

    public String getLocalCachePath() {
        return OsmAndCoreJNI.ResourcesManager_localCachePath_get(this.swigCPtr, this);
    }

    public String getAppVersion() {
        return OsmAndCoreJNI.ResourcesManager_appVersion_get(this.swigCPtr, this);
    }

    public Resource getResource(String string) {
        long l = OsmAndCoreJNI.ResourcesManager_getResource(this.swigCPtr, this, string);
        return l == 0L ? null : new Resource(l, true);
    }

    public SWIGTYPE_p_QHashT_QString_std__shared_ptrT_OsmAnd__ResourcesManager__BuiltinResource_const_t_t getBuiltInResources() {
        return new SWIGTYPE_p_QHashT_QString_std__shared_ptrT_OsmAnd__ResourcesManager__BuiltinResource_const_t_t(OsmAndCoreJNI.ResourcesManager_getBuiltInResources(this.swigCPtr, this), true);
    }

    public BuiltinResource getBuiltInResource(String string) {
        long l = OsmAndCoreJNI.ResourcesManager_getBuiltInResource(this.swigCPtr, this, string);
        return l == 0L ? null : new BuiltinResource(l, true);
    }

    public boolean isBuiltInResource(String string) {
        return OsmAndCoreJNI.ResourcesManager_isBuiltInResource(this.swigCPtr, this, string);
    }

    public boolean rescanUnmanagedStoragePaths(boolean bl) {
        return OsmAndCoreJNI.ResourcesManager_rescanUnmanagedStoragePaths__SWIG_0(this.swigCPtr, this, bl);
    }

    public boolean rescanUnmanagedStoragePaths() {
        return OsmAndCoreJNI.ResourcesManager_rescanUnmanagedStoragePaths__SWIG_1(this.swigCPtr, this);
    }

    public SWIGTYPE_p_QListT_std__shared_ptrT_OsmAnd__ResourcesManager__LocalResource_const_t_t getSortedLocalResources() {
        return new SWIGTYPE_p_QListT_std__shared_ptrT_OsmAnd__ResourcesManager__LocalResource_const_t_t(OsmAndCoreJNI.ResourcesManager_getSortedLocalResources(this.swigCPtr, this), true);
    }

    public SWIGTYPE_p_QHashT_QString_std__shared_ptrT_OsmAnd__ResourcesManager__LocalResource_const_t_t getLocalResources() {
        return new SWIGTYPE_p_QHashT_QString_std__shared_ptrT_OsmAnd__ResourcesManager__LocalResource_const_t_t(OsmAndCoreJNI.ResourcesManager_getLocalResources(this.swigCPtr, this), true);
    }

    public LocalResource getLocalResource(String string) {
        long l = OsmAndCoreJNI.ResourcesManager_getLocalResource(this.swigCPtr, this, string);
        return l == 0L ? null : new LocalResource(l, true);
    }

    public boolean isLocalResource(String string) {
        return OsmAndCoreJNI.ResourcesManager_isLocalResource(this.swigCPtr, this, string);
    }

    public boolean isLocalResourceHidden(String string) {
        return OsmAndCoreJNI.ResourcesManager_isLocalResourceHidden__SWIG_0(this.swigCPtr, this, string);
    }

    public boolean isLocalResourceHidden(LocalResource localResource) {
        return OsmAndCoreJNI.ResourcesManager_isLocalResourceHidden__SWIG_1(this.swigCPtr, this, LocalResource.getCPtr(localResource));
    }

    public boolean isRepositoryAvailable() {
        return OsmAndCoreJNI.ResourcesManager_isRepositoryAvailable(this.swigCPtr, this);
    }

    public boolean updateRepository() {
        return OsmAndCoreJNI.ResourcesManager_updateRepository(this.swigCPtr, this);
    }

    public SWIGTYPE_p_QHashT_QString_std__shared_ptrT_OsmAnd__ResourcesManager__ResourceInRepository_const_t_t getResourcesInRepository() {
        return new SWIGTYPE_p_QHashT_QString_std__shared_ptrT_OsmAnd__ResourcesManager__ResourceInRepository_const_t_t(OsmAndCoreJNI.ResourcesManager_getResourcesInRepository(this.swigCPtr, this), true);
    }

    public ResourceInRepository getResourceInRepository(String string) {
        long l = OsmAndCoreJNI.ResourcesManager_getResourceInRepository(this.swigCPtr, this, string);
        return l == 0L ? null : new ResourceInRepository(l, true);
    }

    public boolean isResourceInRepository(String string) {
        return OsmAndCoreJNI.ResourcesManager_isResourceInRepository(this.swigCPtr, this, string);
    }

    public boolean isResourceInstalled(String string) {
        return OsmAndCoreJNI.ResourcesManager_isResourceInstalled(this.swigCPtr, this, string);
    }

    public BigInteger getResourceTimestamp(String string) {
        return OsmAndCoreJNI.ResourcesManager_getResourceTimestamp(this.swigCPtr, this, string);
    }

    public boolean uninstallResource(String string) {
        return OsmAndCoreJNI.ResourcesManager_uninstallResource__SWIG_0(this.swigCPtr, this, string);
    }

    public boolean uninstallResource(InstalledResource installedResource, LocalResource localResource) {
        return OsmAndCoreJNI.ResourcesManager_uninstallResource__SWIG_1(this.swigCPtr, this, InstalledResource.getCPtr(installedResource), LocalResource.getCPtr(localResource));
    }

    public boolean uninstallTilesResource(String string) {
        return OsmAndCoreJNI.ResourcesManager_uninstallTilesResource(this.swigCPtr, this, string);
    }

    public boolean installTilesResource(IOnlineTileSources.Source source) {
        return OsmAndCoreJNI.ResourcesManager_installTilesResource(this.swigCPtr, this, IOnlineTileSources.Source.getCPtr(source));
    }

    public void installBuiltInTileSources() {
        OsmAndCoreJNI.ResourcesManager_installBuiltInTileSources(this.swigCPtr, this);
    }

    public boolean installFromFile(String string, ResourceType resourceType) {
        return OsmAndCoreJNI.ResourcesManager_installFromFile__SWIG_0(this.swigCPtr, this, string, resourceType.swigValue());
    }

    public boolean installFromFile(String string, String string2, ResourceType resourceType) {
        return OsmAndCoreJNI.ResourcesManager_installFromFile__SWIG_1(this.swigCPtr, this, string, string2, resourceType.swigValue());
    }

    public boolean installImportedResource(String string, String string2, ResourceType resourceType) {
        return OsmAndCoreJNI.ResourcesManager_installImportedResource(this.swigCPtr, this, string, string2, resourceType.swigValue());
    }

    public boolean installFromRepository(String string, SWIGTYPE_p_std__functionT_void_funsigned_long_long_const_unsigned_long_long_constF_t sWIGTYPE_p_std__functionT_void_funsigned_long_long_const_unsigned_long_long_constF_t) {
        return OsmAndCoreJNI.ResourcesManager_installFromRepository__SWIG_0(this.swigCPtr, this, string, SWIGTYPE_p_std__functionT_void_funsigned_long_long_const_unsigned_long_long_constF_t.getCPtr(sWIGTYPE_p_std__functionT_void_funsigned_long_long_const_unsigned_long_long_constF_t));
    }

    public boolean installFromRepository(String string) {
        return OsmAndCoreJNI.ResourcesManager_installFromRepository__SWIG_1(this.swigCPtr, this, string);
    }

    public boolean installFromRepository(String string, String string2) {
        return OsmAndCoreJNI.ResourcesManager_installFromRepository__SWIG_2(this.swigCPtr, this, string, string2);
    }

    public boolean isInstalledResourceOutdated(String string) {
        return OsmAndCoreJNI.ResourcesManager_isInstalledResourceOutdated(this.swigCPtr, this, string);
    }

    public SWIGTYPE_p_QHashT_QString_std__shared_ptrT_OsmAnd__ResourcesManager__LocalResource_const_t_t getOutdatedInstalledResources() {
        return new SWIGTYPE_p_QHashT_QString_std__shared_ptrT_OsmAnd__ResourcesManager__LocalResource_const_t_t(OsmAndCoreJNI.ResourcesManager_getOutdatedInstalledResources(this.swigCPtr, this), true);
    }

    public boolean updateFromFile(String string) {
        return OsmAndCoreJNI.ResourcesManager_updateFromFile__SWIG_0(this.swigCPtr, this, string);
    }

    public boolean updateFromFile(String string, String string2) {
        return OsmAndCoreJNI.ResourcesManager_updateFromFile__SWIG_1(this.swigCPtr, this, string, string2);
    }

    public boolean updateFromRepository(String string, SWIGTYPE_p_std__functionT_void_funsigned_long_long_const_unsigned_long_long_constF_t sWIGTYPE_p_std__functionT_void_funsigned_long_long_const_unsigned_long_long_constF_t) {
        return OsmAndCoreJNI.ResourcesManager_updateFromRepository__SWIG_0(this.swigCPtr, this, string, SWIGTYPE_p_std__functionT_void_funsigned_long_long_const_unsigned_long_long_constF_t.getCPtr(sWIGTYPE_p_std__functionT_void_funsigned_long_long_const_unsigned_long_long_constF_t));
    }

    public boolean updateFromRepository(String string) {
        return OsmAndCoreJNI.ResourcesManager_updateFromRepository__SWIG_1(this.swigCPtr, this, string);
    }

    public boolean updateFromRepository(String string, String string2) {
        return OsmAndCoreJNI.ResourcesManager_updateFromRepository__SWIG_2(this.swigCPtr, this, string, string2);
    }

    public OnlineTileSources downloadOnlineTileSources() {
        long l = OsmAndCoreJNI.ResourcesManager_downloadOnlineTileSources(this.swigCPtr, this);
        return l == 0L ? null : new OnlineTileSources(l, true);
    }

    public boolean addLocalResource(String string) {
        return OsmAndCoreJNI.ResourcesManager_addLocalResource(this.swigCPtr, this, string);
    }

    public ResourcesManagerLocalResourcesChangedObservable getLocalResourcesChangeObservable() {
        long l = OsmAndCoreJNI.ResourcesManager_localResourcesChangeObservable_get(this.swigCPtr, this);
        return l == 0L ? null : new ResourcesManagerLocalResourcesChangedObservable(l, false);
    }

    public ResourcesManagerRepositoryUpdatedObservable getRepositoryUpdateObservable() {
        long l = OsmAndCoreJNI.ResourcesManager_repositoryUpdateObservable_get(this.swigCPtr, this);
        return l == 0L ? null : new ResourcesManagerRepositoryUpdatedObservable(l, false);
    }

    public IOnlineTileSources getOnlineTileSources() {
        long l = OsmAndCoreJNI.ResourcesManager_onlineTileSources_get(this.swigCPtr, this);
        return l == 0L ? null : new IOnlineTileSources(l, true);
    }

    public IMapStylesCollection getMapStylesCollection() {
        long l = OsmAndCoreJNI.ResourcesManager_mapStylesCollection_get(this.swigCPtr, this);
        return l == 0L ? null : new IMapStylesCollection(l, true);
    }

    public IObfsCollection getObfsCollection() {
        long l = OsmAndCoreJNI.ResourcesManager_obfsCollection_get(this.swigCPtr, this);
        return l == 0L ? null : new IObfsCollection(l, true);
    }

    public SWIGTYPE_p_std__shared_ptrT_OsmAnd__IncrementalChangesManager_t getChangesManager() {
        return new SWIGTYPE_p_std__shared_ptrT_OsmAnd__IncrementalChangesManager_t(OsmAndCoreJNI.ResourcesManager_changesManager_get(this.swigCPtr, this), false);
    }

    public WeatherTileResourcesManager getWeatherResourcesManager() {
        long l = OsmAndCoreJNI.ResourcesManager_getWeatherResourcesManager(this.swigCPtr, this);
        return l == 0L ? null : new WeatherTileResourcesManager(l, true);
    }

    public void instantiateWeatherResourcesManager(SWIGTYPE_p_QHashT_BandIndex_std__shared_ptrT_GeoBandSettings_const_t_t sWIGTYPE_p_QHashT_BandIndex_std__shared_ptrT_GeoBandSettings_const_t_t, String string, String string2, long l, float f, IWebClient iWebClient) {
        OsmAndCoreJNI.ResourcesManager_instantiateWeatherResourcesManager__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_QHashT_BandIndex_std__shared_ptrT_GeoBandSettings_const_t_t.getCPtr(sWIGTYPE_p_QHashT_BandIndex_std__shared_ptrT_GeoBandSettings_const_t_t), string, string2, l, f, IWebClient.getCPtr(iWebClient), iWebClient);
    }

    public void instantiateWeatherResourcesManager(SWIGTYPE_p_QHashT_BandIndex_std__shared_ptrT_GeoBandSettings_const_t_t sWIGTYPE_p_QHashT_BandIndex_std__shared_ptrT_GeoBandSettings_const_t_t, String string, String string2, long l, float f) {
        OsmAndCoreJNI.ResourcesManager_instantiateWeatherResourcesManager__SWIG_1(this.swigCPtr, this, SWIGTYPE_p_QHashT_BandIndex_std__shared_ptrT_GeoBandSettings_const_t_t.getCPtr(sWIGTYPE_p_QHashT_BandIndex_std__shared_ptrT_GeoBandSettings_const_t_t), string, string2, l, f);
    }

    public void instantiateWeatherResourcesManager(SWIGTYPE_p_QHashT_BandIndex_std__shared_ptrT_GeoBandSettings_const_t_t sWIGTYPE_p_QHashT_BandIndex_std__shared_ptrT_GeoBandSettings_const_t_t, String string, String string2, long l) {
        OsmAndCoreJNI.ResourcesManager_instantiateWeatherResourcesManager__SWIG_2(this.swigCPtr, this, SWIGTYPE_p_QHashT_BandIndex_std__shared_ptrT_GeoBandSettings_const_t_t.getCPtr(sWIGTYPE_p_QHashT_BandIndex_std__shared_ptrT_GeoBandSettings_const_t_t), string, string2, l);
    }

    public void instantiateWeatherResourcesManager(SWIGTYPE_p_QHashT_BandIndex_std__shared_ptrT_GeoBandSettings_const_t_t sWIGTYPE_p_QHashT_BandIndex_std__shared_ptrT_GeoBandSettings_const_t_t, String string, String string2) {
        OsmAndCoreJNI.ResourcesManager_instantiateWeatherResourcesManager__SWIG_3(this.swigCPtr, this, SWIGTYPE_p_QHashT_BandIndex_std__shared_ptrT_GeoBandSettings_const_t_t.getCPtr(sWIGTYPE_p_QHashT_BandIndex_std__shared_ptrT_GeoBandSettings_const_t_t), string, string2);
    }

    public static ResourceType getIndexType(SWIGTYPE_p_QStringRef sWIGTYPE_p_QStringRef) {
        return ResourceType.swigToEnum(OsmAndCoreJNI.ResourcesManager_getIndexType(SWIGTYPE_p_QStringRef.getCPtr(sWIGTYPE_p_QStringRef)));
    }

    public static class Resource {
        private transient long swigCPtr;
        private transient boolean swigCMemOwn;

        protected Resource(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(Resource resource) {
            return resource == null ? 0L : resource.swigCPtr;
        }

        protected void swigSetCMemOwn(boolean bl) {
            this.swigCMemOwn = bl;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    OsmAndCoreJNI.delete_ResourcesManager_Resource(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public String getId() {
            return OsmAndCoreJNI.ResourcesManager_Resource_id_get(this.swigCPtr, this);
        }

        public ResourceType getType() {
            return ResourceType.swigToEnum(OsmAndCoreJNI.ResourcesManager_Resource_type_get(this.swigCPtr, this));
        }

        public ResourceOrigin getOrigin() {
            return ResourceOrigin.swigToEnum(OsmAndCoreJNI.ResourcesManager_Resource_origin_get(this.swigCPtr, this));
        }

        public Metadata getMetadata() {
            long l = OsmAndCoreJNI.ResourcesManager_Resource_metadata_get(this.swigCPtr, this);
            return l == 0L ? null : new Metadata(l, true);
        }

        public static class Metadata {
            private transient long swigCPtr;
            private transient boolean swigCMemOwn;

            protected Metadata(long l, boolean bl) {
                this.swigCMemOwn = bl;
                this.swigCPtr = l;
            }

            protected static long getCPtr(Metadata metadata) {
                return metadata == null ? 0L : metadata.swigCPtr;
            }

            protected void swigSetCMemOwn(boolean bl) {
                this.swigCMemOwn = bl;
            }

            protected void finalize() {
                this.delete();
            }

            public synchronized void delete() {
                if (this.swigCPtr != 0L) {
                    if (this.swigCMemOwn) {
                        this.swigCMemOwn = false;
                        OsmAndCoreJNI.delete_ResourcesManager_Resource_Metadata(this.swigCPtr);
                    }
                    this.swigCPtr = 0L;
                }
            }

            public Metadata() {
                this(OsmAndCoreJNI.new_ResourcesManager_Resource_Metadata(), true);
            }
        }
    }

    public static class BuiltinResource
    extends Resource {
        private transient long swigCPtr;
        private transient boolean swigCMemOwnDerived;

        protected BuiltinResource(long l, boolean bl) {
            super(OsmAndCoreJNI.ResourcesManager_BuiltinResource_SWIGSmartPtrUpcast(l), true);
            this.swigCMemOwnDerived = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(BuiltinResource builtinResource) {
            return builtinResource == null ? 0L : builtinResource.swigCPtr;
        }

        @Override
        protected void swigSetCMemOwn(boolean bl) {
            this.swigCMemOwnDerived = bl;
            super.swigSetCMemOwn(bl);
        }

        @Override
        protected void finalize() {
            this.delete();
        }

        @Override
        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwnDerived) {
                    this.swigCMemOwnDerived = false;
                    OsmAndCoreJNI.delete_ResourcesManager_BuiltinResource(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
            super.delete();
        }
    }

    public static class LocalResource
    extends Resource {
        private transient long swigCPtr;
        private transient boolean swigCMemOwnDerived;

        protected LocalResource(long l, boolean bl) {
            super(OsmAndCoreJNI.ResourcesManager_LocalResource_SWIGSmartPtrUpcast(l), true);
            this.swigCMemOwnDerived = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(LocalResource localResource) {
            return localResource == null ? 0L : localResource.swigCPtr;
        }

        @Override
        protected void swigSetCMemOwn(boolean bl) {
            this.swigCMemOwnDerived = bl;
            super.swigSetCMemOwn(bl);
        }

        @Override
        protected void finalize() {
            this.delete();
        }

        @Override
        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwnDerived) {
                    this.swigCMemOwnDerived = false;
                    OsmAndCoreJNI.delete_ResourcesManager_LocalResource(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
            super.delete();
        }

        public String getLocalPath() {
            return OsmAndCoreJNI.ResourcesManager_LocalResource_localPath_get(this.swigCPtr, this);
        }

        public BigInteger getSize() {
            return OsmAndCoreJNI.ResourcesManager_LocalResource_size_get(this.swigCPtr, this);
        }
    }

    public static class ResourceInRepository
    extends Resource {
        private transient long swigCPtr;
        private transient boolean swigCMemOwnDerived;

        protected ResourceInRepository(long l, boolean bl) {
            super(OsmAndCoreJNI.ResourcesManager_ResourceInRepository_SWIGSmartPtrUpcast(l), true);
            this.swigCMemOwnDerived = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(ResourceInRepository resourceInRepository) {
            return resourceInRepository == null ? 0L : resourceInRepository.swigCPtr;
        }

        @Override
        protected void swigSetCMemOwn(boolean bl) {
            this.swigCMemOwnDerived = bl;
            super.swigSetCMemOwn(bl);
        }

        @Override
        protected void finalize() {
            this.delete();
        }

        @Override
        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwnDerived) {
                    this.swigCMemOwnDerived = false;
                    OsmAndCoreJNI.delete_ResourcesManager_ResourceInRepository(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
            super.delete();
        }

        public SWIGTYPE_p_QUrl getUrl() {
            return new SWIGTYPE_p_QUrl(OsmAndCoreJNI.ResourcesManager_ResourceInRepository_url_get(this.swigCPtr, this), true);
        }

        public BigInteger getSize() {
            return OsmAndCoreJNI.ResourcesManager_ResourceInRepository_size_get(this.swigCPtr, this);
        }

        public BigInteger getTimestamp() {
            return OsmAndCoreJNI.ResourcesManager_ResourceInRepository_timestamp_get(this.swigCPtr, this);
        }

        public BigInteger getPackageSize() {
            return OsmAndCoreJNI.ResourcesManager_ResourceInRepository_packageSize_get(this.swigCPtr, this);
        }

        public boolean getFree() {
            return OsmAndCoreJNI.ResourcesManager_ResourceInRepository_free_get(this.swigCPtr, this);
        }

        public boolean getHidden() {
            return OsmAndCoreJNI.ResourcesManager_ResourceInRepository_hidden_get(this.swigCPtr, this);
        }

        public String getMessage() {
            return OsmAndCoreJNI.ResourcesManager_ResourceInRepository_message_get(this.swigCPtr, this);
        }
    }

    public static class InstalledResource
    extends LocalResource {
        private transient long swigCPtr;
        private transient boolean swigCMemOwnDerived;

        protected InstalledResource(long l, boolean bl) {
            super(OsmAndCoreJNI.ResourcesManager_InstalledResource_SWIGSmartPtrUpcast(l), true);
            this.swigCMemOwnDerived = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(InstalledResource installedResource) {
            return installedResource == null ? 0L : installedResource.swigCPtr;
        }

        @Override
        protected void swigSetCMemOwn(boolean bl) {
            this.swigCMemOwnDerived = bl;
            super.swigSetCMemOwn(bl);
        }

        @Override
        protected void finalize() {
            this.delete();
        }

        @Override
        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwnDerived) {
                    this.swigCMemOwnDerived = false;
                    OsmAndCoreJNI.delete_ResourcesManager_InstalledResource(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
            super.delete();
        }

        public BigInteger getTimestamp() {
            return OsmAndCoreJNI.ResourcesManager_InstalledResource_timestamp_get(this.swigCPtr, this);
        }
    }

    public static enum ResourceType {
        Unknown(OsmAndCoreJNI.ResourcesManager_ResourceType_Unknown_get()),
        MapRegion,
        RoadMapRegion,
        SrtmMapRegion,
        DepthContourRegion,
        DepthMapRegion,
        WikiMapRegion,
        HillshadeRegion,
        SlopeRegion,
        HeightmapRegionLegacy,
        GeoTiffRegion,
        LiveUpdateRegion,
        VoicePack,
        MapStyle,
        MapStylesPresets,
        OnlineTileSources,
        GpxFile,
        SqliteFile,
        WeatherForecast,
        Travel;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static ResourceType swigToEnum(int n) {
            ResourceType[] resourceTypeArray = (ResourceType[])ResourceType.class.getEnumConstants();
            if (n < resourceTypeArray.length && n >= 0 && resourceTypeArray[n].swigValue == n) {
                return resourceTypeArray[n];
            }
            for (ResourceType resourceType : resourceTypeArray) {
                if (resourceType.swigValue != n) continue;
                return resourceType;
            }
            throw new IllegalArgumentException("No enum " + String.valueOf(ResourceType.class) + " with value " + n);
        }

        private ResourceType() {
            this.swigValue = SwigNext.next++;
        }

        private ResourceType(int n2) {
            this.swigValue = n2;
            SwigNext.next = n2 + 1;
        }

        private ResourceType(ResourceType resourceType) {
            this.swigValue = resourceType.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum ResourceOrigin {
        Builtin,
        Installed,
        Repository,
        Unmanaged;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static ResourceOrigin swigToEnum(int n) {
            ResourceOrigin[] resourceOriginArray = (ResourceOrigin[])ResourceOrigin.class.getEnumConstants();
            if (n < resourceOriginArray.length && n >= 0 && resourceOriginArray[n].swigValue == n) {
                return resourceOriginArray[n];
            }
            for (ResourceOrigin resourceOrigin : resourceOriginArray) {
                if (resourceOrigin.swigValue != n) continue;
                return resourceOrigin;
            }
            throw new IllegalArgumentException("No enum " + String.valueOf(ResourceOrigin.class) + " with value " + n);
        }

        private ResourceOrigin() {
            this.swigValue = SwigNext.next++;
        }

        private ResourceOrigin(int n2) {
            this.swigValue = n2;
            SwigNext.next = n2 + 1;
        }

        private ResourceOrigin(ResourceOrigin resourceOrigin) {
            this.swigValue = resourceOrigin.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static class IRepositoryUpdated {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        protected IRepositoryUpdated(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(IRepositoryUpdated iRepositoryUpdated) {
            return iRepositoryUpdated == null ? 0L : iRepositoryUpdated.swigCPtr;
        }

        protected static long swigRelease(IRepositoryUpdated iRepositoryUpdated) {
            long l = 0L;
            if (iRepositoryUpdated != null) {
                if (!iRepositoryUpdated.swigCMemOwn) {
                    throw new RuntimeException("Cannot release ownership as memory is not owned");
                }
                l = iRepositoryUpdated.swigCPtr;
                iRepositoryUpdated.swigCMemOwn = false;
                iRepositoryUpdated.delete();
            }
            return l;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    OsmAndCoreJNI.delete_ResourcesManager_IRepositoryUpdated(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        protected void swigDirectorDisconnect() {
            this.swigCMemOwn = false;
            this.delete();
        }

        public void swigReleaseOwnership() {
            this.swigCMemOwn = false;
            OsmAndCoreJNI.ResourcesManager_IRepositoryUpdated_change_ownership(this, this.swigCPtr, false);
        }

        public void swigTakeOwnership() {
            this.swigCMemOwn = true;
            OsmAndCoreJNI.ResourcesManager_IRepositoryUpdated_change_ownership(this, this.swigCPtr, true);
        }

        public IRepositoryUpdated() {
            this(OsmAndCoreJNI.new_ResourcesManager_IRepositoryUpdated(), true);
            OsmAndCoreJNI.ResourcesManager_IRepositoryUpdated_director_connect(this, this.swigCPtr, true, true);
        }

        public void method(ResourcesManager resourcesManager) {
            OsmAndCoreJNI.ResourcesManager_IRepositoryUpdated_method(this.swigCPtr, this, ResourcesManager.getCPtr(resourcesManager), resourcesManager);
        }

        public boolean attachTo(ResourcesManagerRepositoryUpdatedObservable resourcesManagerRepositoryUpdatedObservable, long l) {
            return OsmAndCoreJNI.ResourcesManager_IRepositoryUpdated_attachTo(this.swigCPtr, this, ResourcesManagerRepositoryUpdatedObservable.getCPtr(resourcesManagerRepositoryUpdatedObservable), resourcesManagerRepositoryUpdatedObservable, l);
        }

        public SWIGTYPE_p_OsmAnd__ResourcesManager__RepositoryUpdated getBinding() {
            return new SWIGTYPE_p_OsmAnd__ResourcesManager__RepositoryUpdated(OsmAndCoreJNI.ResourcesManager_IRepositoryUpdated_getBinding(this.swigCPtr, this), true);
        }
    }

    public static class ILocalResourcesChanged {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        protected ILocalResourcesChanged(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(ILocalResourcesChanged iLocalResourcesChanged) {
            return iLocalResourcesChanged == null ? 0L : iLocalResourcesChanged.swigCPtr;
        }

        protected static long swigRelease(ILocalResourcesChanged iLocalResourcesChanged) {
            long l = 0L;
            if (iLocalResourcesChanged != null) {
                if (!iLocalResourcesChanged.swigCMemOwn) {
                    throw new RuntimeException("Cannot release ownership as memory is not owned");
                }
                l = iLocalResourcesChanged.swigCPtr;
                iLocalResourcesChanged.swigCMemOwn = false;
                iLocalResourcesChanged.delete();
            }
            return l;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    OsmAndCoreJNI.delete_ResourcesManager_ILocalResourcesChanged(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        protected void swigDirectorDisconnect() {
            this.swigCMemOwn = false;
            this.delete();
        }

        public void swigReleaseOwnership() {
            this.swigCMemOwn = false;
            OsmAndCoreJNI.ResourcesManager_ILocalResourcesChanged_change_ownership(this, this.swigCPtr, false);
        }

        public void swigTakeOwnership() {
            this.swigCMemOwn = true;
            OsmAndCoreJNI.ResourcesManager_ILocalResourcesChanged_change_ownership(this, this.swigCPtr, true);
        }

        public ILocalResourcesChanged() {
            this(OsmAndCoreJNI.new_ResourcesManager_ILocalResourcesChanged(), true);
            OsmAndCoreJNI.ResourcesManager_ILocalResourcesChanged_director_connect(this, this.swigCPtr, true, true);
        }

        public void method(ResourcesManager resourcesManager, QStringList qStringList, QStringList qStringList2, QStringList qStringList3) {
            OsmAndCoreJNI.ResourcesManager_ILocalResourcesChanged_method(this.swigCPtr, this, ResourcesManager.getCPtr(resourcesManager), resourcesManager, QStringList.getCPtr(qStringList), qStringList, QStringList.getCPtr(qStringList2), qStringList2, QStringList.getCPtr(qStringList3), qStringList3);
        }

        public boolean attachTo(ResourcesManagerLocalResourcesChangedObservable resourcesManagerLocalResourcesChangedObservable, long l) {
            return OsmAndCoreJNI.ResourcesManager_ILocalResourcesChanged_attachTo(this.swigCPtr, this, ResourcesManagerLocalResourcesChangedObservable.getCPtr(resourcesManagerLocalResourcesChangedObservable), resourcesManagerLocalResourcesChangedObservable, l);
        }

        public SWIGTYPE_p_OsmAnd__ResourcesManager__LocalResourcesChanged getBinding() {
            return new SWIGTYPE_p_OsmAnd__ResourcesManager__LocalResourcesChanged(OsmAndCoreJNI.ResourcesManager_ILocalResourcesChanged_getBinding(this.swigCPtr, this), true);
        }
    }

    public static class OnlineTileSourcesMetadata
    extends Resource.Metadata {
        private transient long swigCPtr;
        private transient boolean swigCMemOwnDerived;

        protected OnlineTileSourcesMetadata(long l, boolean bl) {
            super(OsmAndCoreJNI.ResourcesManager_OnlineTileSourcesMetadata_SWIGSmartPtrUpcast(l), true);
            this.swigCMemOwnDerived = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(OnlineTileSourcesMetadata onlineTileSourcesMetadata) {
            return onlineTileSourcesMetadata == null ? 0L : onlineTileSourcesMetadata.swigCPtr;
        }

        @Override
        protected void swigSetCMemOwn(boolean bl) {
            this.swigCMemOwnDerived = bl;
            super.swigSetCMemOwn(bl);
        }

        @Override
        protected void finalize() {
            this.delete();
        }

        @Override
        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwnDerived) {
                    this.swigCMemOwnDerived = false;
                    OsmAndCoreJNI.delete_ResourcesManager_OnlineTileSourcesMetadata(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
            super.delete();
        }

        public OnlineTileSourcesMetadata(OnlineTileSources onlineTileSources) {
            this(OsmAndCoreJNI.new_ResourcesManager_OnlineTileSourcesMetadata(OnlineTileSources.getCPtr(onlineTileSources), onlineTileSources), true);
        }

        public OnlineTileSources getSources() {
            long l = OsmAndCoreJNI.ResourcesManager_OnlineTileSourcesMetadata_sources_get(this.swigCPtr, this);
            return l == 0L ? null : new OnlineTileSources(l, true);
        }
    }

    public static class MapStyleMetadata
    extends Resource.Metadata {
        private transient long swigCPtr;
        private transient boolean swigCMemOwnDerived;

        protected MapStyleMetadata(long l, boolean bl) {
            super(OsmAndCoreJNI.ResourcesManager_MapStyleMetadata_SWIGSmartPtrUpcast(l), true);
            this.swigCMemOwnDerived = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(MapStyleMetadata mapStyleMetadata) {
            return mapStyleMetadata == null ? 0L : mapStyleMetadata.swigCPtr;
        }

        @Override
        protected void swigSetCMemOwn(boolean bl) {
            this.swigCMemOwnDerived = bl;
            super.swigSetCMemOwn(bl);
        }

        @Override
        protected void finalize() {
            this.delete();
        }

        @Override
        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwnDerived) {
                    this.swigCMemOwnDerived = false;
                    OsmAndCoreJNI.delete_ResourcesManager_MapStyleMetadata(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
            super.delete();
        }

        public MapStyleMetadata(UnresolvedMapStyle unresolvedMapStyle) {
            this(OsmAndCoreJNI.new_ResourcesManager_MapStyleMetadata(UnresolvedMapStyle.getCPtr(unresolvedMapStyle), unresolvedMapStyle), true);
        }

        public UnresolvedMapStyle getMapStyle() {
            long l = OsmAndCoreJNI.ResourcesManager_MapStyleMetadata_mapStyle_get(this.swigCPtr, this);
            return l == 0L ? null : new UnresolvedMapStyle(l, true);
        }
    }

    public static class ObfMetadata
    extends Resource.Metadata {
        private transient long swigCPtr;
        private transient boolean swigCMemOwnDerived;

        protected ObfMetadata(long l, boolean bl) {
            super(OsmAndCoreJNI.ResourcesManager_ObfMetadata_SWIGSmartPtrUpcast(l), true);
            this.swigCMemOwnDerived = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(ObfMetadata obfMetadata) {
            return obfMetadata == null ? 0L : obfMetadata.swigCPtr;
        }

        @Override
        protected void swigSetCMemOwn(boolean bl) {
            this.swigCMemOwnDerived = bl;
            super.swigSetCMemOwn(bl);
        }

        @Override
        protected void finalize() {
            this.delete();
        }

        @Override
        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwnDerived) {
                    this.swigCMemOwnDerived = false;
                    OsmAndCoreJNI.delete_ResourcesManager_ObfMetadata(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
            super.delete();
        }

        public ObfMetadata(ObfFile obfFile) {
            this(OsmAndCoreJNI.new_ResourcesManager_ObfMetadata(ObfFile.getCPtr(obfFile), obfFile), true);
        }

        public ObfFile getObfFile() {
            long l = OsmAndCoreJNI.ResourcesManager_ObfMetadata_obfFile_get(this.swigCPtr, this);
            return l == 0L ? null : new ObfFile(l, true);
        }
    }

    public static class UnmanagedResource
    extends LocalResource {
        private transient long swigCPtr;
        private transient boolean swigCMemOwnDerived;

        protected UnmanagedResource(long l, boolean bl) {
            super(OsmAndCoreJNI.ResourcesManager_UnmanagedResource_SWIGSmartPtrUpcast(l), true);
            this.swigCMemOwnDerived = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(UnmanagedResource unmanagedResource) {
            return unmanagedResource == null ? 0L : unmanagedResource.swigCPtr;
        }

        @Override
        protected void swigSetCMemOwn(boolean bl) {
            this.swigCMemOwnDerived = bl;
            super.swigSetCMemOwn(bl);
        }

        @Override
        protected void finalize() {
            this.delete();
        }

        @Override
        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwnDerived) {
                    this.swigCMemOwnDerived = false;
                    OsmAndCoreJNI.delete_ResourcesManager_UnmanagedResource(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
            super.delete();
        }

        public String getName() {
            return OsmAndCoreJNI.ResourcesManager_UnmanagedResource_name_get(this.swigCPtr, this);
        }
    }
}

