/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StringArrayIO {
    public static String[] readArray(InputStream input) throws IOException {
        DataInputStream dataInput = new DataInputStream(input);
        int length = dataInput.readInt();
        String[] array = new String[length];
        for (int i = 0; i < length; ++i) {
            array[i] = dataInput.readUTF();
        }
        return array;
    }

    public static void writeArray(OutputStream output, String[] array) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(output);
        int length = array.length;
        dataOutput.writeInt(length);
        for (int i = 0; i < array.length; ++i) {
            dataOutput.writeUTF(array[i]);
        }
    }

    public static String[][] readArray2D(InputStream input) throws IOException {
        DataInputStream dataInput = new DataInputStream(input);
        int length = dataInput.readInt();
        String[][] array = new String[length][];
        for (int i = 0; i < length; ++i) {
            array[i] = StringArrayIO.readArray(dataInput);
        }
        return array;
    }

    public static void writeArray2D(OutputStream output, String[][] array) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(output);
        int length = array.length;
        dataOutput.writeInt(length);
        for (int i = 0; i < length; ++i) {
            StringArrayIO.writeArray(dataOutput, array[i]);
        }
    }

    public static String[][] readSparseArray2D(InputStream input) throws IOException {
        int index;
        DataInputStream dataInput = new DataInputStream(input);
        int length = dataInput.readInt();
        String[][] array = new String[length][];
        while ((index = dataInput.readInt()) >= 0) {
            array[index] = StringArrayIO.readArray(dataInput);
        }
        return array;
    }

    public static void writeSparseArray2D(OutputStream output, String[][] array) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(output);
        int length = array.length;
        dataOutput.writeInt(length);
        for (int i = 0; i < length; ++i) {
            String[] inner = array[i];
            if (inner == null) continue;
            dataOutput.writeInt(i);
            StringArrayIO.writeArray(dataOutput, inner);
        }
        dataOutput.writeInt(-1);
    }
}

