/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.diff;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongLongMap;
import gnu.trove.map.hash.TLongLongHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapPoiReaderAdapter;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.BinaryMapTransportReaderAdapter;
import net.osmand.binary.MapZooms;
import net.osmand.binary.OsmandOdb;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.Amenity;
import net.osmand.data.TransportRoute;
import net.osmand.data.TransportStop;
import net.osmand.obf.preparation.AbstractIndexPartCreator;
import net.osmand.obf.preparation.BinaryFileReference;
import net.osmand.obf.preparation.BinaryMapIndexWriter;
import net.osmand.obf.preparation.IndexCreator;
import net.osmand.obf.preparation.IndexCreatorSettings;
import net.osmand.obf.preparation.IndexPoiCreator;
import net.osmand.obf.preparation.IndexRouteCreator;
import net.osmand.obf.preparation.IndexTransportCreator;
import net.osmand.obf.preparation.IndexVectorMapCreator;
import net.osmand.obf.preparation.TransportTags;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import rtree.LeafElement;
import rtree.Node;
import rtree.RTree;
import rtree.RTreeException;
import rtree.Rect;

public class ObfFileInMemory {
    private static final int ZOOM_LEVEL_POI = 15;
    private static final int ZOOM_LEVEL_ROUTING = 15;
    private double lattop = 85.0;
    private double latbottom = -85.0;
    private double lonleft = -179.9;
    private double lonright = 179.9;
    private static final Log LOG = PlatformUtil.getLog(ObfFileInMemory.class);
    private Map<MapZooms.MapZoomPair, TLongObjectHashMap<BinaryMapDataObject>> mapObjects = new LinkedHashMap<MapZooms.MapZoomPair, TLongObjectHashMap<BinaryMapDataObject>>();
    private TLongObjectHashMap<RouteDataObject> routeObjects = new TLongObjectHashMap();
    private long timestamp = 0L;
    private BinaryMapIndexReader.OsmAndOwner osmAndOwner;
    private BinaryMapIndexReader.MapIndex mapIndex = new BinaryMapIndexReader.MapIndex();
    private BinaryMapRouteReaderAdapter.RouteRegion routeIndex = new BinaryMapRouteReaderAdapter.RouteRegion();
    private TLongObjectHashMap<Map<String, Amenity>> poiObjects = new TLongObjectHashMap();
    private TLongObjectHashMap<TransportStop> transportStops = new TLongObjectHashMap();
    private TLongObjectHashMap<TransportRoute> transportRoutes = new TLongObjectHashMap();

    public TLongObjectHashMap<BinaryMapDataObject> get(MapZooms.MapZoomPair zoom) {
        if (!this.mapObjects.containsKey(zoom)) {
            this.mapObjects.put(zoom, (TLongObjectHashMap<BinaryMapDataObject>)new TLongObjectHashMap());
        }
        return this.mapObjects.get(zoom);
    }

    public Collection<MapZooms.MapZoomPair> getZooms() {
        return this.mapObjects.keySet();
    }

    public TLongObjectHashMap<RouteDataObject> getRoutingData() {
        return this.routeObjects;
    }

    public BinaryMapIndexReader.MapIndex getMapIndex() {
        return this.mapIndex;
    }

    public BinaryMapRouteReaderAdapter.RouteRegion getRouteIndex() {
        return this.routeIndex;
    }

    public TLongObjectHashMap<Map<String, Amenity>> getPoiObjects() {
        return this.poiObjects;
    }

    public TLongObjectHashMap<TransportStop> getTransportStops() {
        return this.transportStops;
    }

    public TLongObjectHashMap<TransportRoute> getTransportRoutes() {
        return this.transportRoutes;
    }

    public void setTransportRoutes(TLongObjectHashMap<TransportRoute> transportRoutes) {
        this.transportRoutes = transportRoutes;
    }

    public void putMapObjects(MapZooms.MapZoomPair pair, Collection<BinaryMapDataObject> objects, boolean override) {
        TLongObjectHashMap<BinaryMapDataObject> res = this.get(pair);
        for (BinaryMapDataObject o : objects) {
            o = this.mapIndex.adoptMapObject(o);
            if (override) {
                res.put(o.getId(), (Object)o);
                continue;
            }
            if (res.containsKey(o.getId())) continue;
            res.put(o.getId(), (Object)o);
        }
    }

    public void writeFile(File targetFile, boolean doNotSimplifyObjects) throws IOException, RTreeException, SQLException {
        String name;
        boolean gzip = targetFile.getName().endsWith(".gz");
        File nonGzip = targetFile;
        if (gzip) {
            nonGzip = new File(targetFile.getParentFile(), targetFile.getName().substring(0, targetFile.getName().length() - 3));
        }
        final RandomAccessFile raf = new RandomAccessFile(nonGzip, "rw");
        CodedOutputStream ous = CodedOutputStream.newInstance((OutputStream)new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                raf.write(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                raf.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                raf.write(b, off, len);
            }
        });
        this.timestamp = this.timestamp == 0L ? System.currentTimeMillis() : this.timestamp;
        int version = 2;
        ous.writeInt32(1, version);
        ous.writeInt64(18, this.timestamp);
        BinaryMapIndexWriter writer = new BinaryMapIndexWriter(raf, ous);
        String defName = targetFile.getName().substring(0, targetFile.getName().indexOf(46));
        if (this.mapObjects.size() > 0) {
            name = this.mapIndex.getName();
            if (Algorithms.isEmpty((CharSequence)name)) {
                name = defName;
            }
            writer.startWriteMapIndex(Algorithms.capitalizeFirstLetter((String)name));
            writer.writeMapEncodingRules((TIntObjectMap<BinaryMapIndexReader.TagValuePair>)this.mapIndex.decodingRules);
            for (Map.Entry<MapZooms.MapZoomPair, TLongObjectHashMap<BinaryMapDataObject>> n : this.mapObjects.entrySet()) {
                this.writeMapData(writer, n.getKey(), n.getValue(), targetFile, doNotSimplifyObjects);
            }
            writer.endWriteMapIndex();
        }
        if (this.routeObjects.size() > 0) {
            name = this.mapIndex.getName();
            if (Algorithms.isEmpty((CharSequence)name)) {
                name = defName;
            }
            writer.startWriteRouteIndex(name);
            writer.writeRouteRawEncodingRules(this.routeIndex.routeEncodingRules);
            this.writeRouteData(writer, this.routeObjects, targetFile);
            writer.endWriteRouteIndex();
        }
        if (this.poiObjects.size() > 0) {
            name = "";
            if (Algorithms.isEmpty((CharSequence)name)) {
                name = defName;
            }
            MapRenderingTypesEncoder renderingTypes = new MapRenderingTypesEncoder(null, name);
            IndexCreatorSettings settings = new IndexCreatorSettings();
            settings.indexPOI = true;
            IndexPoiCreator indexPoiCreator = new IndexPoiCreator(settings, renderingTypes);
            File poiFile = new File(targetFile.getParentFile(), IndexCreator.getPoiFileName(name));
            indexPoiCreator.createDatabaseStructure(poiFile);
            for (Object mp : this.poiObjects.valueCollection()) {
                for (Amenity a : mp.values()) {
                    indexPoiCreator.insertAmenityIntoPoi(a);
                }
            }
            indexPoiCreator.writeBinaryPoiIndex(null, writer, name, null);
            indexPoiCreator.commitAndClosePoiFile(System.currentTimeMillis());
            indexPoiCreator.removePoiFile();
        }
        if (this.transportStops.size() > 0) {
            long[] routesIds;
            name = this.mapIndex.getName();
            if (Algorithms.isEmpty((CharSequence)name)) {
                name = defName;
            }
            IndexCreatorSettings settings = new IndexCreatorSettings();
            settings.indexTransport = true;
            IndexTransportCreator indexCreator = new IndexTransportCreator(settings);
            Map<String, Integer> stringTable = indexCreator.createStringTableForTransport();
            LinkedHashMap<Long, Long> newRoutesIds = new LinkedHashMap<Long, Long>();
            writer.startWriteTransportIndex(Algorithms.capitalizeFirstLetter((String)name));
            TLongObjectHashMap transportRoutes = new TLongObjectHashMap();
            for (TransportStop transportStop : this.transportStops.valueCollection()) {
                routesIds = transportStop.getRoutesIds();
                if (routesIds == null) continue;
                for (long routeId : routesIds) {
                    TransportRoute route = (TransportRoute)this.transportRoutes.get(routeId);
                    if (route == null) continue;
                    transportRoutes.put(routeId, (Object)route);
                }
            }
            if (transportRoutes.size() > 0) {
                writer.startWriteTransportRoutes();
                ByteArrayOutputStream ows = new ByteArrayOutputStream();
                ArrayList<byte[]> directGeometry = new ArrayList<byte[]>();
                TransportTags transportTags = new TransportTags();
                Object object = transportRoutes.valueCollection().iterator();
                while (object.hasNext()) {
                    TransportRoute route = (TransportRoute)object.next();
                    directGeometry.clear();
                    List ways = route.getForwardWays();
                    if (ways != null && ways.size() > 0) {
                        for (Way w : ways) {
                            if (w.getNodes().size() <= 0) continue;
                            indexCreator.writeWay(ows, w);
                            directGeometry.add(ows.toByteArray());
                        }
                    }
                    transportTags.registerTagValues(route.getId(), route.getTags());
                    writer.writeTransportRoute(route.getId(), route.getName(), route.getEnName(false), route.getRef(), route.getOperator(), route.getType(), route.getDistance(), route.getColor(), route.getForwardStops(), directGeometry, stringTable, newRoutesIds, route.getSchedule(), transportTags);
                }
                writer.endWriteTransportRoutes();
            }
            for (TransportStop stop : this.transportStops.valueCollection()) {
                routesIds = stop.getRoutesIds();
                long[] nrefs = null;
                if (routesIds != null) {
                    nrefs = new long[routesIds.length];
                    for (int i = 0; i < routesIds.length; ++i) {
                        Long vl = (Long)newRoutesIds.get(routesIds[i]);
                        if (vl == null) {
                            throw new IllegalStateException(String.format("Transport stop (%s) has reference to route %d but it wasn't found in the list", stop, routesIds[i] / 2L));
                        }
                        nrefs[i] = vl.intValue();
                    }
                }
                stop.setReferencesToRoutes(nrefs);
            }
            this.writeTransportStops(indexCreator, writer, this.transportStops, stringTable, targetFile);
            writer.writeTransportStringTable(stringTable);
            writer.endWriteTransportIndex();
        }
        if (this.osmAndOwner != null) {
            OsmandOdb.OsmAndOwner.Builder b = OsmandOdb.OsmAndOwner.newBuilder();
            b.setName(this.osmAndOwner.getName());
            if (!this.osmAndOwner.getResource().isEmpty()) {
                b.setResource(this.osmAndOwner.getResource());
            }
            if (!this.osmAndOwner.getDescription().isEmpty()) {
                b.setDescription(this.osmAndOwner.getDescription());
            }
            if (!this.osmAndOwner.getPluginid().isEmpty()) {
                b.setPluginid(this.osmAndOwner.getPluginid());
            }
            OsmandOdb.OsmAndOwner m = b.build();
            ous.writeMessage(33, (MessageLite)m);
        }
        ous.writeInt32(32, version);
        ous.flush();
        raf.close();
        if (gzip) {
            nonGzip.setLastModified(this.timestamp);
            FileInputStream fis = new FileInputStream(nonGzip);
            GZIPOutputStream gzout = new GZIPOutputStream(new FileOutputStream(targetFile));
            Algorithms.streamCopy((InputStream)fis, (OutputStream)gzout);
            fis.close();
            gzout.close();
            nonGzip.delete();
        }
        targetFile.setLastModified(this.timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTransportStops(IndexTransportCreator indexCreator, BinaryMapIndexWriter writer, TLongObjectHashMap<TransportStop> transportStops, Map<String, Integer> stringTable, File fileToWrite) throws IOException, RTreeException, SQLException {
        File nonpackRtree = new File(fileToWrite.getParentFile(), "nonpacktrans." + fileToWrite.getName() + ".rtree");
        File packRtree = new File(fileToWrite.getParentFile(), "packtrans." + fileToWrite.getName() + ".rtree");
        RTree rtree = null;
        try {
            long rootIndex;
            rtree = new RTree(nonpackRtree.getAbsolutePath());
            for (TransportStop s : transportStops.valueCollection()) {
                int x = (int)MapUtils.getTileNumberX((float)24.0f, (double)s.getLocation().getLongitude());
                int y = (int)MapUtils.getTileNumberY((float)24.0f, (double)s.getLocation().getLatitude());
                try {
                    rtree.insert(new LeafElement(new Rect(x, y, x, y), s.getId()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            Node root = (rtree = AbstractIndexPartCreator.packRtreeFile(rtree, nonpackRtree.getAbsolutePath(), packRtree.getAbsolutePath())).getReadNode(rootIndex = rtree.getFileHdr().getRootIndex());
            Rect rootBounds = IndexVectorMapCreator.calcBounds(root);
            if (rootBounds != null) {
                writer.startTransportTreeElement(rootBounds.getMinX(), rootBounds.getMaxX(), rootBounds.getMinY(), rootBounds.getMaxY());
                indexCreator.writeBinaryTransportTree(root, rtree, writer, transportStops, stringTable);
                writer.endWriteTransportTreeElement();
            }
        }
        finally {
            if (rtree != null) {
                RandomAccessFile file = rtree.getFileHdr().getFile();
                file.close();
            }
            nonpackRtree.delete();
            packRtree.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRouteData(BinaryMapIndexWriter writer, TLongObjectHashMap<RouteDataObject> routeObjs, File fileToWrite) throws IOException, RTreeException, SQLException {
        File nonpackRtree = new File(fileToWrite.getParentFile(), "nonpackroute." + fileToWrite.getName() + ".rtree");
        File packRtree = new File(fileToWrite.getParentFile(), "packroute." + fileToWrite.getName() + ".rtree");
        RTree rtree = null;
        try {
            rtree = new RTree(nonpackRtree.getAbsolutePath());
            for (long key : routeObjs.keys()) {
                RouteDataObject obj = (RouteDataObject)routeObjs.get(key);
                int minX = obj.getPoint31XTile(0);
                int maxX = obj.getPoint31XTile(0);
                int maxY = obj.getPoint31YTile(0);
                int minY = obj.getPoint31YTile(0);
                for (int i = 1; i < obj.getPointsLength(); ++i) {
                    minX = Math.min(minX, obj.getPoint31XTile(i));
                    minY = Math.min(minY, obj.getPoint31YTile(i));
                    maxX = Math.max(maxX, obj.getPoint31XTile(i));
                    maxY = Math.max(maxY, obj.getPoint31YTile(i));
                }
                try {
                    rtree.insert(new LeafElement(new Rect(minX, minY, maxX, maxY), obj.getId()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            rtree = AbstractIndexPartCreator.packRtreeFile(rtree, nonpackRtree.getAbsolutePath(), packRtree.getAbsolutePath());
            TLongObjectHashMap treeHeader = new TLongObjectHashMap();
            long rootIndex = rtree.getFileHdr().getRootIndex();
            Node root = rtree.getReadNode(rootIndex);
            Rect rootBounds = IndexVectorMapCreator.calcBounds(root);
            if (rootBounds != null) {
                IndexRouteCreator.writeBinaryRouteTree(root, rootBounds, rtree, writer, (TLongObjectHashMap<BinaryFileReference>)treeHeader, false);
                IndexRouteCreator.RouteWriteContext wc = new IndexRouteCreator.RouteWriteContext(null, (TLongObjectHashMap<BinaryFileReference>)treeHeader, null, routeObjs);
                IndexRouteCreator.writeBinaryMapBlock(root, rootBounds, rtree, writer, wc, false);
            }
        }
        finally {
            if (rtree != null) {
                RandomAccessFile file = rtree.getFileHdr().getFile();
                file.close();
            }
            nonpackRtree.delete();
            packRtree.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMapData(BinaryMapIndexWriter writer, MapZooms.MapZoomPair mapZoomPair, TLongObjectHashMap<BinaryMapDataObject> objects, File fileToWrite, boolean doNotSimplify) throws IOException, RTreeException {
        File nonpackRtree = new File(fileToWrite.getParentFile(), "nonpack" + mapZoomPair.getMinZoom() + "." + fileToWrite.getName() + ".rtree");
        File packRtree = new File(fileToWrite.getParentFile(), "pack" + mapZoomPair.getMinZoom() + "." + fileToWrite.getName() + ".rtree");
        RTree rtree = null;
        try {
            rtree = new RTree(nonpackRtree.getAbsolutePath());
            for (long key : objects.keys()) {
                BinaryMapDataObject obj = (BinaryMapDataObject)objects.get(key);
                int minX = obj.getPoint31XTile(0);
                int maxX = obj.getPoint31XTile(0);
                int maxY = obj.getPoint31YTile(0);
                int minY = obj.getPoint31YTile(0);
                for (int i = 1; i < obj.getPointsLength(); ++i) {
                    minX = Math.min(minX, obj.getPoint31XTile(i));
                    minY = Math.min(minY, obj.getPoint31YTile(i));
                    maxX = Math.max(maxX, obj.getPoint31XTile(i));
                    maxY = Math.max(maxY, obj.getPoint31YTile(i));
                }
                try {
                    rtree.insert(new LeafElement(new Rect(minX, minY, maxX, maxY), obj.getId()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            rtree = AbstractIndexPartCreator.packRtreeFile(rtree, nonpackRtree.getAbsolutePath(), packRtree.getAbsolutePath());
            TLongObjectHashMap treeHeader = new TLongObjectHashMap();
            long rootIndex = rtree.getFileHdr().getRootIndex();
            Node root = rtree.getReadNode(rootIndex);
            Rect rootBounds = IndexVectorMapCreator.calcBounds(root);
            if (rootBounds != null) {
                writer.startWriteMapLevelIndex(mapZoomPair.getMinZoom(), mapZoomPair.getMaxZoom(), rootBounds.getMinX(), rootBounds.getMaxX(), rootBounds.getMinY(), rootBounds.getMaxY());
                IndexVectorMapCreator.writeBinaryMapTree(root, rootBounds, rtree, writer, (TLongObjectHashMap<BinaryFileReference>)treeHeader);
                IndexVectorMapCreator.writeBinaryMapBlock(root, rootBounds, rtree, writer, (TLongObjectHashMap<BinaryFileReference>)treeHeader, objects, mapZoomPair, doNotSimplify);
                writer.endWriteMapLevelIndex();
            }
        }
        finally {
            if (rtree != null) {
                RandomAccessFile file = rtree.getFileHdr().getFile();
                file.close();
            }
            nonpackRtree.delete();
            packRtree.delete();
        }
    }

    public void updateTimestamp(long dateCreated) {
        this.timestamp = Math.max(this.timestamp, dateCreated);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void readObfFiles(List<File> files) throws IOException {
        for (int i = 0; i < files.size(); ++i) {
            File inputFile;
            File nonGzip = inputFile = files.get(i);
            boolean gzip = false;
            if (inputFile == null) continue;
            File parentFile = inputFile.getParentFile();
            LOG.info((Object)String.format("Reading %s / %s ", parentFile == null ? "" : parentFile.getName(), inputFile.getName()));
            if (inputFile.getName().endsWith(".gz")) {
                nonGzip = new File(inputFile.getParentFile(), inputFile.getName().substring(0, inputFile.getName().length() - 3));
                GZIPInputStream gzin = new GZIPInputStream(new FileInputStream(inputFile));
                FileOutputStream fous = new FileOutputStream(nonGzip);
                Algorithms.streamCopy((InputStream)gzin, (OutputStream)fous);
                fous.close();
                gzin.close();
                gzip = true;
            }
            RandomAccessFile raf = new RandomAccessFile(nonGzip, "r");
            BinaryMapIndexReader indexReader = new BinaryMapIndexReader(raf, nonGzip);
            for (BinaryIndexPart p : indexReader.getIndexes()) {
                if (p instanceof BinaryMapIndexReader.MapIndex) {
                    BinaryMapIndexReader.MapIndex mi = (BinaryMapIndexReader.MapIndex)p;
                    for (BinaryMapIndexReader.MapRoot mr : mi.getRoots()) {
                        MapZooms.MapZoomPair pair = new MapZooms.MapZoomPair(mr.getMinZoom(), mr.getMaxZoom());
                        TLongObjectHashMap<BinaryMapDataObject> objects = this.readBinaryMapData(indexReader, mi, mr.getMinZoom());
                        this.putMapObjects(pair, objects.valueCollection(), true);
                    }
                    continue;
                }
                if (p instanceof BinaryMapRouteReaderAdapter.RouteRegion) {
                    BinaryMapRouteReaderAdapter.RouteRegion rr = (BinaryMapRouteReaderAdapter.RouteRegion)p;
                    this.readRoutingData(indexReader, rr, 15, true);
                    continue;
                }
                if (p instanceof BinaryMapPoiReaderAdapter.PoiRegion) {
                    BinaryMapPoiReaderAdapter.PoiRegion pr = (BinaryMapPoiReaderAdapter.PoiRegion)p;
                    TLongObjectHashMap<Map<String, Amenity>> rr = this.readPoiData(indexReader, pr, 15, true);
                    this.putPoiData(rr, true);
                    continue;
                }
                if (!(p instanceof BinaryMapTransportReaderAdapter.TransportIndex)) continue;
                this.readTransportData(indexReader, (BinaryMapTransportReaderAdapter.TransportIndex)p, true);
            }
            this.updateTimestamp(indexReader.getDateCreated());
            this.setOsmAndOwner(indexReader.getOwner());
            indexReader.close();
            raf.close();
            if (!gzip) continue;
            nonGzip.delete();
        }
    }

    public void readTransportData(BinaryMapIndexReader indexReader, BinaryMapTransportReaderAdapter.TransportIndex ind, boolean override) throws IOException {
        BinaryMapIndexReader.SearchRequest sr = BinaryMapIndexReader.buildSearchTransportRequest((int)MapUtils.get31TileNumberX((double)this.lonleft), (int)MapUtils.get31TileNumberX((double)this.lonright), (int)MapUtils.get31TileNumberY((double)this.lattop), (int)MapUtils.get31TileNumberY((double)this.latbottom), (int)-1, null);
        List sti = indexReader.searchTransportIndex(ind, sr);
        TLongLongMap routesData = this.putTransportStops(sti, override);
        if (routesData.size() > 0) {
            long[] filePointers = routesData.keys();
            TLongObjectHashMap transportRoutes = indexReader.getTransportRoutes(filePointers);
            for (long offset : transportRoutes.keySet()) {
                TransportRoute route = (TransportRoute)transportRoutes.get(offset);
                Long routeId = route.getId();
                if (!override && this.transportRoutes.containsKey(routeId.longValue())) continue;
                this.transportRoutes.put(routeId.longValue(), (Object)route);
            }
        }
    }

    public TLongLongMap putTransportStops(Collection<TransportStop> newData, boolean override) {
        TLongLongHashMap routesStopsData = new TLongLongHashMap();
        for (TransportStop ts : newData) {
            TransportStop previousStop;
            long[] referencesToRoutes;
            Long tid = ts.getId();
            if (routesStopsData != null && (referencesToRoutes = ts.getReferencesToRoutes()) != null && referencesToRoutes.length > 0) {
                for (long ref : referencesToRoutes) {
                    routesStopsData.put(ref, tid.longValue());
                }
            }
            if ((previousStop = (TransportStop)this.transportStops.get(tid.longValue())) != null) {
                if (override) {
                    this.mergeStop(ts, previousStop);
                    this.transportStops.put(tid.longValue(), (Object)ts);
                    continue;
                }
                this.mergeStop(previousStop, ts);
                continue;
            }
            this.transportStops.put(tid.longValue(), (Object)ts);
        }
        return routesStopsData;
    }

    private void mergeStop(TransportStop stopToMergeInto, TransportStop stopToMergeFrom) {
        boolean rdidsNotEmpty;
        boolean ridsNotEmpty = stopToMergeInto.getRoutesIds() != null && stopToMergeInto.getRoutesIds().length > 0;
        boolean bl = rdidsNotEmpty = stopToMergeInto.getDeletedRoutesIds() != null && stopToMergeInto.getDeletedRoutesIds().length > 0;
        if (!(stopToMergeInto.isDeleted() || ridsNotEmpty && rdidsNotEmpty)) {
            if (stopToMergeFrom.getRoutesIds() != null) {
                for (long routeId : stopToMergeFrom.getRoutesIds()) {
                    if (stopToMergeInto.hasRoute(routeId) || stopToMergeInto.isRouteDeleted(routeId)) continue;
                    stopToMergeInto.addRouteId(routeId);
                }
            }
            if (stopToMergeFrom.getDeletedRoutesIds() != null) {
                for (long routeId : stopToMergeFrom.getDeletedRoutesIds()) {
                    if (stopToMergeInto.hasRoute(routeId) || stopToMergeInto.isRouteDeleted(routeId)) continue;
                    stopToMergeInto.addDeletedRouteId(routeId);
                }
            }
        }
    }

    public TLongObjectHashMap<Map<String, Amenity>> readPoiData(BinaryMapIndexReader indexReader, BinaryMapPoiReaderAdapter.PoiRegion pr, int zoomLevelPoi, boolean override) throws IOException {
        final TLongObjectHashMap local = new TLongObjectHashMap();
        BinaryMapIndexReader.SearchRequest req = BinaryMapIndexReader.buildSearchPoiRequest((int)MapUtils.get31TileNumberX((double)this.lonleft), (int)MapUtils.get31TileNumberX((double)this.lonright), (int)MapUtils.get31TileNumberY((double)this.lattop), (int)MapUtils.get31TileNumberY((double)this.latbottom), (int)15, (BinaryMapIndexReader.SearchPoiTypeFilter)BinaryMapIndexReader.ACCEPT_ALL_POI_TYPE_FILTER, (ResultMatcher)new ResultMatcher<Amenity>(){

            public boolean publish(Amenity object) {
                int order = 0;
                if (!local.containsKey(object.getId().longValue())) {
                    local.put(object.getId().longValue(), new LinkedHashMap());
                } else {
                    Map map = (Map)local.get(object.getId().longValue());
                    for (Amenity am : map.values()) {
                        order = Math.max(am.getOrder(), order);
                    }
                }
                if (object.getOrder() == 0) {
                    object.setOrder(order + 1);
                }
                ((Map)local.get(object.getId().longValue())).put(object.getType().getKeyName(), object);
                return false;
            }

            public boolean isCancelled() {
                return false;
            }
        });
        indexReader.initCategories(pr);
        indexReader.searchPoi(pr, req);
        return local;
    }

    public void putPoiData(TLongObjectHashMap<Map<String, Amenity>> newData, boolean override) {
        TLongObjectIterator it = newData.iterator();
        while (it.hasNext()) {
            it.advance();
            if (!override && this.poiObjects.containsKey(it.key())) continue;
            this.poiObjects.put(it.key(), (Object)((Map)it.value()));
        }
    }

    public void putRoutingData(TLongObjectHashMap<RouteDataObject> ro, boolean override) {
        for (RouteDataObject obj : ro.valueCollection()) {
            if (!override && this.routeObjects.containsKey(obj.getId())) continue;
            this.routeObjects.put(obj.getId(), (Object)this.routeIndex.adopt(obj));
        }
    }

    public void readRoutingData(BinaryMapIndexReader indexReader, BinaryMapRouteReaderAdapter.RouteRegion rr, int zm, final boolean override) throws IOException {
        List regions = indexReader.searchRouteIndexTree(BinaryMapIndexReader.buildSearchRequest((int)MapUtils.get31TileNumberX((double)this.lonleft), (int)MapUtils.get31TileNumberX((double)this.lonright), (int)MapUtils.get31TileNumberY((double)this.lattop), (int)MapUtils.get31TileNumberY((double)this.latbottom), (int)zm, null), rr.getSubregions());
        indexReader.loadRouteIndexData(regions, (ResultMatcher)new ResultMatcher<RouteDataObject>(){

            public boolean publish(RouteDataObject obj) {
                if (override || !ObfFileInMemory.this.routeObjects.containsKey(obj.getId())) {
                    RouteDataObject ad = ObfFileInMemory.this.routeIndex.adopt(obj);
                    ObfFileInMemory.this.routeObjects.put(ad.getId(), (Object)ad);
                }
                return true;
            }

            public boolean isCancelled() {
                return false;
            }
        });
    }

    private TLongObjectHashMap<BinaryMapDataObject> readBinaryMapData(BinaryMapIndexReader index, BinaryMapIndexReader.MapIndex mi, int zoom) throws IOException {
        final TLongObjectHashMap result = new TLongObjectHashMap();
        BinaryMapIndexReader.SearchRequest req = BinaryMapIndexReader.buildSearchRequest((int)MapUtils.get31TileNumberX((double)this.lonleft), (int)MapUtils.get31TileNumberX((double)this.lonright), (int)MapUtils.get31TileNumberY((double)this.lattop), (int)MapUtils.get31TileNumberY((double)this.latbottom), (int)zoom, (BinaryMapIndexReader.SearchFilter)new BinaryMapIndexReader.SearchFilter(){

            public boolean accept(TIntArrayList types, BinaryMapIndexReader.MapIndex index) {
                return true;
            }
        }, (ResultMatcher)new ResultMatcher<BinaryMapDataObject>(){

            public boolean publish(BinaryMapDataObject obj) {
                result.put(obj.getId(), (Object)obj);
                return false;
            }

            public boolean isCancelled() {
                return false;
            }
        });
        index.searchMapIndex(req, mi);
        return result;
    }

    public void filterAllZoomsBelow(int zm) {
        for (MapZooms.MapZoomPair mz : new ArrayList<MapZooms.MapZoomPair>(this.getZooms())) {
            if (mz.getMaxZoom() >= zm) continue;
            this.mapObjects.remove(mz);
        }
    }

    public void setOsmAndOwner(BinaryMapIndexReader.OsmAndOwner owner) {
        this.osmAndOwner = owner;
    }
}

