/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.osmand.util.MapUtils;

public class DataTileManager<T> {
    private final int zoom;
    private final TLongObjectHashMap<List<T>> objects = new TLongObjectHashMap();

    public DataTileManager() {
        this.zoom = 15;
    }

    public DataTileManager(int z) {
        this.zoom = z;
    }

    public int getZoom() {
        return this.zoom;
    }

    public boolean isEmpty() {
        return this.getObjectsCount() == 0;
    }

    public int getObjectsCount() {
        int x = 0;
        for (List s : this.objects.valueCollection()) {
            x += s.size();
        }
        return x;
    }

    public void printStatsDistribution(String name) {
        int min = -1;
        int max = -1;
        int total = 0;
        for (List l : this.objects.valueCollection()) {
            if (min == -1) {
                max = min = l.size();
            } else {
                min = Math.min(min, l.size());
                max = Math.max(max, l.size());
            }
            total += l.size();
        }
        System.out.printf("%s tiles stores %d in %d tiles. Tile size min %d, max %d, avg %.2f.\n ", name, total, this.objects.size(), min, max, (double)total / ((double)this.objects.size() + 0.1));
    }

    private void putObjects(long t, List<T> r) {
        if (this.objects.containsKey(t)) {
            r.addAll((Collection)this.objects.get(t));
        }
    }

    public List<T> getAllObjects() {
        ArrayList<T> l = new ArrayList<T>();
        for (List<T> s : this.getAllEditObjects()) {
            l.addAll(s);
        }
        return l;
    }

    public List<List<T>> getAllEditObjects() {
        return new ArrayList<List<T>>(this.objects.valueCollection());
    }

    public List<T> getObjects(double latitudeUp, double longitudeUp, double latitudeDown, double longitudeDown) {
        int tileXUp = (int)MapUtils.getTileNumberX(this.zoom, longitudeUp);
        int tileYUp = (int)MapUtils.getTileNumberY(this.zoom, latitudeUp);
        int tileXDown = (int)MapUtils.getTileNumberX(this.zoom, longitudeDown) + 1;
        int tileYDown = (int)MapUtils.getTileNumberY(this.zoom, latitudeDown) + 1;
        ArrayList result = new ArrayList();
        if (tileXUp > tileXDown) {
            tileXDown = tileXUp;
            tileXUp = 0;
        }
        if (tileYUp > tileYDown) {
            tileYDown = tileYUp;
            tileXUp = 0;
        }
        for (int i = tileXUp; i <= tileXDown; ++i) {
            for (int j = tileYUp; j <= tileYDown; ++j) {
                this.putObjects(this.evTile(i, j), result);
            }
        }
        return result;
    }

    public List<T> getObjects(int leftX31, int topY31, int rightX31, int bottomY31) {
        ArrayList result = new ArrayList();
        return this.getObjects(leftX31, topY31, rightX31, bottomY31, result);
    }

    public List<T> getObjects(int leftX31, int topY31, int rightX31, int bottomY31, List<T> result) {
        int tileXUp = leftX31 >> 31 - this.zoom;
        int tileYUp = topY31 >> 31 - this.zoom;
        int tileXDown = (rightX31 >> 31 - this.zoom) + 1;
        int tileYDown = (bottomY31 >> 31 - this.zoom) + 1;
        for (int i = tileXUp; i <= tileXDown; ++i) {
            for (int j = tileYUp; j <= tileYDown; ++j) {
                this.putObjects(this.evTile(i, j), result);
            }
        }
        return result;
    }

    public List<T> getClosestObjects(double latitude, double longitude, double radius) {
        if (this.isEmpty()) {
            return new ArrayList();
        }
        double tileDist = radius / MapUtils.getTileDistanceWidth(latitude, this.zoom);
        int tileDistInt = (int)Math.ceil(tileDist);
        double px = MapUtils.getTileNumberX(this.zoom, longitude);
        double py = MapUtils.getTileNumberY(this.zoom, latitude);
        int stTileX = (int)px;
        int stTileY = (int)py;
        final HashMap<Long, Double> tiles = new HashMap<Long, Double>();
        for (int xTile = -tileDistInt; xTile <= tileDistInt; ++xTile) {
            for (int yTile = -tileDistInt; yTile <= tileDistInt; ++yTile) {
                double dx = (double)xTile + 0.5 - (px - (double)stTileX);
                double dy = (double)yTile + 0.5 - (py - (double)stTileY);
                double dist = Math.sqrt(dx * dx + dy * dy);
                if (!(dist <= tileDist)) continue;
                tiles.put(this.evTile(stTileX + xTile, stTileY + yTile), dist);
            }
        }
        ArrayList keys = new ArrayList(tiles.keySet());
        Collections.sort(keys, new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                return Double.compare((Double)tiles.get(o1), (Double)tiles.get(o2));
            }
        });
        ArrayList result = new ArrayList();
        for (Long key : keys) {
            this.putObjects(key, result);
        }
        return result;
    }

    protected List<T> getClosestObjectsBySpiral(double latitude, double longitude, int startDepth, int maxDepth) {
        ArrayList result = new ArrayList();
        int tileX = (int)MapUtils.getTileNumberX(this.zoom, longitude);
        int tileY = (int)MapUtils.getTileNumberY(this.zoom, latitude);
        if (startDepth <= 0) {
            this.putObjects(this.evTile(tileX, tileY), result);
            startDepth = 1;
        }
        for (int depth = startDepth; depth <= maxDepth; ++depth) {
            for (int j = 0; j <= depth; ++j) {
                int dx;
                int n = dx = j == 0 ? 0 : -1;
                while (dx < 1 || j < depth && dx == 1) {
                    this.putObjects(this.evTile(tileX + dx * j, tileY + depth), result);
                    this.putObjects(this.evTile(tileX + depth, tileY - dx * j), result);
                    this.putObjects(this.evTile(tileX - dx * j, tileY - depth), result);
                    this.putObjects(this.evTile(tileX - depth, tileY + dx * j), result);
                    dx += 2;
                }
            }
        }
        return result;
    }

    private long evTile(int tileX, int tileY) {
        return ((long)tileX << this.zoom) + (long)tileY;
    }

    public long evaluateTile(double latitude, double longitude) {
        int tileX = (int)MapUtils.getTileNumberX(this.zoom, longitude);
        int tileY = (int)MapUtils.getTileNumberY(this.zoom, latitude);
        return this.evTile(tileX, tileY);
    }

    public long evaluateTileXY(int x31, int y31) {
        return this.evTile(x31 >> 31 - this.zoom, y31 >> 31 - this.zoom);
    }

    public void unregisterObject(double latitude, double longitude, T object) {
        long tile = this.evaluateTile(latitude, longitude);
        this.removeObject(object, tile);
    }

    public void unregisterObjectXY(int x31, int y31, T object) {
        long tile = this.evaluateTileXY(x31, y31);
        this.removeObject(object, tile);
    }

    private void removeObject(T object, long tile) {
        if (this.objects.containsKey(tile)) {
            ((List)this.objects.get(tile)).remove(object);
        }
    }

    public long registerObjectXY(int x31, int y31, T object) {
        return this.addObject(object, this.evTile(x31 >> 31 - this.zoom, y31 >> 31 - this.zoom));
    }

    public long registerObject(double latitude, double longitude, T object) {
        long tile = this.evaluateTile(latitude, longitude);
        return this.addObject(object, tile);
    }

    private long addObject(T object, long tile) {
        if (!this.objects.containsKey(tile)) {
            this.objects.put(tile, new ArrayList());
        }
        ((List)this.objects.get(tile)).add(object);
        return tile;
    }

    public void clear() {
        this.objects.clear();
    }
}

