/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.tiff;

import it.geosolutions.imageio.imageioimpl.EnhancedImageReadParam;
import it.geosolutions.imageio.plugins.tiff.BaselineTIFFTagSet;
import it.geosolutions.imageio.plugins.tiff.EXIFParentTIFFTagSet;
import it.geosolutions.imageio.plugins.tiff.FaxTIFFTagSet;
import it.geosolutions.imageio.plugins.tiff.GeoTIFFTagSet;
import it.geosolutions.imageio.plugins.tiff.PrivateTIFFTagSet;
import it.geosolutions.imageio.plugins.tiff.TIFFColorConverter;
import it.geosolutions.imageio.plugins.tiff.TIFFDecompressor;
import it.geosolutions.imageio.plugins.tiff.TIFFTagSet;
import java.util.ArrayList;
import java.util.List;

public class TIFFImageReadParam
extends EnhancedImageReadParam {
    List allowedTagSets = new ArrayList(5);
    TIFFDecompressor decompressor = null;
    TIFFColorConverter colorConverter = null;

    public TIFFImageReadParam() {
        this.addAllowedTagSet(BaselineTIFFTagSet.getInstance());
        this.addAllowedTagSet(FaxTIFFTagSet.getInstance());
        this.addAllowedTagSet(EXIFParentTIFFTagSet.getInstance());
        this.addAllowedTagSet(GeoTIFFTagSet.getInstance());
        this.addAllowedTagSet(PrivateTIFFTagSet.getInstance());
    }

    public void addAllowedTagSet(TIFFTagSet tagSet) {
        if (tagSet == null) {
            throw new IllegalArgumentException("tagSet == null!");
        }
        this.allowedTagSets.add(tagSet);
    }

    public void removeAllowedTagSet(TIFFTagSet tagSet) {
        if (tagSet == null) {
            throw new IllegalArgumentException("tagSet == null!");
        }
        this.allowedTagSets.remove(tagSet);
    }

    public List getAllowedTagSets() {
        return this.allowedTagSets;
    }

    public void setTIFFDecompressor(TIFFDecompressor decompressor) {
        this.decompressor = decompressor;
    }

    public TIFFDecompressor getTIFFDecompressor() {
        return this.decompressor;
    }

    public void setColorConverter(TIFFColorConverter colorConverter) {
        this.colorConverter = colorConverter;
    }

    public TIFFColorConverter getColorConverter() {
        return this.colorConverter;
    }
}

