/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm.io;

import gnu.trove.list.array.TLongArrayList;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.osmand.data.MapObject;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.EntityInfo;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.osm.io.OsmBaseStorage;
import net.osmand.util.Algorithms;

public class OsmStorageWriter {
    private static final String INDENT = "    ";
    private final String INDENT2 = "        ";

    public <T extends Entity> List<T> sort(List<T> lst) {
        Collections.sort(lst, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return Long.compare(o1.getId(), o2.getId());
            }
        });
        return lst;
    }

    public void saveStorage(OutputStream output, OsmBaseStorage storage, Collection<Entity.EntityId> interestedObjects, boolean includeLinks) throws XMLStreamException, IOException {
        Map entities = storage.getRegisteredEntities();
        Map entityInfo = storage.getRegisteredEntityInfo();
        this.saveStorage(output, entities, entityInfo, interestedObjects, includeLinks);
    }

    public void saveStorage(OutputStream output, Map<Entity.EntityId, Entity> entities, Map<Entity.EntityId, EntityInfo> entityInfo, Collection<Entity.EntityId> interestedObjects, boolean includeLinks) throws FactoryConfigurationError, XMLStreamException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<Way> ways = new ArrayList<Way>();
        ArrayList<Relation> relations = new ArrayList<Relation>();
        if (interestedObjects == null) {
            interestedObjects = entities.keySet();
        }
        ArrayList<Entity.EntityId> toResolve = new ArrayList<Entity.EntityId>();
        HashSet<Entity.EntityId> resolved = new HashSet<Entity.EntityId>();
        toResolve.addAll(interestedObjects);
        while (!toResolve.isEmpty()) {
            Entity.EntityId l = (Entity.EntityId)toResolve.remove(toResolve.size() - 1);
            boolean add = resolved.add(l);
            if (!add) continue;
            if (entities.get(l) instanceof Node) {
                nodes.add((Node)entities.get(l));
                continue;
            }
            if (entities.get(l) instanceof Way) {
                ways.add((Way)entities.get(l));
                if (!includeLinks) continue;
                toResolve.addAll(((Way)entities.get(l)).getEntityIds());
                continue;
            }
            if (!(entities.get(l) instanceof Relation)) continue;
            relations.add((Relation)entities.get(l));
            if (!includeLinks) continue;
            for (Relation.RelationMember rm : ((Relation)entities.get(l)).getMembers()) {
                toResolve.add(rm.getEntityId());
            }
        }
        this.writeOSM(output, entityInfo, this.sort(nodes), this.sort(ways), this.sort(relations));
    }

    public void writeOSM(OutputStream output, Map<Entity.EntityId, EntityInfo> entityInfo, Collection<Node> nodes, Collection<Way> ways, Collection<Relation> relations) throws FactoryConfigurationError, XMLStreamException {
        this.writeOSM(output, entityInfo, nodes, ways, relations, false);
    }

    public void writeOSM(OutputStream output, Map<Entity.EntityId, EntityInfo> entityInfo, Collection<Node> nodes, Collection<Way> ways, Collection<Relation> relations, boolean skipMissingMembers) throws FactoryConfigurationError, XMLStreamException {
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        XMLStreamWriter streamWriter = xof.createXMLStreamWriter(new OutputStreamWriter(output));
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(8);
        streamWriter.writeStartDocument();
        HashSet<Entity.EntityId> nd = new HashSet<Entity.EntityId>();
        this.writeStartElement(streamWriter, "osm", "");
        streamWriter.writeAttribute("version", "0.6");
        for (Node n : nodes) {
            if (n.getTags().isEmpty()) {
                this.writeEmptyElement(streamWriter, "node", INDENT);
            } else {
                this.writeStartElement(streamWriter, "node", INDENT);
            }
            streamWriter.writeAttribute("lat", nf.format(n.getLatitude()));
            streamWriter.writeAttribute("lon", nf.format(n.getLongitude()));
            streamWriter.writeAttribute("id", String.valueOf(n.getId()));
            this.writeEntityAttributes(streamWriter, (Entity)n, entityInfo == null ? null : entityInfo.get(Entity.EntityId.valueOf((Entity)n)));
            if (!n.getTags().isEmpty()) {
                this.writeTags(streamWriter, (Entity)n);
                this.writeEndElement(streamWriter, INDENT);
            }
            if (!skipMissingMembers) continue;
            nd.add(Entity.EntityId.valueOf((Entity)n));
        }
        for (Way w : ways) {
            this.writeStartElement(streamWriter, "way", INDENT);
            streamWriter.writeAttribute("id", String.valueOf(w.getId()));
            this.writeEntityAttributes(streamWriter, (Entity)w, entityInfo == null ? null : entityInfo.get(Entity.EntityId.valueOf((Entity)w)));
            TLongArrayList ids = w.getNodeIds();
            for (int i = 0; i < ids.size(); ++i) {
                this.writeEmptyElement(streamWriter, "nd", "        ");
                streamWriter.writeAttribute("ref", String.valueOf(ids.get(i)));
            }
            this.writeTags(streamWriter, (Entity)w);
            this.writeEndElement(streamWriter, INDENT);
            if (!skipMissingMembers) continue;
            nd.add(Entity.EntityId.valueOf((Entity)w));
        }
        for (Relation r : relations) {
            if (skipMissingMembers) {
                nd.add(Entity.EntityId.valueOf((Entity)r));
            }
            this.writeStartElement(streamWriter, "relation", INDENT);
            streamWriter.writeAttribute("id", String.valueOf(r.getId()));
            this.writeEntityAttributes(streamWriter, (Entity)r, entityInfo == null ? null : entityInfo.get(Entity.EntityId.valueOf((Entity)r)));
            for (Relation.RelationMember e : r.getMembers()) {
                if (skipMissingMembers && !nd.contains(e.getEntityId())) continue;
                this.writeStartElement(streamWriter, "member", "        ");
                streamWriter.writeAttribute("ref", String.valueOf(e.getEntityId().getId()));
                String s = e.getRole();
                if (s == null) {
                    s = "";
                }
                streamWriter.writeAttribute("role", s);
                streamWriter.writeAttribute("type", e.getEntityId().getType().toString().toLowerCase());
                this.writeEndElement(streamWriter, "        ");
            }
            this.writeTags(streamWriter, (Entity)r);
            this.writeEndElement(streamWriter, INDENT);
        }
        this.writeEndElement(streamWriter, "");
        streamWriter.writeEndDocument();
        streamWriter.flush();
    }

    private void writeEntityAttributes(XMLStreamWriter writer, Entity i, EntityInfo info) throws XMLStreamException {
        if (i.getId() < 0L && (info == null || info.getAction() == null)) {
            writer.writeAttribute("action", "modify");
        }
        if (info != null) {
            if (info.getAction() != null) {
                writer.writeAttribute("action", info.getAction());
            }
            if (info.getChangeset() != null) {
                writer.writeAttribute("changeset", info.getChangeset());
            }
            if (info.getTimestamp() != null) {
                writer.writeAttribute("timestamp", info.getTimestamp());
            }
            if (info.getUid() != null) {
                writer.writeAttribute("uid", info.getUid());
            }
            if (info.getUser() != null) {
                writer.writeAttribute("user", info.getUser());
            }
            if (info.getVisible() != null) {
                writer.writeAttribute("visible", info.getVisible());
            }
            if (info.getVersion() != null) {
                writer.writeAttribute("version", info.getVersion());
            }
        } else {
            writer.writeAttribute("version", (String)(i.getVersion() == 0 ? "1" : "" + i.getVersion()));
        }
    }

    public boolean couldBeWrited(MapObject e) {
        return !Algorithms.isEmpty((CharSequence)e.getName()) && e.getLocation() != null;
    }

    private void writeStartElement(XMLStreamWriter writer, String name, String indent) throws XMLStreamException {
        writer.writeCharacters("\n" + indent);
        writer.writeStartElement(name);
    }

    private void writeEmptyElement(XMLStreamWriter writer, String name, String indent) throws XMLStreamException {
        writer.writeCharacters("\n" + indent);
        writer.writeEmptyElement(name);
    }

    private void writeEndElement(XMLStreamWriter writer, String indent) throws XMLStreamException {
        writer.writeCharacters("\n" + indent);
        writer.writeEndElement();
    }

    private void writeTags(XMLStreamWriter writer, Entity e) throws XMLStreamException {
        for (Map.Entry en : e.getTags().entrySet()) {
            this.writeEmptyElement(writer, "tag", "        ");
            writer.writeAttribute("k", this.replaceInvalid((String)en.getKey()));
            writer.writeAttribute("v", this.replaceInvalid((String)en.getValue()));
        }
    }

    private String replaceInvalid(String value) {
        value = value.replace('\udd62', ' ').replace('\ud855', ' ');
        return value.replace('\ud83d', ' ').replace('\udeb2', ' ');
    }
}

