/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.osmand.shared.gpx.GpxDbUtils;
import net.osmand.shared.gpx.GpxParameter;
import net.osmand.shared.io.KFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0016\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0015H&J\u0019\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0019J\u001b\u0010\u001a\u001a\u0004\u0018\u0001H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001J\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0015J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u001a\u0010!\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0013\u0010$\u001a\u00020\u00122\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lnet/osmand/shared/gpx/DataItem;", "", "file", "Lnet/osmand/shared/io/KFile;", "<init>", "(Lnet/osmand/shared/io/KFile;)V", "getFile", "()Lnet/osmand/shared/io/KFile;", "map", "", "Lnet/osmand/shared/gpx/GpxParameter;", "getMap", "()Ljava/util/Map;", "analysisParametersVersion", "Ljava/util/concurrent/atomic/AtomicLong;", "initFileParameters", "", "hasData", "", "hasAppearanceData", "getParameters", "", "requireParameter", "T", "parameter", "(Lnet/osmand/shared/gpx/GpxParameter;)Ljava/lang/Object;", "getParameter", "setParameter", "value", "getAnalysisCalculationParameters", "getAnalysisParametersVersion", "", "increaseAnalysisParametersVersion", "isValidValue", "hashCode", "", "equals", "other", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nDataItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataItem.kt\nnet/osmand/shared/gpx/DataItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,80:1\n1755#2,3:81\n535#3:84\n520#3,6:85\n*S KotlinDebug\n*F\n+ 1 DataItem.kt\nnet/osmand/shared/gpx/DataItem\n*L\n28#1:81,3\n59#1:84\n59#1:85,6\n*E\n"})
public abstract class DataItem {
    @NotNull
    private final KFile file;
    @NotNull
    private final Map<GpxParameter, Object> map;
    @NotNull
    private AtomicLong analysisParametersVersion;

    public DataItem(@NotNull KFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.map = new HashMap();
        this.analysisParametersVersion = new AtomicLong(0L);
        this.initFileParameters();
    }

    @NotNull
    public final KFile getFile() {
        return this.file;
    }

    @NotNull
    protected final Map<GpxParameter, Object> getMap() {
        return this.map;
    }

    private final void initFileParameters() {
        this.map.put(GpxParameter.FILE_NAME, this.file.name());
        this.map.put(GpxParameter.FILE_DIR, GpxDbUtils.INSTANCE.getGpxFileDir(this.file));
        this.map.put(GpxParameter.FILE_LAST_MODIFIED_TIME, this.file.lastModified());
    }

    public final boolean hasData() {
        return !this.map.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasAppearanceData() {
        boolean bl;
        if (!this.hasData()) return false;
        Iterable $this$any$iv = GpxParameter.Companion.getAppearanceParameters();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            GpxParameter key = (GpxParameter)((Object)element$iv);
            boolean bl2 = false;
            if (this.map.get((Object)key) != null) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public abstract Map<GpxParameter, Object> getParameters();

    public final <T> T requireParameter(@NotNull GpxParameter parameter) {
        T res;
        Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
        T t = this.getParameter(parameter);
        if (t == null) {
            t = null;
        }
        T t2 = res = t;
        if (t2 == null) {
            throw new IllegalStateException("Requested parameter '" + parameter + "' is null.");
        }
        return t2;
    }

    @Nullable
    public final <T> T getParameter(@NotNull GpxParameter parameter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
        Object value = null;
        if (this.map.containsKey((Object)parameter)) {
            value = this.map.get((Object)parameter);
        }
        if (value == null && !parameter.isAppearanceParameter()) {
            value = parameter.getDefaultValue();
        }
        if ((object = value) == null) {
            object = null;
        }
        return (T)object;
    }

    public final boolean setParameter(@NotNull GpxParameter parameter, @Nullable Object value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
        if (this.isValidValue(parameter, value)) {
            this.map.put(parameter, value);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<GpxParameter, Object> getAnalysisCalculationParameters() {
        void $this$filterTo$iv$iv;
        Map<GpxParameter, Object> $this$filter$iv = this.map;
        boolean $i$f$filter = false;
        Map<GpxParameter, Object> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!((GpxParameter)((Object)it.getKey())).isAnalysisRecalculationNeeded()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    public final long getAnalysisParametersVersion() {
        return this.analysisParametersVersion.get();
    }

    public final long increaseAnalysisParametersVersion() {
        return this.analysisParametersVersion.incrementAndGet();
    }

    public boolean isValidValue(@NotNull GpxParameter parameter, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
        return true;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof DataItem)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.file, (Object)((DataItem)other).file);
    }
}

