/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.Amenity;
import net.osmand.core.jni.OsmAndCoreJNI;

public class DecodedValueList {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected DecodedValueList(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(DecodedValueList decodedValueList) {
        return decodedValueList == null ? 0L : decodedValueList.swigCPtr;
    }

    protected static long swigRelease(DecodedValueList decodedValueList) {
        long l = 0L;
        if (decodedValueList != null) {
            if (!decodedValueList.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = decodedValueList.swigCPtr;
            decodedValueList.swigCMemOwn = false;
            decodedValueList.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_DecodedValueList(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public DecodedValueList() {
        this(OsmAndCoreJNI.new_DecodedValueList(), true);
    }

    public long size() {
        return OsmAndCoreJNI.DecodedValueList_size(this.swigCPtr, this);
    }

    public void reserve(long l) {
        OsmAndCoreJNI.DecodedValueList_reserve(this.swigCPtr, this, l);
    }

    public boolean isEmpty() {
        return OsmAndCoreJNI.DecodedValueList_isEmpty(this.swigCPtr, this);
    }

    public void clear() {
        OsmAndCoreJNI.DecodedValueList_clear(this.swigCPtr, this);
    }

    public void add(Amenity.DecodedValue decodedValue) {
        OsmAndCoreJNI.DecodedValueList_add(this.swigCPtr, this, Amenity.DecodedValue.getCPtr(decodedValue), decodedValue);
    }

    public Amenity.DecodedValue get(int n) {
        return new Amenity.DecodedValue(OsmAndCoreJNI.DecodedValueList_get(this.swigCPtr, this, n), false);
    }

    public void set(int n, Amenity.DecodedValue decodedValue) {
        OsmAndCoreJNI.DecodedValueList_set(this.swigCPtr, this, n, Amenity.DecodedValue.getCPtr(decodedValue), decodedValue);
    }
}

