/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.osmand.Collator;
import net.osmand.OsmAndCollator;
import net.osmand.data.LatLon;
import net.osmand.util.Algorithms;
import net.osmand.util.TransliterationHelper;
import org.json.JSONObject;

public abstract class MapObject
implements Comparable<MapObject> {
    public static final MapObjectComparator BY_NAME_COMPARATOR = new MapObjectComparator();
    public static final byte AMENITY_ID_RIGHT_SHIFT = 1;
    public static final byte WAY_MODULO_REMAINDER = 1;
    protected String name = null;
    protected String enName = null;
    protected Map<String, String> names = null;
    protected LatLon location = null;
    protected long fileOffset = 0L;
    protected Long id = null;
    private Object referenceFile = null;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        if (this.id != null) {
            return this.id;
        }
        return null;
    }

    public String getName() {
        if (this.name != null) {
            return MapObject.unzipContent(this.name);
        }
        return "";
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setName(String lang, String name) {
        if (Algorithms.isEmpty(lang)) {
            this.setName(name);
        } else if (lang.equals("en")) {
            this.setEnName(name);
        } else {
            if (this.names == null) {
                this.names = new LinkedHashMap<String, String>();
            }
            this.names.put(lang, MapObject.unzipContent(name));
        }
    }

    public void setNames(Map<String, String> name) {
        if (name != null) {
            if (this.names == null) {
                this.names = new LinkedHashMap<String, String>();
            }
            this.names.putAll(name);
        }
    }

    public Map<String, String> getNamesMap(boolean includeEn) {
        if ((!includeEn || Algorithms.isEmpty(this.enName)) && this.names == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> mp = new LinkedHashMap<String, String>();
        if (this.names != null) {
            for (Map.Entry<String, String> e : this.names.entrySet()) {
                mp.put(e.getKey(), MapObject.unzipContent(e.getValue()));
            }
        }
        if (includeEn && !Algorithms.isEmpty(this.enName)) {
            mp.put("en", MapObject.unzipContent(this.enName));
        }
        return mp;
    }

    public List<String> getOtherNames() {
        return this.getOtherNames(false);
    }

    public List<String> getOtherNames(boolean transliterate) {
        ArrayList<String> l = new ArrayList<String>();
        String enName = this.getEnName(transliterate);
        if (!Algorithms.isEmpty(enName)) {
            l.add(enName);
        }
        if (this.names != null) {
            l.addAll(this.names.values());
        }
        return l;
    }

    public void copyNames(String otherName, String otherEnName, Map<String, String> otherNames, boolean overwrite) {
        if (!Algorithms.isEmpty(otherName) && (overwrite || Algorithms.isEmpty(this.name))) {
            this.name = otherName;
        }
        if (!Algorithms.isEmpty(otherEnName) && (overwrite || Algorithms.isEmpty(this.enName))) {
            this.enName = otherEnName;
        }
        if (!Algorithms.isEmpty(otherNames)) {
            if (otherNames.containsKey("name:en")) {
                this.enName = otherNames.get("name:en");
            } else if (otherNames.containsKey("en")) {
                this.enName = otherNames.get("en");
            }
            for (Map.Entry<String, String> e : otherNames.entrySet()) {
                String key = e.getKey();
                if (key.startsWith("name:")) {
                    key = key.substring("name:".length());
                }
                if (this.names == null) {
                    this.names = new LinkedHashMap<String, String>();
                }
                if (!overwrite && !Algorithms.isEmpty(this.names.get(key))) continue;
                this.names.put(key, e.getValue());
            }
        }
    }

    public void copyNames(String otherName, String otherEnName, Map<String, String> otherNames) {
        this.copyNames(otherName, otherEnName, otherNames, false);
    }

    public void copyNames(MapObject s, boolean copyName, boolean copyEnName, boolean overwrite) {
        this.copyNames(copyName ? s.name : null, copyEnName ? s.enName : null, s.names, overwrite);
    }

    public void copyNames(MapObject s) {
        this.copyNames(s, true, true, false);
    }

    public String getName(String lang) {
        return this.getName(lang, false);
    }

    public String getName(String lang, boolean transliterate) {
        if (lang != null && lang.length() > 0) {
            if (lang.equals("en")) {
                String enName = this.getEnName(transliterate);
                return !Algorithms.isEmpty(enName) ? enName : this.getName();
            }
            if (this.names != null) {
                String nm = this.names.get(lang);
                if (!Algorithms.isEmpty(nm)) {
                    return MapObject.unzipContent(nm);
                }
                if (transliterate) {
                    return TransliterationHelper.transliterate(this.getName());
                }
            }
        }
        return this.getName();
    }

    public String getEnName(boolean transliterate) {
        if (!Algorithms.isEmpty(this.enName)) {
            return MapObject.unzipContent(this.enName);
        }
        if (!Algorithms.isEmpty(this.getName()) && transliterate) {
            return TransliterationHelper.transliterate(this.getName());
        }
        return "";
    }

    public void setEnName(String enName) {
        this.enName = enName;
    }

    public LatLon getLocation() {
        return this.location;
    }

    public void setLocation(double latitude, double longitude) {
        this.location = new LatLon(latitude, longitude);
    }

    public void setLocation(LatLon loc) {
        this.location = loc;
    }

    @Override
    public int compareTo(MapObject o) {
        return OsmAndCollator.primaryCollator().compare(this.getName(), o.getName());
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public void setFileOffset(long fileOffset) {
        this.fileOffset = fileOffset;
    }

    public String toStringEn() {
        return this.getClass().getSimpleName() + ":" + this.getEnName(true);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.name + "(" + this.id + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapObject other = (MapObject)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public boolean compareObject(MapObject thatObj) {
        if (this == thatObj) {
            return true;
        }
        if (thatObj == null || this.id == null || thatObj.id == null) {
            return false;
        }
        return this.id.longValue() == thatObj.id.longValue() && Algorithms.objectEquals(this.getLocation(), thatObj.getLocation()) && Algorithms.objectEquals(this.getName(), thatObj.getName()) && Algorithms.objectEquals(this.getNamesMap(true), thatObj.getNamesMap(true));
    }

    public void setReferenceFile(Object referenceFile) {
        this.referenceFile = referenceFile;
    }

    public Object getReferenceFile() {
        return this.referenceFile;
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("name", (Object)MapObject.unzipContent(this.name));
        json.put("enName", (Object)MapObject.unzipContent(this.enName));
        if (this.names != null && this.names.size() > 0) {
            JSONObject namesObj = new JSONObject();
            for (Map.Entry<String, String> e : this.names.entrySet()) {
                namesObj.put(e.getKey(), (Object)MapObject.unzipContent(e.getValue()));
            }
            json.put("names", (Object)namesObj);
        }
        if (this.location != null) {
            json.put("lat", (Object)String.format(Locale.US, "%.5f", this.location.getLatitude()));
            json.put("lon", (Object)String.format(Locale.US, "%.5f", this.location.getLongitude()));
        }
        json.put("id", (Object)this.id);
        return json;
    }

    public static String unzipContent(String str) {
        if (MapObject.isContentZipped(str)) {
            try {
                String s;
                int ind = 4;
                byte[] bytes = new byte[str.length() - ind];
                for (int i = ind; i < str.length(); ++i) {
                    char ch = str.charAt(i);
                    bytes[i - ind] = (byte)(ch - 128 - 32);
                }
                GZIPInputStream gzn = new GZIPInputStream(new ByteArrayInputStream(bytes));
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)gzn, "UTF-8"));
                StringBuilder bld = new StringBuilder();
                while ((s = br.readLine()) != null) {
                    bld.append(s);
                }
                br.close();
                str = bld.toString();
                if (MapObject.isContentZipped(str)) {
                    str = MapObject.unzipContent(str);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return str;
    }

    public static boolean isContentZipped(String str) {
        return str != null && str.startsWith(" gz ");
    }

    protected static void parseJSON(JSONObject json, MapObject o) {
        if (json.has("name")) {
            o.name = json.getString("name");
        }
        if (json.has("enName")) {
            o.enName = json.getString("enName");
        }
        if (json.has("names")) {
            JSONObject namesObj = json.getJSONObject("names");
            o.names = new LinkedHashMap<String, String>();
            Iterator iterator = namesObj.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = namesObj.getString(key);
                o.names.put(key, value);
            }
        }
        if (json.has("lat") && json.has("lon")) {
            o.location = new LatLon(json.getDouble("lat"), json.getDouble("lon"));
        }
        if (json.has("id")) {
            o.id = json.getLong("id");
        }
    }

    public static boolean isNameLangTag(String tag) {
        if (tag.startsWith("name:")) {
            if (tag.length() <= "name:".length() + 3) {
                return true;
            }
            int l = tag.indexOf("-");
            if (l <= "name:".length() + 3) {
                return true;
            }
        }
        return false;
    }

    public static class MapObjectComparator
    implements Comparator<MapObject> {
        private final String l;
        Collator collator = OsmAndCollator.primaryCollator();
        private boolean transliterate;

        public MapObjectComparator() {
            this.l = null;
        }

        public MapObjectComparator(String lang, boolean transliterate) {
            this.l = lang;
            this.transliterate = transliterate;
        }

        @Override
        public int compare(MapObject o1, MapObject o2) {
            if (o1 == null ^ o2 == null) {
                return o1 == null ? -1 : 1;
            }
            if (o1 == o2) {
                return 0;
            }
            return this.collator.compare(o1.getName(this.l, this.transliterate), o2.getName(this.l, this.transliterate));
        }

        public boolean areEqual(MapObject o1, MapObject o2) {
            if (o1 == null ^ o2 == null) {
                return false;
            }
            if (o1 == o2) {
                return true;
            }
            return this.collator.equals(o1.getName(this.l, this.transliterate), o2.getName(this.l, this.transliterate));
        }
    }
}

