/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.Address;
import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.SWIGTYPE_p_QListT_std__shared_ptrT_OsmAnd__Building_const_t_t;
import net.osmand.core.jni.SWIGTYPE_p_QListT_std__shared_ptrT_OsmAnd__StreetIntersection_const_t_t;
import net.osmand.core.jni.StreetGroup;

public class Street
extends Address {
    private transient long swigCPtr;
    private transient boolean swigCMemOwnDerived;

    protected Street(long l, boolean bl) {
        super(OsmAndCoreJNI.Street_SWIGSmartPtrUpcast(l), true);
        this.swigCMemOwnDerived = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Street street) {
        return street == null ? 0L : street.swigCPtr;
    }

    @Override
    protected void swigSetCMemOwn(boolean bl) {
        this.swigCMemOwnDerived = bl;
        super.swigSetCMemOwn(bl);
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwnDerived) {
                this.swigCMemOwnDerived = false;
                OsmAndCoreJNI.delete_Street(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public Street(StreetGroup streetGroup) {
        this(OsmAndCoreJNI.new_Street(StreetGroup.getCPtr(streetGroup), streetGroup), true);
    }

    @Override
    public String toString() {
        return OsmAndCoreJNI.Street_toString(this.swigCPtr, this);
    }

    public void setOffset(long l) {
        OsmAndCoreJNI.Street_offset_set(this.swigCPtr, this, l);
    }

    public long getOffset() {
        return OsmAndCoreJNI.Street_offset_get(this.swigCPtr, this);
    }

    public void setFirstBuildingInnerOffset(long l) {
        OsmAndCoreJNI.Street_firstBuildingInnerOffset_set(this.swigCPtr, this, l);
    }

    public long getFirstBuildingInnerOffset() {
        return OsmAndCoreJNI.Street_firstBuildingInnerOffset_get(this.swigCPtr, this);
    }

    public void setFirstIntersectionInnerOffset(long l) {
        OsmAndCoreJNI.Street_firstIntersectionInnerOffset_set(this.swigCPtr, this, l);
    }

    public long getFirstIntersectionInnerOffset() {
        return OsmAndCoreJNI.Street_firstIntersectionInnerOffset_get(this.swigCPtr, this);
    }

    public StreetGroup getStreetGroup() {
        long l = OsmAndCoreJNI.Street_streetGroup_get(this.swigCPtr, this);
        return l == 0L ? null : new StreetGroup(l, true);
    }

    public void setBuildings(SWIGTYPE_p_QListT_std__shared_ptrT_OsmAnd__Building_const_t_t sWIGTYPE_p_QListT_std__shared_ptrT_OsmAnd__Building_const_t_t) {
        OsmAndCoreJNI.Street_buildings_set(this.swigCPtr, this, SWIGTYPE_p_QListT_std__shared_ptrT_OsmAnd__Building_const_t_t.getCPtr(sWIGTYPE_p_QListT_std__shared_ptrT_OsmAnd__Building_const_t_t));
    }

    public SWIGTYPE_p_QListT_std__shared_ptrT_OsmAnd__Building_const_t_t getBuildings() {
        long l = OsmAndCoreJNI.Street_buildings_get(this.swigCPtr, this);
        return l == 0L ? null : new SWIGTYPE_p_QListT_std__shared_ptrT_OsmAnd__Building_const_t_t(l, false);
    }

    public void setIntersectedStreets(SWIGTYPE_p_QListT_std__shared_ptrT_OsmAnd__StreetIntersection_const_t_t sWIGTYPE_p_QListT_std__shared_ptrT_OsmAnd__StreetIntersection_const_t_t) {
        OsmAndCoreJNI.Street_intersectedStreets_set(this.swigCPtr, this, SWIGTYPE_p_QListT_std__shared_ptrT_OsmAnd__StreetIntersection_const_t_t.getCPtr(sWIGTYPE_p_QListT_std__shared_ptrT_OsmAnd__StreetIntersection_const_t_t));
    }

    public SWIGTYPE_p_QListT_std__shared_ptrT_OsmAnd__StreetIntersection_const_t_t getIntersectedStreets() {
        long l = OsmAndCoreJNI.Street_intersectedStreets_get(this.swigCPtr, this);
        return l == 0L ? null : new SWIGTYPE_p_QListT_std__shared_ptrT_OsmAnd__StreetIntersection_const_t_t(l, false);
    }
}

