/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf;

import com.google.protobuf.CodedOutputStream;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryHHRouteReaderAdapter;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapAddressReaderAdapter;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapPoiReaderAdapter;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.BinaryMapTransportReaderAdapter;
import net.osmand.binary.GeocodingUtilities;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.Amenity;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.QuadRect;
import net.osmand.data.Street;
import net.osmand.data.TransportRoute;
import net.osmand.data.TransportSchedule;
import net.osmand.data.TransportStop;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.MapRenderingTypes;
import net.osmand.osm.PoiType;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.router.RoutingContext;
import net.osmand.router.TransportRoutePlanner;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;

public class BinaryInspector {
    public static final int BUFFER_SIZE = 0x100000;
    public static final int SHIFT_ID = 6;
    protected static final boolean DETECT_POI_ADDRESS = false;
    private VerboseInfo vInfo;
    private static int OSM_ID = 1;

    public static void main(String[] args) throws IOException {
        BinaryInspector in = new BinaryInspector();
        if (args == null || args.length == 0) {
            BinaryInspector.printUsage(null);
            return;
        }
        if ("test".equals(args[0])) {
            in.inspector(new String[]{"-vpoi", System.getProperty("maps.dir") + "Andorra_europe.obf"});
        } else {
            in.inspector(args);
        }
    }

    private void printToFile(String s) throws IOException {
        if (this.vInfo.osmOut != null) {
            this.vInfo.osmOut.write(s.getBytes());
        } else {
            System.out.println(s);
        }
    }

    private void println(String s) {
        if (this.vInfo == null || !this.vInfo.osm || this.vInfo.osmOut != null) {
            System.out.println(s);
        }
    }

    private void print(String s) {
        if (this.vInfo == null || !this.vInfo.osm || this.vInfo.osmOut != null) {
            System.out.print(s);
        }
    }

    public void inspector(String[] args) throws IOException {
        String f = args[0];
        if (f.charAt(0) == '-') {
            if (f.equals("-c") || f.equals("-combine")) {
                if (args.length < 3) {
                    BinaryInspector.printUsage("Too few parameters to extract (require minimum 3)");
                } else {
                    ArrayList<FileExtractFrom> parts = new ArrayList<FileExtractFrom>();
                    FileExtractFrom lastPart = null;
                    String date = null;
                    for (int i = 2; i < args.length; ++i) {
                        if (args[i].startsWith("-") || args[i].startsWith("+")) {
                            String s;
                            int n;
                            int n2;
                            TreeSet<Integer> ts;
                            String[] st;
                            if (lastPart == null) {
                                System.err.println("Expected file name instead of " + args[i]);
                                return;
                            }
                            if (args[i].startsWith("--date")) {
                                date = args[i].replace("--date", "").replace("=", "");
                                continue;
                            }
                            if (args[i].startsWith("--") || args[i].startsWith("++")) {
                                st = args[i].substring(2).split(",");
                                ts = new TreeSet<Integer>();
                                String[] stringArray = st;
                                n2 = stringArray.length;
                                for (n = 0; n < n2; ++n) {
                                    s = stringArray[n];
                                    int t = 0;
                                    if (s.equals("address")) {
                                        t = 7;
                                    } else if (s.equals("routing")) {
                                        t = 9;
                                    } else if (s.equals("hhrouting")) {
                                        t = 10;
                                    } else if (s.equals("map")) {
                                        t = 6;
                                    } else if (s.equals("poi")) {
                                        t = 8;
                                    } else if (s.equals("transport")) {
                                        t = 4;
                                    } else {
                                        throw new IllegalArgumentException(s);
                                    }
                                    ts.add(t);
                                }
                                if (args[i].startsWith("-")) {
                                    lastPart.excludeIndex = ts;
                                    continue;
                                }
                                lastPart.includeIndex = ts;
                                continue;
                            }
                            st = args[i].substring(1).split(",");
                            ts = new TreeSet();
                            String[] stringArray = st;
                            n2 = stringArray.length;
                            for (n = 0; n < n2; ++n) {
                                s = stringArray[n];
                                ts.add(Integer.parseInt(s));
                            }
                            if (args[i].startsWith("-")) {
                                lastPart.excludeParts = ts;
                                continue;
                            }
                            lastPart.includeParts = ts;
                            continue;
                        }
                        File file = new File(args[i]);
                        if (!file.exists()) {
                            System.err.println("File to extract from doesn't exist " + args[i]);
                            return;
                        }
                        lastPart = new FileExtractFrom();
                        if (file.isDirectory()) {
                            for (File ch : file.listFiles()) {
                                if (!ch.getName().endsWith(".obf")) continue;
                                lastPart.from.add(ch);
                            }
                            Collections.sort(lastPart.from, new Comparator<File>(){

                                @Override
                                public int compare(File o1, File o2) {
                                    return o1.getName().compareTo(o2.getName());
                                }
                            });
                        } else {
                            lastPart.from.add(file);
                        }
                        if (lastPart.from.isEmpty()) continue;
                        parts.add(lastPart);
                    }
                    File to = new File(args[1]);
                    int partsS = BinaryInspector.combineParts(to, parts, date);
                    if (partsS > 0) {
                        this.println("\n" + partsS + " parts were successfully extracted to " + to.getName());
                    }
                }
            } else if (f.startsWith("-v") || f.startsWith("-osm") || f.startsWith("-zoom")) {
                if (args.length < 2) {
                    BinaryInspector.printUsage("Missing file parameter");
                } else {
                    this.vInfo = new VerboseInfo(args);
                    this.printFileInformation(args[args.length - 1]);
                    this.vInfo.close();
                }
            } else {
                BinaryInspector.printUsage("Unknown command : " + f);
            }
        } else {
            this.vInfo = null;
            this.printFileInformation(f);
        }
    }

    public static final void writeInt(CodedOutputStream ous, long v) throws IOException {
        if (v > Integer.MAX_VALUE) {
            ous.writeRawByte(v >> 54 & 0xFFL | 0x80L);
            ous.writeRawByte(v >> 48 & 0xFFL);
            ous.writeRawByte(v >> 40 & 0xFFL);
            ous.writeRawByte(v >> 32 & 0xFFL);
        }
        ous.writeRawByte(v >> 24 & 0xFFL);
        ous.writeRawByte(v >> 16 & 0xFFL);
        ous.writeRawByte(v >> 8 & 0xFFL);
        ous.writeRawByte(v & 0xFFL);
    }

    public static int combineParts(File fileToCreate, List<FileExtractFrom> partsToExtractFrom, String date) throws IOException {
        LinkedHashSet<CallSite> uniqueNames = new LinkedHashSet<CallSite>();
        int version = 2;
        FileOutputStream fout = new FileOutputStream(fileToCreate);
        CodedOutputStream ous = CodedOutputStream.newInstance((OutputStream)fout, (int)0x100000);
        byte[] BUFFER_TO_READ = new byte[0x100000];
        long dateCreated = System.currentTimeMillis();
        if (!Algorithms.isEmpty((CharSequence)date)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-ddHH:mm");
            try {
                Date d = dateFormat.parse(date);
                dateCreated = d.getTime();
            }
            catch (ParseException e) {
                System.err.println("Date is wrong! Right format is yyyy-MM-ddHH:mm");
            }
        }
        ous.writeInt32(1, version);
        ous.writeInt64(18, dateCreated);
        int parts = 0;
        for (FileExtractFrom extract : partsToExtractFrom) {
            for (File f : extract.from) {
                if (f.getAbsolutePath().equals(fileToCreate.getAbsolutePath())) {
                    System.err.println("Error : Input file is equal to output file " + f.getAbsolutePath());
                    continue;
                }
                RandomAccessFile raf = new RandomAccessFile(f.getAbsolutePath(), "r");
                BinaryMapIndexReader bmir = new BinaryMapIndexReader(raf, f);
                if (bmir.getVersion() != version) {
                    System.err.println("Error : Different input files has different input versions " + bmir.getVersion() + " != " + version);
                    continue;
                }
                for (int i = 0; i < bmir.getIndexes().size(); ++i) {
                    BinaryIndexPart part = (BinaryIndexPart)bmir.getIndexes().get(i);
                    int fieldNumber = part.getFieldNumber();
                    String uniqueName = fieldNumber + " " + part.getName();
                    int ind = i + 1;
                    if (extract.excludeParts != null && extract.excludeParts.contains(ind) || extract.includeParts != null && !extract.includeParts.contains(ind) || extract.excludeIndex != null && extract.excludeIndex.contains(fieldNumber) || extract.includeIndex != null && !extract.includeIndex.contains(fieldNumber)) continue;
                    if (!uniqueNames.add((CallSite)((Object)uniqueName))) {
                        System.out.printf("Skip %s %s from %s as duplicate \n", part.getPartName(), part.getName(), f.getName());
                        continue;
                    }
                    ++parts;
                    ous.writeTag(fieldNumber, 6);
                    BinaryInspector.writeInt(ous, part.getLength());
                    BinaryInspector.copyBinaryPart(ous, BUFFER_TO_READ, raf, part.getFilePointer(), part.getLength());
                    System.out.printf("%s %s from %s is extracted %,d bytes\n", part.getPartName(), part.getName(), f.getName(), part.getLength());
                }
                raf.close();
            }
        }
        ous.writeInt32(32, version);
        ous.flush();
        fout.close();
        return parts;
    }

    public static void copyBinaryPart(CodedOutputStream ous, byte[] BUFFER, RandomAccessFile raf, long fp, long length) throws IOException {
        int read;
        long old = raf.getFilePointer();
        raf.seek(fp);
        for (long toRead = length; toRead > 0L; toRead -= (long)read) {
            read = raf.read(BUFFER);
            if (read == -1) {
                throw new IllegalArgumentException("Unexpected end of file");
            }
            if (toRead < (long)read) {
                read = (int)toRead;
            }
            ous.writeRawBytes(BUFFER, 0, read);
        }
        raf.seek(old);
    }

    protected String formatBounds(int left, int right, int top, int bottom) {
        double l = MapUtils.get31LongitudeX((int)left);
        double r = MapUtils.get31LongitudeX((int)right);
        double t = MapUtils.get31LatitudeY((int)top);
        double b = MapUtils.get31LatitudeY((int)bottom);
        return this.formatLatBounds(l, r, t, b);
    }

    protected String formatLatBounds(double l, double r, double t, double b) {
        MessageFormat format = new MessageFormat("(left top - right bottom) : {0,number,#.####}, {1,number,#.####} NE - {2,number,#.####}, {3,number,#.####} NE", new Locale("EN", "US"));
        return format.format(new Object[]{l, t, r, b});
    }

    public void printFileInformation(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            this.println("Binary OsmAnd index " + fileName + " was not found.");
            return;
        }
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                if (!f.getName().endsWith(".obf")) continue;
                this.printFileInformation(f);
            }
        } else {
            this.printFileInformation(file);
        }
    }

    public void printFileInformation(File file) throws IOException {
        RandomAccessFile r = new RandomAccessFile(file.getAbsolutePath(), "r");
        this.printFileInformation(r, file);
    }

    public void printFileInformation(RandomAccessFile r, File file) throws IOException {
        String filename = file.getName();
        try {
            BinaryMapIndexReader index = new BinaryMapIndexReader(r, file);
            String owner = index.getOwner() != null ? "\n" + index.getOwner().toString() : "";
            int i = 1;
            this.println("Binary index " + filename + " version = " + index.getVersion() + " edition = " + String.valueOf(new Date(index.getDateCreated())) + owner);
            for (BinaryIndexPart p : index.getIndexes()) {
                String partname = p.getPartName();
                String name = p.getName() == null ? "" : p.getName();
                this.println(MessageFormat.format("{0} {1} data {3} - {2,number,#,###} bytes", i, partname, p.getLength(), name));
                if (p instanceof BinaryMapTransportReaderAdapter.TransportIndex) {
                    BinaryMapTransportReaderAdapter.TransportIndex ti = (BinaryMapTransportReaderAdapter.TransportIndex)p;
                    int sh = 7;
                    this.println("\tBounds " + this.formatBounds(ti.getLeft() << sh, ti.getRight() << sh, ti.getTop() << sh, ti.getBottom() << sh));
                    if (this.vInfo != null && this.vInfo.isVtransport()) {
                        this.printTransportDetailInfo(this.vInfo, index, (BinaryMapTransportReaderAdapter.TransportIndex)p);
                    }
                } else if (p instanceof BinaryHHRouteReaderAdapter.HHRouteRegion) {
                    ri = (BinaryHHRouteReaderAdapter.HHRouteRegion)p;
                    QuadRect rt = ri.getLatLonBbox();
                    this.println(String.format("\tBounds %s profile '%s' %s edition = %s", this.formatLatBounds(rt.left, rt.right, rt.top, rt.bottom), ri.profile, ri.profileParams, new Date(ri.edition)));
                    if (this.vInfo != null && this.vInfo.isVHHrouting()) {
                        TLongObjectHashMap pnts = index.initHHPoints(ri, (short)0, HHRouteDataStructure.NetworkDBPoint.class);
                        for (HHRouteDataStructure.NetworkDBPoint pnt : pnts.valueCollection()) {
                            System.out.println(String.format("\t\t %s - cluster %d (dual point %d, %d) - %d,%d -> %d,%d", pnt, pnt.clusterId, pnt.dualPoint == null ? 0 : pnt.dualPoint.index, pnt.dualPoint == null ? 0 : pnt.dualPoint.clusterId, pnt.startX, pnt.startY, pnt.endX, pnt.endY));
                        }
                    }
                } else if (p instanceof BinaryMapRouteReaderAdapter.RouteRegion) {
                    ri = (BinaryMapRouteReaderAdapter.RouteRegion)p;
                    this.println("\tBounds " + this.formatLatBounds(ri.getLeftLongitude(), ri.getRightLongitude(), ri.getTopLatitude(), ri.getBottomLatitude()));
                    if (this.vInfo != null && this.vInfo.isVrouting()) {
                        this.printRouteEncodingRules((BinaryMapRouteReaderAdapter.RouteRegion)ri);
                        this.printRouteDetailInfo(index, (BinaryMapRouteReaderAdapter.RouteRegion)p);
                    }
                } else if (p instanceof BinaryMapIndexReader.MapIndex) {
                    BinaryMapIndexReader.MapIndex m = (BinaryMapIndexReader.MapIndex)p;
                    int j = 1;
                    for (BinaryMapIndexReader.MapRoot mi : m.getRoots()) {
                        this.println(MessageFormat.format("\t{4}.{5} Map level minZoom = {0}, maxZoom = {1}, size = {2,number,#,###} bytes \n\t\tBounds {3}", mi.getMinZoom(), mi.getMaxZoom(), mi.getLength(), this.formatBounds(mi.getLeft(), mi.getRight(), mi.getTop(), mi.getBottom()), i, j++));
                    }
                    if (this.vInfo != null && this.vInfo.isVmap()) {
                        this.printMapDetailInfo(index, m);
                        this.printMapEncodingRules(m);
                    }
                } else if (p instanceof BinaryMapPoiReaderAdapter.PoiRegion && this.vInfo != null && this.vInfo.isVpoi()) {
                    this.printPOIDetailInfo(this.vInfo, index, (BinaryMapPoiReaderAdapter.PoiRegion)p);
                } else if (p instanceof BinaryMapAddressReaderAdapter.AddressRegion) {
                    List cities = ((BinaryMapAddressReaderAdapter.AddressRegion)p).getCities();
                    for (BinaryMapAddressReaderAdapter.CitiesBlock c : cities) {
                        this.println("\t" + i + "." + c.getType() + " Address part size=" + c.getLength() + " bytes");
                    }
                    if (this.vInfo != null && this.vInfo.isVaddress()) {
                        this.printAddressDetailedInfo(this.vInfo, index, (BinaryMapAddressReaderAdapter.AddressRegion)p);
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            System.err.println("File doesn't have valid structure : " + filename + " " + e.getMessage());
            throw e;
        }
    }

    private void printRouteEncodingRules(BinaryMapRouteReaderAdapter.RouteRegion ri) {
        final HashMap<Object, Integer> mp = new HashMap<Object, Integer>();
        int ind = 0;
        for (BinaryMapRouteReaderAdapter.RouteTypeRule rtr : ri.routeEncodingRules) {
            if (rtr == null) continue;
            Object t = rtr.getTag();
            if (((String)t).contains(":")) {
                t = ((String)t).substring(0, ((String)t).indexOf(":"));
            }
            if (mp.containsKey(t = (String)t + "-" + ind++)) {
                mp.put(t, (Integer)mp.get(t) + 1);
                continue;
            }
            mp.put(t, 1);
        }
        ArrayList tagvalues = new ArrayList(mp.keySet());
        tagvalues.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return -Integer.compare((Integer)mp.get(o1), (Integer)mp.get(o2));
            }
        });
        LinkedHashMap<String, Integer> fmt = new LinkedHashMap<String, Integer>();
        for (String key : tagvalues) {
            fmt.put(key, (Integer)mp.get(key));
        }
        this.println(String.format("\tEncoding rules %d (%d KB): %s", ri.routeEncodingRules.size(), ri.routeEncodingRulesBytes / 1024, ((Object)fmt).toString()));
    }

    private void printMapEncodingRules(BinaryMapIndexReader.MapIndex ri) {
        final HashMap<String, Integer> mp = new HashMap<String, Integer>();
        TIntObjectIterator it = ri.decodingRules.iterator();
        while (it.hasNext()) {
            it.advance();
            BinaryMapIndexReader.TagValuePair rtr = (BinaryMapIndexReader.TagValuePair)it.value();
            if (rtr == null) continue;
            String t = rtr.tag;
            if (t.contains(":")) {
                t = t.substring(0, t.indexOf(":"));
            }
            if (mp.containsKey(t)) {
                mp.put(t, (Integer)mp.get(t) + 1);
                continue;
            }
            mp.put(t, 1);
        }
        ArrayList tagvalues = new ArrayList(mp.keySet());
        tagvalues.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return -Integer.compare((Integer)mp.get(o1), (Integer)mp.get(o2));
            }
        });
        LinkedHashMap<String, Integer> fmt = new LinkedHashMap<String, Integer>();
        for (String key : tagvalues) {
            fmt.put(key, (Integer)mp.get(key));
        }
        this.println(String.format("\tEncoding rules %d (%d KB): %s", ri.decodingRules.size(), ri.encodingRulesSizeBytes / 1024, ((Object)fmt).toString()));
    }

    private void printRouteDetailInfo(BinaryMapIndexReader index, BinaryMapRouteReaderAdapter.RouteRegion p) throws IOException {
        final DamnCounter mapObjectsCounter = new DamnCounter();
        final StringBuilder b = new StringBuilder();
        List regions = index.searchRouteIndexTree(BinaryMapIndexReader.buildSearchRequest((int)MapUtils.get31TileNumberX((double)this.vInfo.lonleft), (int)MapUtils.get31TileNumberX((double)this.vInfo.lonright), (int)MapUtils.get31TileNumberY((double)this.vInfo.lattop), (int)MapUtils.get31TileNumberY((double)this.vInfo.latbottom), (int)this.vInfo.getZoom(), null), this.vInfo.getZoom() < 15 ? p.getBaseSubregions() : p.getSubregions());
        if (this.vInfo.osm) {
            this.printToFile("<?xml version='1.0' encoding='UTF-8'?>\n<osm version='0.6'>\n");
        }
        index.loadRouteIndexData(regions, (ResultMatcher)new ResultMatcher<RouteDataObject>(){

            public boolean publish(RouteDataObject obj) {
                int i;
                ++mapObjectsCounter.value;
                mapObjectsCounter.pntValue += obj.getPointsLength();
                if (BinaryInspector.this.vInfo.osm) {
                    b.setLength(0);
                    BinaryInspector.this.printOsmRouteDetails(obj, b);
                    try {
                        BinaryInspector.this.printToFile(b.toString());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                b.setLength(0);
                b.append("Road ");
                b.append(obj.id);
                b.append(" osmid ").append(obj.getId() >> 6);
                for (int i2 = 0; i2 < obj.getTypes().length; ++i2) {
                    BinaryMapRouteReaderAdapter.RouteTypeRule routeTypeRule = obj.region.quickGetEncodingRule(obj.getTypes()[i2]);
                    b.append(" ").append(routeTypeRule.getTag()).append("='").append(routeTypeRule.getValue()).append("'");
                }
                int[] nameIds = obj.getNameIds();
                if (nameIds != null) {
                    for (int key : nameIds) {
                        BinaryMapRouteReaderAdapter.RouteTypeRule rr = obj.region.quickGetEncodingRule(key);
                        b.append(" ").append(rr.getTag()).append("=\"").append((String)obj.getNames().get(key)).append("\"");
                    }
                }
                int n = obj.getPointsLength();
                if (obj.hasPointNames() || obj.hasPointTypes()) {
                    b.append(" pointtypes [");
                    for (i = 0; i < n; ++i) {
                        BinaryMapRouteReaderAdapter.RouteTypeRule rr;
                        int k;
                        String[] names = obj.getPointNames(i);
                        int[] nametypes = obj.getPointNameTypes(i);
                        int[] types = obj.getPointTypes(i);
                        if (types == null && names == null) continue;
                        b.append("[" + (i + 1) + ". ");
                        if (names != null) {
                            for (k = 0; k < names.length; ++k) {
                                rr = obj.region.quickGetEncodingRule(nametypes[k]);
                                b.append(rr.getTag()).append("=\"").append(names[k]).append("\" ");
                            }
                        }
                        if (types != null) {
                            for (k = 0; k < types.length; ++k) {
                                rr = obj.region.quickGetEncodingRule(types[k]);
                                b.append(rr.getTag()).append("='").append(rr.getValue()).append("' ");
                            }
                        }
                        if (BinaryInspector.this.vInfo.vmapCoordinates) {
                            float x = (float)MapUtils.get31LongitudeX((int)obj.getPoint31XTile(i));
                            float y = (float)MapUtils.get31LatitudeY((int)obj.getPoint31YTile(i));
                            b.append(y).append(" / ").append(x).append(" ");
                        }
                        b.append("]");
                    }
                    b.append("]");
                }
                if (obj.restrictions != null) {
                    b.append(" restrictions [");
                    for (i = 0; i < obj.restrictions.length; ++i) {
                        if (i > 0) {
                            b.append(", ");
                        }
                        b.append(obj.getRestrictionId(i)).append(" (").append(MapRenderingTypes.getRestrictionValue((int)obj.getRestrictionType(i))).append(")");
                        if (obj.getRestrictionVia(i) == 0L) continue;
                        b.append(" via ").append(obj.getRestrictionVia(i));
                    }
                    b.append(" ]");
                }
                if (BinaryInspector.this.vInfo.vmapCoordinates) {
                    b.append(" lat/lon : ");
                    for (i = 0; i < obj.getPointsLength(); ++i) {
                        float x = (float)MapUtils.get31LongitudeX((int)obj.getPoint31XTile(i));
                        float y = (float)MapUtils.get31LatitudeY((int)obj.getPoint31YTile(i));
                        b.append(y).append(" / ").append(x).append(" , ");
                    }
                }
                BinaryInspector.this.println(b.toString());
                return false;
            }

            public boolean isCancelled() {
                return false;
            }
        });
        this.println("\tTotal map objects: " + mapObjectsCounter.value + " points " + mapObjectsCounter.pntValue);
        if (this.vInfo.osm) {
            this.printToFile("</osm >\n");
        }
    }

    private void printAddressDetailedInfo(VerboseInfo verbose, BinaryMapIndexReader index, BinaryMapAddressReaderAdapter.AddressRegion region) throws IOException {
        String[] cityType_String = new String[]{"Cities/Towns section", "Postcodes section", "Villages section"};
        for (int j = 0; j < BinaryMapAddressReaderAdapter.CITY_TYPES.length; ++j) {
            int type = BinaryMapAddressReaderAdapter.CITY_TYPES[j];
            List cities = index.getCities(region, null, type);
            this.print(MessageFormat.format("\t{0}, {1,number,#} group(s)", cityType_String[j], cities.size()));
            if (1 == type) {
                if (!verbose.vstreetgroups && !verbose.vcities) {
                    this.println("");
                    continue;
                }
            } else if (!verbose.vstreetgroups) {
                this.println("");
                continue;
            }
            this.println(":");
            for (City c : cities) {
                int size = index.preloadStreets(c, null);
                ArrayList streets = new ArrayList(c.getStreets());
                Object name = c.getName(verbose.lang);
                if (verbose.vcitynames) {
                    boolean includeEnName = verbose.lang == null || !verbose.lang.equals("en");
                    name = (String)name + " " + c.getNamesMap(includeEnName).toString();
                }
                String cityDescription = type == 2 ? MessageFormat.format("\t\t''{0}'' {1,number,#} street(s) size {2,number,#} bytes", name, streets.size(), size) : MessageFormat.format("\t\t''{0}'' [{1,number,#}], {2,number,#} street(s) size {3,number,#} bytes", name, c.getId(), streets.size(), size);
                this.print(cityDescription);
                if (!verbose.vstreets) {
                    this.println("");
                    continue;
                }
                this.println(":");
                if (!verbose.contains((MapObject)c)) continue;
                for (Street t : streets) {
                    if (!verbose.contains((MapObject)t)) continue;
                    index.preloadBuildings(t, null);
                    List buildings = t.getBuildings();
                    List intersections = t.getIntersectedStreets();
                    this.println(MessageFormat.format("\t\t\t''{0}'' [{1,number,#}], {2,number,#} building(s), {3,number,#} intersections(s)", t.getName(verbose.lang), t.getId(), buildings.size(), intersections.size()));
                    if (buildings != null && !buildings.isEmpty() && verbose.vbuildings) {
                        this.println("\t\t\t\tBuildings:");
                        for (Building b : buildings) {
                            this.println("\t\t\t\t" + b.getName(verbose.lang) + (String)(b.getPostcode() == null ? "" : " postcode:" + b.getPostcode()));
                        }
                    }
                    if (intersections == null || intersections.isEmpty() || !verbose.vintersections) continue;
                    this.println("\t\t\t\tIntersects with:");
                    for (Street s : intersections) {
                        this.println("\t\t\t\t\t" + s.getName(verbose.lang));
                    }
                }
            }
        }
    }

    private void printMapDetailInfo(BinaryMapIndexReader index, BinaryMapIndexReader.MapIndex mapIndex) throws IOException {
        final StringBuilder b = new StringBuilder();
        final DamnCounter mapObjectsCounter = new DamnCounter();
        final MapStats mapObjectStats = new MapStats();
        if (this.vInfo.osm) {
            this.printToFile("<?xml version='1.0' encoding='UTF-8'?>\n<osm version='0.6'>\n");
        }
        if (this.vInfo.isVStats()) {
            BinaryMapIndexReader.READ_STATS = true;
        }
        BinaryMapIndexReader.SearchRequest req = BinaryMapIndexReader.buildSearchRequest((int)MapUtils.get31TileNumberX((double)this.vInfo.lonleft), (int)MapUtils.get31TileNumberX((double)this.vInfo.lonright), (int)MapUtils.get31TileNumberY((double)this.vInfo.lattop), (int)MapUtils.get31TileNumberY((double)this.vInfo.latbottom), (int)this.vInfo.getZoom(), (BinaryMapIndexReader.SearchFilter)new BinaryMapIndexReader.SearchFilter(){

            public boolean accept(TIntArrayList types, BinaryMapIndexReader.MapIndex index) {
                return true;
            }
        }, (ResultMatcher)new ResultMatcher<BinaryMapDataObject>(){

            public boolean publish(BinaryMapDataObject obj) {
                ++mapObjectsCounter.value;
                mapObjectsCounter.pntValue += obj.getPointsLength();
                if (BinaryInspector.this.vInfo.isVStats()) {
                    mapObjectStats.process(obj);
                } else if (BinaryInspector.this.vInfo.vmapObjects) {
                    b.setLength(0);
                    if (BinaryInspector.this.vInfo.osm) {
                        BinaryInspector.this.printOsmMapDetails(obj, b);
                        try {
                            BinaryInspector.this.printToFile(b.toString());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        BinaryInspector.printMapDetails(obj, b, BinaryInspector.this.vInfo.vmapCoordinates);
                        BinaryInspector.this.println(b.toString());
                    }
                }
                return false;
            }

            public boolean isCancelled() {
                return false;
            }
        });
        if (this.vInfo.vstats) {
            mapObjectStats.setReq((BinaryMapIndexReader.SearchRequest<BinaryMapDataObject>)req);
        }
        index.searchMapIndex(req, mapIndex);
        if (this.vInfo.osm) {
            this.printToFile("</osm >\n");
        }
        if (this.vInfo.vstats) {
            mapObjectStats.print();
        }
        this.println("\tTotal map objects: " + mapObjectsCounter.value);
    }

    public static void printMapDetails(BinaryMapDataObject obj, StringBuilder b, boolean vmapCoordinates) {
        BinaryMapIndexReader.TagValuePair pair;
        int j;
        boolean multipolygon;
        boolean bl = multipolygon = obj.getPolygonInnerCoordinates() != null && obj.getPolygonInnerCoordinates().length > 0;
        if (multipolygon) {
            b.append("Multipolygon");
        } else {
            b.append(obj.isArea() ? "Area" : (obj.getPointsLength() > 1 ? "Way" : "Point"));
        }
        int[] types = obj.getTypes();
        if (obj.isLabelSpecified()) {
            b.append(" ").append(new LatLon(MapUtils.get31LatitudeY((int)obj.getLabelY()), MapUtils.get31LongitudeX((int)obj.getLabelX())));
        }
        b.append(" types [");
        for (j = 0; j < types.length; ++j) {
            if (j > 0) {
                b.append(", ");
            }
            if ((pair = obj.getMapIndex().decodeType(types[j])) == null) {
                System.err.println("Type " + types[j] + "was not found");
                continue;
            }
            b.append(pair.toSimpleString() + " (" + types[j] + ")");
        }
        b.append("]");
        if (obj.getAdditionalTypes() != null && obj.getAdditionalTypes().length > 0) {
            b.append(" add_types [");
            for (j = 0; j < obj.getAdditionalTypes().length; ++j) {
                if (j > 0) {
                    b.append(", ");
                }
                if ((pair = obj.getMapIndex().decodeType(obj.getAdditionalTypes()[j])) == null) {
                    System.err.println("Type " + obj.getAdditionalTypes()[j] + "was not found");
                    continue;
                }
                b.append(pair.toSimpleString() + "(" + obj.getAdditionalTypes()[j] + ")");
            }
            b.append("]");
        }
        TIntObjectHashMap names = obj.getObjectNames();
        TIntArrayList order = obj.getNamesOrder();
        if (names != null && !names.isEmpty()) {
            b.append(" Names [");
            for (int j2 = 0; j2 < order.size(); ++j2) {
                BinaryMapIndexReader.TagValuePair pair2;
                if (j2 > 0) {
                    b.append(", ");
                }
                if ((pair2 = obj.getMapIndex().decodeType(order.get(j2))) == null) {
                    throw new NullPointerException("Type " + order.get(j2) + " was not found");
                }
                b.append(pair2.toSimpleString() + "(" + order.get(j2) + ")");
                b.append(" - ").append((String)names.get(order.get(j2)));
            }
            b.append("]");
        }
        b.append(" id ").append(obj.getId());
        b.append(" osmid ").append(obj.getId() >> 7);
        if (obj.getId() > 0x2000000000000L && obj.getId() < 0x40000000000L) {
            long wayId = (obj.getId() & 0x3FFFFFFFFFFFFL) >> 11;
            b.append(" (propagate from way: " + (wayId >>= 1) + ") ");
        }
        if (vmapCoordinates) {
            b.append(" lat/lon : ");
            for (int i = 0; i < obj.getPointsLength(); ++i) {
                float x = (float)MapUtils.get31LongitudeX((int)obj.getPoint31XTile(i));
                float y = (float)MapUtils.get31LatitudeY((int)obj.getPoint31YTile(i));
                b.append(y).append(" / ").append(x).append(" , ");
            }
        }
    }

    private void printOsmRouteDetails(RouteDataObject obj, StringBuilder b) {
        StringBuilder tags = new StringBuilder();
        int[] types = obj.getTypes();
        for (int j = 0; j < types.length; ++j) {
            BinaryMapRouteReaderAdapter.RouteTypeRule rt = obj.region.quickGetEncodingRule(types[j]);
            if (rt == null) {
                throw new NullPointerException("Type " + types[j] + "was not found");
            }
            String value = this.quoteName(rt.getValue());
            tags.append("\t<tag k='").append(rt.getTag()).append("' v='").append(value).append("' />\n");
        }
        TIntObjectHashMap names = obj.getNames();
        if (names != null && !names.isEmpty()) {
            int[] keys = names.keys();
            for (int j = 0; j < keys.length; ++j) {
                BinaryMapRouteReaderAdapter.RouteTypeRule rt = obj.region.quickGetEncodingRule(keys[j]);
                if (rt == null) {
                    throw new NullPointerException("Type " + keys[j] + "was not found");
                }
                String name = this.quoteName((String)names.get(keys[j]));
                tags.append("\t<tag k='").append(rt.getTag()).append("' v='").append(name).append("' />\n");
            }
        }
        tags.append("\t<tag k='").append("original_id").append("' v='").append(obj.getId() >> 6).append("'/>\n");
        tags.append("\t<tag k='").append("osmand_id").append("' v='").append(obj.getId()).append("'/>\n");
        TLongArrayList ids = new TLongArrayList();
        for (int i = 0; i < obj.getPointsLength(); ++i) {
            int id;
            float lon = (float)MapUtils.get31LongitudeX((int)obj.getPoint31XTile(i));
            float lat = (float)MapUtils.get31LatitudeY((int)obj.getPoint31YTile(i));
            ++OSM_ID;
            b.append("\t<node id = '" + id + "' version='1' lat='" + lat + "' lon='" + lon + "' >\n");
            if (obj.getPointNames(i) != null) {
                String[] vs = obj.getPointNames(i);
                int[] keys = obj.getPointNameTypes(i);
                for (int j = 0; j < keys.length; ++j) {
                    BinaryMapRouteReaderAdapter.RouteTypeRule rt = obj.region.quickGetEncodingRule(keys[j]);
                    String name = this.quoteName(vs[j]);
                    b.append("\t\t<tag k='").append(rt.getTag()).append("' v='").append(name).append("' />\n");
                }
            }
            if (obj.getPointTypes(i) != null) {
                int[] keys = obj.getPointTypes(i);
                for (int j = 0; j < keys.length; ++j) {
                    BinaryMapRouteReaderAdapter.RouteTypeRule rt = obj.region.quickGetEncodingRule(keys[j]);
                    String value = this.quoteName(rt.getValue());
                    b.append("\t\t<tag k='").append(rt.getTag()).append("' v='").append(value).append("' />\n");
                }
            }
            b.append("\t</node >\n");
            ids.add((long)id);
        }
        long idway = this.printWay(ids, b, tags);
        if (obj.getRestrictionLength() > 0) {
            for (int i = 0; i < obj.getRestrictionLength(); ++i) {
                int id;
                long ld = obj.getRestrictionId(i);
                String tp = MapRenderingTypes.getRestrictionValue((int)obj.getRestrictionType(i));
                ++OSM_ID;
                b.append("<relation id = '" + id + "' version='1'>\n");
                b.append("\t<member ref='").append(idway).append("' role='from' type='way' />\n");
                b.append("\t<tag k='").append("from_osmand_id").append("' v='").append(obj.getId()).append("' />\n");
                b.append("\t<tag k='").append("from_id").append("' v='").append(obj.getId() >> 6).append("' />\n");
                b.append("\t<tag k='").append("to_osmand_id").append("' v='").append(ld).append("' />\n");
                b.append("\t<tag k='").append("to_id").append("' v='").append(ld >> 6).append("' />\n");
                b.append("\t<tag k='").append("type").append("' v='").append("restriction").append("' />\n");
                b.append("\t<tag k='").append("restriction").append("' v='").append(tp).append("' />\n");
                b.append("</relation>\n");
            }
        }
    }

    private String quoteName(String name) {
        if (name == null || name.length() == 0) {
            return "EMPTY";
        }
        name = name.replace("'", "&apos;");
        name = name.replace("<", "&lt;");
        name = name.replace(">", "&gt;");
        name = name.replace("&", "&amp;");
        return name;
    }

    private void printOsmMapDetails(BinaryMapDataObject obj, StringBuilder b) {
        TIntObjectHashMap names;
        int j;
        boolean multipolygon = obj.getPolygonInnerCoordinates() != null && obj.getPolygonInnerCoordinates().length > 0;
        boolean point = obj.getPointsLength() == 1;
        StringBuilder tags = new StringBuilder();
        int[] types = obj.getTypes();
        for (j = 0; j < types.length; ++j) {
            BinaryMapIndexReader.TagValuePair pair = obj.getMapIndex().decodeType(types[j]);
            if (pair == null) {
                throw new NullPointerException("Type " + types[j] + "was not found");
            }
            tags.append("\t<tag k='").append(pair.tag).append("' v='").append(this.quoteName(pair.value)).append("' />\n");
        }
        if (obj.getAdditionalTypes() != null && obj.getAdditionalTypes().length > 0) {
            for (j = 0; j < obj.getAdditionalTypes().length; ++j) {
                int addtype = obj.getAdditionalTypes()[j];
                BinaryMapIndexReader.TagValuePair pair = obj.getMapIndex().decodeType(addtype);
                if (pair == null) {
                    throw new NullPointerException("Type " + obj.getAdditionalTypes()[j] + "was not found");
                }
                tags.append("\t<tag k='").append(pair.tag).append("' v='").append(this.quoteName(pair.value)).append("' />\n");
            }
        }
        if ((names = obj.getObjectNames()) != null && !names.isEmpty()) {
            int[] keys = names.keys();
            for (int j2 = 0; j2 < keys.length; ++j2) {
                BinaryMapIndexReader.TagValuePair pair = obj.getMapIndex().decodeType(keys[j2]);
                if (pair == null) {
                    throw new NullPointerException("Type " + keys[j2] + "was not found");
                }
                String name = (String)names.get(keys[j2]);
                name = this.quoteName(name);
                tags.append("\t<tag k='").append(pair.tag).append("' v='").append(name).append("' />\n");
            }
        }
        tags.append("\t<tag k='").append("original_id").append("' v='").append(obj.getId() >> 7).append("'/>\n");
        tags.append("\t<tag k='").append("osmand_id").append("' v='").append(obj.getId()).append("'/>\n");
        if (point) {
            float lon = (float)MapUtils.get31LongitudeX((int)obj.getPoint31XTile(0));
            float lat = (float)MapUtils.get31LatitudeY((int)obj.getPoint31YTile(0));
            b.append("<node id = '" + OSM_ID++ + "' version='1' lat='" + lat + "' lon='" + lon + "' >\n");
            b.append((CharSequence)tags);
            b.append("</node>\n");
        } else {
            int id;
            TLongArrayList innerIds = new TLongArrayList();
            TLongArrayList ids = new TLongArrayList();
            for (int i = 0; i < obj.getPointsLength(); ++i) {
                float lon = (float)MapUtils.get31LongitudeX((int)obj.getPoint31XTile(i));
                float lat = (float)MapUtils.get31LatitudeY((int)obj.getPoint31YTile(i));
                ++OSM_ID;
                b.append("\t<node id = '" + id + "' version='1' lat='" + lat + "' lon='" + lon + "' />\n");
                ids.add((long)id);
            }
            long outerId = this.printWay(ids, b, multipolygon ? null : tags);
            if (multipolygon) {
                int[][] polygonInnerCoordinates = obj.getPolygonInnerCoordinates();
                for (int j3 = 0; j3 < polygonInnerCoordinates.length; ++j3) {
                    ids.clear();
                    for (int i = 0; i < polygonInnerCoordinates[j3].length; i += 2) {
                        int id2;
                        float lon = (float)MapUtils.get31LongitudeX((int)polygonInnerCoordinates[j3][i]);
                        float lat = (float)MapUtils.get31LatitudeY((int)polygonInnerCoordinates[j3][i + 1]);
                        ++OSM_ID;
                        b.append("<node id = '" + id2 + "' version='1' lat='" + lat + "' lon='" + lon + "' />\n");
                        ids.add((long)id2);
                    }
                    innerIds.add(this.printWay(ids, b, null));
                }
                id = OSM_ID++;
                b.append("<relation id = '" + id + "' version='1'>\n");
                b.append((CharSequence)tags);
                b.append("\t<member type='way' role='outer' ref= '" + outerId + "'/>\n");
                for (long ref : innerIds) {
                    b.append("<member type='way' role='inner' ref= '" + ref + "'/>\n");
                }
                b.append("</relation>\n");
            }
        }
    }

    private long printWay(TLongArrayList ids, StringBuilder b, StringBuilder tags) {
        int id = OSM_ID++;
        b.append("<way id = '" + id + "' version='1'>\n");
        if (tags != null) {
            b.append((CharSequence)tags);
        }
        for (long ref : ids) {
            b.append("\t<nd ref = '" + ref + "'/>\n");
        }
        b.append("</way>\n");
        return id;
    }

    private void printTransportDetailInfo(VerboseInfo verbose, BinaryMapIndexReader index, BinaryMapTransportReaderAdapter.TransportIndex p) throws IOException {
        BinaryMapIndexReader.SearchRequest sr = BinaryMapIndexReader.buildSearchTransportRequest((int)MapUtils.get31TileNumberX((double)verbose.lonleft), (int)MapUtils.get31TileNumberX((double)verbose.lonright), (int)MapUtils.get31TileNumberY((double)verbose.lattop), (int)MapUtils.get31TileNumberY((double)verbose.latbottom), (int)-1, null);
        List stops = index.searchTransportIndex(sr);
        LinkedHashMap<Long, TransportRoute> rs = new LinkedHashMap<Long, TransportRoute>();
        ArrayList<CallSite> lrs = new ArrayList<CallSite>();
        this.println("\nStops:");
        for (TransportStop s : stops) {
            lrs.clear();
            for (long pnt : s.getReferencesToRoutes()) {
                TransportRoute route;
                if (!rs.containsKey(pnt)) {
                    TLongObjectHashMap pts = index.getTransportRoutes(new long[]{pnt});
                    route = (TransportRoute)pts.valueCollection().iterator().next();
                    rs.put(pnt, route);
                } else {
                    route = (TransportRoute)rs.get(pnt);
                }
                if (route == null) continue;
                lrs.add((CallSite)((Object)(route.getRef() + " " + route.getType())));
            }
            if (s.getDeletedRoutesIds() != null) {
                for (long l : s.getDeletedRoutesIds()) {
                    lrs.add((CallSite)((Object)(" -" + l / 2L)));
                }
            }
            String exitsString = s.getExitsString();
            this.println("  " + s.getName(verbose.lang) + ": " + String.valueOf(lrs) + " " + String.valueOf(s.getLocation()) + exitsString + " " + s.getId());
        }
        this.println("\nRoutes:");
        for (TransportRoute st : rs.values()) {
            TransportSchedule sc;
            ArrayList<String> stopsString = new ArrayList<String>();
            for (TransportStop stop : st.getForwardStops()) {
                stopsString.add(stop.getName(verbose.lang));
            }
            Map tags = st.getTags();
            StringBuilder tagString = new StringBuilder();
            if (tags != null) {
                for (Map.Entry tag : tags.entrySet()) {
                    tagString.append((String)tag.getKey()).append(":").append((String)tag.getValue()).append(" ");
                }
            }
            this.println("  " + st.getRef() + " " + st.getType() + " " + st.getName(verbose.lang) + ": " + String.valueOf(stopsString) + " " + String.valueOf(tagString));
            if (!verbose.vtransportschedule || (sc = st.getSchedule()) == null) continue;
            StringBuilder bld = new StringBuilder();
            int[] tripIntervalsList = sc.getTripIntervals();
            int prevTime = 0;
            for (int i : tripIntervalsList) {
                String tm = TransportRoutePlanner.formatTransportTime((int)(i += prevTime));
                bld.append(tm);
                prevTime = i;
            }
            this.println("   " + bld.toString());
            bld = new StringBuilder();
            int atm = tripIntervalsList[0];
            int[] avgStopIntervals = sc.getAvgStopIntervals();
            int[] avgWaitIntervals = sc.getAvgWaitIntervals();
            for (int k = 0; k < st.getForwardStops().size(); ++k) {
                TransportStop stp = (TransportStop)st.getForwardStops().get(k);
                if (k == 0) {
                    bld.append(String.format("%6.6s %s, ", stp.getName(), TransportRoutePlanner.formatTransportTime((int)atm)));
                    continue;
                }
                atm += avgStopIntervals[k - 1];
                if (avgWaitIntervals.length > k && avgWaitIntervals[k] > 0) {
                    bld.append(String.format("%6.6s %s - %s, ", stp.getName(), TransportRoutePlanner.formatTransportTime((int)atm), TransportRoutePlanner.formatTransportTime((int)(avgWaitIntervals[k] + atm))));
                    continue;
                }
                bld.append(String.format("%6.6s %s, ", stp.getName(), TransportRoutePlanner.formatTransportTime((int)atm)));
            }
            this.println("   " + bld.toString());
        }
    }

    private void printPOIDetailInfo(VerboseInfo verbose, BinaryMapIndexReader index, BinaryMapPoiReaderAdapter.PoiRegion p) throws IOException {
        final int[] count = new int[3];
        RoutingContext ctx = GeocodingUtilities.buildDefaultContextForPOI((BinaryMapIndexReader)index);
        GeocodingUtilities geocodingUtilities = new GeocodingUtilities();
        BinaryMapIndexReader.SearchRequest req = BinaryMapIndexReader.buildSearchPoiRequest((int)MapUtils.get31TileNumberX((double)verbose.lonleft), (int)MapUtils.get31TileNumberX((double)verbose.lonright), (int)MapUtils.get31TileNumberY((double)verbose.lattop), (int)MapUtils.get31TileNumberY((double)verbose.latbottom), (int)verbose.getZoom(), (BinaryMapIndexReader.SearchPoiTypeFilter)BinaryMapIndexReader.ACCEPT_ALL_POI_TYPE_FILTER, (ResultMatcher)new ResultMatcher<Amenity>(){

            public boolean publish(Amenity amenity) {
                Map tagGroups;
                count[0] = count[0] + 1;
                Object s = String.valueOf(amenity.printNamesAndAdditional());
                long id = amenity.getId();
                if (id > 0L) {
                    id >>= 1;
                }
                if ((tagGroups = amenity.getTagGroups()) != null) {
                    s = (String)s + " cities:";
                    for (Map.Entry entry : tagGroups.entrySet()) {
                        s = (String)s + "[";
                        for (BinaryMapIndexReader.TagValuePair p : (List)entry.getValue()) {
                            s = (String)s + p.tag + "=" + p.value + " ";
                        }
                        s = (String)s + "]";
                    }
                }
                BinaryInspector.this.println(amenity.getType().getKeyName() + ": " + amenity.getSubType() + " " + amenity.getName() + " " + String.valueOf(amenity.getLocation()) + " osmid=" + id + " " + (String)s);
                if (!Algorithms.isEmpty((CharSequence)amenity.getStreetName())) {
                    count[1] = count[1] + 1;
                } else if (!Algorithms.isEmpty((CharSequence)amenity.getName())) {
                    count[2] = count[2] + 1;
                }
                return false;
            }

            public boolean isCancelled() {
                return false;
            }
        });
        index.initCategories(p);
        this.println("\tRegion: " + p.getName());
        this.println("\t\tBounds " + this.formatLatBounds(MapUtils.get31LongitudeX((int)p.getLeft31()), MapUtils.get31LongitudeX((int)p.getRight31()), MapUtils.get31LatitudeY((int)p.getTop31()), MapUtils.get31LatitudeY((int)p.getBottom31())));
        this.println("\t\tCategories:");
        List cs = p.getCategories();
        List subcategories = p.getSubcategories();
        for (int i = 0; i < cs.size(); ++i) {
            this.println(String.format("\t\t\t%s (%d): %s", cs.get(i), ((List)subcategories.get(i)).size(), subcategories.get(i)));
        }
        this.println("\t\tPOI Additionals:");
        List subtypes = p.getSubTypes();
        TreeSet<String> text = new TreeSet<String>();
        TreeSet<String> refs = new TreeSet<String>();
        TreeMap singleValues = new TreeMap();
        int singleVals = 0;
        MapPoiTypes poiTypes = MapPoiTypes.getDefault();
        for (int i = 0; i < subtypes.size(); ++i) {
            BinaryMapPoiReaderAdapter.PoiSubType st = (BinaryMapPoiReaderAdapter.PoiSubType)subtypes.get(i);
            if (st.text) {
                PoiType ref = poiTypes.getPoiTypeByKey(st.name);
                if (ref != null && !ref.isAdditional()) {
                    refs.add(st.name);
                    continue;
                }
                text.add(st.name);
                continue;
            }
            if (st.possibleValues.size() == 1) {
                ++singleVals;
                int lastIndexOf = st.name.lastIndexOf(95);
                String key = st.name;
                if (lastIndexOf >= 0) {
                    key = key.substring(0, lastIndexOf);
                }
                if (!singleValues.containsKey(key)) {
                    singleValues.put(key, new ArrayList());
                }
                ((List)singleValues.get(key)).add(st.name);
                continue;
            }
            this.println(String.format("\t\t\t%s (%d): %s", st.name, st.possibleValues.size(), st.possibleValues));
        }
        StringBuilder singleValuesFmt = new StringBuilder();
        for (String key : singleValues.keySet()) {
            singleValuesFmt.append(key + " (" + ((List)singleValues.get(key)).size() + "), ");
        }
        this.println(String.format("\t\t\tReference to another poi (incorrect?) (%d): %s", refs.size(), refs));
        this.println(String.format("\t\t\tText based (%d): %s", text.size(), text));
        this.println(String.format("\t\t\tSingle value filters (%d): %s", singleVals, singleValuesFmt));
        index.searchPoi(p, req);
        this.println(String.format("Found %d pois (%d with addr, %d with name without addr)", count[0], count[1], count[2]));
    }

    public static void printUsage(String warning) {
        if (warning != null) {
            System.out.println(warning);
        }
        System.out.println("Inspector is console utility for working with binary indexes of OsmAnd.");
        System.out.println("It allows print info about file, extract parts and merge indexes.");
        System.out.println("\nUsage for print info : inspector [-vaddress] [-vcities] [-vcitynames] [-vstreetgroups] [-vstreets] [-vbuildings] [-vintersections] [-vmap] [-vstats] [-vmapobjects] [-vmapcoordinates] [-osm] [-vpoi] [-vrouting] [-vhhrouting] [-vtransport] [-zoom=Zoom] [-bbox=LeftLon,TopLat,RightLon,BottomLat] [file]");
        System.out.println("  Prints information about [file] binary index of OsmAnd.");
        System.out.println("  -v.. more verbose output (like all cities and their streets or all map objects with tags/values and coordinates)");
        System.out.println("\nUsage for combining indexes : inspector -c file_to_create (file_from_extract ((+|-)parts_to_extract)? )* [--date=...]");
        System.out.println("\tCreate new file of extracted parts from input file. [parts_to_extract] could be parts to include or exclude.");
        System.out.println("\nUse optional argument --date=YYYY-MM-DDhh:mm to specify exact edition-date of the output file\n");
        System.out.println("  Example : inspector -c output_file input_file +1,2,3\n\tExtracts 1, 2, 3 parts (could be find in print info)");
        System.out.println("  Example : inspector -c output_file input_file -2,3\n\tExtracts all parts excluding 2, 3");
        System.out.println("  Example : inspector -c output_file input_file1 input_file2 input_file3\n\tSimply combine 3 files");
        System.out.println("  Example : inspector -c output_file input_file1 input_file2 -4\n\tCombine all parts of 1st file and all parts excluding 4th part of 2nd file");
        System.out.println("  Example : inspector -c output_file input_file1 +routing\n\tCopy only routing parts (supports address, poi, routing, hhrouting, transport, map)");
    }

    protected static class VerboseInfo {
        boolean vaddress;
        boolean vcities;
        boolean vcitynames;
        boolean vstreetgroups;
        boolean vstreets;
        boolean vbuildings;
        boolean vintersections;
        boolean vtransport;
        boolean vtransportschedule;
        boolean vpoi;
        boolean vmap;
        boolean vrouting;
        boolean vhhrouting;
        boolean vmapObjects;
        boolean vmapCoordinates;
        boolean vstats;
        boolean osm;
        FileOutputStream osmOut = null;
        double lattop = 85.0;
        double latbottom = -85.0;
        double lonleft = -179.9;
        double lonright = 179.9;
        String lang = null;
        int zoom = 15;

        public boolean isVaddress() {
            return this.vaddress;
        }

        public int getZoom() {
            return this.zoom;
        }

        public boolean isVmap() {
            return this.vmap;
        }

        public boolean isVrouting() {
            return this.vrouting;
        }

        public boolean isVpoi() {
            return this.vpoi;
        }

        public boolean isVHHrouting() {
            return this.vhhrouting;
        }

        public boolean isVtransport() {
            return this.vtransport;
        }

        public boolean isVStats() {
            return this.vstats;
        }

        public VerboseInfo(String[] params) throws FileNotFoundException {
            for (int i = 0; i < params.length; ++i) {
                String[] values;
                if (params[i].equals("-vaddress")) {
                    this.vaddress = true;
                    continue;
                }
                if (params[i].equals("-vstreets")) {
                    this.vstreets = true;
                    continue;
                }
                if (params[i].equals("-vstreetgroups")) {
                    this.vstreetgroups = true;
                    continue;
                }
                if (params[i].equals("-vcities")) {
                    this.vcities = true;
                    continue;
                }
                if (params[i].equals("-vcitynames")) {
                    this.vcitynames = true;
                    continue;
                }
                if (params[i].equals("-vbuildings")) {
                    this.vbuildings = true;
                    continue;
                }
                if (params[i].equals("-vintersections")) {
                    this.vintersections = true;
                    continue;
                }
                if (params[i].equals("-vmap")) {
                    this.vmap = true;
                    continue;
                }
                if (params[i].equals("-vstats")) {
                    this.vstats = true;
                    continue;
                }
                if (params[i].equals("-vrouting")) {
                    this.vrouting = true;
                    continue;
                }
                if (params[i].equals("-vhhrouting")) {
                    this.vhhrouting = true;
                    continue;
                }
                if (params[i].equals("-vmapobjects")) {
                    this.vmapObjects = true;
                    continue;
                }
                if (params[i].equals("-vmapcoordinates")) {
                    this.vmapCoordinates = true;
                    continue;
                }
                if (params[i].equals("-vpoi")) {
                    this.vpoi = true;
                    continue;
                }
                if (params[i].startsWith("-osm")) {
                    this.osm = true;
                    if (!params[i].startsWith("-osm=")) continue;
                    this.osmOut = new FileOutputStream(params[i].substring(5));
                    continue;
                }
                if (params[i].equals("-vtransport")) {
                    this.vtransport = true;
                    continue;
                }
                if (params[i].equals("-vtransportschedule")) {
                    this.vtransportschedule = true;
                    continue;
                }
                if (params[i].startsWith("-lang=")) {
                    this.lang = params[i].substring("-lang=".length());
                    continue;
                }
                if (params[i].startsWith("-zoom=")) {
                    this.zoom = Integer.parseInt(params[i].substring("-zoom=".length()));
                    continue;
                }
                if (params[i].startsWith("-latlon=")) {
                    values = params[i].substring("-latlon=".length()).split(",");
                    double latmid = Double.parseDouble(values[0]);
                    double lonmid = Double.parseDouble(values[1]);
                    double dist = 0.005;
                    if (values.length > 2) {
                        dist = Double.parseDouble(values[2]);
                    }
                    this.lonleft = lonmid - dist;
                    this.lattop = latmid + dist;
                    this.lonright = lonmid + dist;
                    this.latbottom = latmid - dist;
                    continue;
                }
                if (params[i].startsWith("-xyz=")) {
                    values = params[i].substring("-xyz=".length()).split(",");
                    int tileX = Integer.parseInt(values[0]);
                    int tileY = Integer.parseInt(values[1]);
                    int z = Integer.parseInt(values[2]);
                    this.lonleft = MapUtils.getLongitudeFromTile((double)z, (double)tileX);
                    this.lonright = MapUtils.getLongitudeFromTile((double)z, (double)(tileX + 1));
                    this.lattop = MapUtils.getLatitudeFromTile((float)z, (double)tileY);
                    this.latbottom = MapUtils.getLatitudeFromTile((float)z, (double)(tileY + 1));
                    continue;
                }
                if (!params[i].startsWith("-bbox=")) continue;
                values = params[i].substring("-bbox=".length()).split(",");
                this.lonleft = Double.parseDouble(values[0]);
                this.lattop = Double.parseDouble(values[1]);
                this.lonright = Double.parseDouble(values[2]);
                this.latbottom = Double.parseDouble(values[3]);
            }
        }

        public boolean contains(MapObject o) {
            return this.lattop >= o.getLocation().getLatitude() && this.latbottom <= o.getLocation().getLatitude() && this.lonleft <= o.getLocation().getLongitude() && this.lonright >= o.getLocation().getLongitude();
        }

        public void close() throws IOException {
            if (this.osmOut != null) {
                this.osmOut.close();
                this.osmOut = null;
            }
        }
    }

    public static class FileExtractFrom {
        public List<File> from = new ArrayList<File>();
        public Set<Integer> excludeParts;
        public Set<Integer> includeParts;
        public Set<Integer> excludeIndex;
        public Set<Integer> includeIndex;
    }

    private static class DamnCounter {
        int value;
        int pntValue;

        private DamnCounter() {
        }
    }

    private class MapStats {
        public int lastStringNamesSize;
        public int lastObjectIdSize;
        public int lastObjectHeaderInfo;
        public int lastObjectAdditionalTypes;
        public int lastObjectTypes;
        public int lastObjectCoordinates;
        public int lastObjectCoordinatesCount;
        public int lastObjectLabelCoordinates;
        public int lastObjectSize;
        private Map<String, MapStatKey> types = new LinkedHashMap<String, MapStatKey>();
        private BinaryMapIndexReader.SearchRequest<BinaryMapDataObject> req;

        private MapStats() {
        }

        public void processKey(String simpleString, BinaryMapIndexReader.MapObjectStat st, TIntObjectHashMap<String> objectNames, int coordinates, boolean names) {
            TIntObjectIterator it = objectNames.iterator();
            int nameLen = 0;
            while (it.hasNext()) {
                it.advance();
                ++nameLen;
                nameLen += ((String)it.value()).length();
            }
            if (!this.types.containsKey(simpleString)) {
                MapStatKey stt = new MapStatKey();
                stt.key = simpleString;
                this.types.put(simpleString, stt);
            }
            MapStatKey key = this.types.get(simpleString);
            if (names) {
                key.namesLength += nameLen;
            } else {
                key.statCoordinates += (long)st.lastObjectCoordinates;
                key.statCoordinatesCount += (long)coordinates;
                key.statObjectSize += (long)st.lastObjectSize;
                ++key.count;
            }
        }

        public void process(BinaryMapDataObject obj) {
            boolean names;
            BinaryMapIndexReader.MapObjectStat st = this.req.getStat();
            int cnt = 0;
            boolean bl = names = st.lastObjectCoordinates == 0;
            if (!names) {
                this.lastStringNamesSize += st.lastStringNamesSize;
                this.lastObjectIdSize += st.lastObjectIdSize;
                this.lastObjectHeaderInfo += st.lastObjectHeaderInfo;
                this.lastObjectAdditionalTypes += st.lastObjectAdditionalTypes;
                this.lastObjectTypes += st.lastObjectTypes;
                this.lastObjectCoordinates += st.lastObjectCoordinates;
                this.lastObjectLabelCoordinates += st.lastObjectLabelCoordinates;
                cnt = obj.getPointsLength();
                this.lastObjectSize += st.lastObjectSize;
                if (obj.getPolygonInnerCoordinates() != null) {
                    for (int[] i : obj.getPolygonInnerCoordinates()) {
                        cnt += i.length;
                    }
                }
                this.lastObjectCoordinatesCount += cnt;
            }
            for (int i = 0; i < obj.getTypes().length; ++i) {
                int tp = obj.getTypes()[i];
                BinaryMapIndexReader.TagValuePair pair = obj.getMapIndex().decodeType(tp);
                if (pair == null) continue;
                this.processKey(pair.toSimpleString(), st, (TIntObjectHashMap<String>)obj.getObjectNames(), cnt, names);
            }
            st.clearObjectStats();
            st.lastObjectSize = 0;
        }

        public void print() {
            BinaryMapIndexReader.MapObjectStat st = this.req.getStat();
            BinaryInspector.this.println("MAP BLOCK INFO:");
            long b = 0L;
            b += this.out("Header", st.lastBlockHeaderInfo);
            b += this.out("String table", st.lastBlockStringTableSize);
            this.out("TOTAL", b += this.out("Map Objects", this.lastObjectSize));
            BinaryInspector.this.println("\nMAP OBJECTS INFO:");
            b = 0L;
            b += this.out("Header", this.lastObjectHeaderInfo);
            b += this.out("Coordinates", this.lastObjectCoordinates);
            b += this.out("Label coordinates", this.lastObjectLabelCoordinates);
            b += this.out("Coordinates Count (pairs)", this.lastObjectCoordinatesCount);
            b += this.out("Types", this.lastObjectTypes);
            b += this.out("Additonal Types", this.lastObjectAdditionalTypes);
            b += this.out("Ids", this.lastObjectIdSize);
            this.out("TOTAL", b += this.out("String names", this.lastStringNamesSize));
            BinaryInspector.this.println("\n\nOBJECT BY TYPE STATS: ");
            ArrayList<MapStatKey> stats = new ArrayList<MapStatKey>(this.types.values());
            Collections.sort(stats, new Comparator<MapStatKey>(){

                @Override
                public int compare(MapStatKey o1, MapStatKey o2) {
                    return this.compare(o1.statObjectSize, o2.statObjectSize);
                }

                @Override
                public int compare(long x, long y) {
                    return -Long.compare(x, y);
                }
            });
            for (MapStatKey s : stats) {
                BinaryInspector.this.println(String.format("%-35s [%7d] %8d KB: coord [%7d] %8d KB, names %8d KB  ", s.key, s.count, s.statObjectSize >> 10, s.statCoordinatesCount, s.statCoordinates >> 10, s.namesLength >> 10));
            }
        }

        private long out(String s, long i) {
            while (((String)s).length() < 25) {
                s = (String)s + " ";
            }
            DecimalFormat df = new DecimalFormat("0,000,000,000");
            BinaryInspector.this.println((String)s + ": " + df.format(i));
            return i;
        }

        public void setReq(BinaryMapIndexReader.SearchRequest<BinaryMapDataObject> req) {
            this.req = req;
        }
    }

    private static class MapStatKey {
        String key = "";
        long statCoordinates;
        long statCoordinatesCount;
        long statObjectSize;
        int count;
        int namesLength;

        private MapStatKey() {
        }
    }
}

