/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji;

import com.atilika.kuromoji.TokenBase;
import com.atilika.kuromoji.dict.CharacterDefinitions;
import com.atilika.kuromoji.dict.ConnectionCosts;
import com.atilika.kuromoji.dict.Dictionary;
import com.atilika.kuromoji.dict.InsertedDictionary;
import com.atilika.kuromoji.dict.TokenInfoDictionary;
import com.atilika.kuromoji.dict.UnknownDictionary;
import com.atilika.kuromoji.dict.UserDictionary;
import com.atilika.kuromoji.trie.DoubleArrayTrie;
import com.atilika.kuromoji.util.ResourceResolver;
import com.atilika.kuromoji.viterbi.TokenFactory;
import com.atilika.kuromoji.viterbi.ViterbiBuilder;
import com.atilika.kuromoji.viterbi.ViterbiFormatter;
import com.atilika.kuromoji.viterbi.ViterbiLattice;
import com.atilika.kuromoji.viterbi.ViterbiNode;
import com.atilika.kuromoji.viterbi.ViterbiSearcher;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;

public abstract class TokenizerBase {
    private ViterbiBuilder viterbiBuilder;
    private ViterbiSearcher viterbiSearcher;
    private ViterbiFormatter viterbiFormatter;
    private boolean split;
    private TokenInfoDictionary tokenInfoDictionary;
    private UnknownDictionary unknownDictionary;
    private UserDictionary userDictionary;
    private InsertedDictionary insertedDictionary;
    protected TokenFactory tokenFactory;
    protected EnumMap<ViterbiNode.Type, Dictionary> dictionaryMap = new EnumMap(ViterbiNode.Type.class);

    protected void configure(Builder builder) {
        builder.loadDictionaries();
        this.tokenFactory = builder.tokenFactory;
        this.tokenInfoDictionary = builder.tokenInfoDictionary;
        this.unknownDictionary = builder.unknownDictionary;
        this.userDictionary = builder.userDictionary;
        this.insertedDictionary = builder.insertedDictionary;
        this.viterbiBuilder = new ViterbiBuilder(builder.doubleArrayTrie, this.tokenInfoDictionary, this.unknownDictionary, this.userDictionary, builder.mode);
        this.viterbiSearcher = new ViterbiSearcher(builder.mode, builder.connectionCosts, this.unknownDictionary, builder.penalties);
        this.viterbiFormatter = new ViterbiFormatter(builder.connectionCosts);
        this.split = builder.split;
        this.initDictionaryMap();
    }

    private void initDictionaryMap() {
        this.dictionaryMap.put(ViterbiNode.Type.KNOWN, this.tokenInfoDictionary);
        this.dictionaryMap.put(ViterbiNode.Type.UNKNOWN, this.unknownDictionary);
        this.dictionaryMap.put(ViterbiNode.Type.USER, this.userDictionary);
        this.dictionaryMap.put(ViterbiNode.Type.INSERTED, this.insertedDictionary);
    }

    public List<? extends TokenBase> tokenize(String text) {
        return this.createTokenList(text);
    }

    protected <T extends TokenBase> List<T> createTokenList(String text) {
        if (!this.split) {
            return this.createTokenList(0, text);
        }
        List<Integer> splitPositions = this.getSplitPositions(text);
        if (splitPositions.size() == 0) {
            return this.createTokenList(0, text);
        }
        ArrayList<T> result = new ArrayList<T>();
        int offset = 0;
        for (int position : splitPositions) {
            result.addAll(this.createTokenList(offset, text.substring(offset, position + 1)));
            offset = position + 1;
        }
        if (offset < text.length()) {
            result.addAll(this.createTokenList(offset, text.substring(offset)));
        }
        return result;
    }

    public void debugTokenize(OutputStream outputStream, String text) throws IOException {
        ViterbiLattice lattice = this.viterbiBuilder.build(text);
        List<ViterbiNode> bestPath = this.viterbiSearcher.search(lattice);
        outputStream.write(this.viterbiFormatter.format(lattice, bestPath).getBytes(StandardCharsets.UTF_8));
        outputStream.flush();
    }

    public void debugLattice(OutputStream outputStream, String text) throws IOException {
        ViterbiLattice lattice = this.viterbiBuilder.build(text);
        outputStream.write(this.viterbiFormatter.format(lattice).getBytes(StandardCharsets.UTF_8));
        outputStream.flush();
    }

    private List<Integer> getSplitPositions(String text) {
        ArrayList<Integer> splitPositions = new ArrayList<Integer>();
        int currentPosition = 0;
        while (true) {
            int indexOfMaru = text.indexOf("\u3002", currentPosition);
            int indexOfTen = text.indexOf("\u3001", currentPosition);
            int position = indexOfMaru < 0 || indexOfTen < 0 ? Math.max(indexOfMaru, indexOfTen) : Math.min(indexOfMaru, indexOfTen);
            if (position < 0) break;
            splitPositions.add(position);
            currentPosition = position + 1;
        }
        return splitPositions;
    }

    private <T extends TokenBase> List<T> createTokenList(int offset, String text) {
        ArrayList result = new ArrayList();
        ViterbiLattice lattice = this.viterbiBuilder.build(text);
        List<ViterbiNode> bestPath = this.viterbiSearcher.search(lattice);
        for (ViterbiNode node : bestPath) {
            int wordId = node.getWordId();
            if (node.getType() == ViterbiNode.Type.KNOWN && wordId == -1) continue;
            Object token = this.tokenFactory.createToken(wordId, node.getSurface(), node.getType(), offset + node.getStartIndex(), this.dictionaryMap.get((Object)node.getType()));
            result.add(token);
        }
        return result;
    }

    public static abstract class Builder {
        protected DoubleArrayTrie doubleArrayTrie;
        protected ConnectionCosts connectionCosts;
        protected TokenInfoDictionary tokenInfoDictionary;
        protected UnknownDictionary unknownDictionary;
        protected CharacterDefinitions characterDefinitions;
        protected InsertedDictionary insertedDictionary;
        protected UserDictionary userDictionary = null;
        protected Mode mode = Mode.NORMAL;
        protected boolean split = true;
        protected List<Integer> penalties = Collections.emptyList();
        protected int totalFeatures = -1;
        protected int readingFeature = -1;
        protected int partOfSpeechFeature = -1;
        protected ResourceResolver resolver;
        protected TokenFactory tokenFactory;

        protected void loadDictionaries() {
            try {
                this.doubleArrayTrie = DoubleArrayTrie.newInstance(this.resolver);
                this.connectionCosts = ConnectionCosts.newInstance(this.resolver);
                this.tokenInfoDictionary = TokenInfoDictionary.newInstance(this.resolver);
                this.characterDefinitions = CharacterDefinitions.newInstance(this.resolver);
                this.unknownDictionary = UnknownDictionary.newInstance(this.resolver, this.characterDefinitions, this.totalFeatures);
                this.insertedDictionary = new InsertedDictionary(this.totalFeatures);
            }
            catch (Exception ouch) {
                throw new RuntimeException("Could not load dictionaries.", ouch);
            }
        }

        public abstract <T extends TokenizerBase> T build();

        public Builder userDictionary(InputStream input) throws IOException {
            this.userDictionary = new UserDictionary(input, this.totalFeatures, this.readingFeature, this.partOfSpeechFeature);
            return this;
        }

        public Builder userDictionary(String filename) throws IOException {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(filename));
            this.userDictionary(input);
            ((InputStream)input).close();
            return this;
        }
    }

    public static enum Mode {
        NORMAL,
        SEARCH,
        EXTENDED;

    }
}

