/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.osmand.Location;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.ObfConstants;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.osm.AbstractPoiType;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiCategory;
import net.osmand.osm.PoiType;
import net.osmand.shared.wiki.WikiHelper;
import net.osmand.shared.wiki.WikiImage;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.json.JSONObject;

public class Amenity
extends MapObject {
    public static final String WEBSITE = "website";
    public static final String URL = "url";
    public static final String PHONE = "phone";
    public static final String MOBILE = "mobile";
    public static final String BRAND = "brand";
    public static final String OPERATOR = "operator";
    public static final String DESCRIPTION = "description";
    public static final String SHORT_DESCRIPTION = "short_description";
    public static final String ROUTE = "route";
    public static final String OPENING_HOURS = "opening_hours";
    public static final String POPULATION = "population";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String DISTANCE = "distance";
    public static final String SERVICE_TIMES = "service_times";
    public static final String COLLECTION_TIMES = "collection_times";
    public static final String CONTENT = "content";
    public static final String CUISINE = "cuisine";
    public static final String WIKIPEDIA = "wikipedia";
    public static final String WIKIDATA = "wikidata";
    public static final String WIKIMEDIA_COMMONS = "wikimedia_commons";
    public static final String MAPILLARY = "mapillary";
    public static final String DISH = "dish";
    public static final String REF = "ref";
    public static final String OSM_DELETE_VALUE = "delete";
    public static final String OSM_DELETE_TAG = "osmand_change";
    public static final String PRIVATE_VALUE = "private";
    public static final String ACCESS_PRIVATE_TAG = "access_private";
    public static final String IMAGE_TITLE = "image_title";
    public static final String IS_PART = "is_part";
    public static final String IS_PARENT_OF = "is_parent_of";
    public static final String IS_AGGR_PART = "is_aggr_part";
    public static final String CONTENT_JSON = "content_json";
    public static final String ROUTE_ID = "route_id";
    public static final String ROUTE_ID_OSM_PREFIX_LEGACY = "OSM";
    public static final String ROUTE_ID_OSM_PREFIX = "O";
    public static final String ROUTE_SOURCE = "route_source";
    public static final String ROUTE_NAME = "route_name";
    public static final String ROUTE_ACTIVITY_TYPE = "route_activity_type";
    public static final String WIKI_PHOTO = "wiki_photo";
    public static final String WIKI_CATEGORY = "wiki_category";
    public static final String TRAVEL_TOPIC = "travel_topic";
    public static final String TRAVEL_ELO = "travel_elo";
    public static final String OSMAND_POI_KEY = "osmand_poi_key";
    public static final String COLOR = "color";
    public static final String LANG_YES = "lang_yes";
    public static final String GPX_ICON = "gpx_icon";
    public static final String TYPE = "type";
    public static final String SUBTYPE = "subtype";
    public static final String NAME = "name";
    public static final String SEPARATOR = ";";
    public static final String ALT_NAME_WITH_LANG_PREFIX = "alt_name:";
    public static final String COLLAPSABLE_PREFIX = "collapsable_";
    public static final String ROUTE_MEMBERS_IDS = "route_members_ids";
    public static final String ROUTE_BBOX_RADIUS = "route_bbox_radius";
    public static final List<String> HIDING_EXTENSIONS_AMENITY_TAGS = Arrays.asList("phone", "website");
    public static final int DEFAULT_ELO = 900;
    public static final String ADDR_STREET = "addr_street";
    private String subType;
    private PoiCategory type;
    private String openingHours;
    private Map<String, String> additionalInfo;
    private AmenityRoutePoint routePoint;
    private TIntArrayList y;
    private TIntArrayList x;
    private String mapIconName;
    private int order;
    private Map<Integer, List<BinaryMapIndexReader.TagValuePair>> tagGroups;
    private String regionName;
    private String wikiIconUrl;
    private String wikiImageStubUrl;
    private int travelElo = 0;
    private Set<String> contentLocales;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Map<Integer, List<BinaryMapIndexReader.TagValuePair>> getTagGroups() {
        return this.tagGroups;
    }

    public void addTagGroup(int id, List<BinaryMapIndexReader.TagValuePair> tagValues) {
        if (this.tagGroups == null) {
            this.tagGroups = new HashMap<Integer, List<BinaryMapIndexReader.TagValuePair>>();
        }
        this.tagGroups.put(id, tagValues);
    }

    public void setTagGroups(Map<Integer, List<BinaryMapIndexReader.TagValuePair>> tagGroups) {
        this.tagGroups = tagGroups;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getMapIconName() {
        return this.mapIconName;
    }

    public void setMapIconName(String mapIconName) {
        this.mapIconName = mapIconName;
    }

    public PoiCategory getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setType(PoiCategory type) {
        this.type = type;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getSubTypeStr() {
        PoiCategory pc = this.getType();
        String[] subtypes = this.getSubType().split(SEPARATOR);
        Object typeStr = "";
        for (String subType : subtypes) {
            PoiType pt = pc.getPoiTypeByKeyName(subType);
            if (pt == null) continue;
            typeStr = !((String)typeStr).isEmpty() ? (String)typeStr + ", " + pt.getTranslation().toLowerCase() : pt.getTranslation();
        }
        if (((String)typeStr).isEmpty()) {
            typeStr = this.getSubType();
            typeStr = Algorithms.capitalizeFirstLetterAndLowercase(((String)typeStr).replace('_', ' '));
        }
        return typeStr;
    }

    public String getOpeningHours() {
        return this.openingHours;
    }

    public String getAdditionalInfo(String key) {
        if (this.additionalInfo == null) {
            return null;
        }
        String str = this.additionalInfo.get(key);
        if (str == null && key.contains(":")) {
            str = this.additionalInfo.get(key.replaceAll(":", "_-_"));
        }
        if (str != null) {
            str = Amenity.unzipContent(str);
        }
        return str;
    }

    public boolean hasAdditionalInfo() {
        return !Algorithms.isEmpty(this.additionalInfo);
    }

    private Map<String, String> getInternalAdditionalInfoMap() {
        if (this.additionalInfo == null) {
            return Collections.emptyMap();
        }
        return this.additionalInfo;
    }

    public Collection<String> getAdditionalInfoValues(boolean excludeZipped) {
        if (this.additionalInfo == null) {
            return Collections.emptyList();
        }
        boolean zipped = false;
        for (String v : this.additionalInfo.values()) {
            if (!Amenity.isContentZipped(v)) continue;
            zipped = true;
            break;
        }
        if (zipped) {
            ArrayList<String> r = new ArrayList<String>(this.additionalInfo.size());
            for (String str : this.additionalInfo.values()) {
                if (excludeZipped && Amenity.isContentZipped(str)) continue;
                r.add(Amenity.unzipContent(str));
            }
            return r;
        }
        return this.additionalInfo.values();
    }

    public Collection<String> getAdditionalInfoKeys() {
        if (this.additionalInfo == null) {
            return Collections.emptyList();
        }
        return this.additionalInfo.keySet();
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = null;
        this.openingHours = null;
        if (additionalInfo != null) {
            for (Map.Entry<String, String> e : additionalInfo.entrySet()) {
                this.setAdditionalInfo(e.getKey(), e.getValue());
            }
        }
    }

    public void setRoutePoint(AmenityRoutePoint routePoint) {
        this.routePoint = routePoint;
    }

    public AmenityRoutePoint getRoutePoint() {
        return this.routePoint;
    }

    public void setAdditionalInfo(String tag, String value) {
        if (NAME.equals(tag)) {
            this.setName(value);
        } else if (Amenity.isNameLangTag(tag)) {
            this.setName(tag.substring("name:".length()), value);
        } else {
            if (this.additionalInfo == null) {
                this.additionalInfo = new LinkedHashMap<String, String>();
            }
            this.additionalInfo.put(tag, value);
            if (OPENING_HOURS.equals(tag)) {
                this.openingHours = Amenity.unzipContent(value);
            }
        }
    }

    public void copyAdditionalInfo(Amenity amenity, boolean overwrite) {
        this.copyAdditionalInfo(amenity.getInternalAdditionalInfoMap(), overwrite);
    }

    public void copyAdditionalInfo(Map<String, String> map, boolean overwrite) {
        if (overwrite || this.additionalInfo == null) {
            this.setAdditionalInfo(map);
        } else {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                if (this.additionalInfo.containsKey(key)) continue;
                this.setAdditionalInfo(key, entry.getValue());
            }
        }
    }

    public StringBuilder printNamesAndAdditional() {
        StringBuilder s = new StringBuilder();
        LinkedHashMap<String, String> additionals = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> poi_type = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> text = new LinkedHashMap<String, String>();
        if (this.additionalInfo != null) {
            for (Map.Entry<String, String> e : this.additionalInfo.entrySet()) {
                Object key = e.getKey();
                String val = e.getValue();
                AbstractPoiType pt = MapPoiTypes.getDefault().getAnyPoiAdditionalTypeByKey((String)key);
                if (pt == null && !Algorithms.isEmpty(val) && val.length() < 50) {
                    pt = MapPoiTypes.getDefault().getAnyPoiAdditionalTypeByKey((String)key + "_" + val);
                }
                if (pt != null) {
                    additionals.put((String)key, val);
                    continue;
                }
                PoiType pt2 = MapPoiTypes.getDefault().getPoiTypeByKey((String)key);
                if (pt2 != null) {
                    String cat = pt2.getCategory().getKeyName();
                    if (poi_type.containsKey(cat)) {
                        key = (String)poi_type.get(cat) + SEPARATOR + (String)key;
                    }
                    poi_type.put(pt2.getCategory().getKeyName(), (String)key);
                    continue;
                }
                text.put((String)key, val);
            }
        }
        if (poi_type.size() > 0) {
            s.append(" [ ");
            this.printNames("", poi_type, s);
            s.append(" ] ");
        }
        if (additionals.size() > 0) {
            s.append(" poi_additional:[ ");
            this.printNames("", additionals, s);
            s.append(" ] ");
        }
        if (text.size() > 0) {
            s.append(" non_default_poi_xml:[ ");
            this.printNames("", text, s);
            s.append(" ] ");
        }
        this.printNames(" name:", this.getNamesMap(true), s);
        return s;
    }

    private void printNames(String prefix, Map<String, String> stringMap, StringBuilder s) {
        for (Map.Entry<String, String> e : stringMap.entrySet()) {
            if (e.getValue().startsWith(" gz ")) {
                s.append(prefix).append(e.getKey()).append("='gzip ...' ");
                continue;
            }
            s.append(prefix).append(e.getKey()).append("='").append(e.getValue()).append("' ");
        }
    }

    @Override
    public String toStringEn() {
        return super.toStringEn() + ": " + this.type.getKeyName() + ":" + this.subType;
    }

    @Override
    public String toString() {
        return this.type.getKeyName() + ": " + this.subType + " " + this.getName();
    }

    public String getSite() {
        return this.getAdditionalInfo(WEBSITE);
    }

    public String getStreetName() {
        return this.getAdditionalInfo(ADDR_STREET);
    }

    public void setSite(String site) {
        this.setAdditionalInfo(WEBSITE, site);
    }

    public String getPhone() {
        return this.getAdditionalInfo(PHONE);
    }

    public void setPhone(String phone) {
        this.setAdditionalInfo(PHONE, phone);
    }

    public String getColor() {
        return this.getAdditionalInfo(COLOR);
    }

    public String getGpxIcon() {
        String wikiVoyageIcon = this.getAdditionalInfo(GPX_ICON);
        String travelGpxIcon = this.getAdditionalInfo("icon");
        return Algorithms.isEmpty(wikiVoyageIcon) ? travelGpxIcon : wikiVoyageIcon;
    }

    public String getContentLanguage(String tag, String lang, String defLang) {
        String translateName;
        if (lang != null && !Algorithms.isEmpty(translateName = this.getAdditionalInfo(tag + ":" + lang))) {
            return lang;
        }
        String plainContent = this.getAdditionalInfo(tag);
        if (!Algorithms.isEmpty(plainContent)) {
            return defLang;
        }
        String enName = this.getAdditionalInfo(tag + ":en");
        if (!Algorithms.isEmpty(enName)) {
            return "en";
        }
        int maxLen = 0;
        String lng = defLang;
        for (String nm : this.getAdditionalInfoKeys()) {
            String key;
            String cnt;
            if (!nm.startsWith(tag + ":") || Algorithms.isEmpty(cnt = this.getAdditionalInfo(tag + ":" + (key = nm.substring(tag.length() + 1)))) || cnt.length() <= maxLen) continue;
            maxLen = cnt.length();
            lng = key;
        }
        return lng;
    }

    public Set<String> getSupportedContentLocales() {
        if (this.contentLocales != null) {
            return this.contentLocales;
        }
        TreeSet<String> supported = new TreeSet<String>();
        supported.addAll(this.getNames(CONTENT, "en"));
        supported.addAll(this.getNames(DESCRIPTION, "en"));
        return supported;
    }

    public void updateContentLocales(Set<String> locales) {
        if (this.contentLocales == null) {
            this.contentLocales = new TreeSet<String>();
        }
        this.contentLocales.addAll(locales);
    }

    public List<String> getNames(String tag, String defTag) {
        ArrayList<String> l = new ArrayList<String>();
        for (String nm : this.getAdditionalInfoKeys()) {
            if (nm.startsWith(tag + ":")) {
                l.add(nm.substring(tag.length() + 1));
                continue;
            }
            if (!nm.equals(tag)) continue;
            l.add(defTag);
        }
        return l;
    }

    public Map<String, String> getAltNamesMap() {
        HashMap<String, String> names = new HashMap<String, String>();
        for (String nm : this.getAdditionalInfoKeys()) {
            String name = this.additionalInfo.get(nm);
            if (!nm.startsWith(ALT_NAME_WITH_LANG_PREFIX)) continue;
            names.put(nm.substring(ALT_NAME_WITH_LANG_PREFIX.length()), name);
        }
        return names;
    }

    public String getTagSuffix(String tagPrefix) {
        for (String infoTag : this.getAdditionalInfoKeys()) {
            if (!infoTag.startsWith(tagPrefix) || infoTag.length() <= tagPrefix.length()) continue;
            return infoTag.substring(tagPrefix.length());
        }
        return null;
    }

    public String getTagContent(String tag) {
        return this.getTagContent(tag, null);
    }

    public String getTagContent(String tag, String lang) {
        String translateName = this.getStrictTagContent(tag, lang);
        if (translateName != null) {
            return translateName;
        }
        for (String nm : this.getAdditionalInfoKeys()) {
            if (!nm.startsWith(tag + ":") && !nm.startsWith(tag + "_-_")) continue;
            return this.getAdditionalInfo(nm);
        }
        return null;
    }

    public String getRef() {
        return this.getAdditionalInfo(REF);
    }

    public String getRouteId() {
        return this.getAdditionalInfo(ROUTE_ID);
    }

    public String getWikiPhoto() {
        return this.getAdditionalInfo(WIKI_PHOTO);
    }

    public void setWikiPhoto(String wikiPhoto) {
        this.setAdditionalInfo(WIKI_PHOTO, wikiPhoto);
    }

    public String getWikiCategory() {
        return this.getAdditionalInfo(WIKI_CATEGORY);
    }

    public void setWikiCategory(String wikiCategory) {
        this.setAdditionalInfo(WIKI_CATEGORY, wikiCategory);
    }

    public String getTravelTopic() {
        return this.getAdditionalInfo(TRAVEL_TOPIC);
    }

    public void setTravelTopic(String travelTopic) {
        this.setAdditionalInfo(TRAVEL_TOPIC, travelTopic);
    }

    public String getTravelElo() {
        return this.getAdditionalInfo(TRAVEL_ELO);
    }

    public String getWikidata() {
        return this.getAdditionalInfo(WIKIDATA);
    }

    public int getTravelEloNumber() {
        if (this.travelElo > 0) {
            return this.travelElo;
        }
        String travelEloStr = this.getTravelElo();
        this.travelElo = Algorithms.parseIntSilently(travelEloStr, 900);
        return this.travelElo;
    }

    public void setTravelEloNumber(int elo) {
        this.travelElo = elo;
    }

    public String getWikiIconUrl() {
        if (this.wikiIconUrl == null) {
            this.obtainWikiUrls();
        }
        return this.wikiIconUrl;
    }

    public void setWikiIconUrl(String wikiIconUrl) {
        this.wikiIconUrl = wikiIconUrl;
    }

    public String getWikiImageStubUrl() {
        if (this.wikiImageStubUrl == null) {
            this.obtainWikiUrls();
        }
        return this.wikiImageStubUrl;
    }

    public void setWikiImageStubUrl(String wikiImageStubUrl) {
        this.wikiImageStubUrl = wikiImageStubUrl;
    }

    public String getOsmandPoiKey() {
        return this.getAdditionalInfo(OSMAND_POI_KEY);
    }

    private void obtainWikiUrls() {
        String wikiPhoto = this.getWikiPhoto();
        if (!Algorithms.isEmpty(wikiPhoto)) {
            WikiImage wikiIMage = WikiHelper.INSTANCE.getImageData(wikiPhoto);
            this.setWikiIconUrl(wikiIMage.getImageIconUrl());
            this.setWikiImageStubUrl(wikiIMage.getImageStubUrl());
        }
    }

    public boolean hasOsmRouteId() {
        String routeId = this.getRouteId();
        return routeId != null && (routeId.startsWith(ROUTE_ID_OSM_PREFIX_LEGACY) || routeId.startsWith(ROUTE_ID_OSM_PREFIX));
    }

    public String getGpxFileName(String lang) {
        String gpxFileName;
        String string = gpxFileName = lang != null ? this.getName(lang) : this.getEnName(true);
        if (!Algorithms.isEmpty(gpxFileName)) {
            return Algorithms.sanitizeFileName(gpxFileName);
        }
        if (!Algorithms.isEmpty(this.getRouteId())) {
            return this.getRouteId();
        }
        if (!Algorithms.isEmpty(this.getSubType())) {
            return this.getType().getKeyName() + " " + this.getSubType();
        }
        return this.getType().getKeyName();
    }

    public String getStrictTagContent(String tag, String lang) {
        String translateName;
        if (lang != null && !Algorithms.isEmpty(translateName = this.getAdditionalInfo(tag + ":" + lang))) {
            return translateName;
        }
        String plainName = this.getAdditionalInfo(tag);
        if (!Algorithms.isEmpty(plainName)) {
            return plainName;
        }
        String enName = this.getAdditionalInfo(tag + ":en");
        if (!Algorithms.isEmpty(enName)) {
            return enName;
        }
        return null;
    }

    public String getDescription(String lang) {
        String info = this.getTagContent(DESCRIPTION, lang);
        if (!Algorithms.isEmpty(info)) {
            return info;
        }
        return this.getTagContent(CONTENT, lang);
    }

    public void setDescription(String description) {
        this.setAdditionalInfo(DESCRIPTION, description);
    }

    public void setOpeningHours(String openingHours) {
        this.setAdditionalInfo(OPENING_HOURS, openingHours);
    }

    public boolean comparePoi(Amenity thatObj) {
        return this.compareObject(thatObj) && Algorithms.objectEquals(this.type.getKeyName(), thatObj.type.getKeyName()) && Algorithms.objectEquals(this.subType, thatObj.subType) && Algorithms.objectEquals(this.additionalInfo, thatObj.additionalInfo);
    }

    public boolean strictEquals(Object object) {
        if (this.equals(object)) {
            if (this.x != null && ((Amenity)object).x != null && this.x.size() == ((Amenity)object).x.size()) {
                for (int i = 0; i < this.x.size(); ++i) {
                    if (this.x.get(i) == ((Amenity)object).x.get(i) && this.y.get(i) == ((Amenity)object).y.get(i)) continue;
                    return false;
                }
                return true;
            }
            return this.x == null && ((Amenity)object).x == null;
        }
        return false;
    }

    @Override
    public int compareTo(MapObject o) {
        int cmp = super.compareTo(o);
        if (cmp == 0 && o instanceof Amenity) {
            int kn = ((Amenity)o).getType().getKeyName().compareTo(this.getType().getKeyName());
            if (kn == 0) {
                kn = ((Amenity)o).getSubType().compareTo(this.getSubType());
            }
            return kn;
        }
        return cmp;
    }

    @Override
    public boolean equals(Object o) {
        boolean res = super.equals(o);
        if (res && o instanceof Amenity) {
            return Algorithms.stringsEqual(((Amenity)o).getType().getKeyName(), this.getType().getKeyName()) && Algorithms.stringsEqual(((Amenity)o).getSubType(), this.getSubType());
        }
        return res;
    }

    public TIntArrayList getY() {
        if (this.y == null) {
            this.y = new TIntArrayList();
        }
        return this.y;
    }

    public TIntArrayList getX() {
        if (this.x == null) {
            this.x = new TIntArrayList();
        }
        return this.x;
    }

    public boolean isClosed() {
        return OSM_DELETE_VALUE.equals(this.getAdditionalInfo(OSM_DELETE_TAG));
    }

    public boolean isPrivateAccess() {
        return PRIVATE_VALUE.equals(this.getTagContent(ACCESS_PRIVATE_TAG));
    }

    public boolean isRouteTrack() {
        if (this.subType == null) {
            return false;
        }
        boolean hasRouteTrackSubtype = this.subType.startsWith("routes_") || this.subType.equals("route_track");
        boolean hasGeometry = this.additionalInfo != null && this.additionalInfo.containsKey(ROUTE_BBOX_RADIUS);
        return hasRouteTrackSubtype && hasGeometry && !Algorithms.isEmpty(this.getRouteId());
    }

    public boolean isRoutePoint() {
        return this.subType != null && (this.subType.equals("route_track_point") || this.subType.equals("route_article_point"));
    }

    public boolean isRouteArticle() {
        return Algorithms.stringsEqual("route_article", this.subType);
    }

    public boolean isSuperRoute() {
        return this.additionalInfo != null && this.additionalInfo.containsKey(ROUTE_MEMBERS_IDS);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put("subType", (Object)this.subType);
        json.put(TYPE, (Object)this.type.getKeyName());
        json.put("openingHours", (Object)this.openingHours);
        if (this.additionalInfo != null && this.additionalInfo.size() > 0) {
            JSONObject additionalInfoObj = new JSONObject();
            for (Map.Entry<String, String> e : this.additionalInfo.entrySet()) {
                additionalInfoObj.put(e.getKey(), (Object)e.getValue());
            }
            json.put("additionalInfo", (Object)additionalInfoObj);
        }
        return json;
    }

    public static Amenity parseJSON(JSONObject json) {
        Amenity amenity = new Amenity();
        MapObject.parseJSON(json, amenity);
        if (json.has("subType")) {
            amenity.subType = json.getString("subType");
        }
        if (json.has(TYPE)) {
            String categoryName = json.getString(TYPE);
            amenity.setType(MapPoiTypes.getDefault().getPoiCategoryByName(categoryName));
        } else {
            amenity.setType(MapPoiTypes.getDefault().getOtherPoiCategory());
        }
        if (json.has("openingHours")) {
            amenity.openingHours = json.getString("openingHours");
        }
        if (json.has("additionalInfo")) {
            JSONObject namesObj = json.getJSONObject("additionalInfo");
            Iterator iterator = namesObj.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = namesObj.getString(key);
                amenity.setAdditionalInfo(key, value);
            }
        }
        return amenity;
    }

    public Map<String, String> getAmenityExtensions() {
        return this.getAmenityExtensions(MapPoiTypes.getDefault(), true);
    }

    public Map<String, String> getAmenityExtensions(MapPoiTypes mapPoiTypes, boolean addPrefixes) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, List<PoiType>> categories = new HashMap<String, List<PoiType>>();
        if (this.name != null) {
            result.put(addPrefixes ? "amenity_name" : NAME, this.name);
        }
        if (this.subType != null) {
            result.put(addPrefixes ? "amenity_subtype" : SUBTYPE, this.subType);
        }
        if (this.type != null && this.type.getKeyName() != null) {
            result.put(addPrefixes ? "amenity_type" : TYPE, this.type.getKeyName());
        }
        if (this.openingHours != null) {
            result.put(addPrefixes ? "amenity_opening_hours" : OPENING_HOURS, this.openingHours);
        }
        if (this.hasAdditionalInfo()) {
            result.putAll(this.getAdditionalInfoAndCollectCategories(mapPoiTypes, categories, addPrefixes));
            for (Map.Entry entry : categories.entrySet()) {
                String key = COLLAPSABLE_PREFIX + (String)entry.getKey();
                List categoryTypes = (List)entry.getValue();
                if (categoryTypes.isEmpty()) continue;
                StringBuilder builder = new StringBuilder();
                for (PoiType poiType : categoryTypes) {
                    if (builder.length() > 0) {
                        builder.append(SEPARATOR);
                    }
                    builder.append(poiType.getKeyName());
                }
                result.put(key, builder.toString());
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> getAdditionalInfoAndCollectCategories(MapPoiTypes mapPoiTypes, Map<String, List<PoiType>> categories, boolean addPrefixes) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String string : this.getAdditionalInfoKeys()) {
            void var6_6;
            String category;
            String value;
            PoiType poiType = this.getPoiType(mapPoiTypes, string, value = this.getAdditionalInfo(string));
            if (poiType != null && poiType.isFilterOnly()) continue;
            if (poiType != null && !poiType.isText() && categories != null && !Algorithms.isEmpty(category = poiType.getPoiAdditionalCategory())) {
                List<PoiType> types = categories.get(category);
                if (types == null) {
                    types = new ArrayList<PoiType>();
                    categories.put(category, types);
                }
                types.add(poiType);
                continue;
            }
            if (string.endsWith(OPENING_HOURS)) continue;
            if (!HIDING_EXTENSIONS_AMENITY_TAGS.contains(string) && addPrefixes) {
                String string2 = "osm_tag_" + string;
            }
            result.put((String)var6_6, value);
        }
        return result;
    }

    private PoiType getPoiType(MapPoiTypes mapPoiTypes, String key, String value) {
        AbstractPoiType abstractPoiType = mapPoiTypes.getAnyPoiAdditionalTypeByKey(key);
        if (abstractPoiType == null && !Amenity.isContentZipped(value)) {
            abstractPoiType = mapPoiTypes.getAnyPoiAdditionalTypeByKey(key + "_" + value);
        }
        if (abstractPoiType instanceof PoiType) {
            return (PoiType)abstractPoiType;
        }
        return null;
    }

    public String getTranslation(MapPoiTypes mapPoiTypes, String alternateName) {
        for (String key : this.getAdditionalInfoKeys()) {
            PoiType poiType;
            String value = this.getAdditionalInfo(key);
            if (!value.equals(alternateName) || (poiType = this.getPoiType(mapPoiTypes, key, value)) == null || poiType.isText()) continue;
            return poiType.getTranslation();
        }
        return alternateName;
    }

    public String getCityFromTagGroups(String lang) {
        if (this.tagGroups == null) {
            return null;
        }
        String result = null;
        for (Map.Entry<Integer, List<BinaryMapIndexReader.TagValuePair>> entry : this.tagGroups.entrySet()) {
            String translated = "";
            String nonTranslated = "";
            City.CityType type = null;
            for (BinaryMapIndexReader.TagValuePair tagValue : entry.getValue()) {
                if (tagValue.tag.endsWith("name:" + lang)) {
                    translated = tagValue.value;
                }
                if (tagValue.tag.endsWith(NAME)) {
                    nonTranslated = tagValue.value;
                }
                if (!tagValue.tag.equals("place")) continue;
                type = City.CityType.valueFromString(tagValue.value.toUpperCase());
            }
            String name = translated.isEmpty() ? nonTranslated : translated;
            if (name.isEmpty() || !this.isCityTypeAccept(type)) continue;
            result = result == null ? name : result + ", " + name;
        }
        return result;
    }

    private boolean isCityTypeAccept(City.CityType type) {
        if (type == null) {
            return false;
        }
        return type.storedAsSeparateAdminEntity();
    }

    public List<LatLon> getPolygon() {
        ArrayList<LatLon> res = new ArrayList<LatLon>();
        if (this.x == null) {
            return res;
        }
        for (int i = 0; i < this.getX().size(); ++i) {
            int x = this.getX().get(i);
            int y = this.getY().get(i);
            LatLon l = new LatLon(MapUtils.get31LatitudeY(y), MapUtils.get31LongitudeX(x));
            res.add(l);
        }
        return res;
    }

    public void setX(TIntArrayList x) {
        this.x = x;
    }

    public void setY(TIntArrayList y) {
        this.y = y;
    }

    public String getRouteActivityType() {
        if (!this.isRouteTrack() && !this.isSuperRoute()) {
            return "";
        }
        for (Map.Entry<String, String> entry : this.additionalInfo.entrySet()) {
            if (!entry.getKey().startsWith("route_activity_type_")) continue;
            return MapPoiTypes.getDefault().getAnyPoiAdditionalTypeByKey(entry.getKey()).getTranslation();
        }
        return "";
    }

    public Long getOsmId() {
        Long id = this.getId();
        if (id == null) {
            return null;
        }
        if (ObfConstants.isShiftedID(id)) {
            return ObfConstants.getOsmId(id);
        }
        return id >> 1;
    }

    public static String getPoiStringWithoutType(Amenity amenity, String locale, boolean transliterate) {
        String typeName = amenity.getSubTypeStr();
        String localName = amenity.getName(locale, transliterate);
        if (typeName != null && localName.contains(typeName)) {
            return localName;
        }
        if (Algorithms.isEmpty(localName) && amenity.isRouteTrack()) {
            localName = amenity.getAdditionalInfo(ROUTE_ID);
        }
        if (Algorithms.isEmpty(localName)) {
            return typeName;
        }
        return typeName + " " + localName;
    }

    public Map<String, String> getOsmTags() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> amenityTags = new LinkedHashMap<String, String>();
        for (String amenityTag : this.getAdditionalInfoKeys()) {
            amenityTags.put(amenityTag, this.getAdditionalInfo(amenityTag));
        }
        String amenityName = this.getName();
        if (!Algorithms.isEmpty(amenityName)) {
            result.put(NAME, amenityName);
        }
        PoiCategory category = this.getType();
        String subTypesList = this.getSubType();
        if (subTypesList != null) {
            for (String subType : subTypesList.split(SEPARATOR)) {
                PoiType type = category.getPoiTypeByKeyName(subType);
                if (type == null) continue;
                result.putAll(type.getOsmTagsValues());
                for (PoiType additional : type.getPoiAdditionals()) {
                    if (amenityTags.remove(additional.getKeyName()) == null) continue;
                    result.putAll(additional.getOsmTagsValues());
                }
            }
        }
        result.putAll(amenityTags);
        return result;
    }

    public static class AmenityRoutePoint {
        public double deviateDistance;
        public boolean deviationDirectionRight;
        public Location pointA;
        public Location pointB;
    }
}

