/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.htmlcleaner.util;

import info.bliki.htmlcleaner.BaseToken;
import info.bliki.htmlcleaner.HtmlCleaner;
import info.bliki.htmlcleaner.TagNode;
import java.io.IOException;
import java.util.List;

public abstract class AbstractHtmlExtractor<T> {
    final T fResultObject;

    public AbstractHtmlExtractor(T resultObject) {
        this.fResultObject = resultObject;
    }

    protected abstract void appendContent(List<Object> var1);

    protected abstract boolean isFound(TagNode var1);

    protected T getResultObject() {
        return this.fResultObject;
    }

    protected void visitTokenList(List<Object> nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            for (Object item : nodes) {
                if (item == null) continue;
                if (item instanceof List) {
                    List list = (List)item;
                    this.visitTokenList(list);
                    continue;
                }
                if (!(item instanceof BaseToken)) continue;
                this.visitBaseToken((BaseToken)item);
            }
        }
    }

    protected void visitBaseToken(BaseToken node) {
        if (node instanceof TagNode) {
            TagNode tagNode = (TagNode)node;
            if (this.isFound(tagNode)) {
                this.appendContent(tagNode.getChildren());
            } else {
                List<Object> children = tagNode.getChildren();
                if (children.size() != 0) {
                    this.visitTokenList(children);
                }
            }
        }
    }

    public void extractContent(String html) {
        HtmlCleaner cleaner = null;
        try {
            cleaner = new HtmlCleaner(html);
            cleaner.clean();
            TagNode body = cleaner.getBodyNode();
            this.visitBaseToken(body);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

