/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.render;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.render.RenderingRule;
import net.osmand.render.RenderingRuleProperty;
import net.osmand.render.RenderingRuleStorageProperties;
import net.osmand.render.RenderingRulesStorage;
import net.osmand.util.Algorithms;

public class RenderingRuleSearchRequest {
    public final RenderingRuleStorageProperties ALL;
    private BinaryMapDataObject object;
    private final RenderingRuleProperty[] props;
    private final RenderingRulesStorage storage;
    private final int[] values;
    private final float[] fvalues;
    private int[] savedValues;
    private float[] savedFvalues;
    private boolean searchResult = false;
    private Map<String, String> classProperties = new HashMap<String, String>();

    public RenderingRuleSearchRequest(RenderingRulesStorage storage) {
        this.storage = storage;
        this.ALL = storage.PROPS;
        this.props = storage.PROPS.getPoperties();
        this.values = new int[this.props.length];
        for (int i = 0; i < this.props.length; ++i) {
            if (this.props[i].isColor()) continue;
            this.values[i] = -1;
        }
        this.fvalues = new float[this.props.length];
        this.setBooleanFilter(storage.PROPS.R_TEST, true);
        this.saveState();
    }

    public RenderingRuleSearchRequest(RenderingRuleSearchRequest searchRequest) {
        this.storage = searchRequest.storage;
        this.props = searchRequest.props;
        this.values = new int[searchRequest.values.length];
        this.fvalues = new float[searchRequest.fvalues.length];
        this.object = searchRequest.object;
        this.searchResult = searchRequest.searchResult;
        this.ALL = searchRequest.ALL;
        System.arraycopy(searchRequest.values, 0, this.values, 0, searchRequest.values.length);
        System.arraycopy(searchRequest.fvalues, 0, this.fvalues, 0, searchRequest.fvalues.length);
        this.saveState();
    }

    public static RenderingRuleSearchRequest initWithCustomProperties(RenderingRulesStorage renderingRules, int zoom, Map<String, String> customProperties) {
        RenderingRuleSearchRequest searchRequest = new RenderingRuleSearchRequest(renderingRules);
        for (RenderingRuleProperty customProp : renderingRules.PROPS.getCustomRules()) {
            String custom;
            String string = custom = customProperties != null ? customProperties.get(customProp.getAttrName()) : null;
            if (customProp.isBoolean()) {
                searchRequest.setBooleanFilter(customProp, custom != null ? "true".equals(custom) : false);
                continue;
            }
            searchRequest.setStringFilter(customProp, custom != null ? custom : "");
        }
        if (zoom > 0) {
            searchRequest.setIntFilter(renderingRules.PROPS.R_MINZOOM, zoom);
            searchRequest.setIntFilter(renderingRules.PROPS.R_MAXZOOM, zoom);
        }
        searchRequest.saveState();
        return searchRequest;
    }

    RenderingRulesStorage getStorage() {
        return this.storage;
    }

    public BinaryMapDataObject getObject() {
        return this.object;
    }

    public void setStringFilter(RenderingRuleProperty p, String filter) {
        assert (p.isInputProperty());
        this.values[p.getId()] = this.storage.getDictionaryValue(filter);
    }

    public void setIntFilter(RenderingRuleProperty p, int filter) {
        assert (p.isInputProperty());
        this.values[p.getId()] = filter;
    }

    public void setBooleanFilter(RenderingRuleProperty p, boolean filter) {
        assert (p.isInputProperty());
        this.values[p.getId()] = filter ? 1 : 0;
    }

    public void setFloatFilter(RenderingRuleProperty p, float filter) {
        assert (p.isInputProperty());
        this.fvalues[p.getId()] = filter;
    }

    public void saveState() {
        this.savedValues = new int[this.values.length];
        this.savedFvalues = new float[this.fvalues.length];
        System.arraycopy(this.values, 0, this.savedValues, 0, this.values.length);
        System.arraycopy(this.fvalues, 0, this.savedFvalues, 0, this.fvalues.length);
    }

    public void clearState() {
        System.arraycopy(this.savedValues, 0, this.values, 0, this.values.length);
        System.arraycopy(this.savedFvalues, 0, this.fvalues, 0, this.fvalues.length);
        this.object = null;
    }

    public void clearValue(RenderingRuleProperty p) {
        if (!p.isIntParse()) {
            this.fvalues[p.getId()] = this.savedFvalues[p.getId()];
        }
        this.values[p.getId()] = this.savedValues[p.getId()];
    }

    public void setInitialTagValueZoom(String tag, String val, int zoom, BinaryMapDataObject obj) {
        this.clearState();
        this.object = obj;
        this.setIntFilter(this.ALL.R_MINZOOM, zoom);
        this.setIntFilter(this.ALL.R_MAXZOOM, zoom);
        this.setStringFilter(this.ALL.R_TAG, tag);
        this.setStringFilter(this.ALL.R_VALUE, val);
    }

    public void setTagValueZoomLayer(String tag, String val, int zoom, int layer, BinaryMapDataObject obj) {
        this.object = obj;
        this.setIntFilter(this.ALL.R_MINZOOM, zoom);
        this.setIntFilter(this.ALL.R_MAXZOOM, zoom);
        this.setIntFilter(this.ALL.R_LAYER, layer);
        this.setStringFilter(this.ALL.R_TAG, tag);
        this.setStringFilter(this.ALL.R_VALUE, val);
    }

    public boolean isFound() {
        return this.searchResult;
    }

    public boolean searchRenderingAttribute(String attribute) {
        this.searchResult = false;
        RenderingRule rule = this.storage.getRenderingAttributeRule(attribute);
        if (rule == null) {
            return false;
        }
        this.searchResult = this.visitRule(rule, true);
        return this.searchResult;
    }

    public boolean search(int state) {
        return this.search(state, true);
    }

    public boolean search(int state, boolean loadOutput) {
        int valueKey;
        this.searchResult = false;
        int tagKey = this.values[this.storage.PROPS.R_TAG.getId()];
        boolean result = this.searchInternal(state, tagKey, valueKey = this.values[this.storage.PROPS.R_VALUE.getId()], loadOutput);
        if (result) {
            this.searchResult = true;
            return true;
        }
        result = this.searchInternal(state, tagKey, 0, loadOutput);
        if (result) {
            this.searchResult = true;
            return true;
        }
        result = this.searchInternal(state, 0, 0, loadOutput);
        if (result) {
            this.searchResult = true;
            return true;
        }
        return false;
    }

    private boolean searchInternal(int state, int tagKey, int valueKey, boolean loadOutput) {
        this.values[this.storage.PROPS.R_TAG.getId()] = tagKey;
        this.values[this.storage.PROPS.R_VALUE.getId()] = valueKey;
        this.values[this.storage.PROPS.R_DISABLE.getId()] = 0;
        RenderingRule accept = this.storage.getRule(state, tagKey, valueKey);
        if (accept == null) {
            return false;
        }
        boolean match = this.visitRule(accept, loadOutput);
        if (match && this.values[this.storage.PROPS.R_DISABLE.getId()] != 0) {
            return false;
        }
        return match;
    }

    private boolean visitRule(RenderingRule rule, boolean loadOutput) {
        boolean fit;
        RenderingRule rr;
        boolean input = this.checkInputProperties(rule);
        if (!input) {
            return false;
        }
        if (!loadOutput && !rule.isGroup()) {
            return true;
        }
        if (!rule.isGroup()) {
            this.loadOutputProperties(rule, true);
        }
        boolean match = false;
        Iterator<RenderingRule> iterator = rule.getIfElseChildren().iterator();
        while (iterator.hasNext() && !(match = this.visitRule(rr = iterator.next(), loadOutput))) {
        }
        boolean bl = fit = match || !rule.isGroup();
        if (fit && loadOutput) {
            if (rule.isGroup()) {
                this.loadOutputProperties(rule, false);
            }
            for (RenderingRule rr2 : rule.getIfChildren()) {
                this.visitRule(rr2, loadOutput);
            }
        }
        return fit;
    }

    public void loadOutputProperties(RenderingRule rule, boolean override) {
        RenderingRuleProperty[] properties = rule.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            RenderingRuleProperty rp = properties[i];
            if (!rp.isOutputProperty() || this.isSpecified(rp) && !override) continue;
            RenderingRule rr = rule.getAttrProp(i);
            if (rr != null) {
                this.visitRule(rr, true);
                if (this.isSpecified(this.storage.PROPS.R_ATTR_COLOR_VALUE)) {
                    this.values[rp.getId()] = this.getIntPropertyValue(this.storage.PROPS.R_ATTR_COLOR_VALUE);
                    continue;
                }
                if (this.isSpecified(this.storage.PROPS.R_ATTR_INT_VALUE)) {
                    this.values[rp.getId()] = this.getIntPropertyValue(this.storage.PROPS.R_ATTR_INT_VALUE);
                    this.fvalues[rp.getId()] = this.getFloatPropertyValue(this.storage.PROPS.R_ATTR_INT_VALUE);
                    continue;
                }
                if (!this.isSpecified(this.storage.PROPS.R_ATTR_BOOL_VALUE)) continue;
                this.values[rp.getId()] = this.getIntPropertyValue(this.storage.PROPS.R_ATTR_BOOL_VALUE);
                continue;
            }
            if (rp.isFloat()) {
                this.fvalues[rp.getId()] = rule.getFloatProp(i);
                this.values[rp.getId()] = rule.getIntProp(i);
                continue;
            }
            this.values[rp.getId()] = rule.getIntProp(i);
        }
    }

    protected boolean checkInputProperties(RenderingRule rule) {
        RenderingRuleProperty[] properties = rule.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            RenderingRuleProperty rp = properties[i];
            if (rp.isInputProperty()) {
                boolean match = rp.isFloat() ? rp.accept(rule.getFloatProp(i), this.fvalues[rp.getId()], this) : rp.accept(rule.getIntProp(i), this.values[rp.getId()], this);
                if (match) continue;
                return false;
            }
            if (rp != this.storage.PROPS.R_DISABLE) continue;
            this.values[rp.getId()] = rule.getIntProp(i);
        }
        return true;
    }

    public boolean isSpecified(RenderingRuleProperty property) {
        if (property.isFloat()) {
            return this.fvalues[property.getId()] != 0.0f || this.values[property.getId()] != -1;
        }
        int val = this.values[property.getId()];
        if (property.isColor()) {
            return val != 0;
        }
        return val != -1;
    }

    public RenderingRuleProperty[] getProperties() {
        return this.props;
    }

    public String getStringPropertyValue(RenderingRuleProperty property) {
        int val = this.values[property.getId()];
        if (val < 0) {
            return null;
        }
        return this.storage.getStringValue(val);
    }

    public float getFloatPropertyValue(RenderingRuleProperty property) {
        return this.fvalues[property.getId()];
    }

    public float getFloatPropertyValue(RenderingRuleProperty property, float defVal) {
        float f = this.fvalues[property.getId()];
        if (f == 0.0f) {
            return defVal;
        }
        return f;
    }

    public String getColorStringPropertyValue(RenderingRuleProperty property) {
        return Algorithms.colorToString(this.values[property.getId()]);
    }

    public int getIntPropertyValue(RenderingRuleProperty property) {
        return this.values[property.getId()];
    }

    public boolean getBoolPropertyValue(RenderingRuleProperty property) {
        int val = this.values[property.getId()];
        return val != -1 && val != 0;
    }

    public int getIntPropertyValue(RenderingRuleProperty property, int defValue) {
        int val = this.values[property.getId()];
        return val == -1 ? defValue : val;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("object ").append(this.object).append("\n");
        for (int i = 0; i < this.props.length; ++i) {
            RenderingRuleProperty property = this.props[i];
            if (!this.isSpecified(property)) continue;
            builder.append(i).append(" ").append(property.getAttrName()).append(" ");
            if (property.type == 1) {
                builder.append(this.getIntPropertyValue(property));
            } else if (property.type == 2) {
                builder.append(this.getFloatPropertyValue(property));
            } else if (property.type == 3) {
                builder.append(this.getStringPropertyValue(property));
            } else if (property.type == 4) {
                builder.append(this.getColorStringPropertyValue(property));
            } else if (property.type == 5) {
                builder.append(this.getBoolPropertyValue(property));
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public String searchIconByTags(Map<String, String> transformedTags) {
        return this.searchTopOrderedPropertyByTags(transformedTags, 1, this.storage.PROPS.R_ICON, this.storage.PROPS.R_ICON_ORDER);
    }

    private String searchTopOrderedPropertyByTags(Map<String, String> transformedTags, int rulesNumber, RenderingRuleProperty mainStringProperty, RenderingRuleProperty orderIntProperty) {
        HashMap<String, Integer> resultOrderMap = new HashMap<String, Integer>();
        for (Map.Entry<String, String> entry : transformedTags.entrySet()) {
            String tag = entry.getKey();
            String value = entry.getValue();
            this.clearState();
            this.setStringFilter(this.storage.PROPS.R_TAG, tag);
            this.setStringFilter(this.storage.PROPS.R_VALUE, value);
            this.clearValue(this.storage.PROPS.R_ADDITIONAL);
            int order = 0;
            String result = null;
            this.search(rulesNumber);
            if (this.isSpecified(mainStringProperty)) {
                result = this.getStringPropertyValue(mainStringProperty);
                order = orderIntProperty != null ? this.getIntPropertyValue(orderIntProperty) : 0;
            }
            for (Map.Entry<String, String> additional : transformedTags.entrySet()) {
                String childResult;
                String aTag = additional.getKey();
                String aValue = additional.getValue();
                if (aTag.equals(tag) && aValue.equals(value)) continue;
                this.setStringFilter(this.storage.PROPS.R_ADDITIONAL, aTag + "=" + aValue);
                this.search(rulesNumber);
                if (!this.isSpecified(mainStringProperty) || (childResult = this.getStringPropertyValue(mainStringProperty)) == null || result != null && result.equals(childResult)) continue;
                order = orderIntProperty != null ? this.getIntPropertyValue(orderIntProperty) : 0;
                result = childResult;
                break;
            }
            if (result == null) continue;
            resultOrderMap.put(result, order);
        }
        if (!resultOrderMap.isEmpty()) {
            Map.Entry bestResult = Collections.min(resultOrderMap.entrySet(), Comparator.comparingInt(Map.Entry::getValue));
            return (String)bestResult.getKey();
        }
        return null;
    }

    public void setClassProperty(String tag, String value) {
        this.classProperties.put(tag, value);
    }
}

