/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.osmand.osm.AbstractPoiType;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiCategory;
import net.osmand.osm.PoiFilter;

public class PoiType
extends AbstractPoiType {
    public static final int DEFAULT_ORDER = 90;
    public static final int DEFAULT_MIN_COUNT = 3;
    public static final int DEFAULT_MAX_PER_MAP = 100;
    private PoiCategory category;
    private PoiFilter filter;
    private AbstractPoiType parentType;
    private PoiType referenceType;
    private String osmTag;
    private String osmTag2;
    private String osmValue;
    private String osmValue2;
    private String editTag;
    private String editValue;
    private String editTag2;
    private String editValue2;
    private boolean filterOnly;
    private String nameTag;
    private boolean text;
    private boolean nameOnly;
    private boolean relation;
    private int order = 90;
    private boolean topIndex = false;
    private boolean hidden = false;
    private int maxPerMap;
    private int minCount;

    public PoiType(MapPoiTypes poiTypes, PoiCategory category, PoiFilter filter, String keyName, String iconName) {
        super(keyName, poiTypes, iconName);
        this.category = category;
        this.filter = filter;
    }

    public PoiType getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(PoiType referenceType) {
        this.referenceType = referenceType;
    }

    public boolean isReference() {
        return this.referenceType != null;
    }

    public String getOsmTag() {
        if (this.isReference()) {
            return this.referenceType.getOsmTag();
        }
        if (this.editTag != null) {
            return this.editTag;
        }
        if (this.osmTag != null && this.osmTag.startsWith("osmand_amenity")) {
            return "amenity";
        }
        return this.osmTag;
    }

    public String getRawOsmTag() {
        if (this.isReference()) {
            return this.referenceType.getOsmTag();
        }
        return this.osmTag;
    }

    public void setOsmEditTagValue(String osmTag, String editValue) {
        this.editTag = osmTag;
        this.editValue = editValue;
    }

    public void setOsmEditTagValue2(String osmTag, String editValue) {
        this.editTag2 = osmTag;
        this.editValue2 = editValue;
    }

    public String getEditOsmTag() {
        if (this.isReference()) {
            return this.referenceType.getEditOsmTag();
        }
        if (this.editTag == null) {
            return this.getOsmTag();
        }
        return this.editTag;
    }

    public String getEditOsmValue() {
        if (this.isReference()) {
            return this.referenceType.getEditOsmValue();
        }
        if (this.editValue == null) {
            return this.getOsmValue();
        }
        return this.editValue;
    }

    public String getEditOsmTag2() {
        if (this.isReference()) {
            return this.referenceType.getEditOsmTag2();
        }
        return this.editTag2;
    }

    public String getEditOsmValue2() {
        if (this.isReference()) {
            return this.referenceType.getEditOsmValue2();
        }
        return this.editValue2;
    }

    public void setOsmTag(String osmTag) {
        this.osmTag = osmTag;
    }

    public String getOsmTag2() {
        if (this.isReference()) {
            return this.referenceType.getOsmTag2();
        }
        return this.osmTag2;
    }

    public void setOsmTag2(String osmTag2) {
        this.osmTag2 = osmTag2;
    }

    public String getOsmValue() {
        if (this.isReference()) {
            return this.referenceType.getOsmValue();
        }
        return this.osmValue;
    }

    public void setOsmValue(String osmValue) {
        this.osmValue = osmValue;
    }

    public String getOsmValue2() {
        if (this.isReference()) {
            return this.referenceType.getOsmValue2();
        }
        return this.osmValue2;
    }

    public void setOsmValue2(String osmValue2) {
        this.osmValue2 = osmValue2;
    }

    public boolean isFilterOnly() {
        return this.filterOnly;
    }

    public void setFilterOnly(boolean filterOnly) {
        this.filterOnly = filterOnly;
    }

    public PoiCategory getCategory() {
        return this.category;
    }

    public PoiFilter getFilter() {
        return this.filter;
    }

    @Override
    public Map<PoiCategory, LinkedHashSet<String>> putTypes(Map<PoiCategory, LinkedHashSet<String>> acceptedTypes) {
        LinkedHashSet<String> set;
        PoiType poiType;
        if (this.isAdditional()) {
            this.parentType.putTypes(acceptedTypes);
            if (this.filterOnly) {
                LinkedHashSet<String> set2 = acceptedTypes.get(this.category);
                for (PoiType pt : this.category.getPoiTypes()) {
                    List<PoiType> poiAdditionals = pt.getPoiAdditionals();
                    if (poiAdditionals == null) continue;
                    for (PoiType poiType2 : poiAdditionals) {
                        if (!poiType2.getKeyName().equals(this.keyName)) continue;
                        set2.add(pt.getKeyName());
                    }
                }
            }
            return acceptedTypes;
        }
        PoiType rt = this.getReferenceType();
        PoiType poiType3 = poiType = rt != null ? rt : this;
        if (!acceptedTypes.containsKey(poiType.category)) {
            acceptedTypes.put(poiType.category, new LinkedHashSet());
        }
        if ((set = acceptedTypes.get(poiType.category)) != null) {
            set.add(poiType.getKeyName());
        }
        return acceptedTypes;
    }

    @Override
    public String getParentTypeName() {
        if (this.parentType != null) {
            return this.parentType.getTranslation();
        }
        if (this.category != null) {
            return this.category.getTranslation();
        }
        return "";
    }

    public void setAdditional(AbstractPoiType parentType) {
        this.parentType = parentType;
    }

    @Override
    public boolean isAdditional() {
        return this.parentType != null;
    }

    public AbstractPoiType getParentType() {
        return this.parentType;
    }

    public boolean isText() {
        return this.text;
    }

    public void setText(boolean text) {
        this.text = text;
    }

    public String getNameTag() {
        return this.nameTag;
    }

    public void setNameTag(String nameTag) {
        this.nameTag = nameTag;
    }

    public boolean isNameOnly() {
        return this.nameOnly;
    }

    public void setNameOnly(boolean nameOnly) {
        this.nameOnly = nameOnly;
    }

    public boolean isRelation() {
        return this.relation;
    }

    public void setRelation(boolean relation) {
        this.relation = relation;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public String toString() {
        return "PoiType{category=" + String.valueOf(this.category) + ", parentType=" + String.valueOf(this.parentType) + ", referenceType=" + String.valueOf(this.referenceType) + ", osmTag='" + this.osmTag + "', osmTag2='" + this.osmTag2 + "', osmValue='" + this.osmValue + "', osmValue2='" + this.osmValue2 + "', text=" + this.text + ", nameOnly=" + this.nameOnly + ", relation=" + this.relation + ", order=" + this.order + ", hidden=" + this.hidden + "}";
    }

    public boolean isTopIndex() {
        return this.topIndex;
    }

    public void setTopIndex(boolean topIndex) {
        this.topIndex = topIndex;
    }

    public int getMaxPerMap() {
        return this.maxPerMap;
    }

    public void setMaxPerMap(int maxPerMap) {
        this.maxPerMap = maxPerMap;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public void setMinCount(int minCount) {
        this.minCount = minCount;
    }

    public Map<String, String> getOsmTagsValues() {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        String tag1 = this.getRawOsmTag();
        String val1 = this.getOsmValue();
        if (tag1 != null && val1 != null) {
            tags.put(tag1, val1);
        }
        String tag2 = this.getOsmTag2();
        String val2 = this.getOsmValue2();
        if (tag2 != null && val2 != null) {
            tags.put(tag2, val2);
        }
        return tags;
    }
}

