/*
 * Decompiled with CFR 0.152.
 */
package net.osmand;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.StringTokenizer;

public class LocationConvert {
    public static final int FORMAT_DEGREES = 0;
    public static final int FORMAT_MINUTES = 1;
    public static final int FORMAT_SECONDS = 2;
    public static final int UTM_FORMAT = 3;
    public static final int OLC_FORMAT = 4;
    public static final int MGRS_FORMAT = 5;
    public static final int SWISS_GRID_FORMAT = 6;
    public static final int SWISS_GRID_PLUS_FORMAT = 7;
    private static final char DELIM = ':';
    private static final char DELIMITER_DEGREES = '\u00b0';
    private static final char DELIMITER_MINUTES = '\u2032';
    private static final char DELIMITER_SECONDS = '\u2033';
    private static final char DELIMITER_SPACE = ' ';

    public static double convert(String coordinate, boolean throwException) {
        StringTokenizer st;
        int tokens;
        if ((coordinate = coordinate.replace(' ', ':').replace('#', ':').replace(',', '.').replace('\'', ':').replace('\"', ':')) == null) {
            if (!throwException) {
                return Double.NaN;
            }
            throw new NullPointerException("coordinate");
        }
        boolean negative = false;
        if (coordinate.charAt(0) == '-') {
            coordinate = coordinate.substring(1);
            negative = true;
        }
        if ((tokens = (st = new StringTokenizer(coordinate, ":")).countTokens()) < 1) {
            if (!throwException) {
                return Double.NaN;
            }
            throw new IllegalArgumentException("coordinate=" + coordinate);
        }
        try {
            boolean isNegative180;
            double min;
            String degrees = st.nextToken();
            if (tokens == 1) {
                double val = Double.parseDouble(degrees);
                return negative ? -val : val;
            }
            String minutes = st.nextToken();
            int deg = Integer.parseInt(degrees);
            double sec = 0.0;
            if (st.hasMoreTokens()) {
                min = Integer.parseInt(minutes);
                String seconds = st.nextToken();
                sec = Double.parseDouble(seconds);
            } else {
                min = Double.parseDouble(minutes);
            }
            boolean bl = isNegative180 = negative && deg == 180 && min == 0.0 && sec == 0.0;
            if ((double)deg < 0.0 || deg > 180 && !isNegative180) {
                if (!throwException) {
                    return Double.NaN;
                }
                throw new IllegalArgumentException("coordinate=" + coordinate);
            }
            if (min < 0.0 || min > 60.0) {
                if (!throwException) {
                    return Double.NaN;
                }
                throw new IllegalArgumentException("coordinate=" + coordinate);
            }
            if (sec < 0.0 || sec > 60.0) {
                if (!throwException) {
                    return Double.NaN;
                }
                throw new IllegalArgumentException("coordinate=" + coordinate);
            }
            double val = (double)deg * 3600.0 + min * 60.0 + sec;
            return negative ? -val : (val /= 3600.0);
        }
        catch (NumberFormatException nfe) {
            if (!throwException) {
                return Double.NaN;
            }
            throw new IllegalArgumentException("coordinate=" + coordinate);
        }
    }

    public static String convert(double coordinate, int outputType) {
        if (coordinate < -180.0 || coordinate > 180.0 || Double.isNaN(coordinate)) {
            throw new IllegalArgumentException("coordinate=" + coordinate);
        }
        if (outputType != 0 && outputType != 1 && outputType != 2) {
            throw new IllegalArgumentException("outputType=" + outputType);
        }
        StringBuilder sb = new StringBuilder();
        if (coordinate < 0.0) {
            sb.append('-');
            coordinate = -coordinate;
        }
        DecimalFormat df = new DecimalFormat("##0.00000", new DecimalFormatSymbols(Locale.US));
        if (outputType == 1 || outputType == 2) {
            coordinate = LocationConvert.formatCoordinate(coordinate, sb, ':');
            if (outputType == 2) {
                coordinate = LocationConvert.formatCoordinate(coordinate, sb, ':');
            }
        }
        sb.append(df.format(coordinate));
        return sb.toString();
    }

    public static String convertLatitude(double latitude, int outputType, boolean addCardinalDirection) throws IllegalArgumentException {
        if (latitude < -90.0 || latitude > 90.0 || Double.isNaN(latitude)) {
            throw new IllegalArgumentException("latitude=" + latitude);
        }
        if (outputType != 0 && outputType != 1 && outputType != 2) {
            throw new IllegalArgumentException("outputType=" + outputType);
        }
        StringBuilder sb = new StringBuilder();
        if (!addCardinalDirection && latitude < 0.0) {
            sb.append('-');
        }
        LocationConvert.formatDegrees(latitude < 0.0 ? -latitude : latitude, outputType, sb);
        if (addCardinalDirection) {
            sb.append(' ').append(latitude < 0.0 ? (char)'S' : 'N');
        }
        return sb.toString();
    }

    public static String convertLongitude(double longitude, int outputType, boolean addCardinalDirection) {
        if (longitude < -180.0 || longitude > 180.0 || Double.isNaN(longitude)) {
            throw new IllegalArgumentException("longitude=" + longitude);
        }
        if (outputType != 0 && outputType != 1 && outputType != 2) {
            throw new IllegalArgumentException("outputType=" + outputType);
        }
        StringBuilder sb = new StringBuilder();
        if (!addCardinalDirection && longitude < 0.0) {
            sb.append('-');
        }
        LocationConvert.formatDegrees(longitude < 0.0 ? -longitude : longitude, outputType, sb);
        if (addCardinalDirection) {
            sb.append(' ').append(longitude < 0.0 ? (char)'W' : 'E');
        }
        return sb.toString();
    }

    private static double formatCoordinate(double coordinate, StringBuilder sb, char delimiter) {
        int deg = (int)Math.floor(coordinate);
        sb.append(deg);
        sb.append(delimiter);
        coordinate -= (double)deg;
        return coordinate *= 60.0;
    }

    private static String formatDegrees(double coordinate, int outputType, StringBuilder sb) {
        if (outputType == 0) {
            sb.append(new DecimalFormat("##0.00000", new DecimalFormatSymbols(Locale.US)).format(coordinate));
            sb.append('\u00b0');
        } else if (outputType == 1) {
            coordinate = LocationConvert.formatCoordinate(coordinate, sb, '\u00b0');
            sb.append(' ');
            sb.append(new DecimalFormat("00.000", new DecimalFormatSymbols(Locale.US)).format(coordinate));
            sb.append('\u2032');
        } else if (outputType == 2) {
            coordinate = LocationConvert.formatCoordinate(coordinate, sb, '\u00b0');
            sb.append(' ');
            coordinate = LocationConvert.formatCoordinate(coordinate, sb, '\u2032');
            sb.append(' ');
            sb.append(new DecimalFormat("00.0", new DecimalFormatSymbols(Locale.US)).format(coordinate));
            sb.append('\u2033');
        }
        return sb.toString();
    }
}

