/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.osmand.CallbackWithObject;
import net.osmand.IProgress;
import net.osmand.PlatformUtil;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.util.CollectionUtils;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class Algorithms {
    private static final int BUFFER_SIZE = 1024;
    private static final Log log = PlatformUtil.getLog(Algorithms.class);
    private static final char[] CHARS_TO_NORMALIZE_KEY = new char[]{'\u2019'};
    private static final char[] CHARS_TO_NORMALIZE_VALUE = new char[]{'\''};
    public static final NumberFormat DECIMAL_FORMAT = new DecimalFormat("#.#", new DecimalFormatSymbols(Locale.US));
    private static final String HTML_PATTERN = "<(\"[^\"]*\"|'[^']*'|[^'\">])*>";
    public static final int ZIP_FILE_SIGNATURE = 1347093252;
    public static final int XML_FILE_SIGNATURE = 1010792557;
    public static final int OBF_FILE_SIGNATURE = 134385665;
    public static final int SQLITE_FILE_SIGNATURE = 1397836905;
    public static final int BZIP_FILE_SIGNATURE = 16986;
    public static final int GZIP_FILE_SIGNATURE = 8075;
    private static final char CHAR_TO_SPLIT = '\u0001';
    public static final String DEFAULT_SERIALIZER = ",";

    public static String normalizeSearchText(String s) {
        boolean norm = false;
        block0: for (int i = 0; i < s.length() && !norm; ++i) {
            char ch = s.charAt(i);
            for (int j = 0; j < CHARS_TO_NORMALIZE_KEY.length; ++j) {
                if (ch != CHARS_TO_NORMALIZE_KEY[j]) continue;
                norm = true;
                continue block0;
            }
        }
        if (!norm) {
            return s;
        }
        for (int k = 0; k < CHARS_TO_NORMALIZE_KEY.length; ++k) {
            s = s.replace(CHARS_TO_NORMALIZE_KEY[k], CHARS_TO_NORMALIZE_VALUE[k]);
        }
        return s;
    }

    public static List<String> splitByWordsLowercase(String str) {
        ArrayList<String> splitStr = new ArrayList<String>();
        int prev = -1;
        for (int i = 0; i <= str.length(); ++i) {
            if (i == str.length() || !Character.isLetter(str.charAt(i)) && !Character.isDigit(str.charAt(i))) {
                if (prev == -1) continue;
                String subStr = str.substring(prev, i);
                splitStr.add(subStr.toLowerCase());
                prev = -1;
                continue;
            }
            if (prev != -1) continue;
            prev = i;
        }
        return splitStr;
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null || c.size() == 0;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.size() == 0;
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static String emptyIfNull(String s) {
        return s == null ? "" : s;
    }

    public static String trimIfNotNull(String s) {
        return s == null ? null : s.trim();
    }

    public static boolean isEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static int hash(Object ... values) {
        return Arrays.hashCode(values);
    }

    public static boolean stringsEqual(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null) {
            return false;
        }
        if (s2 == null) {
            return false;
        }
        return s2.equals(s1);
    }

    public static long parseLongSilently(String input, long def) {
        if (!Algorithms.isEmpty(input)) {
            try {
                return Long.parseLong(input);
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    public static int parseIntSilently(String input, int def) {
        if (!Algorithms.isEmpty(input)) {
            try {
                return Integer.parseInt(input);
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    public static double parseDoubleSilently(String input, double def) {
        if (!Algorithms.isEmpty(input)) {
            try {
                return Double.parseDouble(input);
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    public static float parseFloatSilently(String input, float def) {
        if (!Algorithms.isEmpty(input)) {
            try {
                return Float.parseFloat(input);
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    public static boolean isFirstPolygonInsideSecond(List<LatLon> firstPolygon, List<LatLon> secondPolygon) {
        for (LatLon point : firstPolygon) {
            if (Algorithms.isPointInsidePolygon(point, secondPolygon)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPointInsidePolygon(LatLon point, List<LatLon> polygon) {
        double px = point.getLongitude();
        double py = point.getLatitude();
        boolean oddNodes = false;
        int i = 0;
        int j = polygon.size() - 1;
        while (i < polygon.size()) {
            double x1 = polygon.get(i).getLongitude();
            double y1 = polygon.get(i).getLatitude();
            double x2 = polygon.get(j).getLongitude();
            double y2 = polygon.get(j).getLatitude();
            if ((y1 < py && y2 >= py || y2 < py && y1 >= py) && (x1 <= px || x2 <= px) && x1 + (py - y1) / (y2 - y1) * (x2 - x1) < px) {
                oddNodes = !oddNodes;
            }
            j = i++;
        }
        return oddNodes;
    }

    public static String getFileNameWithoutExtensionAndRoadSuffix(String fileName) {
        String name = Algorithms.getFileNameWithoutExtension(fileName);
        return name.endsWith(".road") ? name.substring(0, name.lastIndexOf(".road")) : name;
    }

    public static String getFileNameWithoutExtension(File f) {
        return Algorithms.getFileNameWithoutExtension(f.getName());
    }

    public static String getFileNameWithoutExtension(String name) {
        int index;
        if (name != null && (index = name.lastIndexOf(46)) != -1) {
            return name.substring(0, index);
        }
        return name;
    }

    public static String getFileExtension(File f) {
        return Algorithms.getFileNameExtension(f.getName());
    }

    public static String getFileNameExtension(String name) {
        int i = name.lastIndexOf(".");
        return name.substring(i + 1);
    }

    public static String getFileWithoutDirs(String name) {
        int i = name.lastIndexOf(File.separator);
        if (i != -1) {
            return name.substring(i + 1);
        }
        return name;
    }

    public static String convertToPermittedFileName(String name) {
        name = name.replace("\"", "~");
        name = name.replace("*", "~");
        name = name.replace("/", "~");
        name = name.replace(":", "~");
        name = name.replace("<", "~");
        name = name.replace(">", "~");
        name = name.replace("?", "~");
        name = name.replace("\\", "~");
        name = name.replace("|", "~");
        return name;
    }

    public static List<File> collectDirs(File parentDir, List<File> dirs) {
        return Algorithms.collectDirs(parentDir, dirs, null);
    }

    public static List<File> collectDirs(File parentDir, List<File> dirs, File exclDir) {
        Object[] files = parentDir.listFiles();
        if (files != null) {
            Arrays.sort(files);
            for (Object file : files) {
                if (!((File)file).isDirectory()) continue;
                if (!((File)file).equals(exclDir)) {
                    dirs.add((File)file);
                }
                Algorithms.collectDirs((File)file, dirs, exclDir);
            }
        }
        return dirs;
    }

    public static File[] getSortedFilesVersions(File dir) {
        File[] listFiles = dir.listFiles();
        if (listFiles != null) {
            Arrays.sort(listFiles, Algorithms.getFileVersionComparator());
        }
        return listFiles;
    }

    public static Comparator<File> getFileVersionComparator() {
        return new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return -Algorithms.simplifyFileName(o1.getName()).compareTo(Algorithms.simplifyFileName(o2.getName()));
            }
        };
    }

    public static String getRegionName(String filename) {
        int ind;
        String lc = filename.toLowerCase();
        int firstPoint = lc.indexOf(".");
        if (firstPoint != -1) {
            lc = lc.substring(0, firstPoint);
        }
        for (ind = lc.length() - 1; ind > 0 && (lc.charAt(ind) >= '0' && lc.charAt(ind) <= '9' || lc.charAt(ind) == '_'); --ind) {
        }
        return lc.substring(0, ind + 1);
    }

    private static String simplifyFileName(String filename) {
        Object lc = filename.toLowerCase();
        if (((String)lc).contains(".")) {
            lc = ((String)lc).substring(0, ((String)lc).indexOf("."));
        }
        if (((String)lc).endsWith("_2")) {
            lc = ((String)lc).substring(0, ((String)lc).length() - "_2".length());
        }
        boolean hasTimestampEnd = false;
        for (int i = 0; i < ((String)lc).length(); ++i) {
            if (((String)lc).charAt(i) < '0' || ((String)lc).charAt(i) > '9') continue;
            hasTimestampEnd = true;
            break;
        }
        if (!hasTimestampEnd) {
            lc = (String)lc + "_00_00_00";
        }
        return lc;
    }

    public static Comparator<String> getStringVersionComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return -Algorithms.simplifyFileName(o1).compareTo(Algorithms.simplifyFileName(o2));
            }
        };
    }

    public static Map<String, String> decodeMap(String s) {
        if (Algorithms.isEmpty(s)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> names = new HashMap<String, String>();
        String[] split = s.split("\u0001");
        for (int i = 1; i < split.length; i += 2) {
            names.put(split[i - 1], split[i]);
        }
        return names;
    }

    public static String encodeMap(Map<String, String> names) {
        if (names != null) {
            Iterator<Map.Entry<String, String>> it = names.entrySet().iterator();
            StringBuilder bld = new StringBuilder();
            while (it.hasNext()) {
                Map.Entry<String, String> e = it.next();
                bld.append(e.getKey()).append('\u0001').append(e.getValue().replace('\u0001', '\u0002'));
                bld.append('\u0001');
            }
            return bld.toString();
        }
        return "";
    }

    public static Set<String> decodeStringSet(String s) {
        return Algorithms.decodeStringSet(s, String.valueOf('\u0001'));
    }

    public static Set<String> decodeStringSet(String s, String split) {
        if (Algorithms.isEmpty(s)) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(s.split(split)));
    }

    public static <T> String encodeCollection(Collection<T> collection) {
        return Algorithms.encodeCollection(collection, String.valueOf('\u0001'));
    }

    public static <T> String encodeCollection(Collection<T> collection, String split) {
        if (collection != null) {
            StringBuilder sb = new StringBuilder();
            for (T item : collection) {
                sb.append(item).append(split);
            }
            return sb.toString();
        }
        return "";
    }

    public static int findFirstNumberEndIndexLegacy(String value) {
        int i = 0;
        boolean valid = false;
        if (value.length() > 0 && value.charAt(0) == '-') {
            ++i;
        }
        while (i < value.length() && (Algorithms.isDigit(value.charAt(i)) || value.charAt(i) == '.')) {
            ++i;
            valid = true;
        }
        if (valid) {
            return i;
        }
        return -1;
    }

    public static int findFirstNumberEndIndex(String value) {
        int i = 0;
        if (value.length() > 0 && value.charAt(0) == '-') {
            ++i;
        }
        int state = 0;
        while (i < value.length() && (Algorithms.isDigit(value.charAt(i)) || value.charAt(i) == '.')) {
            if (value.charAt(i) == '.') {
                if (state == 2) {
                    return i - 1;
                }
                if (state != 1) {
                    return -1;
                }
                state = 2;
            } else if (state == 2) {
                state = 3;
            } else if (state == 0) {
                state = 1;
            }
            ++i;
        }
        if (state == 2) {
            return i - 1;
        }
        if (state == 0) {
            return -1;
        }
        return i;
    }

    public static boolean isDigit(char charAt) {
        return charAt >= '0' && charAt <= '9';
    }

    public static boolean isHtmlText(String text) {
        Pattern pattern = Pattern.compile(HTML_PATTERN);
        Matcher matcher = pattern.matcher(text);
        return matcher.find();
    }

    public static boolean isZipFile(File file) throws IOException {
        if (file.isDirectory()) {
            return false;
        }
        if (!file.canRead()) {
            throw new IOException("Cannot read file " + file.getAbsolutePath());
        }
        if (file.length() < 4L) {
            return false;
        }
        FileInputStream in = new FileInputStream(file);
        int test = Algorithms.readInt(in);
        in.close();
        return test == 1347093252;
    }

    public static boolean checkFileSignature(InputStream inputStream, int fileSignature) throws IOException {
        if (inputStream == null) {
            return false;
        }
        int firstBytes = Algorithms.isSmallFileSignature(fileSignature) ? Algorithms.readSmallInt(inputStream) : Algorithms.readInt(inputStream);
        if (inputStream.markSupported()) {
            inputStream.reset();
        }
        return firstBytes == fileSignature;
    }

    public static boolean isSmallFileSignature(int fileSignature) {
        return fileSignature == 16986 || fileSignature == 8075;
    }

    public static boolean isSubDirectory(File parent, File child) {
        try {
            parent = parent.getCanonicalFile();
            for (File dir = child = child.getCanonicalFile(); dir != null; dir = dir.getParentFile()) {
                if (!parent.equals(dir)) continue;
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    public static int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public static int readSmallInt(InputStream in) throws IOException {
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + ch2;
    }

    public static String capitalizeFirstLetterAndLowercase(String s) {
        if (s != null && s.length() > 1) {
            return Character.toUpperCase(s.charAt(0)) + s.substring(1).toLowerCase();
        }
        return s;
    }

    public static String capitalizeFirstLetter(String s) {
        if (s != null && s.length() > 0) {
            return Character.toUpperCase(s.charAt(0)) + (s.length() > 1 ? s.substring(1) : "");
        }
        return s;
    }

    public static boolean objectEquals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static int parseColor(String colorString) throws IllegalArgumentException {
        if (((String)colorString).charAt(0) == '#') {
            if (((String)colorString).length() == 4) {
                colorString = "#" + ((String)colorString).charAt(1) + ((String)colorString).charAt(1) + ((String)colorString).charAt(2) + ((String)colorString).charAt(2) + ((String)colorString).charAt(3) + ((String)colorString).charAt(3);
            }
            long color = Long.parseLong(((String)colorString).substring(1), 16);
            if (((String)colorString).length() == 7) {
                color |= 0xFFFFFFFFFF000000L;
            } else if (((String)colorString).length() != 9) {
                throw new IllegalArgumentException("Unknown color " + (String)colorString);
            }
            return (int)color;
        }
        throw new IllegalArgumentException("Unknown color " + (String)colorString);
    }

    public static String formatLatlon(LatLon latLon) {
        if (latLon != null) {
            String lat = String.format(Locale.US, "%.6f", latLon.getLatitude());
            String lan = String.format(Locale.US, "%.6f", latLon.getLongitude());
            return lat + DEFAULT_SERIALIZER + lan;
        }
        return null;
    }

    public static LatLon parseLatLon(String latLon) {
        String[] coords;
        if (latLon != null && (coords = latLon.split(DEFAULT_SERIALIZER)).length == 2) {
            try {
                double lat = Double.parseDouble(coords[0]);
                double lon = Double.parseDouble(coords[1]);
                return new LatLon(lat, lon);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static int extractFirstIntegerNumber(String s) {
        int i = 0;
        for (int k = 0; k < s.length() && Algorithms.isDigit(s.charAt(k)); ++k) {
            i = i * 10 + (s.charAt(k) - 48);
        }
        return i;
    }

    public static int extractIntegerNumber(String s) {
        int k;
        int i = 0;
        for (k = 0; k < s.length() && !Algorithms.isDigit(s.charAt(k)); ++k) {
        }
        while (k < s.length() && Algorithms.isDigit(s.charAt(k))) {
            i = i * 10 + (s.charAt(k) - 48);
            ++k;
        }
        return i;
    }

    public static String extractIntegerPrefix(String s) {
        for (int k = 0; k < s.length(); ++k) {
            if (!Character.isDigit(s.charAt(k))) continue;
            return s.substring(0, k);
        }
        return "";
    }

    public static String extractOnlyIntegerSuffix(String s) {
        for (int k = 0; k < s.length(); ++k) {
            if (!Character.isDigit(s.charAt(k))) continue;
            return s.substring(k);
        }
        return "";
    }

    public static String extractIntegerSuffix(String s) {
        for (int k = 0; k < s.length(); ++k) {
            if (Character.isDigit(s.charAt(k))) continue;
            return s.substring(k);
        }
        return "";
    }

    public static void createParentDirsForFile(File file) {
        File parent;
        if (file != null && !file.exists() && (parent = file.getParentFile()) != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileCopy(File src, File dst) throws IOException {
        try (FileOutputStream fout = new FileOutputStream(dst);
             FileInputStream fin = new FileInputStream(src);){
            Algorithms.streamCopy(fin, fout);
        }
    }

    public static void streamCopy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] b = new byte[1024];
        while ((read = in.read(b)) != -1) {
            out.write(b, 0, read);
        }
    }

    public static void streamCopy(InputStream in, OutputStream out, IProgress pg, int bytesDivisor) throws IOException {
        Algorithms.streamCopy(in, out, pg, bytesDivisor, null);
    }

    public static void streamCopy(InputStream in, OutputStream out, IProgress pg, int bytesDivisor, MessageDigest digest) throws IOException {
        int read;
        byte[] b = new byte[1024];
        int cp = 0;
        while ((read = in.read(b)) != -1) {
            out.write(b, 0, read);
            if (digest != null) {
                digest.update(b, 0, read);
            }
            if (pg == null || (cp += read) <= bytesDivisor) continue;
            pg.progress(cp / bytesDivisor);
            cp %= bytesDivisor;
            if (!pg.isInterrupted()) continue;
            throw new InterruptedIOException();
        }
    }

    public static void oneByteStreamCopy(InputStream in, OutputStream out) throws IOException {
        int read;
        while ((read = in.read()) != -1) {
            out.write(read);
        }
    }

    public static void closeStream(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            log.warn((Object)"Closing stream warn", (Throwable)e);
        }
    }

    public static ByteArrayInputStream createByteArrayIS(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Algorithms.streamCopy(in, out);
        in.close();
        return new ByteArrayInputStream(out.toByteArray());
    }

    public static void updateAllExistingImgTilesToOsmandFormat(File f) {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                Algorithms.updateAllExistingImgTilesToOsmandFormat(c);
            }
        } else if (f.getName().endsWith(".png") || f.getName().endsWith(".jpg")) {
            f.renameTo(new File(f.getAbsolutePath() + ".tile"));
        } else if (f.getName().endsWith(".andnav2")) {
            f.renameTo(new File(f.getAbsolutePath().substring(0, f.getAbsolutePath().length() - ".andnav2".length()) + ".tile"));
        }
    }

    public static StringBuilder readFromInputStream(InputStream i) throws IOException {
        return Algorithms.readFromInputStream(i, true);
    }

    public static byte[] readBytesFromInputStream(InputStream i) throws IOException {
        ByteArrayOutputStream bous = new ByteArrayOutputStream();
        Algorithms.streamCopy(i, bous);
        i.close();
        return bous.toByteArray();
    }

    public static StringBuilder readFromInputStream(InputStream i, boolean autoclose) throws IOException {
        StringBuilder responseBody = new StringBuilder();
        responseBody.setLength(0);
        if (i != null) {
            String s;
            BufferedReader in = new BufferedReader(new InputStreamReader(i, "UTF-8"), 256);
            boolean f = true;
            while ((s = in.readLine()) != null) {
                if (!f) {
                    responseBody.append("\n");
                } else {
                    f = false;
                }
                responseBody.append(s);
            }
            if (autoclose) {
                i.close();
            }
        }
        return responseBody;
    }

    public static String gzipToString(byte[] gzip) {
        try {
            if (gzip == null) {
                return null;
            }
            GZIPInputStream gzipIs = new GZIPInputStream(new ByteArrayInputStream(gzip));
            return Algorithms.readFromInputStream(gzipIs).toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] stringToGzip(String str) {
        try {
            if (str == null) {
                return null;
            }
            ByteArrayOutputStream bous = new ByteArrayOutputStream();
            GZIPOutputStream gzout = new GZIPOutputStream(bous);
            gzout.write(str.getBytes());
            gzout.close();
            return bous.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean removeAllFiles(File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (!Algorithms.isEmpty(files)) {
                for (File f : files) {
                    Algorithms.removeAllFiles(f);
                }
            }
            return file.delete();
        }
        return file.delete();
    }

    public static long parseLongFromBytes(byte[] bytes, int offset) {
        long o = 0xFF & bytes[offset + 7];
        o = o << 8 | (long)(0xFF & bytes[offset + 6]);
        o = o << 8 | (long)(0xFF & bytes[offset + 5]);
        o = o << 8 | (long)(0xFF & bytes[offset + 4]);
        o = o << 8 | (long)(0xFF & bytes[offset + 3]);
        o = o << 8 | (long)(0xFF & bytes[offset + 2]);
        o = o << 8 | (long)(0xFF & bytes[offset + 1]);
        o = o << 8 | (long)(0xFF & bytes[offset]);
        return o;
    }

    public static void putLongToBytes(byte[] bytes, int offset, long l) {
        bytes[offset] = (byte)(l & 0xFFL);
        bytes[offset + 1] = (byte)((l >>= 8) & 0xFFL);
        bytes[offset + 2] = (byte)((l >>= 8) & 0xFFL);
        bytes[offset + 3] = (byte)((l >>= 8) & 0xFFL);
        bytes[offset + 4] = (byte)((l >>= 8) & 0xFFL);
        bytes[offset + 5] = (byte)((l >>= 8) & 0xFFL);
        bytes[offset + 6] = (byte)((l >>= 8) & 0xFFL);
        bytes[offset + 7] = (byte)((l >>= 8) & 0xFFL);
    }

    public static int parseIntFromBytes(byte[] bytes, int offset) {
        int o = (0xFF & bytes[offset + 3]) << 24;
        o |= (0xFF & bytes[offset + 2]) << 16;
        o |= (0xFF & bytes[offset + 1]) << 8;
        return o |= 0xFF & bytes[offset];
    }

    public static void putIntToBytes(byte[] bytes, int offset, int l) {
        bytes[offset] = (byte)(l & 0xFF);
        bytes[offset + 1] = (byte)((l >>= 8) & 0xFF);
        bytes[offset + 2] = (byte)((l >>= 8) & 0xFF);
        bytes[offset + 3] = (byte)((l >>= 8) & 0xFF);
    }

    public static void writeLongInt(OutputStream stream, long l) throws IOException {
        stream.write((int)(l & 0xFFL));
        stream.write((int)((l >>= 8) & 0xFFL));
        stream.write((int)((l >>= 8) & 0xFFL));
        stream.write((int)((l >>= 8) & 0xFFL));
        stream.write((int)((l >>= 8) & 0xFFL));
        stream.write((int)((l >>= 8) & 0xFFL));
        stream.write((int)((l >>= 8) & 0xFFL));
        stream.write((int)((l >>= 8) & 0xFFL));
    }

    public static void writeInt(OutputStream stream, int l) throws IOException {
        stream.write(l & 0xFF);
        stream.write((l >>= 8) & 0xFF);
        stream.write((l >>= 8) & 0xFF);
        stream.write((l >>= 8) & 0xFF);
    }

    public static void writeSmallInt(OutputStream stream, int l) throws IOException {
        stream.write(l & 0xFF);
        stream.write((l >>= 8) & 0xFF);
    }

    public static int parseSmallIntFromBytes(byte[] bytes, int offset) {
        int s = (0xFF & bytes[offset + 1]) << 8;
        return s |= 0xFF & bytes[offset];
    }

    public static void putSmallIntBytes(byte[] bytes, int offset, int s) {
        bytes[offset] = (byte)(s & 0xFF);
        bytes[offset + 1] = (byte)((s >>= 8) & 0xFF);
    }

    public static boolean containsDigit(String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isDigit(name.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isInt(double d) {
        return d == Math.floor(d) && !Double.isInfinite(d);
    }

    public static boolean isInt(String value) {
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char ch = value.charAt(i);
            if (Character.isDigit(ch) || length != 1 && i <= 0 && ch == '-') continue;
            return false;
        }
        return true;
    }

    public static <T> T getPercentile(List<T> sortedValues, int percentile) throws IllegalArgumentException {
        if (percentile < 0 || percentile > 100) {
            throw new IllegalArgumentException("invalid percentile " + percentile + ", should be 0-100");
        }
        int index = (sortedValues.size() - 1) * percentile / 100;
        return sortedValues.get(index);
    }

    public static String formatDuration(int seconds, boolean fullForm) {
        String sec = seconds % 60 < 10 ? "0" + seconds % 60 : "" + seconds % 60;
        int minutes = seconds / 60;
        if (!fullForm && minutes < 60) {
            return minutes + ":" + sec;
        }
        String min = minutes % 60 < 10 ? "0" + minutes % 60 : "" + minutes % 60;
        int hours = minutes / 60;
        return hours + ":" + min + ":" + sec;
    }

    public static String formatMinutesDuration(int minutes) {
        return Algorithms.formatMinutesDuration(minutes, false);
    }

    public static String formatMinutesDuration(int minutes, boolean compact) {
        int min = minutes % 60;
        int hours = minutes / 60;
        if (compact) {
            if (min == 0) {
                return String.format(Locale.UK, "%d", hours);
            }
            return String.format(Locale.UK, "%d:%02d", hours, min);
        }
        return String.format(Locale.UK, "%02d:%02d", hours, min);
    }

    public static <T extends Enum<T>> T parseEnumValue(T[] cl, String val, T defaultValue) {
        for (T aCl : cl) {
            if (!((Enum)aCl).name().equalsIgnoreCase(val)) continue;
            return aCl;
        }
        return defaultValue;
    }

    public static String colorToString(int color) {
        if ((0xFF000000 & color) == -16777216) {
            return "#" + Algorithms.format(6, Integer.toHexString(color & 0xFFFFFF));
        }
        return "#" + Algorithms.format(8, Integer.toHexString(color));
    }

    private static String format(int i, String hexString) {
        while (((String)hexString).length() < i) {
            hexString = "0" + (String)hexString;
        }
        return hexString;
    }

    public static int getRainbowColor(double percent) {
        double a = (1.0 - percent) * 5.0;
        int X = (int)Math.floor(a);
        int Y = (int)Math.floor(255.0 * (a - (double)X));
        switch (X) {
            case 0: {
                return -65536 + (Y << 8);
            }
            case 1: {
                return -16711936 + (255 - Y << 16);
            }
            case 2: {
                return -16711936 + Y;
            }
            case 3: {
                return -16776961 + (255 - Y << 8);
            }
            case 4: {
                return -16776961 + (Y << 16);
            }
        }
        return -65281;
    }

    public static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compare(String str1, String str2) {
        return Algorithms.compare(str1, str2, false);
    }

    public static int compare(String str1, String str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return str1.compareTo(str2);
    }

    public static String getFileAsString(File file) {
        try {
            String line;
            FileInputStream fin = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fin, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(line);
            }
            reader.close();
            fin.close();
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, String> parseStringsXml(File file) throws IOException, XmlPullParserException {
        int tok;
        FileInputStream is = new FileInputStream(file);
        XmlPullParser parser = PlatformUtil.newXMLPullParser();
        HashMap<String, String> map = new HashMap<String, String>();
        parser.setInput((InputStream)is, "UTF-8");
        String key = null;
        StringBuilder text = null;
        while ((tok = parser.next()) != 1) {
            if (tok == 2) {
                text = new StringBuilder();
                String name = parser.getName();
                if (!"string".equals(name)) continue;
                key = parser.getAttributeValue("", "name");
                continue;
            }
            if (tok == 4) {
                if (text == null) continue;
                text.append(parser.getText());
                continue;
            }
            if (tok != 3) continue;
            if (key != null) {
                map.put(key, text.toString());
            }
            key = null;
            text = null;
        }
        ((InputStream)is).close();
        return map;
    }

    public static boolean isValidMessageFormat(CharSequence sequence) {
        if (!Algorithms.isEmpty(sequence)) {
            int counter = 0;
            for (int i = 0; i < sequence.length(); ++i) {
                char ch = sequence.charAt(i);
                if (ch == '{') {
                    ++counter;
                    continue;
                }
                if (ch != '}') continue;
                --counter;
            }
            return counter == 0;
        }
        return false;
    }

    public static boolean isUrl(String value) {
        String[] urlPrefixes = new String[]{"http://", "https://", "HTTP://", "HTTPS://"};
        return CollectionUtils.startsWithAny(value, urlPrefixes);
    }

    public static <T> List<WeakReference<T>> updateWeakReferencesList(List<WeakReference<T>> list, T item, boolean isNew) {
        ArrayList<WeakReference<T>> copy = new ArrayList<WeakReference<T>>(list);
        Iterator it = copy.iterator();
        while (it.hasNext()) {
            WeakReference ref = (WeakReference)it.next();
            Object object = ref.get();
            if (object != null && object != item) continue;
            it.remove();
        }
        if (isNew) {
            copy.add(new WeakReference<T>(item));
        }
        return copy;
    }

    public static void extendRectToContainPoint(QuadRect mapRect, double longitude, double latitude) {
        mapRect.left = mapRect.left == 0.0 ? longitude : Math.min(mapRect.left, longitude);
        mapRect.right = Math.max(mapRect.right, longitude);
        mapRect.bottom = mapRect.bottom == 0.0 ? latitude : Math.min(mapRect.bottom, latitude);
        mapRect.top = Math.max(mapRect.top, latitude);
    }

    public static void extendRectToContainRect(QuadRect mapRect, QuadRect gpxRect) {
        mapRect.left = mapRect.left == 0.0 ? gpxRect.left : Math.min(mapRect.left, gpxRect.left);
        mapRect.right = Math.max(mapRect.right, gpxRect.right);
        mapRect.top = Math.max(mapRect.top, gpxRect.top);
        mapRect.bottom = mapRect.bottom == 0.0 ? gpxRect.bottom : Math.min(mapRect.bottom, gpxRect.bottom);
    }

    public static long combine2Points(int x, int y) {
        return (long)x << 32 | (long)y;
    }

    public static String makeUniqueName(String oldName, CallbackWithObject<String> checkNameCallback) {
        String newName;
        String divider;
        int suffix = 0;
        int i = oldName.length() - 1;
        do {
            try {
                if (oldName.charAt(i) == ' ' || oldName.charAt(i) == '-') {
                    throw new NumberFormatException();
                }
                suffix = Integer.parseInt(oldName.substring(i));
            }
            catch (NumberFormatException e) {
                break;
            }
        } while (--i >= 0);
        String string = divider = suffix == 0 ? " " : "";
        while (!checkNameCallback.processResult(newName = oldName.substring(0, i + 1) + divider + ++suffix)) {
        }
        return newName;
    }

    public static int lowerTo10BaseRoundingBounds(int num, int[] roundRange) {
        int k;
        for (k = 1; k < roundRange.length && (roundRange[k] > num || roundRange[k - 1] > num); k += 2) {
        }
        if (k < roundRange.length) {
            return num / roundRange[k - 1] * roundRange[k - 1];
        }
        return num;
    }

    public static int[] generate10BaseRoundingBounds(int max, int multCoef) {
        int basenum = 1;
        int mult = 1;
        int num = basenum * mult;
        int ind = 0;
        ArrayList<Integer> bounds = new ArrayList<Integer>();
        while (num < max) {
            if (++ind % 3 == 1) {
                mult = 2;
            } else if (ind % 3 == 2) {
                mult = 5;
            } else {
                basenum *= 10;
                mult = 1;
            }
            if (ind > 1) {
                int bound;
                for (bound = num * multCoef; bound % (basenum * mult) != 0 && bound > basenum * mult; bound += num) {
                }
                bounds.add(bound);
            }
            num = basenum * mult;
            bounds.add(num);
        }
        int[] ret = new int[bounds.size()];
        for (int j = 0; j < ret.length; ++j) {
            ret[j] = (Integer)bounds.get(bounds.size() - j - 1);
        }
        return ret;
    }

    public static String serializeStringArray(String[] array) {
        return Algorithms.serializeStringArray(array, DEFAULT_SERIALIZER);
    }

    public static String serializeStringArray(String[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            String v = array[i];
            if (v == null) {
                v = "";
            }
            sb.append("\"").append(v.replace("\"", "\"\"")).append("\"");
            if (i >= array.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String[] deserializeStringArray(String serialized) {
        return Algorithms.deserializeStringArray(serialized, DEFAULT_SERIALIZER);
    }

    public static String[] deserializeStringArray(String serialized, String delimiter) {
        if (serialized == null || serialized.trim().length() == 0) {
            return new String[0];
        }
        ArrayList<String> resultList = new ArrayList<String>();
        boolean inQuotes = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < serialized.length(); ++i) {
            char c = serialized.charAt(i);
            if (c == '\"') {
                if (i < serialized.length() - 1 && serialized.charAt(i + 1) == '\"') {
                    sb.append(c);
                    ++i;
                    continue;
                }
                inQuotes = !inQuotes;
                continue;
            }
            if (!inQuotes && c == delimiter.charAt(0)) {
                resultList.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            sb.append(c);
        }
        resultList.add(sb.toString());
        return resultList.toArray(new String[resultList.size()]);
    }

    public static String splitAndClearRepeats(String ref, String symbol) {
        String[] arr = ref.split(symbol);
        Object res = "";
        String prev = "";
        for (String s : arr) {
            if (Algorithms.isEmpty(s) || prev.equals(s)) continue;
            if (!((String)res).isEmpty()) {
                res = (String)res + symbol;
            }
            res = (String)res + s;
            prev = s;
        }
        return res;
    }

    public static String sanitizeFileName(String fileName) {
        return fileName.replace("/", "_").replace("\\", "_").replace(":", "_").replace(";", "_").replace("*", "_").replace("?", "_").replace("`", "_").replace("'", "_").replace("\"", "_").replace("<", "_").replace(">", "_").replace("|", "_").replace("&", "_").replace("\u0000", "_").replace("\n", "_").replace("\r", "_").replace("\t", " ").trim();
    }
}

