/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.TLongCollection;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.osmand.NativeLibrary;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.QuadPointDouble;
import net.osmand.data.QuadRect;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.GeneralRouter;
import net.osmand.router.PrecalculatedRouteDirection;
import net.osmand.router.RouteCalculationProgress;
import net.osmand.router.RouteConditionalHelper;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RouteSegmentResult;
import net.osmand.router.RoutingConfiguration;
import net.osmand.router.VehicleRouter;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class RoutingContext {
    public static boolean SHOW_GC_SIZE = false;
    public static boolean PRINT_ROUTING_ALERTS = false;
    private static final Log log = PlatformUtil.getLog(RoutingContext.class);
    public final RoutingConfiguration config;
    public final RoutePlannerFrontEnd.RouteCalculationMode calculationMode;
    public final Map<BinaryMapIndexReader, List<BinaryMapRouteReaderAdapter.RouteSubregion>> map = new LinkedHashMap<BinaryMapIndexReader, List<BinaryMapRouteReaderAdapter.RouteSubregion>>();
    public final Map<BinaryMapRouteReaderAdapter.RouteRegion, BinaryMapIndexReader> reverseMap = new LinkedHashMap<BinaryMapRouteReaderAdapter.RouteRegion, BinaryMapIndexReader>();
    private RouteConditionalHelper conditionalHelper = new RouteConditionalHelper();
    public NativeLibrary nativeLib;
    public long nativeRoutingContext;
    public boolean keepNativeRoutingContext;
    public int startX;
    public int startY;
    public long startRoadId;
    public int startSegmentInd;
    public boolean startTransportStop;
    public int targetX;
    public int targetY;
    public int[] intermediatesX;
    public int[] intermediatesY;
    public long targetRoadId;
    public int targetSegmentInd;
    public boolean targetTransportStop;
    public int dijkstraMode;
    public boolean publicTransport;
    public HashSet<BinaryMapIndexReader> mapIndexReaderFilter = new HashSet();
    public String[] regionsCoveringStartAndTargets = new String[0];
    public RouteCalculationProgress calculationProgress;
    public RouteCalculationProgress calculationProgressFirstPhase;
    public boolean leftSideNavigation;
    public List<RouteSegmentResult> previouslyCalculatedRoute;
    public PrecalculatedRouteDirection precalculatedRouteDirection;
    TLongObjectHashMap<List<RoutingSubregionTile>> indexedSubregions = new TLongObjectHashMap();
    List<RoutingSubregionTile> subregionTiles = new ArrayList<RoutingSubregionTile>();
    ArrayList<BinaryRoutePlanner.RouteSegment> segmentsToVisitPrescripted = new ArrayList(5);
    ArrayList<BinaryRoutePlanner.RouteSegment> segmentsToVisitNotForbidden = new ArrayList(5);
    public TileStatistics global = new TileStatistics();
    public int memoryOverhead = 0;
    public float routingTime = 0.0f;
    BinaryRoutePlanner.RouteSegmentVisitor visitor = null;
    public int alertFasterRoadToVisitedSegments;
    public int alertSlowerSegmentedWasVisitedEarlier;
    public BinaryRoutePlanner.FinalRouteSegment finalRouteSegment;

    RoutingContext(RoutingContext cp) {
        this.config = cp.config;
        this.map.putAll(cp.map);
        this.calculationMode = cp.calculationMode;
        this.leftSideNavigation = cp.leftSideNavigation;
        this.reverseMap.putAll(cp.reverseMap);
        this.nativeLib = cp.nativeLib;
        this.visitor = cp.visitor;
        this.calculationProgress = cp.calculationProgress;
    }

    RoutingContext(RoutingConfiguration config, NativeLibrary nativeLibrary, BinaryMapIndexReader[] list, RoutePlannerFrontEnd.RouteCalculationMode calcMode) {
        this.calculationMode = calcMode;
        for (BinaryMapIndexReader mr : list) {
            List<BinaryMapRouteReaderAdapter.RouteRegion> rr = mr.getRoutingIndexes();
            ArrayList<BinaryMapRouteReaderAdapter.RouteSubregion> subregions = new ArrayList<BinaryMapRouteReaderAdapter.RouteSubregion>();
            for (BinaryMapRouteReaderAdapter.RouteRegion r : rr) {
                List<BinaryMapRouteReaderAdapter.RouteSubregion> subregs = calcMode == RoutePlannerFrontEnd.RouteCalculationMode.BASE ? r.getBaseSubregions() : r.getSubregions();
                for (BinaryMapRouteReaderAdapter.RouteSubregion rs : subregs) {
                    subregions.add(new BinaryMapRouteReaderAdapter.RouteSubregion(rs));
                }
                this.reverseMap.put(r, mr);
            }
            this.map.put(mr, subregions);
        }
        this.config = config;
        this.nativeLib = nativeLibrary;
        this.intermediatesX = new int[0];
        this.intermediatesY = new int[0];
    }

    public BinaryRoutePlanner.RouteSegmentVisitor getVisitor() {
        return this.visitor;
    }

    public int getCurrentlyLoadedTiles() {
        int cnt = 0;
        for (RoutingSubregionTile t : this.subregionTiles) {
            if (!t.isLoaded()) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getCurrentEstimatedSize() {
        return this.global.size;
    }

    public void setVisitor(BinaryRoutePlanner.RouteSegmentVisitor visitor) {
        this.visitor = visitor;
    }

    public void setRouter(GeneralRouter router) {
        this.config.router = router;
    }

    public void setHeuristicCoefficient(float heuristicCoefficient) {
        this.config.heuristicCoefficient = heuristicCoefficient;
    }

    public VehicleRouter getRouter() {
        return this.config.router;
    }

    public boolean planRouteIn2Directions() {
        return this.config.planRoadDirection == 0;
    }

    public int getPlanRoadDirection() {
        return this.config.planRoadDirection;
    }

    public void initStartAndTargetPoints(BinaryRoutePlanner.RouteSegmentPoint start, BinaryRoutePlanner.RouteSegmentPoint end) {
        this.initTargetPoint(end);
        this.startX = start.preciseX;
        this.startY = start.preciseY;
        this.startRoadId = start.road.getId();
        this.startSegmentInd = start.getSegmentStart();
    }

    public void initTargetPoint(BinaryRoutePlanner.RouteSegmentPoint end) {
        this.targetX = end.preciseX;
        this.targetY = end.preciseY;
        this.targetRoadId = end.road.getId();
        this.targetSegmentInd = end.getSegmentStart();
    }

    public void unloadAllData() {
        this.unloadAllData(null);
    }

    public void unloadAllData(RoutingContext except) {
        for (RoutingSubregionTile tl : this.subregionTiles) {
            if (!tl.isLoaded() || except != null && except.searchSubregionTile(tl.subregion) >= 0) continue;
            tl.unload();
            if (this.calculationProgress != null) {
                ++this.calculationProgress.unloadedTiles;
            }
            this.global.size -= tl.tileStatistics.size;
        }
        this.subregionTiles.clear();
        this.indexedSubregions.clear();
        this.mapIndexReaderFilter = new HashSet();
    }

    private int searchSubregionTile(BinaryMapRouteReaderAdapter.RouteSubregion subregion) {
        RoutingSubregionTile key = new RoutingSubregionTile(subregion);
        int ind = Collections.binarySearch(this.subregionTiles, key, new Comparator<RoutingSubregionTile>(){

            @Override
            public int compare(RoutingSubregionTile o1, RoutingSubregionTile o2) {
                if (o1.subregion.left == o2.subregion.left) {
                    return 0;
                }
                return o1.subregion.left < o2.subregion.left ? 1 : -1;
            }
        });
        if (ind >= 0) {
            for (int i = ind; i <= this.subregionTiles.size(); ++i) {
                if (i == this.subregionTiles.size() || this.subregionTiles.get((int)i).subregion.left > subregion.left) {
                    ind = -i - 1;
                    return ind;
                }
                if (this.subregionTiles.get((int)i).subregion != subregion) continue;
                return i;
            }
        }
        return ind;
    }

    public BinaryRoutePlanner.RouteSegment loadRouteSegment(int x31, int y31, long memoryLimit) {
        return this.loadRouteSegment(x31, y31, memoryLimit, false);
    }

    public BinaryRoutePlanner.RouteSegment loadRouteSegment(int x31, int y31, long memoryLimit, boolean reverseWaySearch) {
        long tileId = this.getRoutingTile(x31, y31, memoryLimit);
        TLongObjectHashMap excludeDuplications = new TLongObjectHashMap();
        BinaryRoutePlanner.RouteSegment original = null;
        List subregions = (List)this.indexedSubregions.get(tileId);
        if (subregions != null) {
            for (int j = 0; j < subregions.size(); ++j) {
                original = ((RoutingSubregionTile)subregions.get(j)).loadRouteSegment(x31, y31, this, (TLongObjectHashMap<RouteDataObject>)excludeDuplications, original, subregions, j, reverseWaySearch);
            }
        }
        return original;
    }

    public void loadSubregionTile(RoutingSubregionTile ts, boolean loadObjectsInMemory, List<RouteDataObject> toLoad, TLongHashSet excludeNotAllowed) {
        long now = System.nanoTime();
        boolean wasUnloaded = ts.isUnloaded();
        int ucount = ts.getUnloadCont();
        if (this.nativeLib == null) {
            List<Object> points = Collections.emptyList();
            if (this.config.getDirectionPoints() != null) {
                points = this.config.getDirectionPoints().queryInBox(new QuadRect(ts.subregion.left, ts.subregion.top, ts.subregion.right, ts.subregion.bottom), new ArrayList());
                int createType = ts.subregion.routeReg.findOrCreateRouteType("osmand_dp", "osmand_add_point");
                for (RoutingConfiguration.DirectionPoint directionPoint : points) {
                    directionPoint.types.clear();
                    for (Map.Entry<String, String> e : directionPoint.getTags().entrySet()) {
                        int type = ts.subregion.routeReg.searchRouteEncodingRule(e.getKey(), e.getValue());
                        if (type == -1) continue;
                        directionPoint.types.add(type);
                    }
                    directionPoint.types.add(createType);
                }
            }
            try {
                BinaryMapIndexReader reader = this.reverseMap.get(ts.subregion.routeReg);
                ts.setLoadedNonNative();
                List<RouteDataObject> res = reader.loadRouteIndexData(ts.subregion);
                if (toLoad != null) {
                    toLoad.addAll(res);
                }
                for (RouteDataObject ro : res) {
                    if (ro == null) continue;
                    if (this.config.ambiguousConditionalTags != null) {
                        this.conditionalHelper.resolveAmbiguousConditionalTags(ro, this.config.ambiguousConditionalTags);
                    }
                    if (this.config.routeCalculationTime != 0L) {
                        this.conditionalHelper.processConditionalTags(ro, this.config.routeCalculationTime);
                    }
                    if (this.config.router.acceptLine(ro) && excludeNotAllowed != null && !excludeNotAllowed.contains(ro.getId())) {
                        if (!this.config.router.attributes.containsKey("check_allow_private_needed")) {
                            this.connectPoint(ts, ro, points);
                        }
                        ts.add(ro);
                    }
                    if (excludeNotAllowed == null || ro.getId() <= 0L) continue;
                    excludeNotAllowed.add(ro.getId());
                    if (ts.excludedIds == null) {
                        ts.excludedIds = new TLongHashSet();
                    }
                    ts.excludedIds.add(ro.getId());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Loading data exception", e);
            }
        } else {
            NativeLibrary.NativeRouteSearchResult ns = this.nativeLib.loadRouteRegion(ts.subregion, loadObjectsInMemory);
            ts.setLoadedNative(ns, this);
        }
        if (this.calculationProgress != null) {
            ++this.calculationProgress.loadedTiles;
        }
        if (wasUnloaded) {
            if (ucount == 1 && this.calculationProgress != null) {
                ++this.calculationProgress.loadedPrevUnloadedTiles;
            }
        } else {
            if (this.global != null) {
                this.global.allRoutes += ts.tileStatistics.allRoutes;
                this.global.coordinates += ts.tileStatistics.coordinates;
            }
            if (this.calculationProgress != null) {
                ++this.calculationProgress.distinctLoadedTiles;
            }
        }
        this.global.size += ts.tileStatistics.size;
        if (this.calculationProgress != null) {
            this.calculationProgress.timeToLoad += System.nanoTime() - now;
        }
    }

    public List<RoutingSubregionTile> loadAllSubregionTiles(BinaryMapIndexReader reader, BinaryMapRouteReaderAdapter.RouteSubregion reg) throws IOException {
        ArrayList<RoutingSubregionTile> list = new ArrayList<RoutingSubregionTile>();
        BinaryMapIndexReader.SearchRequest<RouteDataObject> request = BinaryMapIndexReader.buildSearchRouteRequest(0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        List<BinaryMapRouteReaderAdapter.RouteSubregion> subregs = reader.searchRouteIndexTree(request, Collections.singletonList(reg));
        for (BinaryMapRouteReaderAdapter.RouteSubregion s : subregs) {
            list.add(new RoutingSubregionTile(s));
        }
        return list;
    }

    public List<RoutingSubregionTile> loadTileHeaders(int x31, int y31) {
        int zoomToLoad = 31 - this.config.ZOOM_TO_LOAD_TILES;
        int tileX = x31 >> zoomToLoad;
        int tileY = y31 >> zoomToLoad;
        long now = System.nanoTime();
        BinaryMapIndexReader.SearchRequest<RouteDataObject> request = BinaryMapIndexReader.buildSearchRouteRequest(tileX << zoomToLoad, tileX + 1 << zoomToLoad, tileY << zoomToLoad, tileY + 1 << zoomToLoad, null);
        ArrayList<RoutingSubregionTile> collection = null;
        for (Map.Entry<BinaryMapIndexReader, List<BinaryMapRouteReaderAdapter.RouteSubregion>> r : this.map.entrySet()) {
            boolean isLiveUpdate;
            BinaryMapIndexReader reader = r.getKey();
            boolean bl = isLiveUpdate = reader.getHHRoutingIndexes().size() == 0;
            if (!isLiveUpdate && this.mapIndexReaderFilter.size() > 0 && !this.mapIndexReaderFilter.contains(r.getKey())) continue;
            try {
                boolean intersect = false;
                for (BinaryMapRouteReaderAdapter.RouteSubregion rs : r.getValue()) {
                    if (!request.intersects(rs.left, rs.top, rs.right, rs.bottom)) continue;
                    intersect = true;
                    break;
                }
                if (!intersect) continue;
                List<BinaryMapRouteReaderAdapter.RouteSubregion> subregs = r.getKey().searchRouteIndexTree(request, r.getValue());
                for (BinaryMapRouteReaderAdapter.RouteSubregion sr : subregs) {
                    RoutingSubregionTile found;
                    int ind = this.searchSubregionTile(sr);
                    if (ind < 0) {
                        found = new RoutingSubregionTile(sr);
                        this.subregionTiles.add(-(ind + 1), found);
                    } else {
                        found = this.subregionTiles.get(ind);
                    }
                    if (collection == null) {
                        collection = new ArrayList<RoutingSubregionTile>(4);
                    }
                    collection.add(found);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Loading data exception", e);
            }
        }
        if (this.calculationProgress != null) {
            this.calculationProgress.timeToLoadHeaders += System.nanoTime() - now;
        }
        return collection;
    }

    public void loadTileData(int x31, int y31, int zoomAround, List<RouteDataObject> toFillIn) {
        this.loadTileData(x31, y31, zoomAround, toFillIn, false);
    }

    public void loadTileData(int x31, int y31, int zoomAround, List<RouteDataObject> toFillIn, boolean allowDuplications) {
        int t = this.config.ZOOM_TO_LOAD_TILES - zoomAround;
        int coordinatesShift = 1 << 31 - this.config.ZOOM_TO_LOAD_TILES;
        if (t <= 0) {
            t = 1;
            coordinatesShift = 1 << 31 - zoomAround;
        } else {
            t = 1 << t;
        }
        TLongHashSet ts = new TLongHashSet();
        for (int i = -t; i <= t; ++i) {
            for (int j = -t; j <= t; ++j) {
                ts.add(this.getRoutingTile(x31 + i * coordinatesShift, y31 + j * coordinatesShift, 0L));
            }
        }
        TLongIterator it = ts.iterator();
        TLongObjectHashMap excludeDuplications = new TLongObjectHashMap();
        while (it.hasNext()) {
            this.getAllObjects(it.next(), toFillIn, (TLongObjectHashMap<RouteDataObject>)excludeDuplications);
            if (!allowDuplications) continue;
            excludeDuplications.clear();
        }
    }

    private long getRoutingTile(int x31, int y31, long memoryLimit) {
        List subregions;
        int zmShift = 31 - this.config.ZOOM_TO_LOAD_TILES;
        long xloc = x31 >> zmShift;
        long yloc = y31 >> zmShift;
        long tileId = (xloc << this.config.ZOOM_TO_LOAD_TILES) + yloc;
        if (memoryLimit == 0L) {
            memoryLimit = this.config.memoryLimitation;
        }
        if ((double)this.getCurrentEstimatedSize() > 0.9 * (double)memoryLimit) {
            int sz1 = this.getCurrentEstimatedSize();
            long h1 = 0L;
            if (SHOW_GC_SIZE && (double)sz1 > 0.7 * (double)memoryLimit) {
                RoutingContext.runGCUsedMemory();
                h1 = RoutingContext.runGCUsedMemory();
            }
            int clt = this.getCurrentlyLoadedTiles();
            long us1 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            this.unloadUnusedTiles(memoryLimit);
            if (h1 != 0L && this.getCurrentlyLoadedTiles() != clt) {
                int sz2 = this.getCurrentEstimatedSize();
                long h2 = RoutingContext.runGCUsedMemory();
                float mb = 1048576.0f;
                log.warn((Object)("Unload tiles :  estimated " + (float)(sz1 - sz2) / mb + " ?= " + (float)(h1 - h2) / mb + " actual"));
                log.warn((Object)("Used after " + (float)h2 / mb + " of " + (float)Runtime.getRuntime().totalMemory() / mb));
            } else {
                float mb = 1048576.0f;
                int sz2 = this.getCurrentEstimatedSize();
                log.warn((Object)("Unload tiles :  occupied before " + (float)sz1 / mb + " Mb - now  " + (float)sz2 / mb + "MB " + (float)memoryLimit / mb + " limit MB " + (float)this.config.memoryLimitation / mb));
                long us2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                log.warn((Object)("Used memory before " + (float)us1 / mb + " after " + (float)us1 / mb));
            }
        }
        if (!this.indexedSubregions.containsKey(tileId)) {
            List<RoutingSubregionTile> collection = this.loadTileHeaders(x31, y31);
            this.indexedSubregions.put(tileId, collection);
        }
        if ((subregions = (List)this.indexedSubregions.get(tileId)) != null) {
            boolean load = false;
            for (RoutingSubregionTile ts : subregions) {
                if (ts.isLoaded()) continue;
                load = true;
            }
            if (load) {
                TLongHashSet excludeIds = new TLongHashSet();
                for (RoutingSubregionTile ts : subregions) {
                    if (!ts.isLoaded()) {
                        this.loadSubregionTile(ts, true, null, excludeIds);
                        continue;
                    }
                    if (ts.excludedIds == null) continue;
                    excludeIds.addAll((TLongCollection)ts.excludedIds);
                }
            }
        }
        return tileId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void connectPoint(RoutingSubregionTile ts, RouteDataObject ro, List<RoutingConfiguration.DirectionPoint> points) {
        int createType = ro.region.findOrCreateRouteType("osmand_dp", "osmand_add_point");
        int deleteType = ro.region.findOrCreateRouteType("osmand_dp", "osmand_delete_point");
        for (RoutingConfiguration.DirectionPoint np : points) {
            boolean restrictionByAngle;
            if (np.types.size() == 0) continue;
            int wptX = MapUtils.get31TileNumberX(np.getLongitude());
            int wptY = MapUtils.get31TileNumberY(np.getLatitude());
            int x = ro.getPoint31XTile(0);
            int y = ro.getPoint31YTile(0);
            double mindist = this.config.directionPointsRadius * 2;
            int indexToInsert = 0;
            int mprojx = 0;
            int mprojy = 0;
            for (int i = 1; i < ro.getPointsLength(); ++i) {
                int nx = ro.getPoint31XTile(i);
                int ny = ro.getPoint31YTile(i);
                boolean sgnx = nx - wptX > 0;
                boolean sgx = x - wptX > 0;
                boolean sgny = ny - wptY > 0;
                boolean sgy = y - wptY > 0;
                boolean checkPreciseProjection = true;
                if (sgny == sgy && sgx == sgnx) {
                    double dist = MapUtils.squareRootDist31(wptX, wptY, Math.abs(nx - wptX) < Math.abs(x - wptX) ? nx : x, Math.abs(ny - wptY) < Math.abs(y - wptY) ? ny : y);
                    boolean bl = checkPreciseProjection = dist < (double)this.config.directionPointsRadius;
                }
                if (checkPreciseProjection) {
                    QuadPointDouble pnt = MapUtils.getProjectionPoint31(wptX, wptY, x, y, nx, ny);
                    int projx = (int)pnt.x;
                    int projy = (int)pnt.y;
                    double dist = MapUtils.squareRootDist31(wptX, wptY, projx, projy);
                    if (dist < mindist) {
                        indexToInsert = i;
                        mindist = dist;
                        mprojx = projx;
                        mprojy = projy;
                    }
                }
                x = nx;
                y = ny;
            }
            boolean sameRoadId = np.connected != null && np.connected.getId() == ro.getId();
            boolean pointShouldBeAttachedByDist = mindist < (double)this.config.directionPointsRadius && mindist < np.distance;
            double npAngle = np.getAngle();
            boolean bl = restrictionByAngle = !Double.isNaN(npAngle);
            if (!pointShouldBeAttachedByDist) continue;
            if (restrictionByAngle) {
                double diff;
                int oneWay = ro.getOneway();
                double forwardAngle = Math.toDegrees(ro.directionRoute(indexToInsert, true));
                if ((oneWay == 1 || oneWay == 0) && (diff = Math.abs(MapUtils.degreesDiff(npAngle, forwardAngle))) <= 45.0) {
                    restrictionByAngle = false;
                }
                if (restrictionByAngle && (oneWay == -1 || oneWay == 0) && (diff = Math.abs(MapUtils.degreesDiff(npAngle, forwardAngle + 180.0))) <= 45.0) {
                    restrictionByAngle = false;
                }
            }
            if (restrictionByAngle) continue;
            if (!sameRoadId) {
                if (np.connected != null) {
                    int pointIndex = this.findPointIndex(np, createType);
                    if (pointIndex == -1) throw new RuntimeException();
                    np.connected.setPointTypes(pointIndex, new int[]{deleteType});
                }
            } else {
                int sameRoadPointIndex = this.findPointIndex(np, createType);
                if (sameRoadPointIndex != -1 && np.connected != null) {
                    if (mprojx == np.connectedx && mprojy == np.connectedy) continue;
                    np.connected.setPointTypes(sameRoadPointIndex, new int[]{deleteType});
                }
            }
            np.connectedx = mprojx;
            np.connectedy = mprojy;
            ro.insert(indexToInsert, mprojx, mprojy);
            ro.setPointTypes(indexToInsert, np.types.toArray());
            np.distance = mindist;
            np.connected = ro;
        }
    }

    private int findPointIndex(RoutingConfiguration.DirectionPoint np, int createType) {
        int samePointIndex = -1;
        for (int i = 0; np.connected != null && i < np.connected.getPointsLength(); ++i) {
            int tx = np.connected.getPoint31XTile(i);
            int ty = np.connected.getPoint31YTile(i);
            if (tx != np.connectedx || ty != np.connectedy || !np.connected.hasPointType(i, createType)) continue;
            samePointIndex = i;
            break;
        }
        return samePointIndex;
    }

    public boolean checkIfMemoryLimitCritical(long memoryLimit) {
        return (double)this.getCurrentEstimatedSize() > 0.9 * (double)memoryLimit;
    }

    public void unloadUnusedTiles(long memoryLimit) {
        float desirableSize = (float)memoryLimit * 0.7f;
        ArrayList<RoutingSubregionTile> list = new ArrayList<RoutingSubregionTile>(this.subregionTiles.size() / 2);
        int loaded = 0;
        for (RoutingSubregionTile t : this.subregionTiles) {
            if (!t.isLoaded()) continue;
            list.add(t);
            ++loaded;
        }
        if (this.calculationProgress != null) {
            this.calculationProgress.maxLoadedTiles = Math.max(this.calculationProgress.maxLoadedTiles, this.getCurrentlyLoadedTiles());
        }
        Collections.sort(list, new Comparator<RoutingSubregionTile>(){

            private int pow(int base, int pw) {
                int r = 1;
                for (int i = 0; i < pw; ++i) {
                    r *= base;
                }
                return r;
            }

            @Override
            public int compare(RoutingSubregionTile o1, RoutingSubregionTile o2) {
                int v2;
                int v1 = (o1.access + 1) * this.pow(10, o1.getUnloadCont() - 1);
                return v1 < (v2 = (o2.access + 1) * this.pow(10, o2.getUnloadCont() - 1)) ? -1 : (v1 == v2 ? 0 : 1);
            }
        });
        int i = 0;
        while ((float)this.getCurrentEstimatedSize() >= desirableSize && list.size() - i > loaded / 5 && i < list.size()) {
            RoutingSubregionTile unload = (RoutingSubregionTile)list.get(i);
            ++i;
            unload.unload();
            if (this.calculationProgress != null) {
                ++this.calculationProgress.unloadedTiles;
            }
            this.global.size -= unload.tileStatistics.size;
        }
        for (RoutingSubregionTile t : this.subregionTiles) {
            t.access /= 3;
        }
    }

    private void getAllObjects(long tileId, List<RouteDataObject> toFillIn, TLongObjectHashMap<RouteDataObject> excludeDuplications) {
        List subregions = (List)this.indexedSubregions.get(tileId);
        if (subregions != null) {
            for (RoutingSubregionTile rs : subregions) {
                rs.loadAllObjects(toFillIn, this, excludeDuplications);
            }
        }
    }

    protected static long runGCUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        long usedMem1 = runtime.totalMemory() - runtime.freeMemory();
        int cnt = 1;
        while (cnt-- >= 0) {
            runtime.runFinalization();
            runtime.gc();
            usedMem1 = runtime.totalMemory() - runtime.freeMemory();
        }
        return usedMem1;
    }

    private static long calcRouteId(RouteDataObject o, int ind) {
        return (o.getId() << 10) + (long)ind;
    }

    static int getEstimatedSize(RouteDataObject o) {
        int sz = 0;
        sz += 12;
        if (o.names != null) {
            sz += 12;
            TIntObjectIterator it = o.names.iterator();
            while (it.hasNext()) {
                it.advance();
                String vl = (String)it.value();
                sz += 12 + vl.length();
            }
            sz += 12 + o.names.size() * 25;
        }
        sz += 8;
        sz += (12 + 4 * o.getPointsLength()) * 4;
        sz += o.types == null ? 4 : 12 + 4 * o.types.length;
        sz += o.restrictions == null ? 4 : 12 + 8 * o.restrictions.length;
        sz += 4;
        if (o.pointTypes != null) {
            sz += 8 + 4 * o.pointTypes.length;
            for (int i = 0; i < o.pointTypes.length; ++i) {
                sz += 4;
                if (o.pointTypes[i] == null) continue;
                sz += 8 + 8 * o.pointTypes[i].length;
            }
        }
        return (int)((double)sz * 3.5);
    }

    public BinaryMapIndexReader[] getMaps() {
        return this.map.keySet().toArray(new BinaryMapIndexReader[0]);
    }

    public int getVisitedSegments() {
        if (this.calculationProgress != null) {
            return this.calculationProgress.visitedSegments;
        }
        return 0;
    }

    public int getLoadedTiles() {
        if (this.calculationProgress != null) {
            return this.calculationProgress.loadedTiles;
        }
        return 0;
    }

    public synchronized void deleteNativeRoutingContext() {
        if (this.nativeRoutingContext != 0L) {
            NativeLibrary.deleteNativeRoutingContext(this.nativeRoutingContext);
        }
        this.nativeRoutingContext = 0L;
    }

    protected void finalize() throws Throwable {
        this.deleteNativeRoutingContext();
        super.finalize();
    }

    protected static class TileStatistics {
        public int size = 0;
        public int allRoutes = 0;
        public int coordinates = 0;

        protected TileStatistics() {
        }

        public String toString() {
            return "All routes " + this.allRoutes + " size " + (float)this.size / 1024.0f + " KB coordinates " + this.coordinates + " ratio coord " + (float)this.size / (float)this.coordinates + " ratio routes " + (float)this.size / (float)this.allRoutes;
        }

        public void addObject(RouteDataObject o) {
            ++this.allRoutes;
            this.coordinates += o.getPointsLength() * 2;
            this.size += RoutingContext.getEstimatedSize(o);
        }
    }

    public static class RoutingSubregionTile {
        public final BinaryMapRouteReaderAdapter.RouteSubregion subregion;
        public int access;
        public TileStatistics tileStatistics = new TileStatistics();
        private NativeLibrary.NativeRouteSearchResult searchResult = null;
        private int isLoaded = 0;
        private TLongObjectMap<BinaryRoutePlanner.RouteSegment> routes = null;
        private TLongHashSet excludedIds = null;

        public RoutingSubregionTile(BinaryMapRouteReaderAdapter.RouteSubregion subregion) {
            this.subregion = subregion;
        }

        public TLongObjectMap<BinaryRoutePlanner.RouteSegment> getRoutes() {
            return this.routes;
        }

        public void loadAllObjects(List<RouteDataObject> toFillIn, RoutingContext ctx, TLongObjectHashMap<RouteDataObject> excludeDuplications) {
            block5: {
                RouteDataObject[] objects;
                block4: {
                    if (this.routes == null) break block4;
                    for (BinaryRoutePlanner.RouteSegment rs : this.routes.valueCollection()) {
                        while (rs != null) {
                            RouteDataObject ro = rs.road;
                            if (!excludeDuplications.contains(ro.id)) {
                                excludeDuplications.put(ro.id, (Object)ro);
                                toFillIn.add(ro);
                            }
                            rs = rs.nextLoaded;
                        }
                    }
                    break block5;
                }
                if (this.searchResult == null || (objects = this.searchResult.objects) == null) break block5;
                for (RouteDataObject ro : objects) {
                    if (ro == null || excludeDuplications.contains(ro.id)) continue;
                    excludeDuplications.put(ro.id, (Object)ro);
                    toFillIn.add(ro);
                }
            }
        }

        private BinaryRoutePlanner.RouteSegment loadRouteSegment(int x31, int y31, RoutingContext ctx, TLongObjectHashMap<RouteDataObject> excludeDuplications, BinaryRoutePlanner.RouteSegment original, List<RoutingSubregionTile> subregions, int subregionIndex, boolean reverseWaySearch) {
            ++this.access;
            if (this.routes != null) {
                long l = ((long)x31 << 31) + (long)y31;
                BinaryRoutePlanner.RouteSegment segment = (BinaryRoutePlanner.RouteSegment)this.routes.get(l);
                while (segment != null) {
                    RouteDataObject ro = segment.road;
                    RouteDataObject toCmp = (RouteDataObject)excludeDuplications.get(RoutingContext.calcRouteId(ro, segment.getSegmentStart()));
                    if (!(RoutingSubregionTile.isExcluded(ro.id, subregions, subregionIndex) || toCmp != null && toCmp.getPointsLength() >= ro.getPointsLength())) {
                        excludeDuplications.put(RoutingContext.calcRouteId(ro, segment.getSegmentStart()), (Object)ro);
                        if (reverseWaySearch) {
                            if (segment.reverseSearch == null) {
                                segment.reverseSearch = new BinaryRoutePlanner.RouteSegment(ro, segment.getSegmentStart());
                                segment.reverseSearch.reverseSearch = segment;
                                segment.reverseSearch.nextLoaded = segment.nextLoaded;
                            }
                            segment = segment.reverseSearch;
                        }
                        segment.next = original;
                        original = segment;
                    }
                    segment = segment.nextLoaded;
                }
            } else {
                throw new UnsupportedOperationException("Not clear how it could be used with native");
            }
            return original;
        }

        private static boolean isExcluded(long id, List<RoutingSubregionTile> subregions, int subregionIndex) {
            for (int i = 0; i < subregionIndex; ++i) {
                if (subregions.get((int)i).excludedIds == null || !subregions.get((int)i).excludedIds.contains(id)) continue;
                return true;
            }
            return false;
        }

        public boolean isLoaded() {
            return this.isLoaded > 0;
        }

        public int getUnloadCont() {
            return Math.abs(this.isLoaded);
        }

        public boolean isUnloaded() {
            return this.isLoaded < 0;
        }

        public void unload() {
            this.isLoaded = this.isLoaded == 0 ? -1 : -Math.abs(this.isLoaded);
            if (this.searchResult != null) {
                this.searchResult.deleteNativeResult();
            }
            this.searchResult = null;
            this.routes = null;
            this.excludedIds = null;
        }

        public void setLoadedNonNative() {
            this.isLoaded = Math.abs(this.isLoaded) + 1;
            this.routes = new TLongObjectHashMap();
            this.tileStatistics = new TileStatistics();
        }

        public void add(RouteDataObject ro) {
            this.tileStatistics.addObject(ro);
            for (int i = 0; i < ro.pointsX.length; ++i) {
                int x31 = ro.getPoint31XTile(i);
                int y31 = ro.getPoint31YTile(i);
                long l = ((long)x31 << 31) + (long)y31;
                BinaryRoutePlanner.RouteSegment segment = new BinaryRoutePlanner.RouteSegment(ro, i);
                if (!this.routes.containsKey(l)) {
                    this.routes.put(l, (Object)segment);
                    continue;
                }
                BinaryRoutePlanner.RouteSegment orig = (BinaryRoutePlanner.RouteSegment)this.routes.get(l);
                while (orig.nextLoaded != null) {
                    orig = orig.nextLoaded;
                }
                orig.nextLoaded = segment;
            }
        }

        public void setLoadedNative(NativeLibrary.NativeRouteSearchResult r, RoutingContext ctx) {
            this.isLoaded = Math.abs(this.isLoaded) + 1;
            this.tileStatistics = new TileStatistics();
            if (r.objects != null) {
                this.searchResult = null;
                this.routes = new TLongObjectHashMap();
                for (RouteDataObject ro : r.objects) {
                    if (ro == null || !ctx.config.router.acceptLine(ro)) continue;
                    this.add(ro);
                }
            } else {
                this.searchResult = r;
                this.tileStatistics.size += 100;
            }
        }
    }
}

