/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import net.osmand.binary.BinaryHHRouteReaderAdapter;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.ExcludeTLongObjectMap;
import net.osmand.router.GeneralRouter;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.router.HHRoutingDB;
import net.osmand.router.RouteCalculationProgress;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RouteResultPreparation;
import net.osmand.router.RouteSegmentResult;
import net.osmand.router.RoutingConfiguration;
import net.osmand.router.RoutingContext;
import net.osmand.util.MapUtils;

public class HHRoutePlanner<T extends HHRouteDataStructure.NetworkDBPoint> {
    public static int DEBUG_VERBOSE_LEVEL = 0;
    static int DEBUG_ALT_ROUTE_SELECTION = -1;
    static final double MINIMAL_COST = 0.01;
    private static final int PNT_SHORT_ROUTE_START_END = -1000;
    public static final int MAX_POINTS_CLUSTER_ROUTING = 150000;
    public static final double MAX_INC_COST_CORR = 10.0;
    private static final double EXCLUDE_PRIORITY_CONSTANT = 0.2;
    private static boolean ASSERT_COST_INCREASING = false;
    private static boolean ASSERT_AND_CORRECT_DIST_SMALLER = true;
    private final Class<T> pointClass;
    private final HHRouteDataStructure.HHRouteRegionPointsCtx<T> predefinedRegions;
    private HHRouteDataStructure.HHRoutingContext<T> currentCtx;
    static final int ROUTE_POINTS = 11;

    public static HHRoutePlanner<HHRouteDataStructure.NetworkDBPoint> createDB(RoutingContext ctx, HHRoutingDB networkDB) {
        return new HHRoutePlanner<HHRouteDataStructure.NetworkDBPoint>(ctx, new HHRouteDataStructure.HHRouteRegionPointsCtx(0, networkDB), HHRouteDataStructure.NetworkDBPoint.class);
    }

    public static <Ts extends HHRouteDataStructure.NetworkDBPoint> HHRoutePlanner<Ts> createDB(RoutingContext ctx, HHRoutingDB networkDB, Class<Ts> cl) {
        return new HHRoutePlanner(ctx, new HHRouteDataStructure.HHRouteRegionPointsCtx(0, networkDB), cl);
    }

    public static HHRoutePlanner<HHRouteDataStructure.NetworkDBPoint> create(RoutingContext ctx) {
        return new HHRoutePlanner<HHRouteDataStructure.NetworkDBPoint>(ctx, null, HHRouteDataStructure.NetworkDBPoint.class);
    }

    private HHRoutePlanner(RoutingContext ctx, HHRouteDataStructure.HHRouteRegionPointsCtx<T> src, Class<T> cl) {
        this.pointClass = cl;
        this.predefinedRegions = src;
        this.initNewContext(ctx, src == null ? null : Collections.singletonList(src));
    }

    private HHRouteDataStructure.HHRoutingContext<T> initNewContext(RoutingContext ctx, List<HHRouteDataStructure.HHRouteRegionPointsCtx<T>> regions) {
        this.currentCtx = new HHRouteDataStructure.HHRoutingContext();
        this.currentCtx.rctx = ctx;
        if (regions != null) {
            this.currentCtx.regions.addAll(regions);
        }
        return this.currentCtx;
    }

    public void close() throws SQLException {
        if (this.predefinedRegions != null && this.predefinedRegions.networkDB != null) {
            try {
                this.predefinedRegions.networkDB.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.currentCtx.regions.clear();
    }

    public static double squareRootDist31(int x1, int y1, int x2, int y2) {
        return MapUtils.squareRootDist31(x1, y1, x2, y2);
    }

    public static RoutingContext prepareContext(String routingProfile) {
        RoutePlannerFrontEnd router = new RoutePlannerFrontEnd();
        RoutingConfiguration.Builder builder = RoutingConfiguration.getDefault();
        RoutingConfiguration.RoutingMemoryLimits memoryLimit = new RoutingConfiguration.RoutingMemoryLimits(90, 256);
        TreeMap<String, String> map = new TreeMap<String, String>();
        RoutingConfiguration config = builder.build(routingProfile, memoryLimit, map);
        config.planRoadDirection = 1;
        config.heuristicCoefficient = 0.0f;
        return router.buildRoutingContext(config, null, new BinaryMapIndexReader[0], RoutePlannerFrontEnd.RouteCalculationMode.NORMAL);
    }

    public static HHRouteDataStructure.HHRoutingConfig prepareDefaultRoutingConfig(HHRouteDataStructure.HHRoutingConfig c) {
        if (c == null) {
            c = new HHRouteDataStructure.HHRoutingConfig();
            c = HHRouteDataStructure.HHRoutingConfig.astar(0);
            c.ROUTE_LAST_MILE = true;
            c.calcDetailed(2);
            DEBUG_VERBOSE_LEVEL = 0;
            ++DEBUG_ALT_ROUTE_SELECTION;
        }
        c.applyCalculateMissingMaps(RoutePlannerFrontEnd.CALCULATE_MISSING_MAPS);
        return c;
    }

    public static <T extends HHRouteDataStructure.NetworkDBPoint> HHRouteDataStructure.HHNetworkRouteRes cancelledStatus(HHRouteDataStructure.HHRoutingContext<T> hctx, TLongObjectHashMap<T> stPoints, TLongObjectHashMap<T> endPoints) {
        hctx.clearAll(stPoints, endPoints);
        return new HHRouteDataStructure.HHNetworkRouteRes("Routing was cancelled.");
    }

    public void printf(boolean cond, String format, Object ... args) {
        if (cond) {
            System.out.printf(format, args);
        }
    }

    public HHRouteDataStructure.HHNetworkRouteRes runRouting(LatLon start, LatLon end, HHRouteDataStructure.HHRoutingConfig config) throws SQLException, IOException, InterruptedException {
        long startTime = System.nanoTime();
        int SL = HHRouteDataStructure.HHRoutingConfig.STATS_VERBOSE_LEVEL;
        RouteCalculationProgress progress = this.currentCtx.rctx.calculationProgress;
        if (config.cacheCtx != null && config.cacheCtx.rctx == this.currentCtx.rctx) {
            this.currentCtx = config.cacheCtx;
        }
        config = HHRoutePlanner.prepareDefaultRoutingConfig(config);
        HHRouteDataStructure.HHRoutingContext<T> hctx = this.initHCtx(config, start, end);
        if (config.CACHE_CALCULATION_CONTEXT) {
            if (config.cacheCtx != null && config.cacheCtx != hctx) {
                System.out.printf("Recreate routing cache context %s -> %s \n", "" + config.cacheCtx.hashCode(), hctx == null ? "" : "" + hctx.hashCode());
            }
            config.cacheCtx = hctx;
        }
        if (hctx == null) {
            return new HHRouteDataStructure.HHNetworkRouteRes("Files for hh routing were not initialized. Route couldn't be calculated.");
        }
        this.filterPointsBasedOnConfiguration(hctx);
        TLongObjectHashMap stPoints = new TLongObjectHashMap();
        TLongObjectHashMap endPoints = new TLongObjectHashMap();
        progress.hhIteration(RouteCalculationProgress.HHIteration.START_END_POINT);
        this.findFirstLastSegments(hctx, start, end, stPoints, endPoints, progress);
        RouteResultPreparation rrp = new RouteResultPreparation();
        HHRouteDataStructure.HHNetworkRouteRes route = null;
        boolean recalc = false;
        double firstIterationTime = 0.0;
        int iteration = 0;
        int calcCount = 0;
        while (route == null) {
            progress.hhIteration(RouteCalculationProgress.HHIteration.ROUTING);
            ++iteration;
            if (recalc && firstIterationTime == 0.0) {
                this.printf(DEBUG_VERBOSE_LEVEL == 0 && SL > 0, "  Recalculating route due to route structure changes...", new Object[0]);
                firstIterationTime = hctx.stats.routingTime;
            }
            this.printf((!recalc || DEBUG_VERBOSE_LEVEL > 0) && SL > 0, " Routing...", new Object[0]);
            long time = System.nanoTime();
            T finalPnt = this.runRoutingPointsToPoints(hctx, stPoints, endPoints);
            if (finalPnt == null) {
                this.printf(SL > 0, " finalPnt is null (stop)\n", new Object[0]);
                hctx.clearAll(stPoints, endPoints);
                return new HHRouteDataStructure.HHNetworkRouteRes("No finalPnt found (points might be filtered by params)");
            }
            ++calcCount;
            if (progress.isCancelled) {
                return HHRoutePlanner.cancelledStatus(hctx, stPoints, endPoints);
            }
            route = this.createRouteSegmentFromFinalPoint(hctx, (HHRouteDataStructure.NetworkDBPoint)finalPnt);
            time = System.nanoTime() - time;
            this.printf((!recalc || DEBUG_VERBOSE_LEVEL > 0) && SL > 0, "%d segments, cost %.2f, %.2f ms\n", route.segments.size(), route.getHHRoutingTime(), (double)time / 1000000.0);
            hctx.stats.routingTime += (double)time / 1000000.0;
            progress.hhIteration(RouteCalculationProgress.HHIteration.DETAILED);
            this.printf((!recalc || DEBUG_VERBOSE_LEVEL > 0) && SL > 0, " Parse detailed route segments...", new Object[0]);
            time = System.nanoTime();
            recalc = this.retrieveSegmentsGeometry(hctx, rrp, route, hctx.config.ROUTE_ALL_SEGMENTS, progress);
            if (progress.isCancelled) {
                return HHRoutePlanner.cancelledStatus(hctx, stPoints, endPoints);
            }
            time = System.nanoTime() - time;
            this.printf((firstIterationTime == 0.0 || DEBUG_VERBOSE_LEVEL > 0) && SL > 0, "%.2f ms\n", (double)time / 1000000.0);
            hctx.stats.routingTime += (double)time / 1000000.0;
            if (!recalc) continue;
            if (calcCount > hctx.config.MAX_COUNT_REITERATION) {
                if (SL >= 0) {
                    this.printFinalMessage(" [too many cancelled]", start, end, startTime, hctx);
                }
                hctx.clearAll(stPoints, endPoints);
                return new HHRouteDataStructure.HHNetworkRouteRes("Too many recalculations (outdated maps or unsupported parameters).");
            }
            hctx.clearVisited(stPoints, endPoints);
            route = null;
        }
        if (firstIterationTime > 0.0) {
            this.printf(DEBUG_VERBOSE_LEVEL == 0 && SL > 0, "%d iterations, %.2f ms\n", iteration, hctx.stats.routingTime - firstIterationTime);
        }
        double altRoutes = 0.0;
        if (hctx.config.CALC_ALTERNATIVES) {
            progress.hhIteration(RouteCalculationProgress.HHIteration.ALTERNATIVES);
            this.printf(SL > 0, " Alternative routes...", new Object[0]);
            long time = System.nanoTime();
            this.calcAlternativeRoute(hctx, route, stPoints, endPoints, progress);
            if (progress.isCancelled) {
                return HHRoutePlanner.cancelledStatus(hctx, stPoints, endPoints);
            }
            hctx.stats.altRoutingTime += (double)(System.nanoTime() - time) / 1000000.0;
            hctx.stats.routingTime += hctx.stats.altRoutingTime;
            this.printf(SL > 0, "%d %.2f ms\n", route.altRoutes.size(), hctx.stats.altRoutingTime);
            time = System.nanoTime();
            for (HHRouteDataStructure.HHNetworkRouteRes alt : route.altRoutes) {
                this.retrieveSegmentsGeometry(hctx, rrp, alt, hctx.config.ROUTE_ALL_ALT_SEGMENTS, progress);
                if (!progress.isCancelled) continue;
                return HHRoutePlanner.cancelledStatus(hctx, stPoints, endPoints);
            }
            altRoutes = (double)(System.nanoTime() - time) / 1000000.0;
            this.printf(SL > 0, "%.2f ms\n", altRoutes);
        }
        long time = System.nanoTime();
        this.printf(SL > 0, " Prepare results (turns, alt routes)...", new Object[0]);
        if (hctx.config.USE_GC_MORE_OFTEN) {
            hctx.unloadAllConnections();
            HHRoutePlanner.printGCInformation(true);
        }
        this.prepareRouteResults(hctx, route, start, end, rrp);
        if (DEBUG_VERBOSE_LEVEL >= 1) {
            System.out.println("  Detailed progress: " + String.valueOf(hctx.rctx.calculationProgress.getInfo(null)));
        }
        if (progress.isCancelled) {
            return HHRoutePlanner.cancelledStatus(hctx, stPoints, endPoints);
        }
        if (hctx.config.ROUTE_ALL_SEGMENTS && route.detailed != null) {
            route.detailed = rrp.prepareResult((RoutingContext)hctx.rctx, (List<RouteSegmentResult>)route.detailed).detailed;
        }
        hctx.stats.prepTime += (double)(System.nanoTime() - time) / 1000000.0;
        this.printf(SL > 0, "%.2f ms\n", hctx.stats.prepTime);
        this.printf(SL > 0, "Found final route - cost %.2f (detailed %.2f, %.1f%%), %d depth ( first met %,d, visited %,d (%,d unique) of %,d added vertices )", route.getHHRoutingTime(), route.getHHRoutingDetailed(), 100.0 * (1.0 - route.getHHRoutingDetailed() / (route.getHHRoutingTime() + 0.01)), route.segments.size(), hctx.stats.firstRouteVisitedVertices, hctx.stats.visitedVertices, hctx.stats.uniqueVisitedVertices, hctx.stats.addedVertices);
        hctx.stats.prepTime += altRoutes;
        if (SL > 0) {
            RouteResultPreparation.printResults(hctx.rctx, start, end, route.detailed);
        }
        HHRoutePlanner.printGCInformation(false);
        hctx.clearAll(stPoints, endPoints);
        if (SL >= 0) {
            this.printFinalMessage("", start, end, startTime, hctx);
        }
        return route;
    }

    private void printFinalMessage(String msg, LatLon start, LatLon end, long startTime, HHRouteDataStructure.HHRoutingContext<T> hctx) {
        this.printf(true, "Routing %s, %.1f ms (ctx %s): load/filter points %.1f ms, last mile %.1f ms, routing %.1f ms (queue  - %.1f ms, %.1f ms - %,d edges), prep result %.1f ms - %s (selected %s)\n", msg, (double)(System.nanoTime() - startTime) / 1000000.0, "" + hctx.hashCode(), hctx.stats.loadPointsTime, hctx.stats.searchPointsTime, hctx.stats.routingTime, hctx.stats.addQueueTime + hctx.stats.pollQueueTime, hctx.stats.loadEdgesTime, hctx.stats.loadEdgesCnt, hctx.stats.prepTime, hctx.config.toString(start, end), hctx.getRoutingInfo());
    }

    public static TreeMap<String, String> getFilteredTags(GeneralRouter generalRouter) {
        Map<String, GeneralRouter.RoutingParameter> parameters = generalRouter.getParameters();
        TreeMap<String, String> tm = new TreeMap<String, String>();
        for (Map.Entry<String, String> es : generalRouter.getParameterValues().entrySet()) {
            String paramId = es.getKey();
            if (!parameters.containsKey(paramId) || paramId.equals("short_way") || paramId.equals("height_obstacles") || paramId.startsWith("relief_smoothness_factor")) continue;
            tm.put(paramId, es.getValue());
        }
        return tm;
    }

    private void filterPointsBasedOnConfiguration(HHRouteDataStructure.HHRoutingContext<T> hctx) {
        TreeMap<String, String> tm = HHRoutePlanner.getFilteredTags((GeneralRouter)hctx.rctx.getRouter());
        if (hctx.filterRoutingParameters.equals(tm)) {
            return;
        }
        for (HHRouteDataStructure.NetworkDBPoint pnt : hctx.pointsById.valueCollection()) {
            pnt.rtExclude = false;
        }
        if (tm.isEmpty()) {
            hctx.filterRoutingParameters = tm;
            return;
        }
        this.printf(HHRouteDataStructure.HHRoutingConfig.STATS_VERBOSE_LEVEL > 0, " Filter points based on parameters...", new Object[0]);
        long nt = System.nanoTime();
        BinaryMapRouteReaderAdapter.RouteRegion regR = new BinaryMapRouteReaderAdapter.RouteRegion();
        TIntArrayList tint = new TIntArrayList(50);
        RouteDataObject rdo = new RouteDataObject(regR);
        for (Object pnt : hctx.pointsById.valueCollection()) {
            if (((HHRouteDataStructure.NetworkDBPoint)pnt).tagValues == null) continue;
            for (BinaryMapIndexReader.TagValuePair tp : ((HHRouteDataStructure.NetworkDBPoint)pnt).tagValues) {
                tp.additionalAttribute = -1;
            }
        }
        int filtered = 0;
        for (HHRouteDataStructure.NetworkDBPoint pnt : hctx.pointsById.valueCollection()) {
            if (pnt.tagValues == null) continue;
            tint.reset();
            for (BinaryMapIndexReader.TagValuePair tp : pnt.tagValues) {
                if (tp.additionalAttribute < 0) {
                    tp.additionalAttribute = regR.searchRouteEncodingRule(tp.tag, tp.value);
                }
                if (tp.additionalAttribute < 0) {
                    tp.additionalAttribute = regR.routeEncodingRules.size();
                    regR.initRouteEncodingRule(tp.additionalAttribute, tp.tag, tp.value);
                }
                tint.add(tp.additionalAttribute);
            }
            rdo.types = tint.toArray();
            boolean bl = pnt.rtExclude = !this.currentCtx.rctx.getRouter().acceptLine(rdo);
            if (!pnt.rtExclude) {
                boolean bl2 = pnt.rtExclude = (double)this.currentCtx.rctx.getRouter().defineSpeedPriority(rdo, pnt.end > pnt.start) < 0.2;
            }
            if (!pnt.rtExclude) continue;
            ++filtered;
        }
        hctx.filterRoutingParameters = tm;
        double time = (double)(System.nanoTime() - nt) / 1000000.0;
        this.printf(HHRouteDataStructure.HHRoutingConfig.STATS_VERBOSE_LEVEL > 0, "%d excluded from %d, %.2f ms\n", filtered, hctx.pointsById.size(), time);
        hctx.stats.loadPointsTime += time;
    }

    private void findFirstLastSegments(HHRouteDataStructure.HHRoutingContext<T> hctx, LatLon start, LatLon end, TLongObjectHashMap<T> stPoints, TLongObjectHashMap<T> endPoints, RouteCalculationProgress progress) throws IOException, InterruptedException {
        long time = System.nanoTime();
        this.printf(HHRouteDataStructure.HHRoutingConfig.STATS_VERBOSE_LEVEL > 0, " Finding first / last segments...\n", new Object[0]);
        RoutePlannerFrontEnd planner = new RoutePlannerFrontEnd();
        int startReiterate = -1;
        int endReiterate = -1;
        boolean found = false;
        progress.hhIterationProgress(0.0);
        BinaryRoutePlanner.RouteSegmentPoint startPnt = planner.findRouteSegment(start.getLatitude(), start.getLongitude(), hctx.rctx, null);
        if (startPnt == null) {
            return;
        }
        progress.hhIterationProgress(0.25);
        BinaryRoutePlanner.RouteSegmentPoint endPnt = planner.findRouteSegment(end.getLatitude(), end.getLongitude(), hctx.rctx, null);
        if (endPnt == null) {
            return;
        }
        List<BinaryRoutePlanner.RouteSegmentPoint> stOthers = startPnt.others;
        List<BinaryRoutePlanner.RouteSegmentPoint> endOthers = endPnt.others;
        while (!found && startReiterate + endReiterate < hctx.config.MAX_START_END_REITERATIONS) {
            for (HHRouteDataStructure.NetworkDBPoint p : stPoints.valueCollection()) {
                p.clearRouting();
            }
            stPoints.clear();
            for (HHRouteDataStructure.NetworkDBPoint p : endPoints.valueCollection()) {
                p.clearRouting();
            }
            endPoints.clear();
            BinaryRoutePlanner.RouteSegmentPoint startP = startPnt;
            if (startReiterate >= 0) {
                if (stOthers == null || startReiterate >= stOthers.size()) break;
                startP = stOthers.get(startReiterate);
            }
            BinaryRoutePlanner.RouteSegmentPoint endP = endPnt;
            if (endReiterate >= 0) {
                if (endOthers == null || endReiterate >= endOthers.size()) break;
                endP = endOthers.get(endReiterate);
            }
            Double prev = hctx.rctx.config.initialDirection;
            hctx.rctx.config.initialDirection = hctx.config.INITIAL_DIRECTION;
            hctx.boundaries.put(HHRoutePlanner.calcRPId(endP, endP.getSegmentEnd(), endP.getSegmentStart()), null);
            hctx.boundaries.put(HHRoutePlanner.calcRPId(endP, endP.getSegmentStart(), endP.getSegmentEnd()), null);
            progress.hhIterationProgress(0.5);
            this.initStart(hctx, startP, false, stPoints);
            hctx.rctx.config.initialDirection = prev;
            if (stPoints.isEmpty()) {
                this.printf(HHRouteDataStructure.HHRoutingConfig.STATS_VERBOSE_LEVEL > 0, "   Reiterate with next start point: " + String.valueOf(startP) + "\n", new Object[0]);
                ++startReiterate;
                found = false;
                continue;
            }
            hctx.boundaries.remove(HHRoutePlanner.calcRPId(endP, endP.getSegmentEnd(), endP.getSegmentStart()));
            hctx.boundaries.remove(HHRoutePlanner.calcRPId(endP, endP.getSegmentStart(), endP.getSegmentEnd()));
            if (stPoints.containsKey(-1000L)) {
                endPoints.put(-1000L, (Object)((HHRouteDataStructure.NetworkDBPoint)stPoints.get(-1000L)));
            }
            progress.hhIterationProgress(0.75);
            this.initStart(hctx, endP, true, endPoints);
            if (endPoints.isEmpty()) {
                this.printf(HHRouteDataStructure.HHRoutingConfig.STATS_VERBOSE_LEVEL > 0, "   Reiterate with next end point: " + String.valueOf(endP) + "\n", new Object[0]);
                ++endReiterate;
                found = false;
                continue;
            }
            found = true;
        }
        hctx.stats.searchPointsTime = (double)(System.nanoTime() - time) / 1000000.0;
        this.printf(HHRouteDataStructure.HHRoutingConfig.STATS_VERBOSE_LEVEL > 0, " Finding first / last segments...%.2f ms\n", hctx.stats.searchPointsTime);
    }

    /*
     * Exception decompiling
     */
    private void calcAlternativeRoute(HHRouteDataStructure.HHRoutingContext<T> hctx, HHRouteDataStructure.HHNetworkRouteRes route, TLongObjectHashMap<T> stPoints, TLongObjectHashMap<T> endPoints, RouteCalculationProgress progress) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 10[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected HHRouteDataStructure.HHRoutingContext<T> initHCtx(HHRouteDataStructure.HHRoutingConfig c, LatLon start, LatLon end) throws SQLException, IOException {
        HHRouteDataStructure.HHRoutingContext<T> hctx = this.currentCtx;
        RouteCalculationProgress progress = hctx.rctx.calculationProgress;
        if (this.predefinedRegions == null) {
            progress.hhIteration(RouteCalculationProgress.HHIteration.SELECT_REGIONS);
            hctx = this.selectBestRoutingFiles(start, end, hctx, c.STRICT_BEST_GROUP_MAPS);
        }
        if (hctx == null) {
            System.out.println("No files found for routing");
            return hctx;
        }
        if (HHRouteDataStructure.HHRoutingConfig.STATS_VERBOSE_LEVEL > 0) {
            System.out.println("Selected files: " + (hctx == null ? " NULL " : hctx.getRoutingInfo()));
        }
        hctx.stats = new HHRouteDataStructure.RoutingStats();
        hctx.config = c;
        hctx.setStartEnd(start, end);
        hctx.clearVisited();
        if (hctx.initialized) {
            return hctx;
        }
        long time = System.nanoTime();
        progress.hhIteration(RouteCalculationProgress.HHIteration.LOAD_POINTS);
        this.printf(HHRouteDataStructure.HHRoutingConfig.STATS_VERBOSE_LEVEL > 0, "Loading points... ", new Object[0]);
        hctx.pointsById = hctx.loadNetworkPoints(this.pointClass);
        hctx.boundaries = new TLongObjectHashMap();
        hctx.pointsByGeo = new TLongObjectHashMap();
        if (c.PRELOAD_SEGMENTS) {
            time = System.nanoTime();
            this.printf(HHRouteDataStructure.HHRoutingConfig.STATS_VERBOSE_LEVEL > 0, "Loading segments...", new Object[0]);
            int cntEdges = hctx.loadNetworkSegments(hctx.pointsById.valueCollection());
            hctx.stats.loadEdgesTime = (double)(System.nanoTime() - time) / 1000000.0;
            this.printf(HHRouteDataStructure.HHRoutingConfig.STATS_VERBOSE_LEVEL > 0, " %,d - %.2fms\n", cntEdges, hctx.stats.loadEdgesTime);
            hctx.stats.loadEdgesCnt = cntEdges;
        } else {
            for (HHRouteDataStructure.NetworkDBPoint p : hctx.pointsById.valueCollection()) {
                p.markSegmentsNotLoaded();
            }
        }
        hctx.clusterOutPoints = HHRoutePlanner.groupByClusters(hctx.pointsById, true);
        hctx.clusterInPoints = HHRoutePlanner.groupByClusters(hctx.pointsById, false);
        for (HHRouteDataStructure.NetworkDBPoint pnt : hctx.pointsById.valueCollection()) {
            long pos = HHRoutePlanner.calculateRoutePointInternalId(pnt.roadId, (int)pnt.start, (int)pnt.end);
            LatLon latlon = pnt.getPoint();
            hctx.pointsRect.registerObject(latlon.getLatitude(), latlon.getLongitude(), pnt);
            if (pos != pnt.getGeoPntId()) {
                throw new IllegalStateException(String.valueOf(pnt) + " " + pos + " != " + pnt.getGeoPntId());
            }
            hctx.boundaries.put(pos, null);
            hctx.pointsByGeo.put(pos, (Object)pnt);
            hctx.regions.get((int)pnt.mapId).pntsByFileId.put((long)pnt.fileId, (Object)pnt);
        }
        if (DEBUG_VERBOSE_LEVEL > 0) {
            hctx.pointsRect.printStatsDistribution("  Points distributed");
        }
        hctx.initialized = true;
        hctx.stats.loadPointsTime = (double)(System.nanoTime() - time) / 1000000.0;
        this.printf(HHRouteDataStructure.HHRoutingConfig.STATS_VERBOSE_LEVEL > 0, " %,d - %.2fms\n", hctx.pointsById.size(), hctx.stats.loadPointsTime);
        return hctx;
    }

    private HHRouteDataStructure.HHRoutingContext<T> selectBestRoutingFiles(LatLon start, LatLon end, HHRouteDataStructure.HHRoutingContext<T> hctx, boolean strictBestGroupMaps) throws IOException {
        ArrayList groups = new ArrayList();
        GeneralRouter router = hctx.rctx.config.router;
        String profile = router.getProfile().toString().toLowerCase();
        List<String> ls = router.serializeParameterValues(router.getParameterValues());
        QuadRect qr = new QuadRect(Math.min(start.getLongitude(), end.getLongitude()), Math.max(start.getLatitude(), end.getLatitude()), Math.max(start.getLongitude(), end.getLongitude()), Math.min(start.getLatitude(), end.getLatitude()));
        for (BinaryMapIndexReader binaryMapIndexReader : hctx.rctx.map.keySet()) {
            for (BinaryHHRouteReaderAdapter.HHRouteRegion hHRouteRegion : binaryMapIndexReader.getHHRoutingIndexes()) {
                if (!hHRouteRegion.profile.equals(profile) || !QuadRect.intersects(hHRouteRegion.getLatLonBbox(), qr)) continue;
                double d = QuadRect.intersectionArea(hHRouteRegion.getLatLonBbox(), qr);
                HHRouteRegionsGroup.appendToGroups(hHRouteRegion, binaryMapIndexReader, groups, d);
            }
        }
        for (HHRouteRegionsGroup hHRouteRegionsGroup : groups) {
            String[] params;
            hHRouteRegionsGroup.containsStartEnd = hHRouteRegionsGroup.contains(start) && hHRouteRegionsGroup.contains(end) && hHRouteRegionsGroup.containsStartEndRegion(hctx.rctx.regionsCoveringStartAndTargets);
            for (String p : params = hHRouteRegionsGroup.profileParams.split(",")) {
                if (p.trim().length() == 0) continue;
                if (!ls.contains(p)) {
                    ++hHRouteRegionsGroup.extraParam;
                    continue;
                }
                ++hHRouteRegionsGroup.matchParam;
            }
        }
        Collections.sort(groups, new Comparator<HHRouteRegionsGroup<T>>(){

            @Override
            public int compare(HHRouteRegionsGroup<T> o1, HHRouteRegionsGroup<T> o2) {
                if (o1.containsStartEnd != o2.containsStartEnd) {
                    return o1.containsStartEnd ? -1 : 1;
                }
                if (o1.edition != o2.edition) {
                    return o1.edition > o2.edition ? -1 : 1;
                }
                if (o1.extraParam != o2.extraParam) {
                    return o1.extraParam < o2.extraParam ? -1 : 1;
                }
                if (o1.matchParam != o2.matchParam) {
                    return o1.matchParam > o2.matchParam ? -1 : 1;
                }
                return -Double.compare(o1.sumIntersects, o2.sumIntersects);
            }
        });
        if (groups.size() == 0) {
            return null;
        }
        HHRouteRegionsGroup bestGroup = (HHRouteRegionsGroup)groups.get(0);
        ArrayList<HHRouteDataStructure.HHRouteRegionPointsCtx<T>> arrayList = new ArrayList<HHRouteDataStructure.HHRouteRegionPointsCtx<T>>();
        for (short mapId = 0; mapId < bestGroup.regions.size(); mapId = (short)(mapId + 1)) {
            HHRouteDataStructure.HHRouteRegionPointsCtx hHRouteRegionPointsCtx = new HHRouteDataStructure.HHRouteRegionPointsCtx(mapId, bestGroup.regions.get(mapId), bestGroup.readers.get(mapId), bestGroup.regions.get((int)mapId).profileParams.indexOf(bestGroup.profileParams));
            arrayList.add(hHRouteRegionPointsCtx);
        }
        boolean allMatched = true;
        for (HHRouteDataStructure.HHRouteRegionPointsCtx hHRouteRegionPointsCtx : arrayList) {
            boolean match = false;
            for (HHRouteDataStructure.HHRouteRegionPointsCtx p : this.currentCtx.regions) {
                if (p.file != hHRouteRegionPointsCtx.file || p.fileRegion != hHRouteRegionPointsCtx.fileRegion || p.routingProfile != hHRouteRegionPointsCtx.routingProfile) continue;
                match = true;
                break;
            }
            if (match) continue;
            allMatched = false;
            break;
        }
        if (allMatched) {
            return this.currentCtx;
        }
        if (strictBestGroupMaps && groups.size() > 1) {
            hctx.rctx.mapIndexReaderFilter = new HashSet();
            for (HHRouteDataStructure.HHRouteRegionPointsCtx hHRouteRegionPointsCtx : arrayList) {
                hctx.rctx.mapIndexReaderFilter.add(hHRouteRegionPointsCtx.file);
            }
        }
        return this.initNewContext(hctx.rctx, arrayList);
    }

    public static <T extends HHRouteDataStructure.NetworkDBPoint> TIntObjectHashMap<List<T>> groupByClusters(TLongObjectHashMap<T> pointsById, boolean out) {
        TIntObjectHashMap res = new TIntObjectHashMap();
        for (HHRouteDataStructure.NetworkDBPoint p : pointsById.valueCollection()) {
            int cid;
            int n = cid = out ? p.clusterId : p.dualPoint.clusterId;
            if (!res.containsKey(cid)) {
                res.put(cid, new ArrayList());
            }
            ((List)res.get(cid)).add(p);
        }
        for (List l : res.valueCollection()) {
            l.sort(new Comparator<HHRouteDataStructure.NetworkDBPoint>(){

                @Override
                public int compare(HHRouteDataStructure.NetworkDBPoint o1, HHRouteDataStructure.NetworkDBPoint o2) {
                    return Integer.compare(o1.index, o2.index);
                }
            });
        }
        return res;
    }

    private TLongObjectHashMap<T> initStart(HHRouteDataStructure.HHRoutingContext<T> hctx, BinaryRoutePlanner.RouteSegmentPoint s, boolean reverse, TLongObjectHashMap<T> pnts) throws IOException, InterruptedException {
        if (!hctx.config.ROUTE_LAST_MILE) {
            double startLat = MapUtils.get31LatitudeY(!reverse ? hctx.startY : hctx.endY);
            double startLon = MapUtils.get31LongitudeX(!reverse ? hctx.startX : hctx.endX);
            double rad = 10000.0;
            float spd = hctx.rctx.getRouter().getMinSpeed();
            while (rad < 300000.0 && pnts.isEmpty()) {
                List pntSelect = hctx.pointsRect.getClosestObjects(startLat, startLon, rad *= 2.0);
                int cid = ((HHRouteDataStructure.NetworkDBPoint)pntSelect.get((int)0)).clusterId;
                for (HHRouteDataStructure.NetworkDBPoint pSelect : pntSelect) {
                    if (pSelect.clusterId != cid) continue;
                    HHRouteDataStructure.NetworkDBPoint pnt = reverse ? pSelect.dualPoint : pSelect;
                    double cost = MapUtils.getDistance(pnt.getPoint(), startLat, startLon) / (double)spd;
                    pnt.setCostParentRt(reverse, cost + hctx.distanceToEnd(reverse, pnt), null, cost);
                    pnts.put((long)pnt.index, (Object)pnt);
                }
            }
            return pnts;
        }
        if (s == null) {
            return pnts;
        }
        HHRouteDataStructure.NetworkDBPoint finitePnt = (HHRouteDataStructure.NetworkDBPoint)hctx.pointsByGeo.get(HHRoutePlanner.calcUniDirRoutePointInternalId(s));
        if (finitePnt != null) {
            double plusCost = 0.0;
            double negCost = 0.0;
            if (hctx.rctx.config.initialDirection != null) {
                double diff = s.getRoad().directionRoute(s.getSegmentStart(), s.isPositive()) - hctx.rctx.config.initialDirection;
                if (Math.abs(MapUtils.alignAngleDifference(diff - Math.PI)) <= 1.0471975511965976) {
                    plusCost += hctx.rctx.config.penaltyForReverseDirection;
                }
                if (Math.abs(MapUtils.alignAngleDifference((diff = s.getRoad().directionRoute(s.getSegmentEnd(), !s.isPositive()) - hctx.rctx.config.initialDirection) - Math.PI)) <= 1.0471975511965976) {
                    negCost += hctx.rctx.config.penaltyForReverseDirection;
                }
            }
            finitePnt.setDistanceToEnd(reverse, hctx.distanceToEnd(reverse, finitePnt));
            finitePnt.setCostParentRt(reverse, plusCost, null, plusCost);
            pnts.put((long)finitePnt.index, (Object)finitePnt);
            HHRouteDataStructure.NetworkDBPoint dualPoint = finitePnt.dualPoint;
            dualPoint.setDistanceToEnd(reverse, hctx.distanceToEnd(reverse, dualPoint));
            dualPoint.setCostParentRt(reverse, negCost, null, negCost);
            pnts.put((long)dualPoint.index, (Object)dualPoint);
            return pnts;
        }
        int savedMaxVisited = hctx.rctx.config.MAX_VISITED;
        int savedPlanRoadDirectrion = hctx.rctx.config.planRoadDirection;
        float savedHeuristicCoefficient = hctx.rctx.config.heuristicCoefficient;
        hctx.rctx.config.MAX_VISITED = 150000;
        hctx.rctx.config.planRoadDirection = reverse ? -1 : 1;
        hctx.rctx.config.heuristicCoefficient = 0.0f;
        hctx.rctx.unloadAllData();
        BinaryRoutePlanner planner = new BinaryRoutePlanner();
        BinaryRoutePlanner.MultiFinalRouteSegment frs = (BinaryRoutePlanner.MultiFinalRouteSegment)planner.searchRouteInternal(hctx.rctx, reverse ? null : s, reverse ? s : null, (TLongObjectMap<BinaryRoutePlanner.RouteSegment>)hctx.boundaries);
        hctx.rctx.config.heuristicCoefficient = savedHeuristicCoefficient;
        hctx.rctx.config.planRoadDirection = savedPlanRoadDirectrion;
        hctx.rctx.config.MAX_VISITED = savedMaxVisited;
        if (HHRouteDataStructure.HHRoutingConfig.STATS_VERBOSE_LEVEL > 0) {
            System.out.println("  " + String.valueOf(hctx.rctx.calculationProgress.getInfo(null)));
        }
        if (frs != null) {
            TLongHashSet set = new TLongHashSet();
            for (BinaryRoutePlanner.FinalRouteSegment o : frs.all) {
                short endSegment;
                short startSegment = reverse ? o.getSegmentEnd() : o.getSegmentStart();
                short s2 = endSegment = reverse ? o.getSegmentStart() : o.getSegmentEnd();
                long pntId = HHRoutePlanner.calculateRoutePointInternalId(o.getRoad().getId(), (int)startSegment, (int)endSegment);
                if (!set.add(pntId)) continue;
                HHRouteDataStructure.NetworkDBPoint pnt = (HHRouteDataStructure.NetworkDBPoint)hctx.pointsByGeo.get(pntId);
                if (pnt == null) {
                    if (pnts.contains(-1000L)) continue;
                    try {
                        pnt = (HHRouteDataStructure.NetworkDBPoint)this.pointClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                    pnt.index = -1000;
                    pnt.roadId = o.getRoad().getId();
                    pnt.start = o.getSegmentStart();
                    pnt.end = o.getSegmentEnd();
                    pnt.startX = o.getStartPointX();
                    pnt.endX = o.getEndPointX();
                    pnt.startY = o.getStartPointY();
                    pnt.endY = o.getEndPointY();
                    int preciseY = reverse ? hctx.startY : hctx.endY;
                    int preciseX = reverse ? hctx.startX : hctx.endX;
                    o.distanceFromStart += planner.calculatePreciseStartTime(hctx.rctx, preciseX, preciseY, o);
                } else {
                    float obstacle = hctx.rctx.getRouter().defineRoutingObstacle(o.getRoad(), o.getSegmentStart(), o.getSegmentStart() > o.getSegmentEnd());
                    if (obstacle < 0.0f) continue;
                    o.distanceFromStart += planner.calcRoutingSegmentTimeOnlyDist(hctx.rctx.getRouter(), o) / 2.0f + obstacle;
                }
                if (pnt.rt((boolean)reverse).rtCost != 0.0) {
                    throw new IllegalStateException();
                }
                pnt.setDistanceToEnd(reverse, hctx.distanceToEnd(reverse, pnt));
                pnt.setDetailedParentRt(reverse, o);
                pnts.put((long)pnt.index, (Object)pnt);
            }
        }
        if (hctx.config.USE_GC_MORE_OFTEN) {
            hctx.rctx.unloadAllData();
            HHRoutePlanner.printGCInformation(true);
        }
        return pnts;
    }

    protected T runRoutingPointToPoint(HHRouteDataStructure.HHRoutingContext<T> hctx, T start, T end) throws SQLException, IOException {
        if (start != null) {
            this.addPointToQueue(hctx, hctx.queue(false), false, start, null, 0.0, 0.01);
        }
        if (end != null) {
            this.addPointToQueue(hctx, hctx.queue(true), true, end, null, 0.0, 0.01);
        }
        return this.runRoutingWithInitQueue(hctx);
    }

    protected T runRoutingPointsToPoints(HHRouteDataStructure.HHRoutingContext<T> hctx, TLongObjectHashMap<T> stPoints, TLongObjectHashMap<T> endPoints) throws SQLException, IOException {
        double cost;
        for (HHRouteDataStructure.NetworkDBPoint start : stPoints.valueCollection()) {
            if (start.rtExclude) continue;
            cost = start.rt((boolean)false).rtCost;
            this.addPointToQueue(hctx, hctx.queue(false), false, start, null, start.rt((boolean)false).rtDistanceFromStart, cost <= 0.0 ? 0.01 : cost);
        }
        for (HHRouteDataStructure.NetworkDBPoint end : endPoints.valueCollection()) {
            if (end.rtExclude) continue;
            cost = end.rt((boolean)true).rtCost;
            this.addPointToQueue(hctx, hctx.queue(true), true, end, null, end.rt((boolean)true).rtDistanceFromStart, cost <= 0.0 ? 0.01 : cost);
        }
        T t = this.runRoutingWithInitQueue(hctx);
        return t;
    }

    private T runRoutingWithInitQueue(HHRouteDataStructure.HHRoutingContext<T> hctx) throws SQLException, IOException {
        float DIR_CONFIG = hctx.config.DIJKSTRA_DIRECTION;
        RouteCalculationProgress progress = hctx.rctx == null ? null : hctx.rctx.calculationProgress;
        double straightStartEndCost = HHRoutePlanner.squareRootDist31(hctx.startX, hctx.startY, hctx.endX, hctx.endY) / (double)hctx.rctx.getRouter().getMaxSpeed();
        while (true) {
            Queue<HHRouteDataStructure.NetworkDBPointCost<T>> queue;
            if (HHRouteDataStructure.HHRoutingContext.USE_GLOBAL_QUEUE) {
                queue = hctx.queue(false);
                if (queue.isEmpty()) {
                    break;
                }
            } else {
                Queue<HHRouteDataStructure.NetworkDBPointCost<T>> pos = hctx.queue(false);
                Queue<HHRouteDataStructure.NetworkDBPointCost<T>> rev = hctx.queue(true);
                if (hctx.config.DIJKSTRA_DIRECTION == 0.0f || !rev.isEmpty() && !pos.isEmpty()) {
                    if (rev.isEmpty() || pos.isEmpty()) break;
                    queue = pos.peek().cost < rev.peek().cost ? pos : rev;
                } else {
                    Queue<HHRouteDataStructure.NetworkDBPointCost<T>> queue2 = queue = hctx.config.DIJKSTRA_DIRECTION > 0.0f ? pos : rev;
                    if (queue.isEmpty()) break;
                }
            }
            if (progress != null && progress.isCancelled) {
                return null;
            }
            long tm = System.nanoTime();
            HHRouteDataStructure.NetworkDBPointCost<T> pointCost = queue.poll();
            HHRouteDataStructure.NetworkDBPoint point = (HHRouteDataStructure.NetworkDBPoint)pointCost.point;
            boolean rev = pointCost.rev;
            hctx.stats.pollQueueTime += (double)(System.nanoTime() - tm) / 1000000.0;
            ++hctx.stats.visitedVertices;
            if (point.rt((boolean)(!rev ? true : false)).rtVisited) {
                if (hctx.stats.firstRouteVisitedVertices == 0) {
                    hctx.stats.firstRouteVisitedVertices = hctx.stats.visitedVertices;
                    if (DIR_CONFIG == 0.0f && hctx.config.HEURISTIC_COEFFICIENT != 0.0f) {
                        float f = DIR_CONFIG = rev ? -1.0f : 1.0f;
                    }
                }
                if (hctx.config.HEURISTIC_COEFFICIENT == 0.0f && hctx.config.DIJKSTRA_DIRECTION == 0.0f) {
                    HHRouteDataStructure.NetworkDBPoint finalPoint = point;
                    finalPoint = this.scanFinalPoint(finalPoint, hctx.visited);
                    finalPoint = this.scanFinalPoint(finalPoint, hctx.visitedRev);
                    return (T)finalPoint;
                }
                double rcost = point.rt((boolean)true).rtDistanceFromStart + point.rt((boolean)false).rtDistanceFromStart;
                if (rcost <= pointCost.cost) {
                    return (T)point;
                }
                queue.add(new HHRouteDataStructure.NetworkDBPointCost<HHRouteDataStructure.NetworkDBPoint>(point, rcost, rev));
                point.markVisited(rev);
                continue;
            }
            if (point.rt((boolean)rev).rtVisited) continue;
            ++hctx.stats.uniqueVisitedVertices;
            point.markVisited(rev);
            hctx.visited.add(point);
            (rev ? hctx.visited : hctx.visitedRev).add(point);
            this.printPoint(point, rev);
            if (progress != null && straightStartEndCost > 0.0) {
                double STRAIGHT_TO_ROUTE_COST = 1.25;
                double k = (pointCost.cost - straightStartEndCost) / straightStartEndCost * 1.25;
                progress.hhIterationProgress(k);
            }
            if (hctx.config.MAX_COST > 0.0 && pointCost.cost > hctx.config.MAX_COST || hctx.config.MAX_SETTLE_POINTS > 0 && (rev ? hctx.visitedRev : hctx.visited).size() > hctx.config.MAX_SETTLE_POINTS) break;
            boolean directionAllowed = DIR_CONFIG <= 0.0f && rev || DIR_CONFIG >= 0.0f && !rev;
            if (!directionAllowed) continue;
            this.addConnectedToQueue(hctx, queue, point, rev);
        }
        return null;
    }

    private T scanFinalPoint(T finalPoint, List<T> lt) {
        for (HHRouteDataStructure.NetworkDBPoint p : lt) {
            if (p.rt((boolean)true).rtDistanceFromStart == 0.0 || p.rt((boolean)false).rtDistanceFromStart == 0.0 || !(p.rt((boolean)true).rtDistanceFromStart + p.rt((boolean)false).rtDistanceFromStart < ((HHRouteDataStructure.NetworkDBPoint)finalPoint).rt((boolean)true).rtDistanceFromStart + ((HHRouteDataStructure.NetworkDBPoint)finalPoint).rt((boolean)false).rtDistanceFromStart)) continue;
            finalPoint = p;
        }
        return finalPoint;
    }

    private void addConnectedToQueue(HHRouteDataStructure.HHRoutingContext<T> hctx, Queue<HHRouteDataStructure.NetworkDBPointCost<T>> queue, T point, boolean reverse) throws SQLException, IOException {
        int depth;
        int n = depth = hctx.config.USE_MIDPOINT || hctx.config.MAX_DEPTH > 0 ? ((HHRouteDataStructure.NetworkDBPoint)point).rt(reverse).getDepth(reverse) : 0;
        if (hctx.config.MAX_DEPTH > 0 && depth >= hctx.config.MAX_DEPTH) {
            return;
        }
        long tm = System.nanoTime();
        int cnt = hctx.loadNetworkSegmentPoint(point, reverse);
        hctx.stats.loadEdgesCnt += cnt;
        hctx.stats.loadEdgesTime += (double)(System.nanoTime() - tm) / 1000000.0;
        for (HHRouteDataStructure.NetworkDBSegment connected : ((HHRouteDataStructure.NetworkDBPoint)point).connected(reverse)) {
            HHRouteDataStructure.NetworkDBPoint nextPoint;
            HHRouteDataStructure.NetworkDBPoint networkDBPoint = nextPoint = reverse ? connected.start : connected.end;
            if (!hctx.config.USE_CH && !hctx.config.USE_CH_SHORTCUTS && connected.shortcut || nextPoint.rtExclude || hctx.config.USE_CH && nextPoint.chInd() > 0 && nextPoint.chInd() < ((HHRouteDataStructure.NetworkDBPoint)point).chInd() || hctx.config.USE_MIDPOINT && Math.min(depth, hctx.config.MIDPOINT_MAX_DEPTH) > nextPoint.midPntDepth() + hctx.config.MIDPOINT_ERROR || connected.dist < 0.0) continue;
            if (ASSERT_AND_CORRECT_DIST_SMALLER && hctx.config.HEURISTIC_COEFFICIENT > 0.0f && this.smallestSegmentCost(hctx, point, nextPoint) - connected.dist > 1.0) {
                double smallestSegmentCost = this.smallestSegmentCost(hctx, point, nextPoint);
                System.err.printf("Incorrect distance %s -> %s: db = %.2f > fastest %.2f \n", point, nextPoint, connected.dist, smallestSegmentCost);
                connected.dist = smallestSegmentCost;
            }
            double cost = ((HHRouteDataStructure.NetworkDBPoint)point).rt((boolean)reverse).rtDistanceFromStart + connected.dist + hctx.distanceToEnd(reverse, nextPoint);
            if (ASSERT_COST_INCREASING && ((HHRouteDataStructure.NetworkDBPoint)point).rt((boolean)reverse).rtCost - cost > 1.0) {
                String msg = String.format("%s (cost %.2f) -> %s (cost %.2f) st=%.2f-> + %.2f, toend=%.2f->%.2f: ", point, ((HHRouteDataStructure.NetworkDBPoint)point).rt((boolean)reverse).rtCost, nextPoint, cost, ((HHRouteDataStructure.NetworkDBPoint)point).rt((boolean)reverse).rtDistanceFromStart, connected.dist, ((HHRouteDataStructure.NetworkDBPoint)point).rt((boolean)reverse).rtDistanceToEnd, hctx.distanceToEnd(reverse, nextPoint));
                throw new IllegalStateException(msg);
            }
            double exCost = nextPoint.rt((boolean)reverse).rtCost;
            if ((exCost != 0.0 || nextPoint.rt((boolean)reverse).rtVisited) && !(cost < exCost)) continue;
            this.addPointToQueue(hctx, queue, reverse, nextPoint, point, connected.dist, cost);
        }
    }

    private void addPointToQueue(HHRouteDataStructure.HHRoutingContext<T> hctx, Queue<HHRouteDataStructure.NetworkDBPointCost<T>> queue, boolean reverse, T point, T parent, double segmentDist, double cost) {
        long tm = System.nanoTime();
        if (DEBUG_VERBOSE_LEVEL > 2) {
            System.out.printf("Add  %s to visit - cost %.2f (%.2f prev, %.2f dist) > prev cost %.2f \n", point, cost, parent == null ? 0.0 : ((HHRouteDataStructure.NetworkDBPoint)parent).rt((boolean)reverse).rtDistanceFromStart, segmentDist, ((HHRouteDataStructure.NetworkDBPoint)point).rt((boolean)reverse).rtCost);
        }
        if (((HHRouteDataStructure.NetworkDBPoint)point).rt((boolean)reverse).rtVisited) {
            throw new IllegalStateException(String.format("%s visited - cost %.2f > prev cost %.2f", point, cost, ((HHRouteDataStructure.NetworkDBPoint)point).rt((boolean)reverse).rtCost));
        }
        ((HHRouteDataStructure.NetworkDBPoint)point).setCostParentRt(reverse, cost, (HHRouteDataStructure.NetworkDBPoint)parent, segmentDist);
        hctx.queueAdded.add(point);
        queue.add(new HHRouteDataStructure.NetworkDBPointCost<T>(point, cost, reverse));
        hctx.stats.addQueueTime += (double)(System.nanoTime() - tm) / 1000000.0;
        ++hctx.stats.addedVertices;
    }

    private double smallestSegmentCost(HHRouteDataStructure.HHRoutingContext<T> hctx, T st, T end) {
        double dist = HHRoutePlanner.squareRootDist31(((HHRouteDataStructure.NetworkDBPoint)st).midX(), ((HHRouteDataStructure.NetworkDBPoint)st).midY(), ((HHRouteDataStructure.NetworkDBPoint)end).midX(), ((HHRouteDataStructure.NetworkDBPoint)end).midY());
        return dist / (double)hctx.rctx.getRouter().getMaxSpeed();
    }

    private void printPoint(T p, boolean rev) {
        if (DEBUG_VERBOSE_LEVEL > 1) {
            int pind = 0;
            long pchInd = 0L;
            if (((HHRouteDataStructure.NetworkDBPoint)p).rt((boolean)rev).rtRouteToPoint != null) {
                pind = ((HHRouteDataStructure.NetworkDBPoint)p).rt((boolean)rev).rtRouteToPoint.index;
                pchInd = ((HHRouteDataStructure.NetworkDBPoint)p).rt((boolean)rev).rtRouteToPoint.chInd();
            }
            String symbol = String.format("%s %d [%d] (from %d [%d])", rev ? "<-" : "->", ((HHRouteDataStructure.NetworkDBPoint)p).index, ((HHRouteDataStructure.NetworkDBPoint)p).chInd(), pind, pchInd);
            System.out.printf("Visit Point %s (cost %.1f s) %.5f/%.5f - %d\n", symbol, ((HHRouteDataStructure.NetworkDBPoint)p).rt((boolean)rev).rtCost, MapUtils.get31LatitudeY(((HHRouteDataStructure.NetworkDBPoint)p).startY), MapUtils.get31LongitudeX(((HHRouteDataStructure.NetworkDBPoint)p).startX), ((HHRouteDataStructure.NetworkDBPoint)p).roadId / 64L);
        }
    }

    private BinaryRoutePlanner.FinalRouteSegment runDetailedRouting(HHRouteDataStructure.HHRoutingContext<T> hctx, HHRouteDataStructure.NetworkDBPoint startS, HHRouteDataStructure.NetworkDBPoint endS, boolean useBoundaries) throws InterruptedException, IOException {
        BinaryRoutePlanner.FinalRouteSegment f;
        BinaryRoutePlanner planner = new BinaryRoutePlanner();
        hctx.rctx.config.planRoadDirection = 0;
        hctx.rctx.config.heuristicCoefficient = 1.0f;
        hctx.rctx.unloadAllData();
        BinaryRoutePlanner.RouteSegmentPoint start = HHRoutePlanner.loadPoint(hctx.rctx, startS);
        BinaryRoutePlanner.RouteSegmentPoint end = HHRoutePlanner.loadPoint(hctx.rctx, endS);
        if (start == null) {
            return null;
        }
        if (end == null) {
            System.out.println(String.format("End point is not present in detailed maps: %s", endS));
            return null;
        }
        double oldP = hctx.rctx.config.penaltyForReverseDirection;
        hctx.rctx.config.penaltyForReverseDirection *= 4.0;
        hctx.rctx.config.initialDirection = start.getRoad().directionRoute(start.getSegmentStart(), start.isPositive());
        hctx.rctx.config.targetDirection = end.getRoad().directionRoute(end.getSegmentEnd(), !end.isPositive());
        hctx.rctx.config.MAX_VISITED = useBoundaries ? -1 : 300000;
        ExcludeTLongObjectMap<BinaryRoutePlanner.RouteSegment> bounds = null;
        if (useBoundaries) {
            long ps = HHRoutePlanner.calcRPId(start, start.getSegmentEnd(), start.getSegmentStart());
            long pe = HHRoutePlanner.calcRPId(end, end.getSegmentStart(), end.getSegmentEnd());
            bounds = new ExcludeTLongObjectMap<BinaryRoutePlanner.RouteSegment>((TLongObjectMap<BinaryRoutePlanner.RouteSegment>)hctx.boundaries, ps, pe);
        }
        if ((f = planner.searchRouteInternal(hctx.rctx, start, end, bounds)) == null) {
            System.out.printf("No route found between %s -> %s \n", start, end);
        }
        hctx.rctx.config.MAX_VISITED = -1;
        hctx.rctx.config.initialDirection = null;
        hctx.rctx.config.targetDirection = null;
        hctx.rctx.config.penaltyForReverseDirection = oldP;
        return f;
    }

    private boolean retrieveSegmentsGeometry(HHRouteDataStructure.HHRoutingContext<T> hctx, RouteResultPreparation rrp, HHRouteDataStructure.HHNetworkRouteRes route, boolean routeSegments, RouteCalculationProgress progress) throws SQLException, InterruptedException, IOException {
        for (int i = 0; i < route.segments.size(); ++i) {
            progress.hhIterationProgress((double)i / (double)route.segments.size());
            HHRouteDataStructure.HHNetworkSegmentRes s = route.segments.get(i);
            if (s.segment == null) {
                if (i <= 0 || i >= route.segments.size() - 1) continue;
                throw new IllegalStateException(String.format("Segment ind %d is null.", i));
            }
            if (routeSegments) {
                if (progress.isCancelled) {
                    return false;
                }
                BinaryRoutePlanner.FinalRouteSegment f = this.runDetailedRouting(hctx, s.segment.start, s.segment.end, true);
                if (f == null) {
                    boolean full = hctx.config.FULL_DIJKSTRA_NETWORK_RECALC-- > 0;
                    System.out.printf("Route not found (%srecalc) %s -> %s\n", full ? "dijkstra+" : "", s.segment.start, s.segment.end);
                    if (full) {
                        this.recalculateNetworkCluster(hctx, s.segment.start);
                    }
                    s.segment.dist = -1.0;
                    return true;
                }
                if ((double)f.distanceFromStart + 10.0 > (s.segment.dist + 10.0) * hctx.config.MAX_INC_COST_CF) {
                    if (DEBUG_VERBOSE_LEVEL > 0) {
                        System.out.printf("Route cost increased (%.2f > %.2f) between %s -> %s: recalculate route\n", Float.valueOf(f.distanceFromStart), s.segment.dist, s.segment.start, s.segment.end);
                    }
                    s.segment.dist = f.distanceFromStart;
                    return true;
                }
                s.rtTimeDetailed = f.distanceFromStart;
                s.list = rrp.convertFinalSegmentToResults(hctx.rctx, f);
                continue;
            }
            if (hctx.loadGeometry(s.segment, false)) continue;
            s.segment.getGeometry().clear();
            s.segment.getGeometry().add(s.segment.start.getPoint());
            s.segment.getGeometry().add(s.segment.end.getPoint());
        }
        return false;
    }

    private void recalculateNetworkCluster(HHRouteDataStructure.HHRoutingContext<T> hctx, HHRouteDataStructure.NetworkDBPoint start) throws InterruptedException, IOException {
        BinaryRoutePlanner plan = new BinaryRoutePlanner();
        hctx.rctx.config.planRoadDirection = 1;
        hctx.rctx.config.heuristicCoefficient = 0.0f;
        hctx.rctx.unloadAllData();
        BinaryRoutePlanner.RouteSegmentPoint s = HHRoutePlanner.loadPoint(hctx.rctx, start);
        if (s == null) {
            System.err.printf("HH recalculateNetworkCluster: loadPoint() is NULL for %s\n", start);
            return;
        }
        hctx.rctx.config.MAX_VISITED = 300000;
        long ps = HHRoutePlanner.calcRPId(s, s.getSegmentStart(), s.getSegmentEnd());
        long ps2 = HHRoutePlanner.calcRPId(s, s.getSegmentEnd(), s.getSegmentStart());
        ExcludeTLongObjectMap<BinaryRoutePlanner.RouteSegment> bounds = new ExcludeTLongObjectMap<BinaryRoutePlanner.RouteSegment>((TLongObjectMap<BinaryRoutePlanner.RouteSegment>)hctx.boundaries, ps, ps2);
        BinaryRoutePlanner.MultiFinalRouteSegment frs = (BinaryRoutePlanner.MultiFinalRouteSegment)plan.searchRouteInternal(hctx.rctx, s, null, bounds);
        hctx.rctx.config.MAX_VISITED = -1;
        TLongObjectHashMap resUnique = new TLongObjectHashMap();
        if (frs != null) {
            for (BinaryRoutePlanner.FinalRouteSegment o : frs.all) {
                long pntId = HHRoutePlanner.calculateRoutePointInternalId(o.getRoad().getId(), (int)o.getSegmentStart(), (int)o.getSegmentEnd());
                if (resUnique.containsKey(pntId)) {
                    if (!(((BinaryRoutePlanner.RouteSegment)resUnique.get(pntId)).getDistanceFromStart() > o.getDistanceFromStart())) continue;
                    System.err.println(String.valueOf(resUnique.get(pntId)) + " > " + String.valueOf(o) + " - " + String.valueOf(s));
                    continue;
                }
                resUnique.put(pntId, (Object)o);
                HHRouteDataStructure.NetworkDBPoint p = (HHRouteDataStructure.NetworkDBPoint)hctx.pointsByGeo.get(HHRoutePlanner.calcRPId(o, o.getSegmentStart(), o.getSegmentEnd()));
                if (p == null) {
                    System.err.println("Error calculations new final boundary not found");
                    continue;
                }
                p.startX = o.getStartPointX();
                p.startY = o.getStartPointY();
                p.endX = o.getEndPointX();
                p.endY = o.getEndPointY();
                float routeTime = o.getDistanceFromStart() + plan.calcRoutingSegmentTimeOnlyDist(hctx.rctx.getRouter(), o) / 2.0f + 1.0f;
                HHRouteDataStructure.NetworkDBSegment c = start.getSegment(p, true);
                if (c != null) {
                    c.dist = routeTime;
                } else {
                    start.connected.add(new HHRouteDataStructure.NetworkDBSegment(start, p, routeTime, true, false));
                }
                HHRouteDataStructure.NetworkDBSegment co = p.getSegment(start, false);
                if (co != null) {
                    co.dist = routeTime;
                    continue;
                }
                if (p.connectedReverse == null) continue;
                p.connectedReverse.add(new HHRouteDataStructure.NetworkDBSegment(start, p, routeTime, false, false));
            }
        }
        for (HHRouteDataStructure.NetworkDBSegment c : start.connected) {
            if (resUnique.containsKey(c.end.getGeoPntId())) continue;
            c.dist = -1.0;
            HHRouteDataStructure.NetworkDBSegment co = c.end.getSegment(start, false);
            if (co == null) continue;
            co.dist = -1.0;
        }
    }

    private HHRouteDataStructure.HHNetworkRouteRes prepareRouteResults(HHRouteDataStructure.HHRoutingContext<T> hctx, HHRouteDataStructure.HHNetworkRouteRes route, LatLon start, LatLon end, RouteResultPreparation rrp) throws SQLException, InterruptedException, IOException {
        hctx.rctx.routingTime = 0.0f;
        route.stats = hctx.stats;
        RouteSegmentResult straightLine = null;
        for (int routeSegmentInd = 0; routeSegmentInd < route.segments.size(); ++routeSegmentInd) {
            int segments;
            HHRouteDataStructure.HHNetworkSegmentRes routeSegment = route.segments.get(routeSegmentInd);
            HHRouteDataStructure.NetworkDBSegment s = routeSegment.segment;
            if (routeSegment.list != null && routeSegment.list.size() > 0) {
                if (straightLine != null) {
                    route.detailed.add(straightLine);
                    straightLine = null;
                }
                if (routeSegmentInd > 0) {
                    RouteSegmentResult p = routeSegment.list.get(0);
                    if (Math.abs(p.getStartPointIndex() - p.getEndPointIndex()) <= 1) {
                        routeSegment.list.remove(0);
                    } else {
                        p.setStartPointIndex(p.getStartPointIndex() + (p.isForwardDirection() ? 1 : -1));
                    }
                }
                route.detailed.addAll(routeSegment.list);
            } else {
                BinaryMapRouteReaderAdapter.RouteRegion reg = new BinaryMapRouteReaderAdapter.RouteRegion();
                reg.initRouteEncodingRule(0, "highway", "unmatched");
                RouteDataObject rdo = new RouteDataObject(reg);
                rdo.types = new int[]{0};
                rdo.pointsX = new int[]{s.start.startX, s.end.startX};
                rdo.pointsY = new int[]{s.start.startY, s.end.startY};
                RouteDataObject sh = new RouteDataObject(reg);
                sh.types = new int[]{0};
                sh.pointsX = new int[]{s.end.startX, s.end.endX};
                sh.pointsY = new int[]{s.end.startY, s.end.endY};
                straightLine = new RouteSegmentResult(sh, 0, 1);
                route.detailed.add(new RouteSegmentResult(rdo, 0, 1));
            }
            hctx.rctx.routingTime = (float)((double)hctx.rctx.routingTime + routeSegment.rtTimeDetailed);
            if (DEBUG_VERBOSE_LEVEL < 1) continue;
            int n = segments = routeSegment.list == null ? 0 : routeSegment.list.size();
            if (s == null) {
                this.printf(HHRouteDataStructure.HHRoutingConfig.STATS_VERBOSE_LEVEL > 0, "First / last segment - %d segments, %.2fs \n", segments, routeSegment.rtTimeDetailed);
                continue;
            }
            this.printf(HHRouteDataStructure.HHRoutingConfig.STATS_VERBOSE_LEVEL > 0, "\nRoute %d [%d] -> %d [%d] %s - hh dist %.2f s, detail %.2f s (%.1f%%) segments %d ( end %.5f/%.5f - %d ) ", s.start.index, s.start.chInd(), s.end.index, s.end.chInd(), s.shortcut ? "sh" : "bs", s.dist, routeSegment.rtTimeDetailed, 100.0 * (1.0 - routeSegment.rtTimeDetailed / s.dist), segments, MapUtils.get31LatitudeY(s.end.startY), MapUtils.get31LongitudeX(s.end.startX), s.end.roadId / 64L);
        }
        return route;
    }

    private HHRouteDataStructure.HHNetworkRouteRes createRouteSegmentFromFinalPoint(HHRouteDataStructure.HHRoutingContext<T> hctx, HHRouteDataStructure.NetworkDBPoint pnt) {
        HHRouteDataStructure.HHNetworkRouteRes route = new HHRouteDataStructure.HHNetworkRouteRes();
        if (pnt != null) {
            HHRouteDataStructure.HHNetworkSegmentRes res;
            HHRouteDataStructure.HHNetworkSegmentRes res2;
            HHRouteDataStructure.NetworkDBSegment segment;
            HHRouteDataStructure.NetworkDBPoint nextPnt;
            HHRouteDataStructure.NetworkDBPoint itPnt = pnt;
            route.uniquePoints.add((long)itPnt.index);
            while (itPnt.rt((boolean)true).rtRouteToPoint != null) {
                nextPnt = itPnt.rt((boolean)true).rtRouteToPoint;
                segment = nextPnt.getSegment(itPnt, false);
                res2 = new HHRouteDataStructure.HHNetworkSegmentRes(segment);
                route.segments.add(res2);
                res2.rtTimeDetailed = res2.rtTimeHHSegments = segment.dist;
                itPnt = nextPnt;
                route.uniquePoints.add((long)itPnt.index);
            }
            if (itPnt.rt((boolean)true).rtDetailedRoute != null) {
                res = new HHRouteDataStructure.HHNetworkSegmentRes(null);
                res.list = new RouteResultPreparation().convertFinalSegmentToResults(hctx.rctx, itPnt.rt((boolean)true).rtDetailedRoute);
                res.rtTimeDetailed = res.rtTimeHHSegments = (double)itPnt.rt((boolean)true).rtDetailedRoute.distanceFromStart;
                route.segments.add(res);
            }
            Collections.reverse(route.segments);
            itPnt = pnt;
            while (itPnt.rt((boolean)false).rtRouteToPoint != null) {
                nextPnt = itPnt.rt((boolean)false).rtRouteToPoint;
                segment = nextPnt.getSegment(itPnt, true);
                res2 = new HHRouteDataStructure.HHNetworkSegmentRes(segment);
                route.segments.add(res2);
                res2.rtTimeDetailed = res2.rtTimeHHSegments = segment.dist;
                itPnt = nextPnt;
                route.uniquePoints.add((long)itPnt.index);
            }
            if (itPnt.rt((boolean)false).rtDetailedRoute != null) {
                res = new HHRouteDataStructure.HHNetworkSegmentRes(null);
                res.list = new RouteResultPreparation().convertFinalSegmentToResults(hctx.rctx, itPnt.rt((boolean)false).rtDetailedRoute);
                res.rtTimeDetailed = res.rtTimeHHSegments = (double)itPnt.rt((boolean)false).rtDetailedRoute.distanceFromStart;
                route.segments.add(res);
            }
            Collections.reverse(route.segments);
        }
        return route;
    }

    public static BinaryRoutePlanner.RouteSegmentPoint loadPoint(RoutingContext ctx, HHRouteDataStructure.NetworkDBPoint pnt) {
        BinaryRoutePlanner.RouteSegment s;
        for (s = ctx.loadRouteSegment(pnt.startX, pnt.startY, ctx.config.memoryLimitation); s != null; s = s.getNext()) {
            if (s.getRoad().getId() != pnt.roadId || s.getSegmentStart() != pnt.start) continue;
            if (s.getSegmentEnd() == pnt.end) break;
            s = s.initRouteSegment(!s.isPositive());
            break;
        }
        if (s == null || s.getSegmentStart() != pnt.start || s.getSegmentEnd() != pnt.end || s.getRoad().getId() != pnt.roadId) {
            return null;
        }
        return new BinaryRoutePlanner.RouteSegmentPoint(s.getRoad(), s.getSegmentStart(), s.getSegmentEnd(), 0.0);
    }

    static long calculateRoutePointInternalId(RouteDataObject road, int pntId, int nextPntId) {
        int positive = nextPntId - pntId;
        int pntLen = road.getPointsLength();
        if (positive < 0) {
            throw new IllegalStateException("Check only positive segments are in calculation");
        }
        if (pntId < 0 || nextPntId < 0 || pntId >= pntLen || nextPntId >= pntLen || positive != -1 && positive != 1 || pntLen > 2048) {
            throw new IllegalStateException("Assert failed");
        }
        return (road.getId() << 11) + (long)(pntId << 1) + (long)(positive > 0 ? 1 : 0);
    }

    static long calculateRoutePointInternalId(long id, int pntId, int nextPntId) {
        int positive = nextPntId - pntId;
        return (id << 11) + (long)(pntId << 1) + (long)(positive > 0 ? 1 : 0);
    }

    static long calcRPId(BinaryRoutePlanner.RouteSegment p, int pntId, int nextPntId) {
        return HHRoutePlanner.calculateRoutePointInternalId(p.getRoad().getId(), pntId, nextPntId);
    }

    static long calcUniDirRoutePointInternalId(BinaryRoutePlanner.RouteSegment segm) {
        if (segm.getSegmentStart() < segm.getSegmentEnd()) {
            return HHRoutePlanner.calculateRoutePointInternalId(segm.getRoad(), (int)segm.getSegmentStart(), (int)segm.getSegmentEnd());
        }
        return HHRoutePlanner.calculateRoutePointInternalId(segm.getRoad(), (int)segm.getSegmentEnd(), (int)segm.getSegmentStart());
    }

    public static void printGCInformation(boolean gc) {
        if (gc) {
            System.gc();
        }
        long MEMORY_LAST_USED_MB = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() >> 20;
        System.out.printf("***** Memory used %d MB *****\n", MEMORY_LAST_USED_MB);
    }

    private static class HHRouteRegionsGroup<T extends HHRouteDataStructure.NetworkDBPoint> {
        List<BinaryHHRouteReaderAdapter.HHRouteRegion> regions = new ArrayList<BinaryHHRouteReaderAdapter.HHRouteRegion>();
        List<BinaryMapIndexReader> readers = new ArrayList<BinaryMapIndexReader>();
        final long edition;
        final String profileParams;
        public int extraParam = 0;
        public int matchParam = 0;
        public boolean containsStartEnd;
        public double sumIntersects;

        public HHRouteRegionsGroup(long edition, String params) {
            this.profileParams = params;
            this.edition = edition;
        }

        public static <T extends HHRouteDataStructure.NetworkDBPoint> void appendToGroups(BinaryHHRouteReaderAdapter.HHRouteRegion r, BinaryMapIndexReader rdr, List<HHRouteRegionsGroup<T>> groups, double iou) {
            for (String params : r.profileParams) {
                HHRouteRegionsGroup<T> matchGroup = null;
                for (HHRouteRegionsGroup<T> g : groups) {
                    if (g.edition != r.edition || !params.equals(g.profileParams)) continue;
                    matchGroup = g;
                    break;
                }
                if (matchGroup == null) {
                    matchGroup = new HHRouteRegionsGroup<T>(r.edition, params);
                    groups.add(matchGroup);
                }
                matchGroup.regions.add(r);
                matchGroup.readers.add(rdr);
                matchGroup.sumIntersects += iou;
            }
        }

        public boolean contains(LatLon p) throws IOException {
            int x31 = MapUtils.get31TileNumberX(p.getLongitude());
            int y31 = MapUtils.get31TileNumberY(p.getLatitude());
            HashSet<String> checked = new HashSet<String>();
            for (int i = 0; i < this.regions.size(); ++i) {
                BinaryMapIndexReader rd = this.readers.get(i);
                if (rd.containsRouteData()) {
                    if (!rd.containsActualRouteData(x31, y31, checked)) continue;
                    return true;
                }
                BinaryHHRouteReaderAdapter.HHRouteRegion reg = this.regions.get(i);
                if (!reg.top.contains(x31, y31)) continue;
                return true;
            }
            return false;
        }

        public boolean containsStartEndRegion(String[] regionsCoveringStartAndTargets) {
            if (regionsCoveringStartAndTargets.length == 0) {
                return true;
            }
            for (BinaryMapIndexReader reader : this.readers) {
                for (BinaryMapRouteReaderAdapter.RouteRegion index : reader.getRoutingIndexes()) {
                    for (String region : regionsCoveringStartAndTargets) {
                        if (!region.equalsIgnoreCase(index.getName())) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

