/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.list.array.TIntArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.osmand.NativeLibrary;
import net.osmand.PlatformUtil;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.QuadRect;
import net.osmand.data.QuadTree;
import net.osmand.osm.edit.Node;
import net.osmand.router.GeneralRouter;
import net.osmand.router.VehicleRouter;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RoutingConfiguration {
    public static final int DEFAULT_MEMORY_LIMIT = 30;
    public static final int DEFAULT_NATIVE_MEMORY_LIMIT = 256;
    public static final float DEVIATION_RADIUS = 3000.0f;
    public static final double DEFAULT_PENALTY_FOR_REVERSE_DIRECTION = 60.0;
    public Map<String, String> attributes = new LinkedHashMap<String, String>();
    public float heuristicCoefficient = 1.0f;
    public int ZOOM_TO_LOAD_TILES = 16;
    public long memoryLimitation;
    public long nativeMemoryLimitation;
    public int planRoadDirection = 0;
    public GeneralRouter router = new GeneralRouter(GeneralRouter.GeneralRouterProfile.CAR, new LinkedHashMap<String, String>());
    public String routerName = "";
    public Double initialDirection;
    public Double targetDirection;
    public double penaltyForReverseDirection = 60.0;
    public float recalculateDistance = 20000.0f;
    public long routeCalculationTime = 0L;
    public Map<String, String> ambiguousConditionalTags;
    public int MAX_VISITED = -1;
    private QuadTree<DirectionPoint> directionPoints;
    public int directionPointsRadius = 30;
    public float minPointApproximation = 50.0f;
    public float minStepApproximation = 100.0f;
    public float maxStepApproximation = 3000.0f;
    public float smoothenPointsNoRoute = 5.0f;
    public boolean showMinorTurns = false;
    private static Builder DEFAULT;

    public QuadTree<DirectionPoint> getDirectionPoints() {
        return this.directionPoints;
    }

    public NativeLibrary.NativeDirectionPoint[] getNativeDirectionPoints() {
        if (this.directionPoints == null) {
            return new NativeLibrary.NativeDirectionPoint[0];
        }
        QuadRect rect = new QuadRect(0.0, 0.0, 2.147483647E9, 2.147483647E9);
        List<DirectionPoint> points = this.directionPoints.queryInBox(rect, new ArrayList());
        NativeLibrary.NativeDirectionPoint[] result = new NativeLibrary.NativeDirectionPoint[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            DirectionPoint point = points.get(i);
            result[i] = new NativeLibrary.NativeDirectionPoint(point.getLatitude(), point.getLongitude(), point.getTags());
        }
        return result;
    }

    public static int parseSilentInt(String t, int v) {
        if (t == null || t.length() == 0) {
            return v;
        }
        return Integer.parseInt(t);
    }

    public static float parseSilentFloat(String t, float v) {
        if (t == null || t.length() == 0) {
            return v;
        }
        return Float.parseFloat(t);
    }

    public static Builder getDefault() {
        if (DEFAULT == null) {
            DEFAULT = RoutingConfiguration.parseDefault();
        }
        return DEFAULT;
    }

    public static Builder parseDefault() {
        try {
            return RoutingConfiguration.parseFromInputStream(RoutingConfiguration.class.getResourceAsStream("routing.xml"));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static Builder parseFromInputStream(InputStream is) throws IOException, XmlPullParserException {
        return RoutingConfiguration.parseFromInputStream(is, null, new Builder());
    }

    public static Builder parseFromInputStream(InputStream is, String filename, Builder config) throws IOException, XmlPullParserException {
        int tok;
        XmlPullParser parser = PlatformUtil.newXMLPullParser();
        GeneralRouter currentRouter = null;
        GeneralRouter.RouteDataObjectAttribute currentAttribute = null;
        String preType = null;
        Stack<RoutingRule> rulesStck = new Stack<RoutingRule>();
        parser.setInput(is, "UTF-8");
        while ((tok = parser.next()) != 1) {
            String pname;
            if (tok == 2) {
                String name = parser.getName();
                if ("osmand_routing_config".equals(name)) {
                    config.defaultRouter = parser.getAttributeValue("", "defaultProfile");
                    continue;
                }
                if ("routingProfile".equals(name)) {
                    currentRouter = RoutingConfiguration.parseRoutingProfile(parser, config, filename);
                    continue;
                }
                if ("attribute".equals(name)) {
                    RoutingConfiguration.parseAttribute(parser, config, currentRouter);
                    continue;
                }
                if ("parameter".equals(name)) {
                    RoutingConfiguration.parseRoutingParameter(parser, currentRouter);
                    continue;
                }
                if ("point".equals(name) || "way".equals(name)) {
                    String attribute = parser.getAttributeValue("", "attribute");
                    currentAttribute = GeneralRouter.RouteDataObjectAttribute.getValueOf(attribute);
                    preType = parser.getAttributeValue("", "type");
                    continue;
                }
                RoutingConfiguration.parseRoutingRule(parser, currentRouter, currentAttribute, preType, rulesStck);
                continue;
            }
            if (tok != 3 || !RoutingConfiguration.checkTag(pname = parser.getName())) continue;
            rulesStck.pop();
        }
        is.close();
        return config;
    }

    private static void parseRoutingParameter(XmlPullParser parser, GeneralRouter currentRouter) {
        String description = parser.getAttributeValue("", "description");
        String group = parser.getAttributeValue("", "group");
        String name = parser.getAttributeValue("", "name");
        String id = parser.getAttributeValue("", "id");
        String type = parser.getAttributeValue("", "type");
        String profilesList = parser.getAttributeValue("", "profiles");
        String[] profiles = Algorithms.isEmpty(profilesList) ? null : profilesList.split(",");
        boolean defaultValue = Boolean.parseBoolean(parser.getAttributeValue("", "default"));
        if ("boolean".equalsIgnoreCase(type)) {
            currentRouter.registerBooleanParameter(id, Algorithms.isEmpty(group) ? null : group, name, description, profiles, defaultValue);
        } else if ("numeric".equalsIgnoreCase(type)) {
            String values = parser.getAttributeValue("", "values");
            String valueDescriptions = parser.getAttributeValue("", "valueDescriptions");
            String[] vlsDesc = valueDescriptions.split(",");
            String[] strValues = values.split(",");
            Double[] vls = new Double[strValues.length];
            for (int i = 0; i < vls.length; ++i) {
                vls[i] = Double.parseDouble(strValues[i].trim());
            }
            currentRouter.registerNumericParameter(id, name, description, profiles, vls, vlsDesc);
        } else {
            throw new UnsupportedOperationException("Unsupported routing parameter type - " + type);
        }
    }

    private static void parseRoutingRule(XmlPullParser parser, GeneralRouter currentRouter, GeneralRouter.RouteDataObjectAttribute attr, String parentType, Stack<RoutingRule> stack) {
        String pname = parser.getName();
        if (RoutingConfiguration.checkTag(pname)) {
            if (attr == null) {
                throw new NullPointerException("Select tag filter outside road attribute < " + pname + " > : " + parser.getLineNumber());
            }
            RoutingRule rr = new RoutingRule();
            rr.tagName = pname;
            rr.t = parser.getAttributeValue("", "t");
            rr.v = parser.getAttributeValue("", "v");
            rr.param = parser.getAttributeValue("", "param");
            rr.value1 = parser.getAttributeValue("", "value1");
            rr.value2 = parser.getAttributeValue("", "value2");
            rr.type = parser.getAttributeValue("", "type");
            if ((rr.type == null || rr.type.length() == 0) && parentType != null && parentType.length() > 0) {
                rr.type = parentType;
            }
            GeneralRouter.RouteAttributeContext ctx = currentRouter.getObjContext(attr);
            if ("select".equals(rr.tagName)) {
                String val = parser.getAttributeValue("", "value");
                String type = rr.type;
                ctx.registerNewRule(val, type);
                RoutingConfiguration.addSubclause(rr, ctx);
                for (int i = 0; i < stack.size(); ++i) {
                    RoutingConfiguration.addSubclause((RoutingRule)stack.get(i), ctx);
                }
            } else if ("min".equals(rr.tagName) || "max".equals(rr.tagName)) {
                String initVal = parser.getAttributeValue("", "value1");
                String type = rr.type;
                ctx.registerNewRule(initVal, type);
                RoutingConfiguration.addSubclause(rr, ctx);
            } else if (stack.size() > 0 && "select".equals(stack.peek().tagName)) {
                RoutingConfiguration.addSubclause(rr, ctx);
            }
            stack.push(rr);
        }
    }

    private static boolean checkTag(String pname) {
        return "select".equals(pname) || "if".equals(pname) || "ifnot".equals(pname) || "gt".equals(pname) || "le".equals(pname) || "eq".equals(pname) || "min".equals(pname) || "max".equals(pname);
    }

    private static void addSubclause(RoutingRule rr, GeneralRouter.RouteAttributeContext ctx) {
        boolean not = "ifnot".equals(rr.tagName);
        if (!Algorithms.isEmpty(rr.param)) {
            if (rr.param.contains(",")) {
                String[] params;
                for (String p : params = rr.param.split(",")) {
                    if (Algorithms.isEmpty(p = p.trim())) continue;
                    ctx.getLastRule().registerAndParamCondition(p, not);
                }
            } else {
                ctx.getLastRule().registerAndParamCondition(rr.param, not);
            }
        }
        if (!Algorithms.isEmpty(rr.t)) {
            ctx.getLastRule().registerAndTagValueCondition(rr.t, Algorithms.isEmpty(rr.v) ? null : rr.v, not);
        }
        switch (rr.tagName) {
            case "gt": {
                ctx.getLastRule().registerGreatCondition(rr.value1, rr.value2, rr.type);
                break;
            }
            case "le": {
                ctx.getLastRule().registerLessCondition(rr.value1, rr.value2, rr.type);
                break;
            }
            case "eq": {
                ctx.getLastRule().registerEqualCondition(rr.value1, rr.value2, rr.type);
                break;
            }
            case "min": {
                ctx.getLastRule().registerMinExpression(rr.value1, rr.value2, rr.type);
                break;
            }
            case "max": {
                ctx.getLastRule().registerMaxExpression(rr.value1, rr.value2, rr.type);
            }
        }
    }

    private static GeneralRouter parseRoutingProfile(XmlPullParser parser, Builder config, String filename) {
        Object currentSelectedRouterName = parser.getAttributeValue("", "name");
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            attrs.put(parser.getAttributeName(i), parser.getAttributeValue(i));
        }
        GeneralRouter.GeneralRouterProfile c = (GeneralRouter.GeneralRouterProfile)Algorithms.parseEnumValue((Enum[])GeneralRouter.GeneralRouterProfile.values(), (String)parser.getAttributeValue("", "baseProfile"), (Enum)GeneralRouter.GeneralRouterProfile.CAR);
        GeneralRouter currentRouter = new GeneralRouter(c, attrs);
        currentRouter.setProfileName((String)currentSelectedRouterName);
        if (filename != null) {
            currentRouter.setFilename(filename);
            currentSelectedRouterName = filename + "/" + (String)currentSelectedRouterName;
        }
        config.routers.put((String)currentSelectedRouterName, currentRouter);
        return currentRouter;
    }

    private static void parseAttribute(XmlPullParser parser, Builder config, GeneralRouter currentRouter) {
        if (currentRouter != null) {
            currentRouter.addAttribute(parser.getAttributeValue("", "name"), parser.getAttributeValue("", "value"));
        } else {
            config.attributes.put(parser.getAttributeValue("", "name"), parser.getAttributeValue("", "value"));
        }
    }

    public static class DirectionPoint
    extends Node {
        private static final long serialVersionUID = -7496599771204656505L;
        public double distance = Double.MAX_VALUE;
        public RouteDataObject connected;
        public TIntArrayList types = new TIntArrayList();
        public int connectedx;
        public int connectedy;
        public static final String TAG = "osmand_dp";
        public static final String DELETE_TYPE = "osmand_delete_point";
        public static final String CREATE_TYPE = "osmand_add_point";
        public static final String ANGLE_TAG = "apply_direction_angle";
        public static final double MAX_ANGLE_DIFF = 45.0;

        public DirectionPoint(Node n) {
            super(n, n.getId());
        }

        public double getAngle() {
            String angle = this.getTag(ANGLE_TAG);
            if (angle != null) {
                try {
                    return Double.parseDouble(angle);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException(e);
                }
            }
            return Double.NaN;
        }
    }

    public static class Builder {
        private String defaultRouter = "";
        private Map<String, GeneralRouter> routers = new LinkedHashMap<String, GeneralRouter>();
        private Map<String, String> attributes = new LinkedHashMap<String, String>();
        private Set<Long> impassableRoadLocations = new HashSet<Long>();
        private QuadTree<Node> directionPointsBuilder;

        public Builder() {
        }

        public Builder(Map<String, String> defaultAttributes) {
            this.attributes.putAll(defaultAttributes);
        }

        public RoutingConfiguration build(String router, RoutingMemoryLimits memoryLimits) {
            return this.build(router, null, memoryLimits, new LinkedHashMap<String, String>());
        }

        public RoutingConfiguration build(String router, RoutingMemoryLimits memoryLimits, Map<String, String> params) {
            return this.build(router, null, memoryLimits, params);
        }

        public RoutingConfiguration build(String router, Double direction, RoutingMemoryLimits memoryLimits, Map<String, String> params) {
            String derivedProfile = null;
            if (!this.routers.containsKey(router)) {
                for (Map.Entry<String, GeneralRouter> r : this.routers.entrySet()) {
                    String derivedProfiles = r.getValue().getAttribute("derivedProfiles");
                    if (derivedProfiles == null || !derivedProfiles.contains(router)) continue;
                    derivedProfile = router;
                    router = r.getKey();
                    break;
                }
                if (derivedProfile == null) {
                    router = this.defaultRouter;
                }
            }
            if (derivedProfile != null) {
                params.put("profile_" + derivedProfile, String.valueOf(true));
            }
            RoutingConfiguration i = new RoutingConfiguration();
            if (this.routers.containsKey(router)) {
                i.router = this.routers.get(router);
                if (params != null) {
                    i.router = i.router.build((Map)params);
                }
                i.routerName = router;
            }
            this.attributes.put("routerName", router);
            i.attributes.putAll(this.attributes);
            i.initialDirection = direction;
            i.recalculateDistance = RoutingConfiguration.parseSilentFloat(this.getAttribute(i.router, "recalculateDistanceHelp"), i.recalculateDistance);
            i.heuristicCoefficient = RoutingConfiguration.parseSilentFloat(this.getAttribute(i.router, "heuristicCoefficient"), i.heuristicCoefficient);
            i.minPointApproximation = RoutingConfiguration.parseSilentFloat(this.getAttribute(i.router, "minPointApproximation"), i.minPointApproximation);
            i.minStepApproximation = RoutingConfiguration.parseSilentFloat(this.getAttribute(i.router, "minStepApproximation"), i.minStepApproximation);
            i.maxStepApproximation = RoutingConfiguration.parseSilentFloat(this.getAttribute(i.router, "maxStepApproximation"), i.maxStepApproximation);
            i.smoothenPointsNoRoute = RoutingConfiguration.parseSilentFloat(this.getAttribute(i.router, "smoothenPointsNoRoute"), i.smoothenPointsNoRoute);
            i.penaltyForReverseDirection = RoutingConfiguration.parseSilentFloat(this.getAttribute(i.router, "penaltyForReverseDirection"), (float)i.penaltyForReverseDirection);
            i.router.setImpassableRoads(new HashSet<Long>(this.impassableRoadLocations));
            i.ZOOM_TO_LOAD_TILES = RoutingConfiguration.parseSilentInt(this.getAttribute(i.router, "zoomToLoadTiles"), i.ZOOM_TO_LOAD_TILES);
            int memoryLimitMB = memoryLimits.memoryLimitMb;
            int desirable = RoutingConfiguration.parseSilentInt(this.getAttribute(i.router, "memoryLimitInMB"), 0);
            if (desirable != 0) {
                i.memoryLimitation = (long)desirable * 0x100000L;
            } else {
                if (memoryLimitMB == 0) {
                    memoryLimitMB = 30;
                }
                i.memoryLimitation = (long)memoryLimitMB * 0x100000L;
            }
            int desirableNativeLimit = RoutingConfiguration.parseSilentInt(this.getAttribute(i.router, "nativeMemoryLimitInMB"), 0);
            i.nativeMemoryLimitation = desirableNativeLimit != 0 ? (long)desirableNativeLimit * 0x100000L : (long)memoryLimits.nativeMemoryLimitMb * 0x100000L;
            i.planRoadDirection = RoutingConfiguration.parseSilentInt(this.getAttribute(i.router, "planRoadDirection"), i.planRoadDirection);
            if (this.directionPointsBuilder != null) {
                QuadRect rect = new QuadRect(0.0, 0.0, 2.147483647E9, 2.147483647E9);
                List<Node> lst = this.directionPointsBuilder.queryInBox(rect, new ArrayList());
                i.directionPoints = new QuadTree(rect, 14, 0.5f);
                for (Node n : lst) {
                    DirectionPoint dp = new DirectionPoint(n);
                    int x = MapUtils.get31TileNumberX(dp.getLongitude());
                    int y = MapUtils.get31TileNumberY(dp.getLatitude());
                    i.directionPoints.insert(dp, new QuadRect(x, y, x, y));
                }
            }
            return i;
        }

        public Builder setDirectionPoints(QuadTree<Node> directionPoints) {
            this.directionPointsBuilder = directionPoints;
            return this;
        }

        public void clearImpassableRoadLocations() {
            this.impassableRoadLocations.clear();
        }

        public Set<Long> getImpassableRoadLocations() {
            return this.impassableRoadLocations;
        }

        public Builder addImpassableRoad(long routeId) {
            this.impassableRoadLocations.add(routeId);
            return this;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        private String getAttribute(VehicleRouter router, String propertyName) {
            if (router.containsAttribute(propertyName)) {
                return router.getAttribute(propertyName);
            }
            return this.attributes.get(propertyName);
        }

        public String getDefaultRouter() {
            return this.defaultRouter;
        }

        public GeneralRouter getRouter(String routingProfileName) {
            return this.routers.get(routingProfileName);
        }

        public String getRoutingProfileKeyByFileName(String fileName) {
            if (fileName != null && this.routers != null) {
                for (Map.Entry<String, GeneralRouter> router : this.routers.entrySet()) {
                    if (!fileName.equals(router.getValue().getFilename())) continue;
                    return router.getKey();
                }
            }
            return null;
        }

        public Map<String, GeneralRouter> getAllRouters() {
            return this.routers;
        }

        public void removeImpassableRoad(long routeId) {
            this.impassableRoadLocations.remove(routeId);
        }
    }

    private static class RoutingRule {
        String tagName;
        String t;
        String v;
        String param;
        String value1;
        String value2;
        String type;

        private RoutingRule() {
        }
    }

    public static class RoutingMemoryLimits {
        public int memoryLimitMb;
        public int nativeMemoryLimitMb;

        public RoutingMemoryLimits(int memoryLimitMb, int nativeMemoryLimitMb) {
            this.memoryLimitMb = memoryLimitMb;
            this.nativeMemoryLimitMb = nativeMemoryLimitMb;
        }
    }
}

