/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import com.google.protobuf.WireFormat;
import gnu.trove.TLongCollection;
import gnu.trove.list.TLongList;
import gnu.trove.list.array.TByteArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.TIntObjectMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.zip.GZIPOutputStream;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.OsmandOdb;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.Street;
import net.osmand.data.TransportRoute;
import net.osmand.data.TransportSchedule;
import net.osmand.data.TransportStop;
import net.osmand.data.TransportStopExit;
import net.osmand.obf.preparation.BinaryFileReference;
import net.osmand.obf.preparation.IndexPoiCreator;
import net.osmand.obf.preparation.TransportTags;
import net.osmand.osm.MapRenderingTypes;
import net.osmand.osm.MapRoutingTypes;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.router.HHRoutingOBFWriter;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import net.sf.junidecode.Junidecode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BinaryMapIndexWriter {
    private RandomAccessFile raf;
    private CodedOutputStream codedOutStream;
    protected static final int SHIFT_COORDINATES = 5;
    public int MASK_TO_READ = -32;
    private static final int ROUTE_SHIFT_COORDINATES = 4;
    private static final int LABEL_THRESHOLD = 1024;
    private static final int LABEL_ZOOM_ENCODE = 26;
    private static Log log = LogFactory.getLog(BinaryMapIndexWriter.class);
    private Stack<Bounds> stackBounds = new Stack();
    private Stack<Long> stackBaseIds = new Stack();
    private Stack<Integer> state = new Stack();
    private Stack<BinaryFileReference> stackSizes = new Stack();
    private static final int OSMAND_STRUCTURE_INIT = 1;
    private static final int MAP_INDEX_INIT = 2;
    private static final int MAP_ROOT_LEVEL_INIT = 3;
    private static final int MAP_TREE = 4;
    private static final int ADDRESS_INDEX_INIT = 5;
    private static final int CITY_INDEX_INIT = 6;
    private static final int TRANSPORT_INDEX_INIT = 9;
    private static final int TRANSPORT_STOPS_TREE = 10;
    private static final int TRANSPORT_ROUTES = 11;
    private static final int POI_INDEX_INIT = 12;
    private static final int POI_BOX = 13;
    private static final int POI_DATA = 14;
    private static final int ROUTE_INDEX_INIT = 15;
    private static final int ROUTE_TREE = 16;
    private static final int HH_INDEX_INIT = 17;
    private static final int HH_BLOCK_SEGMENTS = 18;
    public static int COORDINATES_SIZE = 0;
    public static int COORDINATES_COUNT = 0;
    public static int ID_SIZE = 0;
    public static int TYPES_SIZE = 0;
    public static int MAP_DATA_SIZE = 0;
    public static int STRING_TABLE_SIZE = 0;
    public static int LABEL_COORDINATES_SIZE = 0;
    public static int ROUTE_ID_SIZE = 0;
    public static int ROUTE_TYPES_SIZE = 0;
    public static int ROUTE_COORDINATES_SIZE = 0;
    public static int ROUTE_COORDINATES_COUNT = 0;
    public static int ROUTE_POINTS_SIZE = 0;
    public static int ROUTE_DATA_SIZE = 0;
    public static int ROUTE_STRING_DATA_SIZE = 0;
    private TByteArrayList mapDataBuf = new TByteArrayList();
    private TByteArrayList typesDataBuf = new TByteArrayList();
    private TByteArrayList typesAddDataBuf = new TByteArrayList();

    public BinaryMapIndexWriter(final RandomAccessFile raf, long timestamp) throws IOException {
        this.raf = raf;
        this.codedOutStream = CodedOutputStream.newInstance((OutputStream)new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                raf.write(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                raf.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                raf.write(b, off, len);
            }
        });
        this.codedOutStream.writeUInt32(1, 2);
        this.codedOutStream.writeInt64(18, timestamp);
        this.state.push(1);
    }

    public BinaryMapIndexWriter(RandomAccessFile raf, CodedOutputStream cos) throws IOException {
        this.raf = raf;
        this.codedOutStream = cos;
        this.state.push(1);
    }

    private BinaryFileReference preserveInt32Size() throws IOException {
        long filePointer = this.getFilePointer();
        BinaryFileReference ref = BinaryFileReference.createSizeReference(filePointer);
        this.stackSizes.push(ref);
        this.codedOutStream.writeFixed32NoTag(0);
        return ref;
    }

    private BinaryFileReference preserveInt64Size() throws IOException {
        long filePointer = this.getFilePointer();
        BinaryFileReference ref = BinaryFileReference.createLongSizeReference(filePointer);
        this.stackSizes.push(ref);
        this.codedOutStream.writeFixed32NoTag(0);
        this.codedOutStream.writeFixed32NoTag(0);
        return ref;
    }

    public long getFilePointer() throws IOException {
        this.codedOutStream.flush();
        return this.raf.getFilePointer();
    }

    public CodedOutputStream getCodedOutStream() {
        return this.codedOutStream;
    }

    private long writeInt32Size() throws IOException {
        long filePointer = this.getFilePointer();
        BinaryFileReference ref = this.stackSizes.pop();
        this.codedOutStream.flush();
        long length = ref.writeReference(this.raf, filePointer);
        return length;
    }

    private long prewriteInt32Size() throws IOException {
        long filePointer = this.getFilePointer();
        BinaryFileReference ref = this.stackSizes.peek();
        this.codedOutStream.flush();
        long length = ref.writeReference(this.raf, filePointer);
        return length;
    }

    public void startWriteMapIndex(String name) throws IOException {
        this.pushState(2, 1);
        this.codedOutStream.writeTag(6, 6);
        this.preserveInt32Size();
        if (name != null) {
            this.codedOutStream.writeString(2, name);
        }
    }

    public void endWriteMapIndex() throws IOException {
        this.popState(2);
        long len = this.writeInt32Size();
        log.info((Object)("MAP INDEX SIZE : " + len));
    }

    public void startHHRoutingIndex(long edition, String profile, List<String> stringTable, boolean longIndex, String ... params) throws IOException {
        this.pushState(17, 1);
        this.codedOutStream.writeTag(10, 6);
        if (longIndex) {
            this.preserveInt64Size();
        } else {
            this.preserveInt32Size();
        }
        this.codedOutStream.writeInt64(1, edition);
        this.codedOutStream.writeString(2, profile);
        for (String s : params) {
            this.codedOutStream.writeString(3, s);
        }
        if (stringTable != null && stringTable.size() > 0) {
            OsmandOdb.StringTable.Builder st = OsmandOdb.StringTable.newBuilder();
            for (String s : stringTable) {
                st.addS(s);
            }
            this.codedOutStream.writeMessage(4, (MessageLite)st.build());
        }
    }

    public void endHHRoutingIndex() throws IOException {
        this.popState(17);
        long len = this.writeInt32Size();
        log.info((Object)("HHROUTING INDEX SIZE : " + len));
    }

    public void startWriteRouteIndex(String name) throws IOException {
        this.pushState(15, 1);
        this.codedOutStream.writeTag(9, 6);
        this.preserveInt32Size();
        if (name != null) {
            this.codedOutStream.writeString(1, name);
        }
    }

    public void endWriteRouteIndex() throws IOException {
        this.popState(15);
        long len = this.writeInt32Size();
        log.info((Object)("- ROUTE TYPE SIZE SIZE " + ROUTE_TYPES_SIZE));
        log.info((Object)("- ROUTE COORDINATES SIZE " + ROUTE_COORDINATES_SIZE + " COUNT " + ROUTE_COORDINATES_COUNT));
        log.info((Object)("- ROUTE POINTS SIZE " + ROUTE_POINTS_SIZE));
        log.info((Object)("- ROUTE STRING SIZE " + ROUTE_STRING_DATA_SIZE));
        log.info((Object)("- ROUTE ID SIZE " + ROUTE_ID_SIZE));
        log.info((Object)("-- ROUTE_DATA " + ROUTE_DATA_SIZE));
        ROUTE_COORDINATES_SIZE = 0;
        ROUTE_COORDINATES_COUNT = 0;
        ROUTE_ID_SIZE = 0;
        ROUTE_POINTS_SIZE = 0;
        ROUTE_DATA_SIZE = 0;
        ROUTE_TYPES_SIZE = 0;
        log.info((Object)("ROUTE INDEX SIZE : " + len));
    }

    public void simulateWriteEndRouteIndex() throws IOException {
        this.checkPeekState(15);
        long len = this.prewriteInt32Size();
        log.info((Object)("PREROUTE INDEX SIZE : " + len));
    }

    public RandomAccessFile getRaf() {
        return this.raf;
    }

    public void startWriteMapLevelIndex(int minZoom, int maxZoom, int leftX, int rightX, int topY, int bottomY) throws IOException {
        this.pushState(3, 2);
        this.codedOutStream.writeTag(5, 6);
        this.preserveInt32Size();
        this.codedOutStream.writeInt32(1, maxZoom);
        this.codedOutStream.writeInt32(2, minZoom);
        this.codedOutStream.writeInt32(3, leftX);
        this.codedOutStream.writeInt32(4, rightX);
        this.codedOutStream.writeInt32(5, topY);
        this.codedOutStream.writeInt32(6, bottomY);
        this.stackBounds.push(new Bounds(leftX, rightX, topY, bottomY));
    }

    public void endWriteMapLevelIndex() throws IOException {
        this.popState(3);
        this.stackBounds.pop();
        long len = this.writeInt32Size();
        log.info((Object)("MAP level SIZE : " + len));
    }

    public void writeMapEncodingRules(TIntObjectMap<BinaryMapIndexReader.TagValuePair> decodingRules) throws IOException {
        for (int i = 1; i <= decodingRules.size(); ++i) {
            BinaryMapIndexReader.TagValuePair value = (BinaryMapIndexReader.TagValuePair)decodingRules.get(i);
            OsmandOdb.OsmAndMapIndex.MapEncodingRule.Builder builder = OsmandOdb.OsmAndMapIndex.MapEncodingRule.newBuilder();
            if (value == null) break;
            builder.setTag(value.tag);
            if (value.value != null) {
                builder.setValue(value.value);
            }
            builder.setType(value.additionalAttribute);
            OsmandOdb.OsmAndMapIndex.MapEncodingRule rulet = builder.build();
            this.codedOutStream.writeMessage(4, (MessageLite)rulet);
        }
    }

    public void writeMapEncodingRules(Map<String, MapRenderingTypes.MapRulType> types) throws IOException {
        this.checkPeekState(2);
        ArrayList<MapRenderingTypes.MapRulType> out = new ArrayList<MapRenderingTypes.MapRulType>();
        int highestTargetId = types.size();
        for (MapRenderingTypes.MapRulType t : types.values()) {
            if (t.getFreq() == 0 || !t.isMap()) {
                t.setTargetId(highestTargetId++);
                continue;
            }
            out.add(t);
        }
        Collections.sort(out, new Comparator<MapRenderingTypes.MapRulType>(){

            @Override
            public int compare(MapRenderingTypes.MapRulType o1, MapRenderingTypes.MapRulType o2) {
                return o2.getFreq() - o1.getFreq();
            }
        });
        for (int i = 0; i < out.size(); ++i) {
            OsmandOdb.OsmAndMapIndex.MapEncodingRule.Builder builder = OsmandOdb.OsmAndMapIndex.MapEncodingRule.newBuilder();
            MapRenderingTypes.MapRulType rule = (MapRenderingTypes.MapRulType)out.get(i);
            rule.setTargetId(i + 1);
            builder.setTag(rule.getTag());
            if (rule.getValue() != null) {
                builder.setValue(rule.getValue());
            }
            builder.setMinZoom(rule.getMinzoom());
            if (rule.isAdditional()) {
                builder.setType(1);
            } else if (rule.isText()) {
                builder.setType(2);
            }
            OsmandOdb.OsmAndMapIndex.MapEncodingRule rulet = builder.build();
            this.codedOutStream.writeMessage(4, (MessageLite)rulet);
        }
    }

    public void writeRouteEncodingRules(List<MapRoutingTypes.MapRouteType> types) throws IOException {
        this.checkPeekState(15);
        ArrayList<MapRoutingTypes.MapRouteType> out = new ArrayList<MapRoutingTypes.MapRouteType>(types);
        Collections.sort(out, new Comparator<MapRoutingTypes.MapRouteType>(){

            @Override
            public int compare(MapRoutingTypes.MapRouteType o1, MapRoutingTypes.MapRouteType o2) {
                return o2.getFreq() - o1.getFreq();
            }
        });
        for (int i = 0; i < out.size(); ++i) {
            OsmandOdb.OsmAndRoutingIndex.RouteEncodingRule.Builder builder = OsmandOdb.OsmAndRoutingIndex.RouteEncodingRule.newBuilder();
            MapRoutingTypes.MapRouteType rule = out.get(i);
            rule.setTargetId(i + 1);
            builder.setTag(rule.getTag());
            if (rule.getValue() != null) {
                builder.setValue(rule.getValue());
            } else {
                builder.setValue("");
            }
            OsmandOdb.OsmAndRoutingIndex.RouteEncodingRule rulet = builder.build();
            this.codedOutStream.writeMessage(2, (MessageLite)rulet);
        }
    }

    public void writeRouteRawEncodingRules(List<BinaryMapRouteReaderAdapter.RouteTypeRule> types) throws IOException {
        this.checkPeekState(15);
        for (int i = 1; i < types.size(); ++i) {
            OsmandOdb.OsmAndRoutingIndex.RouteEncodingRule.Builder builder = OsmandOdb.OsmAndRoutingIndex.RouteEncodingRule.newBuilder();
            BinaryMapRouteReaderAdapter.RouteTypeRule rule = types.get(i);
            builder.setTag(rule.getTag());
            if (rule.getValue() != null) {
                builder.setValue(rule.getValue());
            } else {
                builder.setValue("");
            }
            OsmandOdb.OsmAndRoutingIndex.RouteEncodingRule rulet = builder.build();
            this.codedOutStream.writeMessage(2, (MessageLite)rulet);
        }
    }

    public BinaryFileReference startRouteTreeElement(int leftX, int rightX, int topY, int bottomY, boolean containsObjects, boolean basemap) throws IOException {
        this.checkPeekState(16, 15);
        if (this.state.peek() == 15) {
            if (basemap) {
                this.codedOutStream.writeTag(4, 6);
            } else {
                this.codedOutStream.writeTag(3, 6);
            }
        } else {
            this.codedOutStream.writeTag(7, 6);
        }
        this.state.push(16);
        this.preserveInt32Size();
        long fp = this.getFilePointer();
        Bounds bounds = this.stackBounds.isEmpty() ? new Bounds(0, 0, 0, 0) : this.stackBounds.peek();
        this.codedOutStream.writeSInt32(1, leftX - bounds.leftX);
        this.codedOutStream.writeSInt32(2, rightX - bounds.rightX);
        this.codedOutStream.writeSInt32(3, topY - bounds.topY);
        this.codedOutStream.writeSInt32(4, bottomY - bounds.bottomY);
        this.stackBounds.push(new Bounds(leftX, rightX, topY, bottomY));
        BinaryFileReference ref = null;
        if (containsObjects) {
            this.codedOutStream.writeTag(5, 6);
            ref = BinaryFileReference.createShiftReference(this.getFilePointer(), fp);
            this.codedOutStream.writeFixed32NoTag(0);
        }
        return ref;
    }

    public void endRouteTreeElement() throws IOException {
        this.popState(16);
        this.stackBounds.pop();
        this.writeInt32Size();
    }

    public BinaryFileReference startMapTreeElement(int leftX, int rightX, int topY, int bottomY, boolean containsLeaf) throws IOException {
        return this.startMapTreeElement(leftX, rightX, topY, bottomY, containsLeaf, 0);
    }

    public BinaryFileReference startMapTreeElement(int leftX, int rightX, int topY, int bottomY, boolean containsObjects, int landCharacteristic) throws IOException {
        this.checkPeekState(3, 4);
        if (this.state.peek() == 3) {
            this.codedOutStream.writeTag(7, 6);
        } else {
            this.codedOutStream.writeTag(7, 6);
        }
        this.state.push(4);
        this.preserveInt32Size();
        long fp = this.getFilePointer();
        Bounds bounds = this.stackBounds.peek();
        this.codedOutStream.writeSInt32(1, (leftX &= this.MASK_TO_READ) - bounds.leftX);
        this.codedOutStream.writeSInt32(2, rightX - bounds.rightX);
        this.codedOutStream.writeSInt32(3, (topY &= this.MASK_TO_READ) - bounds.topY);
        this.codedOutStream.writeSInt32(4, bottomY - bounds.bottomY);
        if (landCharacteristic != 0) {
            this.codedOutStream.writeBool(6, landCharacteristic < 0);
        }
        this.stackBounds.push(new Bounds(leftX, rightX, topY, bottomY));
        BinaryFileReference ref = null;
        if (containsObjects) {
            this.codedOutStream.writeTag(5, 6);
            ref = BinaryFileReference.createShiftReference(this.getFilePointer(), fp);
            this.codedOutStream.writeFixed32NoTag(0);
        }
        return ref;
    }

    public void endWriteMapTreeElement() throws IOException {
        this.popState(4);
        this.stackBounds.pop();
        this.writeInt32Size();
    }

    public void startHHRouteTreeElement(int leftX, int rightX, int topY, int bottomY) throws IOException {
        this.checkPeekState(16, 17);
        if (this.state.peek() == 17) {
            this.codedOutStream.writeTag(5, 6);
        } else {
            this.codedOutStream.writeTag(6, 6);
        }
        this.state.push(16);
        this.preserveInt32Size();
        Bounds bounds = this.stackBounds.isEmpty() ? new Bounds(0, 0, 0, 0) : this.stackBounds.peek();
        this.codedOutStream.writeSInt32(2, leftX - bounds.leftX);
        this.codedOutStream.writeSInt32(3, rightX - bounds.rightX);
        this.codedOutStream.writeSInt32(4, topY - bounds.topY);
        this.codedOutStream.writeSInt32(5, bottomY - bounds.bottomY);
        this.stackBounds.push(new Bounds(leftX, rightX, topY, bottomY));
    }

    public void writeHHRoutePoints(List<HHRoutingOBFWriter.NetworkDBPointWrite> l) throws IOException {
        this.checkPeekState(16);
        Bounds bounds = this.stackBounds.peek();
        for (HHRoutingOBFWriter.NetworkDBPointWrite p : l) {
            OsmandOdb.OsmAndHHRoutingIndex.HHRouteNetworkPoint.Builder builder = OsmandOdb.OsmAndHHRoutingIndex.HHRouteNetworkPoint.newBuilder();
            HHRouteDataStructure.NetworkDBPoint pnt = p.pnt;
            builder.setClusterId(pnt.clusterId);
            builder.setGlobalId(pnt.index);
            builder.setId(p.localId);
            builder.setRoadId(pnt.roadId);
            builder.setRoadStartEndIndex((pnt.start << 1) + (pnt.end > pnt.start ? 1 : 0));
            builder.setDx(pnt.startX - bounds.leftX);
            builder.setDy(pnt.startY - bounds.topY);
            if (p.includeFlag > 1) {
                builder.setPartialInd(p.includeFlag - 1);
            } else if (p.includeFlag == 0) {
                throw new IllegalStateException();
            }
            if (pnt.dualPoint != null) {
                builder.setDualClusterId(pnt.dualPoint.clusterId);
                builder.setDualPointId(pnt.dualPoint.index);
            }
            if (p.tagValuesInts != null) {
                for (int tgv : p.tagValuesInts) {
                    builder.addTagValueIds(tgv);
                }
            }
            this.codedOutStream.writeMessage(7, (MessageLite)builder.build());
        }
    }

    public void endHHRouteTreeElement() throws IOException {
        this.popState(16);
        this.stackBounds.pop();
        this.writeInt32Size();
    }

    public void startHHRouteBlockSegments(int idRangeStart, int idRangeLength, int profileId) throws IOException {
        this.checkPeekState(18, 17);
        if (this.state.peek() == 17) {
            this.codedOutStream.writeTag(6, 6);
        } else {
            this.codedOutStream.writeTag(6, 6);
        }
        this.state.push(18);
        this.preserveInt32Size();
        this.codedOutStream.writeInt32(1, idRangeStart);
        this.codedOutStream.writeInt32(2, idRangeLength);
        this.codedOutStream.writeInt32(3, profileId);
    }

    public void writePointSegments(byte[] segmentsIn, byte[] segmentsOut) throws IOException {
        this.checkPeekState(18);
        OsmandOdb.OsmAndHHRoutingIndex.HHRoutePointSegments.Builder bld = OsmandOdb.OsmAndHHRoutingIndex.HHRoutePointSegments.newBuilder();
        bld.setSegmentsIn(ByteString.copyFrom((byte[])segmentsIn));
        bld.setSegmentsOut(ByteString.copyFrom((byte[])segmentsOut));
        this.codedOutStream.writeMessage(4, (MessageLite)bld.build());
    }

    public void endHHRouteBlockSegments() throws IOException {
        this.popState(18);
        this.writeInt32Size();
    }

    public OsmandOdb.MapDataBlock.Builder createWriteMapDataBlock(long baseid) throws IOException {
        OsmandOdb.MapDataBlock.Builder builder = OsmandOdb.MapDataBlock.newBuilder();
        builder.setBaseId(baseid);
        return builder;
    }

    public void writeRouteDataBlock(OsmandOdb.OsmAndRoutingIndex.RouteDataBlock.Builder builder, Map<String, Integer> stringTable, BinaryFileReference ref) throws IOException {
        this.checkPeekState(15);
        if (stringTable != null && stringTable.size() > 0) {
            OsmandOdb.StringTable.Builder bs = OsmandOdb.StringTable.newBuilder();
            for (String s : stringTable.keySet()) {
                bs.addS(s);
            }
            OsmandOdb.StringTable st = bs.build();
            builder.setStringTable(st);
            int size = st.getSerializedSize();
            ROUTE_STRING_DATA_SIZE += CodedOutputStream.computeTagSize((int)15) + CodedOutputStream.computeRawVarint32Size((int)size) + size;
        }
        this.codedOutStream.writeTag(15, WireFormat.FieldType.MESSAGE.getWireType());
        this.codedOutStream.flush();
        ref.writeReference(this.raf, this.getFilePointer());
        OsmandOdb.OsmAndRoutingIndex.RouteDataBlock block = builder.build();
        ROUTE_DATA_SIZE += block.getSerializedSize();
        this.codedOutStream.writeMessageNoTag((MessageLite)block);
    }

    public void writeRawVarint32(TByteArrayList bf, int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.writeRawByte(bf, value);
                return;
            }
            this.writeRawByte(bf, value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public void writeRawByte(TByteArrayList bf, int value) throws IOException {
        bf.add((byte)value);
    }

    public OsmandOdb.RouteData writeRouteData(int diffId, int pleft, int ptop, int[] types, RoutePointToWrite[] points, Map<MapRoutingTypes.MapRouteType, String> names, Map<String, Integer> stringTable, List<MapRoutingTypes.MapPointName> pointNames, OsmandOdb.OsmAndRoutingIndex.RouteDataBlock.Builder dataBlock, boolean allowCoordinateSimplification, boolean writePointId) throws IOException {
        OsmandOdb.RouteData.Builder builder = OsmandOdb.RouteData.newBuilder();
        builder.setRouteId(diffId);
        ROUTE_ID_SIZE += CodedOutputStream.computeInt64Size((int)12, (long)diffId);
        this.mapDataBuf.clear();
        for (int i = 0; i < types.length; ++i) {
            this.writeRawVarint32(this.mapDataBuf, types[i]);
        }
        builder.setTypes(ByteString.copyFrom((byte[])this.mapDataBuf.toArray()));
        ROUTE_TYPES_SIZE += CodedOutputStream.computeTagSize((int)7) + CodedOutputStream.computeRawVarint32Size((int)this.mapDataBuf.size()) + this.mapDataBuf.size();
        int pcalcx = pleft >> 4;
        int pcalcy = ptop >> 4;
        this.mapDataBuf.clear();
        this.typesDataBuf.clear();
        for (int k = 0; k < points.length; ++k) {
            ++ROUTE_COORDINATES_COUNT;
            int tx = (points[k].x >> 4) - pcalcx;
            int ty = (points[k].y >> 4) - pcalcy;
            this.writeRawVarint32(this.mapDataBuf, CodedOutputStream.encodeZigZag32((int)tx));
            this.writeRawVarint32(this.mapDataBuf, CodedOutputStream.encodeZigZag32((int)ty));
            pcalcx += tx;
            pcalcy += ty;
            if (points[k].types.size() <= 0) continue;
            this.typesAddDataBuf.clear();
            for (int ij = 0; ij < points[k].types.size(); ++ij) {
                this.writeRawVarint32(this.typesAddDataBuf, points[k].types.get(ij));
            }
            this.writeRawVarint32(this.typesDataBuf, k);
            this.writeRawVarint32(this.typesDataBuf, this.typesAddDataBuf.size());
            this.typesDataBuf.add(this.typesAddDataBuf.toArray());
        }
        builder.setPoints(ByteString.copyFrom((byte[])this.mapDataBuf.toArray()));
        ROUTE_COORDINATES_SIZE += CodedOutputStream.computeTagSize((int)1) + CodedOutputStream.computeRawVarint32Size((int)this.mapDataBuf.size()) + this.mapDataBuf.size();
        builder.setPointTypes(ByteString.copyFrom((byte[])this.typesDataBuf.toArray()));
        ROUTE_TYPES_SIZE += CodedOutputStream.computeTagSize((int)4) + CodedOutputStream.computeRawVarint32Size((int)this.typesDataBuf.size()) + this.typesDataBuf.size();
        if (pointNames.size() > 0) {
            this.mapDataBuf.clear();
            for (MapRoutingTypes.MapPointName p : pointNames) {
                this.writeRawVarint32(this.mapDataBuf, p.pointIndex);
                this.writeRawVarint32(this.mapDataBuf, p.nameTypeTargetId);
                Integer ls = stringTable.get(p.name);
                if (ls == null) {
                    ls = stringTable.size();
                    stringTable.put(p.name, ls);
                }
                this.writeRawVarint32(this.mapDataBuf, ls);
            }
            ROUTE_STRING_DATA_SIZE += this.mapDataBuf.size();
            builder.setPointNames(ByteString.copyFrom((byte[])this.mapDataBuf.toArray()));
        }
        if (names.size() > 0) {
            this.mapDataBuf.clear();
            for (Map.Entry<MapRoutingTypes.MapRouteType, String> s : names.entrySet()) {
                this.writeRawVarint32(this.mapDataBuf, s.getKey().getTargetId());
                Integer ls = stringTable.get(s.getValue());
                if (ls == null) {
                    ls = stringTable.size();
                    stringTable.put(s.getValue(), ls);
                }
                this.writeRawVarint32(this.mapDataBuf, ls);
            }
            ROUTE_STRING_DATA_SIZE += this.mapDataBuf.size();
            builder.setStringNames(ByteString.copyFrom((byte[])this.mapDataBuf.toArray()));
        }
        return builder.build();
    }

    public void writeMapDataBlock(OsmandOdb.MapDataBlock.Builder builder, Map<String, Integer> stringTable, BinaryFileReference ref) throws IOException {
        this.checkPeekState(3);
        OsmandOdb.StringTable.Builder bs = OsmandOdb.StringTable.newBuilder();
        if (stringTable != null) {
            for (String s : stringTable.keySet()) {
                bs.addS(s);
            }
        }
        OsmandOdb.StringTable st = bs.build();
        builder.setStringTable(st);
        int size = st.getSerializedSize();
        STRING_TABLE_SIZE += CodedOutputStream.computeTagSize((int)15) + CodedOutputStream.computeRawVarint32Size((int)size) + size;
        this.codedOutStream.writeTag(15, WireFormat.FieldType.MESSAGE.getWireType());
        this.codedOutStream.flush();
        ref.writeReference(this.raf, this.getFilePointer());
        OsmandOdb.MapDataBlock block = builder.build();
        MAP_DATA_SIZE += block.getSerializedSize();
        this.codedOutStream.writeMessageNoTag((MessageLite)block);
    }

    public OsmandOdb.MapData writeMapData(long diffId, int pleft, int ptop, boolean area, byte[] coordinates, byte[] innerPolygonTypes, int[] typeUse, int[] addtypeUse, Map<MapRenderingTypes.MapRulType, String> names, byte[] labelCoordinates, Map<Integer, String> namesDiff, Map<String, Integer> stringTable, OsmandOdb.MapDataBlock.Builder dataBlock, boolean allowCoordinateSimplification) throws IOException {
        int ty;
        int tx;
        int y;
        int x;
        int i;
        OsmandOdb.MapData.Builder data = OsmandOdb.MapData.newBuilder();
        this.mapDataBuf.clear();
        int pcalcx = pleft >> 5;
        int pcalcy = ptop >> 5;
        int len = coordinates.length / 8;
        int delta = 1;
        long sumLabelX = 0L;
        long sumLabelY = 0L;
        int sumLabelCount = 0;
        for (i = 0; i < len; i += delta) {
            x = Algorithms.parseIntFromBytes((byte[])coordinates, (int)(i * 8));
            y = Algorithms.parseIntFromBytes((byte[])coordinates, (int)(i * 8 + 4));
            tx = (x >> 5) - pcalcx;
            ty = (y >> 5) - pcalcy;
            this.writeRawVarint32(this.mapDataBuf, CodedOutputStream.encodeZigZag32((int)tx));
            this.writeRawVarint32(this.mapDataBuf, CodedOutputStream.encodeZigZag32((int)ty));
            sumLabelX += (long)(pcalcx += tx);
            sumLabelY += (long)(pcalcy += ty);
            ++sumLabelCount;
            delta = 1;
            if (!allowCoordinateSimplification) continue;
            delta = this.skipSomeNodes(coordinates, len, i, x, y, false);
        }
        COORDINATES_SIZE += CodedOutputStream.computeRawVarint32Size((int)this.mapDataBuf.size()) + CodedOutputStream.computeTagSize((int)1) + this.mapDataBuf.size();
        if (area) {
            data.setAreaCoordinates(ByteString.copyFrom((byte[])this.mapDataBuf.toArray()));
        } else {
            data.setCoordinates(ByteString.copyFrom((byte[])this.mapDataBuf.toArray()));
        }
        if (innerPolygonTypes != null && innerPolygonTypes.length > 0) {
            this.mapDataBuf.clear();
            pcalcx = pleft >> 5;
            pcalcy = ptop >> 5;
            len = innerPolygonTypes.length / 8;
            for (i = 0; i < len; i += delta) {
                x = Algorithms.parseIntFromBytes((byte[])innerPolygonTypes, (int)(i * 8));
                y = Algorithms.parseIntFromBytes((byte[])innerPolygonTypes, (int)(i * 8 + 4));
                if (x == 0 && y == 0) {
                    if (this.mapDataBuf.size() > 0) {
                        data.addPolygonInnerCoordinates(ByteString.copyFrom((byte[])this.mapDataBuf.toArray()));
                        this.mapDataBuf.clear();
                    }
                    pcalcx = pleft >> 5;
                    pcalcy = ptop >> 5;
                    continue;
                }
                tx = (x >> 5) - pcalcx;
                ty = (y >> 5) - pcalcy;
                this.writeRawVarint32(this.mapDataBuf, CodedOutputStream.encodeZigZag32((int)tx));
                this.writeRawVarint32(this.mapDataBuf, CodedOutputStream.encodeZigZag32((int)ty));
                pcalcx += tx;
                pcalcy += ty;
                delta = 1;
                if (!allowCoordinateSimplification) continue;
                delta = this.skipSomeNodes(innerPolygonTypes, len, i, x, y, true);
            }
        }
        if (labelCoordinates != null && labelCoordinates.length > 0 && sumLabelCount > 0) {
            this.mapDataBuf.clear();
            int LABEL_SHIFT = 5;
            x = Algorithms.parseIntFromBytes((byte[])labelCoordinates, (int)0) >> LABEL_SHIFT;
            y = Algorithms.parseIntFromBytes((byte[])labelCoordinates, (int)4) >> LABEL_SHIFT;
            long labelX = sumLabelX / (long)sumLabelCount << 5 - LABEL_SHIFT;
            long labelY = sumLabelY / (long)sumLabelCount << 5 - LABEL_SHIFT;
            boolean isPOI = true;
            if (Math.abs(labelX) > 1024L && Math.abs(labelY) > 1024L || isPOI) {
                this.writeRawVarint32(this.mapDataBuf, CodedOutputStream.encodeZigZag32((int)(x - (int)labelX)));
                this.writeRawVarint32(this.mapDataBuf, CodedOutputStream.encodeZigZag32((int)(y - (int)labelY)));
                data.setLabelcoordinates(ByteString.copyFrom((byte[])this.mapDataBuf.toArray()));
                LABEL_COORDINATES_SIZE += CodedOutputStream.computeRawVarint32Size((int)this.mapDataBuf.size()) + CodedOutputStream.computeTagSize((int)8) + this.mapDataBuf.size();
            }
        }
        this.mapDataBuf.clear();
        for (i = 0; i < typeUse.length; ++i) {
            this.writeRawVarint32(this.mapDataBuf, typeUse[i]);
        }
        data.setTypes(ByteString.copyFrom((byte[])this.mapDataBuf.toArray()));
        TYPES_SIZE += CodedOutputStream.computeTagSize((int)7) + CodedOutputStream.computeRawVarint32Size((int)this.mapDataBuf.size()) + this.mapDataBuf.size();
        if (addtypeUse != null && addtypeUse.length > 0) {
            this.mapDataBuf.clear();
            for (i = 0; i < addtypeUse.length; ++i) {
                this.writeRawVarint32(this.mapDataBuf, addtypeUse[i]);
            }
            data.setAdditionalTypes(ByteString.copyFrom((byte[])this.mapDataBuf.toArray()));
            TYPES_SIZE += CodedOutputStream.computeTagSize((int)6);
        }
        this.mapDataBuf.clear();
        if (names != null) {
            for (Map.Entry<MapRenderingTypes.MapRulType, String> s : names.entrySet()) {
                this.writeRawVarint32(this.mapDataBuf, s.getKey().getTargetId());
                Integer ls = stringTable.get(s.getValue());
                if (ls == null) {
                    ls = stringTable.size();
                    stringTable.put(s.getValue(), ls);
                }
                this.writeRawVarint32(this.mapDataBuf, ls);
            }
        }
        if (namesDiff != null) {
            for (Map.Entry<Integer, String> it : namesDiff.entrySet()) {
                this.writeRawVarint32(this.mapDataBuf, it.getKey());
                Integer ls = stringTable.get(it.getValue());
                if (ls == null) {
                    ls = stringTable.size();
                    stringTable.put(it.getValue(), ls);
                }
                this.writeRawVarint32(this.mapDataBuf, ls);
            }
        }
        STRING_TABLE_SIZE += this.mapDataBuf.size();
        data.setStringNames(ByteString.copyFrom((byte[])this.mapDataBuf.toArray()));
        data.setId(diffId);
        ID_SIZE += CodedOutputStream.computeSInt64Size((int)12, (long)diffId);
        return data.build();
    }

    private static double orthogonalDistance(int x, int y, int x1, int y1, int x2, int y2) {
        long A = x - x1;
        long B = y - y1;
        long C = x2 - x1;
        long D = y2 - y1;
        return (double)Math.abs(A * D - C * B) / Math.sqrt(C * C + D * D);
    }

    private int skipSomeNodes(byte[] coordinates, int len, int i, int x, int y, boolean multi) {
        int delta = 1;
        while (i + delta < len - 1) {
            double dist;
            int nx = Algorithms.parseIntFromBytes((byte[])coordinates, (int)((i + delta) * 8));
            int ny = Algorithms.parseIntFromBytes((byte[])coordinates, (int)((i + delta) * 8 + 4));
            int nnx = Algorithms.parseIntFromBytes((byte[])coordinates, (int)((i + delta + 1) * 8));
            int nny = Algorithms.parseIntFromBytes((byte[])coordinates, (int)((i + delta + 1) * 8 + 4));
            if (nnx == 0 && nny == 0 || (dist = BinaryMapIndexWriter.orthogonalDistance(nx, ny, x, y, nnx, nny)) > 31.0) break;
            ++delta;
        }
        return delta;
    }

    public void startWriteAddressIndex(String name, Collection<String> additionalTags) throws IOException {
        this.pushState(5, 1);
        this.codedOutStream.writeTag(7, 6);
        this.preserveInt32Size();
        this.codedOutStream.writeString(1, name);
        this.codedOutStream.writeString(2, Junidecode.unidecode((String)name));
        OsmandOdb.StringTable.Builder bs = OsmandOdb.StringTable.newBuilder();
        for (String s : additionalTags) {
            bs.addS(s);
        }
        this.codedOutStream.writeTag(4, WireFormat.FieldType.MESSAGE.getWireType());
        this.codedOutStream.writeMessageNoTag((MessageLite)bs.build());
    }

    public void endWriteAddressIndex() throws IOException {
        this.popState(5);
        long len = this.writeInt32Size();
        log.info((Object)("ADDRESS INDEX SIZE : " + len));
    }

    public void writeAddressNameIndex(Map<String, List<MapObject>> namesIndex) throws IOException {
        this.checkPeekState(5);
        this.codedOutStream.writeTag(7, 6);
        this.preserveInt32Size();
        Map<String, BinaryFileReference> res = this.writeIndexedTable(4, namesIndex.keySet());
        for (Map.Entry<String, List<MapObject>> entry : namesIndex.entrySet()) {
            BinaryFileReference ref = res.get(entry.getKey());
            this.codedOutStream.writeTag(7, WireFormat.FieldType.MESSAGE.getWireType());
            this.codedOutStream.flush();
            long pointer = this.getFilePointer();
            if (ref != null) {
                ref.writeReference(this.raf, this.getFilePointer());
            }
            OsmandOdb.OsmAndAddressNameIndexData.AddressNameIndexData.Builder builder = OsmandOdb.OsmAndAddressNameIndexData.AddressNameIndexData.newBuilder();
            for (MapObject o : entry.getValue()) {
                OsmandOdb.AddressNameIndexDataAtom.Builder atom = OsmandOdb.AddressNameIndexDataAtom.newBuilder();
                int type = 1;
                if (o instanceof City) {
                    if (((City)o).isPostcode()) {
                        type = 2;
                    } else {
                        City.CityType ct = ((City)o).getType();
                        if (ct != City.CityType.CITY && ct != City.CityType.TOWN) {
                            type = 3;
                        }
                    }
                } else if (o instanceof Street) {
                    type = 4;
                }
                atom.setType(type);
                LatLon ll = o.getLocation();
                int x = (int)MapUtils.getTileNumberX((float)16.0f, (double)ll.getLongitude());
                int y = (int)MapUtils.getTileNumberY((float)16.0f, (double)ll.getLatitude());
                atom.addXy16((x << 16) + y);
                atom.addShiftToIndex((int)(pointer - o.getFileOffset()));
                if (o instanceof Street) {
                    atom.addShiftToCityIndex((int)(pointer - ((Street)o).getCity().getFileOffset()));
                }
                builder.addAtom(atom.build());
            }
            this.codedOutStream.writeMessageNoTag((MessageLite)builder.build());
        }
        long len = this.writeInt32Size();
        log.info((Object)("ADDRESS NAME INDEX SIZE : " + len));
    }

    private boolean checkEnNameToWrite(MapObject obj) {
        return obj.getEnName(false) != null && obj.getEnName(false).length() != 0;
    }

    public BinaryFileReference writeCityHeader(MapObject city, int cityType, Map<String, Integer> tagRules) throws IOException {
        this.checkPeekState(6);
        this.codedOutStream.writeTag(5, WireFormat.FieldType.MESSAGE.getWireType());
        long startMessage = this.getFilePointer();
        OsmandOdb.CityIndex.Builder cityInd = OsmandOdb.CityIndex.newBuilder();
        if (cityType >= 0) {
            cityInd.setCityType(cityType);
        }
        if (city.getId() != null) {
            cityInd.setId(city.getId().longValue());
        }
        cityInd.setName(city.getName());
        if (this.checkEnNameToWrite(city)) {
            cityInd.setNameEn(city.getEnName(false));
        }
        for (Map.Entry next : city.getNamesMap(false).entrySet()) {
            Integer intg = tagRules.get("name:" + (String)next.getKey());
            if (intg == null) continue;
            cityInd.addAttributeTagIds(intg.intValue());
            cityInd.addAttributeValues((String)next.getValue());
        }
        int cx = MapUtils.get31TileNumberX((double)city.getLocation().getLongitude());
        int cy = MapUtils.get31TileNumberY((double)city.getLocation().getLatitude());
        cityInd.setX(cx);
        cityInd.setY(cy);
        cityInd.setShiftToCityBlockIndex(0);
        this.codedOutStream.writeMessageNoTag((MessageLite)cityInd.build());
        this.codedOutStream.flush();
        return BinaryFileReference.createShiftReference(this.getFilePointer() - 4L, startMessage);
    }

    public void writeCityIndex(City cityOrPostcode, List<Street> streets, Map<Street, List<Node>> wayNodes, BinaryFileReference ref, Map<String, Integer> tagRules) throws IOException {
        this.checkPeekState(6);
        this.codedOutStream.writeTag(7, WireFormat.FieldType.MESSAGE.getWireType());
        this.codedOutStream.flush();
        long startMessage = this.getFilePointer();
        long startCityBlock = ref.getStartPointer();
        ref.writeReference(this.raf, startMessage);
        OsmandOdb.CityBlockIndex.Builder cityInd = OsmandOdb.CityBlockIndex.newBuilder();
        cityInd.setShiftToCityIndex((int)(startMessage - startCityBlock));
        long currentPointer = startMessage + 4L + (long)CodedOutputStream.computeTagSize((int)4);
        int cx = MapUtils.get31TileNumberX((double)cityOrPostcode.getLocation().getLongitude());
        int cy = MapUtils.get31TileNumberY((double)cityOrPostcode.getLocation().getLatitude());
        LinkedHashMap<Long, Set<Street>> mapNodeToStreet = new LinkedHashMap<Long, Set<Street>>();
        if (wayNodes != null) {
            for (int i = 0; i < streets.size(); ++i) {
                for (Node n : wayNodes.get(streets.get(i))) {
                    if (!mapNodeToStreet.containsKey(n.getId())) {
                        mapNodeToStreet.put(n.getId(), new LinkedHashSet(3));
                    }
                    ((Set)mapNodeToStreet.get(n.getId())).add(streets.get(i));
                }
            }
        }
        String postcodeFilter = cityOrPostcode.isPostcode() ? cityOrPostcode.getName() : null;
        for (Street s : streets) {
            OsmandOdb.StreetIndex streetInd = this.createStreetAndBuildings(s, cx, cy, postcodeFilter, mapNodeToStreet, wayNodes, tagRules);
            if ((currentPointer += (long)CodedOutputStream.computeTagSize((int)12)) > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("File offset > 2 GB.");
            }
            s.setFileOffset((long)((int)currentPointer));
            currentPointer += (long)CodedOutputStream.computeMessageSizeNoTag((MessageLite)streetInd);
            cityInd.addStreets(streetInd);
        }
        OsmandOdb.CityBlockIndex block = cityInd.build();
        int size = CodedOutputStream.computeRawVarint32Size((int)block.getSerializedSize());
        this.codedOutStream.writeMessageNoTag((MessageLite)block);
        for (Street s : streets) {
            s.setFileOffset(s.getFileOffset() + (long)size);
        }
    }

    public void startCityBlockIndex(int type) throws IOException {
        this.pushState(6, 5);
        this.codedOutStream.writeTag(6, 6);
        this.preserveInt32Size();
        this.codedOutStream.writeUInt32(2, type);
    }

    public void endCityBlockIndex() throws IOException {
        this.popState(6);
        long length = this.writeInt32Size();
        log.info((Object)("CITIES size " + length));
    }

    protected OsmandOdb.StreetIndex createStreetAndBuildings(Street street, int cx, int cy, String postcodeFilter, Map<Long, Set<Street>> mapNodeToStreet, Map<Street, List<Node>> wayNodes, Map<String, Integer> tagRules) throws IOException {
        this.checkPeekState(6);
        OsmandOdb.StreetIndex.Builder streetBuilder = OsmandOdb.StreetIndex.newBuilder();
        streetBuilder.setName(street.getName());
        if (this.checkEnNameToWrite((MapObject)street)) {
            streetBuilder.setNameEn(street.getEnName(false));
        }
        for (Map.Entry next : street.getNamesMap(false).entrySet()) {
            Integer intg = tagRules.get("name:" + (String)next.getKey());
            if (intg == null) continue;
            streetBuilder.addAttributeTagIds(intg.intValue());
            streetBuilder.addAttributeValues((String)next.getValue());
        }
        streetBuilder.setId(street.getId().longValue());
        int sx = MapUtils.get31TileNumberX((double)street.getLocation().getLongitude());
        int sy = MapUtils.get31TileNumberY((double)street.getLocation().getLatitude());
        streetBuilder.setX((sx >> 7) - (cx >> 7));
        streetBuilder.setY((sy >> 7) - (cy >> 7));
        street.sortBuildings();
        for (Building b : street.getBuildings()) {
            if (postcodeFilter != null && !postcodeFilter.equalsIgnoreCase(b.getPostcode())) continue;
            OsmandOdb.BuildingIndex.Builder bbuilder = OsmandOdb.BuildingIndex.newBuilder();
            int bx = MapUtils.get31TileNumberX((double)b.getLocation().getLongitude());
            int by = MapUtils.get31TileNumberY((double)b.getLocation().getLatitude());
            bbuilder.setX((bx >> 7) - (sx >> 7));
            bbuilder.setY((by >> 7) - (sy >> 7));
            String number2 = b.getName2();
            if (!Algorithms.isEmpty((CharSequence)number2)) {
                LatLon loc = b.getLatLon2();
                if (loc == null) {
                    bbuilder.setX((bx >> 7) - (sx >> 7));
                    bbuilder.setY((by >> 7) - (sy >> 7));
                } else {
                    int bcx = MapUtils.get31TileNumberX((double)loc.getLongitude());
                    int bcy = MapUtils.get31TileNumberY((double)loc.getLatitude());
                    bbuilder.setX2((bcx >> 7) - (sx >> 7));
                    bbuilder.setY2((bcy >> 7) - (sy >> 7));
                }
                bbuilder.setName2(number2);
                if (b.getInterpolationType() != null) {
                    bbuilder.setInterpolation(b.getInterpolationType().getValue());
                } else if (b.getInterpolationInterval() > 0) {
                    bbuilder.setInterpolation(b.getInterpolationInterval());
                } else {
                    bbuilder.setInterpolation(1);
                }
            }
            bbuilder.setName(b.getName());
            if (b.getPostcode() != null) {
                bbuilder.setPostcode(b.getPostcode());
            }
            for (Map.Entry next : b.getNamesMap(false).entrySet()) {
                Integer intg = tagRules.get("name:" + (String)next.getKey());
                if (intg == null) continue;
                bbuilder.addAttributeTagIds(intg.intValue());
                bbuilder.addAttributeValues((String)next.getValue());
            }
            if (this.checkEnNameToWrite((MapObject)b)) {
                bbuilder.setNameEn(b.getEnName(false));
            }
            if (postcodeFilter == null && b.getPostcode() != null) {
                bbuilder.setPostcode(b.getPostcode());
            }
            streetBuilder.addBuildings(bbuilder.build());
        }
        if (wayNodes != null) {
            TreeSet<Street> checkedStreets = new TreeSet<Street>();
            for (Node intersection : wayNodes.get(street)) {
                for (Street streetJ : mapNodeToStreet.get(intersection.getId())) {
                    if (checkedStreets.contains(streetJ) || streetJ.getId().longValue() == street.getId().longValue()) continue;
                    checkedStreets.add(streetJ);
                    OsmandOdb.StreetIntersection.Builder builder = OsmandOdb.StreetIntersection.newBuilder();
                    int ix = MapUtils.get31TileNumberX((double)intersection.getLongitude());
                    int iy = MapUtils.get31TileNumberY((double)intersection.getLatitude());
                    builder.setIntersectedX(ix - sx >> 7);
                    builder.setIntersectedY(iy - sy >> 7);
                    builder.setName(streetJ.getName());
                    if (this.checkEnNameToWrite((MapObject)streetJ)) {
                        builder.setNameEn(streetJ.getEnName(false));
                    }
                    for (Map.Entry next : streetJ.getNamesMap(false).entrySet()) {
                        Integer intg = tagRules.get("name:" + (String)next.getKey());
                        if (intg == null) continue;
                        builder.addAttributeTagIds(intg.intValue());
                        builder.addAttributeValues((String)next.getValue());
                    }
                    streetBuilder.addIntersections(builder.build());
                }
            }
        }
        return streetBuilder.build();
    }

    public void startWriteTransportRoutes() throws IOException {
        this.pushState(11, 9);
        this.codedOutStream.writeTag(3, 6);
        this.preserveInt32Size();
    }

    public void endWriteTransportRoutes() throws IOException {
        this.popState(11);
        this.writeInt32Size();
    }

    private int registerString(Map<String, Integer> stringTable, String s) {
        if (s == null) {
            s = "";
        }
        if (stringTable.containsKey(s)) {
            return stringTable.get(s);
        }
        int size = stringTable.size();
        stringTable.put(s, size);
        return size;
    }

    public long startWriteTransportIndex(String name) throws IOException {
        this.pushState(9, 1);
        this.codedOutStream.writeTag(4, 6);
        this.stackBounds.push(new Bounds(0, 0, 0, 0));
        this.preserveInt32Size();
        long tiOffset = this.getFilePointer();
        if (name != null) {
            this.codedOutStream.writeString(1, name);
        }
        return tiOffset;
    }

    public void endWriteTransportIndex() throws IOException {
        this.popState(9);
        long len = this.writeInt32Size();
        this.stackBounds.pop();
        log.info((Object)("TRANSPORT INDEX SIZE : " + len));
    }

    public long writeTransportRoute(long idRoute, String routeName, String routeEnName, String ref, String operator, String type, int dist, String color, List<TransportStop> directStops, List<byte[]> directRoute, Map<String, Integer> stringTable, Map<Long, Long> transportRoutesRegistry, TransportSchedule schedule, TransportTags tags) throws IOException {
        this.checkPeekState(11);
        OsmandOdb.TransportRoute.Builder tRoute = OsmandOdb.TransportRoute.newBuilder();
        tRoute.setRef(ref);
        tRoute.setOperator(this.registerString(stringTable, operator));
        tRoute.setType(this.registerString(stringTable, type));
        tRoute.setId(idRoute);
        tRoute.setName(this.registerString(stringTable, routeName));
        tRoute.setDistance(dist);
        tRoute.setColor(this.registerString(stringTable, color));
        if (tags != null && tags.get(idRoute) != null) {
            TByteArrayList buf = new TByteArrayList();
            for (TransportTags.TransportTagValue tag : tags.get(idRoute)) {
                if (tag.isPopular()) {
                    tRoute.addAttributeTagIds(this.registerString(stringTable, tag.getKey()));
                    continue;
                }
                buf.clear();
                int keyId = this.registerString(stringTable, tag.getTag());
                this.writeRawVarint32(buf, keyId);
                for (byte rawByte : tag.getValue().getBytes(StandardCharsets.UTF_8)) {
                    this.writeRawByte(buf, rawByte);
                }
                tRoute.addAttributeTextTagValues(ByteString.copyFrom((byte[])buf.toArray()));
            }
        }
        if (routeEnName != null) {
            tRoute.setNameEn(this.registerString(stringTable, routeEnName));
        }
        List<TransportStop> stops = directStops;
        long id = 0L;
        int x24 = 0;
        int y24 = 0;
        for (TransportStop st : stops) {
            OsmandOdb.TransportRouteStop.Builder tStop = OsmandOdb.TransportRouteStop.newBuilder();
            tStop.setId(st.getId() - id);
            id = st.getId();
            int x = (int)MapUtils.getTileNumberX((float)24.0f, (double)st.getLocation().getLongitude());
            int y = (int)MapUtils.getTileNumberY((float)24.0f, (double)st.getLocation().getLatitude());
            tStop.setDx(x - x24);
            tStop.setDy(y - y24);
            x24 = x;
            y24 = y;
            tStop.setName(this.registerString(stringTable, st.getName()));
            if (st.getEnName(false) != null) {
                tStop.setNameEn(this.registerString(stringTable, st.getEnName(false)));
            }
            tRoute.addDirectStops(tStop.build());
        }
        if (directRoute != null) {
            this.writeTransportRouteCoordinates(directRoute);
            tRoute.setGeometry(ByteString.copyFrom((byte[])this.mapDataBuf.toArray()));
        }
        if (schedule != null && schedule.tripIntervals.size() > 0) {
            int i;
            OsmandOdb.TransportRouteSchedule.Builder sched = OsmandOdb.TransportRouteSchedule.newBuilder();
            TByteArrayList bf = new TByteArrayList();
            for (i = 0; i < schedule.tripIntervals.size(); ++i) {
                this.writeRawVarint32(bf, schedule.tripIntervals.getQuick(i));
            }
            sched.setTripIntervals(ByteString.copyFrom((byte[])bf.toArray()));
            if (schedule.avgStopIntervals.size() > 0) {
                bf.clear();
                for (i = 0; i < schedule.avgStopIntervals.size(); ++i) {
                    this.writeRawVarint32(bf, schedule.avgStopIntervals.getQuick(i));
                }
                sched.setAvgStopIntervals(ByteString.copyFrom((byte[])bf.toArray()));
            }
            if (schedule.avgWaitIntervals.size() > 0) {
                bf.clear();
                for (i = 0; i < schedule.avgWaitIntervals.size(); ++i) {
                    this.writeRawVarint32(bf, schedule.avgWaitIntervals.getQuick(i));
                }
                sched.setAvgWaitIntervals(ByteString.copyFrom((byte[])bf.toArray()));
            }
            tRoute.addScheduleTrip(sched.build());
        }
        this.codedOutStream.writeTag(6, WireFormat.FieldType.MESSAGE.getWireType());
        long ptr = -1L;
        if (transportRoutesRegistry != null) {
            ptr = this.getFilePointer();
            transportRoutesRegistry.put(idRoute, ptr);
        }
        this.codedOutStream.writeMessageNoTag((MessageLite)tRoute.build());
        return ptr;
    }

    private void writeTransportRouteCoordinates(List<byte[]> rt) throws IOException {
        int pcalcx = 0;
        int pcalcy = 0;
        this.mapDataBuf.clear();
        List<TLongArrayList> coordinates = this.simplifyCoordinates(rt);
        for (int j = 0; j < coordinates.size(); ++j) {
            if (j > 0) {
                this.writeRawVarint32(this.mapDataBuf, CodedOutputStream.encodeZigZag32((int)0));
                this.writeRawVarint32(this.mapDataBuf, CodedOutputStream.encodeZigZag32((int)0));
            }
            TLongArrayList lst = coordinates.get(j);
            for (int i = 0; i < lst.size(); ++i) {
                int x = (int)MapUtils.deinterleaveX((long)lst.get(i));
                int y = (int)MapUtils.deinterleaveY((long)lst.get(i));
                int tx = (x >> 5) - pcalcx;
                int ty = (y >> 5) - pcalcy;
                if (tx != 0 || ty != 0) {
                    this.writeRawVarint32(this.mapDataBuf, CodedOutputStream.encodeZigZag32((int)tx));
                    this.writeRawVarint32(this.mapDataBuf, CodedOutputStream.encodeZigZag32((int)ty));
                }
                pcalcx += tx;
                pcalcy += ty;
            }
        }
    }

    private List<TLongArrayList> simplifyCoordinates(List<byte[]> rt) {
        ArrayList<TLongArrayList> ct = new ArrayList<TLongArrayList>();
        for (byte[] coordinates : rt) {
            TLongArrayList lst = new TLongArrayList();
            int len = coordinates.length / 8;
            for (int i = 0; i < len; ++i) {
                int x = Algorithms.parseIntFromBytes((byte[])coordinates, (int)(i * 8));
                int y = Algorithms.parseIntFromBytes((byte[])coordinates, (int)(i * 8 + 4));
                long clt = MapUtils.interleaveBits((long)x, (long)y);
                lst.add(clt);
            }
            if (lst.size() <= 0) continue;
            ct.add(lst);
        }
        int i = 0;
        while (i < ct.size() - 1) {
            TLongArrayList head = (TLongArrayList)ct.get(i);
            int j = i + 1;
            TLongArrayList tail = (TLongArrayList)ct.get(j);
            if (head.get(head.size() - 1) == tail.get(0)) {
                head.addAll((TLongCollection)tail.subList(1, tail.size()));
                ct.remove(j);
                continue;
            }
            if (head.get(head.size() - 1) == tail.get(tail.size() - 1)) {
                TLongList subl = tail.subList(0, tail.size() - 1);
                subl.reverse();
                head.addAll((TLongCollection)subl);
                ct.remove(j);
                continue;
            }
            ++i;
        }
        return ct;
    }

    public void startTransportTreeElement(int leftX, int rightX, int topY, int bottomY) throws IOException {
        this.checkPeekState(10, 9);
        if (this.state.peek() == 10) {
            this.codedOutStream.writeTag(7, 6);
        } else {
            this.codedOutStream.writeTag(6, 6);
        }
        this.state.push(10);
        this.preserveInt32Size();
        Bounds bounds = this.stackBounds.peek();
        this.codedOutStream.writeSInt32(1, leftX - bounds.leftX);
        this.codedOutStream.writeSInt32(2, rightX - bounds.rightX);
        this.codedOutStream.writeSInt32(3, topY - bounds.topY);
        this.codedOutStream.writeSInt32(4, bottomY - bounds.bottomY);
        this.stackBounds.push(new Bounds(leftX, rightX, topY, bottomY));
        this.stackBaseIds.push(-1L);
    }

    public void endWriteTransportTreeElement() throws IOException {
        Long baseId = this.stackBaseIds.pop();
        if (baseId >= 0L) {
            this.codedOutStream.writeUInt64(16, baseId.longValue());
        }
        this.popState(10);
        this.stackBounds.pop();
        this.writeInt32Size();
    }

    public void writeTransportStop(long id, int x24, int y24, String name, String nameEn, Map<String, String> names, Map<String, Integer> stringTable, TLongArrayList routesOffsets, TLongArrayList routesIds, TLongArrayList deletedRoutes, Map<Entity.EntityId, List<TransportStopExit>> exits) throws IOException {
        this.checkPeekState(10);
        Bounds bounds = this.stackBounds.peek();
        if (this.stackBaseIds.peek() == -1L) {
            this.stackBaseIds.pop();
            this.stackBaseIds.push(id);
        }
        this.codedOutStream.writeTag(8, WireFormat.FieldType.MESSAGE.getWireType());
        long fp = this.getFilePointer();
        OsmandOdb.TransportStop.Builder ts = OsmandOdb.TransportStop.newBuilder();
        ts.setName(this.registerString(stringTable, name));
        if (nameEn != null) {
            ts.setNameEn(this.registerString(stringTable, nameEn));
        }
        ts.setDx(x24 - bounds.leftX);
        ts.setDy(y24 - bounds.topY);
        ts.setId(id - this.stackBaseIds.peek());
        this.mapDataBuf.clear();
        for (Map.Entry<String, String> entry : names.entrySet()) {
            this.writeRawVarint32(this.mapDataBuf, this.registerString(stringTable, entry.getKey()));
            this.writeRawVarint32(this.mapDataBuf, this.registerString(stringTable, entry.getValue()));
        }
        ts.setAdditionalNamePairs(ByteString.copyFrom((byte[])this.mapDataBuf.toArray()));
        for (Object i : (Object)routesOffsets.toArray()) {
            ts.addRoutes((int)(fp - i));
        }
        for (Object i : (Object)routesIds.toArray()) {
            ts.addRoutesIds((long)i);
        }
        for (Object i : (Object)deletedRoutes.toArray()) {
            ts.addDeletedRoutesIds((long)i);
        }
        List<TransportStopExit> list = exits.get(new Entity.EntityId(Entity.EntityType.NODE, Long.valueOf(id)));
        if (list != null) {
            for (TransportStopExit e : list) {
                OsmandOdb.TransportStopExit.Builder exit = OsmandOdb.TransportStopExit.newBuilder();
                LatLon location = e.getLocation();
                int exitX24 = (int)MapUtils.getTileNumberX((float)24.0f, (double)location.getLongitude());
                int exitY24 = (int)MapUtils.getTileNumberY((float)24.0f, (double)location.getLatitude());
                exit.setRef(this.registerString(stringTable, e.getRef()));
                exit.setDx(exitX24 - bounds.leftX);
                exit.setDy(exitY24 - bounds.topY);
                ts.addExits(exit);
            }
        }
        this.codedOutStream.writeMessageNoTag((MessageLite)ts.build());
    }

    public void writeIncompleteTransportRoutes(Collection<TransportRoute> incompleteRoutes, Map<String, Integer> stringTable, long transportIndexOffset) throws IOException {
        this.checkPeekState(9);
        OsmandOdb.IncompleteTransportRoutes.Builder irs = OsmandOdb.IncompleteTransportRoutes.newBuilder();
        for (TransportRoute tr : incompleteRoutes) {
            OsmandOdb.IncompleteTransportRoute.Builder ir = OsmandOdb.IncompleteTransportRoute.newBuilder();
            ir.setId(tr.getId().longValue());
            ir.setRouteRef((int)(tr.getFileOffset() - transportIndexOffset));
            ir.setOperator(this.registerString(stringTable, tr.getOperator()));
            ir.setRef(this.registerString(stringTable, tr.getRef()));
            ir.setType(this.registerString(stringTable, tr.getType()));
            irs.addRoutes(ir);
        }
        this.codedOutStream.writeMessage(8, (MessageLite)irs.build());
    }

    public void writeTransportStringTable(Map<String, Integer> stringTable) throws IOException {
        this.checkPeekState(9);
        int i = 0;
        OsmandOdb.StringTable.Builder st = OsmandOdb.StringTable.newBuilder();
        for (String s : stringTable.keySet()) {
            if (stringTable.get(s) != i++) {
                throw new IllegalStateException();
            }
            st.addS(s);
        }
        this.codedOutStream.writeMessage(9, (MessageLite)st.build());
    }

    public long startWritePoiIndex(String name, int left31, int right31, int bottom31, int top31) throws IOException {
        this.pushState(12, 1);
        this.codedOutStream.writeTag(8, 6);
        this.stackBounds.push(new Bounds(0, 0, 0, 0));
        this.preserveInt32Size();
        long startPointer = this.getFilePointer();
        if (name != null) {
            this.codedOutStream.writeString(1, name);
        }
        OsmandOdb.OsmAndTileBox.Builder builder = OsmandOdb.OsmAndTileBox.newBuilder();
        builder.setLeft(left31);
        builder.setRight(right31);
        builder.setTop(top31);
        builder.setBottom(bottom31);
        this.codedOutStream.writeMessage(2, (MessageLite)builder.build());
        return startPointer;
    }

    public void endWritePoiIndex() throws IOException {
        this.popState(12);
        long len = this.writeInt32Size();
        this.stackBounds.pop();
        log.info((Object)("POI INDEX SIZE : " + len));
    }

    public void writePoiCategoriesTable(IndexPoiCreator.PoiCreatorCategories cs) throws IOException {
        this.checkPeekState(12);
        int i = 0;
        for (String cat : cs.categories.keySet()) {
            OsmandOdb.OsmAndCategoryTable.Builder builder = OsmandOdb.OsmAndCategoryTable.newBuilder();
            builder.setCategory(cat);
            Set<String> subcatSource = cs.categories.get(cat);
            cs.setCategoryIndex(cat, i);
            int j = 0;
            for (String s : subcatSource) {
                cs.setSubcategoryIndex(cat, s, j);
                builder.addSubcategories(s);
                ++j;
            }
            this.codedOutStream.writeMessage(3, (MessageLite)builder.build());
            ++i;
        }
    }

    public void writePoiSubtypesTable(IndexPoiCreator.PoiCreatorCategories cs, Map<String, Set<String>> topIndexAdditional) throws IOException {
        this.checkPeekState(12);
        int subcatId = 0;
        OsmandOdb.OsmAndSubtypesTable.Builder builder = OsmandOdb.OsmAndSubtypesTable.newBuilder();
        HashMap groupAdditionalByTagName = new HashMap();
        for (IndexPoiCreator.PoiAdditionalType rt : cs.additionalAttributes) {
            if (!rt.isText()) {
                Set<String> topIndexSet;
                if (topIndexAdditional.containsKey(rt.getTag()) && !(topIndexSet = topIndexAdditional.get(rt.getTag())).contains(rt.getValue())) continue;
                if (!groupAdditionalByTagName.containsKey(rt.getTag())) {
                    groupAdditionalByTagName.put(rt.getTag(), new ArrayList());
                }
                ((List)groupAdditionalByTagName.get(rt.getTag())).add(rt);
                continue;
            }
            rt.setTargetPoiId(subcatId++, 0);
            OsmandOdb.OsmAndPoiSubtype.Builder subType = OsmandOdb.OsmAndPoiSubtype.newBuilder();
            subType.setName(rt.getTag());
            subType.setIsText(true);
            builder.addSubtypes(subType);
        }
        for (String tag : groupAdditionalByTagName.keySet()) {
            int cInd = subcatId++;
            OsmandOdb.OsmAndPoiSubtype.Builder subType = OsmandOdb.OsmAndPoiSubtype.newBuilder();
            subType.setName(tag);
            subType.setIsText(false);
            List list = (List)groupAdditionalByTagName.get(tag);
            subType.setSubtypeValuesSize(list.size());
            int subcInd = 0;
            for (IndexPoiCreator.PoiAdditionalType subtypeVal : list) {
                subtypeVal.setTargetPoiId(cInd, subcInd++);
                subType.addSubtypeValue(subtypeVal.getValue());
            }
            builder.addSubtypes(subType);
        }
        this.codedOutStream.writeMessage(5, (MessageLite)builder.build());
    }

    public void writePoiCategories(IndexPoiCreator.PoiCreatorCategories poiCats) throws IOException {
        int i;
        this.checkPeekState(13);
        OsmandOdb.OsmAndPoiCategories.Builder builder = OsmandOdb.OsmAndPoiCategories.newBuilder();
        int prev = -1;
        poiCats.cachedCategoriesIds.sort();
        for (i = 0; i < poiCats.cachedCategoriesIds.size(); ++i) {
            if (i != 0 && prev == poiCats.cachedCategoriesIds.get(i)) continue;
            builder.addCategories(poiCats.cachedCategoriesIds.get(i));
            prev = poiCats.cachedCategoriesIds.get(i);
        }
        prev = -1;
        poiCats.cachedAdditionalIds.sort();
        for (i = 0; i < poiCats.cachedAdditionalIds.size(); ++i) {
            if (i != 0 && prev == poiCats.cachedAdditionalIds.get(i)) continue;
            builder.addSubcategories(poiCats.cachedAdditionalIds.get(i));
            prev = poiCats.cachedAdditionalIds.get(i);
        }
        this.codedOutStream.writeMessage(4, (MessageLite)builder.build());
    }

    public void writePoiTagGroups(IndexPoiCreator.PoiCreatorTagGroups tagGroups) throws IOException {
        if (tagGroups.ids == null || tagGroups.ids.size() == 0) {
            return;
        }
        this.checkPeekState(13);
        this.codedOutStream.writeTag(8, WireFormat.FieldType.MESSAGE.getWireType());
        OsmandOdb.OsmAndPoiTagGroups.Builder groupsBuilder = OsmandOdb.OsmAndPoiTagGroups.newBuilder();
        Iterator<Object> iterator = tagGroups.ids.iterator();
        while (iterator.hasNext()) {
            int id = iterator.next();
            groupsBuilder.addIds(id);
        }
        for (IndexPoiCreator.PoiCreatorTagGroup tag : tagGroups.tagGroups) {
            OsmandOdb.OsmAndPoiTagGroup.Builder tagBuilder = OsmandOdb.OsmAndPoiTagGroup.newBuilder();
            tagBuilder.setId(tag.id);
            for (String tagValue : tag.tagValues) {
                tagBuilder.addTagValues(tagValue);
            }
            groupsBuilder.addGroups(tagBuilder);
        }
        this.codedOutStream.writeMessageNoTag((MessageLite)groupsBuilder.build());
    }

    public Map<IndexPoiCreator.PoiTileBox, List<BinaryFileReference>> writePoiNameIndex(Map<String, Set<IndexPoiCreator.PoiTileBox>> namesIndex, long startPoiIndex) throws IOException {
        this.checkPeekState(12);
        this.codedOutStream.writeTag(4, 6);
        this.preserveInt32Size();
        LinkedHashMap<IndexPoiCreator.PoiTileBox, List<BinaryFileReference>> fpToWriteSeeks = new LinkedHashMap<IndexPoiCreator.PoiTileBox, List<BinaryFileReference>>();
        Map<String, BinaryFileReference> indexedTable = this.writeIndexedTable(3, namesIndex.keySet());
        for (Map.Entry<String, Set<IndexPoiCreator.PoiTileBox>> e : namesIndex.entrySet()) {
            this.codedOutStream.writeTag(5, WireFormat.FieldType.MESSAGE.getWireType());
            BinaryFileReference nameTableRef = indexedTable.get(e.getKey());
            this.codedOutStream.flush();
            nameTableRef.writeReference(this.raf, this.getFilePointer());
            OsmandOdb.OsmAndPoiNameIndex.OsmAndPoiNameIndexData.Builder builder = OsmandOdb.OsmAndPoiNameIndex.OsmAndPoiNameIndexData.newBuilder();
            ArrayList tileBoxes = new ArrayList(e.getValue());
            for (IndexPoiCreator.PoiTileBox box : tileBoxes) {
                OsmandOdb.OsmAndPoiNameIndexDataAtom.Builder bs = OsmandOdb.OsmAndPoiNameIndexDataAtom.newBuilder();
                bs.setX(box.getX());
                bs.setY(box.getY());
                bs.setZoom(box.getZoom());
                bs.setShiftTo(0);
                OsmandOdb.OsmAndPoiNameIndexDataAtom atom = bs.build();
                builder.addAtoms(atom);
            }
            OsmandOdb.OsmAndPoiNameIndex.OsmAndPoiNameIndexData msg = builder.build();
            this.codedOutStream.writeMessageNoTag((MessageLite)msg);
            long endPointer = this.getFilePointer();
            int accumulateSize = 4;
            for (int i = tileBoxes.size() - 1; i >= 0; --i) {
                IndexPoiCreator.PoiTileBox box = (IndexPoiCreator.PoiTileBox)tileBoxes.get(i);
                if (!fpToWriteSeeks.containsKey(box)) {
                    fpToWriteSeeks.put(box, new ArrayList());
                }
                ((List)fpToWriteSeeks.get(box)).add(BinaryFileReference.createShiftReference(endPointer - (long)accumulateSize, startPoiIndex));
                accumulateSize += CodedOutputStream.computeMessageSize((int)3, (MessageLite)msg.getAtoms(i));
            }
        }
        this.writeInt32Size();
        return fpToWriteSeeks;
    }

    private Map<String, BinaryFileReference> writeIndexedTable(int tag, Collection<String> indexedTable) throws IOException {
        this.codedOutStream.writeTag(tag, 6);
        this.preserveInt32Size();
        LinkedHashMap<String, BinaryFileReference> res = new LinkedHashMap<String, BinaryFileReference>();
        long init = this.getFilePointer();
        for (String e : indexedTable) {
            this.codedOutStream.writeString(3, e);
            this.codedOutStream.writeTag(4, 6);
            BinaryFileReference ref = BinaryFileReference.createShiftReference(this.getFilePointer(), init);
            this.codedOutStream.writeFixed32NoTag(0);
            res.put(e, ref);
        }
        this.writeInt32Size();
        return res;
    }

    public void writePoiDataAtom(long id, int x24shift, int y24shift, String type, String subtype, Map<IndexPoiCreator.PoiAdditionalType, String> additionalNames, IndexPoiCreator.PoiCreatorCategories globalCategories, int limitZip, int precisionXY, List<Integer> tagGroupsIds) throws IOException {
        this.checkPeekState(14);
        TIntArrayList types = globalCategories.buildTypeIds(type, subtype);
        OsmandOdb.OsmAndPoiBoxDataAtom.Builder builder = OsmandOdb.OsmAndPoiBoxDataAtom.newBuilder();
        builder.setDx(x24shift);
        builder.setDy(y24shift);
        builder.setPrecisionXY(precisionXY);
        for (int i = 0; i < types.size(); ++i) {
            int n = types.get(i);
            builder.addCategories(n);
        }
        builder.setId(id);
        Iterator<Object> iterator = tagGroupsIds.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            builder.addTagGroups(n);
        }
        for (Map.Entry entry : additionalNames.entrySet()) {
            int targetPoiId = ((IndexPoiCreator.PoiAdditionalType)entry.getKey()).getTargetId();
            String tg = ((IndexPoiCreator.PoiAdditionalType)entry.getKey()).getTag();
            if (targetPoiId < 0) {
                throw new IllegalStateException("Illegal target poi id");
            }
            if (!((IndexPoiCreator.PoiAdditionalType)entry.getKey()).isText()) {
                builder.addSubcategories(targetPoiId);
                continue;
            }
            builder.addTextCategories(targetPoiId);
            String vl = (String)entry.getValue();
            if (vl != null && limitZip != -1 && vl.length() >= limitZip && !"opening_hours".equals(tg)) {
                ByteArrayOutputStream bous = new ByteArrayOutputStream(vl.length());
                GZIPOutputStream gz = new GZIPOutputStream(bous);
                byte[] bts = vl.getBytes("UTF-8");
                gz.write(bts);
                gz.close();
                byte[] res = bous.toByteArray();
                StringBuilder sb = new StringBuilder(res.length);
                sb.append(" gz ");
                for (int i = 0; i < res.length; ++i) {
                    sb.append((char)(res[i] + 128 + 32));
                }
                vl = sb.toString();
            } else if (vl != null) {
                vl = vl.trim();
            }
            builder.addTextValues(vl);
        }
        this.codedOutStream.writeMessage(5, (MessageLite)builder.build());
    }

    public void startWritePoiData(int zoom, int x, int y, List<BinaryFileReference> fpPoiBox) throws IOException {
        this.pushState(14, 12);
        this.codedOutStream.writeTag(9, 6);
        long pointer = this.getFilePointer();
        this.preserveInt32Size();
        this.codedOutStream.flush();
        for (int i = 0; i < fpPoiBox.size(); ++i) {
            fpPoiBox.get(i).writeReference(this.raf, pointer);
        }
        this.codedOutStream.writeUInt32(1, zoom);
        this.codedOutStream.writeUInt32(2, x);
        this.codedOutStream.writeUInt32(3, y);
    }

    public void endWritePoiData() throws IOException {
        this.popState(14);
        this.writeInt32Size();
    }

    public BinaryFileReference startWritePoiBox(int zoom, int tileX, int tileY, long startPoiIndex, boolean end) throws IOException {
        this.checkPeekState(12, 13);
        if (this.state.peek() == 12) {
            this.codedOutStream.writeTag(6, 6);
        } else {
            this.codedOutStream.writeTag(10, 6);
        }
        this.state.push(13);
        this.preserveInt32Size();
        Bounds bounds = this.stackBounds.peek();
        int parentZoom = bounds.rightX;
        int parentTileX = bounds.leftX;
        int parentTileY = bounds.topY;
        int pTileX = parentTileX << zoom - parentZoom;
        int pTileY = parentTileY << zoom - parentZoom;
        this.codedOutStream.writeUInt32(1, zoom - parentZoom);
        this.codedOutStream.writeSInt32(2, tileX - pTileX);
        this.codedOutStream.writeSInt32(3, tileY - pTileY);
        this.stackBounds.push(new Bounds(tileX, zoom, tileY, 0));
        if (end) {
            this.codedOutStream.writeTag(14, 6);
            BinaryFileReference shift = BinaryFileReference.createShiftReference(this.getFilePointer(), startPoiIndex);
            this.codedOutStream.writeFixed32NoTag(0);
            return shift;
        }
        return null;
    }

    public void endWritePoiBox() throws IOException {
        this.popState(13);
        this.writeInt32Size();
        this.stackBounds.pop();
    }

    private void pushState(int push, int peek) {
        if (this.state.peek() != peek) {
            throw new IllegalStateException("expected " + peek + " != " + String.valueOf(this.state.peek()));
        }
        this.state.push(push);
    }

    private void checkPeekState(int ... states) {
        for (int i = 0; i < states.length; ++i) {
            if (states[i] != this.state.peek()) continue;
            return;
        }
        throw new IllegalStateException("Note expected state : " + String.valueOf(this.state.peek()));
    }

    private void popState(int state) {
        Integer st = this.state.pop();
        if (st != state) {
            throw new IllegalStateException("expected " + state + " != " + st);
        }
    }

    public void flush() throws IOException {
        this.codedOutStream.flush();
    }

    public void close() throws IOException {
        this.checkPeekState(1);
        this.codedOutStream.writeInt32(32, 2);
        this.codedOutStream.flush();
    }

    public void preclose() throws IOException {
        this.codedOutStream.writeInt32(32, 2);
        this.codedOutStream.flush();
    }

    public void writeOsmAndOwner(BinaryMapIndexReader.OsmAndOwner owner) throws IOException {
        OsmandOdb.OsmAndOwner.Builder b = OsmandOdb.OsmAndOwner.newBuilder();
        b.setName(owner.getName());
        if (!owner.getResource().isEmpty()) {
            b.setResource(owner.getResource());
        }
        if (!owner.getDescription().isEmpty()) {
            b.setDescription(owner.getDescription());
        }
        if (!owner.getPluginid().isEmpty()) {
            b.setPluginid(owner.getPluginid());
        }
        OsmandOdb.OsmAndOwner m = b.build();
        this.codedOutStream.writeMessage(33, (MessageLite)m);
    }

    private static class Bounds {
        int leftX = 0;
        int rightX = 0;
        int topY = 0;
        int bottomY = 0;

        public Bounds(int leftX, int rightX, int topY, int bottomY) {
            this.bottomY = bottomY;
            this.leftX = leftX;
            this.rightX = rightX;
            this.topY = topY;
        }
    }

    public static class RoutePointToWrite {
        public TIntArrayList types = new TIntArrayList();
        public int id;
        public int x;
        public int y;
    }
}

