/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.trie;

import com.atilika.kuromoji.compile.ProgressLog;
import com.atilika.kuromoji.trie.Trie;
import com.atilika.kuromoji.util.ResourceResolver;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;

public class DoubleArrayTrie {
    public static final String DOUBLE_ARRAY_TRIE_FILENAME = "doubleArrayTrie.bin";
    public static final char TERMINATING_CHARACTER = '\u0001';
    private static final int BASE_CHECK_INITIAL_SIZE = 2800000;
    private static final int TAIL_INITIAL_SIZE = 200000;
    private static final int TAIL_OFFSET = 100000000;
    private static float BUFFER_GROWTH_PERCENTAGE = 0.25f;
    private IntBuffer baseBuffer;
    private IntBuffer checkBuffer;
    private CharBuffer tailBuffer;
    private int tailIndex = 100000000;
    private int maxBaseCheckIndex = 0;
    private boolean compact;

    public DoubleArrayTrie() {
        this(false);
    }

    public DoubleArrayTrie(boolean compactTries) {
        this.compact = compactTries;
    }

    public void write(OutputStream output) throws IOException {
        this.baseBuffer.rewind();
        this.checkBuffer.rewind();
        this.tailBuffer.rewind();
        int baseCheckSize = Math.min(this.maxBaseCheckIndex + 64, this.baseBuffer.capacity());
        int tailSize = Math.min(this.tailIndex - 100000000 + 64, this.tailBuffer.capacity());
        DataOutputStream dataOutput = new DataOutputStream(new BufferedOutputStream(output));
        dataOutput.writeBoolean(this.compact);
        dataOutput.writeInt(baseCheckSize);
        dataOutput.writeInt(tailSize);
        WritableByteChannel channel = Channels.newChannel(dataOutput);
        ByteBuffer tmpBuffer = ByteBuffer.allocate(baseCheckSize * 4);
        IntBuffer tmpIntBuffer = tmpBuffer.asIntBuffer();
        tmpIntBuffer.put(this.baseBuffer.array(), 0, baseCheckSize);
        tmpBuffer.rewind();
        channel.write(tmpBuffer);
        tmpBuffer = ByteBuffer.allocate(baseCheckSize * 4);
        tmpIntBuffer = tmpBuffer.asIntBuffer();
        tmpIntBuffer.put(this.checkBuffer.array(), 0, baseCheckSize);
        tmpBuffer.rewind();
        channel.write(tmpBuffer);
        tmpBuffer = ByteBuffer.allocate(tailSize * 2);
        CharBuffer tmpCharBuffer = tmpBuffer.asCharBuffer();
        tmpCharBuffer.put(this.tailBuffer.array(), 0, tailSize);
        tmpBuffer.rewind();
        channel.write(tmpBuffer);
        dataOutput.flush();
    }

    public static DoubleArrayTrie newInstance(ResourceResolver resolver) throws IOException {
        return DoubleArrayTrie.read(resolver.resolve(DOUBLE_ARRAY_TRIE_FILENAME));
    }

    public static DoubleArrayTrie read(InputStream input) throws IOException {
        DoubleArrayTrie trie = new DoubleArrayTrie();
        DataInputStream dis = new DataInputStream(new BufferedInputStream(input));
        trie.compact = dis.readBoolean();
        int baseCheckSize = dis.readInt();
        int tailSize = dis.readInt();
        ReadableByteChannel channel = Channels.newChannel(dis);
        ByteBuffer tmpBaseBuffer = ByteBuffer.allocate(baseCheckSize * 4);
        channel.read(tmpBaseBuffer);
        tmpBaseBuffer.rewind();
        trie.baseBuffer = tmpBaseBuffer.asIntBuffer();
        ByteBuffer tmpCheckBuffer = ByteBuffer.allocate(baseCheckSize * 4);
        channel.read(tmpCheckBuffer);
        tmpCheckBuffer.rewind();
        trie.checkBuffer = tmpCheckBuffer.asIntBuffer();
        ByteBuffer tmpTailBuffer = ByteBuffer.allocate(tailSize * 2);
        channel.read(tmpTailBuffer);
        tmpTailBuffer.rewind();
        trie.tailBuffer = tmpTailBuffer.asCharBuffer();
        input.close();
        return trie;
    }

    public void build(Trie trie) {
        ProgressLog.begin("building " + (this.compact ? "compact" : "sparse") + " trie");
        this.baseBuffer = IntBuffer.allocate(2800000);
        this.baseBuffer.put(0, 1);
        this.checkBuffer = IntBuffer.allocate(2800000);
        this.tailBuffer = CharBuffer.allocate(200000);
        this.add(-1, 0, trie.getRoot());
        this.reportUtilizationRate();
        ProgressLog.end();
    }

    private void reportUtilizationRate() {
        int zeros = 0;
        for (int i = 0; i < this.maxBaseCheckIndex; ++i) {
            if (this.baseBuffer.get(i) != 0) continue;
            ++zeros;
        }
        ProgressLog.println("trie memory utilization ratio (" + (!this.compact ? "not " : "") + "compacted): " + (float)(this.maxBaseCheckIndex - zeros) / (float)this.maxBaseCheckIndex);
    }

    private void add(int previous, int index, Trie.Node node) {
        if (!node.getChildren().isEmpty() && node.hasSinglePath() && node.getChildren().get(0).getKey() != '\u0001') {
            this.baseBuffer.put(index, this.tailIndex);
            this.addToTail(node.getChildren().get(0));
            this.checkBuffer.put(index, previous);
            return;
        }
        int startIndex = this.compact ? 0 : index;
        int base = this.findBase(startIndex, node.getChildren());
        this.baseBuffer.put(index, base);
        if (previous >= 0) {
            this.checkBuffer.put(index, previous);
        }
        for (Trie.Node child : node.getChildren()) {
            if (this.compact) {
                this.add(index, base + child.getKey(), child);
                continue;
            }
            this.add(index, index + base + child.getKey(), child);
        }
    }

    public int lookup(String key) {
        return this.lookup(key, 0, 0);
    }

    public int lookup(String key, int index, int j) {
        int base = 1;
        if (index != 0) {
            base = this.baseBuffer.get(index);
        }
        int keyLength = key.length();
        for (int i = j; i < keyLength; ++i) {
            int previous = index;
            index = this.compact ? base + key.charAt(i) : index + base + key.charAt(i);
            if (index >= this.baseBuffer.limit()) {
                return -1;
            }
            base = this.baseBuffer.get(index);
            if (base == 0) {
                return -1;
            }
            if (this.checkBuffer.get(index) != previous) {
                return -1;
            }
            if (base < 100000000) continue;
            return this.matchTail(base, index, key.substring(i + 1));
        }
        int endIndex = this.compact ? base + 1 : index + base + 1;
        return this.checkBuffer.get(endIndex) == index ? index : 0;
    }

    private int matchTail(int base, int index, String key) {
        int positionInTailArr = base - 100000000;
        int keyLength = key.length();
        for (int i = 0; i < keyLength; ++i) {
            if (key.charAt(i) == this.tailBuffer.get(positionInTailArr + i)) continue;
            return -1;
        }
        return this.tailBuffer.get(positionInTailArr + keyLength) == '\u0001' ? index : 0;
    }

    private int findBase(int index, List<Trie.Node> nodes) {
        boolean collision;
        int base = this.baseBuffer.get(index);
        if (base < 0) {
            return base;
        }
        block0: do {
            collision = false;
            for (Trie.Node node : nodes) {
                int nextIndex = index + base + node.getKey();
                this.maxBaseCheckIndex = Math.max(this.maxBaseCheckIndex, nextIndex);
                if (this.baseBuffer.capacity() <= nextIndex) {
                    this.extendBuffers(nextIndex);
                }
                if (this.baseBuffer.get(nextIndex) == 0) continue;
                ++base;
                collision = true;
                continue block0;
            }
        } while (collision);
        for (Trie.Node node : nodes) {
            this.baseBuffer.put(index + base + node.getKey(), node.getKey() == '\u0001' ? -1 : 1);
        }
        return base;
    }

    private void extendBuffers(int nextIndex) {
        int newLength = nextIndex + (int)((float)this.baseBuffer.capacity() * BUFFER_GROWTH_PERCENTAGE);
        ProgressLog.println("Buffers extended to " + this.baseBuffer.capacity() + " entries");
        IntBuffer newBaseBuffer = IntBuffer.allocate(newLength);
        this.baseBuffer.rewind();
        newBaseBuffer.put(this.baseBuffer);
        this.baseBuffer = newBaseBuffer;
        IntBuffer newCheckBuffer = IntBuffer.allocate(newLength);
        this.checkBuffer.rewind();
        newCheckBuffer.put(this.checkBuffer);
        this.checkBuffer = newCheckBuffer;
    }

    private void addToTail(Trie.Node node) {
        while (true) {
            if (this.tailBuffer.capacity() < this.tailIndex - 100000000 + 1) {
                CharBuffer newTailBuffer = CharBuffer.allocate(this.tailBuffer.capacity() + (int)((float)this.tailBuffer.capacity() * BUFFER_GROWTH_PERCENTAGE));
                this.tailBuffer.rewind();
                newTailBuffer.put(this.tailBuffer);
                this.tailBuffer = newTailBuffer;
            }
            this.tailBuffer.put(this.tailIndex++ - 100000000, node.getKey());
            if (node.getChildren().isEmpty()) break;
            node = node.getChildren().get(0);
        }
    }

    public IntBuffer getBaseBuffer() {
        return this.baseBuffer;
    }

    public IntBuffer getCheckBuffer() {
        return this.checkBuffer;
    }

    public CharBuffer getTailBuffer() {
        return this.tailBuffer;
    }
}

