/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.osmand.shared.io.NativeFile;
import net.osmand.shared.util.KAlgorithms;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\u0018\u0000 32\u00020\u0001:\u00013B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0000\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0003J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0007J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0000J\u0006\u0010\u0017\u001a\u00020\u0011J\u0006\u0010\u0018\u001a\u00020\u0011J\u0006\u0010\u0019\u001a\u00020\u0011J\u0006\u0010\u001a\u001a\u00020\u0011J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u0006\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0003J\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010'J\u0006\u0010(\u001a\u00020\u0011J\b\u0010)\u001a\u00020*H\u0016J\u0013\u0010+\u001a\u00020\u00112\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010-\u001a\u00020\u0003H\u0016J\u0006\u0010.\u001a\u00020\u001cJ\u000e\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0000J\u000e\u0010/\u001a\u00020\u00112\u0006\u00101\u001a\u00020\u0003J\b\u00102\u001a\u0004\u0018\u00010\u0003R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lnet/osmand/shared/io/KFile;", "", "filePath", "", "<init>", "(Ljava/lang/String;)V", "path", "Lokio/Path;", "(Lokio/Path;)V", "file", "fileName", "(Lnet/osmand/shared/io/KFile;Ljava/lang/String;)V", "getPath", "()Lokio/Path;", "nativeFile", "Lnet/osmand/shared/io/NativeFile;", "directory", "", "Ljava/lang/Boolean;", "absolutePath", "name", "parent", "getParentFile", "isPathEmpty", "exists", "isAbsolute", "isDirectory", "lastModified", "", "source", "Lokio/Source;", "sink", "Lokio/Sink;", "createDirectories", "", "readText", "writeText", "text", "listFiles", "", "delete", "hashCode", "", "equals", "other", "toString", "length", "renameTo", "toFile", "toFilePath", "getFileNameWithoutExtension", "Companion", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nKFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KFile.kt\nnet/osmand/shared/io/KFile\n+ 2 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,148:1\n66#2:149\n52#2,22:150\n66#2:172\n52#2,22:173\n*S KotlinDebug\n*F\n+ 1 KFile.kt\nnet/osmand/shared/io/KFile\n*L\n87#1:149\n87#1:150,22\n94#1:172\n94#1:173,22\n*E\n"})
public final class KFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    @NotNull
    private NativeFile nativeFile;
    @Nullable
    private Boolean directory;
    @Nullable
    private String absolutePath;

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    public KFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.path = Path.Companion.get$default((Path.Companion)Path.Companion, (String)filePath, (boolean)false, (int)1, null);
        this.nativeFile = new NativeFile(this);
    }

    public KFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.nativeFile = new NativeFile(this);
    }

    public KFile(@NotNull KFile file, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.path = Path.resolve$default((Path)file.path, (String)fileName, (boolean)false, (int)2, null);
        this.nativeFile = new NativeFile(this);
    }

    @NotNull
    public final String name() {
        return this.path.name();
    }

    @Nullable
    public final Path parent() {
        return this.path.parent();
    }

    @Nullable
    public final KFile getParentFile() {
        Path parent = this.path.parent();
        return parent != null ? new KFile(parent) : null;
    }

    public final boolean isPathEmpty() {
        String path = this.path();
        return ((CharSequence)path).length() == 0 || Intrinsics.areEqual((Object)path, (Object)".") || Intrinsics.areEqual((Object)path, (Object)Path.DIRECTORY_SEPARATOR);
    }

    public final boolean exists() {
        return this.nativeFile.exists();
    }

    public final boolean isAbsolute() {
        return this.path.isAbsolute();
    }

    public final boolean isDirectory() {
        Boolean directory = this.directory;
        if (directory == null) {
            this.directory = directory = Boolean.valueOf(this.nativeFile.isDirectory());
        }
        return directory;
    }

    public final long lastModified() {
        return this.nativeFile.lastModified();
    }

    @NotNull
    public final String path() {
        return this.path.toString();
    }

    @NotNull
    public final String absolutePath() {
        String absolutePath = this.absolutePath;
        if (absolutePath == null) {
            this.absolutePath = absolutePath = this.nativeFile.absolutePath();
        }
        return absolutePath;
    }

    @NotNull
    public final Source source() throws IOException {
        return FileSystem.SYSTEM.source(this.path);
    }

    @NotNull
    public final Sink sink() throws IOException {
        return FileSystem.SYSTEM.sink(this.path);
    }

    public final void createDirectories() throws IOException {
        FileSystem.SYSTEM.createDirectories(this.path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final String readText() throws IOException {
        String string;
        Throwable thrown$iv;
        block14: {
            Closeable $this$use$iv = (Closeable)Okio.buffer((Source)FileSystem.SYSTEM.source(this.path));
            boolean $i$f$use = false;
            thrown$iv = null;
            try {
                BufferedSource it = (BufferedSource)$this$use$iv;
                boolean bl = false;
                string = it.readUtf8();
            }
            catch (Throwable t$iv) {
                try {
                    thrown$iv = t$iv;
                    string = null;
                    break block14;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block15: {
                        try {
                            Closeable closeable = $this$use$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv2) {
                            if (thrown$iv == null) {
                                thrown$iv = t$iv2;
                                break block15;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv) {
                thrown$iv = t$iv;
            }
        }
        String result$iv = string;
        Throwable throwable = thrown$iv;
        if (throwable == null) return result$iv;
        throw throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void writeText(@NotNull String text) throws IOException {
        BufferedSink bufferedSink;
        Throwable thrown$iv;
        block14: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Closeable $this$use$iv = (Closeable)Okio.buffer((Sink)FileSystem.SYSTEM.sink(this.path));
            boolean $i$f$use = false;
            thrown$iv = null;
            try {
                BufferedSink it = (BufferedSink)$this$use$iv;
                boolean bl = false;
                bufferedSink = it.writeUtf8(text);
            }
            catch (Throwable t$iv) {
                try {
                    thrown$iv = t$iv;
                    bufferedSink = null;
                    break block14;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block15: {
                        try {
                            Closeable closeable = $this$use$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv2) {
                            if (thrown$iv == null) {
                                thrown$iv = t$iv2;
                                break block15;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv) {
                thrown$iv = t$iv;
            }
        }
        BufferedSink result$iv = bufferedSink;
        Throwable throwable = thrown$iv;
        if (throwable == null) return;
        throw throwable;
    }

    @Nullable
    public final List<KFile> listFiles() {
        return this.nativeFile.listFiles();
    }

    public final boolean delete() {
        if (!this.exists()) {
            return false;
        }
        FileSystem.SYSTEM.delete(this.path, false);
        return !this.exists();
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KFile)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.path, (Object)((KFile)other).path);
    }

    @NotNull
    public String toString() {
        return this.path.toString();
    }

    public final long length() {
        return this.nativeFile.length();
    }

    public final boolean renameTo(@NotNull KFile toFile) {
        Intrinsics.checkNotNullParameter((Object)toFile, (String)"toFile");
        return this.nativeFile.renameTo(toFile);
    }

    public final boolean renameTo(@NotNull String toFilePath) {
        Intrinsics.checkNotNullParameter((Object)toFilePath, (String)"toFilePath");
        return this.nativeFile.renameTo(toFilePath);
    }

    @Nullable
    public final String getFileNameWithoutExtension() {
        return Companion.getFileNameWithoutExtension(this.name());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lnet/osmand/shared/io/KFile$Companion;", "", "<init>", "()V", "getFileNameWithoutExtension", "", "name", "removeAllFiles", "", "file", "Lnet/osmand/shared/io/KFile;", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getFileNameWithoutExtension(@Nullable String name) {
            String string = name;
            return string != null ? StringsKt.substringBeforeLast$default((String)string, (String)".", null, (int)2, null) : null;
        }

        public final boolean removeAllFiles(@NotNull KFile file) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (file.isDirectory()) {
                List<KFile> files = file.listFiles();
                if (!KAlgorithms.INSTANCE.isEmpty((Collection)files)) {
                    List<KFile> list = files;
                    Intrinsics.checkNotNull(list);
                    for (KFile f : list) {
                        this.removeAllFiles(f);
                    }
                }
                bl = file.delete();
            } else {
                bl = file.delete();
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

