/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.helper;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.osmand.shared.gpx.GpxFile;
import net.osmand.shared.gpx.GpxUtilities;
import net.osmand.shared.gpx.helper.ImportGpx;
import net.osmand.shared.io.SourceInputStream;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lnet/osmand/shared/gpx/helper/ImportHelper;", "", "<init>", "()V", "loadGPXFileFromArchive", "Lkotlin/Pair;", "Lnet/osmand/shared/gpx/GpxFile;", "", "source", "Lokio/Source;", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nImportHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportHelper.kt\nnet/osmand/shared/gpx/helper/ImportHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,32:1\n1#2:33\n*E\n"})
public final class ImportHelper {
    @NotNull
    public static final ImportHelper INSTANCE = new ImportHelper();

    private ImportHelper() {
    }

    @NotNull
    public final Pair<GpxFile, Long> loadGPXFileFromArchive(@NotNull Source source) throws IOException {
        block2: {
            String string;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            ZipInputStream stream = new ZipInputStream(new SourceInputStream(source));
            ZipEntry entry = null;
            do {
                ZipEntry zipEntry;
                ZipEntry it = zipEntry = stream.getNextEntry();
                boolean bl = false;
                entry = it;
                if (zipEntry == null) break block2;
                String string2 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (StringsKt.endsWith$default((String)string2, (String)".gpx", (boolean)false, (int)2, null)) {
                    long fileSize = entry.getSize();
                    return new Pair((Object)GpxUtilities.INSTANCE.loadGpxFile(Okio.source((InputStream)stream)), (Object)fileSize);
                }
                string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            } while (!StringsKt.endsWith$default((String)string, (String)".kml", (boolean)false, (int)2, null));
            return ImportGpx.INSTANCE.loadGPXFileFromKml(Okio.source((InputStream)stream));
        }
        return ImportGpx.INSTANCE.errorImport("Archive doesn't have GPX/KLM files");
    }
}

