/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.xhtml;

import org.xwiki.rendering.wikimodel.IWikiPrinter;
import org.xwiki.rendering.wikimodel.WikiPageUtil;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.xhtml.PrintInlineListener;

public class PrintListener
extends PrintInlineListener {
    public PrintListener(IWikiPrinter printer) {
        super(printer);
    }

    public PrintListener(IWikiPrinter printer, boolean supportImage, boolean supportDownload) {
        super(printer, supportImage, supportDownload);
    }

    @Override
    public void beginDefinitionDescription() {
        this.print("  <dd>");
    }

    @Override
    public void beginDefinitionList(WikiParameters parameters) {
        this.println("<dl>");
    }

    @Override
    public void beginDefinitionTerm() {
        this.print("  <dt>");
    }

    @Override
    public void beginDocument(WikiParameters params) {
        this.println("<div class='wikimodel-document'" + params + ">");
    }

    @Override
    public void beginHeader(int headerLevel, WikiParameters params) {
        this.print("<h" + headerLevel + params + ">");
    }

    @Override
    public void beginInfoBlock(String infoType, WikiParameters params) {
        this.print("<table" + params + "><tr><th>" + infoType + "</th><td>");
    }

    @Override
    public void beginList(WikiParameters parameters, boolean ordered) {
        if (ordered) {
            this.println("<ol" + parameters + ">");
        } else {
            this.println("<ul" + parameters + ">");
        }
    }

    @Override
    public void beginListItem() {
        this.print("  <li>");
    }

    @Override
    public void beginParagraph(WikiParameters params) {
        this.print("<p" + params + ">");
    }

    @Override
    public void beginPropertyBlock(String propertyUri, boolean doc) {
        this.print("<div class='wikimodel-property' url='" + WikiPageUtil.escapeXmlAttribute(propertyUri) + "'>");
        if (doc) {
            this.println("");
        }
    }

    @Override
    public void beginQuotation(WikiParameters params) {
        this.println("<blockquote" + params + ">");
    }

    @Override
    public void beginQuotationLine() {
    }

    @Override
    public void beginTable(WikiParameters params) {
        this.println("<table" + params + "><tbody>");
    }

    @Override
    public void beginTableCell(boolean tableHead, WikiParameters params) {
        String str = tableHead ? "<th" : "<td";
        this.print(str + params + ">");
    }

    @Override
    public void beginTableRow(WikiParameters params) {
        this.print("  <tr" + params + ">");
    }

    @Override
    public void endDefinitionDescription() {
        this.println("</dd>");
    }

    @Override
    public void endDefinitionList(WikiParameters parameters) {
        this.println("</dl>");
    }

    @Override
    public void endDefinitionTerm() {
        this.println("</dt>");
    }

    @Override
    public void endDocument(WikiParameters params) {
        this.println("</div>");
    }

    @Override
    public void endHeader(int headerLevel, WikiParameters params) {
        this.println("</h" + headerLevel + ">");
    }

    @Override
    public void endInfoBlock(String infoType, WikiParameters params) {
        this.println("</td></tr></table>");
    }

    @Override
    public void endList(WikiParameters parameters, boolean ordered) {
        if (ordered) {
            this.println("</ol>");
        } else {
            this.println("</ul>");
        }
    }

    @Override
    public void endListItem() {
        this.println("</li>");
    }

    @Override
    public void endParagraph(WikiParameters params) {
        this.println("</p>");
    }

    @Override
    public void endPropertyBlock(String propertyUri, boolean doc) {
        this.println("</div>");
    }

    @Override
    public void endQuotation(WikiParameters params) {
        this.println("</blockquote>");
    }

    @Override
    public void endQuotationLine() {
        this.println("");
    }

    @Override
    public void endTable(WikiParameters params) {
        this.println("</tbody></table>");
    }

    @Override
    public void endTableCell(boolean tableHead, WikiParameters params) {
        String str = tableHead ? "</th>" : "</td>";
        this.print(str);
    }

    @Override
    public void endTableRow(WikiParameters params) {
        this.println("</tr>");
    }

    @Override
    public void onEmptyLines(int count) {
        if (count > 1) {
            this.println("<div style='height:" + count + "em;'></div>");
        }
    }

    @Override
    public void onExtensionBlock(String extensionName, WikiParameters params) {
        this.println("<div class='wikimodel-extension' extension='" + extensionName + "'" + params + "/>");
    }

    @Override
    public void onHorizontalLine(WikiParameters params) {
        this.println("<hr" + params + " />");
    }

    @Override
    public void onMacroBlock(String macroName, WikiParameters params, String content) {
        if (content == null) {
            this.println("<pre class='wikimodel-macro' macroName='" + macroName + "'" + params + "/>");
        } else {
            this.println("<pre class='wikimodel-macro' macroName='" + macroName + "'" + params + "><![CDATA[" + content + "]]></pre>");
        }
    }

    @Override
    public void onMacroInline(String macroName, WikiParameters params, String content) {
        if (content == null) {
            this.print("<span class='wikimodel-macro' macroName='" + macroName + "'" + params + "/>");
        } else {
            this.print("<span class='wikimodel-macro' macroName='" + macroName + "'" + params + "><![CDATA[" + content + "]]></span>");
        }
    }

    @Override
    public void onTableCaption(String str) {
    }

    @Override
    public void onVerbatimBlock(String str, WikiParameters params) {
        this.println("<pre" + params + ">" + WikiPageUtil.escapeXmlString(str) + "</pre>");
    }
}

