/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki.wikidata;

import java.time.Instant;
import java.util.Date;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class ExtractorHandler
extends DefaultHandler {
    private long startTime;
    private Locator locator;
    private boolean start;
    private boolean article;
    private String articleId;
    private int endHeaderLine;
    private int firstArticleLine;
    private int endArticleLine;
    private int articleCount;
    private final String title;
    private final StringBuilder currentValue = new StringBuilder();

    public ExtractorHandler(String title, int articleCount) {
        this.title = title;
        this.articleCount = articleCount;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() {
        System.out.println("Start Document parsing " + String.valueOf(Date.from(Instant.now())));
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void endDocument() {
        System.out.println("End Document. Parsing time: " + (System.currentTimeMillis() - this.startTime) / 1000L);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.currentValue.setLength(0);
        if (qName.equals("page") && !this.start) {
            this.start = true;
            this.endHeaderLine = this.locator.getLineNumber();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equalsIgnoreCase("title") && this.currentValue.toString().equals(this.title)) {
            this.firstArticleLine = this.locator.getLineNumber() - 1;
            System.out.printf("Found title %s on the line %d\n", this.currentValue, this.locator.getLineNumber());
            this.article = true;
        }
        if (qName.equals("page") && this.article) {
            --this.articleCount;
            if (this.articleCount == 0) {
                this.article = false;
                this.endArticleLine = this.locator.getLineNumber();
                System.out.printf("Parsing time: %d%n", (System.currentTimeMillis() - this.startTime) / 1000L);
                throw new StopParsingException();
            }
        }
        if (qName.equalsIgnoreCase("id") && this.article && this.articleId == null) {
            this.articleId = this.currentValue.toString();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentValue.append(ch, start, length);
    }

    public int getEndHeaderLine() {
        return this.endHeaderLine;
    }

    public int getFirstArticleLine() {
        return this.firstArticleLine;
    }

    public int getEndArticleLine() {
        return this.endArticleLine;
    }

    public String getArticleId() {
        return this.articleId;
    }

    static class StopParsingException
    extends RuntimeException {
        StopParsingException() {
        }
    }
}

