/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.render;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.osmand.PlatformUtil;
import net.osmand.render.RenderingRuleProperty;
import net.osmand.render.RenderingRuleSearchRequest;
import net.osmand.render.RenderingRulesStorage;
import net.osmand.util.Algorithms;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.xmlpull.v1.XmlPullParser;

public class SvgMapLegendGenerator {
    public static final String LEGEND_COMPONENT_MAP_JS = "/web/main/src/components/docs/legend/componentMap.js";
    public static final String LEGEND_LEGEND_SECTIONS_JS = "/web/main/src/components/docs/legend/legendSections.js";
    public static final String WEB_DESTINATION_SPRITES_DIR = "/web/main/static/img/map-legend/";
    public static final String RES_SOURCES_SPRITES_DIR = "/resources/rendering_styles/map-legend/sprites";
    public static final String LEGEND_ITEM_PREFIX = "LegendItemAutogenerated";
    static int defaultZoomLevel = 19;
    static int canvasWidth = 300;
    static int canvasHeight = 40;
    static int defaultShieldSize = 40;
    static int defaultIconSize = 24;

    public static void main(String[] args) throws Exception {
        SvgMapLegendGenerator.generate(System.getenv("repo_dir"), "default");
    }

    private static String getStylePath(String styleName, String repositoriesPath) {
        String[] allStylesNames = new String[]{"default", "desert", "LightRS", "mapnik", "nautical", "offroad", "osm-carto", "regions", "skimap", "snowmobile", "standalone-template", "Topo-map-assimilation", "topo", "Touring-view_(more-contrast-and-details)", "UniRS", "weather.addon"};
        if (Algorithms.isEmpty((CharSequence)styleName) || !Arrays.asList(allStylesNames).contains(styleName)) {
            styleName = "default";
        }
        return repositoriesPath + "/resources/rendering_styles/" + styleName + ".render.xml";
    }

    public static void generate(String repositoriesPath, String rendererStyle) throws Exception {
        System.out.println("\n\n\n");
        System.out.println("OK: SvgMapLegendGenerator - Start script");
        try {
            if (Algorithms.isEmpty((CharSequence)repositoriesPath)) {
                throw new Exception("ERROR: SvgMapLegendGenerator - 'repo_dir' env parameter is empty");
            }
            String configPath = repositoriesPath + "/resources/rendering_styles/map-legend/" + rendererStyle + ".legend.xml";
            ArrayList<GroupDTO> configGroups = SvgMapLegendGenerator.parseXmlConfig(configPath);
            if (Algorithms.isEmpty(configGroups)) {
                throw new Exception("ERROR: SvgMapLegendGenerator - configGroups is empty");
            }
            System.out.println("OK: SvgMapLegendGenerator - Config file reading DONE");
            String path = SvgMapLegendGenerator.getStylePath(rendererStyle, repositoriesPath);
            RenderingRulesStorage storage = RenderingRulesStorage.getTestStorageForStyle((String)path);
            for (GroupDTO group : configGroups) {
                if (group.spriteSheet) continue;
                for (IconDTO icon : group.icons) {
                    Map<String, String> dayStyle = SvgMapLegendGenerator.getAmenityIconStyle(icon.tag, icon.value, icon.tag2, icon.value2, false, icon.zoom, storage);
                    Map<String, String> nightStyle = SvgMapLegendGenerator.getAmenityIconStyle(icon.tag, icon.value, icon.tag2, icon.value2, false, icon.zoom, storage);
                    if (!(Algorithms.isEmpty(dayStyle) || Algorithms.isEmpty(dayStyle) || Algorithms.isEmpty((CharSequence)dayStyle.get("iconName")))) {
                        icon.iconName = dayStyle.get("iconName");
                        icon.shieldNameDay = dayStyle.get("shieldName");
                        icon.shieldNameNight = nightStyle.get("shieldName");
                        icon.iconTargetFileName = icon.tag + "_" + icon.value;
                        if (!Algorithms.isEmpty((CharSequence)icon.tag2)) {
                            icon.iconTargetFileName = icon.iconTargetFileName + "_" + icon.tag2 + "_" + icon.value2;
                        }
                        icon.iconTargetFileName = icon.iconTargetFileName.replace(':', '_');
                        icon.styleIconSize = Float.parseFloat(dayStyle.get("iconSize"));
                        continue;
                    }
                    throw new Exception(String.format("ERROR: SvgMapLegendGenerator - style collecting invalid result for  '%s':'%s'  '%s':'%s'", icon.tag, icon.value, icon.tag2, icon.value2));
                }
            }
            System.out.println("OK: SvgMapLegendGenerator - styles collecting DONE");
            for (GroupDTO group : configGroups) {
                if (group.spriteSheet) {
                    SvgMapLegendGenerator.copySpritesToWebFolder(repositoriesPath, group);
                    continue;
                }
                String resultIconsFolderPath = repositoriesPath + "/web/main/static/img/legend/osmand/";
                String resultFolderPath = resultIconsFolderPath + group.folderName;
                try {
                    Files.createDirectories(Paths.get(resultFolderPath, new String[0]), new FileAttribute[0]);
                    FileUtils.cleanDirectory((File)new File(resultFolderPath));
                }
                catch (Exception e) {
                    throw new Exception("ERROR: SvgMapLegendGenerator - failed to create or clean directory: " + resultFolderPath, e);
                }
                for (IconDTO icon : group.icons) {
                    try {
                        String contentDay = SvgGenerator.generate(icon.iconName, icon.iconSize, icon.shieldNameDay, icon.shieldSize, null, 0.0f);
                        SvgGenerator.createSvgFile(group, icon, contentDay, true, resultIconsFolderPath);
                        String contentNight = SvgGenerator.generate(icon.iconName, icon.iconSize, icon.shieldNameNight, icon.shieldSize, null, 0.0f);
                        SvgGenerator.createSvgFile(group, icon, contentNight, false, resultIconsFolderPath);
                    }
                    catch (Exception e) {
                        throw new Exception(String.format("ERROR: SvgMapLegendGenerator - failed generate icon content for '%s' - '%s' ", group.groupName, icon.name), e);
                    }
                }
            }
            System.out.println("OK: SvgMapLegendGenerator - svg files saving DONE");
            ReactComponentsGenerator.generate(configGroups);
            System.out.println("SUCCESS: SvgMapLegendGenerator - script finished successful!");
        }
        catch (Exception e) {
            throw new Exception("FATAL ERROR: SvgMapLegendGenerator - script failed with error:", e);
        }
    }

    private static void copySpritesToWebFolder(String repositoriesPath, GroupDTO group) throws Exception {
        String fileNameDay = "osmand-" + group.folderName + "-day.svg";
        String fileNameNight = "osmand-" + group.folderName + "-night.svg";
        String destDir = repositoriesPath + WEB_DESTINATION_SPRITES_DIR;
        File destSprite = new File(destDir, fileNameDay);
        String sourceDir = repositoriesPath + RES_SOURCES_SPRITES_DIR;
        File sourceSprite = new File(sourceDir, fileNameDay);
        try {
            FileUtils.copyFile((File)sourceSprite, (File)destSprite);
            destSprite = new File(destDir, fileNameNight);
            File sourceSpriteNight = new File(sourceDir, fileNameNight);
            if (sourceSpriteNight.exists()) {
                sourceSprite = sourceSpriteNight;
            }
            FileUtils.copyFile((File)sourceSprite, (File)destSprite);
        }
        catch (IOException e) {
            throw new Exception("ERROR: SvgMapLegendGenerator - file not found: " + String.valueOf(sourceSprite), e);
        }
    }

    public static Map<String, String> getAmenityIconStyle(String tag, String value, String tag2, String value2, boolean nightMode, int zoom, RenderingRulesStorage storage) {
        RenderingRuleSearchRequest searchRequest = new RenderingRuleSearchRequest(storage);
        searchRequest.setStringFilter(storage.PROPS.R_TAG, tag);
        searchRequest.setStringFilter(storage.PROPS.R_VALUE, value);
        if (!Algorithms.isEmpty((CharSequence)tag2) && !Algorithms.isEmpty((CharSequence)value2)) {
            searchRequest.setStringFilter(storage.PROPS.R_ADDITIONAL, tag2 + "=" + value2);
        }
        searchRequest.setBooleanFilter(storage.PROPS.R_NIGHT_MODE, nightMode);
        searchRequest.setIntFilter(storage.PROPS.R_MINZOOM, zoom);
        searchRequest.setIntFilter(storage.PROPS.R_MAXZOOM, zoom);
        for (RenderingRuleProperty customProp : storage.PROPS.getCustomRules()) {
            if (customProp.isBoolean()) {
                searchRequest.setBooleanFilter(customProp, false);
                continue;
            }
            searchRequest.setStringFilter(customProp, "");
        }
        searchRequest.search(1);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("iconName", searchRequest.getStringPropertyValue(searchRequest.ALL.R_ICON));
        result.put("shieldName", searchRequest.getStringPropertyValue(searchRequest.ALL.R_SHIELD));
        result.put("iconSize", String.valueOf(searchRequest.getFloatPropertyValue(searchRequest.ALL.R_ICON_VISIBLE_SIZE, -1.0f)));
        return result;
    }

    private static ArrayList<GroupDTO> parseXmlConfig(String filePath) throws Exception {
        try {
            int next;
            File file = new File(filePath);
            XmlPullParser parser = PlatformUtil.newXMLPullParser();
            InputStream fis = new FileInputStream(file);
            if (file.getName().endsWith(".gz")) {
                fis = new GZIPInputStream(fis);
            }
            parser.setInput(fis, "UTF-8");
            ArrayList<GroupDTO> resultGroups = new ArrayList<GroupDTO>();
            GroupDTO tempGroup = new GroupDTO();
            IconDTO tempIcon = new IconDTO();
            while ((next = parser.next()) != 1) {
                String name;
                if (next == 3) {
                    name = parser.getName();
                    if (name.equals("icon")) {
                        tempGroup.icons.add(tempIcon);
                        tempIcon = new IconDTO();
                        continue;
                    }
                    if (!name.equals("group")) continue;
                    resultGroups.add(tempGroup);
                    tempGroup = new GroupDTO();
                    continue;
                }
                if (next != 2) continue;
                name = parser.getName();
                if (name.equals("group")) {
                    tempGroup.groupName = parser.getAttributeValue("", "name");
                    String foldername = parser.getAttributeValue("", "foldername");
                    if (foldername == null && (foldername = parser.getAttributeValue("", "sprite")) != null) {
                        tempGroup.spriteSheet = true;
                    }
                    tempGroup.folderName = foldername;
                    if (!Algorithms.isEmpty((CharSequence)tempGroup.groupName) && !Algorithms.isEmpty((CharSequence)tempGroup.folderName)) continue;
                    throw new Exception("ERROR: parseXmlConfig() - group fields invalid at map-legend.xml line " + parser.getLineNumber());
                }
                if (!name.equals("icon")) continue;
                tempIcon.name = parser.getAttributeValue("", "name");
                if (tempGroup.spriteSheet) {
                    tempIcon.id = parser.getAttributeValue("", "id");
                    if (!Algorithms.isEmpty((CharSequence)tempIcon.name) && !Algorithms.isEmpty((CharSequence)tempIcon.id)) continue;
                    throw new Exception("ERROR: parseXmlConfig() - icon fields invalid at map-legend.xml line " + parser.getLineNumber());
                }
                tempIcon.tag = parser.getAttributeValue("", "tag");
                tempIcon.value = parser.getAttributeValue("", "value");
                tempIcon.tag2 = parser.getAttributeValue("", "tag2");
                tempIcon.value2 = parser.getAttributeValue("", "value2");
                String numberString = parser.getAttributeValue("", "icon_size");
                if (!Algorithms.isEmpty((CharSequence)numberString)) {
                    tempIcon.iconSize = Integer.parseInt(numberString);
                }
                if (!Algorithms.isEmpty((CharSequence)(numberString = parser.getAttributeValue("", "shield_size")))) {
                    tempIcon.shieldSize = Integer.parseInt(numberString);
                }
                if (!Algorithms.isEmpty((CharSequence)(numberString = parser.getAttributeValue("", "zoom")))) {
                    tempIcon.zoom = Integer.parseInt(numberString);
                }
                if (!Algorithms.isEmpty((CharSequence)tempIcon.name) && !Algorithms.isEmpty((CharSequence)tempIcon.tag) && !Algorithms.isEmpty((CharSequence)tempIcon.value)) continue;
                throw new Exception("ERROR: parseXmlConfig() - icon fields invalid at map-legend.xml line " + parser.getLineNumber());
            }
            return resultGroups;
        }
        catch (Exception e) {
            throw new Exception("ERROR: parseConfig() failed to parse file " + filePath, e);
        }
    }

    private static class GroupDTO {
        String groupName = "";
        String folderName = "";
        boolean spriteSheet = false;
        ArrayList<IconDTO> icons = new ArrayList();

        private GroupDTO() {
        }
    }

    private static class IconDTO {
        public String iconTargetFileName;
        String name = null;
        String id = null;
        String tag = null;
        String value = null;
        String tag2 = null;
        String value2 = null;
        int iconSize = defaultIconSize;
        int shieldSize = defaultShieldSize;
        int zoom = defaultZoomLevel;
        String iconName = null;
        String shieldNameNight = null;
        String shieldNameDay = null;
        float styleIconSize = -1.0f;

        private IconDTO() {
        }
    }

    private static class SvgGenerator {
        private SvgGenerator() {
        }

        public static String generate(String iconName, int iconSize, String shieldName, int shieldSize, String backgroundColor, float backgroundOpacity) throws Exception {
            String additionalIconHeaderTags = SvgGenerator.getSvgIconAdditionalHeaderTags(iconName);
            Object content = String.format("<svg width=\"%d\" height=\"%d\" viewBox=\"0 0 %d %d\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" %s>\n", canvasWidth, canvasHeight, canvasWidth, canvasHeight, additionalIconHeaderTags);
            if (!Algorithms.isEmpty((CharSequence)backgroundColor)) {
                content = (String)content + SvgGenerator.geBackgroundRect(backgroundColor, backgroundOpacity);
            }
            if (!Algorithms.isEmpty((CharSequence)shieldName)) {
                content = (String)content + SvgGenerator.getShield(shieldName, shieldSize);
            }
            if (!Algorithms.isEmpty((CharSequence)iconName)) {
                content = (String)content + SvgGenerator.getIcon(iconName, iconSize);
            }
            content = (String)content + "</svg>";
            return content;
        }

        private static String getIconPath(String iconName) throws Exception {
            String basePath = System.getenv("repo_dir") + "/resources/rendering_styles/style-icons/map-icons-svg/";
            String filePath = basePath + "mx_" + iconName + ".svg";
            File file = new File(filePath);
            if (file.exists()) {
                return filePath;
            }
            String coloredIconFilePath = basePath + "c_mx_" + iconName + ".svg";
            file = new File(coloredIconFilePath);
            if (file.exists()) {
                return coloredIconFilePath;
            }
            throw new Exception("File not found " + filePath);
        }

        private static String geBackgroundRect(String color, float opacity) {
            return String.format("<rect width=\"%d\" height=\"%d\" fill=\"%s\" fill-opacity=\"%f\"/>\n", canvasWidth, canvasHeight, color, Float.valueOf(opacity));
        }

        private static String getShield(String shieldName, int shieldSize) throws Exception {
            String shieldsFolder = System.getenv("repo_dir") + "/resources/icons/svg/shields/";
            String filePath = shieldsFolder + "h_" + shieldName + ".svg";
            SvgDTO shieldSvg = SvgGenerator.parseSvg(filePath);
            return SvgGenerator.moveToCenterAndResize(shieldSvg, shieldSize);
        }

        private static String getIcon(String iconName, int iconSize) throws Exception {
            String filePath = SvgGenerator.getIconPath(iconName);
            SvgDTO iconSvg = SvgGenerator.parseSvg(filePath);
            iconSvg.content = iconSvg.content.replace("clip", "clip100");
            return SvgGenerator.moveToCenterAndResize(iconSvg, iconSize);
        }

        private static SvgDTO parseSvg(String filePath) throws Exception {
            try {
                int next;
                SvgDTO parsedSvg = new SvgDTO();
                File file = new File(filePath);
                XmlPullParser parser = PlatformUtil.newXMLPullParser();
                InputStream fis = new FileInputStream(file);
                if (file.getName().endsWith(".gz")) {
                    fis = new GZIPInputStream(fis);
                }
                parser.setInput(fis, "UTF-8");
                while ((next = parser.next()) != 1) {
                    String name;
                    if (next != 2 || !(name = parser.getName()).equals("svg")) continue;
                    parsedSvg.width = Double.parseDouble(parser.getAttributeValue("", "width"));
                    parsedSvg.height = Double.parseDouble(parser.getAttributeValue("", "height"));
                    String viewBoxStr = parser.getAttributeValue(null, "viewBox");
                    if (viewBoxStr == null) continue;
                    String[] parts = viewBoxStr.split(" ");
                    for (int i = 0; i < parts.length; ++i) {
                        parsedSvg.viewBox[i] = Double.parseDouble(parts[i]);
                    }
                }
                parsedSvg.content = SvgGenerator.getSvgInnerContent(filePath);
                return parsedSvg;
            }
            catch (Exception e) {
                throw new Exception("ERROR: parseSvg() failed to parse file " + filePath, e);
            }
        }

        private static String getSvgIconAdditionalHeaderTags(String iconName) throws Exception {
            String filePath = SvgGenerator.getIconPath(iconName);
            try {
                String firstTagStart = "<svg";
                String firstTagEnd = ">";
                String svgHeaderContent = Files.readString(Path.of(filePath, new String[0]));
                int trimIndexStart = svgHeaderContent.indexOf(firstTagStart) + firstTagStart.length();
                int trimIndexEnd = svgHeaderContent.indexOf(firstTagEnd, trimIndexStart);
                svgHeaderContent = svgHeaderContent.substring(trimIndexStart, trimIndexEnd);
                svgHeaderContent = svgHeaderContent.replace("\n", " ");
                svgHeaderContent = svgHeaderContent.replace("  ", " ");
                String[] parameters = svgHeaderContent.split("\" ");
                StringBuilder filteredAdditionalTagsBuilder = new StringBuilder();
                for (String parameter : parameters) {
                    if (parameter.contains("width=") || parameter.contains("height=") || parameter.contains("viewBox=") || parameter.contains("fill=") || parameter.contains("xmlns=")) continue;
                    filteredAdditionalTagsBuilder.append(parameter).append("\" ");
                }
                String filteredAdditionalTags = filteredAdditionalTagsBuilder.toString();
                if ((filteredAdditionalTags = filteredAdditionalTags.trim()).endsWith("\"\"")) {
                    filteredAdditionalTags = filteredAdditionalTags.substring(0, filteredAdditionalTags.length() - 1);
                }
                return filteredAdditionalTags;
            }
            catch (Exception e) {
                throw new Exception("ERROR: getSvgIconAdditionalHeaderTags() failed to process file " + filePath, e);
            }
        }

        private static String getSvgInnerContent(String filePath) throws Exception {
            try {
                String firstTagStart = "<svg";
                String firstTagEnd = ">";
                String secondTag = "</svg>";
                String svgInnerContent = Files.readString(Path.of(filePath, new String[0]));
                int trimIndex = svgInnerContent.indexOf(firstTagStart);
                trimIndex = svgInnerContent.indexOf(firstTagEnd, trimIndex);
                svgInnerContent = svgInnerContent.substring(trimIndex + firstTagEnd.length());
                return svgInnerContent.replace(secondTag, "");
            }
            catch (Exception e) {
                throw new Exception("ERROR: getSvgInnerContent() failed to process file " + filePath, e);
            }
        }

        private static String moveToCenterAndResize(SvgDTO svg, int newSize) {
            double originalMaxSize = Math.max(svg.viewBox[2], svg.viewBox[3]);
            double rescalingRatio = (double)newSize / originalMaxSize;
            double xOffset = (double)canvasWidth / 2.0 - (double)newSize / 2.0;
            double yOffset = (double)canvasHeight / 2.0 - (double)newSize / 2.0;
            Object resultContent = String.format(Locale.US, "%n<g transform=\"translate(%f, %f) scale(%f %f) \"> %n", xOffset, yOffset, rescalingRatio, rescalingRatio);
            resultContent = (String)resultContent + svg.content + "</g>%n%n";
            return resultContent;
        }

        public static void createSvgFile(GroupDTO group, IconDTO icon, String content, boolean isDay, String resultIconsFolderPath) throws Exception {
            String postfix = isDay ? "_day.svg" : "_night.svg";
            String path = resultIconsFolderPath + group.folderName + "/" + group.folderName + "_" + icon.iconTargetFileName + postfix;
            try {
                FileWriter writer = new FileWriter(path);
                writer.write(content);
                writer.close();
            }
            catch (Exception e) {
                throw new Exception("ERROR: createSvgFile() - failed to write file: " + path, e);
            }
        }

        private static class SvgDTO {
            String content = null;
            double width = -1.0;
            double height = -1.0;
            double[] viewBox = new double[4];

            private SvgDTO() {
            }
        }
    }

    private static class ReactComponentsGenerator {
        private ReactComponentsGenerator() {
        }

        public static void generate(ArrayList<GroupDTO> groups) throws Exception {
            LinkedHashMap<String, GroupDTO> components = new LinkedHashMap<String, GroupDTO>();
            for (GroupDTO group : groups) {
                StringBuilder content = group.spriteSheet ? ReactComponentsGenerator.createSpriteSheetGroupContent(group) : ReactComponentsGenerator.createGroupContent(group);
                Object componentName = group.folderName.replaceAll("[^a-zA-Z]", "");
                componentName = SvgMapLegendGenerator.LEGEND_ITEM_PREFIX + Algorithms.capitalizeFirstLetter((String)componentName);
                String path = System.getenv("repo_dir") + "/web/main/src/components/docs/autogenerated/" + (String)componentName + ".js";
                try {
                    FileWriter writer = new FileWriter(path);
                    writer.write(content.toString());
                    writer.close();
                    components.put((String)componentName, group);
                }
                catch (Exception e) {
                    throw new Exception("ERROR: ReactComponentsGenerator - file saving error for " + path, e);
                }
                ReactComponentsGenerator.createLegendAndComponentsFiles(components);
            }
        }

        private static void createLegendAndComponentsFiles(Map<String, GroupDTO> components) throws Exception {
            StringBuilder componentMapContent = new StringBuilder("import React from 'react';\n\n// This code was automatically generated\n// with Java-tools SvgMapLegendGenerator\n\nexport const componentMap = {\n");
            StringBuilder legendSectionsContent = new StringBuilder("/**\n * This code was automatically generated\n * with Java-tools SvgMapLegendGenerator\n *\n * Data for the CONTENT of legend sections.\n * Headings are defined directly in the MD file for Docusaurus's Table of Contents.\n */\n\nexport const legendContentData = {\n");
            HashSet<String> uniqueSectionID = new HashSet<String>();
            for (Map.Entry<String, GroupDTO> component : components.entrySet()) {
                String componentName = component.getKey();
                componentMapContent.append("  %s: React.lazy(() => import('@site/src/components/docs/autogenerated/%s.js')),\n".formatted(componentName, componentName));
                int height = 70 + (component.getValue().icons.size() + 2) / 3 * 111;
                String tmpSectionId = component.getValue().groupName.toLowerCase().replaceAll("[^a-zA-Z -]", "");
                tmpSectionId = tmpSectionId.replace(" ", "-");
                int suffix = 1;
                Object sectionId = tmpSectionId;
                while (!uniqueSectionID.add((String)sectionId)) {
                    sectionId = tmpSectionId + "-" + suffix;
                }
                legendSectionsContent.append("  '%s': { component: '%s', height: %d },\n".formatted(sectionId, componentName, height));
            }
            componentMapContent.append("};");
            legendSectionsContent.append("};");
            String componentMapPath = System.getenv("repo_dir") + SvgMapLegendGenerator.LEGEND_COMPONENT_MAP_JS;
            String legendSectionsPath = System.getenv("repo_dir") + SvgMapLegendGenerator.LEGEND_LEGEND_SECTIONS_JS;
            try {
                FileWriter writer = new FileWriter(componentMapPath);
                writer.write(componentMapContent.toString());
                writer.close();
                writer = new FileWriter(legendSectionsPath);
                writer.write(legendSectionsContent.toString());
                writer.close();
            }
            catch (Exception e) {
                throw new Exception("ERROR: createLegendAndComponentsFiles - file saving error ", e);
            }
        }

        @NotNull
        private static StringBuilder createSpriteSheetGroupContent(GroupDTO group) {
            String svgPath = group.folderName;
            StringBuilder content = new StringBuilder("import LegendItemWithProcessing from \"../LegendItemWithProcessing\";\n\n// This code was automatically generated\n// with Java-tools SvgMapLegendGenerator\n\nexport default function Render() {\n  return LegendItemWithProcessing({\n    svgPath: '/img/map-legend/osmand-%s',\n    svgParts: {\n".formatted(svgPath));
            for (IconDTO icon : group.icons) {
                content.append(String.format("      '%s' : '%s',\n", icon.id, icon.name));
            }
            content.append("    }});\n}\n");
            return content;
        }

        @NotNull
        private static StringBuilder createGroupContent(GroupDTO group) {
            StringBuilder content = new StringBuilder("import LegendItem from \"../LegendItem\";\n\n// This code was automatically generated\n// with Java-tools SvgMapLegendGenerator\n\nexport default function Render() {\n    return LegendItem({itemsMap: {\n");
            for (IconDTO icon : group.icons) {
                String iconName = group.folderName + "_" + icon.iconTargetFileName;
                content.append(String.format("        '%s' : '%s/%s',\n", icon.name, group.folderName, iconName));
            }
            content.append("    }});\n}\n");
            return content;
        }
    }
}

