/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.compile;

import com.atilika.kuromoji.buffer.BufferEntry;
import com.atilika.kuromoji.buffer.FeatureInfoMap;
import com.atilika.kuromoji.buffer.StringValueMapBuffer;
import com.atilika.kuromoji.buffer.WordIdMap;
import com.atilika.kuromoji.compile.Compiler;
import com.atilika.kuromoji.compile.TokenInfoBufferCompiler;
import com.atilika.kuromoji.compile.WordIdMapCompiler;
import com.atilika.kuromoji.dict.DictionaryEntryBase;
import com.atilika.kuromoji.dict.GenericDictionaryEntry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public abstract class TokenInfoDictionaryCompilerBase<T extends DictionaryEntryBase>
implements Compiler {
    protected List<BufferEntry> bufferEntries = new ArrayList<BufferEntry>();
    protected FeatureInfoMap posInfo = new FeatureInfoMap();
    protected FeatureInfoMap otherInfo = new FeatureInfoMap();
    protected WordIdMapCompiler wordIdsCompiler = new WordIdMapCompiler();
    protected List<GenericDictionaryEntry> dictionaryEntries = null;
    private String encoding;
    private List<String> surfaces = new ArrayList<String>();

    public TokenInfoDictionaryCompilerBase(String encoding) {
        this.encoding = encoding;
    }

    public void analyzeTokenInfo(InputStream input) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, this.encoding));
        while ((line = reader.readLine()) != null) {
            T entry = this.parse(line);
            GenericDictionaryEntry dictionaryEntry = this.generateGenericDictionaryEntry(entry);
            this.posInfo.mapFeatures(dictionaryEntry.getPosFeatures());
        }
    }

    public void readTokenInfo(InputStream input) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, this.encoding));
        int entryCount = this.posInfo.getEntryCount();
        while ((line = reader.readLine()) != null) {
            T entry = this.parse(line);
            GenericDictionaryEntry dictionaryEntry = this.generateGenericDictionaryEntry(entry);
            short leftId = dictionaryEntry.getLeftId();
            short rightId = dictionaryEntry.getRightId();
            short wordCost = dictionaryEntry.getWordCost();
            List<String> allPosFeatures = dictionaryEntry.getPosFeatures();
            List<Integer> posFeatureIds = this.posInfo.mapFeatures(allPosFeatures);
            List<String> featureList = dictionaryEntry.getFeatures();
            List<Integer> otherFeatureIds = this.otherInfo.mapFeatures(featureList);
            BufferEntry bufferEntry = new BufferEntry();
            bufferEntry.tokenInfo.add(leftId);
            bufferEntry.tokenInfo.add(rightId);
            bufferEntry.tokenInfo.add(wordCost);
            if (this.entriesFitInAByte(entryCount)) {
                List<Byte> posFeatureIdBytes = this.createPosFeatureIds(posFeatureIds);
                bufferEntry.posInfo.addAll(posFeatureIdBytes);
            } else {
                for (Integer posFeatureId : posFeatureIds) {
                    bufferEntry.tokenInfo.add(posFeatureId.shortValue());
                }
            }
            bufferEntry.features.addAll(otherFeatureIds);
            this.bufferEntries.add(bufferEntry);
            this.surfaces.add(dictionaryEntry.getSurface());
            if (this.dictionaryEntries == null) continue;
            this.dictionaryEntries.add(dictionaryEntry);
        }
    }

    protected abstract GenericDictionaryEntry generateGenericDictionaryEntry(T var1);

    protected abstract T parse(String var1);

    @Override
    public void compile() throws IOException {
    }

    private boolean entriesFitInAByte(int entryCount) {
        return entryCount <= 255;
    }

    private List<Byte> createPosFeatureIds(List<Integer> posFeatureIds) {
        ArrayList<Byte> posFeatureIdBytes = new ArrayList<Byte>();
        for (Integer posFeatureId : posFeatureIds) {
            posFeatureIdBytes.add(posFeatureId.byteValue());
        }
        return posFeatureIdBytes;
    }

    public InputStream combinedSequentialFileInputStream(File dir) throws FileNotFoundException {
        ArrayList<FileInputStream> fileInputStreams = new ArrayList<FileInputStream>();
        List<File> files = this.getCsvFiles(dir);
        for (File file : files) {
            fileInputStreams.add(new FileInputStream(file));
        }
        return new SequenceInputStream(Collections.enumeration(fileInputStreams));
    }

    public List<File> getCsvFiles(File dir) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".csv");
            }
        };
        ArrayList<File> files = new ArrayList<File>();
        Collections.addAll(files, dir.listFiles(filter));
        Collections.sort(files);
        return files;
    }

    public void addMapping(int sourceId, int wordId) {
        this.wordIdsCompiler.addMapping(sourceId, wordId);
    }

    public List<String> getSurfaces() {
        return this.surfaces;
    }

    public void write(String directoryName) throws IOException {
        this.writeDictionary(directoryName + File.separator + "tokenInfoDictionary.bin");
        this.writeMap(directoryName + File.separator + "tokenInfoPartOfSpeechMap.bin", this.posInfo);
        this.writeMap(directoryName + File.separator + "tokenInfoFeaturesMap.bin", this.otherInfo);
        this.writeWordIds(directoryName + File.separator + "tokenInfoTargetMap.bin");
    }

    protected void writeMap(String filename, FeatureInfoMap map) throws IOException {
        TreeMap<Integer, String> features = map.invert();
        StringValueMapBuffer mapBuffer = new StringValueMapBuffer(features);
        FileOutputStream fos = new FileOutputStream(filename);
        mapBuffer.write(fos);
    }

    protected void writeDictionary(String filename) throws IOException {
        TokenInfoBufferCompiler tokenInfoBufferCompiler = new TokenInfoBufferCompiler(new FileOutputStream(filename), this.bufferEntries);
        tokenInfoBufferCompiler.compile();
    }

    protected void writeWordIds(String filename) throws IOException {
        this.wordIdsCompiler.write(new FileOutputStream(filename));
    }

    @Deprecated
    public WordIdMap getWordIdMap() throws IOException {
        File file = File.createTempFile("kuromoji-wordid-", ".bin");
        file.deleteOnExit();
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
        this.wordIdsCompiler.write(output);
        ((OutputStream)output).close();
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
        WordIdMap wordIds = new WordIdMap(input);
        ((InputStream)input).close();
        return wordIds;
    }

    @Deprecated
    public List<BufferEntry> getBufferEntries() {
        return this.bufferEntries;
    }

    @Deprecated
    public List<GenericDictionaryEntry> getDictionaryEntries() {
        return this.dictionaryEntries;
    }

    @Deprecated
    public void setDictionaryEntries(List<GenericDictionaryEntry> dictionaryEntries) {
        this.dictionaryEntries = dictionaryEntries;
    }
}

