/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.osmand.binary.BinaryHHRouteReaderAdapter;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapAddressReaderAdapter;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapPoiReaderAdapter;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.router.HHRouteDataStructure;

public class ObfChecker {
    private static int LIMIT_HH_POINTS_NEEDED = 100000;

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("--test")) {
            args = new String[]{System.getProperty("maps.dir") + "Canada_nunavut_northamerica_2.obf"};
        }
        LinkedHashMap<String, String> argMap = new LinkedHashMap<String, String>();
        ArrayList<String> files = new ArrayList<String>();
        for (String a : args) {
            if (a.startsWith("--")) {
                String[] k = a.substring(2).split("=");
                argMap.put(k[0], k.length == 1 ? "" : k[1]);
                continue;
            }
            files.add(a);
        }
        int failed = 0;
        try {
            for (String file : files) {
                boolean ok = ObfChecker.check(file, argMap);
                if (ok) continue;
                ++failed;
            }
            if (failed == 0) {
                System.out.println("OK");
            }
            System.exit(failed);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static boolean check(String file, Map<String, String> argMap) throws Exception {
        File oFile = new File(file);
        RandomAccessFile r = new RandomAccessFile(oFile.getAbsolutePath(), "r");
        boolean ok = true;
        if (oFile.length() > Integer.MAX_VALUE) {
            ok = false;
            System.err.println("File exceeds max integer value that causes issue with C++ protobuf");
        }
        BinaryMapIndexReader index = new BinaryMapIndexReader(r, oFile);
        BinaryMapIndexReader.MapIndex mi = null;
        BinaryHHRouteReaderAdapter.HHRouteRegion car = null;
        BinaryHHRouteReaderAdapter.HHRouteRegion bicycle = null;
        BinaryMapPoiReaderAdapter.PoiRegion poi = null;
        BinaryMapRouteReaderAdapter.RouteRegion routeRegion = null;
        long routeSectionSize = 0L;
        BinaryMapAddressReaderAdapter.AddressRegion address = null;
        boolean world = oFile.getName().toLowerCase().startsWith("world");
        for (BinaryIndexPart p : index.getIndexes()) {
            if (p instanceof BinaryMapIndexReader.MapIndex) {
                mi = (BinaryMapIndexReader.MapIndex)p;
                continue;
            }
            if (p instanceof BinaryHHRouteReaderAdapter.HHRouteRegion) {
                BinaryHHRouteReaderAdapter.HHRouteRegion hr = (BinaryHHRouteReaderAdapter.HHRouteRegion)p;
                if (hr.profile.equals("car")) {
                    car = hr;
                } else if (hr.profile.equals("bicycle")) {
                    bicycle = hr;
                }
                ok &= ObfChecker.checkHHRegion(index, hr);
                continue;
            }
            if (p instanceof BinaryMapPoiReaderAdapter.PoiRegion) {
                poi = (BinaryMapPoiReaderAdapter.PoiRegion)p;
                continue;
            }
            if (p instanceof BinaryMapAddressReaderAdapter.AddressRegion) {
                address = (BinaryMapAddressReaderAdapter.AddressRegion)p;
                continue;
            }
            if (!(p instanceof BinaryMapRouteReaderAdapter.RouteRegion)) continue;
            routeRegion = (BinaryMapRouteReaderAdapter.RouteRegion)p;
            routeSectionSize = p.getLength();
        }
        if (!(routeSectionSize <= (long)(LIMIT_HH_POINTS_NEEDED * 2) || car != null && bicycle != null || world)) {
            int cnt = 0;
            BinaryMapIndexReader.SearchRequest sr = BinaryMapIndexReader.buildSearchRouteRequest((int)0, (int)Integer.MAX_VALUE, (int)0, (int)Integer.MAX_VALUE, null);
            List regions = index.searchRouteIndexTree(sr, routeRegion.getSubregions());
            for (BinaryMapRouteReaderAdapter.RouteSubregion rs : regions) {
                if (cnt > LIMIT_HH_POINTS_NEEDED) break;
                List ls = index.loadRouteIndexData(rs);
                for (RouteDataObject rdo : ls) {
                    if (rdo == null || rdo.getHighway() == null) continue;
                    cnt += rdo.getPointsLength();
                }
            }
            if (cnt > LIMIT_HH_POINTS_NEEDED) {
                ok &= ObfChecker.checkNull(oFile, car, "Missing HH route section for car - route section bytes: " + routeSectionSize);
                ok &= ObfChecker.checkNull(oFile, bicycle, "Missing HH route section for bicycle - route section bytes: " + routeSectionSize);
            }
        }
        ok &= ObfChecker.checkNull(oFile, mi, "Missing Map section");
        if (!world) {
            ok &= ObfChecker.checkNull(oFile, poi, "Missing Poi section");
            ok &= ObfChecker.checkNull(oFile, address, "Missing address section");
            ok &= ObfChecker.checkNull(oFile, routeRegion, "Missing routing section");
        }
        index.close();
        return ok;
    }

    private static boolean checkHHRegion(BinaryMapIndexReader index, BinaryHHRouteReaderAdapter.HHRouteRegion hr) throws IOException {
        boolean ok = true;
        TLongObjectHashMap pnts = index.initHHPoints(hr, (short)0, HHRouteDataStructure.NetworkDBPoint.class);
        for (HHRouteDataStructure.NetworkDBPoint pnt : pnts.valueCollection()) {
            if (pnt.dualPoint != null) continue;
            System.err.printf("Error in map %s - %s missing dual point \n", index.getFile().getName(), pnt.toString());
            ok = false;
        }
        return ok;
    }

    private static boolean checkNull(File f, Object o, String string) {
        if (o == null) {
            System.err.println("[" + f.getName() + "] " + string);
            return false;
        }
        return true;
    }
}

