/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.grid;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import net.osmand.shared.data.KQuadRect;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b%\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0016\u0018\u0000 [2\u00020\u0001:\u0001[B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\u000bB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\u000eJ\u0006\u00100\u001a\u00020\u0000J\u0006\u00101\u001a\u00020\u0000J\u0006\u00102\u001a\u00020\u0000J\u0006\u00103\u001a\u00020\u0000J\u0006\u00104\u001a\u00020\u0000J\u0016\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0007J\u000e\u00108\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0007J\u000e\u00109\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0007J\u0016\u0010:\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007J\u0006\u0010A\u001a\u00020BJ>\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020\u00072\u0006\u0010I\u001a\u00020\t2\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\t2\u0006\u0010L\u001a\u00020\u0007J\u000e\u0010M\u001a\u00020\u00072\u0006\u0010E\u001a\u00020FJ\u000e\u0010N\u001a\u00020\u00072\u0006\u0010E\u001a\u00020FJ\u000e\u0010O\u001a\u00020\u00072\u0006\u0010E\u001a\u00020FJ\u000e\u0010P\u001a\u00020\u00072\u0006\u0010E\u001a\u00020FJ\u000e\u0010Q\u001a\u00020\u00072\u0006\u0010E\u001a\u00020FJ\u000e\u0010R\u001a\u00020\u00002\u0006\u0010S\u001a\u00020BJ\b\u0010T\u001a\u00020DH\u0002J\b\u0010U\u001a\u00020\u0003H\u0016J\u000e\u0010V\u001a\u00020\t2\u0006\u0010W\u001a\u00020\u0000J\u0018\u0010X\u001a\u00020D2\u0006\u0010Y\u001a\u00020\u00072\u0006\u0010Z\u001a\u00020\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\r\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0017\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0012\"\u0004\b\u0019\u0010\u0014R\u001a\u0010\u001a\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0012\"\u0004\b\u001c\u0010\u0014R\u001a\u0010\u001d\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0012\"\u0004\b\u001f\u0010\u0014R\u001a\u0010 \u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0012\"\u0004\b\"\u0010\u0014R\u001a\u0010#\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010%\"\u0004\b*\u0010'R\u001a\u0010+\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0012\"\u0004\b-\u0010\u0014R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010;\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010%R\u0011\u0010<\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010%R\u0011\u0010=\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010%R\u0011\u0010>\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010%R\u0011\u0010?\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010%R\u0011\u0010@\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010%\u00a8\u0006\\"}, d2={"Lnet/osmand/shared/grid/ButtonPositionSize;", "", "id", "", "<init>", "(Ljava/lang/String;)V", "sz8dp", "", "left", "", "top", "(Ljava/lang/String;IZZ)V", "posH", "posV", "(Ljava/lang/String;III)V", "getId", "()Ljava/lang/String;", "getPosH", "()I", "setPosH", "(I)V", "getPosV", "setPosV", "marginX", "getMarginX", "setMarginX", "marginY", "getMarginY", "setMarginY", "width", "getWidth", "setWidth", "height", "getHeight", "setHeight", "xMove", "getXMove", "()Z", "setXMove", "(Z)V", "yMove", "getYMove", "setYMove", "moveDescendants", "getMoveDescendants", "setMoveDescendants", "bounds", "Lnet/osmand/shared/data/KQuadRect;", "setMoveVertical", "setMoveDescendantsAny", "setMoveDescendantsVertical", "setMoveDescendantsHorizontal", "setMoveHorizontal", "setSize", "width8dp", "height8dp", "setPositionHorizontal", "setPositionVertical", "setMargin", "isLeft", "isRight", "isTop", "isBottom", "isFullWidth", "isFullHeight", "toLongValue", "", "calcGridPositionFromPixel", "", "dpToPix", "", "widthPx", "heightPx", "gravLeft", "x", "gravTop", "y", "getYStartPix", "getYEndPix", "getXStartPix", "getXEndPix", "getWidthPix", "fromLongValue", "v", "validate", "toString", "overlap", "position", "updateBounds", "totalWidth", "totalHeight", "Companion", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nButtonPositionSize.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ButtonPositionSize.kt\nnet/osmand/shared/grid/ButtonPositionSize\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,338:1\n1#2:339\n*E\n"})
public final class ButtonPositionSize {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private int posH;
    private int posV;
    private int marginX;
    private int marginY;
    private int width;
    private int height;
    private boolean xMove;
    private boolean yMove;
    private int moveDescendants;
    @NotNull
    private final KQuadRect bounds;
    @NotNull
    private static final Logger LOG = LoggerFactory.INSTANCE.getLogger("ButtonPositionSize");
    private static final int MAX_ITERATIONS = 1000;
    private static final int MAX_STUCK_ATTEMPTS = 20;
    public static final int CELL_SIZE_DP = 8;
    public static final int DEF_MARGIN_DP = 4;
    public static final int MOVE_DESCENDANTS_ANY = 0;
    public static final int MOVE_DESCENDANTS_VERTICAL = 1;
    public static final int MOVE_DESCENDANTS_HORIZONTAL = 2;
    public static final int POS_FULL_WIDTH = 0;
    public static final int POS_LEFT = 1;
    public static final int POS_RIGHT = 2;
    public static final int POS_FULL_HEIGHT = 0;
    public static final int POS_TOP = 1;
    public static final int POS_BOTTOM = 2;
    private static final int MAX_MARGIN_BITS = 10;
    private static final int MAX_SIZE_BITS = 6;
    private static final int MARGIN_MASK = 1023;
    private static final int SIZE_MASK = 63;

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final int getPosH() {
        return this.posH;
    }

    public final void setPosH(int n) {
        this.posH = n;
    }

    public final int getPosV() {
        return this.posV;
    }

    public final void setPosV(int n) {
        this.posV = n;
    }

    public final int getMarginX() {
        return this.marginX;
    }

    public final void setMarginX(int n) {
        this.marginX = n;
    }

    public final int getMarginY() {
        return this.marginY;
    }

    public final void setMarginY(int n) {
        this.marginY = n;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    public final boolean getXMove() {
        return this.xMove;
    }

    public final void setXMove(boolean bl) {
        this.xMove = bl;
    }

    public final boolean getYMove() {
        return this.yMove;
    }

    public final void setYMove(boolean bl) {
        this.yMove = bl;
    }

    public final int getMoveDescendants() {
        return this.moveDescendants;
    }

    public final void setMoveDescendants(int n) {
        this.moveDescendants = n;
    }

    public ButtonPositionSize(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this(id, 7, true, true);
    }

    public ButtonPositionSize(@NotNull String id, int sz8dp, boolean left, boolean top) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.posH = 1;
        this.posV = 1;
        this.width = 7;
        this.height = 7;
        this.bounds = new KQuadRect();
        this.id = id;
        this.width = sz8dp;
        this.height = sz8dp;
        this.posH = left ? 1 : 2;
        this.posV = top ? 1 : 2;
    }

    public ButtonPositionSize(@NotNull String id, int sz8dp, int posH, int posV) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.posH = 1;
        this.posV = 1;
        this.width = 7;
        this.height = 7;
        this.bounds = new KQuadRect();
        this.id = id;
        this.width = sz8dp;
        this.height = sz8dp;
        this.posH = posH;
        this.posV = posV;
        this.validate();
    }

    @NotNull
    public final ButtonPositionSize setMoveVertical() {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setMoveVertical_u24lambda_u240 = buttonPositionSize = this;
        boolean bl = false;
        $this$setMoveVertical_u24lambda_u240.yMove = true;
        return buttonPositionSize;
    }

    @NotNull
    public final ButtonPositionSize setMoveDescendantsAny() {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setMoveDescendantsAny_u24lambda_u241 = buttonPositionSize = this;
        boolean bl = false;
        $this$setMoveDescendantsAny_u24lambda_u241.moveDescendants = 0;
        return buttonPositionSize;
    }

    @NotNull
    public final ButtonPositionSize setMoveDescendantsVertical() {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setMoveDescendantsVertical_u24lambda_u242 = buttonPositionSize = this;
        boolean bl = false;
        $this$setMoveDescendantsVertical_u24lambda_u242.moveDescendants = 1;
        return buttonPositionSize;
    }

    @NotNull
    public final ButtonPositionSize setMoveDescendantsHorizontal() {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setMoveDescendantsHorizontal_u24lambda_u243 = buttonPositionSize = this;
        boolean bl = false;
        $this$setMoveDescendantsHorizontal_u24lambda_u243.moveDescendants = 2;
        return buttonPositionSize;
    }

    @NotNull
    public final ButtonPositionSize setMoveHorizontal() {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setMoveHorizontal_u24lambda_u244 = buttonPositionSize = this;
        boolean bl = false;
        $this$setMoveHorizontal_u24lambda_u244.xMove = true;
        return buttonPositionSize;
    }

    @NotNull
    public final ButtonPositionSize setSize(int width8dp, int height8dp) {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setSize_u24lambda_u245 = buttonPositionSize = this;
        boolean bl = false;
        $this$setSize_u24lambda_u245.width = width8dp;
        $this$setSize_u24lambda_u245.height = height8dp;
        return buttonPositionSize;
    }

    @NotNull
    public final ButtonPositionSize setPositionHorizontal(int posH) {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setPositionHorizontal_u24lambda_u246 = buttonPositionSize = this;
        boolean bl = false;
        $this$setPositionHorizontal_u24lambda_u246.posH = posH;
        $this$setPositionHorizontal_u24lambda_u246.validate();
        return buttonPositionSize;
    }

    @NotNull
    public final ButtonPositionSize setPositionVertical(int posV) {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setPositionVertical_u24lambda_u247 = buttonPositionSize = this;
        boolean bl = false;
        $this$setPositionVertical_u24lambda_u247.posV = posV;
        $this$setPositionVertical_u24lambda_u247.validate();
        return buttonPositionSize;
    }

    @NotNull
    public final ButtonPositionSize setMargin(int marginX, int marginY) {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setMargin_u24lambda_u248 = buttonPositionSize = this;
        boolean bl = false;
        $this$setMargin_u24lambda_u248.marginX = marginX;
        $this$setMargin_u24lambda_u248.marginY = marginY;
        return buttonPositionSize;
    }

    public final boolean isLeft() {
        return this.posH == 1;
    }

    public final boolean isRight() {
        return this.posH == 2;
    }

    public final boolean isTop() {
        return this.posV == 1;
    }

    public final boolean isBottom() {
        return this.posV == 2;
    }

    public final boolean isFullWidth() {
        return this.posH == 0;
    }

    public final boolean isFullHeight() {
        return this.posV == 0;
    }

    public final long toLongValue() {
        long vl = 0L;
        vl = (vl << 2) + (long)this.moveDescendants;
        vl = (vl << 2) + (long)this.posV;
        vl = (vl << 1) + (long)(this.yMove ? 1 : 0);
        vl = (vl << 10) + (long)Math.min(this.marginY, 1023);
        vl = (vl << 6) + (long)Math.min(this.height, 63);
        vl = (vl << 2) + (long)this.posH;
        vl = (vl << 1) + (long)(this.xMove ? 1 : 0);
        vl = (vl << 10) + (long)Math.min(this.marginX, 1023);
        vl = (vl << 6) + (long)Math.min(this.width, 63);
        return vl;
    }

    public final void calcGridPositionFromPixel(float dpToPix, int widthPx, int heightPx, boolean gravLeft, int x, boolean gravTop, int y) {
        float calcX = 0.0f;
        if (x < widthPx / 2) {
            this.posH = gravLeft ? 1 : 2;
            calcX = (float)x / dpToPix;
        } else {
            this.posH = gravLeft ? 2 : 1;
            calcX = (float)(widthPx - x) / dpToPix - (float)(this.width * 8);
        }
        this.marginX = Math.max(0, MathKt.roundToInt((float)((calcX - (float)4) / (float)8)));
        float calcY = 0.0f;
        if (y < heightPx / 2) {
            this.posV = gravTop ? 1 : 2;
            calcY = (float)y / dpToPix;
        } else {
            this.posV = gravTop ? 2 : 1;
            calcY = (float)(heightPx - y) / dpToPix - (float)(this.height * 8);
        }
        this.marginY = Math.max(0, MathKt.roundToInt((float)((calcY - (float)4) / (float)8)));
    }

    public final int getYStartPix(float dpToPix) {
        return (int)((float)(this.marginY * 8 + 4) * dpToPix);
    }

    public final int getYEndPix(float dpToPix) {
        return (int)((float)((this.marginY + this.height) * 8 + 4) * dpToPix);
    }

    public final int getXStartPix(float dpToPix) {
        return (int)((float)(this.marginX * 8 + 4) * dpToPix);
    }

    public final int getXEndPix(float dpToPix) {
        return (int)((float)((this.marginX + this.width) * 8 + 4) * dpToPix);
    }

    public final int getWidthPix(float dpToPix) {
        return (int)((float)(this.width * 8) * dpToPix);
    }

    @NotNull
    public final ButtonPositionSize fromLongValue(long v) {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$fromLongValue_u24lambda_u249 = buttonPositionSize = this;
        boolean bl = false;
        long value = v;
        $this$fromLongValue_u24lambda_u249.width = (int)(value & 0x3FL);
        $this$fromLongValue_u24lambda_u249.marginX = (int)((value >>= 6) & 0x3FFL);
        $this$fromLongValue_u24lambda_u249.xMove = (value >>= 10) % (long)2 == 1L;
        $this$fromLongValue_u24lambda_u249.posH = (int)((value >>= 1) % (long)4);
        $this$fromLongValue_u24lambda_u249.height = (int)((value >>= 2) & 0x3FL);
        $this$fromLongValue_u24lambda_u249.marginY = (int)((value >>= 6) & 0x3FFL);
        $this$fromLongValue_u24lambda_u249.yMove = (value >>= 10) % (long)2 == 1L;
        $this$fromLongValue_u24lambda_u249.posV = (int)((value >>= 1) % (long)4);
        $this$fromLongValue_u24lambda_u249.moveDescendants = (int)((value >>= 2) % (long)4);
        $this$fromLongValue_u24lambda_u249.validate();
        return buttonPositionSize;
    }

    private final void validate() {
        if (this.posH == 0 && this.posV == 0) {
            Logger.error$default(LOG, "Error parsing " + this + " as full width + full height", null, 2, null);
            this.posH = 2;
        }
    }

    @NotNull
    public String toString() {
        String posHStr = switch (this.posH) {
            case 0 -> "full_w";
            case 1 -> "left ";
            default -> "right";
        };
        String posVStr = switch (this.posV) {
            case 0 -> "full_h";
            case 1 -> "top ";
            default -> "bott";
        };
        String xMoveIndicator = this.xMove ? "+" : " ";
        String yMoveIndicator = this.yMove ? "+" : " ";
        String paddedWidth = StringsKt.padStart$default((String)String.valueOf(this.width), (int)2, (char)'\u0000', (int)2, null);
        String paddedHeight = StringsKt.padStart$default((String)String.valueOf(this.height), (int)2, (char)'\u0000', (int)2, null);
        return "Pos " + StringsKt.padStart$default((String)this.id, (int)10, (char)'\u0000', (int)2, null) + " x=(" + posHStr + "->" + this.marginX + xMoveIndicator + "), y=(" + posVStr + "->" + this.marginY + yMoveIndicator + "), w=" + paddedWidth + ", h=" + paddedHeight;
    }

    public final boolean overlap(@NotNull ButtonPositionSize position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return KQuadRect.Companion.intersects(this.bounds, position.bounds);
    }

    private final void updateBounds(int totalWidth, int totalHeight) {
        double left = 0.0;
        double right = 0.0;
        double top = 0.0;
        double bottom = 0.0;
        if (this.posH == 0) {
            left = 0.0;
            right = totalWidth;
        } else if (this.posH == 1) {
            left = this.marginX;
            right = left + (double)this.width;
        } else {
            right = totalWidth - this.marginX;
            left = right - (double)this.width;
        }
        if (this.posV == 0) {
            top = 0.0;
            bottom = totalHeight;
        } else if (this.posV == 1) {
            top = this.marginY;
            bottom = top + (double)this.height;
        } else {
            bottom = totalHeight - this.marginY;
            top = bottom - (double)this.height;
        }
        this.bounds.setLeft(left);
        this.bounds.setRight(right);
        this.bounds.setTop(top);
        this.bounds.setBottom(bottom);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007J0\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lnet/osmand/shared/grid/ButtonPositionSize$Companion;", "", "<init>", "()V", "LOG", "Lnet/osmand/shared/util/Logger;", "MAX_ITERATIONS", "", "MAX_STUCK_ATTEMPTS", "CELL_SIZE_DP", "DEF_MARGIN_DP", "MOVE_DESCENDANTS_ANY", "MOVE_DESCENDANTS_VERTICAL", "MOVE_DESCENDANTS_HORIZONTAL", "POS_FULL_WIDTH", "POS_LEFT", "POS_RIGHT", "POS_FULL_HEIGHT", "POS_TOP", "POS_BOTTOM", "MAX_MARGIN_BITS", "MAX_SIZE_BITS", "MARGIN_MASK", "SIZE_MASK", "computeNonOverlap", "", "space", "buttons", "", "Lnet/osmand/shared/grid/ButtonPositionSize;", "totalWidth", "totalHeight", "moveButton", "toMove", "overlap", "OsmAnd-shared"})
    @SourceDebugExtension(value={"SMAP\nButtonPositionSize.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ButtonPositionSize.kt\nnet/osmand/shared/grid/ButtonPositionSize$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,338:1\n1863#2,2:339\n*S KotlinDebug\n*F\n+ 1 ButtonPositionSize.kt\nnet/osmand/shared/grid/ButtonPositionSize$Companion\n*L\n258#1:339,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean computeNonOverlap(int space, @NotNull List<ButtonPositionSize> buttons, int totalWidth, int totalHeight) {
            Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
            Iterable $this$forEach$iv = buttons;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ButtonPositionSize it = (ButtonPositionSize)element$iv;
                boolean bl = false;
                it.updateBounds(totalWidth, totalHeight);
            }
            int iteration = 0;
            Map moveAttempts = new LinkedHashMap();
            int fixedPos = buttons.size() - 1;
            while (fixedPos >= 0) {
                if (iteration++ > 1000) {
                    Logger.error$default(LOG, "Relayout is broken", null, 2, null);
                    return false;
                }
                boolean overlap = false;
                ButtonPositionSize button = buttons.get(fixedPos);
                int n = buttons.size();
                for (int i = fixedPos + 1; i < n; ++i) {
                    int attempts;
                    ButtonPositionSize check = buttons.get(i);
                    if (!button.overlap(check)) continue;
                    Integer n2 = (Integer)moveAttempts.get(check);
                    int n3 = attempts = n2 != null ? n2 : 0;
                    if (attempts >= 20) {
                        LOG.warn("Skipping move for " + check + " (max attempts reached)");
                        continue;
                    }
                    if (!this.moveButton(space, check, button, totalWidth, totalHeight)) continue;
                    overlap = true;
                    check.updateBounds(totalWidth, totalHeight);
                    moveAttempts.put(check, attempts + 1);
                    fixedPos = i;
                    break;
                }
                if (overlap) continue;
                --fixedPos;
            }
            return true;
        }

        private final boolean moveButton(int space, ButtonPositionSize toMove, ButtonPositionSize overlap, int totalWidth, int totalHeight) {
            int desired;
            int newY;
            boolean xMove = false;
            boolean yMove = false;
            switch (overlap.getMoveDescendants()) {
                case 0: {
                    if (overlap.isFullWidth()) {
                        yMove = true;
                        break;
                    }
                    if (overlap.isFullHeight()) {
                        xMove = true;
                        break;
                    }
                    if (toMove.getXMove()) {
                        xMove = true;
                    }
                    if (!toMove.getYMove()) break;
                    yMove = true;
                    break;
                }
                case 1: {
                    yMove = true;
                    break;
                }
                case 2: {
                    xMove = true;
                }
            }
            int newX = xMove ? space + overlap.getMarginX() + overlap.getWidth() : toMove.getMarginX();
            int n = newY = yMove ? space + overlap.getMarginY() + overlap.getHeight() : toMove.getMarginY();
            if (newX + toMove.getWidth() > totalWidth) {
                newX = Math.max(0, totalWidth - toMove.getWidth());
                if (!yMove) {
                    desired = space + overlap.getMarginY() + overlap.getHeight();
                    newY = Math.max(0, Math.min(desired, totalHeight - toMove.getHeight()));
                }
            }
            if (newY + toMove.getHeight() > totalHeight) {
                newY = Math.max(0, totalHeight - toMove.getHeight());
                if (!xMove) {
                    desired = space + overlap.getMarginX() + overlap.getWidth();
                    newX = Math.max(0, Math.min(desired, totalWidth - toMove.getWidth()));
                }
            }
            boolean moved = newX != toMove.getMarginX() || newY != toMove.getMarginY();
            toMove.setMarginX(newX);
            toMove.setMarginY(newY);
            return moved;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

