/*
 * Decompiled with CFR 0.152.
 */
package io.github.cosinekitty.astronomy;

import io.github.cosinekitty.astronomy.Astronomy;
import io.github.cosinekitty.astronomy.StateVector;
import io.github.cosinekitty.astronomy.Vector;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006BQ\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u0012\u0006\u0010\r\u001a\u00020\b\u0012\u0006\u0010\u000e\u001a\u00020\b\u0012\u0006\u0010\u000f\u001a\u00020\b\u0012\u0006\u0010\u0010\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\u0011J\u0006\u0010\u0015\u001a\u00020\u0000J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J\u000e\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000H\u0086\u0004J\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\bR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lio/github/cosinekitty/astronomy/RotationMatrix;", "", "rot", "", "", "<init>", "([[D)V", "a00", "", "a01", "a02", "a10", "a11", "a12", "a20", "a21", "a22", "(DDDDDDDDD)V", "getRot", "()[[D", "[[D", "inverse", "rotate", "Lio/github/cosinekitty/astronomy/Vector;", "vec", "Lio/github/cosinekitty/astronomy/StateVector;", "state", "combine", "other", "pivot", "axis", "", "angle", "Companion", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nastronomy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 astronomy.kt\nio/github/cosinekitty/astronomy/RotationMatrix\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,10676:1\n12511#2,2:10677\n*S KotlinDebug\n*F\n+ 1 astronomy.kt\nio/github/cosinekitty/astronomy/RotationMatrix\n*L\n1183#1:10677,2\n*E\n"})
public final class RotationMatrix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final double[][] rot;

    public RotationMatrix(@NotNull double[][] rot) {
        block5: {
            block4: {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)rot, (String)"rot");
                    this.rot = rot;
                    if (((Object[])this.rot).length != 3) break block4;
                    Object[] $this$any$iv = (Object[])this.rot;
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        double[] it = (double[])element$iv;
                        boolean bl2 = false;
                        if (!(it.length != 3)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (!bl) break block5;
            }
            throw new IllegalArgumentException("Rotation matrix must be a 3x3 array.");
        }
    }

    @NotNull
    public final double[][] getRot() {
        return this.rot;
    }

    public RotationMatrix(double a00, double a01, double a02, double a10, double a11, double a12, double a20, double a21, double a22) {
        double[][] dArrayArray = new double[3][];
        double[] dArray = new double[]{a00, a01, a02};
        dArrayArray[0] = dArray;
        dArray = new double[]{a10, a11, a12};
        dArrayArray[1] = dArray;
        dArray = new double[]{a20, a21, a22};
        dArrayArray[2] = dArray;
        this(dArrayArray);
    }

    @NotNull
    public final RotationMatrix inverse() {
        return new RotationMatrix(this.rot[0][0], this.rot[1][0], this.rot[2][0], this.rot[0][1], this.rot[1][1], this.rot[2][1], this.rot[0][2], this.rot[1][2], this.rot[2][2]);
    }

    @NotNull
    public final Vector rotate(@NotNull Vector vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        return new Vector(this.rot[0][0] * vec.getX() + this.rot[1][0] * vec.getY() + this.rot[2][0] * vec.getZ(), this.rot[0][1] * vec.getX() + this.rot[1][1] * vec.getY() + this.rot[2][1] * vec.getZ(), this.rot[0][2] * vec.getX() + this.rot[1][2] * vec.getY() + this.rot[2][2] * vec.getZ(), vec.getT());
    }

    @NotNull
    public final StateVector rotate(@NotNull StateVector state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new StateVector(this.rotate(state.position()), this.rotate(state.velocity()), state.getT());
    }

    @NotNull
    public final RotationMatrix combine(@NotNull RotationMatrix other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new RotationMatrix(other.rot[0][0] * this.rot[0][0] + other.rot[1][0] * this.rot[0][1] + other.rot[2][0] * this.rot[0][2], other.rot[0][1] * this.rot[0][0] + other.rot[1][1] * this.rot[0][1] + other.rot[2][1] * this.rot[0][2], other.rot[0][2] * this.rot[0][0] + other.rot[1][2] * this.rot[0][1] + other.rot[2][2] * this.rot[0][2], other.rot[0][0] * this.rot[1][0] + other.rot[1][0] * this.rot[1][1] + other.rot[2][0] * this.rot[1][2], other.rot[0][1] * this.rot[1][0] + other.rot[1][1] * this.rot[1][1] + other.rot[2][1] * this.rot[1][2], other.rot[0][2] * this.rot[1][0] + other.rot[1][2] * this.rot[1][1] + other.rot[2][2] * this.rot[1][2], other.rot[0][0] * this.rot[2][0] + other.rot[1][0] * this.rot[2][1] + other.rot[2][0] * this.rot[2][2], other.rot[0][1] * this.rot[2][0] + other.rot[1][1] * this.rot[2][1] + other.rot[2][1] * this.rot[2][2], other.rot[0][2] * this.rot[2][0] + other.rot[1][2] * this.rot[2][1] + other.rot[2][2] * this.rot[2][2]);
    }

    @NotNull
    public final RotationMatrix pivot(int axis, double angle) {
        if (axis < 0 || axis > 2) {
            throw new IllegalArgumentException("Invalid coordinate axis " + axis + ". Must be 0..2.");
        }
        double d = angle;
        if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
            throw new IllegalArgumentException("Angle must be a finite number.");
        }
        double radians = Astronomy.degreesToRadians(angle);
        double c = Math.cos(radians);
        double s = Math.sin(radians);
        int i = (axis + 1) % 3;
        int j = (axis + 2) % 3;
        int k = axis;
        double[][] dArrayArray = new double[][]{new double[3], new double[3], new double[3]};
        double[][] piv = dArrayArray;
        piv[i][i] = c * this.rot[i][i] - s * this.rot[i][j];
        piv[i][j] = s * this.rot[i][i] + c * this.rot[i][j];
        piv[i][k] = this.rot[i][k];
        piv[j][i] = c * this.rot[j][i] - s * this.rot[j][j];
        piv[j][j] = s * this.rot[j][i] + c * this.rot[j][j];
        piv[j][k] = this.rot[j][k];
        piv[k][i] = c * this.rot[k][i] - s * this.rot[k][j];
        piv[k][j] = s * this.rot[k][i] + c * this.rot[k][j];
        piv[k][k] = this.rot[k][k];
        return new RotationMatrix(piv);
    }

    @JvmStatic
    @NotNull
    public static final RotationMatrix identity() {
        return Companion.identity();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lio/github/cosinekitty/astronomy/RotationMatrix$Companion;", "", "<init>", "()V", "identity", "Lio/github/cosinekitty/astronomy/RotationMatrix;", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RotationMatrix identity() {
            return new RotationMatrix(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

