/*
 * Decompiled with CFR 0.152.
 */
package io.github.cosinekitty.astronomy;

import io.github.cosinekitty.astronomy.Astronomy;
import io.github.cosinekitty.astronomy.Body;
import io.github.cosinekitty.astronomy.BodyGravCalc;
import io.github.cosinekitty.astronomy.BodyState;
import io.github.cosinekitty.astronomy.GravSimEndpoint;
import io.github.cosinekitty.astronomy.InvalidBodyException;
import io.github.cosinekitty.astronomy.StateVector;
import io.github.cosinekitty.astronomy.TerseVector;
import io.github.cosinekitty.astronomy.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0004\u001a\u00020\u0005J\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0003J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u001e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\b\u0010\u001b\u001a\u00020\u0014H\u0002J(\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/github/cosinekitty/astronomy/GravitySimulator;", "", "originBody", "Lio/github/cosinekitty/astronomy/Body;", "time", "Lio/github/cosinekitty/astronomy/Time;", "bodyStates", "", "Lio/github/cosinekitty/astronomy/StateVector;", "<init>", "(Lio/github/cosinekitty/astronomy/Body;Lio/github/cosinekitty/astronomy/Time;Ljava/util/List;)V", "getOriginBody", "()Lio/github/cosinekitty/astronomy/Body;", "prev", "Lio/github/cosinekitty/astronomy/GravSimEndpoint;", "curr", "update", "", "(Lio/github/cosinekitty/astronomy/Time;)[Lio/github/cosinekitty/astronomy/StateVector;", "swap", "", "solarSystemBodyState", "body", "internalBodyState", "Lio/github/cosinekitty/astronomy/BodyState;", "initialEndpoint", "calcSolarSystem", "calcBodyAccelerations", "addAcceleration", "acc", "Lio/github/cosinekitty/astronomy/TerseVector;", "smallPos", "majorPos", "gm", "", "duplicate", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nastronomy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 astronomy.kt\nio/github/cosinekitty/astronomy/GravitySimulator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,10676:1\n13411#2,3:10677\n13411#2,3:10680\n11102#2:10683\n11437#2,3:10684\n37#3,2:10687\n37#3,2:10693\n1557#4:10689\n1628#4,3:10690\n*S KotlinDebug\n*F\n+ 1 astronomy.kt\nio/github/cosinekitty/astronomy/GravitySimulator\n*L\n8856#1:10677,3\n8864#1:10680,3\n8892#1:10683\n8892#1:10684,3\n8892#1:10687,2\n9004#1:10693,2\n8997#1:10689\n8997#1:10690,3\n*E\n"})
public final class GravitySimulator {
    @NotNull
    private final Body originBody;
    @NotNull
    private GravSimEndpoint prev;
    @NotNull
    private GravSimEndpoint curr;

    @NotNull
    public final Body getOriginBody() {
        return this.originBody;
    }

    public GravitySimulator(@NotNull Body originBody, @NotNull Time time, @NotNull List<StateVector> bodyStates) {
        Intrinsics.checkNotNullParameter((Object)((Object)originBody), (String)"originBody");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter(bodyStates, (String)"bodyStates");
        this.originBody = originBody;
        for (StateVector b : bodyStates) {
            if (b.getT().getTt() == time.getTt()) continue;
            throw new IllegalArgumentException("Inconsistent time(s) in bodyStates array.");
        }
        this.curr = this.initialEndpoint(time, bodyStates);
        this.prev = this.initialEndpoint(time, bodyStates);
        this.calcSolarSystem();
        if (originBody != Body.SSB) {
            BodyState ostate = this.internalBodyState(originBody);
            for (BodyGravCalc bstate : this.curr.getBodies()) {
                TerseVector terseVector = bstate.getR();
                terseVector.setX(terseVector.getX() + ostate.getR().getX());
                terseVector = bstate.getR();
                terseVector.setY(terseVector.getY() + ostate.getR().getY());
                terseVector = bstate.getR();
                terseVector.setZ(terseVector.getZ() + ostate.getR().getZ());
                terseVector = bstate.getV();
                terseVector.setX(terseVector.getX() + ostate.getV().getX());
                terseVector = bstate.getV();
                terseVector.setY(terseVector.getY() + ostate.getV().getY());
                terseVector = bstate.getV();
                terseVector.setZ(terseVector.getZ() + ostate.getV().getZ());
            }
        }
        this.calcBodyAccelerations();
        this.duplicate();
    }

    @NotNull
    public final Time time() {
        return this.curr.getTime();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StateVector[] update(@NotNull Time time) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        BodyGravCalc c;
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        double dt = time.getTt() - this.curr.getTime().getTt();
        if (dt == 0.0) {
            this.duplicate();
        } else {
            BodyGravCalc p;
            int i;
            this.swap();
            this.curr.setTime(time);
            this.calcSolarSystem();
            BodyGravCalc[] $this$forEachIndexed$iv = this.prev.getBodies();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (BodyGravCalc item$iv : $this$forEachIndexed$iv) {
                int n = index$iv++;
                BodyGravCalc bodyGravCalc = item$iv;
                i = n;
                boolean bl = false;
                this.curr.getBodies()[i].setR(Astronomy.access$updatePosition(dt, p.getR(), p.getV(), p.getA()));
            }
            this.calcBodyAccelerations();
            $this$forEachIndexed$iv = this.prev.getBodies();
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (BodyGravCalc item$iv : $this$forEachIndexed$iv) {
                int n = index$iv++;
                p = item$iv;
                i = n;
                boolean bl = false;
                c = this.curr.getBodies()[i];
                TerseVector acc = p.getA().mean(c.getA());
                c.setTt(time.getTt());
                c.setR(Astronomy.access$updatePosition(dt, p.getR(), p.getV(), acc));
                c.setV(Astronomy.access$updateVelocity(dt, p.getV(), acc));
            }
            this.calcBodyAccelerations();
        }
        Object $this$map$iv = this.curr.getBodies();
        boolean $i$f$map = false;
        BodyGravCalc[] bodyGravCalcArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((BodyGravCalc[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            c = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Astronomy.access$exportGravCalc((BodyGravCalc)it, time));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        StateVector[] bodyStateArray = thisCollection$iv.toArray(new StateVector[0]);
        if (this.originBody != Body.SSB) {
            BodyState ostate = this.internalBodyState(this.originBody);
            int n = bodyStateArray.length;
            for (int i = 0; i < n; ++i) {
                bodyStateArray[i] = new StateVector(bodyStateArray[i].getX() - ostate.getR().getX(), bodyStateArray[i].getY() - ostate.getR().getY(), bodyStateArray[i].getZ() - ostate.getR().getZ(), bodyStateArray[i].getVx() - ostate.getV().getX(), bodyStateArray[i].getVy() - ostate.getV().getY(), bodyStateArray[i].getVz() - ostate.getV().getZ(), time);
            }
        }
        return bodyStateArray;
    }

    public final void swap() {
        GravSimEndpoint s = this.curr;
        this.curr = this.prev;
        this.prev = s;
    }

    @NotNull
    public final StateVector solarSystemBodyState(@NotNull Body body) {
        Intrinsics.checkNotNullParameter((Object)((Object)body), (String)"body");
        BodyState bstate = this.internalBodyState(body);
        BodyState ostate = this.internalBodyState(this.originBody);
        return Astronomy.access$exportState(bstate.minus(ostate), this.curr.getTime());
    }

    private final BodyState internalBodyState(Body body) {
        BodyState bodyState;
        if (body == Body.Sun || body.ordinal() >= Body.Mercury.ordinal() && body.ordinal() <= Body.Neptune.ordinal()) {
            bodyState = this.curr.getGravitators()[body.ordinal()];
        } else if (body == Body.SSB) {
            bodyState = new BodyState(this.curr.getTime().getTt(), TerseVector.Companion.zero(), TerseVector.Companion.zero());
        } else {
            throw new InvalidBodyException(body);
        }
        return bodyState;
    }

    /*
     * WARNING - void declaration
     */
    private final GravSimEndpoint initialEndpoint(Time time, List<StateVector> bodyStates) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        int n = 0;
        int n2 = Body.Sun.ordinal() + 1;
        BodyState[] bodyStateArray = new BodyState[n2];
        while (n < n2) {
            int n3 = n++;
            bodyStateArray[n3] = new BodyState(time.getTt(), new TerseVector(0.0, 0.0, 0.0), new TerseVector(0.0, 0.0, 0.0));
        }
        BodyState[] gravitators = bodyStateArray;
        Iterable $this$map$iv = bodyStates;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StateVector stateVector = (StateVector)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new BodyGravCalc(time.getTt(), new TerseVector(it.getX(), it.getY(), it.getZ()), new TerseVector(it.getVx(), it.getVy(), it.getVz()), new TerseVector(0.0, 0.0, 0.0)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        BodyGravCalc[] bodies = thisCollection$iv.toArray(new BodyGravCalc[0]);
        return new GravSimEndpoint(time, gravitators, bodies);
    }

    private final void calcSolarSystem() {
        double tt = this.curr.getTime().getTt();
        BodyState sun = this.curr.getGravitators()[Body.Sun.ordinal()];
        sun.setTt(tt);
        sun.getR().setToZero();
        sun.getV().setToZero();
        this.curr.getGravitators()[Body.Mercury.ordinal()] = Astronomy.access$adjustBarycenterPosVel(sun, tt, Body.Mercury, 4.912547451450812E-11);
        this.curr.getGravitators()[Body.Venus.ordinal()] = Astronomy.access$adjustBarycenterPosVel(sun, tt, Body.Venus, 7.243452486162703E-10);
        this.curr.getGravitators()[Body.Earth.ordinal()] = Astronomy.access$adjustBarycenterPosVel(sun, tt, Body.Earth, 8.997011346712498E-10);
        this.curr.getGravitators()[Body.Mars.ordinal()] = Astronomy.access$adjustBarycenterPosVel(sun, tt, Body.Mars, 9.549535105779258E-11);
        this.curr.getGravitators()[Body.Jupiter.ordinal()] = Astronomy.access$adjustBarycenterPosVel(sun, tt, Body.Jupiter, 2.825345909524226E-7);
        this.curr.getGravitators()[Body.Saturn.ordinal()] = Astronomy.access$adjustBarycenterPosVel(sun, tt, Body.Saturn, 8.459715185680659E-8);
        this.curr.getGravitators()[Body.Uranus.ordinal()] = Astronomy.access$adjustBarycenterPosVel(sun, tt, Body.Uranus, 1.292024916781969E-8);
        this.curr.getGravitators()[Body.Neptune.ordinal()] = Astronomy.access$adjustBarycenterPosVel(sun, tt, Body.Neptune, 1.524358900784276E-8);
        int bindex = Body.Mercury.ordinal();
        int n = Body.Neptune.ordinal();
        if (bindex <= n) {
            while (true) {
                this.curr.getGravitators()[bindex].getR().decrement(sun.getR());
                this.curr.getGravitators()[bindex].getV().decrement(sun.getV());
                if (bindex == n) break;
                ++bindex;
            }
        }
        sun.getR().negate();
        sun.getV().negate();
    }

    private final void calcBodyAccelerations() {
        for (BodyGravCalc calc : this.curr.getBodies()) {
            calc.getA().setToZero();
            this.addAcceleration(calc.getA(), calc.getR(), this.curr.getGravitators()[Body.Sun.ordinal()].getR(), 2.959122082855911E-4);
            this.addAcceleration(calc.getA(), calc.getR(), this.curr.getGravitators()[Body.Mercury.ordinal()].getR(), 4.912547451450812E-11);
            this.addAcceleration(calc.getA(), calc.getR(), this.curr.getGravitators()[Body.Venus.ordinal()].getR(), 7.243452486162703E-10);
            this.addAcceleration(calc.getA(), calc.getR(), this.curr.getGravitators()[Body.Earth.ordinal()].getR(), 8.997011346712498E-10);
            this.addAcceleration(calc.getA(), calc.getR(), this.curr.getGravitators()[Body.Mars.ordinal()].getR(), 9.549535105779258E-11);
            this.addAcceleration(calc.getA(), calc.getR(), this.curr.getGravitators()[Body.Jupiter.ordinal()].getR(), 2.825345909524226E-7);
            this.addAcceleration(calc.getA(), calc.getR(), this.curr.getGravitators()[Body.Saturn.ordinal()].getR(), 8.459715185680659E-8);
            this.addAcceleration(calc.getA(), calc.getR(), this.curr.getGravitators()[Body.Uranus.ordinal()].getR(), 1.292024916781969E-8);
            this.addAcceleration(calc.getA(), calc.getR(), this.curr.getGravitators()[Body.Neptune.ordinal()].getR(), 1.524358900784276E-8);
        }
    }

    private final void addAcceleration(TerseVector acc, TerseVector smallPos, TerseVector majorPos, double gm) {
        double dx = majorPos.getX() - smallPos.getX();
        double dy = majorPos.getY() - smallPos.getY();
        double dz = majorPos.getZ() - smallPos.getZ();
        double r2 = dx * dx + dy * dy + dz * dz;
        double pull = gm / (r2 * Math.sqrt(r2));
        acc.setX(acc.getX() + dx * pull);
        acc.setY(acc.getY() + dy * pull);
        acc.setZ(acc.getZ() + dz * pull);
    }

    private final void duplicate() {
        int i;
        this.prev.setTime(this.curr.getTime());
        int n = this.curr.getGravitators().length;
        for (i = 0; i < n; ++i) {
            this.prev.getGravitators()[i].copyFrom(this.curr.getGravitators()[i]);
        }
        n = this.curr.getBodies().length;
        for (i = 0; i < n; ++i) {
            this.prev.getBodies()[i].copyFrom(this.curr.getBodies()[i]);
        }
    }
}

