/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.osmand.Location;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.QuadPointDouble;
import net.osmand.data.QuadRect;
import net.osmand.util.GeoParsedPoint;

public class MapUtils {
    public static final int ROUNDING_ERROR = 3;
    private static final int EARTH_RADIUS_B = 6356752;
    public static final int EARTH_RADIUS_A = 6378137;
    public static final double MIN_LATITUDE = -85.0511;
    public static final double MAX_LATITUDE = 85.0511;
    public static final double LATITUDE_TURN = 180.0;
    public static final double MIN_LONGITUDE = -180.0;
    public static final double MAX_LONGITUDE = 180.0;
    public static final double LONGITUDE_TURN = 360.0;
    public static final double DEFAULT_LATLON_PRECISION = 1.0E-5;
    public static final double HIGH_LATLON_PRECISION = 1.0E-7;
    public static final double METERS_IN_DEGREE = 111320.0;
    private static final String BASE_SHORT_OSM_URL = "https://openstreetmap.org/go/";
    private static final char[] intToBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '~'};
    public static final int EQUATOR = 0x40000000;
    public static int PRECISION_ZOOM = 14;
    private static final TIntObjectHashMap<Double> DIST_CACHE = new TIntObjectHashMap();

    public static int calculateFromBaseZoomPrecisionXY(int baseZoom, int finalZoom, int xFinal, int yFinal) {
        int px = xFinal;
        int py = yFinal;
        int precisionNumber = 1;
        for (int zoom = finalZoom - 1; zoom >= baseZoom; --zoom) {
            int x = px / 2;
            int y = py / 2;
            int deltax = px - x * 2;
            int deltay = py - y * 2;
            precisionNumber = (precisionNumber << 2) + (deltax << 1) + deltay;
            px = x;
            py = y;
        }
        return precisionNumber;
    }

    public static int[] calculateFinalXYFromBaseAndPrecisionXY(int bazeZoom, int finalZoom, int precisionXY, int xBase, int yBase, boolean ignoreNotEnoughPrecision) {
        int finalX = xBase;
        int finalY = yBase;
        int precisionCalc = precisionXY;
        for (int zoom = bazeZoom; zoom < finalZoom; ++zoom) {
            if (precisionCalc <= 1 && precisionCalc > 0 && !ignoreNotEnoughPrecision) {
                throw new IllegalArgumentException("Not enough bits to retrieve zoom approximation");
            }
            finalY = finalY * 2 + (precisionXY & 1);
            finalX = finalX * 2 + ((precisionXY & 2) >> 1);
            precisionXY >>= 2;
        }
        return new int[]{finalX, finalY};
    }

    public static double getDistance(LatLon l, double latitude, double longitude) {
        return MapUtils.getDistance(l.getLatitude(), l.getLongitude(), latitude, longitude);
    }

    public static double scalarMultiplication(double xA, double yA, double xB, double yB, double xC, double yC) {
        return (xB - xA) * (xC - xA) + (yB - yA) * (yC - yA);
    }

    public static Location calculateMidPoint(Location s1, Location s2) {
        double[] latLon = MapUtils.calculateMidPoint(s1.getLatitude(), s1.getLongitude(), s2.getLatitude(), s2.getLongitude());
        return new Location("", latLon[0], latLon[1]);
    }

    public static LatLon calculateMidPoint(LatLon s1, LatLon s2) {
        double[] latLon = MapUtils.calculateMidPoint(s1.getLatitude(), s1.getLongitude(), s2.getLatitude(), s2.getLongitude());
        return new LatLon(latLon[0], latLon[1]);
    }

    public static double[] calculateMidPoint(double firstLat, double firstLon, double secondLat, double secondLon) {
        double lat1 = firstLat / 180.0 * Math.PI;
        double lon1 = firstLon / 180.0 * Math.PI;
        double lat2 = secondLat / 180.0 * Math.PI;
        double lon2 = secondLon / 180.0 * Math.PI;
        double Bx = Math.cos(lat2) * Math.cos(lon2 - lon1);
        double By = Math.cos(lat2) * Math.sin(lon2 - lon1);
        double latMid = Math.atan2(Math.sin(lat1) + Math.sin(lat2), Math.sqrt((Math.cos(lat1) + Bx) * (Math.cos(lat1) + Bx) + By * By));
        double lonMid = lon1 + Math.atan2(By, Math.cos(lat1) + Bx);
        return new double[]{MapUtils.checkLatitude(latMid * 180.0 / Math.PI), MapUtils.checkLongitude(lonMid * 180.0 / Math.PI)};
    }

    public static LatLon calculateIntermediatePoint(double fromLat, double fromLon, double toLat, double toLon, double coeff) {
        double lat1 = MapUtils.toRadians(fromLat);
        double lon1 = MapUtils.toRadians(fromLon);
        double lat2 = MapUtils.toRadians(toLat);
        double lon2 = MapUtils.toRadians(toLon);
        double lat1Cos = Math.cos(lat1);
        double lat2Cos = Math.cos(lat2);
        double d = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat1 - lat2) / 2.0), 2.0) + lat1Cos * lat2Cos * Math.pow(Math.sin((lon1 - lon2) / 2.0), 2.0)));
        double A = Math.sin((1.0 - coeff) * d) / Math.sin(d);
        double B = Math.sin(coeff * d) / Math.sin(d);
        double x = A * lat1Cos * Math.cos(lon1) + B * lat2Cos * Math.cos(lon2);
        double y = A * lat1Cos * Math.sin(lon1) + B * lat2Cos * Math.sin(lon2);
        double z = A * Math.sin(lat1) + B * Math.sin(lat2);
        double lat = Math.atan2(z, Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0)));
        double lon = Math.atan2(y, x);
        return new LatLon(MapUtils.checkLatitude(lat * 180.0 / Math.PI), MapUtils.checkLongitude(lon * 180.0 / Math.PI));
    }

    public static double getOrthogonalDistance(double lat, double lon, double fromLat, double fromLon, double toLat, double toLon) {
        return MapUtils.getDistance(MapUtils.getProjection(lat, lon, fromLat, fromLon, toLat, toLon), lat, lon);
    }

    public static LatLon getProjection(double lat, double lon, double fromLat, double fromLon, double toLat, double toLon) {
        double prlon;
        double prlat;
        double mDist = (fromLat - toLat) * (fromLat - toLat) + (fromLon - toLon) * (fromLon - toLon);
        double projection = MapUtils.scalarMultiplication(fromLat, fromLon, toLat, toLon, lat, lon);
        if (projection < 0.0) {
            prlat = fromLat;
            prlon = fromLon;
        } else if (projection >= mDist) {
            prlat = toLat;
            prlon = toLon;
        } else {
            prlat = fromLat + (toLat - fromLat) * (projection / mDist);
            prlon = fromLon + (toLon - fromLon) * (projection / mDist);
        }
        return new LatLon(prlat, prlon);
    }

    public static double getProjectionCoeff(double lat, double lon, double fromLat, double fromLon, double toLat, double toLon) {
        double mDist = (fromLat - toLat) * (fromLat - toLat) + (fromLon - toLon) * (fromLon - toLon);
        double projection = MapUtils.scalarMultiplication(fromLat, fromLon, toLat, toLon, lat, lon);
        if (projection < 0.0) {
            return 0.0;
        }
        if (projection >= mDist) {
            return 1.0;
        }
        return projection / mDist;
    }

    private static double toRadians(double angdeg) {
        return angdeg / 180.0 * Math.PI;
    }

    public static double getDistance(double lat1, double lon1, double lat2, double lon2) {
        double R = 6372.8;
        double dLat = MapUtils.toRadians(lat2 - lat1);
        double dLon = MapUtils.toRadians(lon2 - lon1);
        double sinHalfLat = Math.sin(dLat / 2.0);
        double sinHalfLon = Math.sin(dLon / 2.0);
        double a = sinHalfLat * sinHalfLat + Math.cos(MapUtils.toRadians(lat1)) * Math.cos(MapUtils.toRadians(lat2)) * sinHalfLon * sinHalfLon;
        return 2.0 * R * 1000.0 * Math.asin(Math.sqrt(a));
    }

    public static double getDistance(LatLon l1, LatLon l2) {
        return MapUtils.getDistance(l1.getLatitude(), l1.getLongitude(), l2.getLatitude(), l2.getLongitude());
    }

    public static double getDistance(Location l1, Location l2) {
        return MapUtils.getDistance(l1.getLatitude(), l1.getLongitude(), l2.getLatitude(), l2.getLongitude());
    }

    public static double checkLongitude(double longitude) {
        if (longitude >= -180.0 && longitude <= 180.0) {
            return longitude;
        }
        while (longitude <= -180.0 || longitude > 180.0) {
            if (longitude < 0.0) {
                longitude += 360.0;
                continue;
            }
            longitude -= 360.0;
        }
        return longitude;
    }

    public static double checkLatitude(double latitude) {
        if (latitude >= -85.0511 && latitude <= 85.0511) {
            return latitude;
        }
        while (latitude < -90.0 || latitude > 90.0) {
            if (latitude < 0.0) {
                latitude += 180.0;
                continue;
            }
            latitude -= 180.0;
        }
        if (latitude < -85.0511) {
            return -85.0511;
        }
        if (latitude > 85.0511) {
            return 85.0511;
        }
        return latitude;
    }

    public static int get31TileNumberX(double longitude) {
        longitude = MapUtils.checkLongitude(longitude);
        long l = 0x80000000L;
        return (int)((longitude + 180.0) / 360.0 * (double)l);
    }

    public static int get31TileNumberY(double latitude) {
        latitude = MapUtils.checkLatitude(latitude);
        double eval = Math.log(Math.tan(MapUtils.toRadians(latitude)) + 1.0 / Math.cos(MapUtils.toRadians(latitude)));
        long l = 0x80000000L;
        if (eval > Math.PI) {
            eval = Math.PI;
        }
        return (int)((1.0 - eval / Math.PI) / 2.0 * (double)l);
    }

    public static double get31LongitudeX(int tileX) {
        return MapUtils.getLongitudeFromTile(21.0, (double)tileX / 1024.0);
    }

    public static double get31LatitudeY(int tileY) {
        return MapUtils.getLatitudeFromTile(21.0f, (double)tileY / 1024.0);
    }

    public static double getTileNumberX(float zoom, double longitude) {
        double powZoom;
        double dz = ((longitude = MapUtils.checkLongitude(longitude)) + 180.0) / 360.0 * (powZoom = MapUtils.getPowZoom(zoom));
        if (dz >= powZoom) {
            return powZoom - 0.01;
        }
        return dz;
    }

    public static double getTileNumberY(float zoom, double latitude) {
        double eval = Math.log(Math.tan(MapUtils.toRadians(latitude = MapUtils.checkLatitude(latitude))) + 1.0 / Math.cos(MapUtils.toRadians(latitude)));
        if (Double.isInfinite(eval) || Double.isNaN(eval)) {
            latitude = latitude < 0.0 ? -89.9 : 89.9;
            eval = Math.log(Math.tan(MapUtils.toRadians(latitude)) + 1.0 / Math.cos(MapUtils.toRadians(latitude)));
        }
        return (1.0 - eval / Math.PI) / 2.0 * MapUtils.getPowZoom(zoom);
    }

    public static double getTileEllipsoidNumberY(float zoom, double latitude) {
        double E2 = latitude * Math.PI / 180.0;
        long sradiusa = 6378137L;
        long sradiusb = 6356752L;
        double J2 = Math.sqrt(2.72335601265E11) / 6378137.0;
        double M2 = Math.log((1.0 + Math.sin(E2)) / (1.0 - Math.sin(E2))) / 2.0 - J2 * Math.log((1.0 + J2 * Math.sin(E2)) / (1.0 - J2 * Math.sin(E2))) / 2.0;
        double B2 = MapUtils.getPowZoom(zoom);
        return B2 / 2.0 - M2 * B2 / 2.0 / Math.PI;
    }

    public static double[] getTileEllipsoidNumberAndOffsetY(int zoom, double latitude, int tileSize) {
        double E2 = latitude * Math.PI / 180.0;
        long sradiusa = 6378137L;
        long sradiusb = 6356752L;
        double J2 = Math.sqrt(2.72335601265E11) / 6378137.0;
        double M2 = Math.log((1.0 + Math.sin(E2)) / (1.0 - Math.sin(E2))) / 2.0 - J2 * Math.log((1.0 + J2 * Math.sin(E2)) / (1.0 - J2 * Math.sin(E2))) / 2.0;
        double B2 = MapUtils.getPowZoom(zoom);
        double tileY = B2 / 2.0 - M2 * B2 / 2.0 / Math.PI;
        double tilesCount = 1 << zoom;
        double yTileNumber = Math.floor(tilesCount * (0.5 - M2 / 2.0 / Math.PI));
        double offsetY = Math.floor((tilesCount * (0.5 - M2 / 2.0 / Math.PI) - yTileNumber) * (double)tileSize);
        return new double[]{tileY, offsetY};
    }

    public static double getLatitudeFromEllipsoidTileY(float zoom, float tileNumberY) {
        double MerkElipsK = 1.0E-7;
        long sradiusa = 6378137L;
        long sradiusb = 6356752L;
        double FExct = Math.sqrt(2.72335601265E11) / 6378137.0;
        double TilesAtZoom = MapUtils.getPowZoom(zoom);
        double result = ((double)tileNumberY - TilesAtZoom / 2.0) / -(TilesAtZoom / (Math.PI * 2));
        result = (2.0 * Math.atan(Math.exp(result)) - 1.5707963267948966) * 180.0 / Math.PI;
        double Zu = result / 57.29577951308232;
        double yy = (double)tileNumberY - TilesAtZoom / 2.0;
        double Zum1 = Zu;
        Zu = Math.asin(1.0 - (1.0 + Math.sin(Zum1)) * Math.pow(1.0 - FExct * Math.sin(Zum1), FExct) / (Math.exp(2.0 * yy / -(TilesAtZoom / (Math.PI * 2))) * Math.pow(1.0 + FExct * Math.sin(Zum1), FExct)));
        while (Math.abs(Zum1 - Zu) >= 1.0E-7) {
            Zum1 = Zu;
            Zu = Math.asin(1.0 - (1.0 + Math.sin(Zum1)) * Math.pow(1.0 - FExct * Math.sin(Zum1), FExct) / (Math.exp(2.0 * yy / -(TilesAtZoom / (Math.PI * 2))) * Math.pow(1.0 + FExct * Math.sin(Zum1), FExct)));
        }
        return Zu * 180.0 / Math.PI;
    }

    public static double getTileDistanceWidth(float zoom) {
        return MapUtils.getTileDistanceWidth(30.0, zoom);
    }

    public static double getTileDistanceWidth(double lat, float zoom) {
        LatLon ll = new LatLon(lat, MapUtils.getLongitudeFromTile(zoom, 0.0));
        LatLon ll2 = new LatLon(lat, MapUtils.getLongitudeFromTile(zoom, 1.0));
        return MapUtils.getDistance(ll, ll2);
    }

    public static double getTileDistanceHeight(double lat, float zoom) {
        double y = MapUtils.getTileNumberY(zoom, lat);
        LatLon ll = new LatLon(MapUtils.getLatitudeFromTile(zoom, Math.floor(y)), 0.0);
        LatLon ll2 = new LatLon(MapUtils.getLatitudeFromTile(zoom, Math.floor(y) + 1.0), 0.0);
        return MapUtils.getDistance(ll, ll2);
    }

    public static double getLongitudeFromTile(double zoom, double x) {
        return x / MapUtils.getPowZoom(zoom) * 360.0 - 180.0;
    }

    public static double getPowZoom(double zoom) {
        if (zoom >= 0.0 && zoom - Math.floor(zoom) < (double)0.001f) {
            return 1 << (int)zoom;
        }
        return Math.pow(2.0, zoom);
    }

    public static float calcDiffPixelX(float rotateSin, float rotateCos, float dTileX, float dTileY, float tileSize) {
        return (rotateCos * dTileX - rotateSin * dTileY) * tileSize;
    }

    public static float calcDiffPixelY(float rotateSin, float rotateCos, float dTileX, float dTileY, float tileSize) {
        return (rotateSin * dTileX + rotateCos * dTileY) * tileSize;
    }

    public static double getLatitudeFromTile(float zoom, double y) {
        int sign = y < 0.0 ? -1 : 1;
        return Math.atan((double)sign * Math.sinh(Math.PI * (1.0 - 2.0 * y / MapUtils.getPowZoom(zoom)))) * 180.0 / Math.PI;
    }

    public static int getPixelShiftX(float zoom, double long1, double long2, double tileSize) {
        return (int)((MapUtils.getTileNumberX(zoom, long1) - MapUtils.getTileNumberX(zoom, long2)) * tileSize);
    }

    public static int getPixelShiftY(float zoom, double lat1, double lat2, double tileSize) {
        return (int)((MapUtils.getTileNumberY(zoom, lat1) - MapUtils.getTileNumberY(zoom, lat2)) * tileSize);
    }

    public static void sortListOfMapObject(List<? extends MapObject> list, final double lat, final double lon) {
        Collections.sort(list, new Comparator<MapObject>(){

            @Override
            public int compare(MapObject o1, MapObject o2) {
                return Double.compare(MapUtils.getDistance(o1.getLocation(), lat, lon), MapUtils.getDistance(o2.getLocation(), lat, lon));
            }
        });
    }

    public static String buildGeoUrl(String latitude, String longitude, int zoom) {
        return "geo:" + latitude + "," + longitude + "?z=" + zoom;
    }

    public static String buildShortOsmUrl(double latitude, double longitude, int zoom) {
        return BASE_SHORT_OSM_URL + MapUtils.createShortLinkString(latitude, longitude, zoom) + "?m";
    }

    public static String createShortLinkString(double latitude, double longitude, int zoom) {
        long lat = (long)((latitude + 90.0) / 180.0 * 4.294967296E9);
        long lon = (long)((longitude + 180.0) / 360.0 * 4.294967296E9);
        long code = MapUtils.interleaveBits(lon, lat);
        Object str = "";
        int i = 0;
        while ((double)i < Math.ceil((double)(zoom + 8) / 3.0)) {
            str = (String)str + intToBase64[(int)(code >> 58 - 6 * i & 0x3FL)];
            ++i;
        }
        for (int j = 0; j < (zoom + 8) % 3; ++j) {
            str = (String)str + "-";
        }
        return str;
    }

    public static GeoParsedPoint decodeShortLinkString(String s) {
        s = s.replaceAll("@", "~");
        int i = 0;
        long x = 0L;
        long y = 0L;
        int z = -8;
        for (i = 0; i < s.length(); ++i) {
            int j;
            int digit = -1;
            char c = s.charAt(i);
            for (j = 0; j < intToBase64.length; ++j) {
                if (c != intToBase64[j]) continue;
                digit = j;
                break;
            }
            if (digit < 0 || digit < 0) break;
            x <<= 3;
            y <<= 3;
            for (j = 2; j >= 0; --j) {
                x |= (long)((digit & 1 << j + j + 1) == 0 ? 0 : 1 << j);
                y |= (long)((digit & 1 << j + j) == 0 ? 0 : 1 << j);
            }
            z += 3;
        }
        double lon = (double)x * Math.pow(2.0, 2 - 3 * i) * 90.0 - 180.0;
        double lat = (double)y * Math.pow(2.0, 2 - 3 * i) * 45.0 - 90.0;
        if (i < s.length() && s.charAt(i) == '-') {
            z -= 2;
            if (i + 1 < s.length() && s.charAt(i + 1) == '-') {
                ++z;
            }
        }
        return new GeoParsedPoint(lat, lon, z);
    }

    public static QuadRect decodeShortLinkToQuadRect(String shortLink) {
        GeoParsedPoint point = MapUtils.decodeShortLinkString(shortLink);
        double bottom = point.getLatitude();
        double left = point.getLongitude();
        int precision = 0;
        String base64chars = new String(intToBase64);
        for (int i = 0; i < shortLink.length(); ++i) {
            if (base64chars.indexOf(shortLink.charAt(i)) <= 0) continue;
            ++precision;
        }
        double factor = Math.pow(2.0, 2 - 3 * precision);
        double deltaLon = factor * 90.0;
        double deltaLat = factor * 45.0;
        double top = bottom + deltaLat;
        double right = left + deltaLon;
        return new QuadRect(left, top, right, bottom);
    }

    public static long interleaveBits(long x, long y) {
        long c = 0L;
        for (int b = 31; b >= 0; b = (int)((byte)(b - 1))) {
            c = c << 1 | x >> b & 1L;
            c = c << 1 | y >> b & 1L;
        }
        return c;
    }

    public static float unifyRotationDiff(float rotate, float targetRotate) {
        float d;
        for (d = targetRotate - rotate; d >= 180.0f; d -= 360.0f) {
        }
        while (d < -180.0f) {
            d += 360.0f;
        }
        return d;
    }

    public static float unifyRotationTo360(float rotate) {
        while (rotate < -180.0f) {
            rotate += 360.0f;
        }
        while (rotate > 180.0f) {
            rotate -= 360.0f;
        }
        return rotate;
    }

    public static float normalizeDegrees360(float degrees) {
        while (degrees < 0.0f) {
            degrees += 360.0f;
        }
        while (degrees >= 360.0f) {
            degrees -= 360.0f;
        }
        return degrees;
    }

    public static double alignAngleDifference(double diff) {
        while (diff > Math.PI) {
            diff -= Math.PI * 2;
        }
        while (diff <= -Math.PI) {
            diff += Math.PI * 2;
        }
        return diff;
    }

    public static double degreesDiff(double a1, double a2) {
        double diff;
        for (diff = a1 - a2; diff > 180.0; diff -= 360.0) {
        }
        while (diff <= -180.0) {
            diff += 360.0;
        }
        return diff;
    }

    public static QuadPointDouble getProjectionPoint31(int px, int py, int st31x, int st31y, int end31x, int end31y) {
        double tWidth = MapUtils.getTileWidth(py);
        double projection = (double)(end31x - st31x) * tWidth * (double)(px - st31x) * tWidth + (double)(end31y - st31y) * tWidth * (double)(py - st31y) * tWidth;
        double mDist = MapUtils.squareRootDist31(end31x, end31y, st31x, st31y);
        double pry = end31y;
        double prx = end31x;
        if (projection < 0.0) {
            prx = st31x;
            pry = st31y;
        } else if (projection >= mDist * mDist) {
            prx = end31x;
            pry = end31y;
        } else {
            prx = (double)st31x + (double)(end31x - st31x) * (projection / (mDist * mDist));
            pry = (double)st31y + (double)(end31y - st31y) * (projection / (mDist * mDist));
        }
        return new QuadPointDouble(prx, pry);
    }

    public static double squareRootDist31(int x1, int y1, int x2, int y2) {
        return Math.sqrt(MapUtils.squareDist31TileMetric(x1, y1, x2, y2));
    }

    public static double measuredDist31(int x1, int y1, int x2, int y2) {
        return MapUtils.getDistance(MapUtils.get31LatitudeY(y1), MapUtils.get31LongitudeX(x1), MapUtils.get31LatitudeY(y2), MapUtils.get31LongitudeX(x2));
    }

    public static double squareDist31TileMetric(int x1, int y1, int x2, int y2) {
        boolean top2;
        boolean top1 = y1 > 0x40000000;
        boolean bl = top2 = y2 > 0x40000000;
        if (top1 != top2 && y1 != 0x40000000 && y2 != 0x40000000) {
            int mx = x1 + (int)((double)(x2 - x1) * (double)(0x40000000 - y1) / (double)(y2 - y1));
            double d1 = Math.sqrt(MapUtils.squareDist31TileMetric(mx, 0x40000000, x2, y2));
            double d2 = Math.sqrt(MapUtils.squareDist31TileMetric(mx, 0x40000000, x1, y1));
            return (d1 + d2) * (d1 + d2);
        }
        int ymidx = y1 / 2 + y2 / 2;
        double tw = MapUtils.getTileWidth(ymidx);
        double dy = (double)(y1 - y2) * tw;
        double dx = (double)(x2 - x1) * tw;
        return dx * dx + dy * dy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static double getTileWidth(int y31) {
        Class<MapUtils> clazz;
        double y = (double)y31 / 1.0 / (double)(1 << 31 - PRECISION_ZOOM);
        int tileY = (int)y;
        double ry = y - (double)tileY;
        Double d = null;
        Double dp = null;
        try {
            d = (Double)DIST_CACHE.get(tileY);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (d == null) {
            clazz = MapUtils.class;
            // MONITORENTER : net.osmand.util.MapUtils.class
            d = MapUtils.getTileDistanceWidth(MapUtils.get31LatitudeY(tileY << 31 - PRECISION_ZOOM), PRECISION_ZOOM) / (double)(1 << 31 - PRECISION_ZOOM);
            DIST_CACHE.put(tileY, (Object)d);
            // MONITOREXIT : clazz
        }
        ++tileY;
        try {
            dp = (Double)DIST_CACHE.get(tileY);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (dp != null) return ry * dp + (1.0 - ry) * d;
        clazz = MapUtils.class;
        // MONITORENTER : net.osmand.util.MapUtils.class
        dp = MapUtils.getTileDistanceWidth(MapUtils.get31LatitudeY(tileY << 31 - PRECISION_ZOOM), PRECISION_ZOOM) / (double)(1 << 31 - PRECISION_ZOOM);
        DIST_CACHE.put(tileY, (Object)dp);
        // MONITOREXIT : clazz
        return ry * dp + (1.0 - ry) * d;
    }

    public static boolean rightSide(double lat, double lon, double aLat, double aLon, double bLat, double bLon) {
        double ax = aLon - lon;
        double by = bLat - lat;
        double bx = bLon - lon;
        double ay = aLat - lat;
        double sa = ax * by - bx * ay;
        return sa < 0.0;
    }

    public static long deinterleaveY(long coord) {
        long x = 0L;
        for (int b = 31; b >= 0; b = (int)((byte)(b - 1))) {
            x = x << 1 | 1L & coord >> b * 2;
        }
        return x;
    }

    public static long deinterleaveX(long coord) {
        long x = 0L;
        for (int b = 31; b >= 0; b = (int)((byte)(b - 1))) {
            x = x << 1 | 1L & coord >> b * 2 + 1;
        }
        return x;
    }

    public static QuadRect calculateLatLonBbox(double latitude, double longitude, int radiusMeters) {
        int zoom = 16;
        float coeff = (float)((double)radiusMeters / MapUtils.getTileDistanceWidth(zoom));
        double tx = MapUtils.getTileNumberX(zoom, longitude);
        double ty = MapUtils.getTileNumberY(zoom, latitude);
        double topLeftX = Math.max(0.0, tx - (double)coeff);
        double topLeftY = Math.max(0.0, ty - (double)coeff);
        int max = (1 << zoom) - 1;
        double bottomRightX = Math.min((double)max, tx + (double)coeff);
        double bottomRightY = Math.min((double)max, ty + (double)coeff);
        double pw = MapUtils.getPowZoom(31 - zoom);
        QuadRect rect = new QuadRect(topLeftX * pw, topLeftY * pw, bottomRightX * pw, bottomRightY * pw);
        rect.left = MapUtils.get31LongitudeX((int)rect.left);
        rect.top = MapUtils.get31LatitudeY((int)rect.top);
        rect.right = MapUtils.get31LongitudeX((int)rect.right);
        rect.bottom = MapUtils.get31LatitudeY((int)rect.bottom);
        return rect;
    }

    public static float getInterpolatedY(float x1, float y1, float x2, float y2, float x) {
        float a = y1 - y2;
        float b = x2 - x1;
        float d = -a * b;
        if (d != 0.0f) {
            float c1 = y2 * x1 - x2 * y1;
            float c2 = x * (y2 - y1);
            return a * (c1 - c2) / d;
        }
        return y1;
    }

    public static void insetLatLonRect(QuadRect r, double latitude, double longitude) {
        if (r.left == 0.0 && r.right == 0.0) {
            r.left = longitude;
            r.right = longitude;
            r.top = latitude;
            r.bottom = latitude;
        } else {
            r.left = Math.min(r.left, longitude);
            r.right = Math.max(r.right, longitude);
            r.top = Math.max(r.top, latitude);
            r.bottom = Math.min(r.bottom, latitude);
        }
    }

    public static boolean areLatLonEqual(Location l1, Location l2) {
        return l1 == null && l2 == null || l2 != null && MapUtils.areLatLonEqual(l1, l2.getLatitude(), l2.getLongitude());
    }

    public static boolean areLatLonEqual(Location l1, Location l2, double precision) {
        return l1 == null && l2 == null || l1 != null && l2 != null && MapUtils.areLatLonEqual(l1.getLatitude(), l1.getLongitude(), l2.getLatitude(), l2.getLongitude(), precision);
    }

    public static boolean areLatLonEqual(Location l, double lat, double lon) {
        return l != null && MapUtils.areLatLonEqual(l.getLatitude(), l.getLongitude(), lat, lon);
    }

    public static boolean areLatLonEqual(LatLon l1, LatLon l2) {
        return l1 == null && l2 == null || l2 != null && MapUtils.areLatLonEqual(l1, l2.getLatitude(), l2.getLongitude());
    }

    public static boolean areLatLonEqual(LatLon l, double lat, double lon) {
        return l != null && MapUtils.areLatLonEqual(l.getLatitude(), l.getLongitude(), lat, lon);
    }

    public static boolean areLatLonEqual(double lat1, double lon1, double lat2, double lon2) {
        return MapUtils.areLatLonEqual(lat1, lon1, lat2, lon2, 1.0E-5);
    }

    public static boolean areLatLonEqual(LatLon l1, LatLon l2, double precision) {
        return l1 == null && l2 == null || l1 != null && l2 != null && MapUtils.areLatLonEqual(l1.getLatitude(), l1.getLongitude(), l2.getLatitude(), l2.getLongitude(), precision);
    }

    public static boolean areLatLonEqual(double lat1, double lon1, double lat2, double lon2, double precision) {
        return Math.abs(lat1 - lat2) < precision && Math.abs(lon1 - lon2) < precision;
    }

    public static LatLon rhumbDestinationPoint(LatLon latLon, double distance, double bearing) {
        return MapUtils.rhumbDestinationPoint(latLon.getLatitude(), latLon.getLongitude(), distance, bearing);
    }

    public static LatLon rhumbDestinationPoint(double lat, double lon, double distance, double bearing) {
        double radius = 6378137.0;
        double d = distance / radius;
        double phi1 = Math.toRadians(lat);
        double lambda1 = Math.toRadians(lon);
        double theta = Math.toRadians(bearing);
        double deltaPhi = d * Math.cos(theta);
        double phi2 = phi1 + deltaPhi;
        double deltaPsi = Math.log(Math.tan(phi2 / 2.0 + 0.7853981633974483) / Math.tan(phi1 / 2.0 + 0.7853981633974483));
        double q = Math.abs(deltaPsi) > 1.0E-11 ? deltaPhi / deltaPsi : Math.cos(phi1);
        double deltalambda = d * Math.sin(theta) / q;
        double lambda2 = lambda1 + deltalambda;
        return new LatLon(Math.toDegrees(phi2), Math.toDegrees(lambda2));
    }

    public static double getSqrtDistance(int startX, int startY, int endX, int endY) {
        return Math.sqrt((double)(endX - startX) * (double)(endX - startX) + (double)(endY - startY) * (double)(endY - startY));
    }

    public static double getSqrtDistance(float startX, float startY, float endX, float endY) {
        return Math.sqrt((endX - startX) * (endX - startX) + (endY - startY) * (endY - startY));
    }

    public static String convertDistToChar(int dist, char firstLetter, int firstDist, int mult1, int mult2) {
        int iteration = 0;
        while (dist - firstDist > 0) {
            firstDist *= ++iteration % 2 == 1 ? mult1 : mult2;
        }
        return String.valueOf((char)(firstLetter + iteration));
    }

    public static int convertCharToDist(char ch, char firstLetter, int firstDist, int mult1, int mult2) {
        int dist = firstDist;
        for (int iteration = 1; iteration < ch - firstLetter + 1; ++iteration) {
            dist *= iteration % 2 == 1 ? mult1 : mult2;
        }
        return dist;
    }

    public static void inflateBBox31(QuadRect bbox, int dx, int dy) {
        if (bbox.left <= bbox.right) {
            bbox.left -= (double)dx;
            bbox.right += (double)dx;
        } else {
            bbox.left += (double)dx;
            bbox.right -= (double)dx;
        }
        if (bbox.top <= bbox.bottom) {
            bbox.top -= (double)dy;
            bbox.bottom += (double)dy;
        } else {
            bbox.top += (double)dy;
            bbox.bottom -= (double)dy;
        }
        int INT31_MAX = Integer.MAX_VALUE;
        bbox.top = Math.min(Math.max(0.0, bbox.top), (double)INT31_MAX);
        bbox.left = Math.min(Math.max(0.0, bbox.left), (double)INT31_MAX);
        bbox.right = Math.min(Math.max(0.0, bbox.right), (double)INT31_MAX);
        bbox.bottom = Math.min(Math.max(0.0, bbox.bottom), (double)INT31_MAX);
    }

    public static void inflateBBoxLatLon(QuadRect bbox, double dx, double dy) {
        if (bbox.left <= bbox.right) {
            bbox.left -= dx;
            bbox.right += dx;
        } else {
            bbox.left += dx;
            bbox.right -= dx;
        }
        if (bbox.top >= bbox.bottom) {
            bbox.top += dy;
            bbox.bottom -= dy;
        } else {
            bbox.top -= dy;
            bbox.bottom += dy;
        }
        bbox.left = Math.max(-180.0, Math.min(180.0, bbox.left));
        bbox.right = Math.max(-180.0, Math.min(180.0, bbox.right));
        bbox.top = Math.max(-90.0, Math.min(90.0, bbox.top));
        bbox.bottom = Math.max(-90.0, Math.min(90.0, bbox.bottom));
    }
}

