/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import gnu.trove.list.array.TIntArrayList;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import net.osmand.NativeJavaRendering;
import net.osmand.NativeLibrary;
import net.osmand.PlatformUtil;
import net.osmand.data.DataTileManager;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Way;
import net.osmand.router.network.NetworkRouteContext;
import net.osmand.router.network.NetworkRouteSelector;
import net.osmand.shared.gpx.GpxFile;
import net.osmand.shared.gpx.primitives.Track;
import net.osmand.shared.gpx.primitives.TrkSegment;
import net.osmand.shared.gpx.primitives.WptPt;
import net.osmand.swing.DataExtractionSettings;
import net.osmand.swing.MapInformationLayer;
import net.osmand.swing.MapPanel;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class MapPanelSelector {
    protected static final Log log = PlatformUtil.getLog(MapPanelSelector.class);
    private static final boolean LOAD_ROUTE_BBOX = true;
    private static final boolean LOAD_ROUTE_POI_RADIUS_BBOX = false;
    private final MapPanel panel;
    private MapSelectionArea mapSelectionArea;
    private ThreadPoolExecutor threadPool;

    public MapPanelSelector(MapPanel panel) {
        this.panel = panel;
        this.mapSelectionArea = new MapSelectionArea();
        this.threadPool = new ThreadPoolExecutor(0, 1, 5L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));
    }

    public MapSelectionArea getSelectionArea() {
        return this.mapSelectionArea;
    }

    public void select(NativeJavaRendering.RenderingImageContext ctx, MouseEvent e) {
        if (this.panel.getNativeLibrary() == null) {
            return;
        }
        MapPanel mapPanel = this.panel;
        Objects.requireNonNull(mapPanel);
        MapPanel.NativeRendererRunnable rr = mapPanel.new MapPanel.NativeRendererRunnable(this.getWidth(), this.getHeight());
        int x = (int)((double)(rr.oleft - ctx.sleft) / MapUtils.getPowZoom((double)(31 - this.getZoom())) * this.getTileSize() + (double)e.getPoint().x);
        int y = (int)((double)(rr.otop - ctx.stop) / MapUtils.getPowZoom((double)(31 - this.getZoom())) * this.getTileSize() + (double)e.getPoint().y);
        System.out.println("Search objects at " + x + " " + y);
        NativeLibrary.RenderedObject[] ls = this.panel.getNativeLibrary().searchRenderedObjectsFromContext(ctx.context, x, y, true);
        DataTileManager points = new DataTileManager(6);
        if (ls != null && ls.length > 0) {
            for (NativeLibrary.RenderedObject o : ls) {
                System.out.println((o.isText() ? o.getName() : "Icon") + " " + o.getId() + " " + String.valueOf(o.getTags()) + " (" + String.valueOf(o.getBbox()) + ")  order = " + o.getOrder() + " visible = " + o.isVisible());
                if (!o.isVisible()) continue;
                if (o.getX().size() > 1) {
                    List keys = NetworkRouteSelector.getRouteKeys((Map)o.getTags());
                    if (keys.size() > 0) {
                        try {
                            this.createMenu(o, e.getX(), e.getY()).show(this.panel, e.getX(), e.getY());
                        }
                        catch (IOException e1) {
                            log.error((Object)e1.getMessage(), (Throwable)e1);
                        }
                    }
                    Way way = new Way(-1L);
                    TIntArrayList x1 = o.getX();
                    TIntArrayList y1 = o.getY();
                    for (int i = 0; i < x1.size(); ++i) {
                        double lat = MapUtils.get31LatitudeY((int)y1.get(i));
                        double lon = MapUtils.get31LongitudeX((int)x1.get(i));
                        Node n = new Node(lat, lon, -1L);
                        way.addNode(n);
                    }
                    LatLon wayCenter = way.getLatLon();
                    points.registerObject(wayCenter.getLatitude(), wayCenter.getLongitude(), (Object)way);
                    continue;
                }
                LatLon n = o.getLabelLatLon();
                if (n == null) {
                    n = o.getLocation();
                }
                if (n == null) continue;
                Node nt = new Node(n.getLatitude(), n.getLongitude(), -1L);
                points.registerObject(n.getLatitude(), n.getLongitude(), (Object)nt);
            }
        }
        this.panel.setPoints((DataTileManager<Entity>)points);
        this.panel.repaint();
    }

    private JPopupMenu createMenu(final NativeLibrary.RenderedObject renderedObject, int x, int y) throws IOException {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new JLabel("Select route"));
        final NetworkRouteSelector.NetworkRouteSelectorFilter f = new NetworkRouteSelector.NetworkRouteSelectorFilter();
        final NetworkRouteSelector routeSelector = new NetworkRouteSelector(DataExtractionSettings.getSettings().getObfReaders(), f, null);
        final QuadRect latLonBBox = this.panel.getLatLonBBox();
        final Map routeMap = routeSelector.getRoutes(latLonBBox, false, null);
        Set routeKeys = routeMap.keySet();
        for (final NetworkRouteSelector.RouteKey routeKey : routeKeys) {
            menu.add(new AbstractAction(routeKey.tags.toString()){
                private static final long serialVersionUID = 8970133073749840163L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MapPanelSelector.this.threadPool.submit(() -> {
                        try {
                            Map<NetworkRouteSelector.RouteKey, GpxFile> routes;
                            long tms = System.currentTimeMillis();
                            if (routeMap == null || routeMap.get(routeKey) == null) {
                                System.out.println("Start loading " + String.valueOf(routeKey2.tags));
                                Map res = routeSelector.getRoutes(latLonBBox, true, routeKey);
                                routes = Collections.singletonMap(routeKey, (GpxFile)res.get(routeKey));
                            } else {
                                routes = Collections.singletonMap(routeKey, (GpxFile)routeMap.get(routeKey));
                            }
                            NetworkRouteContext.NetworkRouteContextStats stats = routeSelector.getNetworkRouteContext().getStats();
                            String msg = String.format("Load route after %.1f s: loaded %d tiles, %d routes, time %.1f s", (double)(System.currentTimeMillis() - tms) / 1000.0, stats.loadedTiles, stats.loadedRoutes, (double)stats.loadTimeNs / 1.0E9);
                            System.out.println(msg);
                            MapPanelSelector.this.drawGpxFiles(routes.values());
                        }
                        catch (Exception e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    });
                }
            });
        }
        return menu;
    }

    private void drawGpxFiles(Collection<GpxFile> files) {
        DataTileManager points = new DataTileManager(4);
        ArrayList<Way> ways = new ArrayList<Way>();
        for (GpxFile file : files) {
            for (Track track : file.getTracks()) {
                for (TrkSegment segment : track.getSegments()) {
                    Way w = new Way(-1L);
                    Node last = null;
                    Node first = null;
                    for (WptPt point : segment.getPoints()) {
                        last = new Node(point.getLat(), point.getLon(), -1L);
                        if (first == null) {
                            first = last;
                        }
                        w.addNode(last);
                    }
                    if (first == null) continue;
                    ways.add(w);
                    LatLon n = w.getLatLon();
                    points.registerObject(n.getLatitude(), n.getLongitude(), (Object)w);
                    first = new Node(first.getLatitude() + Math.random() * 5.0E-5, first.getLongitude(), -1L);
                    last = new Node(last.getLatitude() + Math.random() * 5.0E-5, last.getLongitude(), -1L);
                    first.putTag("colour", "green");
                    points.registerObject(first.getLatitude(), first.getLongitude(), (Object)first);
                    last.putTag("colour", "red");
                    points.registerObject(last.getLatitude(), last.getLongitude(), (Object)last);
                }
            }
            this.panel.setPoints((DataTileManager<Entity>)points);
        }
    }

    private int getHeight() {
        return this.panel.getHeight();
    }

    public int getWidth() {
        return this.panel.getWidth();
    }

    public double getTileSize() {
        return this.panel.getTileSize();
    }

    public double getYTile() {
        return this.panel.getYTile();
    }

    public double getXTile() {
        return this.panel.getXTile();
    }

    public int getZoom() {
        return this.panel.getZoom();
    }

    public double getLongitude() {
        return this.panel.getLongitude();
    }

    public double getLatitude() {
        return this.panel.getLatitude();
    }

    public double getMapDensity() {
        return this.panel.getMapDensity();
    }

    public class MapSelectionArea {
        private double lat1;
        private double lon1;
        private double lat2;
        private double lon2;

        public double getLat1() {
            return this.lat1;
        }

        public double getLat2() {
            return this.lat2;
        }

        public double getLon1() {
            return this.lon1;
        }

        public double getLon2() {
            return this.lon2;
        }

        public Rectangle getSelectedArea() {
            Rectangle r = new Rectangle();
            int zoom = MapPanelSelector.this.getZoom();
            r.x = MapPanelSelector.this.getWidth() / 2 + MapUtils.getPixelShiftX((float)((float)((double)zoom + Math.log(MapPanelSelector.this.getMapDensity()) / Math.log(2.0))), (double)this.lon1, (double)MapPanelSelector.this.getLongitude(), (double)MapPanelSelector.this.getTileSize());
            r.y = MapPanelSelector.this.getHeight() / 2 + MapUtils.getPixelShiftY((float)((float)((double)zoom + Math.log(MapPanelSelector.this.getMapDensity()) / Math.log(2.0))), (double)this.lat1, (double)MapPanelSelector.this.getLatitude(), (double)MapPanelSelector.this.getTileSize());
            r.width = MapPanelSelector.this.getWidth() / 2 + MapUtils.getPixelShiftX((float)((float)((double)zoom + Math.log(MapPanelSelector.this.getMapDensity()) / Math.log(2.0))), (double)this.lon2, (double)MapPanelSelector.this.getLongitude(), (double)MapPanelSelector.this.getTileSize()) - r.x;
            r.height = MapPanelSelector.this.getHeight() / 2 + MapUtils.getPixelShiftY((float)((float)((double)zoom + Math.log(MapPanelSelector.this.getMapDensity()) / Math.log(2.0))), (double)this.lat2, (double)MapPanelSelector.this.getLatitude(), (double)MapPanelSelector.this.getTileSize()) - r.y;
            return r;
        }

        public boolean isVisible() {
            if (this.lat1 == this.lat2 || this.lon1 == this.lon2) {
                return false;
            }
            Rectangle area = this.getSelectedArea();
            return area.width > 4 && area.height > 4;
        }

        public void setSelectedArea(int x1, int y1, int x2, int y2) {
            int rx1 = Math.min(x1, x2);
            int rx2 = Math.max(x1, x2);
            int ry1 = Math.min(y1, y2);
            int ry2 = Math.max(y1, y2);
            int zoom = MapPanelSelector.this.getZoom();
            double xTile = MapPanelSelector.this.getXTile();
            double yTile = MapPanelSelector.this.getYTile();
            int wid = MapPanelSelector.this.getWidth();
            int h = MapPanelSelector.this.getHeight();
            double tileSize = MapPanelSelector.this.getTileSize();
            double xTile1 = xTile - (double)(wid / 2 - rx1) / tileSize;
            double yTile1 = yTile - (double)(h / 2 - ry1) / tileSize;
            double xTile2 = xTile - (double)(wid / 2 - rx2) / tileSize;
            double yTile2 = yTile - (double)(h / 2 - ry2) / tileSize;
            this.lat1 = MapUtils.getLatitudeFromTile((float)zoom, (double)yTile1);
            this.lat2 = MapUtils.getLatitudeFromTile((float)zoom, (double)yTile2);
            this.lon1 = MapUtils.getLongitudeFromTile((double)zoom, (double)xTile1);
            this.lon2 = MapUtils.getLongitudeFromTile((double)zoom, (double)xTile2);
            MapPanelSelector.this.panel.getLayer(MapInformationLayer.class).setAreaButtonVisible(this.isVisible());
        }
    }
}

