/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TLongHashSet;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.VehicleRouter;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;

public class GeneralRouter
implements VehicleRouter {
    private static final float CAR_SHORTEST_DEFAULT_SPEED = 15.277779f;
    private static final float BICYCLE_SHORTEST_DEFAULT_SPEED = 4.166667f;
    public static int IMPASSABLE_ROAD_SHIFT = 0;
    public static final String USE_SHORTEST_WAY = "short_way";
    public static final String USE_HEIGHT_OBSTACLES = "height_obstacles";
    public static final String GROUP_RELIEF_SMOOTHNESS_FACTOR = "relief_smoothness_factor";
    public static final String AVOID_FERRIES = "avoid_ferries";
    public static final String AVOID_TOLL = "avoid_toll";
    public static final String AVOID_MOTORWAY = "avoid_motorway";
    public static final String AVOID_UNPAVED = "avoid_unpaved";
    public static final String PREFER_MOTORWAYS = "prefer_motorway";
    public static final String ALLOW_PRIVATE = "allow_private";
    public static final String ALLOW_PRIVATE_FOR_TRUCK = "allow_private_for_truck";
    public static final String HAZMAT_CATEGORY = "hazmat_category";
    public static final String GOODS_RESTRICTIONS = "goods_restrictions";
    public static final String ALLOW_MOTORWAYS = "allow_motorway";
    public static final String DEFAULT_SPEED = "default_speed";
    public static final String MIN_SPEED = "min_speed";
    public static final String MAX_SPEED = "max_speed";
    public static final String VEHICLE_HEIGHT = "height";
    public static final String VEHICLE_WEIGHT = "weight";
    public static final String VEHICLE_WIDTH = "width";
    public static final String VEHICLE_LENGTH = "length";
    public static final String MOTOR_TYPE = "motor_type";
    public static final String MAX_AXLE_LOAD = "maxaxleload";
    public static final String WEIGHT_RATING = "weightrating";
    public static final String ALLOW_VIA_FERRATA = "allow_via_ferrata";
    public static final String CHECK_ALLOW_PRIVATE_NEEDED = "check_allow_private_needed";
    private static final double MIN_DISTANCE_SLOPE_ROUND = 10.0;
    private static boolean USE_CACHE = true;
    public static long TIMER = 0L;
    private final RouteAttributeContext[] objectAttributes;
    public final Map<String, String> attributes;
    private final Map<String, RoutingParameter> parameters;
    private final Map<String, String> parameterValues;
    private final Map<String, Integer> universalRules;
    private final List<String> universalRulesById;
    private final Map<String, BitSet> tagRuleMask;
    private final ArrayList<Object> ruleToValue;
    private boolean shortestRoute;
    private boolean heightObstacles;
    private boolean allowPrivate;
    private String filename = null;
    private String profileName = "";
    private Map<BinaryMapRouteReaderAdapter.RouteRegion, Map<Integer, Integer>> regionConvert = new LinkedHashMap<BinaryMapRouteReaderAdapter.RouteRegion, Map<Integer, Integer>>();
    private boolean restrictionsAware = true;
    private float sharpTurn;
    private float shortWaySharpTurn;
    private float slightTurn;
    private float shortWaySlightTurn;
    private float roundaboutTurn;
    private float shortWayRoundaboutTurn;
    private float minSpeed = 0.28f;
    private float defaultSpeed = 1.0f;
    private float maxSpeed = 10.0f;
    private float maxVehicleSpeed;
    private TLongHashSet impassableRoads;
    private GeneralRouterProfile profile;
    Map<BinaryMapRouteReaderAdapter.RouteRegion, Map<IntHolder, Float>>[] evalCache;
    public String[] hhNativeFilter = new String[0];
    public String[] hhNativeParameterValues = new String[0];
    private final GeneralRouter root;

    public GeneralRouter(GeneralRouter copy, Map<String, String> params) {
        GeneralRouter parent = this.root = copy.root;
        this.profile = parent.profile;
        this.attributes = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> next : parent.attributes.entrySet()) {
            this.addAttribute(next.getKey(), next.getValue());
        }
        this.universalRules = parent.universalRules;
        this.universalRulesById = parent.universalRulesById;
        this.parameterValues = params;
        this.tagRuleMask = parent.tagRuleMask;
        this.ruleToValue = parent.ruleToValue;
        this.parameters = parent.parameters;
        this.profileName = parent.profileName;
        this.objectAttributes = new RouteAttributeContext[RouteDataObjectAttribute.values().length];
        for (int i = 0; i < this.objectAttributes.length; ++i) {
            this.objectAttributes[i] = new RouteAttributeContext(parent.objectAttributes[i], params);
        }
        this.shortestRoute = params.containsKey(USE_SHORTEST_WAY) && GeneralRouter.parseSilentBoolean(params.get(USE_SHORTEST_WAY), false);
        boolean bl = this.heightObstacles = params.containsKey(USE_HEIGHT_OBSTACLES) && GeneralRouter.parseSilentBoolean(params.get(USE_HEIGHT_OBSTACLES), false);
        if (params.containsKey("profile_truck")) {
            this.allowPrivate = params.containsKey(ALLOW_PRIVATE_FOR_TRUCK) && GeneralRouter.parseSilentBoolean(params.get(ALLOW_PRIVATE_FOR_TRUCK), false);
        } else {
            boolean bl2 = this.allowPrivate = params.containsKey(ALLOW_PRIVATE) && GeneralRouter.parseSilentBoolean(params.get(ALLOW_PRIVATE), false);
        }
        if (params.containsKey(DEFAULT_SPEED)) {
            this.defaultSpeed = GeneralRouter.parseSilentFloat(params.get(DEFAULT_SPEED), this.defaultSpeed);
        }
        if (params.containsKey(MIN_SPEED)) {
            this.minSpeed = GeneralRouter.parseSilentFloat(params.get(MIN_SPEED), this.minSpeed);
        }
        if (params.containsKey(MAX_SPEED)) {
            this.maxSpeed = GeneralRouter.parseSilentFloat(params.get(MAX_SPEED), this.maxSpeed);
        }
        this.maxVehicleSpeed = this.maxSpeed;
        if (this.shortestRoute) {
            this.maxSpeed = this.profile == GeneralRouterProfile.BICYCLE ? Math.min(4.166667f, this.maxSpeed) : Math.min(15.277779f, this.maxSpeed);
        }
        this.initCaches();
    }

    public GeneralRouter(GeneralRouterProfile profile, Map<String, String> attributes) {
        this.root = this;
        this.profile = profile;
        this.attributes = new LinkedHashMap<String, String>();
        this.parameterValues = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> next : attributes.entrySet()) {
            this.addAttribute(next.getKey(), next.getValue());
        }
        this.objectAttributes = new RouteAttributeContext[RouteDataObjectAttribute.values().length];
        for (int i = 0; i < this.objectAttributes.length; ++i) {
            this.objectAttributes[i] = new RouteAttributeContext();
        }
        this.universalRules = new LinkedHashMap<String, Integer>();
        this.universalRulesById = new ArrayList<String>();
        this.tagRuleMask = new LinkedHashMap<String, BitSet>();
        this.ruleToValue = new ArrayList();
        this.parameters = new LinkedHashMap<String, RoutingParameter>();
        this.initCaches();
    }

    private void initCaches() {
        int l = RouteDataObjectAttribute.values().length;
        this.evalCache = new Map[l];
        for (int i = 0; i < l; ++i) {
            this.evalCache[i] = new HashMap<BinaryMapRouteReaderAdapter.RouteRegion, Map<IntHolder, Float>>();
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    @Override
    public GeneralRouterProfile getProfile() {
        return this.profile;
    }

    public boolean getHeightObstacles() {
        return this.heightObstacles;
    }

    public Map<String, RoutingParameter> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getParameterValues() {
        return this.parameterValues;
    }

    public List<String> serializeParameterValues(Map<String, String> vls) {
        ArrayList<String> ls = new ArrayList<String>();
        for (Map.Entry<String, String> e : vls.entrySet()) {
            String val = e.getValue();
            if (val.isEmpty() || "true".equals(val) || "false".equals(val)) {
                ls.add(e.getKey());
                continue;
            }
            ls.add(e.getKey() + "=" + val);
        }
        return ls;
    }

    public void addAttribute(String k, String v) {
        this.attributes.put(k, v);
        if (k.equals("restrictionsAware")) {
            this.restrictionsAware = GeneralRouter.parseSilentBoolean(v, this.restrictionsAware);
        } else if (k.equals("sharpTurn") || k.equals("leftTurn")) {
            this.sharpTurn = GeneralRouter.parseSilentFloat(v, this.sharpTurn);
        } else if (k.equals("slightTurn") || k.equals("rightTurn")) {
            this.slightTurn = GeneralRouter.parseSilentFloat(v, this.slightTurn);
        } else if (k.equals("roundaboutTurn")) {
            this.roundaboutTurn = GeneralRouter.parseSilentFloat(v, this.roundaboutTurn);
        } else if (k.equals("minDefaultSpeed") || k.equals("defaultSpeed")) {
            this.defaultSpeed = GeneralRouter.parseSilentFloat(v, this.defaultSpeed * 3.6f) / 3.6f;
        } else if (k.equals("minSpeed")) {
            this.minSpeed = GeneralRouter.parseSilentFloat(v, this.minSpeed * 3.6f) / 3.6f;
        } else if (k.equals("maxDefaultSpeed") || k.equals("maxSpeed")) {
            this.maxSpeed = GeneralRouter.parseSilentFloat(v, this.maxSpeed * 3.6f) / 3.6f;
        } else if (k.equals("shortWaySharpTurn")) {
            this.shortWaySharpTurn = GeneralRouter.parseSilentFloat(v, this.shortWaySharpTurn);
        } else if (k.equals("shortWaySlightTurn")) {
            this.shortWaySlightTurn = GeneralRouter.parseSilentFloat(v, this.shortWaySlightTurn);
        } else if (k.equals("shortWayRoundaboutTurn")) {
            this.shortWayRoundaboutTurn = GeneralRouter.parseSilentFloat(v, this.shortWayRoundaboutTurn);
        }
    }

    public RouteAttributeContext getObjContext(RouteDataObjectAttribute a) {
        return this.objectAttributes[a.ordinal()];
    }

    public void registerBooleanParameter(String id, String group, String name, String description, String[] profiles, boolean defaultValue) {
        RoutingParameter rp = new RoutingParameter();
        rp.id = id;
        rp.group = group;
        rp.name = name;
        rp.description = description;
        rp.profiles = profiles;
        rp.type = RoutingParameterType.BOOLEAN;
        rp.defaultBoolean = defaultValue;
        this.parameters.put(rp.id, rp);
    }

    public void registerNumericParameter(String id, String name, String description, String[] profiles, Double[] vls, String[] vlsDescriptions) {
        RoutingParameter rp = new RoutingParameter();
        rp.name = name;
        rp.description = description;
        rp.id = id;
        rp.profiles = profiles;
        rp.possibleValues = vls;
        rp.possibleValueDescriptions = vlsDescriptions;
        rp.type = RoutingParameterType.NUMERIC;
        this.parameters.put(rp.id, rp);
    }

    @Override
    public boolean acceptLine(RouteDataObject way) {
        Float res = this.getCache(RouteDataObjectAttribute.ACCESS, way);
        if (res == null) {
            res = Float.valueOf(this.getObjContext(RouteDataObjectAttribute.ACCESS).evaluateInt(way, 0));
            this.putCache(RouteDataObjectAttribute.ACCESS, way, res);
        }
        if (this.impassableRoads != null && this.impassableRoads.contains(way.id >> IMPASSABLE_ROAD_SHIFT)) {
            return false;
        }
        return res.floatValue() >= 0.0f;
    }

    public boolean isAllowPrivate() {
        return this.allowPrivate;
    }

    public long[] getImpassableRoadIds() {
        if (this.impassableRoads == null) {
            return new long[0];
        }
        return this.impassableRoads.toArray();
    }

    public int registerTagValueAttribute(String tag, String value) {
        String key = tag + "$" + value;
        if (this.universalRules.containsKey(key)) {
            return this.universalRules.get(key);
        }
        int id = this.universalRules.size();
        this.universalRulesById.add(key);
        this.universalRules.put(key, id);
        if (!this.tagRuleMask.containsKey(tag)) {
            this.tagRuleMask.put(tag, new BitSet());
        }
        this.tagRuleMask.get(tag).set(id);
        return id;
    }

    private Object parseValue(String value, String type) {
        float vl = -1.0f;
        value = value.trim();
        if ("speed".equals(type)) {
            vl = RouteDataObject.parseSpeed(value, vl);
        } else if (VEHICLE_WEIGHT.equals(type)) {
            vl = RouteDataObject.parseWeightInTon(value, vl);
        } else if (VEHICLE_LENGTH.equals(type)) {
            vl = RouteDataObject.parseLength(value, vl);
        } else {
            int i = Algorithms.findFirstNumberEndIndex(value);
            if (i > 0) {
                return Float.valueOf(Float.parseFloat(value.substring(0, i)));
            }
        }
        if (vl == -1.0f) {
            return null;
        }
        return Float.valueOf(vl);
    }

    private Object parseValueFromTag(int id, String type) {
        while (this.ruleToValue.size() <= id) {
            this.ruleToValue.add(null);
        }
        Object res = this.ruleToValue.get(id);
        if (res == null) {
            String v = this.universalRulesById.get(id);
            String value = v.substring(v.indexOf(36) + 1);
            res = this.parseValue(value, type);
            if (res == null) {
                res = "";
            }
            this.ruleToValue.set(id, res);
        }
        if ("".equals(res)) {
            return null;
        }
        return res;
    }

    @Override
    public GeneralRouter build(Map<String, String> params) {
        return new GeneralRouter(this, params);
    }

    @Override
    public boolean restrictionsAware() {
        return this.restrictionsAware;
    }

    @Override
    public float defineObstacle(RouteDataObject road, int point, boolean dir) {
        int[] pointTypes = road.getPointTypes(point);
        if (pointTypes != null) {
            Float obst = this.getCache(RouteDataObjectAttribute.OBSTACLES, road.region, pointTypes, dir);
            if (obst == null) {
                int[] filteredPointTypes = this.filterDirectionTags(road, pointTypes, dir);
                obst = Float.valueOf(this.getObjContext(RouteDataObjectAttribute.OBSTACLES).evaluateFloat(road.region, filteredPointTypes, 0.0f));
                this.putCache(RouteDataObjectAttribute.OBSTACLES, road.region, pointTypes, obst, dir);
            }
            return obst.floatValue();
        }
        return 0.0f;
    }

    @Override
    public float defineRoutingObstacle(RouteDataObject road, int point, boolean dir) {
        int[] pointTypes = road.getPointTypes(point);
        if (pointTypes != null) {
            Float obst = this.getCache(RouteDataObjectAttribute.ROUTING_OBSTACLES, road.region, pointTypes, dir);
            if (obst == null) {
                int[] filteredPointTypes = this.filterDirectionTags(road, pointTypes, dir);
                obst = Float.valueOf(this.getObjContext(RouteDataObjectAttribute.ROUTING_OBSTACLES).evaluateFloat(road.region, filteredPointTypes, 0.0f));
                this.putCache(RouteDataObjectAttribute.ROUTING_OBSTACLES, road.region, pointTypes, obst, dir);
            }
            return obst.floatValue();
        }
        return 0.0f;
    }

    private int[] filterDirectionTags(RouteDataObject road, int[] pointTypes, boolean forwardDir) {
        int wayDirection = forwardDir ? 1 : -1;
        int direction = 0;
        int tdirection = 0;
        int hdirection = 0;
        for (int type : pointTypes) {
            if (type == road.region.directionBackward) {
                direction = -1;
                continue;
            }
            if (type == road.region.directionForward) {
                direction = 1;
                continue;
            }
            if (type == road.region.directionTrafficSignalsBackward) {
                tdirection = -1;
                continue;
            }
            if (type == road.region.directionTrafficSignalsForward) {
                tdirection = 1;
                continue;
            }
            if (type == road.region.maxheightBackward) {
                hdirection = -1;
                continue;
            }
            if (type != road.region.maxheightForward) continue;
            hdirection = 1;
        }
        if (direction != 0 || tdirection != 0 || hdirection != 0) {
            TIntArrayList filteredPointTypes = new TIntArrayList();
            for (int type : pointTypes) {
                if ((type == road.region.stopSign || type == road.region.giveWaySign) && direction == wayDirection || type == road.region.trafficSignals && tdirection == wayDirection || hdirection == wayDirection) continue;
                filteredPointTypes.add(type);
            }
            return filteredPointTypes.toArray();
        }
        return pointTypes;
    }

    @Override
    public double defineHeightObstacle(RouteDataObject road, short startIndex, short endIndex) {
        if (!this.heightObstacles) {
            return 0.0;
        }
        float[] heightArray = road.calculateHeightArray();
        if (heightArray == null || heightArray.length == 0) {
            return 0.0;
        }
        double sum = 0.0;
        RouteAttributeContext objContext = this.getObjContext(RouteDataObjectAttribute.OBSTACLE_SRTM_ALT_SPEED);
        int k = startIndex;
        while (k != endIndex) {
            int knext = startIndex < endIndex ? k + 1 : k - 1;
            double dist = startIndex < endIndex ? (double)heightArray[2 * knext] : (double)heightArray[2 * k];
            double diff = heightArray[2 * knext + 1] - heightArray[2 * k + 1];
            if (diff != 0.0 && dist > 0.0) {
                double incl = Math.abs(diff / Math.max(dist, 10.0));
                int percentIncl = (int)(incl * 100.0);
                if ((percentIncl = (percentIncl + 2) / 3 * 3 - 2) >= 1) {
                    objContext.paramContext.incline = diff > 0.0 ? (double)percentIncl : (double)(-percentIncl);
                    sum += (double)objContext.evaluateFloat(road, 0.0f) * (diff > 0.0 ? diff : -diff);
                }
            }
            k = knext;
        }
        return sum;
    }

    @Override
    public int isOneWay(RouteDataObject road) {
        Float res = this.getCache(RouteDataObjectAttribute.ONEWAY, road);
        if (res == null) {
            res = Float.valueOf(this.getObjContext(RouteDataObjectAttribute.ONEWAY).evaluateInt(road, 0));
            this.putCache(RouteDataObjectAttribute.ONEWAY, road, res);
        }
        return res.intValue();
    }

    @Override
    public boolean isArea(RouteDataObject road) {
        return this.getObjContext(RouteDataObjectAttribute.AREA).evaluateInt(road, 0) == 1;
    }

    @Override
    public float getPenaltyTransition(RouteDataObject road) {
        Float vl = this.getCache(RouteDataObjectAttribute.PENALTY_TRANSITION, road);
        if (vl == null) {
            vl = Float.valueOf(this.getObjContext(RouteDataObjectAttribute.PENALTY_TRANSITION).evaluateInt(road, 0));
            this.putCache(RouteDataObjectAttribute.PENALTY_TRANSITION, road, vl);
        }
        return vl.floatValue();
    }

    @Override
    public float defineRoutingSpeed(RouteDataObject road, boolean dir) {
        Float definedSpd = this.getCache(RouteDataObjectAttribute.ROAD_SPEED, road, dir);
        if (definedSpd == null) {
            float spd = this.getObjContext(RouteDataObjectAttribute.ROAD_SPEED).evaluateFloat(road, this.defaultSpeed);
            definedSpd = Float.valueOf(Math.max(Math.min(spd, this.maxSpeed), this.minSpeed));
            this.putCache(RouteDataObjectAttribute.ROAD_SPEED, road, definedSpd, dir);
        }
        return definedSpd.floatValue();
    }

    @Override
    public float defineVehicleSpeed(RouteDataObject road, boolean dir) {
        if (this.maxVehicleSpeed != this.maxSpeed) {
            float spd = this.getObjContext(RouteDataObjectAttribute.ROAD_SPEED).evaluateFloat(road, this.defaultSpeed);
            return Math.max(Math.min(spd, this.maxVehicleSpeed), this.minSpeed);
        }
        Float sp = this.getCache(RouteDataObjectAttribute.ROAD_SPEED, road, dir);
        if (sp == null) {
            float spd = this.getObjContext(RouteDataObjectAttribute.ROAD_SPEED).evaluateFloat(road, this.defaultSpeed);
            sp = Float.valueOf(Math.max(Math.min(spd, this.maxVehicleSpeed), this.minSpeed));
            this.putCache(RouteDataObjectAttribute.ROAD_SPEED, road, sp, dir);
        }
        return sp.floatValue();
    }

    @Override
    public float defineSpeedPriority(RouteDataObject road, boolean dir) {
        Float sp = this.getCache(RouteDataObjectAttribute.ROAD_PRIORITIES, road, dir);
        if (sp == null) {
            sp = Float.valueOf(this.getObjContext(RouteDataObjectAttribute.ROAD_PRIORITIES).evaluateFloat(road, 1.0f));
            this.putCache(RouteDataObjectAttribute.ROAD_PRIORITIES, road, sp, dir);
        }
        return sp.floatValue();
    }

    @Override
    public float defineDestinationPriority(RouteDataObject road) {
        Float sp = this.getCache(RouteDataObjectAttribute.DESTINATION_PRIORITIES, road);
        if (sp == null) {
            sp = Float.valueOf(this.getObjContext(RouteDataObjectAttribute.DESTINATION_PRIORITIES).evaluateFloat(road, 1.0f));
            this.putCache(RouteDataObjectAttribute.DESTINATION_PRIORITIES, road, sp, false);
        }
        return sp.floatValue();
    }

    private void putCache(RouteDataObjectAttribute attr, RouteDataObject road, Float val) {
        this.putCache(attr, road.region, road.types, val, false);
    }

    private void putCache(RouteDataObjectAttribute attr, RouteDataObject road, Float val, boolean extra) {
        this.putCache(attr, road.region, road.types, val, extra);
    }

    private void putCache(RouteDataObjectAttribute attr, BinaryMapRouteReaderAdapter.RouteRegion reg, int[] types, Float val, boolean extra) {
        Map<BinaryMapRouteReaderAdapter.RouteRegion, Map<IntHolder, Float>> ch = this.evalCache[attr.ordinal()];
        if (USE_CACHE) {
            Map<IntHolder, Float> rM = ch.get(reg);
            if (rM == null) {
                rM = new HashMap<IntHolder, Float>();
                ch.put(reg, rM);
            }
            rM.put(new IntHolder(types, extra), val);
        }
    }

    private Float getCache(RouteDataObjectAttribute attr, RouteDataObject road) {
        return this.getCache(attr, road.region, road.types, false);
    }

    private Float getCache(RouteDataObjectAttribute attr, RouteDataObject road, boolean extra) {
        return this.getCache(attr, road.region, road.types, extra);
    }

    private Float getCache(RouteDataObjectAttribute attr, BinaryMapRouteReaderAdapter.RouteRegion reg, int[] types, boolean extra) {
        Map<BinaryMapRouteReaderAdapter.RouteRegion, Map<IntHolder, Float>> ch = this.evalCache[attr.ordinal()];
        if (USE_CACHE) {
            Map<IntHolder, Float> rM = ch.get(reg);
            if (rM == null) {
                return null;
            }
            Float vl = rM.get(new IntHolder(types, extra));
            if (vl != null) {
                return vl;
            }
        }
        return null;
    }

    @Override
    public float getDefaultSpeed() {
        return this.defaultSpeed;
    }

    @Override
    public float getMinSpeed() {
        return this.minSpeed;
    }

    @Override
    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    private float getSharpTurnPenalty() {
        return this.shortestRoute ? this.shortWaySharpTurn : this.sharpTurn;
    }

    private float getSlightTurnPenalty() {
        return this.shortestRoute ? this.shortWaySlightTurn : this.slightTurn;
    }

    private float getRoundaboutTurnPenalty() {
        return this.shortestRoute ? this.shortWayRoundaboutTurn : this.roundaboutTurn;
    }

    @Override
    public double calculateTurnTime(BinaryRoutePlanner.RouteSegment segment, BinaryRoutePlanner.RouteSegment prev) {
        float ts = this.getPenaltyTransition(segment.getRoad());
        float prevTs = this.getPenaltyTransition(prev.getRoad());
        float totalPenalty = 0.0f;
        if (prevTs != ts) {
            totalPenalty += Math.abs(ts - prevTs) / 2.0f;
        }
        if (segment.getRoad().roundabout() && !prev.getRoad().roundabout()) {
            double rt = this.getRoundaboutTurnPenalty();
            if (rt > 0.0) {
                totalPenalty = (float)((double)totalPenalty + rt);
            }
        } else if (this.getSharpTurnPenalty() > 0.0f || this.getSlightTurnPenalty() > 0.0f) {
            double a2;
            double a1 = segment.getRoad().directionRoute(segment.getSegmentStart(), segment.isPositive());
            double diff = Math.abs(MapUtils.alignAngleDifference(a1 - (a2 = prev.getRoad().directionRoute(prev.getSegmentEnd(), !prev.isPositive())) - Math.PI));
            if (diff > 2.0943951023931953) {
                totalPenalty += this.getSharpTurnPenalty();
            } else if (diff > 1.0471975511965976) {
                totalPenalty += this.getSlightTurnPenalty();
            } else if (diff > 0.5235987755982988) {
                totalPenalty += this.getSlightTurnPenalty() / 2.0f;
            }
        }
        return totalPenalty;
    }

    @Override
    public boolean containsAttribute(String attribute) {
        return this.attributes.containsKey(attribute);
    }

    @Override
    public String getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public float getFloatAttribute(String attribute, float v) {
        return GeneralRouter.parseSilentFloat(this.getAttribute(attribute), v);
    }

    public int getIntAttribute(String attribute, int v) {
        return (int)GeneralRouter.parseSilentFloat(this.getAttribute(attribute), v);
    }

    private static boolean parseSilentBoolean(String t, boolean v) {
        if (t == null || t.length() == 0) {
            return v;
        }
        return Boolean.parseBoolean(t);
    }

    private static float parseSilentFloat(String t, float v) {
        if (t == null || t.length() == 0) {
            return v;
        }
        return Float.parseFloat(t);
    }

    public void clearCaches() {
        if (this.evalCache != null) {
            for (int i = 0; i < this.evalCache.length; ++i) {
                this.evalCache[i].clear();
            }
        }
    }

    public void printRules(PrintStream out) {
        for (int i = 0; i < RouteDataObjectAttribute.values().length; ++i) {
            out.println((Object)RouteDataObjectAttribute.values()[i]);
            this.objectAttributes[i].printRules(out);
        }
    }

    public void setImpassableRoads(Set<Long> impassableRoads) {
        if (impassableRoads != null && !impassableRoads.isEmpty()) {
            this.impassableRoads = new TLongHashSet(impassableRoads);
        } else if (this.impassableRoads != null) {
            this.impassableRoads.clear();
        }
    }

    public static enum GeneralRouterProfile {
        CAR,
        PEDESTRIAN,
        BICYCLE,
        BOAT,
        SKI,
        MOPED,
        TRAIN,
        PUBLIC_TRANSPORT,
        HORSEBACKRIDING;


        public String getBaseProfile() {
            return this.toString().toLowerCase();
        }
    }

    public static enum RouteDataObjectAttribute {
        ROAD_SPEED("speed"),
        ROAD_PRIORITIES("priority"),
        DESTINATION_PRIORITIES("destination_priority"),
        ACCESS("access"),
        OBSTACLES("obstacle_time"),
        ROUTING_OBSTACLES("obstacle"),
        ONEWAY("oneway"),
        PENALTY_TRANSITION("penalty_transition"),
        OBSTACLE_SRTM_ALT_SPEED("obstacle_srtm_alt_speed"),
        AREA("area");

        public final String nm;

        private RouteDataObjectAttribute(String name) {
            this.nm = name;
        }

        public static RouteDataObjectAttribute getValueOf(String s) {
            for (RouteDataObjectAttribute a : RouteDataObjectAttribute.values()) {
                if (!a.nm.equals(s)) continue;
                return a;
            }
            return null;
        }
    }

    public class RouteAttributeContext {
        List<RouteAttributeEvalRule> rules = new ArrayList<RouteAttributeEvalRule>();
        ParameterContext paramContext = null;

        public RouteAttributeContext() {
        }

        public RouteAttributeContext(RouteAttributeContext original, Map<String, String> params) {
            if (params != null) {
                this.paramContext = new ParameterContext();
                this.paramContext.vars = params;
            }
            for (RouteAttributeEvalRule rt : original.rules) {
                if (!this.checkParameter(rt)) continue;
                this.rules.add(rt);
            }
        }

        public RouteAttributeEvalRule[] getRules() {
            return this.rules.toArray(new RouteAttributeEvalRule[0]);
        }

        public String[] getParamKeys() {
            if (this.paramContext == null) {
                return new String[0];
            }
            return this.paramContext.vars.keySet().toArray(new String[0]);
        }

        public String[] getParamValues() {
            if (this.paramContext == null) {
                return new String[0];
            }
            return this.paramContext.vars.values().toArray(new String[0]);
        }

        private Object evaluate(RouteDataObject ro) {
            return this.evaluate(this.convert(ro.region, ro.types));
        }

        public void printRules(PrintStream out) {
            for (RouteAttributeEvalRule r : this.rules) {
                r.printRule(out);
            }
        }

        public RouteAttributeEvalRule registerNewRule(String selectValue, String selectType) {
            RouteAttributeEvalRule ev = new RouteAttributeEvalRule();
            ev.registerSelectValue(selectValue, selectType);
            this.rules.add(ev);
            return ev;
        }

        public RouteAttributeEvalRule getLastRule() {
            return this.rules.get(this.rules.size() - 1);
        }

        private synchronized Object evaluate(BitSet types) {
            for (int k = 0; k < this.rules.size(); ++k) {
                RouteAttributeEvalRule r = this.rules.get(k);
                Object o = r.eval(types, this.paramContext);
                if (o == null) continue;
                return o;
            }
            return null;
        }

        private boolean checkParameter(RouteAttributeEvalRule r) {
            if (this.paramContext != null && r.parameters.size() > 0) {
                for (String p : r.parameters) {
                    boolean not = false;
                    if (p.startsWith("-")) {
                        not = true;
                        p = p.substring(1);
                    }
                    boolean val = this.paramContext.vars.containsKey(p);
                    if (not && val) {
                        return false;
                    }
                    if (not || val) continue;
                    return false;
                }
            }
            return true;
        }

        public int evaluateInt(RouteDataObject ro, int defValue) {
            Object o = this.evaluate(ro);
            if (!(o instanceof Number)) {
                return defValue;
            }
            return ((Number)o).intValue();
        }

        public int evaluateInt(BinaryMapRouteReaderAdapter.RouteRegion region, int[] types, int defValue) {
            Object o = this.evaluate(this.convert(region, types));
            if (!(o instanceof Number)) {
                return defValue;
            }
            return ((Number)o).intValue();
        }

        public int evaluateInt(BitSet rawTypes, int defValue) {
            Object o = this.evaluate(rawTypes);
            if (!(o instanceof Number)) {
                return defValue;
            }
            return ((Number)o).intValue();
        }

        public float evaluateFloat(RouteDataObject ro, float defValue) {
            Object o = this.evaluate(ro);
            if (!(o instanceof Number)) {
                return defValue;
            }
            return ((Number)o).floatValue();
        }

        public float evaluateFloat(BinaryMapRouteReaderAdapter.RouteRegion region, int[] types, float defValue) {
            Object o = this.evaluate(this.convert(region, types));
            if (!(o instanceof Number)) {
                return defValue;
            }
            return ((Number)o).floatValue();
        }

        public float evaluateFloat(BitSet rawTypes, float defValue) {
            Object o = this.evaluate(rawTypes);
            if (!(o instanceof Number)) {
                return defValue;
            }
            return ((Number)o).floatValue();
        }

        private BitSet convert(BinaryMapRouteReaderAdapter.RouteRegion reg, int[] types) {
            BitSet b = new BitSet(GeneralRouter.this.universalRules.size());
            Map<Integer, Integer> map = GeneralRouter.this.regionConvert.get(reg);
            if (map == null) {
                map = new HashMap<Integer, Integer>();
                GeneralRouter.this.regionConvert.put(reg, map);
            }
            for (int k = 0; k < types.length; ++k) {
                Integer nid = map.get(types[k]);
                if (nid == null) {
                    BinaryMapRouteReaderAdapter.RouteTypeRule r = reg.quickGetEncodingRule(types[k]);
                    nid = GeneralRouter.this.registerTagValueAttribute(r.getTag(), r.getValue());
                    map.put(types[k], nid);
                }
                b.set(nid);
            }
            return b;
        }
    }

    public static class RoutingParameter {
        private String id;
        private String group;
        private String name;
        private String description;
        private RoutingParameterType type;
        private Object[] possibleValues;
        private String[] possibleValueDescriptions;
        private String[] profiles;
        private boolean defaultBoolean;

        public String getId() {
            return this.id;
        }

        public String getGroup() {
            return this.group;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public RoutingParameterType getType() {
            return this.type;
        }

        public String[] getPossibleValueDescriptions() {
            return this.possibleValueDescriptions;
        }

        public Object[] getPossibleValues() {
            return this.possibleValues;
        }

        public boolean getDefaultBoolean() {
            return this.defaultBoolean;
        }

        public String getDefaultString() {
            return this.type == RoutingParameterType.NUMERIC ? "0.0" : "-";
        }

        public String[] getProfiles() {
            return this.profiles;
        }
    }

    public static enum RoutingParameterType {
        NUMERIC,
        BOOLEAN,
        SYMBOLIC;

    }

    private class ParameterContext {
        private Map<String, String> vars;
        private double incline = 0.0;

        private ParameterContext() {
        }
    }

    class IntHolder {
        private final int[] array;
        private final boolean extra;

        IntHolder(int[] ts, boolean extra) {
            this.array = ts;
            this.extra = extra;
        }

        public int hashCode() {
            return Arrays.hashCode(this.array) + (this.extra ? 1 : 0);
        }

        public boolean equals(Object other) {
            if (this.array == other) {
                return true;
            }
            if (!(other instanceof IntHolder)) {
                return false;
            }
            if (((IntHolder)other).extra != this.extra) {
                return false;
            }
            return Arrays.equals(this.array, ((IntHolder)other).array);
        }
    }

    public class RouteAttributeEvalRule {
        protected List<String> parameters = new ArrayList<String>();
        protected List<String> tagValueCondDefTag = new ArrayList<String>();
        protected List<String> tagValueCondDefValue = new ArrayList<String>();
        protected List<Boolean> tagValueCondDefNot = new ArrayList<Boolean>();
        protected String selectValueDef = null;
        protected Object selectValue = null;
        protected String selectType = null;
        protected RouteAttributeExpression selectExpression = null;
        protected BitSet filterTypes = new BitSet();
        protected BitSet filterNotTypes = new BitSet();
        protected BitSet evalFilterTypes = new BitSet();
        protected Set<String> onlyTags = new LinkedHashSet<String>();
        protected Set<String> onlyNotTags = new LinkedHashSet<String>();
        protected List<RouteAttributeExpression> conditionExpressions = new ArrayList<RouteAttributeExpression>();

        public RouteAttributeExpression[] getExpressions() {
            return this.conditionExpressions.toArray(new RouteAttributeExpression[0]);
        }

        public String[] getParameters() {
            return this.parameters.toArray(new String[0]);
        }

        public String[] getTagValueCondDefTag() {
            return this.tagValueCondDefTag.toArray(new String[0]);
        }

        public String[] getTagValueCondDefValue() {
            return this.tagValueCondDefValue.toArray(new String[0]);
        }

        public boolean[] getTagValueCondDefNot() {
            boolean[] r = new boolean[this.tagValueCondDefNot.size()];
            for (int i = 0; i < r.length; ++i) {
                r[i] = this.tagValueCondDefNot.get(i);
            }
            return r;
        }

        public void registerSelectValue(String value, String type) {
            this.selectType = type;
            this.selectValueDef = value;
            if (value.startsWith(":") || value.startsWith("$")) {
                this.selectValue = value;
            } else {
                this.selectValue = GeneralRouter.this.parseValue(value, type);
                if (this.selectValue == null) {
                    System.err.println("Routing.xml select value '" + value + "' was not registered");
                }
            }
        }

        public void printRule(PrintStream out) {
            String key;
            int k;
            out.print(" Select " + String.valueOf(this.selectValue) + " if ");
            for (k = 0; k < this.filterTypes.length(); ++k) {
                if (!this.filterTypes.get(k)) continue;
                key = GeneralRouter.this.universalRulesById.get(k);
                out.print(key + " ");
            }
            if (this.filterNotTypes.length() > 0) {
                out.print(" ifnot ");
            }
            for (k = 0; k < this.filterNotTypes.length(); ++k) {
                if (!this.filterNotTypes.get(k)) continue;
                key = GeneralRouter.this.universalRulesById.get(k);
                out.print(key + " ");
            }
            for (k = 0; k < this.parameters.size(); ++k) {
                out.print(" param=" + this.parameters.get(k));
            }
            if (this.onlyTags.size() > 0) {
                out.print(" match tag = " + String.valueOf(this.onlyTags));
            }
            if (this.onlyNotTags.size() > 0) {
                out.print(" not match tag = " + String.valueOf(this.onlyNotTags));
            }
            if (this.conditionExpressions.size() > 0) {
                out.println(" subexpressions " + this.conditionExpressions.size());
            }
            if (this.selectExpression != null) {
                out.println("  selectexpression " + this.selectExpression.expressionType);
            }
            out.println();
        }

        public void registerAndTagValueCondition(String tag, String value, boolean not) {
            this.tagValueCondDefTag.add(tag);
            this.tagValueCondDefValue.add(value);
            this.tagValueCondDefNot.add(not);
            if (value == null) {
                if (not) {
                    this.onlyNotTags.add(tag);
                } else {
                    this.onlyTags.add(tag);
                }
            } else {
                int vtype = GeneralRouter.this.registerTagValueAttribute(tag, value);
                if (not) {
                    this.filterNotTypes.set(vtype);
                } else {
                    this.filterTypes.set(vtype);
                }
            }
        }

        public void registerLessCondition(String value1, String value2, String valueType) {
            this.conditionExpressions.add(new RouteAttributeExpression(new String[]{value1, value2}, valueType, 1));
        }

        public void registerGreatCondition(String value1, String value2, String valueType) {
            this.conditionExpressions.add(new RouteAttributeExpression(new String[]{value1, value2}, valueType, 2));
        }

        public void registerEqualCondition(String value1, String value2, String valueType) {
            this.conditionExpressions.add(new RouteAttributeExpression(new String[]{value1, value2}, valueType, 3));
        }

        public void registerMinExpression(String value1, String value2, String valueType) {
            this.selectExpression = new RouteAttributeExpression(new String[]{value1, value2}, valueType, 4);
        }

        public void registerMaxExpression(String value1, String value2, String valueType) {
            this.selectExpression = new RouteAttributeExpression(new String[]{value1, value2}, valueType, 5);
        }

        public void registerAndParamCondition(String param, boolean not) {
            param = not ? "-" + (String)param : param;
            this.parameters.add((String)param);
        }

        public Object eval(BitSet types, ParameterContext paramContext) {
            if (this.matches(types, paramContext)) {
                return this.calcSelectValue(types, paramContext);
            }
            return null;
        }

        protected Object calcSelectValue(BitSet types, ParameterContext paramContext) {
            if (this.selectExpression != null) {
                this.selectValue = this.selectExpression.calculateExprValue(types, paramContext);
            } else if (this.selectValue instanceof String && this.selectValue.toString().startsWith("$")) {
                BitSet mask = GeneralRouter.this.tagRuleMask.get(this.selectValue.toString().substring(1));
                if (mask != null && mask.intersects(types)) {
                    BitSet findBit = new BitSet(mask.length());
                    findBit.or(mask);
                    findBit.and(types);
                    int value = findBit.nextSetBit(0);
                    return GeneralRouter.this.parseValueFromTag(value, this.selectType);
                }
            } else if (this.selectValue instanceof String && this.selectValue.toString().startsWith(":")) {
                String p = ((String)this.selectValue).substring(1);
                if (paramContext != null && paramContext.vars.containsKey(p)) {
                    this.selectValue = GeneralRouter.this.parseValue(paramContext.vars.get(p), this.selectType);
                } else {
                    return null;
                }
            }
            return this.selectValue;
        }

        public boolean matches(BitSet types, ParameterContext paramContext) {
            if (!this.checkAllTypesShouldBePresent(types)) {
                return false;
            }
            if (!this.checkAllTypesShouldNotBePresent(types)) {
                return false;
            }
            if (!this.checkFreeTags(types)) {
                return false;
            }
            if (!this.checkNotFreeTags(types)) {
                return false;
            }
            return this.checkExpressions(types, paramContext);
        }

        private boolean checkExpressions(BitSet types, ParameterContext paramContext) {
            for (RouteAttributeExpression e : this.conditionExpressions) {
                if (e.matches(types, paramContext)) continue;
                return false;
            }
            return true;
        }

        private boolean checkFreeTags(BitSet types) {
            for (String ts : this.onlyTags) {
                BitSet b = GeneralRouter.this.tagRuleMask.get(ts);
                if (b != null && b.intersects(types)) continue;
                return false;
            }
            return true;
        }

        private boolean checkNotFreeTags(BitSet types) {
            for (String ts : this.onlyNotTags) {
                BitSet b = GeneralRouter.this.tagRuleMask.get(ts);
                if (b == null || !b.intersects(types)) continue;
                return false;
            }
            return true;
        }

        private boolean checkAllTypesShouldNotBePresent(BitSet types) {
            return !this.filterNotTypes.intersects(types);
        }

        private boolean checkAllTypesShouldBePresent(BitSet types) {
            this.evalFilterTypes.or(this.filterTypes);
            this.evalFilterTypes.and(types);
            return this.evalFilterTypes.equals(this.filterTypes);
        }
    }

    public class RouteAttributeExpression {
        public static final int LESS_EXPRESSION = 1;
        public static final int GREAT_EXPRESSION = 2;
        public static final int EQUAL_EXPRESSION = 3;
        public static final int MIN_EXPRESSION = 4;
        public static final int MAX_EXPRESSION = 5;
        private String[] values;
        private int expressionType;
        private String valueType;
        private Number[] cacheValues;

        public RouteAttributeExpression(String[] vs, String valueType, int expressionId) {
            this.expressionType = expressionId;
            this.values = vs;
            if (vs.length < 2) {
                throw new IllegalStateException("Expression should have at least 2 arguments");
            }
            this.cacheValues = new Number[vs.length];
            this.valueType = valueType;
            for (int i = 0; i < vs.length; ++i) {
                Object o;
                if (vs[i].startsWith("$") || vs[i].startsWith(":") || !((o = GeneralRouter.this.parseValue(vs[i], valueType)) instanceof Number)) continue;
                this.cacheValues[i] = (Number)o;
            }
        }

        public boolean matches(BitSet types, ParameterContext paramContext) {
            double f1 = this.calculateExprValue(0, types, paramContext);
            double f2 = this.calculateExprValue(1, types, paramContext);
            if (Double.isNaN(f1) || Double.isNaN(f2)) {
                return false;
            }
            if (this.expressionType == 1) {
                return f1 <= f2;
            }
            if (this.expressionType == 2) {
                return f1 >= f2;
            }
            if (this.expressionType == 3) {
                return f1 == f2;
            }
            return false;
        }

        private Double calculateExprValue(BitSet types, ParameterContext paramContext) {
            double f1 = this.calculateExprValue(0, types, paramContext);
            double f2 = this.calculateExprValue(1, types, paramContext);
            if (!Double.isNaN(f1) && !Double.isNaN(f2)) {
                switch (this.expressionType) {
                    case 4: {
                        return Math.min(f1, f2);
                    }
                    case 5: {
                        return Math.max(f1, f2);
                    }
                }
            }
            return null;
        }

        private double calculateExprValue(int id, BitSet types, ParameterContext paramContext) {
            String value = this.values[id];
            Number cacheValue = this.cacheValues[id];
            if (cacheValue != null) {
                return cacheValue.doubleValue();
            }
            Object o = null;
            if (value != null && value.startsWith("$")) {
                BitSet mask = GeneralRouter.this.tagRuleMask.get(value.substring(1));
                if (mask != null && mask.intersects(types)) {
                    BitSet findBit = new BitSet(mask.length());
                    findBit.or(mask);
                    findBit.and(types);
                    int v = findBit.nextSetBit(0);
                    o = GeneralRouter.this.parseValueFromTag(v, this.valueType);
                }
            } else {
                if (value != null && value.equals(":incline")) {
                    return paramContext.incline;
                }
                if (value != null && value.startsWith(":")) {
                    String p = value.substring(1);
                    if (paramContext != null && paramContext.vars.containsKey(p)) {
                        o = GeneralRouter.this.parseValue(paramContext.vars.get(p), this.valueType);
                    }
                }
            }
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            return Double.NaN;
        }
    }
}

