/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.obf.preparation.OsmDbAccessor;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.util.Algorithms;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MissingWikiTagsProcessor
implements OsmDbAccessor.OsmDbTagsPreparation {
    private static final Log log = LogFactory.getLog(MissingWikiTagsProcessor.class);
    private final String wikidataMappingUrl;
    Boolean init = null;
    private PreparedStatement selectById;
    private PreparedStatement selectId;

    public MissingWikiTagsProcessor(String wikidataMappingUrl) {
        this.wikidataMappingUrl = wikidataMappingUrl;
    }

    @Override
    public void processTags(Entity e) {
        String wikidata = e.getTag(OSMSettings.OSMTagKey.WIKIDATA);
        String wikipedia = e.getTag(OSMSettings.OSMTagKey.WIKIPEDIA);
        if (wikipedia == null && wikidata == null) {
            return;
        }
        if (wikidata != null && wikipedia != null) {
            return;
        }
        this.syncReadTags(e, wikidata, wikipedia);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void syncReadTags(Entity e, String wikidata, String wikipedia) {
        block14: {
            try {
                if (wikipedia != null && wikidata == null) {
                    if (!this.init()) {
                        return;
                    }
                    int langInd = wikipedia.indexOf(58);
                    String lang = "en";
                    String title = wikipedia;
                    if (langInd >= 0) {
                        lang = wikipedia.substring(0, langInd);
                        title = wikipedia.substring(langInd + 1);
                    }
                    this.selectId.setString(1, lang);
                    this.selectId.setString(2, title);
                    ResultSet rs = this.selectId.executeQuery();
                    if (rs.next()) {
                        e.putTag("wikidata", "Q" + rs.getLong(1));
                    }
                    rs.close();
                    break block14;
                }
                if (wikidata == null || wikipedia != null) break block14;
                if (!this.init()) {
                    return;
                }
                String ind = wikidata.substring(wikidata.lastIndexOf(81) + 1);
                long wid = Algorithms.parseLongSilently((String)ind, (long)0L);
                if (wid == 0L) {
                    return;
                }
                this.selectById.setLong(1, wid);
                try (ResultSet rs = this.selectById.executeQuery();){
                    String lang = null;
                    String title = null;
                    int cntLangs = 0;
                    while (rs.next()) {
                        lang = rs.getString(1);
                        title = rs.getString(2);
                        ++cntLangs;
                        if (lang == null) {
                            System.out.println("Null language for " + title + " Q" + wid);
                        }
                        if (lang.length() != 2 || !lang.equals("en")) continue;
                        e.putTag("wikipedia", "en:" + title);
                    }
                    if (cntLangs == 1 && !lang.equals("en")) {
                        e.removeTag("wikipedia:" + lang);
                        e.putTag("wikipedia", lang + ":" + title);
                    }
                }
            }
            catch (Exception es) {
                log.error((Object)es.getMessage(), (Throwable)es);
            }
        }
    }

    private boolean init() {
        if (this.init != null) {
            return this.init;
        }
        try {
            this.init = false;
            String fileName = this.wikidataMappingUrl;
            if (this.wikidataMappingUrl.startsWith("http")) {
                log.info((Object)("Downloading wikidata database by url " + this.wikidataMappingUrl));
                URL url = new URL(this.wikidataMappingUrl);
                URLConnection cn = url.openConnection();
                fileName = "wikidata_mapping.sqlitedb";
                FileOutputStream fous = new FileOutputStream(fileName);
                Algorithms.streamCopy((InputStream)cn.getInputStream(), (OutputStream)fous);
                fous.close();
                log.info((Object)"Finished downloading wikidata database");
            } else {
                log.info((Object)("Using local wikidata database: " + this.wikidataMappingUrl));
            }
            Connection wikiMapping = DBDialect.SQLITE.getDatabaseConnection(fileName, log);
            this.selectById = wikiMapping.prepareStatement("SELECT lang, title from wiki_mapping where id = ?");
            this.selectId = wikiMapping.prepareStatement("SELECT id from wiki_mapping where lang = ? and title = ? ");
            this.init = true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.init;
    }
}

