/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.osmand.PlatformUtil;
import org.apache.commons.logging.Log;

public class IndexWeatherData {
    private static final Log log = PlatformUtil.getLog(IndexWeatherData.class);
    public static final int NEAREST_NEIGHBOOR_INTERPOLATION = 0;
    public static final int BILINEAR_INTERPOLATION = 1;
    public static final int BICUBIC_INTERPOLATION = 2;
    public static int INTERPOLATION = 1;
    public static final double INEXISTENT_VALUE = Double.MIN_VALUE;
    public static final int REF_WIDTH = 1440;
    public static final int REF_HEIGHT = 721;
    private static final String ECWMF_WEATHER_TYPE = "ecmwf";

    public static void main(String[] args) throws IOException {
        IndexWeatherData.readWeatherData("/Users/victorshcherb/osmand/maps/weather/", "20220206_%02d00.tiff", 8, 23, 1);
    }

    private static void readWeatherData(String folder, String fmt, int min, int max, int step) throws IOException {
        double lat = 52.3121;
        double lon = 4.888;
        int len = (max + 1 - min) / step;
        double[][] wth = new double[6][len];
        long ms = System.currentTimeMillis();
        for (int i = 0; i < len; ++i) {
            int vl = min + step * i;
            WeatherTiff td = new WeatherTiff(new File(folder, String.format(fmt, vl)));
            for (int j = 0; j < 5; ++j) {
                wth[j + 1][i] = td.getValue(j, lat, lon, ECWMF_WEATHER_TYPE);
            }
            wth[0][i] = vl;
        }
        System.out.println("TIME    :      " + IndexWeatherData.format("%3.0f:00", wth[0]));
        System.out.println("Cloud %%:      " + IndexWeatherData.format("%6.2f", wth[1]));
        System.out.println("Temp (C):      " + IndexWeatherData.format("%6.1f", wth[2]));
        System.out.println("Pressure (kPa):" + IndexWeatherData.format("%6.2f", wth[3], 0.001));
        System.out.println("Wind (m/s):    " + IndexWeatherData.format("%6.2f", wth[4]));
        System.out.println("Precipitation: " + IndexWeatherData.format("%6.2f", wth[5], 1000000.0));
        System.out.println(System.currentTimeMillis() - ms + " ms");
    }

    private static String format(String fmt, double[] ds) {
        return IndexWeatherData.format(fmt, ds, 1.0);
    }

    private static String format(String fmt, double[] ds, double mult) {
        Object s = "";
        for (int i = 0; i < ds.length; ++i) {
            if (i > 0) {
                s = (String)s + "  ";
            }
            s = (String)s + String.format(fmt, ds[i] * mult);
        }
        return s;
    }

    public static class WeatherTiff {
        public double ORIGIN_LON = -180.125;
        public double ORIGIN_LAT = 90.125;
        public double PX_SIZE_LON = 0.25;
        public double PX_SIZE_LAT = -0.25;
        public double ECMWF_ORIGIN_LON = -180.1999;
        public double ECMWF_ORIGIN_LAT = 90.2;
        public double ECMWF_PX_SIZE_LON = 0.28;
        public double ECMWF_PX_SIZE_LAT = -0.28;
        public final File file;
        private DataBufferFloat data;
        private int height;
        private int width;
        private int bands;

        public WeatherTiff(File file) throws IOException {
            this.file = file;
            this.readFile(file);
        }

        public int getBands() {
            return this.bands;
        }

        private BufferedImage readFile(File file) {
            BufferedImage img = null;
            if (file.exists()) {
                img = this.iterativeReadData(file);
            }
            return img;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BufferedImage iterativeReadData(File file) {
            boolean readSuccess = false;
            BufferedImage img = null;
            Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix("tiff");
            ImageInputStream iis = null;
            while (readers.hasNext() && !readSuccess) {
                ImageReader reader = readers.next();
                if (!(reader instanceof TIFFImageReader)) continue;
                try {
                    iis = ImageIO.createImageInputStream(file);
                    reader.setInput(iis, true);
                    img = reader.read(0);
                    this.readWeatherData(img);
                    readSuccess = true;
                }
                catch (IOException e) {
                    log.info((Object)("Error reading TIFF file with reader " + reader.getClass().getName() + ": " + e.getMessage()));
                }
                finally {
                    reader.dispose();
                    if (iis == null) continue;
                    try {
                        iis.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("Error closing ImageInputStream: " + e.getMessage()));
                    }
                }
            }
            if (!readSuccess) {
                log.error((Object)"Failed to read TIFF file with all available readers.");
            }
            return img;
        }

        private void readWeatherData(BufferedImage img) {
            if (img != null) {
                this.width = img.getWidth();
                this.height = img.getHeight();
                this.data = (DataBufferFloat)img.getRaster().getDataBuffer();
                this.bands = this.data.getSize() / this.width / this.height;
            }
        }

        public double getValue(int band, double lat, double lon, String weatherType) {
            double x;
            double y;
            if (weatherType.equals(IndexWeatherData.ECWMF_WEATHER_TYPE)) {
                y = (lat - this.ECMWF_ORIGIN_LAT) / this.ECMWF_PX_SIZE_LAT;
                x = (lon - this.ECMWF_ORIGIN_LON) / this.ECMWF_PX_SIZE_LON;
            } else {
                y = (lat - this.ORIGIN_LAT) / this.PX_SIZE_LAT;
                x = (lon - this.ORIGIN_LON) / this.PX_SIZE_LON;
            }
            if (y < 0.0 || y > (double)this.height || x < 0.0 || x > (double)this.width) {
                return Double.MIN_VALUE;
            }
            return this.getInterpolationValue(band, x, y, null);
        }

        public double getInterpolationValue(int band, double x, double y, double[] array) {
            if (this.data == null) {
                return Double.MIN_VALUE;
            }
            if (INTERPOLATION == 1) {
                return this.bilinearInterpolation(band, x, y, array);
            }
            if (INTERPOLATION == 2) {
                return this.bicubicInterpolation(band, x, y, array);
            }
            return this.nearestNeighboor(band, x, y);
        }

        protected double nearestNeighboor(int band, double x, double y) {
            int px = (int)Math.round(x);
            int py = (int)Math.round(y);
            return this.getElem(band, px, py);
        }

        protected double getElem(int band, int px, int py) {
            int ind;
            if (px < 0) {
                px = 0;
            }
            if (py < 0) {
                py = 1;
            }
            if (px > this.width - 1) {
                px = this.width - 1;
            }
            if (py >= this.height - 1) {
                py = this.height - 1;
            }
            if ((ind = (px + py * this.width) * this.bands + band) >= this.data.getSize()) {
                throw new IllegalArgumentException("Illegal access (" + px + ", " + py + ") " + ind + " - " + this.file.getName());
            }
            return this.data.getElemDouble(ind);
        }

        protected double bilinearInterpolation(int band, double x, double y, double[] array) {
            int px = (int)Math.ceil(x);
            int py = (int)Math.ceil(y);
            if (array == null) {
                array = new double[]{this.getElem(band, px - 1, py - 1), this.getElem(band, px, py - 1), this.getElem(band, px - 1, py), this.getElem(band, px, py)};
            }
            double cx = x + 1.0 - (double)px;
            double cy = y + 1.0 - (double)py;
            double h = (1.0 - cx) * (1.0 - cy) * array[0] + cx * (1.0 - cy) * array[1] + (1.0 - cx) * cy * array[2] + cx * cy * array[3];
            return h;
        }

        protected double bicubicInterpolation(int band, double ix, double iy, double[] cf) {
            int px = (int)Math.floor(ix);
            int py = (int)Math.floor(iy);
            double x = ix - (double)px;
            double y = iy - (double)py;
            if (cf == null) {
                cf = new double[16];
            }
            for (int i = 0; i < cf.length; ++i) {
                cf[i] = 0.0;
            }
            cf[0] = (x - 1.0) * (x - 2.0) * (x + 1.0) * (y - 1.0) * (y - 2.0) * (y + 1.0) / 4.0 * this.getElem(band, px, py);
            cf[1] = -x * (x - 2.0) * (x + 1.0) * (y - 1.0) * (y - 2.0) * (y + 1.0) / 4.0 * this.getElem(band, px, py + 1);
            cf[2] = -(x - 1.0) * (x - 2.0) * (x + 1.0) * y * (y - 2.0) * (y + 1.0) / 4.0 * this.getElem(band, px + 1, py);
            cf[3] = x * (x - 2.0) * (x + 1.0) * y * (y - 2.0) * (y + 1.0) / 4.0 * this.getElem(band, px + 1, py + 1);
            cf[4] = -x * (x - 2.0) * (x - 1.0) * (y - 1.0) * (y - 2.0) * (y + 1.0) / 12.0 * this.getElem(band, px, py - 1);
            cf[5] = -(x + 1.0) * (x - 2.0) * (x - 1.0) * (y - 1.0) * (y - 2.0) * y / 12.0 * this.getElem(band, px - 1, py);
            cf[6] = x * (x - 2.0) * (x - 1.0) * (y + 1.0) * (y - 2.0) * y / 12.0 * this.getElem(band, px + 1, py - 1);
            cf[7] = x * (x - 2.0) * (x + 1.0) * (y - 1.0) * (y - 2.0) * y / 12.0 * this.getElem(band, px - 1, py + 1);
            cf[8] = x * (x - 1.0) * (x + 1.0) * (y - 1.0) * (y - 2.0) * (y + 1.0) / 12.0 * this.getElem(band, px, py + 2);
            cf[9] = (x - 2.0) * (x - 1.0) * (x + 1.0) * (y - 1.0) * y * (y + 1.0) / 12.0 * this.getElem(band, px + 2, py);
            cf[10] = x * (x - 1.0) * (x - 2.0) * y * (y - 1.0) * (y - 2.0) / 36.0 * this.getElem(band, px - 1, py - 1);
            cf[11] = -x * (x - 1.0) * (x + 1.0) * y * (y + 1.0) * (y - 2.0) / 12.0 * this.getElem(band, px + 1, py + 2);
            cf[12] = -x * (x + 1.0) * (x - 2.0) * y * (y - 1.0) * (y + 1.0) / 12.0 * this.getElem(band, px + 2, py + 1);
            cf[13] = -x * (x - 1.0) * (x + 1.0) * y * (y - 1.0) * (y - 2.0) / 36.0 * this.getElem(band, px - 1, py + 2);
            cf[14] = -x * (x - 1.0) * (x - 2.0) * y * (y - 1.0) * (y + 1.0) / 36.0 * this.getElem(band, px + 2, py - 1);
            cf[15] = x * (x - 1.0) * (x + 1.0) * y * (y - 1.0) * (y + 1.0) / 36.0 * this.getElem(band, px + 2, py + 2);
            double h = 0.0;
            for (int i = 0; i < cf.length; ++i) {
                h += cf[i];
            }
            return h;
        }
    }
}

