/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import gnu.trove.set.hash.TLongHashSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.obf.ToolsOsmAndContextImpl;
import net.osmand.obf.preparation.IndexCreationContext;
import net.osmand.obf.preparation.IndexPoiCreator;
import net.osmand.obf.preparation.IndexVectorMapCreator;
import net.osmand.obf.preparation.OsmDbAccessorContext;
import net.osmand.obf.preparation.OverpassFetcher;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.OsmRouteType;
import net.osmand.osm.RelationTagsPropagation;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.OsmMapUtils;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.shared.api.OsmAndContext;
import net.osmand.shared.gpx.RouteActivityHelper;
import net.osmand.shared.gpx.primitives.RouteActivity;
import net.osmand.shared.util.PlatformUtil;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexRouteRelationCreator {
    private static final String[] FILTERED_TAGS = new String[]{"hiking", "bicycle", "foot", "mtb", "piste", "ski", "horse", "running", "snowmobile", "fitness_trail", "canoe", "canyoning", "motorboat", "boat", "waterway", "inline_skates", "via_ferrata", "walking", "ferrata"};
    private static final boolean DEBUG_GENERATE_ROUTE_SEGMENT = false;
    private static final String SHIELD_FG = "shield_fg";
    private static final String SHIELD_BG = "shield_bg";
    private static final String SHIELD_TEXT = "shield_text";
    private static final String SHIELD_STUB_NAME = "shield_stub_name";
    private static final String ROUTE = "route";
    public static final int MIN_REF_LENGTH_TO_USE_FOR_SEARCH = 3;
    public static final int MAX_JOINED_POINTS_PER_SEGMENT = 2000;
    public static final int POI_SEARCH_POINTS_INTERVAL_M = 5000;
    public static final int POI_SEARCH_POINTS_EDGE_DISTANCE_M = 100;
    public static final String ROUTE_ID_TAG = "route_id";
    public static final String ROUTE_TYPE = "route_type";
    public static final String TRACK_COLOR = "track_color";
    private static final String SHIELD_WAYCOLOR = "shield_waycolor";
    public static final String COLOR = "color";
    private static final String COLOUR = "colour";
    public static final String DISPLAYCOLOR = "displaycolor";
    private static final String OSMAND_ACTIVITY = "osmand:activity";
    private static final String ROUTE_ACTIVITY_TYPE = "route_activity_type";
    private static final String[] COLOR_TAGS_FOR_MAP_SECTION = new String[]{"track_color", "shield_waycolor", "color", "colour", "displaycolor"};
    private static final Map<String, String> OSMC_TAGS_TO_SHIELD_PROPS = Map.of("osmc_text", "shield_text", "osmc_background", "shield_bg", "osmc_foreground", "shield_fg", "osmc_foreground2", "shield_fg_2", "osmc_textcolor", "shield_textcolor", "osmc_waycolor", "shield_waycolor");
    private static final String OSMC_ICON_PREFIX = "osmc_";
    private static final String OSMC_ICON_BG_SUFFIX = "_bg";
    private static final Set<String> SHIELD_BG_ICONS = Set.of("shield_bg");
    private static final Set<String> SHIELD_FG_ICONS = Set.of("shield_fg", "shield_fg_2");
    private static final String RELATION_ID = OSMSettings.OSMTagKey.RELATION_ID.getValue();
    private static long INTERNAL_NEGATIVE_BASE_ID = -1048576L;
    private static final RouteActivityHelper routeActivityHelper = RouteActivityHelper.INSTANCE;
    private static final Log log = LogFactory.getLog(IndexRouteRelationCreator.class);
    private final IndexPoiCreator indexPoiCreator;
    private final IndexVectorMapCreator indexMapCreator;
    private final RelationTagsPropagation transformer;
    private final MapRenderingTypesEncoder renderingTypes;
    private final Long lastModifiedDate;
    private static final NumberFormat distanceKmFormat = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.US));

    public IndexRouteRelationCreator(@Nonnull IndexPoiCreator indexPoiCreator, @Nonnull IndexVectorMapCreator indexMapCreator, Long lastModifiedDate) {
        this.indexPoiCreator = indexPoiCreator;
        this.indexMapCreator = indexMapCreator;
        this.transformer = indexMapCreator.tagsTransformer;
        this.renderingTypes = indexMapCreator.renderingTypes;
        this.lastModifiedDate = lastModifiedDate;
        PlatformUtil.INSTANCE.initialize((OsmAndContext)new ToolsOsmAndContextImpl());
    }

    public void iterateRelation(Relation relation, OsmDbAccessorContext ctx, IndexCreationContext icc) throws SQLException {
        LinkedHashMap<String, String> preparedTags;
        if (!IndexRouteRelationCreator.isSupportedRouteType(relation.getTag(ROUTE))) {
            return;
        }
        if (ROUTE.equals(relation.getTag("type"))) {
            ArrayList<Way> joinedWays = new ArrayList<Way>();
            ArrayList<Node> pointsForPoiSearch = new ArrayList<Node>();
            preparedTags = new LinkedHashMap<String, String>();
            TLongHashSet geometryBeforeCompletion = new TLongHashSet();
            this.fillRelationWaysGeometrySet(relation, geometryBeforeCompletion);
            OverpassFetcher.getInstance().fetchCompleteGeometryRelation(relation, ctx, this.lastModifiedDate);
            int hash = this.getRelationHash(relation);
            if (hash == -1) {
                log.error((Object)String.format("Route relation %d is incomplete", relation.getId()));
                return;
            }
            this.collectJoinedWaysAndShieldTags(relation, joinedWays, preparedTags, hash);
            this.calcRadiusDistanceAndPoiSearchPoints(relation.getId(), joinedWays, pointsForPoiSearch, preparedTags, hash);
            LinkedHashMap<String, String> mapSectionTags = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> poiSectionTags = new LinkedHashMap<String, String>();
            this.collectMapAndPoiSectionTags(relation, preparedTags, mapSectionTags, poiSectionTags);
            block0: for (Way way : joinedWays) {
                for (Node node : way.getNodes()) {
                    if (!geometryBeforeCompletion.contains(this.getNodeLongId(node))) continue;
                    way.replaceTags(mapSectionTags);
                    this.indexMapCreator.iterateMainEntity((Entity)way, ctx, icc);
                    continue block0;
                }
            }
            for (Node node : pointsForPoiSearch) {
                if (!geometryBeforeCompletion.contains(this.getNodeLongId(node))) continue;
                poiSectionTags.forEach((arg_0, arg_1) -> ((Node)node).putTag(arg_0, arg_1));
                this.indexPoiCreator.iterateEntity((Entity)node, ctx, icc);
            }
            this.indexPoiCreator.excludeFromMainIteration(relation.getId());
        }
        if (OsmMapUtils.isSuperRoute((Map)relation.getTags())) {
            LinkedHashMap<String, String> mapSectionTags = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> poiSectionTags = new LinkedHashMap<String, String>();
            preparedTags = new LinkedHashMap();
            this.collectMapAndPoiSectionTags(relation, preparedTags, mapSectionTags, poiSectionTags);
            for (Map.Entry entry : poiSectionTags.entrySet()) {
                relation.putTag((String)entry.getKey(), (String)entry.getValue());
            }
            this.indexPoiCreator.iterateEntity((Entity)relation, ctx, icc);
            this.indexPoiCreator.excludeFromMainIteration(relation.getId());
        }
    }

    private void fillRelationWaysGeometrySet(Relation relation, TLongHashSet geometryBeforeCompletion) {
        for (Relation.RelationMember member : relation.getMembers()) {
            Entity entity = member.getEntity();
            if (!(entity instanceof Way)) continue;
            Way way = (Way)entity;
            for (Node node : way.getNodes()) {
                geometryBeforeCompletion.add(this.getNodeLongId(node));
            }
        }
    }

    private long getNodeLongId(Node node) {
        long y31 = MapUtils.get31TileNumberY((double)node.getLatitude());
        long x31 = MapUtils.get31TileNumberX((double)node.getLongitude());
        return (x31 << 31) + y31;
    }

    private void calcRadiusDistanceAndPoiSearchPoints(long relationId, @Nonnull List<Way> joinedWays, @Nonnull List<Node> pointsForPoiSearch, @Nonnull Map<String, String> tagsToFill, int hash) {
        int MIN_RADIUS_FOR_SHORT_LINK = 50000;
        int SHORT_LINK_ZOOM = 9;
        TreeSet<String> shortLinkTiles = new TreeSet<String>();
        double distance = 0.0;
        QuadRect bbox = new QuadRect();
        int searchPointsCounter = 0;
        for (int segmentIndex = 0; segmentIndex < joinedWays.size(); ++segmentIndex) {
            Way way = joinedWays.get(segmentIndex);
            QuadRect wayBbox = way.getLatLonBBox();
            bbox.expand(wayBbox.left, wayBbox.top, wayBbox.right, wayBbox.bottom);
            ArrayList<Node> localPoints = new ArrayList<Node>();
            List nodes = way.getNodes();
            if (nodes.size() >= 2) {
                LatLon middle = ((Node)nodes.get(nodes.size() / 2)).getLatLon();
                long nodeId = IndexRouteRelationCreator.calcEntityIdFromRelationId(relationId, searchPointsCounter++, hash);
                localPoints.add(new Node(middle.getLatitude(), middle.getLongitude(), nodeId));
                for (int i = 1; i < nodes.size(); ++i) {
                    LatLon currentLatLon = ((Node)nodes.get(i)).getLatLon();
                    LatLon previousLatLon = ((Node)nodes.get(i - 1)).getLatLon();
                    distance += MapUtils.getDistance((LatLon)currentLatLon, (LatLon)previousLatLon);
                    int alternateIndex = i % 2 == 0 ? i : nodes.size() - i - 1;
                    LatLon candidate = ((Node)nodes.get(alternateIndex)).getLatLon();
                    double distStart = MapUtils.getDistance((LatLon)candidate, (LatLon)((Node)nodes.get(0)).getLatLon());
                    double distEnd = MapUtils.getDistance((LatLon)candidate, (LatLon)((Node)nodes.get(nodes.size() - 1)).getLatLon());
                    if (!(distStart > 100.0) || !(distEnd > 100.0) || !localPoints.stream().noneMatch(node -> MapUtils.getDistance((LatLon)candidate, (LatLon)node.getLatLon()) < 5000.0)) continue;
                    nodeId = IndexRouteRelationCreator.calcEntityIdFromRelationId(relationId, searchPointsCounter++, hash);
                    localPoints.add(new Node(candidate.getLatitude(), candidate.getLongitude(), nodeId));
                }
            }
            for (Node node2 : localPoints) {
                node2.putTag("route_segment_index", String.valueOf(segmentIndex));
            }
            pointsForPoiSearch.addAll(localPoints);
        }
        if (distance > 0.0) {
            tagsToFill.put("distance", distanceKmFormat.format(distance / 1000.0));
        }
        if (!bbox.hasInitialState()) {
            int radius = (int)MapUtils.getDistance((double)bbox.left, (double)bbox.top, (double)bbox.right, (double)bbox.bottom);
            String routeBboxRadius = MapUtils.convertDistToChar((int)radius, (char)'A', (int)5000, (int)2, (int)5);
            if (radius > 50000) {
                pointsForPoiSearch.forEach(node -> shortLinkTiles.add(MapUtils.createShortLinkString((double)node.getLatitude(), (double)node.getLongitude(), (int)1)));
                shortLinkTiles.add(MapUtils.createShortLinkString((double)bbox.bottom, (double)bbox.left, (int)1));
                shortLinkTiles.add(MapUtils.createShortLinkString((double)bbox.top, (double)bbox.right, (int)1));
                tagsToFill.put("route_shortlink_tiles", String.join((CharSequence)",", shortLinkTiles));
            }
            tagsToFill.put("route_bbox_radius", routeBboxRadius);
        }
    }

    private void collectMapAndPoiSectionTags(@Nonnull Relation relation, @Nonnull Map<String, String> preparedTags, @Nonnull Map<String, String> mapSectionTags, @Nonnull Map<String, String> poiSectionTags) {
        LinkedHashMap<String, String> commonTags = new LinkedHashMap<String, String>(relation.getTags());
        commonTags.putAll(relation.getTags());
        commonTags.put("width", "roadstyle");
        commonTags.put("translucent_line_colors", "yes");
        commonTags.put(ROUTE_ID_TAG, "O" + relation.getId());
        commonTags.putAll(preparedTags);
        String ref = (String)commonTags.get("ref");
        if (ref != null && ref.length() >= 3) {
            commonTags.put("name:ref", ref);
        }
        IndexRouteRelationCreator.finalizeRouteShieldTags(commonTags);
        IndexRouteRelationCreator.finalizeActivityTypeAndColors(commonTags, null, null, null);
        mapSectionTags.putAll(commonTags);
        poiSectionTags.putAll(commonTags);
        poiSectionTags.remove(TRACK_COLOR);
        poiSectionTags.remove(ROUTE);
    }

    public static void finalizeRouteShieldTags(Map<String, String> tags) {
        String text;
        if (tags.containsKey("ref") || tags.containsKey(SHIELD_TEXT)) {
            tags.remove(SHIELD_STUB_NAME);
        } else if (tags.containsKey(SHIELD_FG) || tags.containsKey(SHIELD_BG)) {
            tags.put(SHIELD_STUB_NAME, ".");
        }
        if (tags.containsKey(SHIELD_TEXT) && (text = tags.get(SHIELD_TEXT)).length() >= 3 && !text.equals(tags.get("ref"))) {
            tags.put("name:sym", text);
        }
    }

    public static void finalizeActivityTypeAndColors(@Nonnull Map<String, String> commonTags, @Nullable Map<String, String> metadataExtraTags, @Nullable Map<String, String> extensionsExtraTags, @Nullable String[] gpxInfoTags) {
        String[] activityTags = new String[]{ROUTE_ACTIVITY_TYPE, OSMAND_ACTIVITY, ROUTE};
        if (gpxInfoTags != null) {
            OsmRouteType compatibleOsmRouteType = OsmRouteType.getTypeFromTags((String[])gpxInfoTags);
            if (extensionsExtraTags != null) {
                for (String tg : gpxInfoTags) {
                    extensionsExtraTags.put("tag_" + tg, "yes");
                }
            }
            if (compatibleOsmRouteType != null) {
                if (compatibleOsmRouteType.getColor() != null) {
                    commonTags.putIfAbsent(TRACK_COLOR, compatibleOsmRouteType.getColor());
                }
                commonTags.putIfAbsent(ROUTE_ACTIVITY_TYPE, compatibleOsmRouteType.getName().toLowerCase());
            }
        }
        LinkedHashMap<String, String> allTags = new LinkedHashMap<String, String>(commonTags);
        if (metadataExtraTags != null) {
            allTags.putAll(metadataExtraTags);
        }
        if (extensionsExtraTags != null) {
            allTags.putAll(extensionsExtraTags);
        }
        for (String tag : COLOR_TAGS_FOR_MAP_SECTION) {
            if (!allTags.containsKey(tag)) continue;
            commonTags.put(TRACK_COLOR, MapRenderingTypesEncoder.formatColorToPalette((String)allTags.get(tag), false));
            break;
        }
        for (String tag : activityTags) {
            String values = (String)allTags.get(tag);
            if (values == null) continue;
            for (String val : values.split("[;, ]")) {
                RouteActivity activity = routeActivityHelper.findRouteActivity(val);
                if (activity == null) {
                    activity = routeActivityHelper.findActivityByTag(val);
                }
                if (activity == null) continue;
                commonTags.put(ROUTE_TYPE, activity.getGroup().getId());
                commonTags.put(ROUTE_ACTIVITY_TYPE, activity.getId());
                return;
            }
        }
        commonTags.putIfAbsent(ROUTE_TYPE, "other");
    }

    private void collectJoinedWaysAndShieldTags(@Nonnull Relation relation, @Nonnull List<Way> joinedWays, @Nonnull Map<String, String> shieldTags, int hash) {
        ArrayList<Way> waysToJoin = new ArrayList<Way>();
        for (Relation.RelationMember member : relation.getMembers()) {
            Way way;
            Entity entity = member.getEntity();
            if (!(entity instanceof Way) || "yes".equals((way = (Way)entity).getTag(OSMSettings.OSMTagKey.AREA))) continue;
            waysToJoin.add(way);
            this.transformer.addPropogatedTags(this.renderingTypes, MapRenderingTypesEncoder.EntityConvertApplyType.MAP, (Entity)way, way.getModifiableTags());
            shieldTags.putAll(IndexRouteRelationCreator.getShieldTagsFromOsmcTags(way.getTags(), relation.getId()));
        }
        IndexRouteRelationCreator.spliceWaysIntoSegments(waysToJoin, joinedWays, relation.getId(), hash);
    }

    public static void spliceWaysIntoSegments(@Nonnull List<Way> waysToJoin, @Nonnull List<Way> joinedWays, long relationId, int hash) {
        boolean[] done = new boolean[waysToJoin.size()];
        while (true) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (int i = 0; i < waysToJoin.size(); ++i) {
                boolean stop;
                if (done[i]) continue;
                done[i] = true;
                if (waysToJoin.get(i).getNodeIds().isEmpty()) continue;
                IndexRouteRelationCreator.addWayToNodes(nodes, false, waysToJoin.get(i), false);
                do {
                    stop = true;
                    for (int j = 0; j < waysToJoin.size(); ++j) {
                        if (done[j] || !IndexRouteRelationCreator.considerWayToJoin(nodes, waysToJoin.get(j))) continue;
                        done[j] = true;
                        stop = false;
                    }
                } while (!stop);
                break;
            }
            if (nodes.isEmpty()) break;
            long generatedId = IndexRouteRelationCreator.calcEntityIdFromRelationId(relationId, joinedWays.size(), hash);
            joinedWays.add(new Way(generatedId, nodes));
        }
    }

    private int getRelationHash(@Nonnull Relation relation) {
        ArrayList<Node> allNodes = new ArrayList<Node>();
        for (Relation.RelationMember member : relation.getMembers()) {
            Entity entity = member.getEntity();
            if (entity instanceof Node) {
                Node node = (Node)entity;
                allNodes.add(node);
            }
            if (!((entity = member.getEntity()) instanceof Way)) continue;
            Way way = (Way)entity;
            if (way.getNodes().isEmpty()) {
                return -1;
            }
            allNodes.addAll(way.getNodes());
        }
        LatLon center = OsmMapUtils.getWeightCenterForNodes(allNodes);
        return center == null ? allNodes.size() % 64 : (int)(1000.0 * Math.abs(center.getLatitude() + center.getLongitude())) % 64;
    }

    private static long calcEntityIdFromRelationId(long relationId, long counter, int hash) {
        long MAX_RELATION_ID_BITS = 27L;
        long MAX_COUNTER_BITS = 9L;
        long MAX_HASH_BITS = 6L;
        if (relationId < 0L || relationId >= 0x8000000L || counter < 0L || counter >= 512L || hash < 0 || (long)hash >= 64L) {
            log.error((Object)String.format("calcEntityIdFromRelationId() relation %d/%d/%d overflow (%d/%d/%d bits)", relationId, counter, hash, 27L, 9L, 6L));
        }
        return 0x40000000000L + (relationId << 15) + (counter << 6) + (long)hash;
    }

    private static boolean considerWayToJoin(List<Node> result, Way candidate) {
        if (result.isEmpty() || result.size() > 2000) {
            return false;
        }
        if (candidate.getNodes().isEmpty()) {
            return true;
        }
        LatLon firstNodeLL = result.get(0).getLatLon();
        LatLon lastNodeLL = result.get(result.size() - 1).getLatLon();
        LatLon firstCandidateLL = ((Node)candidate.getNodes().get(0)).getLatLon();
        LatLon lastCandidateLL = ((Node)candidate.getNodes().get(candidate.getNodes().size() - 1)).getLatLon();
        if (MapUtils.areLatLonEqual((LatLon)lastNodeLL, (LatLon)firstCandidateLL)) {
            IndexRouteRelationCreator.addWayToNodes(result, false, candidate, false);
        } else if (MapUtils.areLatLonEqual((LatLon)lastNodeLL, (LatLon)lastCandidateLL)) {
            IndexRouteRelationCreator.addWayToNodes(result, false, candidate, true);
        } else if (MapUtils.areLatLonEqual((LatLon)firstNodeLL, (LatLon)firstCandidateLL)) {
            IndexRouteRelationCreator.addWayToNodes(result, true, candidate, true);
        } else if (MapUtils.areLatLonEqual((LatLon)firstNodeLL, (LatLon)lastCandidateLL)) {
            IndexRouteRelationCreator.addWayToNodes(result, true, candidate, false);
        } else {
            return false;
        }
        return true;
    }

    private static void addWayToNodes(List<Node> nodes, boolean insert, Way way, boolean reverse) {
        ArrayList<Node> points = new ArrayList<Node>();
        for (Node n : way.getNodes()) {
            points.add(new Node(n.getLatitude(), n.getLongitude(), INTERNAL_NEGATIVE_BASE_ID--));
        }
        if (reverse) {
            Collections.reverse(points);
        }
        if (!nodes.isEmpty() && !points.isEmpty()) {
            List skipLeadingPoint = points.subList(insert ? 0 : 1, points.size() - (insert ? 1 : 0));
            nodes.addAll(insert ? 0 : nodes.size(), skipLeadingPoint);
        } else {
            nodes.addAll(insert ? 0 : nodes.size(), points);
        }
    }

    public static boolean isSupportedRouteType(@Nullable String routeType) {
        if (routeType != null) {
            for (String tag : routeType.split("[;, ]")) {
                for (String value : FILTERED_TAGS) {
                    if (!tag.startsWith(value) && !tag.endsWith(value)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nonnull
    public static Map<String, String> getShieldTagsFromOsmcTags(@Nonnull Map<String, String> tags, long relationId) {
        String requiredGroupPrefix = "route_";
        if (relationId != 0L) {
            for (String tag : tags.keySet()) {
                if (!tag.endsWith(RELATION_ID) || !tags.get(tag).equals(Long.toString(relationId))) continue;
                requiredGroupPrefix = tag.replace(RELATION_ID, "");
                break;
            }
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String tag : tags.keySet()) {
            for (String match : OSMC_TAGS_TO_SHIELD_PROPS.keySet()) {
                if (!tag.startsWith(requiredGroupPrefix) || !tag.endsWith(match)) continue;
                String key = OSMC_TAGS_TO_SHIELD_PROPS.get(match);
                String prefix = SHIELD_BG_ICONS.contains(key) || SHIELD_FG_ICONS.contains(key) ? OSMC_ICON_PREFIX : "";
                String suffix = SHIELD_BG_ICONS.contains(key) ? OSMC_ICON_BG_SUFFIX : "";
                String val = prefix + tags.get(tag) + suffix;
                result.putIfAbsent(key, val);
            }
        }
        return result;
    }

    public void closeAllStatements() {
    }
}

