/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import net.osmand.shared.KException;
import net.osmand.shared.data.KQuadRect;
import net.osmand.shared.extensions.ClockExtensionsKt;
import net.osmand.shared.gpx.GpxDataItem;
import net.osmand.shared.gpx.GpxDbHelper;
import net.osmand.shared.gpx.GpxParameter;
import net.osmand.shared.gpx.GpxTrackAnalysis;
import net.osmand.shared.gpx.GpxUtilities;
import net.osmand.shared.gpx.SplitSegment;
import net.osmand.shared.gpx.primitives.GpxExtensions;
import net.osmand.shared.gpx.primitives.Metadata;
import net.osmand.shared.gpx.primitives.Route;
import net.osmand.shared.gpx.primitives.Track;
import net.osmand.shared.gpx.primitives.TrkSegment;
import net.osmand.shared.gpx.primitives.WptPt;
import net.osmand.shared.io.KFile;
import net.osmand.shared.util.KMapUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\u0007\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u00f2\u00012\u00020\u0001:\u0002\u00f2\u0001B\u0013\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B'\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\tJ\u0006\u0010G\u001a\u000203J\u0006\u00108\u001a\u000203J\u0006\u0010H\u001a\u000203J\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u001f0JJ\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u001f0JJ\u0014\u0010L\u001a\u00020M2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0JJ\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u001f0JJ\u0006\u0010O\u001a\u000203J\u0006\u0010P\u001a\u00020QJ\u000e\u0010R\u001a\u0002032\u0006\u0010S\u001a\u00020\u001fJ\u0006\u0010T\u001a\u00020MJ\u0006\u0010U\u001a\u00020MJ\u000e\u0010V\u001a\u00020M2\u0006\u0010S\u001a\u00020\u001fJ\u000e\u0010W\u001a\u00020M2\u0006\u0010S\u001a\u00020\u001fJ\u0016\u0010V\u001a\u00020M2\u0006\u0010X\u001a\u00020Q2\u0006\u0010S\u001a\u00020\u001fJ\u0014\u0010Y\u001a\u00020M2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u001f0[J\u000e\u0010\\\u001a\u00020M2\u0006\u0010]\u001a\u00020\"J\u0016\u0010^\u001a\u00020M2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u001f0[H\u0002J\u0010\u0010_\u001a\u00020\"2\u0006\u0010S\u001a\u00020\u001fH\u0002J\u000e\u0010`\u001a\u0002032\u0006\u0010S\u001a\u00020\u001fJ\u0016\u0010`\u001a\u0002032\u0006\u0010a\u001a\u00020\u00032\u0006\u0010b\u001a\u00020QJ\u0010\u0010c\u001a\u00020M2\u0006\u0010S\u001a\u00020\u001fH\u0002J\u001a\u0010c\u001a\u00020M2\u0006\u0010S\u001a\u00020\u001f2\b\u0010d\u001a\u0004\u0018\u00010\u0003H\u0002J&\u0010e\u001a\u00020M2\u0006\u0010a\u001a\u00020\u00032\u0006\u0010f\u001a\u00020Q2\u0006\u0010g\u001a\u00020\u001f2\u0006\u0010h\u001a\u000203J\u001a\u0010i\u001a\u0004\u0018\u00010\u001f2\u0006\u0010a\u001a\u00020\u00032\u0006\u0010f\u001a\u00020QH\u0002J \u0010e\u001a\u00020M2\u0006\u0010j\u001a\u00020\u001f2\u0006\u0010g\u001a\u00020\u001f2\b\b\u0002\u0010h\u001a\u000203J\u0016\u0010k\u001a\u00020M2\u0006\u0010l\u001a\u00020\u00032\u0006\u0010m\u001a\u00020\"J\u0006\u0010n\u001a\u000203J\u0006\u0010o\u001a\u000203J\u0006\u0010p\u001a\u00020MJ\b\u0010q\u001a\u0004\u0018\u00010\u0015J\b\u0010r\u001a\u0004\u0018\u00010FJ\b\u0010s\u001a\u00020MH\u0002J\u000e\u0010t\u001a\u00020u2\u0006\u0010v\u001a\u00020<J&\u0010t\u001a\u00020u2\u0006\u0010v\u001a\u00020<2\u0016\u0010w\u001a\u0012\u0012\u0004\u0012\u00020y\u0012\u0006\u0012\u0004\u0018\u00010z\u0018\u00010xJ2\u0010t\u001a\u00020u2\u0006\u0010v\u001a\u00020<2\b\u0010{\u001a\u0004\u0018\u00010|2\b\u0010}\u001a\u0004\u0018\u00010|2\b\u0010~\u001a\u0004\u0018\u00010\u007f\u00a2\u0006\u0003\u0010\u0080\u0001JJ\u0010t\u001a\u00020u2\u0006\u0010v\u001a\u00020<2\b\u0010{\u001a\u0004\u0018\u00010|2\b\u0010}\u001a\u0004\u0018\u00010|2\u0016\u0010w\u001a\u0012\u0012\u0004\u0012\u00020y\u0012\u0006\u0012\u0004\u0018\u00010z\u0018\u00010x2\b\u0010~\u001a\u0004\u0018\u00010\u007f\u00a2\u0006\u0003\u0010\u0081\u0001J3\u0010\u0082\u0001\u001a\t\u0012\u0005\u0012\u00030\u0083\u00010J2\u0007\u0010\u0084\u0001\u001a\u00020u2\b\u0010{\u001a\u0004\u0018\u00010|2\b\u0010}\u001a\u0004\u0018\u00010|H\u0002\u00a2\u0006\u0003\u0010\u0085\u0001J-\u0010\u0086\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u0087\u0001\u001a\u00020F2\b\u0010{\u001a\u0004\u0018\u00010|2\b\u0010}\u001a\u0004\u0018\u00010|H\u0002\u00a2\u0006\u0003\u0010\u0088\u0001J\u001e\u0010\u0089\u0001\u001a\u00020Q2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0J2\u0007\u0010\u008a\u0001\u001a\u00020|J\u000f\u0010\u008b\u0001\u001a\u0002032\u0006\u0010S\u001a\u00020\u001fJ\r\u0010\u008c\u0001\u001a\b\u0012\u0004\u0012\u00020\u001f0JJ\u0016\u0010\u008c\u0001\u001a\b\u0012\u0004\u0012\u00020\u001f0J2\u0007\u0010\u008d\u0001\u001a\u00020QJ\u0007\u0010\u008e\u0001\u001a\u000203J\u0007\u0010\u008f\u0001\u001a\u000203J\u0007\u0010\u0090\u0001\u001a\u000203J\u0007\u0010\u0091\u0001\u001a\u000203J\u0016\u0010\u0092\u0001\u001a\b\u0012\u0004\u0012\u00020F0J2\u0007\u0010\u0093\u0001\u001a\u000203J\u0015\u0010\u0094\u0001\u001a\u00020M2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0JJ\u0019\u0010\u0095\u0001\u001a\u0002032\u0007\u0010\u0096\u0001\u001a\u00020F2\u0007\u0010\u0097\u0001\u001a\u00020FJ\u001e\u0010\u0098\u0001\u001a\u00020M2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0J2\u0007\u0010\u0099\u0001\u001a\u000203J\u0015\u0010\u009a\u0001\u001a\u00020M2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0JJ\t\u0010\u009b\u0001\u001a\u00020MH\u0002J\u0010\u0010\u009c\u0001\u001a\u0002032\u0007\u0010\u0087\u0001\u001a\u00020FJ\u0010\u0010\u009d\u0001\u001a\u0002032\u0007\u0010\u009e\u0001\u001a\u00020\u001fJ\r\u0010\u009f\u0001\u001a\b\u0012\u0004\u0012\u00020F0JJ\r\u0010\u00a0\u0001\u001a\b\u0012\u0004\u0012\u00020F0JJ\t\u0010\u00a1\u0001\u001a\u0004\u0018\u00010\u001fJ\t\u0010\u00a2\u0001\u001a\u0004\u0018\u00010\u001fJ\u0007\u0010\u00a3\u0001\u001a\u000203J\u0015\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150J2\u0007\u0010\u00a4\u0001\u001a\u000203J\u0016\u0010\u00a5\u0001\u001a\b\u0012\u0004\u0012\u00020F0J2\u0007\u0010\u00a4\u0001\u001a\u000203J\u0007\u0010\u00a6\u0001\u001a\u00020QJ\u0007\u0010\u00a7\u0001\u001a\u00020QJ\u0007\u0010\u00a8\u0001\u001a\u00020QJ\u000e\u0010\u00a9\u0001\u001a\t\u0012\u0004\u0012\u00020\u00030\u00aa\u0001J\b\u0010\u00ab\u0001\u001a\u00030\u00ac\u0001J\u001a\u0010\u00ad\u0001\u001a\u00030\u00ac\u00012\u0007\u0010\u00ae\u0001\u001a\u00020|2\u0007\u0010\u00af\u0001\u001a\u00020|J\t\u0010\u00b0\u0001\u001a\u0004\u0018\u00010\u0003J\t\u0010\u00b1\u0001\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u00b2\u0001\u001a\u00020M2\u0007\u0010\u00b3\u0001\u001a\u00020\u0003J\u0007\u0010\u00b4\u0001\u001a\u00020MJ\t\u0010\u00b5\u0001\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u00b6\u0001\u001a\u00020M2\u0007\u0010\u00b7\u0001\u001a\u00020\u0003J\u0007\u0010\u00b8\u0001\u001a\u00020|J\u0010\u0010\u00b9\u0001\u001a\u00020M2\u0007\u0010\u00ba\u0001\u001a\u00020|J\u0007\u0010\u00bb\u0001\u001a\u000203J\u0007\u0010\u00bc\u0001\u001a\u000203J\u0010\u0010\u00bd\u0001\u001a\u00020M2\u0007\u0010\u00be\u0001\u001a\u000203J\t\u0010\u00bf\u0001\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u00c0\u0001\u001a\u00020M2\u0007\u0010\u00c1\u0001\u001a\u00020\u0003J\t\u0010\u00c2\u0001\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u00c3\u0001\u001a\u00020M2\u0007\u0010\u00c4\u0001\u001a\u00020\u0003J\t\u0010\u00c5\u0001\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u00c6\u0001\u001a\u00020M2\u0007\u0010\u00c7\u0001\u001a\u00020\u0003J\u0011\u0010\u00c8\u0001\u001a\u00020M2\b\u0010\u00c9\u0001\u001a\u00030\u00ca\u0001J\b\u0010\u00cb\u0001\u001a\u00030\u00ca\u0001J\u0011\u0010\u00cc\u0001\u001a\u00020M2\b\u0010\u00cd\u0001\u001a\u00030\u00ca\u0001J\b\u0010\u00ce\u0001\u001a\u00030\u00ca\u0001J\u0007\u0010\u00cf\u0001\u001a\u000203J\u0007\u0010\u00d0\u0001\u001a\u000203J\u0010\u0010\u00d1\u0001\u001a\u00020M2\u0007\u0010\u00d2\u0001\u001a\u000203J\u0007\u0010\u00d3\u0001\u001a\u000203J\u0010\u0010\u00d4\u0001\u001a\u00020M2\u0007\u0010\u00d5\u0001\u001a\u000203J\u001c\u0010\u00d6\u0001\u001a\u00020M2\u0013\u0010\u00d7\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030xJ\u0013\u0010\u00d8\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030xJ\u0010\u0010\u00d9\u0001\u001a\u00020M2\u0007\u0010\u00da\u0001\u001a\u00020\u0003J\t\u0010\u00db\u0001\u001a\u0004\u0018\u00010\u0003J\u0007\u0010\u00dc\u0001\u001a\u00020\u0003J\t\u0010\u00dd\u0001\u001a\u0004\u0018\u00010\u0003J\u0007\u0010\u00de\u0001\u001a\u00020QJ\u0007\u0010\u00df\u0001\u001a\u00020<J\u0017\u0010\u00df\u0001\u001a\u00020<2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0JH\u0002J\u0007\u0010\u00e0\u0001\u001a\u00020\u0000J\u0012\u0010\u00e1\u0001\u001a\u00020\u00152\u0007\u0010\u00e2\u0001\u001a\u00020\u0015H\u0002J\u0012\u0010\u00e3\u0001\u001a\u00020\u001b2\u0007\u0010\u00e2\u0001\u001a\u00020\u001bH\u0002J\u0012\u0010\u00e4\u0001\u001a\u00020\"2\u0007\u0010\u00e2\u0001\u001a\u00020\"H\u0002J\u0012\u0010\u00e5\u0001\u001a\u00020F2\u0007\u0010\u00e2\u0001\u001a\u00020FH\u0002J\u0014\u0010\u00e6\u0001\u001a\u00030\u00e7\u00012\b\u0010\u00e2\u0001\u001a\u00030\u00e7\u0001H\u0002J\u0014\u0010\u00e8\u0001\u001a\u00030\u00e9\u00012\b\u0010\u00e2\u0001\u001a\u00030\u00e9\u0001H\u0002J\t\u0010\u00ea\u0001\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u00eb\u0001\u001a\u00020M2\u0007\u0010\u00ec\u0001\u001a\u00020\u0003J\u0014\u0010\u00ed\u0001\u001a\u0004\u0018\u00010\u001b2\t\u0010\u00ee\u0001\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u00ef\u0001\u001a\u00020M2\u0007\u0010\u00f0\u0001\u001a\u00020\u0003J\u0007\u0010\u00f1\u0001\u001a\u000203R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0005R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\"0!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001d\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030!\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010$R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u000b\"\u0004\b1\u0010\u0005R\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u00105\"\u0004\b:\u00107R\u001a\u0010;\u001a\u00020<X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001a\u0010A\u001a\u00020<X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010>\"\u0004\bC\u0010@R\u0010\u0010D\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010E\u001a\u0004\u0018\u00010FX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00f3\u0001"}, d2={"Lnet/osmand/shared/gpx/GpxFile;", "Lnet/osmand/shared/gpx/primitives/GpxExtensions;", "author", "", "<init>", "(Ljava/lang/String;)V", "title", "lang", "description", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAuthor", "()Ljava/lang/String;", "setAuthor", "metadata", "Lnet/osmand/shared/gpx/primitives/Metadata;", "getMetadata", "()Lnet/osmand/shared/gpx/primitives/Metadata;", "setMetadata", "(Lnet/osmand/shared/gpx/primitives/Metadata;)V", "tracks", "", "Lnet/osmand/shared/gpx/primitives/Track;", "getTracks", "()Ljava/util/List;", "setTracks", "(Ljava/util/List;)V", "routes", "Lnet/osmand/shared/gpx/primitives/Route;", "getRoutes", "setRoutes", "points", "Lnet/osmand/shared/gpx/primitives/WptPt;", "pointsGroups", "", "Lnet/osmand/shared/gpx/GpxUtilities$PointsGroup;", "getPointsGroups", "()Ljava/util/Map;", "setPointsGroups", "(Ljava/util/Map;)V", "networkRouteKeyTags", "getNetworkRouteKeyTags", "error", "Lnet/osmand/shared/KException;", "getError", "()Lnet/osmand/shared/KException;", "setError", "(Lnet/osmand/shared/KException;)V", "path", "getPath", "setPath", "showCurrentTrack", "", "getShowCurrentTrack", "()Z", "setShowCurrentTrack", "(Z)V", "hasAltitude", "getHasAltitude", "setHasAltitude", "modifiedTime", "", "getModifiedTime", "()J", "setModifiedTime", "(J)V", "pointsModifiedTime", "getPointsModifiedTime", "setPointsModifiedTime", "generalTrack", "generalSegment", "Lnet/osmand/shared/gpx/primitives/TrkSegment;", "isShowCurrentTrack", "hasRoute", "getAllPoints", "", "getPointsList", "setPointsList", "", "getAllSegmentsPoints", "isPointsEmpty", "getPointsSize", "", "containsPoint", "point", "clearData", "clearPoints", "addPoint", "addParsedPoint", "position", "addPoints", "collection", "", "addPointsGroup", "group", "addPointsToGroups", "getOrCreateGroup", "deleteWptPt", "wptName", "index", "removePointFromGroup", "groupName", "updateWptPt", "wptIndex", "newWpt", "updateTimestamp", "getWptPt", "existingPoint", "updatePointsGroup", "prevGroupName", "pointsGroup", "isCloudmadeRouteFile", "hasGeneralTrack", "addGeneralTrack", "getGeneralTrack", "getGeneralSegment", "buildGeneralSegment", "getAnalysis", "Lnet/osmand/shared/gpx/GpxTrackAnalysis;", "fileTimestamp", "parameters", "", "Lnet/osmand/shared/gpx/GpxParameter;", "", "fromDistance", "", "toDistance", "pointsAnalyzer", "Lnet/osmand/shared/gpx/GpxTrackAnalysis$TrackPointsAnalyser;", "(JLjava/lang/Double;Ljava/lang/Double;Lnet/osmand/shared/gpx/GpxTrackAnalysis$TrackPointsAnalyser;)Lnet/osmand/shared/gpx/GpxTrackAnalysis;", "(JLjava/lang/Double;Ljava/lang/Double;Ljava/util/Map;Lnet/osmand/shared/gpx/GpxTrackAnalysis$TrackPointsAnalyser;)Lnet/osmand/shared/gpx/GpxTrackAnalysis;", "getSplitSegments", "Lnet/osmand/shared/gpx/SplitSegment;", "analysis", "(Lnet/osmand/shared/gpx/GpxTrackAnalysis;Ljava/lang/Double;Ljava/lang/Double;)Ljava/util/List;", "createSplitSegment", "segment", "(Lnet/osmand/shared/gpx/primitives/TrkSegment;Ljava/lang/Double;Ljava/lang/Double;)Lnet/osmand/shared/gpx/SplitSegment;", "getPointIndexByDistance", "distance", "containsRoutePoint", "getRoutePoints", "routeIndex", "isAttachedToRoads", "hasRtePt", "hasWptPt", "hasTrkPt", "getNonEmptyTrkSegments", "routesOnly", "addTrkSegment", "replaceSegment", "oldSegment", "newSegment", "addRoutePoints", "addRoute", "replaceRoutePoints", "removeGeneralTrackIfExists", "removeTrkSegment", "deleteRtePt", "pt", "processRoutePoints", "processPoints", "getLastPoint", "findPointToShow", "isEmpty", "includeGeneralTrack", "getSegments", "getTracksCount", "getNonEmptyTracksCount", "getNonEmptySegmentsCount", "getWaypointCategories", "", "getRect", "Lnet/osmand/shared/data/KQuadRect;", "getBounds", "defaultMissingLat", "defaultMissingLon", "getColoringType", "getGradientScaleType", "setColoringType", "coloringType", "removeGradientScaleType", "getSplitType", "setSplitType", "gpxSplitType", "getSplitInterval", "setSplitInterval", "splitInterval", "isShowArrowsSet", "isShowArrows", "setShowArrows", "showArrows", "get3DVisualizationType", "set3DVisualizationType", "visualizationType", "get3DWallColoringType", "set3DWallColoringType", "trackWallColoringType", "get3DLinePositionType", "set3DLinePositionType", "trackLinePositionType", "setAdditionalExaggeration", "additionalExaggeration", "", "getAdditionalExaggeration", "setElevationMeters", "elevation", "getElevationMeters", "isShowStartFinishSet", "isShowStartFinish", "setShowStartFinish", "showStartFinish", "isJoinSegments", "setJoinSegment", "isJoinSegment", "addRouteKeyTags", "routeKey", "getRouteKeyTags", "setRef", "ref", "getRef", "getOuterRadius", "getArticleTitle", "getItemsToWriteSize", "getLastPointTime", "clone", "cloneTrack", "source", "cloneRoute", "clonePointsGroup", "cloneTrkSegment", "cloneRouteSegment", "Lnet/osmand/shared/gpx/GpxUtilities$RouteSegment;", "cloneRouteType", "Lnet/osmand/shared/gpx/GpxUtilities$RouteType;", "getGradientColorPalette", "setGradientColorPalette", "gradientColorPaletteName", "getRouteByName", "name", "updateTrackName", "newName", "isOsmAndOrigin", "Companion", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nGpxFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpxFile.kt\nnet/osmand/shared/gpx/GpxFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,948:1\n1#2:949\n1557#3:950\n1628#3,3:951\n2341#3,14:956\n774#3:970\n865#3,2:971\n1368#3:973\n1454#3,2:974\n774#3:976\n865#3,2:977\n1456#3,3:979\n1782#3,4:982\n1782#3,3:986\n1755#3,3:989\n1785#3:992\n1782#3,4:993\n295#3,2:997\n295#3,2:999\n37#4,2:954\n*S KotlinDebug\n*F\n+ 1 GpxFile.kt\nnet/osmand/shared/gpx/GpxFile\n*L\n260#1:950\n260#1:951,3\n354#1:956,14\n579#1:970\n579#1:971,2\n583#1:973\n583#1:974,2\n583#1:976\n583#1:977,2\n583#1:979,3\n587#1:982,4\n591#1:986,3\n591#1:989,3\n591#1:992\n595#1:993,4\n787#1:997,2\n791#1:999,2\n310#1:954,2\n*E\n"})
public final class GpxFile
extends GpxExtensions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String author;
    @NotNull
    private Metadata metadata = new Metadata();
    @NotNull
    private List<Track> tracks = new ArrayList();
    @NotNull
    private List<Route> routes = new ArrayList();
    @NotNull
    private List<WptPt> points = new ArrayList();
    @NotNull
    private Map<String, GpxUtilities.PointsGroup> pointsGroups = new LinkedHashMap();
    @NotNull
    private final Map<String, String> networkRouteKeyTags = new LinkedHashMap();
    @Nullable
    private KException error;
    @NotNull
    private String path = "";
    private boolean showCurrentTrack;
    private boolean hasAltitude;
    private long modifiedTime;
    private long pointsModifiedTime;
    @Nullable
    private Track generalTrack;
    @Nullable
    private TrkSegment generalSegment;
    @NotNull
    public static final String OSMAND_AUTHOR_PREFIX = "OsmAnd";
    @NotNull
    public static final String DEFAULT_WPT_GROUP_NAME = "";
    @NotNull
    public static final String XML_COLON = "_-_";

    @Nullable
    public final String getAuthor() {
        return this.author;
    }

    public final void setAuthor(@Nullable String string) {
        this.author = string;
    }

    @NotNull
    public final Metadata getMetadata() {
        return this.metadata;
    }

    public final void setMetadata(@NotNull Metadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"<set-?>");
        this.metadata = metadata;
    }

    @NotNull
    public final List<Track> getTracks() {
        return this.tracks;
    }

    public final void setTracks(@NotNull List<Track> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.tracks = list;
    }

    @NotNull
    public final List<Route> getRoutes() {
        return this.routes;
    }

    public final void setRoutes(@NotNull List<Route> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.routes = list;
    }

    @NotNull
    public final Map<String, GpxUtilities.PointsGroup> getPointsGroups() {
        return this.pointsGroups;
    }

    public final void setPointsGroups(@NotNull Map<String, GpxUtilities.PointsGroup> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.pointsGroups = map;
    }

    @NotNull
    public final Map<String, String> getNetworkRouteKeyTags() {
        return this.networkRouteKeyTags;
    }

    @Nullable
    public final KException getError() {
        return this.error;
    }

    public final void setError(@Nullable KException kException) {
        this.error = kException;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final void setPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.path = string;
    }

    public final boolean getShowCurrentTrack() {
        return this.showCurrentTrack;
    }

    public final void setShowCurrentTrack(boolean bl) {
        this.showCurrentTrack = bl;
    }

    public final boolean getHasAltitude() {
        return this.hasAltitude;
    }

    public final void setHasAltitude(boolean bl) {
        this.hasAltitude = bl;
    }

    public final long getModifiedTime() {
        return this.modifiedTime;
    }

    public final void setModifiedTime(long l) {
        this.modifiedTime = l;
    }

    public final long getPointsModifiedTime() {
        return this.pointsModifiedTime;
    }

    public final void setPointsModifiedTime(long l) {
        this.pointsModifiedTime = l;
    }

    public GpxFile(@Nullable String author) {
        this.author = author;
    }

    public GpxFile(@Nullable String title, @Nullable String lang, @Nullable String description) {
        if (description != null) {
            this.metadata.setDesc(description);
        }
        if (lang != null) {
            this.metadata.getExtensionsToWrite().put("article_lang", lang);
        }
        if (title != null) {
            this.metadata.getExtensionsToWrite().put("article_title", title);
        }
    }

    public final boolean isShowCurrentTrack() {
        return this.showCurrentTrack;
    }

    public final boolean hasAltitude() {
        return this.hasAltitude;
    }

    public final boolean hasRoute() {
        return !((Collection)this.getNonEmptyTrkSegments(true)).isEmpty();
    }

    @NotNull
    public final List<WptPt> getAllPoints() {
        List total = new ArrayList();
        total.addAll((Collection)this.getPointsList());
        total.addAll((Collection)this.getAllSegmentsPoints());
        return total;
    }

    @NotNull
    public final List<WptPt> getPointsList() {
        return CollectionsKt.toList((Iterable)this.points);
    }

    public final void setPointsList(@NotNull List<WptPt> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        this.points = CollectionsKt.toMutableList((Collection)points);
    }

    @NotNull
    public final List<WptPt> getAllSegmentsPoints() {
        List points = new ArrayList();
        for (Track track : this.tracks) {
            if (track.getGeneralTrack()) continue;
            for (TrkSegment segment : track.getSegments()) {
                if (segment.getGeneralSegment()) continue;
                points.addAll((Collection)segment.getPoints());
            }
        }
        return points;
    }

    public final boolean isPointsEmpty() {
        return this.points.isEmpty();
    }

    public final int getPointsSize() {
        return this.points.size();
    }

    public final boolean containsPoint(@NotNull WptPt point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.points.contains(point);
    }

    public final void clearData() {
        this.clearPoints();
        this.tracks.clear();
        this.generalSegment = null;
        this.generalTrack = null;
    }

    public final void clearPoints() {
        this.points.clear();
        this.pointsGroups.clear();
        this.pointsModifiedTime = this.modifiedTime = ClockExtensionsKt.currentTimeMillis();
    }

    public final void addPoint(@NotNull WptPt point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.points.add(point);
        this.addPointsToGroups(SetsKt.setOf((Object)point));
        this.pointsModifiedTime = this.modifiedTime = ClockExtensionsKt.currentTimeMillis();
    }

    public final void addParsedPoint(@NotNull WptPt point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.points.add(point);
    }

    public final void addPoint(int position, @NotNull WptPt point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.points.add(position, point);
        this.addPointsToGroups(SetsKt.setOf((Object)point));
        this.pointsModifiedTime = this.modifiedTime = ClockExtensionsKt.currentTimeMillis();
    }

    public final void addPoints(@NotNull Collection<WptPt> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        this.points.addAll(collection);
        this.addPointsToGroups(collection);
        this.pointsModifiedTime = this.modifiedTime = ClockExtensionsKt.currentTimeMillis();
    }

    public final void addPointsGroup(@NotNull GpxUtilities.PointsGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this.points.addAll((Collection<WptPt>)group.getPoints());
        this.pointsGroups.put(group.getName(), group);
        this.pointsModifiedTime = this.modifiedTime = ClockExtensionsKt.currentTimeMillis();
    }

    private final void addPointsToGroups(Collection<WptPt> collection) {
        for (WptPt point : collection) {
            GpxUtilities.PointsGroup pointsGroup = this.getOrCreateGroup(point);
            pointsGroup.getPoints().add(point);
        }
    }

    private final GpxUtilities.PointsGroup getOrCreateGroup(WptPt point) {
        String groupName;
        GpxUtilities.PointsGroup pointsGroup;
        String string = point.getCategory();
        if (string == null) {
            string = DEFAULT_WPT_GROUP_NAME;
        }
        if ((pointsGroup = this.pointsGroups.get(groupName = string)) == null) {
            GpxUtilities.PointsGroup pointsGroup2;
            GpxUtilities.PointsGroup it = pointsGroup2 = new GpxUtilities.PointsGroup(point);
            boolean bl = false;
            this.pointsGroups.put(it.getName(), it);
            pointsGroup = pointsGroup2;
        }
        return pointsGroup;
    }

    public final boolean deleteWptPt(@NotNull WptPt point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.removePointFromGroup(point);
        this.pointsModifiedTime = this.modifiedTime = ClockExtensionsKt.currentTimeMillis();
        return this.points.remove(point);
    }

    public final boolean deleteWptPt(@NotNull String wptName, int index) {
        boolean bl;
        WptPt currentWpt;
        Intrinsics.checkNotNullParameter((Object)wptName, (String)"wptName");
        WptPt wptPt = currentWpt = this.getWptPt(wptName, index);
        if (wptPt != null) {
            WptPt it = wptPt;
            boolean bl2 = false;
            bl = this.deleteWptPt(it);
        } else {
            bl = false;
        }
        return bl;
    }

    private final void removePointFromGroup(WptPt point) {
        this.removePointFromGroup(point, point.getCategory());
    }

    private final void removePointFromGroup(WptPt point, String groupName) {
        block0: {
            GpxUtilities.PointsGroup group = this.pointsGroups.get(groupName);
            Object object = group;
            if (object == null || (object = ((GpxUtilities.PointsGroup)object).getPoints()) == null) break block0;
            object.remove(point);
        }
    }

    public final void updateWptPt(@NotNull String wptName, int wptIndex, @NotNull WptPt newWpt, boolean updateTimestamp) {
        Intrinsics.checkNotNullParameter((Object)wptName, (String)"wptName");
        Intrinsics.checkNotNullParameter((Object)newWpt, (String)"newWpt");
        WptPt currentWpt = this.getWptPt(wptName, wptIndex);
        if (currentWpt != null) {
            this.updateWptPt(currentWpt, newWpt, updateTimestamp);
        } else {
            this.addPoint(newWpt);
        }
    }

    private final WptPt getWptPt(String wptName, int wptIndex) {
        return (0 <= wptIndex ? wptIndex < ((Collection)this.points).size() : false) && Intrinsics.areEqual((Object)this.points.get(wptIndex).getName(), (Object)wptName) ? this.points.get(wptIndex) : null;
    }

    public final void updateWptPt(@NotNull WptPt existingPoint, @NotNull WptPt newWpt, boolean updateTimestamp) {
        Intrinsics.checkNotNullParameter((Object)existingPoint, (String)"existingPoint");
        Intrinsics.checkNotNullParameter((Object)newWpt, (String)"newWpt");
        int index = this.points.indexOf(existingPoint);
        if (index == -1) {
            return;
        }
        String string = existingPoint.getCategory();
        if (string == null) {
            string = DEFAULT_WPT_GROUP_NAME;
        }
        String prevGroupName = string;
        long prevTime = existingPoint.getTime();
        existingPoint.updatePoint(newWpt);
        if (!updateTimestamp) {
            existingPoint.setTime(prevTime);
        }
        if (!Intrinsics.areEqual((Object)newWpt.getCategory(), (Object)prevGroupName) || newWpt.getCategory() == null && !Intrinsics.areEqual((Object)prevGroupName, (Object)DEFAULT_WPT_GROUP_NAME)) {
            this.removePointFromGroup(existingPoint, prevGroupName);
            GpxUtilities.PointsGroup pointsGroup = this.getOrCreateGroup(existingPoint);
            pointsGroup.getPoints().add(existingPoint);
        }
        this.pointsModifiedTime = this.modifiedTime = ClockExtensionsKt.currentTimeMillis();
    }

    public static /* synthetic */ void updateWptPt$default(GpxFile gpxFile, WptPt wptPt, WptPt wptPt2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        gpxFile.updateWptPt(wptPt, wptPt2, bl);
    }

    public final void updatePointsGroup(@NotNull String prevGroupName, @NotNull GpxUtilities.PointsGroup pointsGroup) {
        Intrinsics.checkNotNullParameter((Object)prevGroupName, (String)"prevGroupName");
        Intrinsics.checkNotNullParameter((Object)pointsGroup, (String)"pointsGroup");
        this.pointsGroups.remove(prevGroupName);
        this.pointsGroups.put(pointsGroup.getName(), pointsGroup);
        this.modifiedTime = ClockExtensionsKt.currentTimeMillis();
    }

    public final boolean isCloudmadeRouteFile() {
        return StringsKt.equals((String)this.author, (String)"cloudmade", (boolean)true);
    }

    public final boolean hasGeneralTrack() {
        return this.generalTrack != null;
    }

    public final void addGeneralTrack() {
        Track generalTrack = this.getGeneralTrack();
        if (generalTrack != null && !this.tracks.contains(generalTrack)) {
            this.tracks.add(0, generalTrack);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Track getGeneralTrack() {
        if (this.generalTrack == null && this.getGeneralSegment() != null) {
            void $this$getGeneralTrack_u24lambda_u242;
            Track track;
            Track track2 = track = new Track();
            GpxFile gpxFile = this;
            boolean bl = false;
            Object[] objectArray = new TrkSegment[1];
            Intrinsics.checkNotNull((Object)this.getGeneralSegment());
            $this$getGeneralTrack_u24lambda_u242.setSegments(CollectionsKt.mutableListOf((Object[])objectArray));
            $this$getGeneralTrack_u24lambda_u242.setGeneralTrack(true);
            gpxFile.generalTrack = track;
        }
        return this.generalTrack;
    }

    @Nullable
    public final TrkSegment getGeneralSegment() {
        if (this.generalSegment == null && this.getNonEmptySegmentsCount() > 1) {
            this.buildGeneralSegment();
        }
        return this.generalSegment;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildGeneralSegment() {
        TrkSegment segment = new TrkSegment();
        for (Track track : this.tracks) {
            for (TrkSegment trkSegment : track.getSegments()) {
                void $this$mapTo$iv$iv;
                segment.getRouteSegments().addAll((Collection<GpxUtilities.RouteSegment>)trkSegment.getRouteSegments());
                if (!(!((Collection)trkSegment.getPoints()).isEmpty())) continue;
                Iterable $this$map$iv = trkSegment.getPoints();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    WptPt wptPt = (WptPt)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new WptPt((WptPt)it));
                }
                List waypoints = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                ((WptPt)CollectionsKt.first((List)waypoints)).setFirstPoint(true);
                ((WptPt)CollectionsKt.last((List)waypoints)).setLastPoint(true);
                segment.getPoints().addAll(waypoints);
            }
        }
        if (!((Collection)segment.getPoints()).isEmpty()) {
            segment.setGeneralSegment(true);
            this.generalSegment = segment;
        }
    }

    @NotNull
    public final GpxTrackAnalysis getAnalysis(long fileTimestamp) {
        Map<GpxParameter, Object> map;
        if (((CharSequence)this.path).length() > 0) {
            GpxDataItem gpxDataItem = GpxDbHelper.INSTANCE.getItem(new KFile(this.path), false);
            map = gpxDataItem != null ? gpxDataItem.getAnalysisCalculationParameters() : null;
        } else {
            map = null;
        }
        Map<GpxParameter, Object> parameters = map;
        return this.getAnalysis(fileTimestamp, null, null, parameters, null);
    }

    @NotNull
    public final GpxTrackAnalysis getAnalysis(long fileTimestamp, @Nullable Map<GpxParameter, ? extends Object> parameters) {
        return this.getAnalysis(fileTimestamp, null, null, parameters, null);
    }

    @NotNull
    public final GpxTrackAnalysis getAnalysis(long fileTimestamp, @Nullable Double fromDistance, @Nullable Double toDistance, @Nullable GpxTrackAnalysis.TrackPointsAnalyser pointsAnalyzer) {
        Map<GpxParameter, Object> map;
        if (((CharSequence)this.path).length() > 0) {
            GpxDataItem gpxDataItem = GpxDbHelper.INSTANCE.getItem(new KFile(this.path), false);
            map = gpxDataItem != null ? gpxDataItem.getAnalysisCalculationParameters() : null;
        } else {
            map = null;
        }
        Map<GpxParameter, Object> parameters = map;
        return this.getAnalysis(fileTimestamp, fromDistance, toDistance, parameters, pointsAnalyzer);
    }

    @NotNull
    public final GpxTrackAnalysis getAnalysis(long fileTimestamp, @Nullable Double fromDistance, @Nullable Double toDistance, @Nullable Map<GpxParameter, ? extends Object> parameters, @Nullable GpxTrackAnalysis.TrackPointsAnalyser pointsAnalyzer) {
        GpxTrackAnalysis analysis = new GpxTrackAnalysis();
        analysis.setName(this.path);
        analysis.setWptPoints(this.points.size());
        analysis.setWptCategoryNames(this.getWaypointCategories());
        if (parameters != null) {
            analysis.setGpxParameters(parameters);
        }
        List<SplitSegment> segments = this.getSplitSegments(analysis, fromDistance, toDistance);
        Collection $this$toTypedArray$iv = segments;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SplitSegment[] splitSegmentArray = thisCollection$iv.toArray(new SplitSegment[0]);
        analysis.prepareInformation(fileTimestamp, pointsAnalyzer, Arrays.copyOf(splitSegmentArray, splitSegmentArray.length));
        return analysis;
    }

    private final List<SplitSegment> getSplitSegments(GpxTrackAnalysis analysis, Double fromDistance, Double toDistance) {
        Object object;
        List splitSegments = new ArrayList();
        if ((fromDistance == null || toDistance == null) && (object = this.getGeneralSegment()) != null) {
            Object it = object;
            boolean bl = false;
            splitSegments.add(new SplitSegment((TrkSegment)it));
            return splitSegments;
        }
        for (Track subtrack : this.tracks) {
            for (TrkSegment segment : subtrack.getSegments()) {
                if (segment.getGeneralSegment()) continue;
                analysis.setTotalTracks(analysis.getTotalTracks() + 1);
                if (segment.getPoints().size() <= 1) continue;
                splitSegments.add(this.createSplitSegment(segment, fromDistance, toDistance));
            }
        }
        return splitSegments;
    }

    private final SplitSegment createSplitSegment(TrkSegment segment, Double fromDistance, Double toDistance) {
        SplitSegment splitSegment;
        if (fromDistance != null && toDistance != null) {
            int startInd = this.getPointIndexByDistance(segment.getPoints(), fromDistance);
            int endInd = this.getPointIndexByDistance(segment.getPoints(), toDistance);
            splitSegment = new SplitSegment(startInd, endInd, segment);
        } else {
            splitSegment = new SplitSegment(segment);
        }
        return splitSegment;
    }

    /*
     * WARNING - void declaration
     */
    public final int getPointIndexByDistance(@NotNull List<WptPt> points, double distance) {
        Object v0;
        void $this$minByOrNull$iv;
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Iterable iterable = points;
        List<WptPt> list = points;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                WptPt it = (WptPt)minElem$iv;
                boolean bl = false;
                double minValue$iv = Math.abs(it.getDistance() - distance);
                do {
                    Object e$iv = iterator$iv.next();
                    WptPt it2 = (WptPt)e$iv;
                    $i$a$-minByOrNull-GpxFile$getPointIndexByDistance$1 = false;
                    double v$iv = Math.abs(it2.getDistance() - distance);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return CollectionsKt.indexOf(list, v0);
    }

    public final boolean containsRoutePoint(@NotNull WptPt point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.getRoutePoints().contains(point);
    }

    @NotNull
    public final List<WptPt> getRoutePoints() {
        List points = new ArrayList();
        for (Route route : this.routes) {
            points.addAll((Collection)route.getPoints());
        }
        return points;
    }

    @NotNull
    public final List<WptPt> getRoutePoints(int routeIndex) {
        List points = new ArrayList();
        if (this.routes.size() > routeIndex) {
            points.addAll((Collection)this.routes.get(routeIndex).getPoints());
        }
        return points;
    }

    public final boolean isAttachedToRoads() {
        List<WptPt> points = this.getRoutePoints();
        if (!((Collection)points).isEmpty()) {
            for (WptPt wptPt : points) {
                CharSequence charSequence = wptPt.getProfileType();
                if (!(charSequence == null || charSequence.length() == 0)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean hasRtePt() {
        for (Route route : this.routes) {
            if (!(!((Collection)route.getPoints()).isEmpty())) continue;
            return true;
        }
        return false;
    }

    public final boolean hasWptPt() {
        return !((Collection)this.points).isEmpty();
    }

    public final boolean hasTrkPt() {
        for (Track track : this.tracks) {
            for (TrkSegment segment : track.getSegments()) {
                if (!(!((Collection)segment.getPoints()).isEmpty())) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public final List<TrkSegment> getNonEmptyTrkSegments(boolean routesOnly) {
        List segments = new ArrayList();
        for (Track track : this.tracks) {
            for (TrkSegment segment : track.getSegments()) {
                if (segment.getGeneralSegment() || !(!((Collection)segment.getPoints()).isEmpty()) || routesOnly && !segment.hasRoute()) continue;
                segments.add(segment);
            }
        }
        return segments;
    }

    public final void addTrkSegment(@NotNull List<WptPt> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        this.removeGeneralTrackIfExists();
        TrkSegment segment = new TrkSegment();
        segment.getPoints().addAll((Collection<WptPt>)points);
        if (this.tracks.isEmpty()) {
            this.tracks.add(new Track());
        }
        Track lastTrack = (Track)CollectionsKt.last(this.tracks);
        lastTrack.getSegments().add(segment);
        this.modifiedTime = ClockExtensionsKt.currentTimeMillis();
    }

    public final boolean replaceSegment(@NotNull TrkSegment oldSegment, @NotNull TrkSegment newSegment) {
        Intrinsics.checkNotNullParameter((Object)oldSegment, (String)"oldSegment");
        Intrinsics.checkNotNullParameter((Object)newSegment, (String)"newSegment");
        this.removeGeneralTrackIfExists();
        for (Track currentTrack : this.tracks) {
            int segmentIndex = currentTrack.getSegments().indexOf(oldSegment);
            if (segmentIndex == -1) continue;
            currentTrack.getSegments().set(segmentIndex, newSegment);
            this.addGeneralTrack();
            this.modifiedTime = ClockExtensionsKt.currentTimeMillis();
            return true;
        }
        this.addGeneralTrack();
        return false;
    }

    public final void addRoutePoints(@NotNull List<WptPt> points, boolean addRoute) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        if (this.routes.isEmpty() || addRoute) {
            this.routes.add(new Route());
        }
        Route lastRoute = (Route)CollectionsKt.last(this.routes);
        lastRoute.getPoints().addAll((Collection<WptPt>)points);
        this.pointsModifiedTime = this.modifiedTime = ClockExtensionsKt.currentTimeMillis();
    }

    public final void replaceRoutePoints(@NotNull List<WptPt> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        this.routes.clear();
        this.routes.add(new Route());
        Route currentRoute = (Route)CollectionsKt.last(this.routes);
        currentRoute.getPoints().addAll((Collection<WptPt>)points);
        this.pointsModifiedTime = this.modifiedTime = ClockExtensionsKt.currentTimeMillis();
    }

    private final void removeGeneralTrackIfExists() {
        if (this.generalTrack != null) {
            Collection collection = this.tracks;
            Track track = this.generalTrack;
            TypeIntrinsics.asMutableCollection((Object)collection).remove(track);
            this.generalTrack = null;
            this.generalSegment = null;
        }
    }

    public final boolean removeTrkSegment(@NotNull TrkSegment segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        this.removeGeneralTrackIfExists();
        for (Track currentTrack : this.tracks) {
            if (!currentTrack.getSegments().remove(segment)) continue;
            this.addGeneralTrack();
            this.modifiedTime = ClockExtensionsKt.currentTimeMillis();
            return true;
        }
        this.addGeneralTrack();
        return false;
    }

    public final boolean deleteRtePt(@NotNull WptPt pt) {
        Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
        this.pointsModifiedTime = this.modifiedTime = ClockExtensionsKt.currentTimeMillis();
        for (Route route : this.routes) {
            if (!route.getPoints().remove(pt)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final List<TrkSegment> processRoutePoints() {
        List tpoints = new ArrayList();
        if (!((Collection)this.routes).isEmpty()) {
            for (Route route : this.routes) {
                Integer routeColor = route.getColor(this.getColor(null));
                if (!(!((Collection)route.getPoints()).isEmpty())) continue;
                TrkSegment ts = new TrkSegment();
                tpoints.add(ts);
                ts.getPoints().addAll((Collection<WptPt>)route.getPoints());
                ts.setColor(routeColor);
            }
        }
        return tpoints;
    }

    @NotNull
    public final List<TrkSegment> processPoints() {
        List tpoints = new ArrayList();
        for (Track track : this.tracks) {
            Integer trackColor = track.getColor(this.getColor(null));
            String trackWidth = track.getWidth(null);
            for (TrkSegment segment : track.getSegments()) {
                Integer segmentColor = segment.getColor(trackColor);
                String segmentWidth = segment.getWidth(trackWidth);
                if (segment.getGeneralSegment() || !(!((Collection)segment.getPoints()).isEmpty())) continue;
                TrkSegment ts = new TrkSegment();
                tpoints.add(ts);
                ts.setColor(segmentColor);
                ts.setWidth(segmentWidth);
                ts.getPoints().addAll((Collection<WptPt>)segment.getPoints());
            }
        }
        return tpoints;
    }

    @Nullable
    public final WptPt getLastPoint() {
        Object object = (Track)CollectionsKt.lastOrNull(this.tracks);
        return object != null && (object = ((Track)object).getSegments()) != null && (object = (TrkSegment)CollectionsKt.lastOrNull((List)object)) != null && (object = ((TrkSegment)object).getPoints()) != null ? (WptPt)CollectionsKt.lastOrNull(object) : null;
    }

    @Nullable
    public final WptPt findPointToShow() {
        for (Track track : this.tracks) {
            for (TrkSegment segment : track.getSegments()) {
                if (!(!((Collection)segment.getPoints()).isEmpty())) continue;
                return segment.getPoints().get(0);
            }
        }
        for (Route route : this.routes) {
            if (!(!((Collection)route.getPoints()).isEmpty())) continue;
            return route.getPoints().get(0);
        }
        return (WptPt)CollectionsKt.firstOrNull(this.points);
    }

    public final boolean isEmpty() {
        for (Track track : this.tracks) {
            for (TrkSegment segment : track.getSegments()) {
                if (!(!((Collection)segment.getPoints()).isEmpty())) continue;
                return false;
            }
        }
        return this.points.isEmpty() && this.routes.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Track> getTracks(boolean includeGeneralTrack) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.tracks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Track it = (Track)element$iv$iv;
            boolean bl = false;
            if (!(includeGeneralTrack || !it.getGeneralTrack())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TrkSegment> getSegments(boolean includeGeneralTrack) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.tracks;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            Track track = (Track)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = track.getSegments();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                TrkSegment it = (TrkSegment)element$iv$iv2;
                boolean bl2 = false;
                if (!(includeGeneralTrack || !track.getGeneralTrack())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final int getTracksCount() {
        int n;
        Iterable $this$count$iv = this.tracks;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Track it = (Track)element$iv;
                boolean bl = false;
                if (!(!it.getGeneralTrack()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int getNonEmptyTracksCount() {
        int n;
        Iterable $this$count$iv = this.tracks;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                boolean bl;
                block6: {
                    Track track = (Track)element$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = track.getSegments();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            TrkSegment it = (TrkSegment)element$iv2;
                            boolean bl3 = false;
                            boolean bl4 = !((Collection)it.getPoints()).isEmpty();
                            if (!bl4) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (!bl || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int getNonEmptySegmentsCount() {
        Iterable iterable = this.tracks;
        int n = 0;
        for (Object t : iterable) {
            int n2;
            void track;
            Track track2 = (Track)t;
            int n3 = n;
            boolean bl = false;
            Iterable $this$count$iv = track.getSegments();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    TrkSegment it = (TrkSegment)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = !((Collection)it.getPoints()).isEmpty();
                    if (!bl3 || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            int n4 = n2;
            n = n3 + n4;
        }
        return n;
    }

    @NotNull
    public final Set<String> getWaypointCategories() {
        return this.pointsGroups.keySet();
    }

    @NotNull
    public final KQuadRect getRect() {
        return this.getBounds(0.0, 0.0);
    }

    @NotNull
    public final KQuadRect getBounds(double defaultMissingLat, double defaultMissingLon) {
        KQuadRect qr = new KQuadRect(defaultMissingLon, defaultMissingLat, defaultMissingLon, defaultMissingLat);
        for (Track track : this.tracks) {
            for (TrkSegment segment : track.getSegments()) {
                for (WptPt p : segment.getPoints()) {
                    GpxUtilities.INSTANCE.updateQR(qr, p, defaultMissingLat, defaultMissingLon);
                }
            }
        }
        for (WptPt p : this.points) {
            GpxUtilities.INSTANCE.updateQR(qr, p, defaultMissingLat, defaultMissingLon);
        }
        for (Route route : this.routes) {
            for (WptPt p : route.getPoints()) {
                GpxUtilities.INSTANCE.updateQR(qr, p, defaultMissingLat, defaultMissingLon);
            }
        }
        return qr;
    }

    @Nullable
    public final String getColoringType() {
        Map<String, String> map = this.getExtensions();
        return map != null ? map.get("coloring_type") : null;
    }

    @Nullable
    public final String getGradientScaleType() {
        Map<String, String> map = this.getExtensions();
        return map != null ? map.get("gradient_scale_type") : null;
    }

    public final void setColoringType(@NotNull String coloringType) {
        Intrinsics.checkNotNullParameter((Object)coloringType, (String)"coloringType");
        this.getExtensionsToWrite().put("coloring_type", coloringType);
    }

    public final void removeGradientScaleType() {
        this.getExtensionsToWrite().remove("gradient_scale_type");
    }

    @Nullable
    public final String getSplitType() {
        Map<String, String> map = this.getExtensions();
        return map != null ? map.get("split_type") : null;
    }

    public final void setSplitType(@NotNull String gpxSplitType) {
        Intrinsics.checkNotNullParameter((Object)gpxSplitType, (String)"gpxSplitType");
        this.getExtensionsToWrite().put("split_type", gpxSplitType);
    }

    public final double getSplitInterval() {
        Map<String, String> map = this.getExtensions();
        String splitIntervalStr = map != null ? map.get("split_interval") : null;
        Object object = splitIntervalStr;
        return object != null && (object = StringsKt.toDoubleOrNull((String)object)) != null ? (Double)object : 0.0;
    }

    public final void setSplitInterval(double splitInterval) {
        this.getExtensionsToWrite().put("split_interval", String.valueOf(splitInterval));
    }

    public final boolean isShowArrowsSet() {
        Map<String, String> map = this.getExtensions();
        return map != null ? map.containsKey("show_arrows") : false;
    }

    public final boolean isShowArrows() {
        Map<String, String> map = this.getExtensions();
        return map != null && (map = map.get("show_arrows")) != null ? Boolean.parseBoolean((String)((Object)map)) : false;
    }

    public final void setShowArrows(boolean showArrows) {
        this.getExtensionsToWrite().put("show_arrows", String.valueOf(showArrows));
    }

    @Nullable
    public final String get3DVisualizationType() {
        Map<String, String> map = this.getExtensions();
        return map != null ? map.get("line_3d_visualization_by_type") : null;
    }

    public final void set3DVisualizationType(@NotNull String visualizationType) {
        Intrinsics.checkNotNullParameter((Object)visualizationType, (String)"visualizationType");
        this.getExtensionsToWrite().put("line_3d_visualization_by_type", visualizationType);
    }

    @Nullable
    public final String get3DWallColoringType() {
        Map<String, String> map = this.getExtensions();
        return map != null ? map.get("line_3d_visualization_wall_color_type") : null;
    }

    public final void set3DWallColoringType(@NotNull String trackWallColoringType) {
        Intrinsics.checkNotNullParameter((Object)trackWallColoringType, (String)"trackWallColoringType");
        this.getExtensionsToWrite().put("line_3d_visualization_wall_color_type", trackWallColoringType);
    }

    @Nullable
    public final String get3DLinePositionType() {
        Map<String, String> map = this.getExtensions();
        return map != null ? map.get("line_3d_visualization_position_type") : null;
    }

    public final void set3DLinePositionType(@NotNull String trackLinePositionType) {
        Intrinsics.checkNotNullParameter((Object)trackLinePositionType, (String)"trackLinePositionType");
        this.getExtensionsToWrite().put("line_3d_visualization_position_type", trackLinePositionType);
    }

    public final void setAdditionalExaggeration(float additionalExaggeration) {
        this.getExtensionsToWrite().put("vertical_exaggeration_scale", String.valueOf(additionalExaggeration));
    }

    public final float getAdditionalExaggeration() {
        Map<String, String> map = this.getExtensions();
        return map != null && (map = map.get("vertical_exaggeration_scale")) != null && (map = StringsKt.toFloatOrNull((String)((Object)map))) != null ? ((Float)((Object)map)).floatValue() : 1.0f;
    }

    public final void setElevationMeters(float elevation) {
        this.getExtensionsToWrite().put("elevation_meters", String.valueOf(elevation));
    }

    public final float getElevationMeters() {
        Map<String, String> map = this.getExtensions();
        return map != null && (map = map.get("elevation_meters")) != null && (map = StringsKt.toFloatOrNull((String)((Object)map))) != null ? ((Float)((Object)map)).floatValue() : 1000.0f;
    }

    public final boolean isShowStartFinishSet() {
        Map<String, String> map = this.getExtensions();
        return map != null ? map.containsKey("show_start_finish") : false;
    }

    public final boolean isShowStartFinish() {
        Map<String, String> map = this.getExtensions();
        return map != null && (map = map.get("show_start_finish")) != null ? Boolean.parseBoolean((String)((Object)map)) : true;
    }

    public final void setShowStartFinish(boolean showStartFinish) {
        this.getExtensionsToWrite().put("show_start_finish", String.valueOf(showStartFinish));
    }

    public final boolean isJoinSegments() {
        Map<String, String> map = this.getExtensions();
        return map != null && (map = map.get("is_join_segments")) != null ? Boolean.parseBoolean((String)((Object)map)) : false;
    }

    public final void setJoinSegment(boolean isJoinSegment) {
        this.getExtensionsToWrite().put("is_join_segments", String.valueOf(isJoinSegment));
    }

    public final void addRouteKeyTags(@NotNull Map<String, String> routeKey) {
        Intrinsics.checkNotNullParameter(routeKey, (String)"routeKey");
        this.networkRouteKeyTags.putAll(routeKey);
    }

    @NotNull
    public final Map<String, String> getRouteKeyTags() {
        return this.networkRouteKeyTags;
    }

    public final void setRef(@NotNull String ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        this.getExtensionsToWrite().put("ref", ref);
    }

    @Nullable
    public final String getRef() {
        Map<String, String> map = this.getExtensions();
        return map != null ? map.get("ref") : null;
    }

    @NotNull
    public final String getOuterRadius() {
        KQuadRect rect = this.getRect();
        int radius = (int)KMapUtils.INSTANCE.getDistance(rect.getBottom(), rect.getLeft(), rect.getTop(), rect.getRight());
        return KMapUtils.INSTANCE.convertDistToChar(radius, 'A', 5000, 2, 5);
    }

    @Nullable
    public final String getArticleTitle() {
        return this.metadata.getArticleTitle();
    }

    public final int getItemsToWriteSize() {
        int size = this.getPointsSize();
        for (Route route : this.routes) {
            size += route.getPoints().size();
        }
        for (TrkSegment segment : this.getNonEmptyTrkSegments(false)) {
            size += segment.getPoints().size();
        }
        ++size;
        if (this.metadata.getAuthor() != null) {
            ++size;
        }
        if (this.metadata.getCopyright() != null) {
            ++size;
        }
        if (this.metadata.getBounds() != null) {
            ++size;
        }
        size += this.getExtensionsToWrite().size();
        Map<String, GpxUtilities.GpxExtensionsWriter> map = this.getExtensionsWriters();
        return size += map != null ? map.size() : 0;
    }

    public final long getLastPointTime() {
        Object v0;
        block1: {
            Object[] objectArray = new Long[]{this.getLastPointTime(this.getAllSegmentsPoints()), this.getLastPointTime(this.getRoutePoints()), this.getLastPointTime(this.getPointsList())};
            Iterable $this$firstOrNull$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                long it = ((Number)element$iv).longValue();
                boolean bl = false;
                if (!(it > 0L)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Long l = v0;
        return l != null ? l : 0L;
    }

    private final long getLastPointTime(List<WptPt> points) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = CollectionsKt.asReversed(points);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                WptPt it = (WptPt)element$iv;
                boolean bl = false;
                if (!(it.getTime() > 0L)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        WptPt wptPt = v0;
        return wptPt != null ? wptPt.getTime() : 0L;
    }

    @NotNull
    public final GpxFile clone() {
        GpxFile dest = new GpxFile(this.author);
        dest.metadata = new Metadata(this.metadata);
        List<Track> tracks = dest.tracks;
        for (Object track : CollectionsKt.toList((Iterable)this.tracks)) {
            tracks.add(this.cloneTrack((Track)track));
        }
        List<Route> routes = dest.routes;
        for (Object route : CollectionsKt.toList((Iterable)this.routes)) {
            routes.add(this.cloneRoute((Route)route));
        }
        List points = new ArrayList();
        for (WptPt point : CollectionsKt.toList((Iterable)this.points)) {
            points.add(new WptPt(point));
        }
        dest.setPointsList(points);
        dest.pointsGroups = new LinkedHashMap();
        Map<String, GpxUtilities.PointsGroup> pointsGroups = dest.pointsGroups;
        for (Map.Entry entry : MapsKt.toMap(this.pointsGroups).entrySet()) {
            String key = (String)entry.getKey();
            GpxUtilities.PointsGroup value = (GpxUtilities.PointsGroup)entry.getValue();
            pointsGroups.put(key, this.clonePointsGroup(value));
        }
        dest.pointsGroups = pointsGroups;
        dest.addRouteKeyTags(MapsKt.toMap(this.getRouteKeyTags()));
        dest.path = this.path;
        dest.showCurrentTrack = this.showCurrentTrack;
        dest.hasAltitude = this.hasAltitude;
        dest.pointsModifiedTime = dest.modifiedTime = ClockExtensionsKt.currentTimeMillis();
        dest.copyExtensions(this);
        return dest;
    }

    private final Track cloneTrack(Track source) {
        Track dest = new Track();
        dest.setName(source.getName());
        dest.setDesc(source.getDesc());
        dest.setGeneralTrack(source.getGeneralTrack());
        List trkSegments = new ArrayList();
        for (TrkSegment segment : CollectionsKt.toList((Iterable)source.getSegments())) {
            trkSegments.add(this.cloneTrkSegment(segment));
        }
        dest.setSegments(trkSegments);
        dest.copyExtensions(source);
        return dest;
    }

    private final Route cloneRoute(Route source) {
        Route dest = new Route();
        dest.setName(source.getName());
        dest.setDesc(source.getDesc());
        List points = new ArrayList();
        for (WptPt point : CollectionsKt.toList((Iterable)source.getPoints())) {
            points.add(new WptPt(point));
        }
        dest.setPoints(points);
        dest.copyExtensions(source);
        return dest;
    }

    private final GpxUtilities.PointsGroup clonePointsGroup(GpxUtilities.PointsGroup source) {
        GpxUtilities.PointsGroup dest = new GpxUtilities.PointsGroup(source.getName(), source.getIconName(), source.getBackgroundType(), source.getColor());
        dest.setHidden(source.getHidden());
        List points = new ArrayList();
        for (WptPt point : CollectionsKt.toList((Iterable)source.getPoints())) {
            points.add(new WptPt(point));
        }
        dest.setPoints(points);
        return dest;
    }

    private final TrkSegment cloneTrkSegment(TrkSegment source) {
        TrkSegment dest = new TrkSegment();
        dest.setName(source.getName());
        dest.setGeneralSegment(source.getGeneralSegment());
        List kPoints = new ArrayList();
        for (Object point : CollectionsKt.toList((Iterable)source.getPoints())) {
            kPoints.add(new WptPt((WptPt)point));
        }
        dest.setPoints(kPoints);
        List routeSegments = new ArrayList();
        for (GpxUtilities.RouteSegment rs : CollectionsKt.toList((Iterable)source.getRouteSegments())) {
            routeSegments.add(this.cloneRouteSegment(rs));
        }
        dest.setRouteSegments(routeSegments);
        List routeTypes = new ArrayList();
        for (GpxUtilities.RouteType rt : CollectionsKt.toList((Iterable)source.getRouteTypes())) {
            routeTypes.add(this.cloneRouteType(rt));
        }
        dest.setRouteTypes(routeTypes);
        dest.copyExtensions(source);
        return dest;
    }

    private final GpxUtilities.RouteSegment cloneRouteSegment(GpxUtilities.RouteSegment source) {
        GpxUtilities.RouteSegment dest = new GpxUtilities.RouteSegment();
        dest.setId(source.getId());
        dest.setLength(source.getLength());
        dest.setStartTrackPointIndex(source.getStartTrackPointIndex());
        dest.setSegmentTime(source.getSegmentTime());
        dest.setSpeed(source.getSpeed());
        dest.setTurnType(source.getTurnType());
        dest.setTurnLanes(source.getTurnLanes());
        dest.setTurnAngle(source.getTurnAngle());
        dest.setSkipTurn(source.getSkipTurn());
        dest.setTypes(source.getTypes());
        dest.setPointTypes(source.getPointTypes());
        dest.setNames(source.getNames());
        return dest;
    }

    private final GpxUtilities.RouteType cloneRouteType(GpxUtilities.RouteType source) {
        GpxUtilities.RouteType dest = new GpxUtilities.RouteType();
        dest.setTag(source.getTag());
        dest.setValue(source.getValue());
        return dest;
    }

    @Nullable
    public final String getGradientColorPalette() {
        Map<String, String> map = this.getExtensions();
        return map != null ? map.get("color_palette") : null;
    }

    public final void setGradientColorPalette(@NotNull String gradientColorPaletteName) {
        Intrinsics.checkNotNullParameter((Object)gradientColorPaletteName, (String)"gradientColorPaletteName");
        this.getExtensionsToWrite().put("color_palette", gradientColorPaletteName);
    }

    @Nullable
    public final Route getRouteByName(@Nullable String name) {
        for (Route route : this.routes) {
            if (!Intrinsics.areEqual((Object)route.getName(), (Object)name)) continue;
            return route;
        }
        return null;
    }

    public final void updateTrackName(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        this.metadata.setName(newName);
        if (this.tracks.size() == 1) {
            this.tracks.get(0).setName(newName);
        }
        this.modifiedTime = ClockExtensionsKt.currentTimeMillis();
    }

    public final boolean isOsmAndOrigin() {
        String string = this.author;
        return string != null ? StringsKt.startsWith((String)string, (String)OSMAND_AUTHOR_PREFIX, (boolean)true) : false;
    }

    @kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnet/osmand/shared/gpx/GpxFile$Companion;", "", "<init>", "()V", "OSMAND_AUTHOR_PREFIX", "", "DEFAULT_WPT_GROUP_NAME", "XML_COLON", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

