/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.tiff;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.PackageUtil;
import it.geosolutions.imageio.imageioimpl.EnhancedImageReadParam;
import it.geosolutions.imageio.plugins.tiff.BaselineTIFFTagSet;
import it.geosolutions.imageio.plugins.tiff.TIFFColorConverter;
import it.geosolutions.imageio.plugins.tiff.TIFFDecompressor;
import it.geosolutions.imageio.plugins.tiff.TIFFField;
import it.geosolutions.imageio.plugins.tiff.TIFFImageReadParam;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFCIELabColorConverter;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFCodecLibFaxDecompressor;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFDeflateDecompressor;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFFaxDecompressor;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageMetadata;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageWriter;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFJPEGDecompressor;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFLSBDecompressor;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFLZWDecompressor;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFNullDecompressor;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFOldJPEGDecompressor;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFPackBitsDecompressor;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFRenderedImage;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFStreamMetadata;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFYCbCrColorConverter;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFYCbCrDecompressor;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFZSTDDecompressor;
import it.geosolutions.imageioimpl.plugins.tiff.TiffDatasetLayoutImpl;
import it.geosolutions.imageioimpl.plugins.tiff.gdal.GDALMetadata;
import it.geosolutions.imageioimpl.plugins.tiff.gdal.GDALMetadataParser;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Node;

public class TIFFImageReader
extends ImageReader {
    private static final Logger LOGGER = Logger.getLogger(TIFFImageReader.class.toString());
    private static final boolean DEBUG = false;
    private static final String MASK_SUFFIX = ".msk";
    private static final String OVR_SUFFIX = ".ovr";
    private int magic = -1;
    private Map<Integer, PageInfo> pagesInfo = new HashMap<Integer, PageInfo>();
    private boolean bigtiff = false;
    protected ImageInputStream stream = null;
    protected boolean gotTiffHeader = false;
    protected boolean initialized = false;
    protected ImageReadParam imageReadParam = this.getDefaultReadParam();
    protected TIFFStreamMetadata streamMetadata = null;
    protected int currIndex = -1;
    protected TIFFImageMetadata imageMetadata = null;
    List<Long> imageStartPosition = new ArrayList<Long>();
    int numImages = -1;
    HashMap<Integer, List<ImageTypeSpecifier>> imageTypeMap = new HashMap();
    protected BufferedImage theImage = null;
    protected int width = -1;
    protected int height = -1;
    protected int numBands = -1;
    protected int tileOrStripWidth = -1;
    protected int tileOrStripHeight = -1;
    protected int planarConfiguration = 1;
    protected int compression;
    protected int photometricInterpretation;
    protected int samplesPerPixel;
    protected int[] sampleFormat;
    protected int[] bitsPerSample;
    protected int[] extraSamples;
    protected char[] colorMap;
    protected int sourceXOffset;
    protected int sourceYOffset;
    protected int srcXSubsampling;
    protected int srcYSubsampling;
    protected int dstWidth;
    protected int dstHeight;
    protected int dstMinX;
    protected int dstMinY;
    protected int dstXOffset;
    protected int dstYOffset;
    protected int tilesAcross;
    protected int tilesDown;
    protected int pixelsRead;
    protected int pixelsToRead;
    private boolean isImageTiled = false;
    protected Double noData = null;
    private Double[] scales;
    private Double[] offsets;
    private TiffDatasetLayoutImpl layout;
    private File externalMask;
    private File externalOverviews;
    private File maskOverviews;
    protected int[] sourceBands;
    protected int[] destinationBands;
    private TIFFDecompressor decompressor;

    public TIFFImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.resetLocal();
        if (input != null) {
            FileImageInputStreamExtImpl stream;
            File inputFile;
            if (!(input instanceof ImageInputStream)) {
                throw new IllegalArgumentException("input not an ImageInputStream!");
            }
            this.stream = (ImageInputStream)input;
            if (!ImageIOUtilities.isSkipExternalFilesLookup() && input instanceof FileImageInputStreamExtImpl && (inputFile = (stream = (FileImageInputStreamExtImpl)input).getFile()) != null) {
                File ovr;
                File parent = inputFile.getParentFile();
                File mask = new File(parent, inputFile.getName() + MASK_SUFFIX);
                if (mask.exists() && mask.canRead()) {
                    this.externalMask = mask;
                    File mskOverviews = new File(mask.getAbsolutePath() + OVR_SUFFIX);
                    if (mskOverviews.exists() && mskOverviews.canRead()) {
                        this.maskOverviews = mskOverviews;
                    }
                }
                if ((ovr = new File(parent, inputFile.getName() + OVR_SUFFIX)).exists() && ovr.canRead()) {
                    this.externalOverviews = ovr;
                }
            }
        } else {
            this.stream = null;
        }
        this.layout = new TiffDatasetLayoutImpl();
    }

    private void readHeader() throws IIOException {
        if (this.gotTiffHeader) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        this.streamMetadata = new TIFFStreamMetadata();
        try {
            int byteOrder = this.stream.readUnsignedShort();
            if (byteOrder == 19789) {
                this.streamMetadata.byteOrder = ByteOrder.BIG_ENDIAN;
                this.stream.setByteOrder(ByteOrder.BIG_ENDIAN);
            } else if (byteOrder == 18761) {
                this.streamMetadata.byteOrder = ByteOrder.LITTLE_ENDIAN;
                this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            } else {
                this.processWarningOccurred("Bad byte order in header, assuming little-endian");
                this.streamMetadata.byteOrder = ByteOrder.LITTLE_ENDIAN;
                this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            }
            this.magic = this.stream.readUnsignedShort();
            if (this.magic != 42 && this.magic != 43) {
                this.processWarningOccurred("Bad magic number in header, continuing");
            }
            this.bigtiff = this.magic == 43;
            long offset = -1L;
            switch (this.magic) {
                case 42: {
                    offset = this.stream.readUnsignedInt();
                    break;
                }
                case 43: {
                    int alwaysZero;
                    int alwaysEight = this.stream.readUnsignedShort();
                    if (alwaysEight != 8) {
                        this.processWarningOccurred("No BigTiff file format");
                    }
                    if ((alwaysZero = this.stream.readUnsignedShort()) != 0) {
                        this.processWarningOccurred("No BigTiff file format");
                    }
                    offset = this.stream.readLong();
                }
            }
            if (offset >= 0L) {
                this.imageStartPosition.add(offset);
                this.stream.seek(offset);
            } else {
                this.processWarningOccurred("Error calculating offset");
            }
        }
        catch (IOException e) {
            throw new IIOException("I/O error reading header!", e);
        }
        this.gotTiffHeader = true;
    }

    private void defineDatasetLayout() throws IIOException {
        int numImg;
        if (this.layout.getNumInternalOverviews() != -1 || this.layout.getNumInternalMasks() != -1) {
            return;
        }
        this.readHeader();
        try {
            numImg = this.getNumImages(true);
        }
        catch (IOException e) {
            throw new IIOException(e.getMessage(), e);
        }
        int numOverviews = 0;
        int numMasks = 0;
        int numMaskOverView = 0;
        int currentIdx = this.currIndex;
        for (int i = 0; i < numImg; ++i) {
            Object data;
            this.seekToImage(i);
            PageInfo info = this.pagesInfo.get(i);
            TIFFImageMetadata metadata = (TIFFImageMetadata)((Object)info.imageMetadata.get());
            TIFFField f = metadata.getTIFFField(254);
            if (f == null || !((data = f.getData()) instanceof long[])) continue;
            long ldata = ((long[])data)[0];
            numMasks += (ldata & 4L) > 0L ? 1 : 0;
            numOverviews += (ldata & 1L) > 0L ? 1 : 0;
            numMaskOverView += (ldata & 1L) > 0L && (ldata & 4L) > 0L ? 1 : 0;
        }
        this.seekToImage(currentIdx);
        this.layout.setNumInternalMasks(numMasks);
        this.layout.setNumInternalOverviews(numOverviews - numMaskOverView);
    }

    private void defineExternalMasks() throws IIOException {
        if (!(this.externalMask != null && this.layout.getExternalMasks() == null || this.maskOverviews != null && this.layout.getExternalMaskOverviews() == null || this.externalOverviews != null && this.layout.getExternalOverviews() == null)) {
            return;
        }
        this.readHeader();
        this.layout.setExternalMasks(this.externalMask);
        this.layout.setExternalMaskOverviews(this.maskOverviews);
        this.layout.setExternalOverviews(this.externalOverviews);
        this.layout.setNumExternalMasks(this.getNumImages(this.externalMask));
        this.layout.setNumExternalMaskOverviews(this.getNumImages(this.maskOverviews));
        this.layout.setNumExternalOverviews(this.getNumImages(this.externalOverviews));
    }

    private int getNumImages(File inputFile) throws IIOException {
        int numImg = 0;
        ImageReader reader = null;
        FileImageInputStreamExtImpl stream = null;
        if (inputFile != null) {
            try {
                stream = new FileImageInputStreamExtImpl(inputFile);
                reader = this.originatingProvider.createReaderInstance();
                reader.setInput(stream);
                numImg = reader.getNumImages(true);
            }
            catch (IOException e) {
                throw new IIOException("Unable to open input .msk file", e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.dispose();
                    }
                    catch (Exception exception) {}
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return numImg;
    }

    private int locateImage(int imageIndex) throws IIOException {
        this.readHeader();
        try {
            int index;
            long l = this.imageStartPosition.get(index);
            this.stream.seek(l);
            switch (this.magic) {
                case 42: {
                    for (index = Math.min(imageIndex, this.imageStartPosition.size() - 1); index < imageIndex; ++index) {
                        int count = this.stream.readUnsignedShort();
                        this.stream.skipBytes(12 * count);
                        long offset = this.stream.readUnsignedInt();
                        if (offset == 0L) {
                            this.currIndex = index;
                            this.imageMetadata = null;
                            this.initialized = false;
                            return index;
                        }
                        this.imageStartPosition.add(offset);
                        this.stream.seek(offset);
                    }
                    break;
                }
                case 43: {
                    while (index < imageIndex) {
                        long count = this.stream.readLong();
                        this.stream.skipBytes(20L * count);
                        long offset = this.stream.readLong();
                        if (offset == 0L) {
                            this.currIndex = index;
                            this.imageMetadata = null;
                            this.initialized = false;
                            return index;
                        }
                        this.imageStartPosition.add(offset);
                        this.stream.seek(offset);
                        ++index;
                    }
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new IIOException("Couldn't seek!", e);
        }
        if (this.currIndex != imageIndex) {
            this.imageMetadata = null;
            this.initialized = false;
        }
        this.currIndex = imageIndex;
        return imageIndex;
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        if (this.seekForwardOnly && allowSearch) {
            throw new IllegalStateException("seekForwardOnly and allowSearch can't both be true!");
        }
        if (this.numImages > 0) {
            return this.numImages;
        }
        if (allowSearch) {
            this.numImages = this.locateImage(Integer.MAX_VALUE) + 1;
        }
        return this.numImages;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IIOException {
        this.readHeader();
        this.defineDatasetLayout();
        this.defineExternalMasks();
        this.streamMetadata.dtLayout = this.layout;
        return this.streamMetadata;
    }

    private void checkIndex(int imageIndex) {
        if (imageIndex < this.minIndex) {
            throw new IndexOutOfBoundsException("imageIndex < minIndex!");
        }
        if (this.seekForwardOnly) {
            this.minIndex = imageIndex;
        }
    }

    private void seekToImage(int imageIndex) throws IIOException {
        this.seekToImage(imageIndex, true);
    }

    private void seekToImage(int imageIndex, boolean optimized) throws IIOException {
        this.checkIndex(imageIndex);
        int index = this.locateImage(imageIndex);
        if (index != imageIndex) {
            throw new IndexOutOfBoundsException("imageIndex out of bounds!");
        }
        Integer i = index;
        if (!optimized) {
            this.readMetadata();
            this.initializeFromMetadata();
            return;
        }
        if (this.pagesInfo.containsKey(i) && (this.imageMetadata == null || !this.initialized)) {
            PageInfo info = this.pagesInfo.get(i);
            TIFFImageMetadata metadata = (TIFFImageMetadata)((Object)info.imageMetadata.get());
            if (metadata != null) {
                this.initializeFromCachedInfo(info, metadata);
                return;
            }
            this.pagesInfo.put(i, null);
        }
        this.readMetadata();
        this.initializeFromMetadata();
    }

    private void initializeFromCachedInfo(PageInfo pageInfo, TIFFImageMetadata imageMetadata) {
        this.bigtiff = pageInfo.bigtiff;
        this.bitsPerSample = pageInfo.bitsPerSample;
        this.colorMap = pageInfo.colorMap;
        this.compression = pageInfo.compression;
        this.extraSamples = pageInfo.extraSamples;
        this.height = pageInfo.height;
        this.isImageTiled = pageInfo.isImageTiled;
        this.numBands = pageInfo.numBands;
        this.photometricInterpretation = pageInfo.photometricInterpretation;
        this.planarConfiguration = pageInfo.planarConfiguration;
        this.sampleFormat = pageInfo.sampleFormat;
        this.samplesPerPixel = pageInfo.samplesPerPixel;
        this.tileOrStripHeight = pageInfo.tileOrStripHeight;
        this.tileOrStripWidth = pageInfo.tileOrStripWidth;
        this.width = pageInfo.width;
        this.noData = pageInfo.noData;
        this.imageMetadata = imageMetadata;
    }

    private void readMetadata() throws IIOException {
        if (this.imageMetadata != null) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        try {
            ArrayList<BaselineTIFFTagSet> tagSets;
            if (this.imageReadParam instanceof TIFFImageReadParam) {
                tagSets = ((TIFFImageReadParam)((Object)this.imageReadParam)).getAllowedTagSets();
            } else {
                tagSets = new ArrayList<BaselineTIFFTagSet>(1);
                tagSets.add(BaselineTIFFTagSet.getInstance());
            }
            this.imageMetadata = new TIFFImageMetadata(tagSets);
            this.imageMetadata.initializeFromStream(this.stream, this.ignoreMetadata, this.bigtiff);
            this.initialized = false;
        }
        catch (IIOException iioe) {
            throw iioe;
        }
        catch (IOException ioe) {
            throw new IIOException("I/O error reading image metadata!", ioe);
        }
    }

    private int getTileOrStripWidth() {
        TIFFField f = this.imageMetadata.getTIFFField(322);
        return f == null ? this.width : f.getAsInt(0);
    }

    private int getTileOrStripHeight() {
        int h = -1;
        TIFFField f = this.imageMetadata.getTIFFField(323);
        h = f != null ? f.getAsInt(0) : ((f = this.imageMetadata.getTIFFField(278)) == null ? -1 : f.getAsInt(0));
        return h == -1 ? this.height : h;
    }

    private int getPlanarConfiguration() {
        TIFFField f = this.imageMetadata.getTIFFField(284);
        if (f != null) {
            int planarConfigurationValue = f.getAsInt(0);
            if (planarConfigurationValue == 2) {
                if (this.compression == 6 && this.imageMetadata.getTIFFField(513) != null) {
                    this.processWarningOccurred("PlanarConfiguration \"Planar\" value inconsistent with JPEGInterchangeFormat; resetting to \"Chunky\".");
                    planarConfigurationValue = 1;
                } else {
                    TIFFField offsetField = this.imageMetadata.getTIFFField(324);
                    if (offsetField == null) {
                        offsetField = this.imageMetadata.getTIFFField(273);
                        int tw = this.tileOrStripWidth;
                        int th = this.tileOrStripHeight;
                        int tAcross = (this.width + tw - 1) / tw;
                        int tDown = (this.height + th - 1) / th;
                        int tilesPerImage = tAcross * tDown;
                        long[] offsetArray = offsetField.getAsLongs();
                        if (offsetArray != null && offsetArray.length == tilesPerImage) {
                            this.processWarningOccurred("PlanarConfiguration \"Planar\" value inconsistent with TileOffsets field value count; resetting to \"Chunky\".");
                            planarConfigurationValue = 1;
                        }
                    } else {
                        int rowsPerStrip = this.tileOrStripHeight;
                        int stripsPerImage = (this.height + rowsPerStrip - 1) / rowsPerStrip;
                        long[] offsetArray = offsetField.getAsLongs();
                        if (offsetArray != null && offsetArray.length == stripsPerImage) {
                            this.processWarningOccurred("PlanarConfiguration \"Planar\" value inconsistent with StripOffsets field value count; resetting to \"Chunky\".");
                            planarConfigurationValue = 1;
                        }
                    }
                }
            }
            return planarConfigurationValue;
        }
        return 1;
    }

    protected long getTileOrStripOffset(int tileIndex) throws IIOException {
        TIFFField f = this.imageMetadata.getTIFFField(324);
        if (f == null) {
            f = this.imageMetadata.getTIFFField(273);
        }
        if (f == null) {
            f = this.imageMetadata.getTIFFField(513);
        }
        if (f == null) {
            throw new IIOException("Missing required strip or tile offsets field.");
        }
        return f.getAsLong(tileIndex);
    }

    protected long getTileOrStripByteCount(int tileIndex) throws IOException {
        long tileOrStripByteCount;
        TIFFField f = this.imageMetadata.getTIFFField(325);
        if (f == null) {
            f = this.imageMetadata.getTIFFField(279);
        }
        if (f == null) {
            f = this.imageMetadata.getTIFFField(514);
        }
        if (f != null) {
            tileOrStripByteCount = f.getAsLong(tileIndex);
        } else {
            this.processWarningOccurred("TIFF directory contains neither StripByteCounts nor TileByteCounts field: attempting to calculate from strip or tile width and height.");
            int bitsPerPixel = this.bitsPerSample[0];
            for (int i = 1; i < this.samplesPerPixel; ++i) {
                bitsPerPixel += this.bitsPerSample[i];
            }
            int bytesPerRow = (this.tileOrStripWidth * bitsPerPixel + 7) / 8;
            tileOrStripByteCount = bytesPerRow * this.tileOrStripHeight;
            long streamLength = this.stream.length();
            if (streamLength != -1L) {
                tileOrStripByteCount = Math.min(tileOrStripByteCount, streamLength - this.getTileOrStripOffset(tileIndex));
            } else {
                this.processWarningOccurred("Stream length is unknown: cannot clamp estimated strip or tile byte count to EOF.");
            }
        }
        return tileOrStripByteCount;
    }

    protected int getCompression() {
        TIFFField f = this.imageMetadata.getTIFFField(259);
        if (f == null) {
            this.processWarningOccurred("Compression field is missing; assuming no compression");
            return 1;
        }
        return f.getAsInt(0);
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.seekToImage(imageIndex);
        return this.width;
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.seekToImage(imageIndex);
        return this.height;
    }

    private void initializeFromMetadata() {
        block36: {
            int i;
            Iterator<ImageReader> iter;
            if (this.initialized) {
                return;
            }
            this.planarConfiguration = this.getPlanarConfiguration();
            this.compression = this.getCompression();
            boolean isMissingDimension = false;
            TIFFField f = this.imageMetadata.getTIFFField(256);
            if (f != null) {
                this.width = f.getAsInt(0);
            } else {
                this.processWarningOccurred("ImageWidth field is missing.");
                isMissingDimension = true;
            }
            f = this.imageMetadata.getTIFFField(257);
            if (f != null) {
                this.height = f.getAsInt(0);
            } else {
                this.processWarningOccurred("ImageLength field is missing.");
                isMissingDimension = true;
            }
            this.tileOrStripWidth = this.getTileOrStripWidth();
            this.tileOrStripHeight = this.getTileOrStripHeight();
            f = this.imageMetadata.getTIFFField(322);
            this.isImageTiled = f != null;
            f = this.imageMetadata.getTIFFField(277);
            if (f != null) {
                this.samplesPerPixel = f.getAsInt(0);
            } else {
                this.samplesPerPixel = 1;
                isMissingDimension = true;
            }
            int defaultBitDepth = 1;
            if (isMissingDimension && (f = this.imageMetadata.getTIFFField(513)) != null && (iter = ImageIO.getImageReadersByFormatName("JPEG")) != null && iter.hasNext()) {
                ImageReader jreader = iter.next();
                try {
                    this.stream.mark();
                    this.stream.seek(f.getAsLong(0));
                    jreader.setInput(this.stream);
                    if (this.imageMetadata.getTIFFField(256) == null) {
                        this.width = jreader.getWidth(0);
                    }
                    if (this.imageMetadata.getTIFFField(257) == null) {
                        this.height = jreader.getHeight(0);
                    }
                    ImageTypeSpecifier imageType = jreader.getRawImageType(0);
                    if (this.imageMetadata.getTIFFField(277) == null) {
                        this.samplesPerPixel = imageType.getSampleModel().getNumBands();
                    }
                    this.stream.reset();
                    defaultBitDepth = imageType.getColorModel().getComponentSize(0);
                }
                catch (IOException imageType) {
                    // empty catch block
                }
                jreader.dispose();
            }
            if (this.samplesPerPixel < 1) {
                this.processWarningOccurred("Samples per pixel < 1!");
            }
            this.numBands = this.samplesPerPixel;
            this.colorMap = null;
            f = this.imageMetadata.getTIFFField(320);
            if (f != null) {
                this.colorMap = f.getAsChars();
            }
            if ((f = this.imageMetadata.getTIFFField(262)) == null) {
                if (this.compression == 2 || this.compression == 3 || this.compression == 4) {
                    this.processWarningOccurred("PhotometricInterpretation field is missing; assuming WhiteIsZero");
                    this.photometricInterpretation = 0;
                } else if (this.colorMap != null) {
                    this.photometricInterpretation = 3;
                } else if (this.samplesPerPixel == 3 || this.samplesPerPixel == 4) {
                    this.photometricInterpretation = 2;
                } else {
                    this.processWarningOccurred("PhotometricInterpretation field is missing; assuming BlackIsZero");
                    this.photometricInterpretation = 1;
                }
            } else {
                this.photometricInterpretation = f.getAsInt(0);
            }
            boolean replicateFirst = false;
            int first = -1;
            f = this.imageMetadata.getTIFFField(339);
            this.sampleFormat = new int[this.samplesPerPixel];
            replicateFirst = false;
            if (f == null) {
                replicateFirst = true;
                first = 4;
            } else if (f.getCount() != this.samplesPerPixel) {
                replicateFirst = true;
                first = f.getAsInt(0);
            }
            for (i = 0; i < this.samplesPerPixel; ++i) {
                int n = this.sampleFormat[i] = replicateFirst ? first : f.getAsInt(i);
                if (this.sampleFormat[i] == 1 || this.sampleFormat[i] == 2 || this.sampleFormat[i] == 3 || this.sampleFormat[i] == 4) continue;
                this.processWarningOccurred("Illegal value for SAMPLE_FORMAT, assuming SAMPLE_FORMAT_UNDEFINED");
                this.sampleFormat[i] = 4;
            }
            f = this.imageMetadata.getTIFFField(258);
            this.bitsPerSample = new int[this.samplesPerPixel];
            replicateFirst = false;
            if (f == null) {
                replicateFirst = true;
                first = defaultBitDepth;
            } else if (f.getCount() != this.samplesPerPixel) {
                replicateFirst = true;
                first = f.getAsInt(0);
            }
            for (i = 0; i < this.samplesPerPixel; ++i) {
                this.bitsPerSample[i] = replicateFirst ? first : f.getAsInt(i);
            }
            this.extraSamples = null;
            f = this.imageMetadata.getTIFFField(338);
            if (f != null) {
                this.extraSamples = f.getAsInts();
            }
            this.noData = null;
            f = this.imageMetadata.getTIFFField(42113);
            if (f != null) {
                String value = f.getAsString(0);
                this.noData = "nan".equalsIgnoreCase(value) ? Double.valueOf(Double.NaN) : ("inf".equalsIgnoreCase(value) ? Double.valueOf(Double.POSITIVE_INFINITY) : ("-inf".equalsIgnoreCase(value) ? Double.valueOf(Double.NEGATIVE_INFINITY) : Double.valueOf(Double.parseDouble(value))));
            }
            f = this.imageMetadata.getTIFFField(42112);
            this.offsets = null;
            this.scales = null;
            if (f != null) {
                try {
                    String xml = f.getAsString(0);
                    GDALMetadata gdalMetadata = GDALMetadataParser.parse(xml);
                    Double[] offsets = gdalMetadata.getOffsets(this.numBands);
                    Double[] scales = gdalMetadata.getScales(this.numBands);
                    this.offsets = offsets;
                    this.scales = scales;
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block36;
                    LOGGER.log(Level.FINE, "Skipping GDAL metadata parsing due to errors", e);
                }
            }
        }
        this.initialized = true;
        this.pagesInfo.put(this.currIndex, new PageInfo(this.imageMetadata, this.bigtiff, this.bitsPerSample, this.colorMap, this.compression, this.height, this.numBands, this.photometricInterpretation, this.width, this.tileOrStripWidth, this.tileOrStripHeight, this.planarConfiguration, this.isImageTiled, this.samplesPerPixel, this.sampleFormat, this.extraSamples, this.noData, this.offsets, this.scales));
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IIOException {
        Integer imageIndexInteger = imageIndex;
        if (this.imageTypeMap.containsKey(imageIndexInteger)) {
            return this.imageTypeMap.get(imageIndexInteger).iterator();
        }
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>();
        this.seekToImage(imageIndex, true);
        ImageTypeSpecifier itsRaw = TIFFDecompressor.getRawImageTypeSpecifier(this.photometricInterpretation, this.compression, this.samplesPerPixel, this.bitsPerSample, this.sampleFormat, this.extraSamples, this.colorMap);
        TIFFField iccProfileField = this.imageMetadata.getTIFFField(34675);
        if (iccProfileField != null && itsRaw.getColorModel() instanceof ComponentColorModel) {
            int numComponents;
            byte[] iccProfileValue = iccProfileField.getAsBytes();
            ICC_Profile iccProfile = ICC_Profile.getInstance(iccProfileValue);
            ICC_ColorSpace iccColorSpace = new ICC_ColorSpace(iccProfile);
            ColorModel cmRaw = itsRaw.getColorModel();
            ColorSpace csRaw = cmRaw.getColorSpace();
            SampleModel smRaw = itsRaw.getSampleModel();
            int numBands = smRaw.getNumBands();
            if (numBands == (numComponents = iccColorSpace.getNumComponents()) || numBands == numComponents + 1) {
                boolean hasAlpha = numComponents != numBands;
                boolean isAlphaPre = hasAlpha && cmRaw.isAlphaPremultiplied();
                ComponentColorModel iccColorModel = new ComponentColorModel(iccColorSpace, cmRaw.getComponentSize(), hasAlpha, isAlphaPre, cmRaw.getTransparency(), cmRaw.getTransferType());
                l.add(new ImageTypeSpecifier(iccColorModel, smRaw));
                if (csRaw.getType() == iccColorSpace.getType() && csRaw.getNumComponents() == iccColorSpace.getNumComponents()) {
                    l.add(itsRaw);
                }
            } else {
                l.add(itsRaw);
            }
        } else {
            l.add(itsRaw);
        }
        this.imageTypeMap.put(imageIndexInteger, l);
        return l.iterator();
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IIOException {
        this.seekToImage(imageIndex, true);
        TIFFImageMetadata im = new TIFFImageMetadata(this.imageMetadata.getRootIFD().getTagSetList());
        Node root = this.imageMetadata.getAsTree("it_geosolutions_imageioimpl_plugins_tiff_image_1.0");
        im.setFromTree("it_geosolutions_imageioimpl_plugins_tiff_image_1.0", root);
        if (this.noData != null) {
            im.setNoData(new double[]{this.noData, this.noData});
        }
        if (this.scales != null && this.offsets != null) {
            im.setScales(this.scales);
            im.setOffsets(this.offsets);
        }
        return im;
    }

    public IIOMetadata getStreamMetadata(int imageIndex) throws IIOException {
        this.readHeader();
        TIFFStreamMetadata sm = new TIFFStreamMetadata();
        Node root = sm.getAsTree("com_sun_media_imageio_plugins_tiff_stream_1.0");
        sm.setFromTree("com_sun_media_imageio_plugins_tiff_stream_1.0", root);
        return sm;
    }

    @Override
    public boolean isRandomAccessEasy(int imageIndex) throws IOException {
        if (this.currIndex != -1) {
            this.seekToImage(this.currIndex);
            return this.compression == 1;
        }
        return false;
    }

    public boolean readSupportsThumbnails() {
        return false;
    }

    @Override
    public boolean hasThumbnails(int imageIndex) {
        return false;
    }

    @Override
    public int getNumThumbnails(int imageIndex) throws IOException {
        return 0;
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new TIFFImageReadParam();
    }

    @Override
    public boolean isImageTiled(int imageIndex) throws IOException {
        this.seekToImage(imageIndex);
        return this.isImageTiled;
    }

    @Override
    public int getTileWidth(int imageIndex) throws IOException {
        this.seekToImage(imageIndex);
        return this.tileOrStripWidth;
    }

    @Override
    public int getTileHeight(int imageIndex) throws IOException {
        this.seekToImage(imageIndex);
        return this.tileOrStripHeight;
    }

    @Override
    public BufferedImage readTile(int imageIndex, int tileX, int tileY) throws IOException {
        int w = this.getWidth(imageIndex);
        int h = this.getHeight(imageIndex);
        int tw = this.getTileWidth(imageIndex);
        int th = this.getTileHeight(imageIndex);
        int x = tw * tileX;
        int y = th * tileY;
        if (tileX < 0 || tileY < 0 || x >= w || y >= h) {
            throw new IllegalArgumentException("Tile indices are out of bounds!");
        }
        if (x + tw > w) {
            tw = w - x;
        }
        if (y + th > h) {
            th = h - y;
        }
        ImageReadParam param = this.getDefaultReadParam();
        Rectangle tileRect = new Rectangle(x, y, tw, th);
        param.setSourceRegion(tileRect);
        return this.read(imageIndex, param);
    }

    @Override
    public boolean canReadRaster() {
        return false;
    }

    @Override
    public Raster readRaster(int imageIndex, ImageReadParam param) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static int ifloor(int num, int den) {
        if (num < 0) {
            num -= den - 1;
        }
        return num / den;
    }

    private static int iceil(int num, int den) {
        if (num > 0) {
            num += den - 1;
        }
        return num / den;
    }

    protected void prepareRead(int imageIndex, ImageReadParam param) throws IOException {
        EnhancedImageReadParam ep;
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        this.imageReadParam = param;
        this.seekToImage(imageIndex);
        ImageTypeSpecifier theImageType = null;
        if (param instanceof EnhancedImageReadParam && (ep = (EnhancedImageReadParam)param).getSourceBands() == null && ep.getBands() != null) {
            this.sourceBands = ep.getBands();
            this.destinationBands = IntStream.range(0, this.sourceBands.length).toArray();
            theImageType = TIFFImageReader.getBandSelectedImageType(this.sourceBands.length, this.getImageTypes(imageIndex));
        }
        if (theImageType == null) {
            this.sourceBands = param.getSourceBands();
            if (this.sourceBands == null) {
                this.sourceBands = new int[this.numBands];
                for (int i = 0; i < this.numBands; ++i) {
                    this.sourceBands[i] = i;
                }
            }
            if (theImageType == null) {
                Iterator<ImageTypeSpecifier> imageTypes = this.getImageTypes(imageIndex);
                theImageType = param.getDestinationType() != null ? param.getDestinationType() : ImageUtil.getDestinationType((ImageReadParam)param, imageTypes);
            }
            this.destinationBands = param.getDestinationBands();
            if (this.destinationBands == null) {
                int destNumBands = theImageType.getSampleModel().getNumBands();
                this.destinationBands = new int[destNumBands];
                for (int i = 0; i < destNumBands; ++i) {
                    this.destinationBands[i] = i;
                }
            }
            if (this.sourceBands.length != this.destinationBands.length) {
                throw new IllegalArgumentException("sourceBands.length != destinationBands.length");
            }
        }
        for (int i = 0; i < this.sourceBands.length; ++i) {
            int sb = this.sourceBands[i];
            if (sb < 0 || sb >= this.numBands) {
                throw new IllegalArgumentException("Source band out of range!");
            }
            int db = this.destinationBands[i];
            if (db >= 0 && db < theImageType.getSampleModel().getNumBands()) continue;
            throw new IllegalArgumentException("Destination band out of range!");
        }
    }

    private static ImageTypeSpecifier getBandSelectedImageType(int numBands, Iterator<ImageTypeSpecifier> imageTypes) throws IIOException {
        ImageTypeSpecifier o = imageTypes.next();
        if (!(o instanceof ImageTypeSpecifier)) {
            throw new IllegalArgumentException("Non-ImageTypeSpecifier retrieved from imageTypes!");
        }
        ImageTypeSpecifier its = o;
        return ImageIOUtilities.getBandSelectedType((int)numBands, (SampleModel)its.getSampleModel());
    }

    @Override
    public RenderedImage readAsRenderedImage(int imageIndex, ImageReadParam param) throws IOException {
        this.prepareRead(imageIndex, param);
        return new TIFFRenderedImage(this, imageIndex, this.imageReadParam, this.width, this.height);
    }

    private void decodeTile(int ti, int tj, int band) throws IOException {
        Rectangle tileRect = new Rectangle(ti * this.tileOrStripWidth, tj * this.tileOrStripHeight, this.tileOrStripWidth, this.tileOrStripHeight);
        if (!this.isImageTiled) {
            tileRect = tileRect.intersection(new Rectangle(0, 0, this.width, this.height));
        }
        if (tileRect.width <= 0 || tileRect.height <= 0) {
            return;
        }
        int srcMinX = tileRect.x;
        int srcMinY = tileRect.y;
        int srcWidth = tileRect.width;
        int srcHeight = tileRect.height;
        this.dstMinX = TIFFImageReader.iceil(srcMinX - this.sourceXOffset, this.srcXSubsampling);
        int dstMaxX = TIFFImageReader.ifloor(srcMinX + srcWidth - 1 - this.sourceXOffset, this.srcXSubsampling);
        this.dstMinY = TIFFImageReader.iceil(srcMinY - this.sourceYOffset, this.srcYSubsampling);
        int dstMaxY = TIFFImageReader.ifloor(srcMinY + srcHeight - 1 - this.sourceYOffset, this.srcYSubsampling);
        this.dstWidth = dstMaxX - this.dstMinX + 1;
        this.dstHeight = dstMaxY - this.dstMinY + 1;
        this.dstMinX += this.dstXOffset;
        this.dstMinY += this.dstYOffset;
        Rectangle dstRect = new Rectangle(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight);
        dstRect = dstRect.intersection(this.theImage.getRaster().getBounds());
        this.dstMinX = dstRect.x;
        this.dstMinY = dstRect.y;
        this.dstWidth = dstRect.width;
        this.dstHeight = dstRect.height;
        if (this.dstWidth <= 0 || this.dstHeight <= 0) {
            return;
        }
        int activeSrcMinX = (this.dstMinX - this.dstXOffset) * this.srcXSubsampling + this.sourceXOffset;
        int sxmax = (this.dstMinX + this.dstWidth - 1 - this.dstXOffset) * this.srcXSubsampling + this.sourceXOffset;
        int activeSrcWidth = sxmax - activeSrcMinX + 1;
        int activeSrcMinY = (this.dstMinY - this.dstYOffset) * this.srcYSubsampling + this.sourceYOffset;
        int symax = (this.dstMinY + this.dstHeight - 1 - this.dstYOffset) * this.srcYSubsampling + this.sourceYOffset;
        int activeSrcHeight = symax - activeSrcMinY + 1;
        this.decompressor.setSrcMinX(srcMinX);
        this.decompressor.setSrcMinY(srcMinY);
        this.decompressor.setSrcWidth(srcWidth);
        this.decompressor.setSrcHeight(srcHeight);
        this.decompressor.setDstMinX(this.dstMinX);
        this.decompressor.setDstMinY(this.dstMinY);
        this.decompressor.setDstWidth(this.dstWidth);
        this.decompressor.setDstHeight(this.dstHeight);
        this.decompressor.setActiveSrcMinX(activeSrcMinX);
        this.decompressor.setActiveSrcMinY(activeSrcMinY);
        this.decompressor.setActiveSrcWidth(activeSrcWidth);
        this.decompressor.setActiveSrcHeight(activeSrcHeight);
        int tileIndex = tj * this.tilesAcross + ti;
        if (this.planarConfiguration == 2) {
            tileIndex += band * this.tilesAcross * this.tilesDown;
        }
        long offset = this.getTileOrStripOffset(tileIndex);
        long byteCount = this.getTileOrStripByteCount(tileIndex);
        long streamLength = this.stream.length();
        if (streamLength > 0L && offset + byteCount > streamLength) {
            this.processWarningOccurred("Attempting to process truncated stream.");
            byteCount = streamLength - offset;
            if (Math.max(byteCount, 0L) == 0L) {
                this.processWarningOccurred("No bytes in strip/tile: skipping.");
                return;
            }
        }
        this.decompressor.setStream(this.stream);
        this.decompressor.setOffset(offset);
        this.decompressor.setByteCount((int)byteCount);
        this.decompressor.setNoData(this.noData);
        this.decompressor.beginDecoding();
        this.stream.mark();
        this.decompressor.decode();
        this.stream.reset();
    }

    private void reportProgress() {
        this.pixelsRead += this.dstWidth * this.dstHeight;
        this.processImageProgress(100.0f * (float)this.pixelsRead / (float)this.pixelsToRead);
        this.processImageUpdate(this.theImage, this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight, 1, 1, this.destinationBands);
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.prepareRead(imageIndex, param);
        this.theImage = TIFFImageReader.getDestination(param, this.getImageTypes(imageIndex), this.width, this.height, this.noData);
        this.srcXSubsampling = this.imageReadParam.getSourceXSubsampling();
        this.srcYSubsampling = this.imageReadParam.getSourceYSubsampling();
        Point p = this.imageReadParam.getDestinationOffset();
        this.dstXOffset = p.x;
        this.dstYOffset = p.y;
        Rectangle srcRegion = new Rectangle(0, 0, 0, 0);
        Rectangle destRegion = new Rectangle(0, 0, 0, 0);
        TIFFImageReader.computeRegions(this.imageReadParam, this.width, this.height, this.theImage, srcRegion, destRegion);
        this.sourceXOffset = srcRegion.x;
        this.sourceYOffset = srcRegion.y;
        this.pixelsToRead = destRegion.width * destRegion.height;
        this.pixelsRead = 0;
        this.processImageStarted(imageIndex);
        this.processImageProgress(0.0f);
        this.tilesAcross = (this.width + this.tileOrStripWidth - 1) / this.tileOrStripWidth;
        this.tilesDown = (this.height + this.tileOrStripHeight - 1) / this.tileOrStripHeight;
        TIFFColorConverter colorConverter = null;
        if (this.imageReadParam instanceof TIFFImageReadParam) {
            TIFFImageReadParam tparam = (TIFFImageReadParam)((Object)this.imageReadParam);
            this.decompressor = tparam.getTIFFDecompressor();
            colorConverter = tparam.getColorConverter();
        }
        if (this.decompressor == null) {
            int predictor;
            TIFFField predictorField;
            if (this.compression == 1) {
                TIFFField fillOrderField = this.imageMetadata.getTIFFField(266);
                this.decompressor = fillOrderField != null && fillOrderField.getAsInt(0) == 2 ? new TIFFLSBDecompressor() : new TIFFNullDecompressor();
            } else if (this.compression == 4) {
                if (PackageUtil.isCodecLibAvailable()) {
                    try {
                        this.decompressor = new TIFFCodecLibFaxDecompressor(this.compression);
                    }
                    catch (RuntimeException fillOrderField) {
                        // empty catch block
                    }
                }
                if (this.decompressor == null) {
                    this.decompressor = new TIFFFaxDecompressor();
                }
            } else if (this.compression == 3) {
                if (PackageUtil.isCodecLibAvailable()) {
                    try {
                        this.decompressor = new TIFFCodecLibFaxDecompressor(this.compression);
                    }
                    catch (RuntimeException fillOrderField) {
                        // empty catch block
                    }
                }
                if (this.decompressor == null) {
                    this.decompressor = new TIFFFaxDecompressor();
                }
            } else if (this.compression == 2) {
                this.decompressor = new TIFFFaxDecompressor();
            } else if (this.compression == 32773) {
                this.decompressor = new TIFFPackBitsDecompressor();
            } else if (this.compression == 5) {
                predictorField = this.imageMetadata.getTIFFField(317);
                predictor = predictorField == null ? 1 : predictorField.getAsInt(0);
                this.decompressor = new TIFFLZWDecompressor(predictor);
            } else if (this.compression == 7) {
                this.decompressor = new TIFFJPEGDecompressor();
            } else if (this.compression == 8 || this.compression == 32946) {
                predictorField = this.imageMetadata.getTIFFField(317);
                predictor = predictorField == null ? 1 : predictorField.getAsInt(0);
                this.decompressor = new TIFFDeflateDecompressor(predictor);
            } else if (this.compression == 6) {
                TIFFField JPEGProcField = this.imageMetadata.getTIFFField(512);
                if (JPEGProcField == null) {
                    this.processWarningOccurred("JPEGProc field missing; assuming baseline sequential JPEG process.");
                } else if (JPEGProcField.getAsInt(0) != 1) {
                    throw new IIOException("Old-style JPEG supported for baseline sequential JPEG process only!");
                }
                this.decompressor = new TIFFOldJPEGDecompressor();
            } else if (this.compression == 50000) {
                predictorField = this.imageMetadata.getTIFFField(317);
                predictor = predictorField == null ? 1 : predictorField.getAsInt(0);
                this.decompressor = new TIFFZSTDDecompressor(predictor);
            } else {
                throw new IIOException("Unsupported compression type (tag number = " + this.compression + ")!");
            }
            if (this.photometricInterpretation == 6 && this.compression != 7 && this.compression != 6) {
                boolean convertYCbCrToRGB = this.theImage.getColorModel().getColorSpace().getType() == 5;
                TIFFDecompressor wrappedDecompressor = this.decompressor instanceof TIFFNullDecompressor ? null : this.decompressor;
                this.decompressor = new TIFFYCbCrDecompressor(wrappedDecompressor, convertYCbCrToRGB);
            }
        }
        if (colorConverter == null) {
            if (this.photometricInterpretation == 8 && this.theImage.getColorModel().getColorSpace().getType() == 5) {
                colorConverter = new TIFFCIELabColorConverter();
            } else if (this.photometricInterpretation == 6 && !(this.decompressor instanceof TIFFYCbCrDecompressor) && this.compression != 7 && this.compression != 6) {
                colorConverter = new TIFFYCbCrColorConverter(this.imageMetadata);
            }
        }
        this.decompressor.setReader(this);
        this.decompressor.setMetadata((IIOMetadata)((Object)this.imageMetadata));
        this.decompressor.setImage(this.theImage);
        this.decompressor.setPhotometricInterpretation(this.photometricInterpretation);
        this.decompressor.setCompression(this.compression);
        this.decompressor.setSamplesPerPixel(this.samplesPerPixel);
        this.decompressor.setBitsPerSample(this.bitsPerSample);
        this.decompressor.setSampleFormat(this.sampleFormat);
        this.decompressor.setExtraSamples(this.extraSamples);
        this.decompressor.setColorMap(this.colorMap);
        this.decompressor.setColorConverter(colorConverter);
        this.decompressor.setSourceXOffset(this.sourceXOffset);
        this.decompressor.setSourceYOffset(this.sourceYOffset);
        this.decompressor.setSubsampleX(this.srcXSubsampling);
        this.decompressor.setSubsampleY(this.srcYSubsampling);
        this.decompressor.setDstXOffset(this.dstXOffset);
        this.decompressor.setDstYOffset(this.dstYOffset);
        this.decompressor.setSourceBands(this.sourceBands);
        this.decompressor.setDestinationBands(this.destinationBands);
        int minTileX = TIFFImageWriter.XToTileX(srcRegion.x, 0, this.tileOrStripWidth);
        int minTileY = TIFFImageWriter.YToTileY(srcRegion.y, 0, this.tileOrStripHeight);
        int maxTileX = TIFFImageWriter.XToTileX(srcRegion.x + srcRegion.width - 1, 0, this.tileOrStripWidth);
        int maxTileY = TIFFImageWriter.YToTileY(srcRegion.y + srcRegion.height - 1, 0, this.tileOrStripHeight);
        boolean isAbortRequested = false;
        if (this.planarConfiguration == 2) {
            this.decompressor.setPlanar(true);
            int[] sb = new int[1];
            int[] db = new int[1];
            for (int tj = minTileY; tj <= maxTileY; ++tj) {
                for (int ti = minTileX; ti <= maxTileX; ++ti) {
                    for (int band = 0; band < this.sourceBands.length; ++band) {
                        sb[0] = this.sourceBands[band];
                        this.decompressor.setSourceBands(sb);
                        db[0] = this.destinationBands[band];
                        this.decompressor.setDestinationBands(db);
                        if (this.abortRequested()) {
                            isAbortRequested = true;
                            break;
                        }
                        this.decodeTile(ti, tj, sb[0]);
                    }
                    if (isAbortRequested) break;
                    this.reportProgress();
                }
                if (!isAbortRequested) {
                    continue;
                }
                break;
            }
        } else {
            for (int tj = minTileY; tj <= maxTileY; ++tj) {
                for (int ti = minTileX; ti <= maxTileX; ++ti) {
                    if (this.abortRequested()) {
                        isAbortRequested = true;
                        break;
                    }
                    this.decodeTile(ti, tj, -1);
                    this.reportProgress();
                }
                if (!isAbortRequested) {
                    continue;
                }
                break;
            }
        }
        if (isAbortRequested) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return this.theImage;
    }

    @Override
    public void reset() {
        super.reset();
        this.resetLocal();
    }

    protected void resetLocal() {
        this.imageStartPosition.clear();
        this.pagesInfo.clear();
        this.stream = null;
        this.gotTiffHeader = false;
        this.imageReadParam = this.getDefaultReadParam();
        this.streamMetadata = null;
        this.currIndex = -1;
        this.imageMetadata = null;
        this.initialized = false;
        this.imageStartPosition = new ArrayList<Long>();
        this.numImages = -1;
        this.imageTypeMap = new HashMap();
        this.width = -1;
        this.height = -1;
        this.numBands = -1;
        this.tileOrStripWidth = -1;
        this.tileOrStripHeight = -1;
        this.planarConfiguration = 1;
    }

    void forwardWarningMessage(String warning) {
        this.processWarningOccurred(warning);
    }

    protected static BufferedImage getDestination(ImageReadParam param, Iterator<ImageTypeSpecifier> imageTypes, int width, int height, Double noData) throws IIOException {
        if (imageTypes == null || !imageTypes.hasNext()) {
            throw new IllegalArgumentException("imageTypes null or empty!");
        }
        BufferedImage dest = null;
        ImageTypeSpecifier imageType = null;
        if (param != null) {
            dest = param.getDestination();
            if (dest != null) {
                return dest;
            }
            imageType = param.getDestinationType();
        }
        if (imageType == null) {
            if (param instanceof EnhancedImageReadParam && ((EnhancedImageReadParam)param).getBands() != null) {
                int numBands = ((EnhancedImageReadParam)param).getBands().length;
                imageType = TIFFImageReader.getBandSelectedImageType(numBands, imageTypes);
            } else {
                ImageTypeSpecifier o = imageTypes.next();
                if (!(o instanceof ImageTypeSpecifier)) {
                    throw new IllegalArgumentException("Non-ImageTypeSpecifier retrieved from imageTypes!");
                }
                imageType = o;
            }
        }
        Rectangle srcRegion = new Rectangle(0, 0, 0, 0);
        Rectangle destRegion = new Rectangle(0, 0, 0, 0);
        TIFFImageReader.computeRegions(param, width, height, null, srcRegion, destRegion);
        int destWidth = destRegion.x + destRegion.width;
        int destHeight = destRegion.y + destRegion.height;
        if ((long)destWidth * (long)destHeight > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("width*height > Integer.MAX_VALUE!");
        }
        SampleModel sampleModel = imageType.getSampleModel(destWidth, destHeight);
        ColorModel colorModel = imageType.getColorModel();
        WritableRaster raster = Raster.createWritableRaster(sampleModel, new Point(0, 0));
        Hashtable<String, Double> properties = new Hashtable<String, Double>();
        if (noData != null) {
            properties.put("GC_NODATA", noData);
        }
        return new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), properties);
    }

    @Override
    public void dispose() {
        if (this.decompressor != null) {
            this.decompressor.dispose();
        }
        this.layout = null;
        if (this.theImage != null) {
            this.theImage.flush();
        }
        this.theImage = null;
        this.imageStartPosition = null;
        this.imageMetadata = null;
        this.imageReadParam = null;
        this.stream = null;
    }

    protected static final class PageInfo {
        private SoftReference<TIFFImageMetadata> imageMetadata;
        private boolean bigtiff = false;
        private int[] bitsPerSample;
        private char[] colorMap;
        private int compression;
        private int height = -1;
        private int numBands = -1;
        private int photometricInterpretation;
        private int width = -1;
        private int tileOrStripWidth = -1;
        private int tileOrStripHeight = -1;
        private int planarConfiguration = 1;
        private boolean isImageTiled = false;
        private int samplesPerPixel;
        private int[] sampleFormat;
        private int[] extraSamples;
        private Double noData = null;
        private Double[] scales;
        private Double[] offsets;

        protected PageInfo(TIFFImageMetadata imageMetadata, boolean bigtiff, int[] bitsPerSample, char[] colorMap, int compression, int height, int numBands, int photometricInterpretation, int width, int tileOrStripWidth, int tileOrStripHeight, int planarConfiguration, boolean isImageTiled, int samplesPerPixel, int[] sampleFormat, int[] extraSamples, Double noData, Double[] offsets, Double[] scales) {
            this.imageMetadata = new SoftReference<TIFFImageMetadata>(imageMetadata);
            this.bigtiff = bigtiff;
            this.bitsPerSample = bitsPerSample;
            this.colorMap = colorMap;
            this.compression = compression;
            this.height = height;
            this.numBands = numBands;
            this.photometricInterpretation = photometricInterpretation;
            this.width = width;
            this.tileOrStripWidth = tileOrStripWidth;
            this.tileOrStripHeight = tileOrStripHeight;
            this.planarConfiguration = planarConfiguration;
            this.isImageTiled = isImageTiled;
            this.samplesPerPixel = samplesPerPixel;
            this.sampleFormat = sampleFormat;
            this.extraSamples = extraSamples;
            this.noData = noData;
            this.offsets = offsets;
            this.scales = scales;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bigtiff ? 1231 : 1237);
            result = 31 * result + Arrays.hashCode(this.bitsPerSample);
            result = 31 * result + Arrays.hashCode(this.colorMap);
            result = 31 * result + this.compression;
            result = 31 * result + Arrays.hashCode(this.extraSamples);
            result = 31 * result + this.height;
            result = 31 * result + (this.isImageTiled ? 1231 : 1237);
            result = 31 * result + (this.noData == null ? 0 : this.noData.hashCode());
            result = 31 * result + this.numBands;
            result = 31 * result + this.photometricInterpretation;
            result = 31 * result + this.planarConfiguration;
            result = 31 * result + Arrays.hashCode(this.sampleFormat);
            result = 31 * result + this.samplesPerPixel;
            result = 31 * result + this.tileOrStripHeight;
            result = 31 * result + this.tileOrStripWidth;
            result = 31 * result + this.width;
            result = 31 * result + Arrays.hashCode((Object[])this.offsets);
            result = 31 * result + Arrays.hashCode((Object[])this.scales);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PageInfo)) {
                return false;
            }
            PageInfo other = (PageInfo)obj;
            if (this.bigtiff != other.bigtiff) {
                return false;
            }
            if (!Arrays.equals(this.bitsPerSample, other.bitsPerSample)) {
                return false;
            }
            if (!Arrays.equals(this.colorMap, other.colorMap)) {
                return false;
            }
            if (this.compression != other.compression) {
                return false;
            }
            if (!Arrays.equals(this.extraSamples, other.extraSamples)) {
                return false;
            }
            if (this.height != other.height) {
                return false;
            }
            if (this.isImageTiled != other.isImageTiled) {
                return false;
            }
            if (this.noData == null ? other.noData != null : !this.noData.equals(other.noData)) {
                return false;
            }
            if (this.numBands != other.numBands) {
                return false;
            }
            if (this.photometricInterpretation != other.photometricInterpretation) {
                return false;
            }
            if (this.planarConfiguration != other.planarConfiguration) {
                return false;
            }
            if (!Arrays.equals(this.sampleFormat, other.sampleFormat)) {
                return false;
            }
            if (this.samplesPerPixel != other.samplesPerPixel) {
                return false;
            }
            if (this.tileOrStripHeight != other.tileOrStripHeight) {
                return false;
            }
            if (this.tileOrStripWidth != other.tileOrStripWidth) {
                return false;
            }
            if (this.width != other.width) {
                return false;
            }
            if (!Arrays.equals((Object[])this.offsets, (Object[])other.offsets)) {
                return false;
            }
            return Arrays.equals((Object[])this.scales, (Object[])other.scales);
        }

        public String toString() {
            return "PageInfo [bigtiff=" + this.bigtiff + ", bitsPerSample=" + Arrays.toString(this.bitsPerSample) + ", colorMap=" + Arrays.toString(this.colorMap) + ", compression=" + this.compression + ", extraSamples=" + Arrays.toString(this.extraSamples) + ", height=" + this.height + ", isImageTiled=" + this.isImageTiled + ", numBands=" + this.numBands + ", photometricInterpretation=" + this.photometricInterpretation + ", planarConfiguration=" + this.planarConfiguration + ", sampleFormat=" + Arrays.toString(this.sampleFormat) + ", samplesPerPixel=" + this.samplesPerPixel + ", tileOrStripHeight=" + this.tileOrStripHeight + ", tileOrStripWidth=" + this.tileOrStripWidth + ", width=" + this.width + ", noData=" + this.noData + ", offsets=" + Arrays.toString((Object[])this.offsets) + ", scales=" + Arrays.toString((Object[])this.scales) + "]";
        }
    }
}

