/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class SourceSPIProvider {
    private ImageReaderSpi readerSpi;
    private ImageInputStreamSpi streamSpi;
    private Object source;

    public ImageInputStreamSpi getStreamSpi() {
        return this.streamSpi;
    }

    public void setStreamSpi(ImageInputStreamSpi streamSpi) {
        this.streamSpi = streamSpi;
    }

    public ImageReaderSpi getReaderSpi() {
        return this.readerSpi;
    }

    public void setReaderSpi(ImageReaderSpi readerSpi) {
        this.readerSpi = readerSpi;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public URL getSourceUrl() throws MalformedURLException {
        if (this.source instanceof URL) {
            return (URL)this.source;
        }
        if (this.source instanceof String) {
            return new URL((String)this.source);
        }
        if (this.source instanceof File) {
            return SourceSPIProvider.fileToUrl((File)this.source);
        }
        if (this.source instanceof URI) {
            return ((URI)this.source).toURL();
        }
        return null;
    }

    public SourceSPIProvider(Object source, ImageReaderSpi readerSpi, ImageInputStreamSpi streamSpi) {
        this.readerSpi = readerSpi;
        this.streamSpi = streamSpi;
        this.source = source;
    }

    public ImageReader getReader() throws IOException {
        return this.readerSpi.createReaderInstance();
    }

    public ImageInputStream getStream() throws IOException {
        return this.streamSpi.createInputStreamInstance(this.source, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
    }

    public SourceSPIProvider getCompatibleSourceProvider(URL url) {
        return new SourceSPIProvider(url, this.readerSpi, this.streamSpi);
    }

    public static URL fileToUrl(File file) {
        try {
            String string = file.toURI().toASCIIString();
            if (string.contains("+")) {
                string = string.replace("+", "%2B");
            }
            if (string.contains(" ")) {
                string = string.replace(" ", "%20");
            }
            return new URL(string);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

