/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.nativewindow.util.PixelFormatUtil;
import com.jogamp.nativewindow.util.PixelRectangle;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.newt.event.NEWTEventConsumer;
import com.jogamp.newt.util.EDTUtil;
import com.jogamp.opengl.util.PNGPixelRect;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import jogamp.newt.DefaultEDTUtil;
import jogamp.newt.PointerIconImpl;
import jogamp.newt.ScreenImpl;
import jogamp.newt.WindowImpl;
import jogamp.newt.event.NEWTEventTask;

public abstract class DisplayImpl
extends Display {
    private static int serialno = 1;
    private static final boolean pngUtilAvail;
    final ArrayList<PointerIconImpl> pointerIconList = new ArrayList();
    public static final String nilString = "nil";
    private final Object eventsLock = new Object();
    private ArrayList<NEWTEventTask> events = new ArrayList();
    private volatile boolean haveEvents = false;
    protected final Runnable dispatchMessagesRunnable = new Runnable(){

        @Override
        public void run() {
            DisplayImpl.this.dispatchMessages();
        }
    };
    protected volatile EDTUtil edtUtil = null;
    protected int id;
    protected String name;
    protected String type;
    protected String fqname;
    protected int hashCode;
    protected int refCount;
    protected boolean exclusive;
    protected AbstractGraphicsDevice aDevice;

    public static final boolean isPNGUtilAvailable() {
        return pngUtilAvail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyAllPointerIconFromList(long l) {
        ArrayList<PointerIconImpl> arrayList = this.pointerIconList;
        synchronized (arrayList) {
            int n = this.pointerIconList.size();
            for (int i = 0; i < n; ++i) {
                PointerIconImpl pointerIconImpl = this.pointerIconList.get(i);
                if (DEBUG) {
                    System.err.println("destroyAllPointerIconFromList: dpy " + DisplayImpl.toHexString(l) + ", # " + i + "/" + n + ": " + pointerIconImpl + " @ " + DisplayImpl.getThreadName());
                }
                if (null == pointerIconImpl || !pointerIconImpl.isValid()) continue;
                pointerIconImpl.destroyOnEDT(l);
            }
            this.pointerIconList.clear();
        }
    }

    @Override
    public PixelFormat getNativePointerIconPixelFormat() {
        return PixelFormat.BGRA8888;
    }

    @Override
    public boolean getNativePointerIconForceDirectNIO() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Display.PointerIcon createPointerIcon(final IOUtil.ClassResources classResources, final int n, final int n2) throws IllegalArgumentException, IllegalStateException, IOException {
        if (null == classResources || 0 >= classResources.resourceCount()) {
            throw new IllegalArgumentException("Null or invalid pngResource " + classResources);
        }
        if (!pngUtilAvail) {
            return null;
        }
        final PointerIconImpl[] pointerIconImplArray = new PointerIconImpl[]{null};
        this.runOnEDTIfAvail(true, new Runnable(){

            @Override
            public void run() {
                try {
                    if (!DisplayImpl.this.isNativeValidAsync()) {
                        throw new IllegalStateException("Display.createPointerIcon: Display invalid " + DisplayImpl.this);
                    }
                    URLConnection uRLConnection = classResources.resolve(0);
                    if (null == uRLConnection) {
                        throw new IOException("Could not resolve " + classResources.resourcePaths[0]);
                    }
                    PNGPixelRect pNGPixelRect = PNGPixelRect.read(uRLConnection.getInputStream(), DisplayImpl.this.getNativePointerIconPixelFormat(), DisplayImpl.this.getNativePointerIconForceDirectNIO(), 0, false);
                    long l = DisplayImpl.this.createPointerIconImplChecked(pNGPixelRect.getPixelformat(), pNGPixelRect.getSize().getWidth(), pNGPixelRect.getSize().getHeight(), pNGPixelRect.getPixels(), n, n2);
                    Point point = new Point(n, n2);
                    if (DEBUG_POINTER_ICON) {
                        System.err.println("createPointerIconPNG.0: " + pNGPixelRect + ", handle: " + Display.toHexString(l) + ", hot " + point);
                    }
                    if (0L != l) {
                        pointerIconImplArray[0] = new PointerIconImpl(DisplayImpl.this, pNGPixelRect, point, l);
                        if (DEBUG_POINTER_ICON) {
                            System.err.println("createPointerIconPNG.0: " + pointerIconImplArray[0]);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        if (null != pointerIconImplArray[0]) {
            ArrayList<PointerIconImpl> arrayList = this.pointerIconList;
            synchronized (arrayList) {
                this.pointerIconList.add(pointerIconImplArray[0]);
            }
        }
        return pointerIconImplArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Display.PointerIcon createPointerIcon(PixelRectangle pixelRectangle, final int n, final int n2) throws IllegalArgumentException, IllegalStateException {
        Object object;
        PointerIconImpl[] pointerIconImplArray;
        PixelRectangle pixelRectangle2;
        if (null == pixelRectangle) {
            throw new IllegalArgumentException("Null or pixelrect");
        }
        if (this.getNativePointerIconPixelFormat() != pixelRectangle.getPixelformat() || pixelRectangle.isGLOriented()) {
            pixelRectangle2 = PixelFormatUtil.convert(pixelRectangle, this.getNativePointerIconPixelFormat(), 0, false, this.getNativePointerIconForceDirectNIO());
            if (DEBUG_POINTER_ICON) {
                System.err.println("createPointerIconRES.0: Conversion-FMT " + pixelRectangle + " -> " + pixelRectangle2);
            }
        } else if (this.getNativePointerIconForceDirectNIO() && !Buffers.isDirect((Object)pixelRectangle.getPixels())) {
            pointerIconImplArray = pixelRectangle.getPixels();
            object = Buffers.newDirectByteBuffer((byte[])pointerIconImplArray.array(), (int)pointerIconImplArray.arrayOffset());
            pixelRectangle2 = new PixelRectangle.GenericPixelRect(pixelRectangle.getPixelformat(), pixelRectangle.getSize(), pixelRectangle.getStride(), pixelRectangle.isGLOriented(), (ByteBuffer)object);
            if (DEBUG_POINTER_ICON) {
                System.err.println("createPointerIconRES.0: Conversion-NIO " + pixelRectangle + " -> " + pixelRectangle2);
            }
        } else {
            pixelRectangle2 = pixelRectangle;
            if (DEBUG_POINTER_ICON) {
                System.err.println("createPointerIconRES.0: No conversion " + pixelRectangle2);
            }
        }
        pointerIconImplArray = new PointerIconImpl[]{null};
        this.runOnEDTIfAvail(true, new Runnable(){

            @Override
            public void run() {
                try {
                    long l;
                    if (!DisplayImpl.this.isNativeValidAsync()) {
                        throw new IllegalStateException("Display.createPointerIcon: Display invalid " + DisplayImpl.this);
                    }
                    if (null != pixelRectangle2 && 0L != (l = DisplayImpl.this.createPointerIconImplChecked(pixelRectangle2.getPixelformat(), pixelRectangle2.getSize().getWidth(), pixelRectangle2.getSize().getHeight(), pixelRectangle2.getPixels(), n, n2))) {
                        pointerIconImplArray[0] = new PointerIconImpl(DisplayImpl.this, pixelRectangle2, new Point(n, n2), l);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        if (null != pointerIconImplArray[0]) {
            object = this.pointerIconList;
            synchronized (object) {
                this.pointerIconList.add(pointerIconImplArray[0]);
            }
        }
        return pointerIconImplArray[0];
    }

    protected final long createPointerIconImplChecked(PixelFormat pixelFormat, int n, int n2, ByteBuffer byteBuffer, int n3, int n4) {
        if (this.getNativePointerIconPixelFormat() != pixelFormat) {
            throw new IllegalArgumentException("Pixelformat no " + (Object)((Object)this.getNativePointerIconPixelFormat()) + ", but " + (Object)((Object)pixelFormat));
        }
        if (this.getNativePointerIconForceDirectNIO() && !Buffers.isDirect((Object)byteBuffer)) {
            throw new IllegalArgumentException("pixel buffer is not direct " + byteBuffer);
        }
        return this.createPointerIconImpl(pixelFormat, n, n2, byteBuffer, n3, n4);
    }

    protected long createPointerIconImpl(PixelFormat pixelFormat, int n, int n2, ByteBuffer byteBuffer, int n3, int n4) {
        return 0L;
    }

    protected void destroyPointerIconImpl(long l, long l2) {
    }

    static void initSingleton() {
    }

    private static Class<?> getDisplayClass(String string) throws ClassNotFoundException {
        Class<?> clazz = NewtFactory.getCustomClass(string, "DisplayDriver");
        if (null == clazz) {
            throw new ClassNotFoundException("Failed to find NEWT Display Class <" + string + ".DisplayDriver>");
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display create(String string, String string2, long l, boolean bl) {
        try {
            Class<?> clazz = DisplayImpl.getDisplayClass(string);
            DisplayImpl displayImpl = (DisplayImpl)clazz.newInstance();
            string2 = displayImpl.validateDisplayName(string2, l);
            ArrayList arrayList = displayList;
            synchronized (arrayList) {
                Display display;
                if (bl && null != (display = Display.getLastDisplayOf(string, string2, -1, true))) {
                    if (DEBUG) {
                        System.err.println("Display.create() REUSE: " + display + " " + DisplayImpl.getThreadName());
                    }
                    return display;
                }
                displayImpl.exclusive = !bl;
                displayImpl.name = string2;
                displayImpl.type = string;
                displayImpl.refCount = 0;
                displayImpl.id = serialno++;
                displayImpl.fqname = DisplayImpl.getFQName(displayImpl.type, displayImpl.name, displayImpl.id);
                displayImpl.hashCode = displayImpl.fqname.hashCode();
                displayImpl.setEDTUtil(displayImpl.edtUtil);
                Display.addDisplay2List(displayImpl);
            }
            if (DEBUG) {
                System.err.println("Display.create() NEW: " + displayImpl + " " + DisplayImpl.getThreadName());
            }
            return displayImpl;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DisplayImpl displayImpl = (DisplayImpl)object;
        if (this.id != displayImpl.id) {
            return false;
        }
        if (this.name == null ? displayImpl.name != null : !this.name.equals(displayImpl.name)) {
            return false;
        }
        return !(this.type == null ? displayImpl.type != null : !this.type.equals(displayImpl.type));
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void createNative() throws NativeWindowException {
        if (null == this.aDevice) {
            if (DEBUG) {
                System.err.println("Display.createNative() START (" + DisplayImpl.getThreadName() + ", " + this + ")");
            }
            final DisplayImpl displayImpl = this;
            try {
                this.runOnEDTIfAvail(true, new Runnable(){

                    @Override
                    public void run() {
                        displayImpl.createNativeImpl();
                    }
                });
            }
            catch (Throwable throwable) {
                throw new NativeWindowException(throwable);
            }
            if (null == this.aDevice) {
                throw new NativeWindowException("Display.createNative() failed to instanciate an AbstractGraphicsDevice");
            }
            ArrayList arrayList = displayList;
            synchronized (arrayList) {
                ++displaysActive;
                if (DEBUG) {
                    System.err.println("Display.createNative() END (" + DisplayImpl.getThreadName() + ", " + this + ", active " + displaysActive + ")");
                }
            }
        }
    }

    protected EDTUtil createEDTUtil() {
        DefaultEDTUtil defaultEDTUtil;
        if (NewtFactory.useEDT()) {
            defaultEDTUtil = new DefaultEDTUtil(Thread.currentThread().getThreadGroup(), "Display-" + this.getFQName(), this.dispatchMessagesRunnable);
            if (DEBUG) {
                System.err.println("Display.createEDTUtil(" + this.getFQName() + "): " + defaultEDTUtil.getClass().getName());
            }
        } else {
            defaultEDTUtil = null;
        }
        return defaultEDTUtil;
    }

    @Override
    public synchronized EDTUtil setEDTUtil(EDTUtil eDTUtil) {
        EDTUtil eDTUtil2 = this.edtUtil;
        if (null != eDTUtil && eDTUtil == eDTUtil2) {
            if (DEBUG) {
                System.err.println("Display.setEDTUtil: " + eDTUtil + " - keep!");
            }
            return eDTUtil2;
        }
        if (DEBUG) {
            String string = null == eDTUtil ? "default" : "custom";
            System.err.println("Display.setEDTUtil(" + string + "): " + eDTUtil2 + " -> " + eDTUtil);
        }
        DisplayImpl.stopEDT(eDTUtil2, null);
        this.edtUtil = null == eDTUtil ? this.createEDTUtil() : eDTUtil;
        return eDTUtil2;
    }

    @Override
    public final EDTUtil getEDTUtil() {
        return this.edtUtil;
    }

    private static void stopEDT(EDTUtil eDTUtil, Runnable runnable) {
        if (null != eDTUtil) {
            if (eDTUtil.isRunning()) {
                boolean bl = eDTUtil.invokeStop(true, runnable);
                if (DEBUG && !bl) {
                    System.err.println("Warning: invokeStop() failed");
                    ExceptionUtils.dumpStack((PrintStream)System.err);
                }
            }
            eDTUtil.waitUntilStopped();
        } else if (null != runnable) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOnEDTIfAvail(boolean bl, Runnable runnable) {
        EDTUtil eDTUtil = this.edtUtil;
        if (!eDTUtil.isRunning()) {
            DisplayImpl displayImpl = this;
            synchronized (displayImpl) {
                if (!eDTUtil.isRunning()) {
                    if (DEBUG) {
                        System.err.println("Info: EDT start " + Thread.currentThread().getName() + ", " + this);
                        ExceptionUtils.dumpStack((PrintStream)System.err);
                    }
                    eDTUtil.start();
                }
            }
        }
        if (!eDTUtil.isCurrentThreadEDT()) {
            if (eDTUtil.invoke(bl, runnable)) {
                return;
            }
            if (DEBUG) {
                System.err.println("Warning: invoke(wait " + bl + ", ..) on EDT failed .. invoke on current thread " + Thread.currentThread().getName());
                ExceptionUtils.dumpStack((PrintStream)System.err);
            }
        }
        runnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateEDTStopped() {
        EDTUtil eDTUtil;
        if (0 == this.refCount && null == this.aDevice && null != (eDTUtil = this.edtUtil) && eDTUtil.isRunning()) {
            DisplayImpl displayImpl = this;
            synchronized (displayImpl) {
                if (null != this.edtUtil && this.edtUtil.isRunning()) {
                    DisplayImpl.stopEDT(this.edtUtil, null);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void destroy() {
        if (DEBUG) {
            DisplayImpl.dumpDisplayList("Display.destroy(" + this.getFQName() + ") BEGIN");
        }
        Object object = displayList;
        synchronized (object) {
            if (0 < displaysActive) {
                --displaysActive;
            }
            if (DEBUG) {
                System.err.println("Display.destroy(): " + this + ", active " + displaysActive + " " + DisplayImpl.getThreadName());
            }
        }
        object = this;
        final AbstractGraphicsDevice abstractGraphicsDevice = this.aDevice;
        this.aDevice = null;
        this.refCount = 0;
        DisplayImpl.stopEDT(this.edtUtil, new Runnable((DisplayImpl)object){
            final /* synthetic */ DisplayImpl val$f_dpy;
            {
                this.val$f_dpy = displayImpl2;
            }

            @Override
            public void run() {
                if (null != abstractGraphicsDevice) {
                    this.val$f_dpy.destroyAllPointerIconFromList(abstractGraphicsDevice.getHandle());
                    this.val$f_dpy.closeNativeImpl(abstractGraphicsDevice);
                }
            }
        });
        if (DEBUG) {
            DisplayImpl.dumpDisplayList("Display.destroy(" + this.getFQName() + ") END");
        }
    }

    static final void shutdownAll() {
        int n = displayList.size();
        if (DEBUG) {
            DisplayImpl.dumpDisplayList("Display.shutdownAll " + n + " instances, on thread " + DisplayImpl.getThreadName());
        }
        for (int i = 0; i < n && displayList.size() > 0; ++i) {
            final DisplayImpl displayImpl = (DisplayImpl)((WeakReference)displayList.remove(0)).get();
            if (DEBUG) {
                System.err.println("Display.shutdownAll[" + (i + 1) + "/" + n + "]: " + displayImpl + ", GCed " + (null == displayImpl));
            }
            if (null == displayImpl) continue;
            if (0 < displaysActive) {
                --displaysActive;
            }
            EDTUtil eDTUtil = displayImpl.getEDTUtil();
            final AbstractGraphicsDevice abstractGraphicsDevice = displayImpl.aDevice;
            displayImpl.aDevice = null;
            displayImpl.refCount = 0;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (null != displayImpl.getGraphicsDevice()) {
                        displayImpl.destroyAllPointerIconFromList(abstractGraphicsDevice.getHandle());
                        displayImpl.closeNativeImpl(abstractGraphicsDevice);
                    }
                }
            };
            if (null != eDTUtil) {
                long l = eDTUtil.getPollPeriod() * 2L;
                if (eDTUtil.isRunning()) {
                    eDTUtil.invokeStop(false, runnable);
                }
                try {
                    Thread.sleep(l < 50L ? l : 50L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            runnable.run();
        }
    }

    @Override
    public final synchronized int addReference() {
        if (DEBUG) {
            System.err.println("Display.addReference() (" + Display.getThreadName() + "): " + this.refCount + " -> " + (this.refCount + 1));
        }
        if (0 == this.refCount) {
            this.createNative();
        }
        if (null == this.aDevice) {
            throw new NativeWindowException("Display.addReference() (refCount " + this.refCount + ") null AbstractGraphicsDevice");
        }
        return this.refCount++;
    }

    @Override
    public final synchronized int removeReference() {
        if (DEBUG) {
            System.err.println("Display.removeReference() (" + Display.getThreadName() + "): " + this.refCount + " -> " + (this.refCount - 1));
        }
        --this.refCount;
        if (0 >= this.refCount) {
            this.destroy();
            this.refCount = 0;
        }
        return this.refCount;
    }

    @Override
    public final synchronized int getReferenceCount() {
        return this.refCount;
    }

    protected abstract void createNativeImpl();

    protected abstract void closeNativeImpl(AbstractGraphicsDevice var1);

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getFQName() {
        return this.fqname;
    }

    @Override
    public final boolean isExclusive() {
        return this.exclusive;
    }

    public String validateDisplayName(String string, long l) {
        if (null == string && 0L != l) {
            string = "wrapping-" + DisplayImpl.toHexString(l);
        }
        return null == string ? nilString : string;
    }

    private static String getFQName(String string, String string2, int n) {
        if (null == string) {
            string = nilString;
        }
        if (null == string2) {
            string2 = nilString;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("_");
        stringBuilder.append(string2);
        stringBuilder.append("-");
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    @Override
    public final long getHandle() {
        if (null != this.aDevice) {
            return this.aDevice.getHandle();
        }
        return 0L;
    }

    @Override
    public final AbstractGraphicsDevice getGraphicsDevice() {
        return this.aDevice;
    }

    @Override
    public final synchronized boolean isNativeValid() {
        return null != this.aDevice;
    }

    protected final boolean isNativeValidAsync() {
        return null != this.aDevice;
    }

    @Override
    public boolean isEDTRunning() {
        EDTUtil eDTUtil = this.edtUtil;
        if (null != eDTUtil) {
            return eDTUtil.isRunning();
        }
        return false;
    }

    public String toString() {
        EDTUtil eDTUtil = this.edtUtil;
        boolean bl = null != eDTUtil ? eDTUtil.isRunning() : false;
        return "NEWT-Display[" + this.getFQName() + ", excl " + this.exclusive + ", refCount " + this.refCount + ", hasEDT " + (null != eDTUtil) + ", edtRunning " + bl + ", " + this.aDevice + "]";
    }

    protected abstract void dispatchMessagesNative();

    final void dispatchMessage(NEWTEvent nEWTEvent) {
        block4: {
            try {
                Object object = nEWTEvent.getSource();
                if (object instanceof NEWTEventConsumer) {
                    NEWTEventConsumer nEWTEventConsumer = (NEWTEventConsumer)object;
                    if (!nEWTEventConsumer.consumeEvent(nEWTEvent)) {
                        this.enqueueEvent(false, nEWTEvent);
                    }
                    break block4;
                }
                throw new RuntimeException("Event source not NEWT: " + object.getClass().getName() + ", " + object);
            }
            catch (Throwable throwable) {
                RuntimeException runtimeException = throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
                throw runtimeException;
            }
        }
    }

    final void dispatchMessage(NEWTEventTask nEWTEventTask) {
        NEWTEvent nEWTEvent = nEWTEventTask.get();
        try {
            if (null == nEWTEvent) {
                System.err.println("Warning: event of eventTask is NULL");
                ExceptionUtils.dumpStack((PrintStream)System.err);
                return;
            }
            this.dispatchMessage(nEWTEvent);
        }
        catch (RuntimeException runtimeException) {
            if (nEWTEventTask.isCallerWaiting()) {
                nEWTEventTask.setException(runtimeException);
            }
            throw runtimeException;
        }
        nEWTEventTask.notifyCaller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchMessages() {
        if (0 == this.refCount || null == this.getGraphicsDevice()) {
            return;
        }
        ArrayList<NEWTEventTask> arrayList = null;
        if (this.haveEvents) {
            Object object = this.eventsLock;
            synchronized (object) {
                if (this.haveEvents) {
                    arrayList = this.events;
                    this.events = new ArrayList();
                    this.haveEvents = false;
                }
                this.eventsLock.notifyAll();
            }
            if (null != arrayList) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.dispatchMessage(arrayList.get(i));
                }
            }
        }
        this.dispatchMessagesNative();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueEvent(boolean bl, NEWTEvent nEWTEvent) {
        EDTUtil eDTUtil = this.edtUtil;
        if (!eDTUtil.isRunning()) {
            if (DEBUG) {
                System.err.println("Warning: EDT already stopped: wait:=" + bl + ", " + nEWTEvent);
                ExceptionUtils.dumpStack((PrintStream)System.err);
            }
            return;
        }
        if (bl && eDTUtil.isCurrentThreadEDTorNEDT()) {
            this.dispatchMessage(nEWTEvent);
            return;
        }
        Object object = new Object();
        NEWTEventTask nEWTEventTask = new NEWTEventTask(nEWTEvent, bl ? object : null);
        Object object2 = object;
        synchronized (object2) {
            Object object3 = this.eventsLock;
            synchronized (object3) {
                this.events.add(nEWTEventTask);
                this.haveEvents = true;
                this.eventsLock.notifyAll();
            }
            if (bl) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                if (null != nEWTEventTask.getException()) {
                    throw nEWTEventTask.getException();
                }
            }
        }
    }

    public static final <T> T runWithLockedDevice(AbstractGraphicsDevice abstractGraphicsDevice, DisplayRunnable<T> displayRunnable) {
        T t;
        abstractGraphicsDevice.lock();
        try {
            t = displayRunnable.run(abstractGraphicsDevice.getHandle());
        }
        finally {
            abstractGraphicsDevice.unlock();
        }
        return t;
    }

    public final <T> T runWithLockedDisplayDevice(DisplayRunnable<T> displayRunnable) {
        AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsDevice();
        if (null == abstractGraphicsDevice) {
            throw new RuntimeException("null device - not initialized: " + this);
        }
        return DisplayImpl.runWithLockedDevice(abstractGraphicsDevice, displayRunnable);
    }

    static {
        NativeWindowFactory.addCustomShutdownHook(true, new Runnable(){

            @Override
            public void run() {
                WindowImpl.shutdownAll();
                ScreenImpl.shutdownAll();
                DisplayImpl.shutdownAll();
            }
        });
        ClassLoader classLoader = DisplayImpl.class.getClassLoader();
        pngUtilAvail = ReflectionUtil.isClassAvailable((String)"com.jogamp.opengl.util.PNGPixelRect", (ClassLoader)classLoader);
    }

    public static interface DisplayRunnable<T> {
        public T run(long var1);
    }
}

