/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.osmand.PlatformUtil;
import net.osmand.osm.io.NetworkUtils;
import net.osmand.shared.data.KQuadRect;
import net.osmand.shared.wiki.WikiHelper;
import net.osmand.shared.wiki.WikiImage;
import net.osmand.shared.wiki.WikiMetadata;
import net.osmand.util.Algorithms;
import org.apache.commons.logging.Log;

public class WikiCoreHelper {
    public static final boolean USE_OSMAND_WIKI_API = true;
    private static final Log LOG = PlatformUtil.getLog(WikiCoreHelper.class);
    private static final String WIKIMEDIA_API_ENDPOINT = "https://commons.wikimedia.org/w/api.php";
    private static final String WIKIDATA_API_ENDPOINT = "https://www.wikidata.org/w/api.php";
    private static final String WIKIDATA_ACTION = "?action=wbgetclaims&property=P18&entity=";
    private static final String WIKIMEDIA_ACTION = "?action=query&list=categorymembers&cmtitle=";
    private static final String CM_LIMIT = "&cmlimit=100";
    private static final String FORMAT_JSON = "&format=json";
    public static final String WIKIMEDIA_FILE = "File:";
    public static final String WIKIMEDIA_CATEGORY = "Category:";
    private static final int THUMB_SIZE = 480;
    private static final int ICON_SIZE = 64;
    public static final String OSMAND_API_ENDPOINT = "https://osmand.net/api/";
    public static final String OSMAND_SEARCH_ENDPOINT = "https://osmand.net/search/";
    private static final String WIKI_PLACE_ACTION = "wiki_place?";
    private static final String GET_WIKI_DATA_ACTION = "get-wiki-data?";
    private static final int DEPT_CAT_LIMIT = 1;
    private static final List<String> IMAGE_EXTENSIONS = new ArrayList<String>(Arrays.asList(".jpeg", ".jpg", ".png", ".gif"));

    public static List<OsmandApiFeatureData> getExploreImageList(KQuadRect mapRect, int zoom, String langs) {
        ArrayList<OsmandApiFeatureData> wikiImages = new ArrayList<OsmandApiFeatureData>();
        StringBuilder url = new StringBuilder();
        String baseApiActionUrl = "https://osmand.net/search/get-wiki-data?";
        String northWest = String.format(Locale.US, "%f,%f", mapRect.getTop(), mapRect.getLeft());
        String southEast = String.format(Locale.US, "%f,%f", mapRect.getBottom(), mapRect.getRight());
        url.append(baseApiActionUrl);
        try {
            url.append(String.format(Locale.US, "northWest=%s", URLEncoder.encode(northWest, "UTF-8")));
            url.append("&");
            url.append(String.format(Locale.US, "southEast=%s", URLEncoder.encode(southEast, "UTF-8")));
            url.append("&");
            url.append(String.format(Locale.US, "zoom=%d", zoom));
            url.append("&");
            url.append(String.format(Locale.US, "lang=%s", langs));
            url.append("&");
            url.append(String.format(Locale.US, "filters=", new Object[0]));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        LOG.debug((Object)("Download images " + String.valueOf(url) + " {" + Thread.currentThread().getName() + "}"));
        WikiCoreHelper.getNearbyImagesOsmAndAPIRequest(url.toString(), wikiImages);
        return wikiImages;
    }

    public static List<WikiImage> getWikiImageList(Map<String, String> tags, NetworkResponseListener listener) {
        WikiHelper.WikiTagData wikiTagData = WikiHelper.INSTANCE.extractWikiTagData(tags);
        String wikidataId = wikiTagData.getWikidataId();
        String wikiCategory = wikiTagData.getWikiCategory();
        String wikiTitle = wikiTagData.getWikiTitle();
        List wikiImages = wikiTagData.getWikiImages();
        Object url = "";
        String baseApiActionUrl = "https://osmand.net/api/wiki_place?";
        try {
            if (!Algorithms.isEmpty(wikidataId)) {
                url = (String)url + baseApiActionUrl + "article=" + URLEncoder.encode(wikidataId, "UTF-8");
            }
            if (!Algorithms.isEmpty(wikiCategory)) {
                url = (String)url + (((String)url).isEmpty() ? baseApiActionUrl : "&") + "category=" + URLEncoder.encode(wikiCategory, "UTF-8");
            }
            if (!Algorithms.isEmpty(wikiTitle)) {
                url = (String)url + (((String)url).isEmpty() ? baseApiActionUrl : "&") + "wiki=" + URLEncoder.encode(wikiTitle, "UTF-8");
            }
            if (!((String)url).isEmpty()) {
                url = (String)url + "&addMetaData=" + URLEncoder.encode("true", "UTF-8");
                WikiCoreHelper.getImagesOsmAndAPIRequestV2((String)url, wikiImages, listener);
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e);
        }
        return wikiImages;
    }

    private static List<WikiImage> getWikimediaImageCategory(String categoryName, List<WikiImage> wikiImages, int depth) {
        String url = "https://commons.wikimedia.org/w/api.php?action=query&list=categorymembers&cmtitle=Category:" + categoryName + "&cmlimit=100&format=json";
        WikimediaResponse response = WikiCoreHelper.sendWikipediaApiRequest(url, WikimediaResponse.class, false);
        if (response != null) {
            ArrayList<String> subCategories = new ArrayList<String>();
            for (Categorymember cm : response.query.categorymembers) {
                String memberTitle = cm.title;
                if (memberTitle == null) continue;
                if (memberTitle.startsWith(WIKIMEDIA_CATEGORY)) {
                    subCategories.add(memberTitle);
                    continue;
                }
                if (!memberTitle.startsWith(WIKIMEDIA_FILE)) continue;
                WikiHelper.INSTANCE.addFile(wikiImages, memberTitle);
            }
            if (depth < 1) {
                for (String subCategory : subCategories) {
                    WikiCoreHelper.getWikimediaImageCategory(subCategory, wikiImages, depth + 1);
                }
            }
        }
        return wikiImages;
    }

    protected static List<WikiImage> getWikidataImageWikidata(String wikidataId, List<WikiImage> wikiImages) {
        String url = "https://www.wikidata.org/w/api.php?action=wbgetclaims&property=P18&entity=" + wikidataId + FORMAT_JSON;
        WikidataResponse response = WikiCoreHelper.sendWikipediaApiRequest(url, WikidataResponse.class, false);
        if (response != null && response.claims != null && response.claims.p18 != null) {
            for (P18 p18 : response.claims.p18) {
                WikiImage wikiImage;
                String imageFileName = p18.mainsnak.datavalue.value;
                if (imageFileName == null || (wikiImage = WikiHelper.INSTANCE.getImageData(imageFileName)) == null) continue;
                wikiImages.add(wikiImage);
            }
        }
        return wikiImages;
    }

    private static OsmandAPIResponseV2 getImagesOsmAndAPIRequestV2(String jsonString) {
        try {
            return (OsmandAPIResponseV2)new Gson().fromJson(jsonString, OsmandAPIResponseV2.class);
        }
        catch (JsonSyntaxException e) {
            LOG.error((Object)e.getLocalizedMessage());
            return null;
        }
    }

    private static List<WikiImage> createWikiImages(OsmandAPIResponseV2 response, List<WikiImage> wikiImages) {
        if (response != null && !Algorithms.isEmpty(response.images)) {
            for (Map<String, String> image : response.images) {
                WikiImage wikiImage = WikiCoreHelper.parseImageDataWithMetaData(image);
                if (wikiImage == null || !WikiCoreHelper.isUrlFileImage(wikiImage)) continue;
                wikiImages.add(wikiImage);
            }
        }
        return wikiImages;
    }

    public static List<WikiImage> getImagesFromJson(String json, List<WikiImage> wikiImages) {
        OsmandAPIResponseV2 response = WikiCoreHelper.getImagesOsmAndAPIRequestV2(json);
        return WikiCoreHelper.createWikiImages(response, wikiImages);
    }

    private static List<WikiImage> getImagesOsmAndAPIRequestV2(String url, List<WikiImage> wikiImages, NetworkResponseListener listener) {
        OsmandAPIResponseV2 response = WikiCoreHelper.sendWikipediaApiRequest(url, OsmandAPIResponseV2.class, listener, false);
        return WikiCoreHelper.createWikiImages(response, wikiImages);
    }

    private static boolean isUrlFileImage(WikiImage wikiImage) {
        String path = wikiImage.getImageHiResUrl();
        int lastIndexOfDot = path.lastIndexOf(46);
        if (lastIndexOfDot != -1) {
            return IMAGE_EXTENSIONS.contains(path.substring(lastIndexOfDot).toLowerCase());
        }
        return false;
    }

    private static void getNearbyImagesOsmAndAPIRequest(String url, List<OsmandApiFeatureData> wikiImages) {
        OsmandAPIFeaturesResponse response = WikiCoreHelper.sendWikipediaApiRequest(url, OsmandAPIFeaturesResponse.class, true);
        if (response != null && !Algorithms.isEmpty(response.features)) {
            wikiImages.addAll(response.features);
        }
    }

    private static List<WikiImage> getImagesOsmAndAPIRequest(String url, List<WikiImage> wikiImages) {
        OsmandAPIResponse response = WikiCoreHelper.sendWikipediaApiRequest(url, OsmandAPIResponse.class, false);
        if (response != null && !Algorithms.isEmpty(response.images)) {
            for (String imageUrl : response.images) {
                WikiImage wikiImage;
                if (imageUrl == null || (wikiImage = WikiCoreHelper.parseImageDataFromFile(imageUrl)) == null) continue;
                wikiImages.add(wikiImage);
            }
        }
        return wikiImages;
    }

    private static WikiImage parseImageDataWithMetaData(Map<String, String> image) {
        WikiImage wikiImage;
        String imageUrl = image.get("image");
        if (!Algorithms.isEmpty(image) && (wikiImage = WikiCoreHelper.parseImageDataFromFile(imageUrl)) != null) {
            WikiMetadata.Metadata metadata = wikiImage.getMetadata();
            String date = image.get("date");
            if (date != null) {
                metadata.setDate(date);
            }
            String author = image.get("author");
            if (date != null) {
                metadata.setAuthor(author);
            }
            String license = image.get("license");
            if (date != null) {
                metadata.setLicense(license);
            }
            long mediaId = Algorithms.parseLongSilently(image.get("mediaId"), -1L);
            wikiImage.setMediaId(mediaId);
            return wikiImage;
        }
        return null;
    }

    private static WikiImage parseImageDataFromFile(String imageUrl) {
        try {
            imageUrl = URLDecoder.decode(imageUrl, "UTF-8");
            String imageHiResUrl = imageUrl.replace(" ", "_");
            String imageFileName = Algorithms.getFileWithoutDirs(imageUrl);
            String imageName = Algorithms.getFileNameWithoutExtension(imageUrl);
            String imageStubUrl = imageHiResUrl + "?width=480";
            String imageIconUrl = imageHiResUrl + "?width=64";
            return new WikiImage(imageFileName, imageName, imageStubUrl, imageHiResUrl, imageIconUrl);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getLocalizedMessage());
            return null;
        }
    }

    private static <T> T sendWikipediaApiRequest(String url, Class<T> responseClass, boolean useGzip) {
        return WikiCoreHelper.sendWikipediaApiRequest(url, responseClass, null, useGzip);
    }

    private static <T> T sendWikipediaApiRequest(String url, Class<T> responseClass, NetworkResponseListener listener, boolean useGzip) {
        StringBuilder rawResponse = new StringBuilder();
        try {
            String errorMessage = NetworkUtils.sendGetRequest(url, null, rawResponse, useGzip);
            if (errorMessage == null) {
                try {
                    String stringResponse = rawResponse.toString();
                    if (listener != null) {
                        listener.onGetRawResponse(stringResponse);
                    }
                    return (T)new Gson().fromJson(stringResponse, responseClass);
                }
                catch (JsonSyntaxException e) {
                    LOG.error((Object)e.getLocalizedMessage());
                }
            } else {
                LOG.error((Object)errorMessage);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage());
        }
        return null;
    }

    public static interface NetworkResponseListener {
        public void onGetRawResponse(String var1);
    }

    public static class WikimediaResponse {
        @SerializedName(value="query")
        @Expose
        private Query query;
    }

    public static class Query {
        @SerializedName(value="categorymembers")
        @Expose
        private List<Categorymember> categorymembers;
    }

    public static class Categorymember {
        @SerializedName(value="title")
        @Expose
        private String title;
    }

    public static class WikidataResponse {
        @SerializedName(value="claims")
        @Expose
        private Claims claims;
    }

    public static class Claims {
        @SerializedName(value="P18")
        @Expose
        private final List<P18> p18 = null;
    }

    public static class P18 {
        @SerializedName(value="mainsnak")
        @Expose
        private Mainsnak mainsnak;
    }

    public static class Mainsnak {
        @SerializedName(value="datavalue")
        @Expose
        private Datavalue datavalue;
        @SerializedName(value="datatype")
        @Expose
        private String datatype;
    }

    public static class Datavalue {
        @SerializedName(value="value")
        @Expose
        private String value;
        @SerializedName(value="type")
        @Expose
        private String type;
    }

    public static class OsmandAPIResponseV2 {
        @SerializedName(value="features-v2")
        @Expose
        private final Set<Map<String, String>> images = null;
    }

    public static class OsmandAPIFeaturesResponse {
        @SerializedName(value="features")
        @Expose
        private final List<OsmandApiFeatureData> features = null;
    }

    public static class OsmandAPIResponse {
        @SerializedName(value="features")
        @Expose
        private final List<String> images = null;
    }

    public static class WikiDataProperties {
        public String id;
        public String photoId;
        public String photoTitle;
        public String wikiTitle;
        public String poitype;
        public String poisubtype;
        public String catId;
        public String catTitle;
        public String depId;
        public String depTitle;
        public String wikiLang;
        public String wikiDesc;
        public String wikiLangs;
        public String wikiLangViews;
        public Long osmid;
        public Double elo;
        public int osmtype;
    }

    public static class WikiDataGeometry {
        @Expose
        public double[] coordinates;
    }

    public static class OsmandApiFeatureData {
        @Expose
        public WikiDataProperties properties;
        @Expose
        public WikiDataGeometry geometry;
    }
}

