/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import net.osmand.PlatformUtil;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.LatLon;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RouteSegmentResult;
import net.osmand.router.RoutingContext;
import net.osmand.router.VehicleRouter;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class BinaryRoutePlanner {
    private static final int REVERSE_WAY_RESTRICTION_ONLY = 1024;
    static final int STANDARD_ROAD_IN_QUEUE_OVERHEAD = 220;
    static final int STANDARD_ROAD_VISITED_OVERHEAD = 150;
    protected static final Log log = PlatformUtil.getLog(BinaryRoutePlanner.class);
    private static final int ROUTE_POINTS = 11;
    static boolean ASSERT_CHECKS = true;
    static boolean TRACE_ROUTING = false;
    static int TEST_ID = 194349150;
    static boolean TEST_SPECIFIC = false;
    public static boolean DEBUG_PRECISE_DIST_MEASUREMENT = false;
    public static boolean DEBUG_BREAK_EACH_SEGMENT = false;

    public static double squareRootDist(int x1, int y1, int x2, int y2) {
        if (DEBUG_PRECISE_DIST_MEASUREMENT) {
            return MapUtils.measuredDist31(x1, y1, x2, y2);
        }
        return MapUtils.squareRootDist31(x1, y1, x2, y2);
    }

    private static float cost(float distanceFromStart, float distanceToEnd, RoutingContext ctx) {
        return ctx.config.heuristicCoefficient * distanceToEnd + distanceFromStart;
    }

    FinalRouteSegment searchRouteInternal(RoutingContext ctx, RouteSegmentPoint start, RouteSegmentPoint end, TLongObjectMap<RouteSegment> boundaries) throws InterruptedException, IOException {
        ctx.memoryOverhead = 1000;
        PriorityQueue<RouteSegmentCost> graphDirectSegments = new PriorityQueue<RouteSegmentCost>(50, new SegmentsComparator());
        PriorityQueue<RouteSegmentCost> graphReverseSegments = new PriorityQueue<RouteSegmentCost>(50, new SegmentsComparator());
        TLongObjectHashMap visitedDirectSegments = new TLongObjectHashMap();
        TLongObjectHashMap visitedOppositeSegments = new TLongObjectHashMap();
        this.initQueuesWithStartEnd(ctx, start, end, graphDirectSegments, graphReverseSegments);
        boolean onlyBackward = ctx.getPlanRoadDirection() < 0;
        boolean onlyForward = ctx.getPlanRoadDirection() > 0;
        boolean forwardSearch = !onlyForward;
        FinalRouteSegment finalSegment = null;
        int n = end == null ? 1 : (ctx.dijkstraMode = start == null ? -1 : 0);
        if (ctx.dijkstraMode == 1) {
            start.others = null;
            forwardSearch = true;
        } else if (ctx.dijkstraMode == -1) {
            end.others = null;
            forwardSearch = false;
        }
        PriorityQueue<RouteSegmentCost> graphSegments = forwardSearch ? graphDirectSegments : graphReverseSegments;
        float[] minCost = new float[]{Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
        while (!graphSegments.isEmpty()) {
            boolean visited;
            RouteSegmentCost cst = graphSegments.poll();
            RouteSegment segment = cst.segment;
            int visitedCnt = (start != null ? visitedDirectSegments.size() : 0) + (end != null ? visitedOppositeSegments.size() : 0);
            ctx.memoryOverhead = visitedCnt * 150 + (graphDirectSegments.size() + graphReverseSegments.size()) * 220;
            if (TRACE_ROUTING) {
                this.printRoad(">", segment, !forwardSearch);
            }
            if (ctx.config.MAX_VISITED > 0 && visitedCnt > ctx.config.MAX_VISITED) {
                if (finalSegment == null) break;
                break;
            }
            boolean skipSegment = false;
            if (segment instanceof FinalRouteSegment) {
                if (RoutingContext.SHOW_GC_SIZE) {
                    log.warn((Object)("Estimated overhead " + ctx.memoryOverhead / 0x100000 + " mb"));
                    this.printMemoryConsumption("Memory occupied after calculation : ");
                }
                if (TRACE_ROUTING) {
                    BinaryRoutePlanner.println(" >>FINAL segment: " + String.valueOf(segment));
                }
                if (ctx.dijkstraMode != 0) {
                    TLongObjectHashMap visitedSegments;
                    if (finalSegment == null) {
                        finalSegment = new MultiFinalRouteSegment((FinalRouteSegment)segment);
                    }
                    ((MultiFinalRouteSegment)finalSegment).all.add((FinalRouteSegment)segment);
                    TLongObjectHashMap tLongObjectHashMap = visitedSegments = forwardSearch ? visitedDirectSegments : visitedOppositeSegments;
                    if (!visitedSegments.containsKey(this.calculateRoutePointId(segment))) {
                        visitedSegments.put(this.calculateRoutePointId(segment), (Object)segment);
                    }
                    skipSegment = true;
                } else {
                    finalSegment = (FinalRouteSegment)segment;
                    break;
                }
            }
            if ((double)ctx.memoryOverhead > (double)ctx.config.memoryLimitation * 0.9 && RoutingContext.SHOW_GC_SIZE) {
                this.printMemoryConsumption("Memory occupied before exception : ");
            }
            if ((double)ctx.memoryOverhead > (double)ctx.config.memoryLimitation * 0.9) {
                throw new IllegalStateException(String.format("There is not enough memory %.5f, %.5f -> %.5f, %.5f - limit  %d  MB", MapUtils.get31LatitudeY(ctx.startY), MapUtils.get31LongitudeX(ctx.startX), MapUtils.get31LatitudeY(ctx.targetY), MapUtils.get31LongitudeX(ctx.targetX), ctx.config.memoryLimitation / 0x100000L));
            }
            if (ctx.calculationProgress != null) {
                ++ctx.calculationProgress.visitedSegments;
            }
            if (visited = (forwardSearch ? visitedDirectSegments : visitedOppositeSegments).containsKey(this.calculateRoutePointId(segment))) {
                if (TRACE_ROUTING) {
                    BinaryRoutePlanner.println("  " + segment.segEnd + ">> Already visited by minimum");
                }
                skipSegment = true;
            } else {
                double d = (double)cst.cost + 5.0;
                int n2 = forwardSearch ? 1 : 0;
                if (d < (double)minCost[n2] && ASSERT_CHECKS && ctx.calculationMode != RoutePlannerFrontEnd.RouteCalculationMode.COMPLEX) {
                    if (ctx.config.heuristicCoefficient <= 1.0f) {
                        throw new IllegalStateException(cst.cost + " < ???  " + minCost[forwardSearch ? 1 : 0]);
                    }
                } else {
                    minCost[forwardSearch ? 1 : 0] = cst.cost;
                }
            }
            if (!skipSegment) {
                if (forwardSearch) {
                    doNotAddIntersections = onlyBackward;
                    this.processRouteSegment(ctx, false, graphDirectSegments, (TLongObjectMap<RouteSegment>)visitedDirectSegments, segment, (TLongObjectMap<RouteSegment>)visitedOppositeSegments, boundaries, doNotAddIntersections);
                } else {
                    doNotAddIntersections = onlyForward;
                    this.processRouteSegment(ctx, true, graphReverseSegments, (TLongObjectMap<RouteSegment>)visitedOppositeSegments, segment, (TLongObjectMap<RouteSegment>)visitedDirectSegments, boundaries, doNotAddIntersections);
                }
            }
            this.updateCalculationProgress(ctx, graphDirectSegments, graphReverseSegments);
            boolean reiterate = false;
            reiterate |= this.checkIfGraphIsEmpty(ctx, ctx.getPlanRoadDirection() <= 0, true, graphReverseSegments, end, (TLongObjectMap<RouteSegment>)visitedOppositeSegments, "Route is not found to selected target point.");
            if (reiterate |= this.checkIfGraphIsEmpty(ctx, ctx.getPlanRoadDirection() >= 0, false, graphDirectSegments, start, (TLongObjectMap<RouteSegment>)visitedDirectSegments, "Route is not found from selected start point.")) {
                minCost = new float[]{Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
            }
            if (ctx.planRouteIn2Directions()) {
                if (visitedDirectSegments.isEmpty() && !graphDirectSegments.isEmpty()) {
                    forwardSearch = true;
                } else if (visitedOppositeSegments.isEmpty() && !graphReverseSegments.isEmpty()) {
                    forwardSearch = false;
                } else {
                    if (graphDirectSegments.isEmpty() || graphReverseSegments.isEmpty()) {
                        PriorityQueue<RouteSegmentCost> priorityQueue = graphSegments = graphDirectSegments.isEmpty() ? graphReverseSegments : graphDirectSegments;
                        if (finalSegment == null) {
                            while (!graphSegments.isEmpty()) {
                                RouteSegmentCost pc = graphSegments.poll();
                                if (!(pc.segment instanceof FinalRouteSegment)) continue;
                                finalSegment = (FinalRouteSegment)pc.segment;
                                break;
                            }
                        }
                        return finalSegment;
                    }
                    RouteSegment fw = graphDirectSegments.peek().segment;
                    RouteSegment bw = graphReverseSegments.peek().segment;
                    forwardSearch = Double.compare(BinaryRoutePlanner.cost(fw.distanceFromStart, fw.distanceToEnd, ctx), BinaryRoutePlanner.cost(bw.distanceFromStart, bw.distanceToEnd, ctx)) <= 0;
                }
            } else {
                forwardSearch = onlyForward;
                if (onlyBackward && !graphDirectSegments.isEmpty()) {
                    forwardSearch = true;
                }
                if (onlyForward && !graphReverseSegments.isEmpty()) {
                    forwardSearch = false;
                }
            }
            graphSegments = forwardSearch ? graphDirectSegments : graphReverseSegments;
            if (ctx.calculationProgress == null || !ctx.calculationProgress.isCancelled) continue;
            throw new InterruptedException("Route calculation interrupted");
        }
        if (ctx.calculationProgress != null) {
            ctx.calculationProgress.visitedDirectSegments += visitedDirectSegments.size();
            ctx.calculationProgress.visitedOppositeSegments += visitedOppositeSegments.size();
            ctx.calculationProgress.directQueueSize += graphDirectSegments.size();
            ctx.calculationProgress.oppositeQueueSize += graphReverseSegments.size();
        }
        return finalSegment;
    }

    protected boolean checkIfGraphIsEmpty(RoutingContext ctx, boolean allowDirection, boolean reverseWaySearch, PriorityQueue<RouteSegmentCost> graphSegments, RouteSegmentPoint pnt, TLongObjectMap<RouteSegment> visited, String msg) {
        if (allowDirection && graphSegments.isEmpty() && pnt.others != null) {
            Iterator<RouteSegmentPoint> pntIterator = pnt.others.iterator();
            while (pntIterator.hasNext()) {
                RouteSegment neg;
                RouteSegmentPoint next = pntIterator.next();
                pntIterator.remove();
                float estimatedDistance = this.estimatedDistance(next, reverseWaySearch, ctx);
                RouteSegment pos = next.initRouteSegment(true);
                if (pos != null && !visited.containsKey(this.calculateRoutePointId(pos)) && this.checkMovementAllowed(ctx, reverseWaySearch, pos)) {
                    pos.setParentRoute(null);
                    pos.distanceFromStart = 0.0f;
                    pos.distanceToEnd = estimatedDistance;
                    graphSegments.add(new RouteSegmentCost(pos, ctx));
                }
                if ((neg = next.initRouteSegment(false)) != null && !visited.containsKey(this.calculateRoutePointId(neg)) && this.checkMovementAllowed(ctx, reverseWaySearch, neg)) {
                    neg.setParentRoute(null);
                    neg.distanceFromStart = 0.0f;
                    neg.distanceToEnd = estimatedDistance;
                    graphSegments.add(new RouteSegmentCost(neg, ctx));
                }
                if (graphSegments.isEmpty()) continue;
                BinaryRoutePlanner.println("Reiterate point with new " + (!reverseWaySearch ? "start " : "destination ") + String.valueOf(next.getRoad()));
                return true;
            }
            if (graphSegments.isEmpty()) {
                throw new IllegalArgumentException(msg);
            }
        }
        return false;
    }

    public RouteSegment initEdgeSegment(RoutingContext ctx, RouteSegmentPoint pnt, boolean originalDir, PriorityQueue<RouteSegmentCost> graphSegments, boolean reverseSearchWay) {
        double plusDir;
        double diff;
        float dist;
        RouteSegment seg;
        if (pnt == null) {
            return null;
        }
        for (seg = ctx.loadRouteSegment(originalDir ? pnt.getStartPointX() : pnt.getEndPointX(), originalDir ? pnt.getStartPointY() : pnt.getEndPointY(), 0L, reverseSearchWay); seg != null && (seg.getRoad().getId() != pnt.getRoad().getId() || seg.getSegmentStart() != (originalDir ? pnt.getSegmentStart() : pnt.getSegmentEnd())); seg = seg.getNext()) {
        }
        if (seg.getSegmentStart() != (originalDir ? pnt.getSegmentStart() : pnt.getSegmentEnd()) || seg.getSegmentEnd() != (originalDir ? pnt.getSegmentEnd() : pnt.getSegmentStart())) {
            seg = seg.initRouteSegment(!seg.isPositive());
        }
        if (originalDir && (seg.getSegmentStart() != pnt.getSegmentStart() || seg.getSegmentEnd() != pnt.getSegmentEnd())) {
            throw new IllegalStateException();
        }
        if (!(originalDir || seg.getSegmentStart() == pnt.getSegmentEnd() && seg.getSegmentEnd() == pnt.getSegmentStart())) {
            throw new IllegalStateException();
        }
        if (!originalDir && ctx.config.initialDirection == null && ctx.config.penaltyForReverseDirection < 0.0) {
            return null;
        }
        seg.setParentRoute(RouteSegment.NULL);
        seg.distanceFromStart = dist = -this.calculatePreciseStartTime(ctx, pnt.preciseX, pnt.preciseY, seg);
        if ((!reverseSearchWay && ctx.config.initialDirection != null || reverseSearchWay && ctx.config.targetDirection != null) && Math.abs(MapUtils.alignAngleDifference((diff = (plusDir = seg.getRoad().directionRoute(seg.getSegmentStart(), seg.isPositive())) - (reverseSearchWay ? ctx.config.targetDirection : ctx.config.initialDirection)) - Math.PI)) <= 1.0471975511965976) {
            seg.distanceFromStart = (float)((double)seg.distanceFromStart + ctx.config.penaltyForReverseDirection);
        }
        if (this.checkMovementAllowed(ctx, reverseSearchWay, seg)) {
            seg.distanceToEnd = this.estimatedDistance(seg, reverseSearchWay, ctx);
            graphSegments.add(new RouteSegmentCost(seg, ctx));
            return seg;
        }
        return null;
    }

    public float calculatePreciseStartTime(RoutingContext ctx, int projX, int projY, RouteSegment seg) {
        double fullTime = this.calcRoutingSegmentTimeOnlyDist(ctx.getRouter(), seg);
        double full = BinaryRoutePlanner.squareRootDist(seg.getStartPointX(), seg.getStartPointY(), seg.getEndPointX(), seg.getEndPointY()) + 0.01;
        double fromStart = BinaryRoutePlanner.squareRootDist(projX, projY, seg.getStartPointX(), seg.getStartPointY());
        float dist = (float)(fromStart / full * fullTime);
        return dist;
    }

    private void initQueuesWithStartEnd(RoutingContext ctx, RouteSegmentPoint start, RouteSegmentPoint end, PriorityQueue<RouteSegmentCost> graphDirectSegments, PriorityQueue<RouteSegmentCost> graphReverseSegments) {
        if (ctx.precalculatedRouteDirection != null) {
            ctx.precalculatedRouteDirection.updatePreciseStartEnd(start != null ? start.preciseX : 0, start != null ? start.preciseY : 0, end != null ? end.preciseX : 0, end != null ? end.preciseY : 0);
        }
        if (start != null) {
            ctx.startX = start.preciseX;
            ctx.startY = start.preciseY;
        }
        if (end != null) {
            ctx.targetX = end.preciseX;
            ctx.targetY = end.preciseY;
        }
        RouteSegment startPos = this.initEdgeSegment(ctx, start, true, graphDirectSegments, false);
        RouteSegment startNeg = this.initEdgeSegment(ctx, start, false, graphDirectSegments, false);
        RouteSegment endPos = this.initEdgeSegment(ctx, end, true, graphReverseSegments, true);
        RouteSegment endNeg = this.initEdgeSegment(ctx, end, false, graphReverseSegments, true);
        if (TRACE_ROUTING) {
            this.printRoad("Initial segment start positive: ", startPos, false);
            this.printRoad("Initial segment start negative: ", startNeg, false);
            this.printRoad("Initial segment end positive: ", endPos, false);
            this.printRoad("Initial segment end negative: ", endNeg, false);
        }
    }

    private void printMemoryConsumption(String string) {
        long h1 = RoutingContext.runGCUsedMemory();
        float mb = 1048576.0f;
        log.warn((Object)(string + (float)h1 / mb));
    }

    private void updateCalculationProgress(RoutingContext ctx, PriorityQueue<RouteSegmentCost> graphDirectSegments, PriorityQueue<RouteSegmentCost> graphReverseSegments) {
        if (ctx.calculationProgress != null) {
            RouteSegment peek;
            ctx.calculationProgress.reverseSegmentQueueSize = graphReverseSegments.size();
            ctx.calculationProgress.directSegmentQueueSize = graphDirectSegments.size();
            if (!graphDirectSegments.isEmpty() && ctx.getPlanRoadDirection() >= 0) {
                peek = graphDirectSegments.peek().segment;
                ctx.calculationProgress.distanceFromBegin = Math.max(peek.distanceFromStart, ctx.calculationProgress.distanceFromBegin);
                ctx.calculationProgress.directDistance = peek.distanceFromStart + peek.distanceToEnd;
            }
            if (!graphReverseSegments.isEmpty() && ctx.getPlanRoadDirection() <= 0) {
                peek = graphReverseSegments.peek().segment;
                ctx.calculationProgress.distanceFromEnd = Math.max(peek.distanceFromStart + peek.distanceToEnd, ctx.calculationProgress.distanceFromEnd);
                ctx.calculationProgress.reverseDistance = peek.distanceFromStart + peek.distanceToEnd;
            }
        }
    }

    private void printRoad(String prefix, RouteSegment segment, Boolean reverseWaySearch) {
        String p = "";
        if (reverseWaySearch != null) {
            String string = p = reverseWaySearch != false ? "B" : "F";
        }
        if (segment == null) {
            BinaryRoutePlanner.println(p + prefix + " Segment=null");
        } else {
            Object pr = segment.parentRoute != null ? " pend=" + segment.parentRoute.segEnd + " parent=" + String.valueOf(segment.parentRoute.road) : "";
            BinaryRoutePlanner.println(p + prefix + String.valueOf(segment.road) + " ind=" + segment.getSegmentStart() + "->" + segment.getSegmentEnd() + " ds=" + segment.distanceFromStart + " es=" + segment.distanceToEnd + (String)pr);
        }
    }

    private float estimatedDistance(RouteSegment seg, boolean rev, RoutingContext ctx) {
        int x = seg.getStartPointX() / 2 + seg.getEndPointX() / 2;
        int y = seg.getStartPointY() / 2 + seg.getEndPointY() / 2;
        double distance = BinaryRoutePlanner.squareRootDist(x, y, rev ? ctx.startX : ctx.targetX, rev ? ctx.startY : ctx.targetY);
        return (float)(distance / (double)ctx.getRouter().getMaxSpeed());
    }

    protected static float h(RoutingContext ctx, int begX, int begY, int endX, int endY) {
        float te;
        if (ctx.dijkstraMode != 0) {
            return 0.0f;
        }
        if (ctx.precalculatedRouteDirection != null && (te = ctx.precalculatedRouteDirection.timeEstimate(begX, begY, endX, endY)) > 0.0f) {
            return te;
        }
        double distToFinalPoint = BinaryRoutePlanner.squareRootDist(begX, begY, endX, endY);
        double result = distToFinalPoint / (double)ctx.getRouter().getMaxSpeed();
        return (float)result;
    }

    private static void println(String logMsg) {
        System.out.println(logMsg);
    }

    private double calculateRouteSegmentTime(RoutingContext ctx, boolean reverseWaySearch, RouteSegment segment) {
        RouteDataObject road = segment.road;
        short segmentInd = reverseWaySearch ? segment.getSegmentStart() : segment.getSegmentEnd();
        short prevSegmentInd = !reverseWaySearch ? segment.getSegmentStart() : segment.getSegmentEnd();
        double distTimeOnRoadToPass = this.calcRoutingSegmentTimeOnlyDist(ctx.getRouter(), segment);
        double obstacle = 0.0;
        if (segment.distanceFromStart >= 0.0f || !reverseWaySearch) {
            obstacle = ctx.getRouter().defineRoutingObstacle(road, segmentInd, prevSegmentInd > segmentInd);
        }
        if (obstacle < 0.0) {
            return -1.0;
        }
        double heightObstacle = ctx.getRouter().defineHeightObstacle(road, segmentInd, prevSegmentInd);
        if (heightObstacle < 0.0) {
            return -1.0;
        }
        return obstacle + heightObstacle + distTimeOnRoadToPass;
    }

    public float calcRoutingSegmentTimeOnlyDist(VehicleRouter router, RouteSegment segment) {
        int prevX = segment.road.getPoint31XTile(segment.getSegmentStart());
        int prevY = segment.road.getPoint31YTile(segment.getSegmentStart());
        int x = segment.road.getPoint31XTile(segment.getSegmentEnd());
        int y = segment.road.getPoint31YTile(segment.getSegmentEnd());
        float priority = router.defineSpeedPriority(segment.road, segment.isPositive());
        float speed = router.defineRoutingSpeed(segment.road, segment.isPositive()) * priority;
        if (speed == 0.0f) {
            speed = router.getDefaultSpeed() * priority;
        }
        if (speed > router.getMaxSpeed()) {
            speed = router.getMaxSpeed();
        }
        float distOnRoadToPass = (float)BinaryRoutePlanner.squareRootDist(prevX, prevY, x, y);
        return distOnRoadToPass / speed;
    }

    private void processRouteSegment(RoutingContext ctx, boolean reverseWaySearch, PriorityQueue<RouteSegmentCost> graphSegments, TLongObjectMap<RouteSegment> visitedSegments, RouteSegment startSegment, TLongObjectMap<RouteSegment> oppositeSegments, TLongObjectMap<RouteSegment> boundaries, boolean doNotAddIntersections) {
        if (ASSERT_CHECKS && !this.checkMovementAllowed(ctx, reverseWaySearch, startSegment)) {
            throw new IllegalStateException();
        }
        RouteDataObject road = startSegment.getRoad();
        if (TEST_SPECIFIC && road.getId() >> 6 == (long)TEST_ID) {
            this.printRoad(" ! " + startSegment.distanceFromStart + " ", startSegment, reverseWaySearch);
        }
        RouteSegment nextCurrentSegment = startSegment;
        RouteSegment currentSegment = null;
        while (nextCurrentSegment != null) {
            currentSegment = nextCurrentSegment;
            nextCurrentSegment = null;
            boolean bothDirVisited = this.checkIfOppositeSegmentWasVisited(ctx, reverseWaySearch, graphSegments, currentSegment, oppositeSegments, boundaries);
            float segmentAndObstaclesTime = (float)this.calculateRouteSegmentTime(ctx, reverseWaySearch, currentSegment);
            if (segmentAndObstaclesTime < 0.0f) break;
            float distFromStartPlusSegmentTime = currentSegment.distanceFromStart + segmentAndObstaclesTime;
            long nextPntId = this.calculateRoutePointId(currentSegment);
            RouteSegment existingSegment = (RouteSegment)visitedSegments.put(nextPntId, (Object)currentSegment);
            if (existingSegment != null) {
                if (distFromStartPlusSegmentTime > existingSegment.distanceFromStart) {
                    visitedSegments.put(nextPntId, (Object)existingSegment);
                    if (!TRACE_ROUTING) break;
                    BinaryRoutePlanner.println("  " + currentSegment.segEnd + ">> Already visited");
                    break;
                }
                if (ctx.config.heuristicCoefficient <= 1.0f) {
                    if (RoutingContext.PRINT_ROUTING_ALERTS) {
                        System.err.println("! ALERT slower segment was visited earlier " + distFromStartPlusSegmentTime + " > " + existingSegment.distanceFromStart + ": " + String.valueOf(currentSegment) + " - " + String.valueOf(existingSegment));
                    } else {
                        ++ctx.alertSlowerSegmentedWasVisitedEarlier;
                    }
                }
            }
            currentSegment.distanceFromStart = distFromStartPlusSegmentTime;
            if (bothDirVisited) {
                if (!TRACE_ROUTING) break;
                BinaryRoutePlanner.println("  " + currentSegment.segEnd + ">> 2 dir visited");
                break;
            }
            nextCurrentSegment = this.processIntersections(ctx, graphSegments, visitedSegments, currentSegment, reverseWaySearch, doNotAddIntersections);
            if (DEBUG_BREAK_EACH_SEGMENT && nextCurrentSegment != null) {
                if (doNotAddIntersections) break;
                graphSegments.add(new RouteSegmentCost(nextCurrentSegment, ctx));
                break;
            }
            if (!doNotAddIntersections) continue;
            break;
        }
        if (ctx.visitor != null) {
            ctx.visitor.visitSegment(startSegment, currentSegment.getSegmentEnd(), true);
        }
    }

    private boolean checkMovementAllowed(RoutingContext ctx, boolean reverseWaySearch, RouteSegment segment) {
        int oneway = ctx.getRouter().isOneWay(segment.getRoad());
        boolean directionAllowed = !reverseWaySearch ? (segment.isPositive() ? oneway >= 0 : oneway <= 0) : (segment.isPositive() ? oneway <= 0 : oneway >= 0);
        return directionAllowed;
    }

    private boolean checkViaRestrictions(RouteSegment from, RouteSegment to) {
        if (from != null && to != null) {
            long fid = to.getRoad().getId();
            for (int i = 0; i < from.getRoad().getRestrictionLength(); ++i) {
                long id = from.getRoad().getRestrictionId(i);
                int tp = from.getRoad().getRestrictionType(i);
                if (fid == id) {
                    if (tp != 2 && tp != 1 && tp != 4 && tp != 3) break;
                    return false;
                }
                if (tp != 7) continue;
                return false;
            }
        }
        return true;
    }

    private RouteSegment getParentDiffId(RouteSegment s) {
        if (s == null) {
            return null;
        }
        while (s.getParentRoute() != null && s.getParentRoute().getRoad().getId() == s.getRoad().getId()) {
            s = s.getParentRoute();
        }
        return s.getParentRoute();
    }

    private boolean checkIfOppositeSegmentWasVisited(RoutingContext ctx, boolean reverseWaySearch, PriorityQueue<RouteSegmentCost> graphSegments, RouteSegment currentSegment, TLongObjectMap<RouteSegment> oppositeSegments, TLongObjectMap<RouteSegment> boundaries) {
        long currPoint = this.calculateRoutePointInternalId(currentSegment.getRoad(), currentSegment.getSegmentEnd(), currentSegment.getSegmentStart());
        if (boundaries != null && ctx.dijkstraMode != 0) {
            oppositeSegments = boundaries;
        }
        if (oppositeSegments.containsKey(currPoint)) {
            RouteSegment from;
            RouteSegment opposite = (RouteSegment)oppositeSegments.get(currPoint);
            RouteSegment curParent = this.getParentDiffId(currentSegment);
            RouteSegment oppParent = this.getParentDiffId(opposite);
            RouteSegment to = reverseWaySearch ? curParent : oppParent;
            RouteSegment routeSegment = from = !reverseWaySearch ? curParent : oppParent;
            if (this.checkViaRestrictions(from, to)) {
                FinalRouteSegment frs = new FinalRouteSegment(currentSegment.getRoad(), currentSegment.getSegmentStart(), currentSegment.getSegmentEnd());
                frs.setParentRoute(currentSegment.getParentRoute());
                frs.reverseWaySearch = reverseWaySearch;
                float oppTime = opposite == null ? 0.0f : opposite.distanceFromStart;
                frs.distanceFromStart = oppTime + currentSegment.distanceFromStart;
                frs.distanceToEnd = 0.0f;
                frs.opposite = opposite;
                if (frs.distanceFromStart < 0.0f) {
                    return true;
                }
                graphSegments.add(new RouteSegmentCost(frs, ctx));
                if (TRACE_ROUTING) {
                    this.printRoad("  " + currentSegment.segEnd + ">> Final segment : ", frs, reverseWaySearch);
                }
                if (ctx.calculationProgress != null) {
                    ++ctx.calculationProgress.finalSegmentsFound;
                }
                return true;
            }
        }
        return boundaries != null && ctx.dijkstraMode == 0 && boundaries.containsKey(currPoint);
    }

    private long calculateRoutePointInternalId(RouteDataObject road, int pntId, int nextPntId) {
        int positive = nextPntId - pntId;
        int pntLen = road.getPointsLength();
        if (pntId < 0 || nextPntId < 0 || pntId >= pntLen || nextPntId >= pntLen || positive != -1 && positive != 1) {
            throw new IllegalStateException("Assert failed");
        }
        return (road.getId() << 11) + (long)(pntId << 1) + (long)(positive > 0 ? 1 : 0);
    }

    private long calculateRoutePointId(RouteSegment segm) {
        return this.calculateRoutePointInternalId(segm.getRoad(), segm.getSegmentStart(), segm.isPositive() ? segm.getSegmentStart() + 1 : segm.getSegmentStart() - 1);
    }

    private boolean proccessRestrictions(RoutingContext ctx, RouteSegment segment, RouteSegment inputNext, boolean reverseWay) {
        if (!ctx.getRouter().restrictionsAware()) {
            return false;
        }
        RouteDataObject road = segment.getRoad();
        RouteSegment parent = this.getParentDiffId(segment);
        if (!(reverseWay || road.getRestrictionLength() != 0 || parent != null && parent.getRoad().getRestrictionLength() != 0)) {
            return false;
        }
        ctx.segmentsToVisitPrescripted.clear();
        ctx.segmentsToVisitNotForbidden.clear();
        this.processRestriction(ctx, inputNext, reverseWay, 0L, road);
        if (parent != null) {
            this.processRestriction(ctx, inputNext, reverseWay, road.id, parent.getRoad());
        }
        return true;
    }

    protected void processRestriction(RoutingContext ctx, RouteSegment inputNext, boolean reverseWay, long viaId, RouteDataObject road) {
        boolean via = viaId != 0L;
        RouteSegment next = inputNext;
        boolean exclusiveRestriction = false;
        while (next != null) {
            int type = -1;
            if (!reverseWay) {
                for (i = 0; i < road.getRestrictionLength(); ++i) {
                    rt = road.getRestrictionType(i);
                    rv = road.getRestrictionVia(i);
                    if (!(road.getRestrictionId(i) != next.road.id || via && rv != viaId)) {
                        type = rt;
                    } else {
                        if (rv != viaId || !via || rt != 7) continue;
                        type = 4;
                    }
                    break;
                }
            } else {
                for (i = 0; i < next.road.getRestrictionLength(); ++i) {
                    rt = next.road.getRestrictionType(i);
                    rv = next.road.getRestrictionVia(i);
                    long restrictedTo = next.road.getRestrictionId(i);
                    if (!(restrictedTo != road.id || via && rv != viaId)) {
                        type = rt;
                        break;
                    }
                    if (rv == viaId && via && rt == 7) {
                        type = 4;
                        break;
                    }
                    if (rt != 5 && rt != 6 && rt != 7) continue;
                    RouteSegment foundNext = inputNext;
                    while (foundNext != null && foundNext.getRoad().id != restrictedTo) {
                        foundNext = foundNext.next;
                    }
                    if (foundNext == null) continue;
                    type = 1024;
                }
            }
            if (!(type == 1024 || type == -1 && exclusiveRestriction)) {
                if (type == 2 || type == 1 || type == 4 || type == 3) {
                    if (via) {
                        ctx.segmentsToVisitPrescripted.remove(next);
                    }
                } else if (type == -1) {
                    ctx.segmentsToVisitNotForbidden.add(next);
                } else if (!via) {
                    if (!reverseWay) {
                        exclusiveRestriction = true;
                        ctx.segmentsToVisitNotForbidden.clear();
                        ctx.segmentsToVisitPrescripted.add(next);
                    } else {
                        ctx.segmentsToVisitNotForbidden.add(next);
                    }
                }
            }
            next = next.next;
        }
        if (!via) {
            ctx.segmentsToVisitPrescripted.addAll(ctx.segmentsToVisitNotForbidden);
        }
    }

    private RouteSegment processIntersections(RoutingContext ctx, PriorityQueue<RouteSegmentCost> graphSegments, TLongObjectMap<RouteSegment> visitedSegments, RouteSegment currentSegment, boolean reverseWaySearch, boolean doNotAddIntersections) {
        boolean hasNext;
        RouteSegment connectedNextSegment;
        float distanceToEnd;
        RouteSegment nextCurrentSegment = null;
        int targetEndX = reverseWaySearch ? ctx.startX : ctx.targetX;
        int targetEndY = reverseWaySearch ? ctx.startY : ctx.targetY;
        int x = currentSegment.getRoad().getPoint31XTile(currentSegment.getSegmentEnd());
        int y = currentSegment.getRoad().getPoint31YTile(currentSegment.getSegmentEnd());
        currentSegment.distanceToEnd = distanceToEnd = BinaryRoutePlanner.h(ctx, x, y, targetEndX, targetEndY);
        boolean directionAllowed = true;
        boolean singleRoad = true;
        for (RouteSegment roadIter = connectedNextSegment = ctx.loadRouteSegment(x, y, ctx.config.memoryLimitation - (long)ctx.memoryOverhead, reverseWaySearch); roadIter != null; roadIter = roadIter.getNext()) {
            if (currentSegment.getSegmentEnd() == roadIter.getSegmentStart() && roadIter.road.getId() == currentSegment.getRoad().getId()) {
                nextCurrentSegment = roadIter.initRouteSegment(currentSegment.isPositive());
                if (nextCurrentSegment == null) {
                    directionAllowed = false;
                    continue;
                }
                if (nextCurrentSegment.isSegmentAttachedToStart()) {
                    directionAllowed = this.processOneRoadIntersection(ctx, reverseWaySearch, null, visitedSegments, currentSegment, nextCurrentSegment);
                    if (directionAllowed) continue;
                    nextCurrentSegment = null;
                    continue;
                }
                nextCurrentSegment.setParentRoute(currentSegment);
                nextCurrentSegment.distanceFromStart = currentSegment.distanceFromStart;
                nextCurrentSegment.distanceToEnd = distanceToEnd;
                int nx = nextCurrentSegment.getRoad().getPoint31XTile(nextCurrentSegment.getSegmentEnd());
                int ny = nextCurrentSegment.getRoad().getPoint31YTile(nextCurrentSegment.getSegmentEnd());
                if (nx != x || ny != y) continue;
                return nextCurrentSegment;
            }
            singleRoad = false;
        }
        if (singleRoad) {
            return nextCurrentSegment;
        }
        Iterator<RouteSegment> nextIterator = null;
        boolean thereAreRestrictions = this.proccessRestrictions(ctx, currentSegment, connectedNextSegment, reverseWaySearch);
        if (thereAreRestrictions) {
            nextIterator = ctx.segmentsToVisitPrescripted.iterator();
            if (TRACE_ROUTING) {
                BinaryRoutePlanner.println("  " + currentSegment.segEnd + ">> There are restrictions ");
            }
        }
        RouteSegment next = connectedNextSegment;
        boolean bl = nextIterator != null ? nextIterator.hasNext() : (hasNext = next != null);
        while (hasNext) {
            if (nextIterator != null) {
                next = nextIterator.next();
            }
            if (!(next.getSegmentStart() == currentSegment.getSegmentEnd() && next.getRoad().getId() == currentSegment.getRoad().getId() || doNotAddIntersections)) {
                RouteSegment nextPos = next.initRouteSegment(true);
                this.processOneRoadIntersection(ctx, reverseWaySearch, graphSegments, visitedSegments, currentSegment, nextPos);
                RouteSegment nextNeg = next.initRouteSegment(false);
                this.processOneRoadIntersection(ctx, reverseWaySearch, graphSegments, visitedSegments, currentSegment, nextNeg);
            }
            if (nextIterator == null) {
                next = next.next;
                hasNext = next != null;
                continue;
            }
            hasNext = nextIterator.hasNext();
        }
        if (nextCurrentSegment == null && directionAllowed) {
            if (ctx.calculationMode != RoutePlannerFrontEnd.RouteCalculationMode.BASE) {
                if (ASSERT_CHECKS) {
                    throw new IllegalStateException();
                }
            } else {
                int newEnd = currentSegment.getSegmentEnd() + (currentSegment.isPositive() ? 1 : -1);
                if (newEnd >= 0 && newEnd < currentSegment.getRoad().getPointsLength() - 1) {
                    nextCurrentSegment = new RouteSegment(currentSegment.getRoad(), currentSegment.getSegmentEnd(), newEnd);
                    nextCurrentSegment.setParentRoute(currentSegment);
                    nextCurrentSegment.distanceFromStart = currentSegment.distanceFromStart;
                    nextCurrentSegment.distanceToEnd = distanceToEnd;
                }
            }
        }
        return nextCurrentSegment;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processOneRoadIntersection(RoutingContext ctx, boolean reverseWaySearch, PriorityQueue<RouteSegmentCost> graphSegments, TLongObjectMap<RouteSegment> visitedSegments, RouteSegment segment, RouteSegment next) {
        RouteSegment visIt;
        if (next == null) return false;
        if (!this.checkMovementAllowed(ctx, reverseWaySearch, next)) {
            return false;
        }
        float obstaclesTime = 0.0f;
        if (next.road.getId() != segment.road.getId()) {
            obstaclesTime = (float)ctx.getRouter().calculateTurnTime(next, segment);
        }
        if (obstaclesTime < 0.0f) {
            return false;
        }
        float distFromStart = obstaclesTime + segment.distanceFromStart;
        if (TEST_SPECIFIC && next.road.getId() >> 6 == (long)TEST_ID) {
            this.printRoad(" !? distFromStart=" + distFromStart + " from " + segment.getRoad().getId() + " distToEnd=" + segment.distanceFromStart + " segmentPoint=" + segment.getSegmentEnd() + " -- ", next, null);
        }
        if ((visIt = (RouteSegment)visitedSegments.get(this.calculateRoutePointId(next))) != null) {
            if (TRACE_ROUTING) {
                this.printRoad("  " + segment.segEnd + ">?", (RouteSegment)visitedSegments.get(this.calculateRoutePointId(next)), null);
            }
            if (!(distFromStart < visIt.distanceFromStart)) return false;
            double routeSegmentTime = this.calculateRouteSegmentTime(ctx, reverseWaySearch, visIt);
            if (!((double)visIt.distanceFromStart - ((double)distFromStart + routeSegmentTime) > 0.01)) return false;
            if (ctx.config.heuristicCoefficient <= 1.0f) {
                if (DEBUG_BREAK_EACH_SEGMENT && ASSERT_CHECKS) {
                    throw new IllegalStateException();
                }
                if (RoutingContext.PRINT_ROUTING_ALERTS) {
                    System.err.println("! ALERT new faster path to a visited segment: " + ((double)distFromStart + routeSegmentTime) + " < " + visIt.distanceFromStart + ": " + String.valueOf(next) + " - " + String.valueOf(visIt));
                } else {
                    ++ctx.alertFasterRoadToVisitedSegments;
                }
            }
            visitedSegments.remove(this.calculateRoutePointId(next));
        }
        if (next.isSegmentAttachedToStart() && !(BinaryRoutePlanner.cost(next.distanceFromStart, next.distanceToEnd, ctx) > BinaryRoutePlanner.cost(distFromStart, segment.distanceToEnd, ctx))) return false;
        next.distanceFromStart = distFromStart;
        next.distanceToEnd = segment.distanceToEnd;
        if (TRACE_ROUTING) {
            this.printRoad(" " + (next.isSegmentAttachedToStart() ? "*" : "") + segment.getSegmentEnd() + ">>", next, null);
        }
        next.setParentRoute(segment);
        if (graphSegments == null) return true;
        graphSegments.add(new RouteSegmentCost(next, ctx));
        return true;
    }

    private static class SegmentsComparator
    implements Comparator<RouteSegmentCost> {
        private SegmentsComparator() {
        }

        @Override
        public int compare(RouteSegmentCost o1, RouteSegmentCost o2) {
            return Double.compare(o1.cost, o2.cost);
        }
    }

    public static class RouteSegmentPoint
    extends RouteSegment {
        public double distToProj;
        public int preciseX;
        public int preciseY;
        public List<RouteSegmentPoint> others;

        public RouteSegmentPoint(RouteDataObject road, int segmentStart, double distToProj) {
            super(road, segmentStart);
            this.distToProj = distToProj;
            this.preciseX = road.getPoint31XTile(segmentStart, segmentStart + 1);
            this.preciseY = road.getPoint31YTile(segmentStart, segmentStart + 1);
        }

        public RouteSegmentPoint(RouteDataObject road, int segmentStart, int segmentEnd, double distToProjSquare) {
            super(road, segmentStart, segmentEnd);
            this.distToProj = distToProjSquare;
            this.preciseX = road.getPoint31XTile(segmentStart, segmentEnd);
            this.preciseY = road.getPoint31YTile(segmentStart, segmentEnd);
        }

        public RouteSegmentPoint(RouteSegmentPoint pnt) {
            super(pnt.road, pnt.segStart, pnt.segEnd);
            this.distToProj = pnt.distToProj;
            this.preciseX = pnt.preciseX;
            this.preciseY = pnt.preciseY;
        }

        public LatLon getPreciseLatLon() {
            return new LatLon(MapUtils.get31LatitudeY(this.preciseY), MapUtils.get31LongitudeX(this.preciseX));
        }

        @Override
        public String toString() {
            return String.format("%d (%s): %s", this.segStart, this.getPreciseLatLon(), this.road);
        }
    }

    private static class RouteSegmentCost {
        float cost;
        RouteSegment segment;

        public RouteSegmentCost(RouteSegment segment, RoutingContext ctx) {
            this.cost = BinaryRoutePlanner.cost(segment.distanceFromStart, segment.distanceToEnd, ctx);
            this.segment = segment;
        }

        public String toString() {
            return String.format("%.2f %s", Float.valueOf(this.cost), this.segment);
        }
    }

    public static class RouteSegment {
        public static final RouteSegment NULL = new RouteSegment(null, 0, 1);
        final short segStart;
        final short segEnd;
        final RouteDataObject road;
        RouteSegment nextLoaded = null;
        RouteSegment next = null;
        RouteSegment oppositeDirection = null;
        RouteSegment reverseSearch = null;
        RouteSegment parentRoute = null;
        float distanceFromStart = 0.0f;
        float distanceToEnd = 0.0f;

        public RouteSegment(RouteDataObject road, int segmentStart, int segmentEnd) {
            this.road = road;
            this.segStart = (short)segmentStart;
            this.segEnd = (short)segmentEnd;
        }

        public RouteSegment(RouteDataObject road, int segmentStart) {
            this(road, segmentStart, segmentStart < road.getPointsLength() - 1 ? segmentStart + 1 : segmentStart - 1);
        }

        public RouteSegment initRouteSegment(boolean positiveDirection) {
            if (this.segStart == 0 && !positiveDirection) {
                return null;
            }
            if (this.segStart == this.road.getPointsLength() - 1 && positiveDirection) {
                return null;
            }
            if (this.segStart == this.segEnd) {
                throw new IllegalArgumentException();
            }
            if (positiveDirection == this.segEnd > this.segStart) {
                return this;
            }
            if (this.oppositeDirection == null) {
                this.oppositeDirection = new RouteSegment(this.road, this.segStart, this.segEnd > this.segStart ? this.segStart - 1 : this.segStart + 1);
                this.oppositeDirection.oppositeDirection = this;
            }
            return this.oppositeDirection;
        }

        public boolean isSegmentAttachedToStart() {
            return this.parentRoute != null;
        }

        public RouteSegment getParentRoute() {
            return this.parentRoute == NULL ? null : this.parentRoute;
        }

        public boolean isPositive() {
            return this.segEnd > this.segStart;
        }

        public void setParentRoute(RouteSegment parentRoute) {
            this.parentRoute = parentRoute;
        }

        public RouteSegment getNext() {
            return this.next;
        }

        public short getSegmentStart() {
            return this.segStart;
        }

        public int getStartPointX() {
            return this.road.getPoint31XTile(this.segStart);
        }

        public int getStartPointY() {
            return this.road.getPoint31YTile(this.segStart);
        }

        public int getEndPointY() {
            return this.road.getPoint31YTile(this.segEnd);
        }

        public int getEndPointX() {
            return this.road.getPoint31XTile(this.segEnd);
        }

        public short getSegmentEnd() {
            return this.segEnd;
        }

        public float getDistanceFromStart() {
            return this.distanceFromStart;
        }

        public void setDistanceFromStart(float distanceFromStart) {
            this.distanceFromStart = distanceFromStart;
        }

        public int getDepth() {
            if (this.parentRoute == null) {
                return 0;
            }
            return this.parentRoute.getDepth() + 1;
        }

        public RouteDataObject getRoad() {
            return this.road;
        }

        public String getTestName() {
            return MessageFormat.format("s{0,number,#.##} e{1,number,#.##}", Float.valueOf(this.distanceFromStart), Float.valueOf(this.distanceToEnd));
        }

        public String toString() {
            Object dst = "";
            if (this.road != null) {
                int x = this.road.getPoint31XTile(this.segStart);
                int y = this.road.getPoint31YTile(this.segStart);
                int xe = this.road.getPoint31XTile(this.segEnd);
                int ye = this.road.getPoint31YTile(this.segEnd);
                dst = (float)((int)(MapUtils.squareRootDist31(x, y, xe, ye) * 10.0)) / 10.0f + " m";
            }
            if (this.distanceFromStart != 0.0f) {
                dst = String.format("dstStart=%.2f", Float.valueOf(this.distanceFromStart));
            }
            return (this.road == null ? "NULL" : this.road.toString()) + " [" + this.segStart + "-" + this.segEnd + "] " + (String)dst;
        }

        public Iterator<RouteSegment> getIterator() {
            return new Iterator<RouteSegment>(){
                RouteSegment next;
                {
                    this.next = this;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public RouteSegment next() {
                    RouteSegment c = this.next;
                    if (this.next != null) {
                        this.next = this.next.next;
                    }
                    return c;
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }
            };
        }
    }

    static class FinalRouteSegment
    extends RouteSegment {
        boolean reverseWaySearch;
        RouteSegment opposite;

        public FinalRouteSegment(RouteDataObject road, int segmentStart, int segmentEnd) {
            super(road, segmentStart, segmentEnd);
        }
    }

    static class MultiFinalRouteSegment
    extends FinalRouteSegment {
        List<FinalRouteSegment> all = new ArrayList<FinalRouteSegment>();

        public MultiFinalRouteSegment(FinalRouteSegment f) {
            super(f.getRoad(), f.getSegmentStart(), f.getSegmentEnd());
            this.distanceFromStart = f.distanceFromStart;
            this.distanceToEnd = f.distanceToEnd;
        }
    }

    public static interface RouteSegmentVisitor {
        public void visitSegment(RouteSegment var1, int var2, boolean var3);

        public void visitApproximatedSegments(List<RouteSegmentResult> var1, RoutePlannerFrontEnd.GpxPoint var2, RoutePlannerFrontEnd.GpxPoint var3);
    }
}

