/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.util.Algorithms;

public class WorldRegion
implements Serializable {
    public static final String WORLD_BASEMAP = "world_basemap";
    public static final String WORLD_BASEMAP_MINI = "world_basemap_mini";
    public static final String ANTARCTICA_REGION_ID = "antarctica";
    public static final String AFRICA_REGION_ID = "africa";
    public static final String ASIA_REGION_ID = "asia";
    public static final String AUSTRALIA_AND_OCEANIA_REGION_ID = "australia-oceania-all";
    public static final String CENTRAL_AMERICA_REGION_ID = "centralamerica";
    public static final String EUROPE_REGION_ID = "europe";
    public static final String NORTH_AMERICA_REGION_ID = "northamerica";
    public static final String RUSSIA_REGION_ID = "russia";
    public static final String JAPAN_REGION_ID = "japan_asia";
    public static final String GERMANY_REGION_ID = "europe_germany";
    public static final String FRANCE_REGION_ID = "europe_france";
    public static final String SOUTH_AMERICA_REGION_ID = "southamerica";
    public static final String WORLD = "world";
    public static final String UNITED_KINGDOM_REGION_ID = "europe_gb";
    protected WorldRegion superregion;
    protected List<WorldRegion> subregions;
    protected RegionParams params = new RegionParams();
    protected String regionFullName;
    protected String regionParentFullName;
    protected String regionName;
    protected String regionNameEn;
    protected String regionNameLocale;
    protected String regionSearchText;
    protected String regionDownloadName;
    protected boolean regionMapDownload;
    protected boolean regionRoadsDownload;
    protected LatLon regionCenter;
    protected QuadRect boundingBox;
    protected List<LatLon> polygon;
    protected List<List<LatLon>> additionalPolygons = new ArrayList<List<LatLon>>();

    public boolean isRegionMapDownload() {
        return this.regionMapDownload;
    }

    public boolean isRegionRoadsDownload() {
        return this.regionRoadsDownload;
    }

    public String getLocaleName() {
        if (!Algorithms.isEmpty(this.regionNameLocale)) {
            return this.regionNameLocale;
        }
        if (!Algorithms.isEmpty(this.regionNameEn)) {
            return this.regionNameEn;
        }
        if (!Algorithms.isEmpty(this.regionName)) {
            return this.regionName;
        }
        return this.capitalize(this.regionFullName.replace('_', ' '));
    }

    public String getRegionDownloadName() {
        return this.regionDownloadName;
    }

    public String getRegionDownloadNameLC() {
        return this.regionDownloadName == null ? null : this.regionDownloadName.toLowerCase();
    }

    public RegionParams getParams() {
        return this.params;
    }

    public LatLon getRegionCenter() {
        return this.regionCenter;
    }

    public String getRegionSearchText() {
        return this.regionSearchText;
    }

    public WorldRegion getSuperregion() {
        return this.superregion;
    }

    public List<WorldRegion> getSuperRegions() {
        return this.getSuperRegions(null);
    }

    public List<WorldRegion> getSuperRegions(WorldRegion baseRegion) {
        ArrayList<WorldRegion> regions = new ArrayList<WorldRegion>();
        this.collectSuperRegions(regions, this.superregion, baseRegion);
        return regions;
    }

    private void collectSuperRegions(List<WorldRegion> regions, WorldRegion region, WorldRegion baseRegion) {
        if (!(region == null || baseRegion != null && Objects.equals(region, baseRegion))) {
            regions.add(region);
            this.collectSuperRegions(regions, region.getSuperregion(), baseRegion);
        }
    }

    public List<WorldRegion> getSubregions() {
        return this.subregions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorldRegion that = (WorldRegion)o;
        return !(this.regionFullName == null ? that.regionFullName != null : !this.regionFullName.equalsIgnoreCase(that.regionFullName));
    }

    public int hashCode() {
        return this.regionFullName != null ? this.regionFullName.hashCode() : 0;
    }

    public WorldRegion(String regionFullName, String downloadName) {
        this.regionFullName = regionFullName;
        this.regionDownloadName = downloadName;
        this.superregion = null;
        this.subregions = new LinkedList<WorldRegion>();
    }

    public WorldRegion(String id) {
        this(id, null);
    }

    public String getRegionId() {
        return this.regionFullName;
    }

    private String capitalize(String s) {
        String[] words = s.split(" ");
        if (words[0].length() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(Algorithms.capitalizeFirstLetterAndLowercase(words[0]));
            for (int i = 1; i < words.length; ++i) {
                sb.append(" ");
                sb.append(Algorithms.capitalizeFirstLetterAndLowercase(words[i]));
            }
            return sb.toString();
        }
        return s;
    }

    public void addSubregion(WorldRegion rd) {
        this.subregions.add(rd);
        rd.superregion = this;
    }

    public int getLevel() {
        int res = 0;
        WorldRegion parent = this.superregion;
        while (parent != null) {
            parent = parent.superregion;
            ++res;
        }
        return res;
    }

    public boolean containsRegion(WorldRegion another) {
        if (!this.containsBoundingBox(another.boundingBox)) {
            return false;
        }
        if (!this.containsPolygon(another.polygon)) {
            return false;
        }
        boolean isInnerPoint = another.containsPoint(another.regionCenter);
        if (isInnerPoint) {
            return this.containsPoint(another.regionCenter);
        }
        return true;
    }

    public boolean containsBoundingBox(QuadRect rectangle) {
        return this.boundingBox != null && rectangle != null && this.boundingBox.contains(rectangle);
    }

    private boolean containsPolygon(List<LatLon> another) {
        return this.polygon != null && another != null && Algorithms.isFirstPolygonInsideSecond(another, this.polygon);
    }

    public boolean containsPoint(LatLon latLon) {
        return this.polygon != null && Algorithms.isPointInsidePolygon(latLon, this.polygon);
    }

    public boolean isContinent() {
        if (this.superregion != null) {
            String superRegionId = this.superregion.getRegionId();
            String thisRegionId = this.getRegionId();
            return WORLD.equals(superRegionId) && !RUSSIA_REGION_ID.equals(thisRegionId);
        }
        return false;
    }

    public static List<WorldRegion> removeDuplicates(List<WorldRegion> regions) {
        ArrayList<WorldRegion> copy = new ArrayList<WorldRegion>(regions);
        HashSet<WorldRegion> duplicates = new HashSet<WorldRegion>();
        for (int i = 0; i < copy.size() - 1; ++i) {
            WorldRegion r1 = (WorldRegion)copy.get(i);
            for (int j = i + 1; j < copy.size(); ++j) {
                WorldRegion r2 = (WorldRegion)copy.get(j);
                if (r1.containsRegion(r2)) {
                    duplicates.add(r2);
                    continue;
                }
                if (!r2.containsRegion(r1)) continue;
                duplicates.add(r1);
            }
        }
        copy.removeAll(duplicates);
        return copy;
    }

    public String getObfFileName() {
        return WorldRegion.getObfFileName(this.regionDownloadName);
    }

    public String getRoadObfFileName() {
        return WorldRegion.getRoadObfFileName(this.regionDownloadName);
    }

    public static String getObfFileName(String regionDownloadName) {
        return Algorithms.capitalizeFirstLetterAndLowercase(regionDownloadName) + ".obf";
    }

    public static String getRoadObfFileName(String regionDownloadName) {
        return Algorithms.capitalizeFirstLetterAndLowercase(regionDownloadName) + ".road.obf";
    }

    public static String getRegionDownloadName(String obfFileName) {
        String obfExt = ".obf";
        String roadObfExt = ".road.obf";
        if (obfFileName.endsWith(roadObfExt)) {
            return obfFileName.toLowerCase().substring(0, obfFileName.length() - roadObfExt.length());
        }
        if (obfFileName.endsWith(obfExt)) {
            return obfFileName.toLowerCase().substring(0, obfFileName.length() - obfExt.length());
        }
        return obfFileName.toLowerCase();
    }

    public QuadRect getBoundingBox() {
        return this.boundingBox;
    }

    public List<List<LatLon>> getPolygons() {
        ArrayList<List<LatLon>> polygons = new ArrayList<List<LatLon>>();
        if (this.polygon != null) {
            polygons.add(this.polygon);
        }
        polygons.addAll(this.additionalPolygons);
        return polygons;
    }

    public List<QuadRect> getAllPolygonsBounds() {
        ArrayList<QuadRect> allBounds = new ArrayList<QuadRect>();
        for (List<LatLon> polygon : this.getPolygons()) {
            QuadRect bounds = new QuadRect();
            for (LatLon ll : polygon) {
                double x = ll.getLongitude();
                double y = ll.getLatitude();
                bounds.expand(x, y, x, y);
            }
            allBounds.add(bounds);
        }
        return allBounds;
    }

    public String toString() {
        return this.getRegionId();
    }

    public static class RegionParams {
        protected String regionLeftHandDriving;
        protected String regionLang;
        protected String regionMetric;
        protected String regionRoadSigns;
        protected String wikiLink;
        protected String population;

        public String getRegionLeftHandDriving() {
            return this.regionLeftHandDriving;
        }

        public String getRegionLang() {
            return this.regionLang;
        }

        public String getRegionMetric() {
            return this.regionMetric;
        }

        public String getRegionRoadSigns() {
            return this.regionRoadSigns;
        }

        public String getWikiLink() {
            return this.wikiLink;
        }

        public String getPopulation() {
            return this.population;
        }
    }
}

