/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.obd;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.datetime.Clock;
import net.osmand.shared.extensions.StringExtensionsKt;
import net.osmand.shared.obd.OBDCommand;
import net.osmand.shared.obd.OBDConnector;
import net.osmand.shared.obd.OBDDataComputer;
import net.osmand.shared.obd.OBDDataField;
import net.osmand.shared.obd.OBDDispatcher;
import net.osmand.shared.obd.OBDResponse;
import net.osmand.shared.obd.Obd2Connection;
import net.osmand.shared.obd.UnderlyingTransport;
import net.osmand.shared.util.KCollectionUtils;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import okio.Buffer;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00019B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u001dH\u0082@\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&H\u0002J\u001e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\n2\u0006\u0010%\u001a\u00020&H\u0082@\u00a2\u0006\u0002\u0010*J\u000e\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\nJ\u0006\u0010-\u001a\u00020\u001dJ\u000e\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\nJ\u0010\u00100\u001a\u00020\u001d2\b\u00101\u001a\u0004\u0018\u00010\u0012J\b\u00102\u001a\u00020\u001dH\u0002J\u0006\u00103\u001a\u00020\u001dJ7\u00104\u001a.\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00150\u0014j\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0015`5\u00a2\u0006\u0002\u00106J\u0010\u0010\u000f\u001a\u00020\u001d2\u0006\u00107\u001a\u000208H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lnet/osmand/shared/obd/OBDDispatcher;", "", "debug", "", "<init>", "(Z)V", "getDebug", "()Z", "commandQueue", "", "Lnet/osmand/shared/obd/OBDCommand;", "inputStream", "Lokio/Source;", "outputStream", "Lokio/Sink;", "log", "Lnet/osmand/shared/util/Logger;", "readStatusListener", "Lnet/osmand/shared/obd/OBDDispatcher$OBDReadStatusListener;", "sensorDataCache", "Ljava/util/HashMap;", "Lnet/osmand/shared/obd/OBDDataField;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "initOBDTimeout", "", "initOBDRetryOffset", "", "connect", "", "connector", "Lnet/osmand/shared/obd/OBDConnector;", "startReadObdLooper", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createTransport", "Lnet/osmand/shared/obd/UnderlyingTransport;", "isConnected", "connection", "Lnet/osmand/shared/obd/Obd2Connection;", "handleCommand", "Lnet/osmand/shared/obd/OBDResponse;", "command", "(Lnet/osmand/shared/obd/OBDCommand;Lnet/osmand/shared/obd/Obd2Connection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addCommand", "commandToRead", "clearCommands", "removeCommand", "commandToStopReading", "setReadStatusListener", "listener", "cleanupResources", "stopReading", "getRawData", "Lkotlin/collections/HashMap;", "()Ljava/util/HashMap;", "msg", "", "OBDReadStatusListener", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nOBDDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OBDDispatcher.kt\nnet/osmand/shared/obd/OBDDispatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1863#2,2:199\n*S KotlinDebug\n*F\n+ 1 OBDDispatcher.kt\nnet/osmand/shared/obd/OBDDispatcher\n*L\n88#1:199,2\n*E\n"})
public final class OBDDispatcher {
    private final boolean debug;
    @NotNull
    private List<? extends OBDCommand> commandQueue;
    @Nullable
    private Source inputStream;
    @Nullable
    private Sink outputStream;
    @NotNull
    private final Logger log;
    @Nullable
    private OBDReadStatusListener readStatusListener;
    @NotNull
    private HashMap<OBDCommand, OBDDataField<Object>> sensorDataCache;
    @NotNull
    private final CoroutineScope scope;
    private final int initOBDTimeout;
    private final long initOBDRetryOffset;

    public OBDDispatcher(boolean debug) {
        this.debug = debug;
        this.commandQueue = CollectionsKt.emptyList();
        this.log = LoggerFactory.INSTANCE.getLogger("OBDDispatcher");
        this.sensorDataCache = new HashMap();
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.initOBDTimeout = 30000;
        this.initOBDRetryOffset = 2000L;
    }

    public /* synthetic */ OBDDispatcher(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final void connect(@NotNull OBDConnector connector) {
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(connector, this, null){
            int label;
            final /* synthetic */ OBDConnector $connector;
            final /* synthetic */ OBDDispatcher this$0;
            {
                this.$connector = $connector;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Pair<Source, Sink> connectionResult = this.$connector.connect();
                        if (connectionResult == null) {
                            this.$connector.onConnectionFailed();
                            return Unit.INSTANCE;
                        }
                        this.$connector.onConnectionSuccess();
                        OBDDispatcher.access$setInputStream$p(this.this$0, (Source)connectionResult.getFirst());
                        OBDDispatcher.access$setOutputStream$p(this.this$0, (Sink)connectionResult.getSecond());
                        this.label = 1;
                        Object object3 = OBDDispatcher.access$startReadObdLooper(this.this$0, (Continuation)this);
                        Object object4 = object3;
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object4;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object4 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (CancellationException connectionResult) {
                            OBDDispatcher.access$log(this.this$0, "OBD reading canceled");
                            return Unit.INSTANCE;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            catch (Exception e) {
                                OBDDispatcher.access$getLog$p(this.this$0).error("Unexpected error in connect: " + e.getMessage(), e);
                                OBDReadStatusListener oBDReadStatusListener = OBDDispatcher.access$getReadStatusListener$p(this.this$0);
                                if (oBDReadStatusListener != null) {
                                    oBDReadStatusListener.onIOError();
                                }
                                this.$connector.onConnectionFailed();
                                return Unit.INSTANCE;
                            }
                        }
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                finally {
                    this.$connector.disconnect();
                    OBDDispatcher.access$cleanupResources(this.this$0);
                }
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object startReadObdLooper(Continuation<? super Unit> $completion) {
        block19: {
            if (!($completion instanceof startReadObdLooper.1)) ** GOTO lbl-1000
            var13_2 = $completion;
            if ((var13_2.label & -2147483648) != 0) {
                var13_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    long J$0;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ OBDDispatcher this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return OBDDispatcher.access$startReadObdLooper(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var14_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    this.log("Start reading obd with " + this.inputStream + " and " + this.outputStream);
                    connection = new Obd2Connection(this.createTransport(), this);
                    startInitTime = Clock.System.INSTANCE.now().toEpochMilliseconds();
                    ** GOTO lbl39
                }
                case 1: {
                    startInitTime = $continuation.J$0;
                    connection = (Obd2Connection)$continuation.L$1;
                    this = (OBDDispatcher)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    while (!((Boolean)v0).booleanValue() && JobKt.isActive((CoroutineContext)$continuation.getContext())) {
                        $continuation.L$0 = this;
                        $continuation.L$1 = connection;
                        $continuation.J$0 = startInitTime;
                        $continuation.label = 2;
                        v1 = DelayKt.delay((long)this.initOBDRetryOffset, (Continuation)$continuation);
                        if (v1 == var14_4) {
                            return var14_4;
                        }
                        ** GOTO lbl38
                    }
                    ** GOTO lbl46
                }
                case 2: {
                    startInitTime = $continuation.J$0;
                    connection = (Obd2Connection)$continuation.L$1;
                    this = (OBDDispatcher)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl38:
                    // 2 sources

                    if (Clock.System.INSTANCE.now().toEpochMilliseconds() - startInitTime > (long)this.initOBDTimeout) ** GOTO lbl46
lbl39:
                    // 2 sources

                    $continuation.L$0 = this;
                    $continuation.L$1 = connection;
                    $continuation.J$0 = startInitTime;
                    $continuation.label = 1;
                    v0 = connection.initialize((Continuation<? super Boolean>)$continuation);
                    if (v0 != var14_4) ** GOTO lbl22
                    return var14_4;
lbl46:
                    // 2 sources

                    if (!connection.isInitialized()) {
                        connection.finish();
                        return Unit.INSTANCE;
                    }
                    cycleIndex = 0;
                    break block19;
                }
                case 3: {
                    cycleIndex = $continuation.I$0;
                    connection = (Obd2Connection)$continuation.L$1;
                    this = (OBDDispatcher)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                    break block19;
                }
                case 4: {
                    $i$f$forEach = false;
                    $i$a$-forEach-OBDDispatcher$startReadObdLooper$2 = false;
                    cycleIndex = $continuation.I$0;
                    var8_11 = (Iterator<T>)$continuation.L$2;
                    connection = (Obd2Connection)$continuation.L$1;
                    this = (OBDDispatcher)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        ** GOTO lbl94
                    }
                    catch (Throwable var5_8) {
                        connection.finish();
                        throw var5_8;
                    }
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
        while (this.isConnected(connection) && JobKt.isActive((CoroutineContext)$continuation.getContext())) {
            if (this.commandQueue.isEmpty()) {
                $continuation.L$0 = this;
                $continuation.L$1 = connection;
                $continuation.L$2 = null;
                $continuation.I$0 = cycleIndex;
                $continuation.label = 3;
                v2 = DelayKt.delay((long)500L, (Continuation)$continuation);
                if (v2 != var14_4) continue;
                return var14_4;
            }
            this.log.debug("Start new commandsRound " + cycleIndex);
            ++cycleIndex;
            $this$forEach$iv = this.commandQueue;
            $i$f$forEach = false;
            var8_11 = $this$forEach$iv.iterator();
lbl94:
            // 3 sources

            while (var8_11.hasNext()) {
                element$iv = var8_11.next();
                command = (OBDCommand)element$iv;
                $i$a$-forEach-OBDDispatcher$startReadObdLooper$2 = false;
                JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                $continuation.L$0 = this;
                $continuation.L$1 = connection;
                $continuation.L$2 = var8_11;
                $continuation.I$0 = cycleIndex;
                $continuation.label = 4;
                v3 = this.handleCommand(command, connection, (Continuation<? super OBDResponse>)$continuation);
                if (v3 != var14_4) continue;
                return var14_4;
            }
            JobKt.ensureActive((CoroutineContext)$continuation.getContext());
            OBDDataComputer.INSTANCE.acceptValue((Map<OBDCommand, ? extends OBDDataField<Object>>)this.sensorDataCache);
        }
        connection.finish();
        return Unit.INSTANCE;
    }

    private final UnderlyingTransport createTransport() {
        return new UnderlyingTransport(this){
            final /* synthetic */ OBDDispatcher this$0;
            {
                this.this$0 = $receiver;
            }

            public Object write(byte[] bytes, Continuation<? super Unit> $completion) {
                block0: {
                    Buffer buffer;
                    Buffer $this$write_u24lambda_u240 = buffer = new Buffer();
                    boolean bl = false;
                    $this$write_u24lambda_u240.write(bytes);
                    Buffer buffer2 = buffer;
                    Sink sink = OBDDispatcher.access$getOutputStream$p(this.this$0);
                    if (sink == null) break block0;
                    sink.write(buffer2, buffer2.size());
                }
                return Unit.INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            public Object read(Continuation<? super String> $completion) {
                if (!($completion instanceof createTransport.read.1)) ** GOTO lbl-1000
                var15_2 = $completion;
                if ((var15_2.label & -2147483648) != 0) {
                    var15_2.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        long J$0;
                        long J$1;
                        long J$2;
                        /* synthetic */ Object result;
                        final /* synthetic */ createTransport.1 this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.read((Continuation<? super String>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var16_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        readBuffer = new Buffer();
                        loopDelay = 100L;
                        ticks = 0L;
                        timeout = 15000L;
                        timeoutTicks = timeout / loopDelay;
lbl17:
                        // 2 sources

                        while (JobKt.isActive((CoroutineContext)$continuation.getContext())) {
                            v0 = OBDDispatcher.access$getInputStream$p(this.this$0);
                            v1 = bytesRead = v0 != null ? Boxing.boxLong((long)v0.read(readBuffer, 1024L)) : null;
                            if (bytesRead != null && bytesRead > 0L) {
                                return readBuffer.readUtf8();
                            }
                            v2 = bytesRead;
                            var12_11 = -1L;
                            if (v2 != null && v2 == var12_11) {
                                return UnderlyingTransport.Companion.getUNABLETOREAD();
                            }
                            if (ticks > timeoutTicks) {
                                return UnderlyingTransport.Companion.getTIMEOUT();
                            }
                            $continuation.L$0 = this;
                            $continuation.L$1 = readBuffer;
                            $continuation.J$0 = loopDelay;
                            $continuation.J$1 = ticks;
                            $continuation.J$2 = timeoutTicks;
                            $continuation.label = 1;
                            v3 = DelayKt.delay((long)loopDelay, (Continuation)$continuation);
                            if (v3 == var16_4) {
                                return var16_4;
                            }
                            ** GOTO lbl47
                        }
                        break;
                    }
                    case 1: {
                        timeoutTicks = $continuation.J$2;
                        ticks = $continuation.J$1;
                        loopDelay = $continuation.J$0;
                        readBuffer = (Buffer)$continuation.L$1;
                        this = $continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl47:
                        // 2 sources

                        var12_11 = ticks;
                        ticks = var12_11 + 1L;
                        ** GOTO lbl17
                    }
                }
                return UnderlyingTransport.Companion.getCONTEXTINACTIVE();
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
        };
    }

    private final boolean isConnected(Obd2Connection connection) {
        return this.inputStream != null && this.outputStream != null && !connection.isFinished();
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleCommand(OBDCommand var1_1, Obd2Connection var2_2, Continuation<? super OBDResponse> $completion) {
        if (!($completion instanceof handleCommand.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ OBDDispatcher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return OBDDispatcher.access$handleCommand(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (command.isStale() && this.sensorDataCache.get((Object)command) != null) {
                    return OBDResponse.Companion.getOK();
                }
                if (command.isTextCommand()) {
                    v0 = command.getTextCommand();
                    v1 = v0;
                    Intrinsics.checkNotNull((Object)v0);
                } else {
                    var5_7 = new Object[]{Boxing.boxInt((int)command.getCommandGroup()), Boxing.boxInt((int)command.getCommand())};
                    v1 = StringExtensionsKt.format("%02X%02X", var5_7);
                }
                fullCommand = v1;
                $continuation.L$0 = this;
                $continuation.L$1 = command;
                $continuation.label = 1;
                v2 = connection.run(fullCommand, command, (Continuation<? super OBDResponse>)$continuation);
                if (v2 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl34
            }
            case 1: {
                command = (OBDCommand)$continuation.L$1;
                this = (OBDDispatcher)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl34:
                // 2 sources

                it = commandResult = (OBDResponse)v2;
                $i$a$-let-OBDDispatcher$handleCommand$2 = false;
                if (it.isValid() && it.getResult().length >= command.getResponseLength()) {
                    ((Map)this.sensorDataCache).put(command, command.parseResponse(it.getResult()));
                } else if (Intrinsics.areEqual((Object)it, (Object)OBDResponse.Companion.getNO_DATA())) {
                    ((Map)this.sensorDataCache).put(command, OBDDataField.Companion.getNO_DATA());
                } else if (Intrinsics.areEqual((Object)it, (Object)OBDResponse.Companion.getCONNECTION_FAILURE())) {
                    v3 = this.readStatusListener;
                    if (v3 != null) {
                        v3.onIOError();
                    }
                } else {
                    this.log("Incorrect response length or unknown error for command " + command);
                }
                return commandResult;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void addCommand(@NotNull OBDCommand commandToRead) {
        Intrinsics.checkNotNullParameter((Object)((Object)commandToRead), (String)"commandToRead");
        if (!this.commandQueue.contains((Object)commandToRead)) {
            this.commandQueue = KCollectionUtils.INSTANCE.addToList((Collection)this.commandQueue, commandToRead);
        }
    }

    public final void clearCommands() {
        this.commandQueue = CollectionsKt.emptyList();
    }

    public final void removeCommand(@NotNull OBDCommand commandToStopReading) {
        Intrinsics.checkNotNullParameter((Object)((Object)commandToStopReading), (String)"commandToStopReading");
        this.commandQueue = KCollectionUtils.INSTANCE.removeFromList((Collection)this.commandQueue, commandToStopReading);
    }

    public final void setReadStatusListener(@Nullable OBDReadStatusListener listener) {
        this.readStatusListener = listener;
    }

    private final void cleanupResources() {
        this.inputStream = null;
        this.outputStream = null;
        OBDDataComputer.INSTANCE.clearCache();
        this.readStatusListener = null;
    }

    public final void stopReading() {
        this.log("stop reading");
        CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
        this.log("after stop reading");
    }

    @NotNull
    public final HashMap<OBDCommand, OBDDataField<Object>> getRawData() {
        return new HashMap<OBDCommand, OBDDataField<Object>>((Map)this.sensorDataCache);
    }

    private final void log(String msg) {
        if (this.debug) {
            this.log.debug(msg);
        } else {
            this.log.info(msg);
        }
    }

    public OBDDispatcher() {
        this(false, 1, null);
    }

    public static final /* synthetic */ void access$setInputStream$p(OBDDispatcher $this, Source source) {
        $this.inputStream = source;
    }

    public static final /* synthetic */ void access$setOutputStream$p(OBDDispatcher $this, Sink sink) {
        $this.outputStream = sink;
    }

    public static final /* synthetic */ Object access$startReadObdLooper(OBDDispatcher $this, Continuation $completion) {
        return $this.startReadObdLooper((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$log(OBDDispatcher $this, String msg) {
        $this.log(msg);
    }

    public static final /* synthetic */ Logger access$getLog$p(OBDDispatcher $this) {
        return $this.log;
    }

    public static final /* synthetic */ OBDReadStatusListener access$getReadStatusListener$p(OBDDispatcher $this) {
        return $this.readStatusListener;
    }

    public static final /* synthetic */ void access$cleanupResources(OBDDispatcher $this) {
        $this.cleanupResources();
    }

    public static final /* synthetic */ Sink access$getOutputStream$p(OBDDispatcher $this) {
        return $this.outputStream;
    }

    public static final /* synthetic */ Source access$getInputStream$p(OBDDispatcher $this) {
        return $this.inputStream;
    }

    public static final /* synthetic */ Object access$handleCommand(OBDDispatcher $this, OBDCommand command, Obd2Connection connection, Continuation $completion) {
        return $this.handleCommand(command, connection, (Continuation<? super OBDResponse>)$completion);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lnet/osmand/shared/obd/OBDDispatcher$OBDReadStatusListener;", "", "onIOError", "", "OsmAnd-shared"})
    public static interface OBDReadStatusListener {
        public void onIOError();
    }
}

