/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.osmand.shared.KException;
import net.osmand.shared.gpx.GpxFile;
import net.osmand.shared.gpx.GpxUtilities;
import net.osmand.shared.gpx.helper.ImportHelper;
import net.osmand.shared.xml.XmlPullParser;
import net.osmand.shared.xml.XmlSerializer;
import okio.Buffer;
import okio.BufferedSink;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005J\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0018\u001a\u00020\u0014J\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u001a\u001a\u00020\u0005J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\"\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020 J*\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020&H\u0002J\u001a\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020$2\b\u0010+\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010,\u001a\u00020*2\u0006\u0010#\u001a\u00020$H\u0002J6\u0010-\u001a\u00020*2\u0006\u0010#\u001a\u00020$2\b\u0010.\u001a\u0004\u0018\u00010\u00052\b\u0010/\u001a\u0004\u0018\u00010\u00052\u0006\u00100\u001a\u00020\u00052\b\u00101\u001a\u0004\u0018\u00010\u0005H\u0002J6\u00102\u001a\u00020*2\u0006\u0010#\u001a\u00020$2\b\u0010.\u001a\u0004\u0018\u00010\u00052\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0005032\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000503H\u0002J\u0016\u00105\u001a\b\u0012\u0004\u0012\u000206032\u0006\u00100\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lnet/osmand/shared/gpx/helper/ImportGpx;", "", "<init>", "()V", "FEATURE_PROCESS_NAMESPACES", "", "TAG_FOLDER", "TAG_DOCUMENT", "TAG_PLACEMARK", "TAG_GX_TRACK", "TAG_NAME", "TAG_DESC", "TAG_COORDS", "TAG_GX_COORD", "TAG_WHEN", "loadGpxWithFileSize", "Lkotlin/Pair;", "Lnet/osmand/shared/gpx/GpxFile;", "", "source", "Lokio/Source;", "fileName", "importFile", "loadGPXFileFromKml", "kml", "errorImport", "msg", "convertKmlToGpxString", "convertKmlToGpxStream", "outputSink", "Lokio/BufferedSink;", "flushEvery", "", "parseKmlStreaming", "inputStream", "serializer", "Lnet/osmand/shared/xml/XmlSerializer;", "sink", "Lokio/Sink;", "startGpxDocument", "output", "writeMetadata", "", "documentName", "endGpxDocument", "writePlacemarkAsGpx", "name", "desc", "coords", "parentName", "writeGxTrackAsGpx", "", "times", "parseCoordinates", "Lnet/osmand/shared/gpx/helper/ImportGpx$PointData;", "PointData", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nImportGpx.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportGpx.kt\nnet/osmand/shared/gpx/helper/ImportGpx\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,279:1\n1#2:280\n1#2:296\n1#2:311\n1863#3,2:281\n1577#3,11:283\n1872#3,2:294\n1874#3:297\n1588#3:298\n1863#3,2:299\n1611#3,9:301\n1863#3:310\n1864#3:312\n1620#3:313\n*S KotlinDebug\n*F\n+ 1 ImportGpx.kt\nnet/osmand/shared/gpx/helper/ImportGpx\n*L\n237#1:296\n266#1:311\n219#1:281,2\n237#1:283,11\n237#1:294,2\n237#1:297\n237#1:298\n253#1:299,2\n266#1:301,9\n266#1:310\n266#1:312\n266#1:313\n*E\n"})
public final class ImportGpx {
    @NotNull
    public static final ImportGpx INSTANCE = new ImportGpx();
    @NotNull
    private static final String FEATURE_PROCESS_NAMESPACES = "http://xmlpull.org/v1/doc/features.html#process-namespaces";
    @NotNull
    private static final String TAG_FOLDER = "Folder";
    @NotNull
    private static final String TAG_DOCUMENT = "Document";
    @NotNull
    private static final String TAG_PLACEMARK = "Placemark";
    @NotNull
    private static final String TAG_GX_TRACK = "gx:Track";
    @NotNull
    private static final String TAG_NAME = "name";
    @NotNull
    private static final String TAG_DESC = "description";
    @NotNull
    private static final String TAG_COORDS = "coordinates";
    @NotNull
    private static final String TAG_GX_COORD = "gx:coord";
    @NotNull
    private static final String TAG_WHEN = "when";

    private ImportGpx() {
    }

    @NotNull
    public final Pair<GpxFile, Long> loadGpxWithFileSize(@NotNull Source source, @NotNull String fileName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return StringsKt.endsWith$default((String)fileName, (String)".kml", (boolean)false, (int)2, null) ? this.loadGPXFileFromKml(source) : (StringsKt.endsWith$default((String)fileName, (String)".kmz", (boolean)false, (int)2, null) ? ImportHelper.INSTANCE.loadGPXFileFromArchive(source) : (StringsKt.endsWith$default((String)fileName, (String)".zip", (boolean)false, (int)2, null) ? ImportHelper.INSTANCE.loadGPXFileFromArchive(source) : this.errorImport("Unsupported file extension: " + fileName)));
    }

    @NotNull
    public final GpxFile importFile(@NotNull Source source, @NotNull String fileName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return (GpxFile)this.loadGpxWithFileSize(source, fileName).getFirst();
    }

    @NotNull
    public final Pair<GpxFile, Long> loadGPXFileFromKml(@NotNull Source kml) throws IOException {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)kml, (String)"kml");
        try {
            String res = this.convertKmlToGpxString(kml);
            byte[] byteStr = StringsKt.encodeToByteArray((String)res);
            Source gpxStream = (Source)new Buffer().write(byteStr);
            pair = new Pair((Object)GpxUtilities.INSTANCE.loadGpxFile(gpxStream), (Object)byteStr.length);
        }
        catch (Exception e) {
            pair = this.errorImport("KML to GPX transform error: " + e.getMessage());
        }
        return pair;
    }

    @NotNull
    public final Pair<GpxFile, Long> errorImport(@NotNull String msg) {
        GpxFile gpxFile;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        GpxFile $this$errorImport_u24lambda_u240 = gpxFile = new GpxFile(null);
        boolean bl = false;
        $this$errorImport_u24lambda_u240.setError(new KException(msg));
        GpxFile gpxFile2 = gpxFile;
        return new Pair((Object)gpxFile2, (Object)0L);
    }

    private final String convertKmlToGpxString(Source kml) {
        Buffer writer2 = new Buffer();
        XmlSerializer serializer2 = this.startGpxDocument((Sink)writer2);
        String documentName = this.parseKmlStreaming(kml, serializer2, (Sink)writer2, Integer.MAX_VALUE);
        this.writeMetadata(serializer2, documentName);
        this.endGpxDocument(serializer2);
        return writer2.readUtf8();
    }

    @Nullable
    public final String convertKmlToGpxStream(@NotNull Source kml, @NotNull BufferedSink outputSink, int flushEvery) {
        Intrinsics.checkNotNullParameter((Object)kml, (String)"kml");
        Intrinsics.checkNotNullParameter((Object)outputSink, (String)"outputSink");
        XmlSerializer serializer2 = this.startGpxDocument((Sink)outputSink);
        String documentName = this.parseKmlStreaming(kml, serializer2, (Sink)outputSink, flushEvery);
        this.writeMetadata(serializer2, documentName);
        this.endGpxDocument(serializer2);
        outputSink.flush();
        return documentName;
    }

    public static /* synthetic */ String convertKmlToGpxStream$default(ImportGpx importGpx, Source source, BufferedSink bufferedSink, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 100;
        }
        return importGpx.convertKmlToGpxStream(source, bufferedSink, n);
    }

    /*
     * Unable to fully structure code
     */
    private final String parseKmlStreaming(Source inputStream, XmlSerializer serializer, Sink sink, int flushEvery) {
        $this$parseKmlStreaming_u24lambda_u241 = var6_5 = new XmlPullParser();
        $i$a$-apply-ImportGpx$parseKmlStreaming$parser$1 = false;
        $this$parseKmlStreaming_u24lambda_u241.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
        $this$parseKmlStreaming_u24lambda_u241.setInput(inputStream, null);
        parser = var6_5;
        folderNameStack = new ArrayDeque();
        documentName = null;
        currentPlacemarkName = null;
        currentPlacemarkDesc = null;
        currentCoordinates = null;
        isGxTrack = false;
        gxCoords = new ArrayList<E>();
        gxWhens = new ArrayList<E>();
        elementCount = 0;
        while (true) {
            switch (parser.getEventType()) {
                case 2: {
                    var15_16 = parser.getName();
                    if (var15_16 == null) break;
                    tmp = -1;
                    switch (var15_16.hashCode()) {
                        case -11343518: {
                            if (var15_16.equals("gx:Track")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case -498064332: {
                            if (var15_16.equals("Placemark")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case 3373707: {
                            if (var15_16.equals("name")) {
                                tmp = 3;
                            }
                            break;
                        }
                        case 1871919611: {
                            if (var15_16.equals("coordinates")) {
                                tmp = 4;
                            }
                            break;
                        }
                        case -1724546052: {
                            if (var15_16.equals("description")) {
                                tmp = 5;
                            }
                            break;
                        }
                        case 2433836: {
                            if (var15_16.equals("gx:coord")) {
                                tmp = 6;
                            }
                            break;
                        }
                        case 2109868174: {
                            if (var15_16.equals("Folder")) {
                                tmp = 7;
                            }
                            break;
                        }
                        case 926364987: {
                            if (var15_16.equals("Document")) {
                                tmp = 8;
                            }
                            break;
                        }
                        case 3648314: {
                            if (var15_16.equals("when")) {
                                tmp = 9;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 7: {
                            folderNameStack.addLast((Object)"");
                            break;
                        }
                        case 8: {
                            documentName = "";
                            break;
                        }
                        case 2: {
                            currentPlacemarkName = null;
                            currentPlacemarkDesc = null;
                            currentCoordinates = null;
                            break;
                        }
                        case 1: {
                            isGxTrack = true;
                            break;
                        }
                        case 3: {
                            text = parser.nextText();
                            if (Intrinsics.areEqual((Object)documentName, (Object)"")) {
                                documentName = text;
                                break;
                            }
                            if (((Collection)folderNameStack).isEmpty() == false) {
                                folderNameStack.set(CollectionsKt.getLastIndex((List)((List)folderNameStack)), (Object)text);
                                break;
                            }
                            currentPlacemarkName = text;
                            break;
                        }
                        case 5: {
                            currentPlacemarkDesc = parser.nextText();
                            break;
                        }
                        case 4: {
                            currentCoordinates = parser.nextText();
                            break;
                        }
                        case 6: {
                            if (!isGxTrack) break;
                            gxCoords.add(parser.nextText());
                            break;
                        }
                        case 9: {
                            if (!isGxTrack) break;
                            gxWhens.add(parser.nextText());
                        }
                    }
                    break;
                }
                case 3: {
                    var15_16 = parser.getName();
                    if (var15_16 == null) break;
                    switch (var15_16.hashCode()) {
                        case -11343518: {
                            if (!var15_16.equals("gx:Track")) {
                                ** break;
                            }
                            ** GOTO lbl137
                        }
                        case -498064332: {
                            if (var15_16.equals("Placemark")) break;
                            ** break;
                        }
                        case 2109868174: {
                            if (!var15_16.equals("Folder")) ** break;
                            folderNameStack.removeLastOrNull();
                            ** break;
                        }
                    }
                    if (currentCoordinates == null) break;
                    v0 = (String)folderNameStack.lastOrNull();
                    if (v0 == null) {
                        v0 = documentName;
                    }
                    this.writePlacemarkAsGpx(serializer, currentPlacemarkName, currentPlacemarkDesc, currentCoordinates, v0);
                    ++elementCount;
                    break;
lbl137:
                    // 1 sources

                    this.writeGxTrackAsGpx(serializer, currentPlacemarkName, gxCoords, gxWhens);
                    isGxTrack = false;
                    gxCoords.clear();
                    gxWhens.clear();
                    ++elementCount;
lbl142:
                    // 6 sources

                    break;
                }
                case 1: {
                    return documentName;
                }
            }
            if (elementCount >= flushEvery) {
                sink.flush();
                elementCount = 0;
            }
            parser.next();
        }
    }

    private final XmlSerializer startGpxDocument(Sink output) {
        XmlSerializer serializer2 = new XmlSerializer();
        Sink sink = output;
        if (!(sink instanceof Buffer) && !(sink instanceof BufferedSink)) {
            throw new IllegalArgumentException("Unsupported output type: " + output);
        }
        serializer2.setOutput(output);
        serializer2.startDocument("UTF-8", true);
        serializer2.setPrefix("gpx", "http://www.topografix.com/GPX/1/1");
        serializer2.startTag(null, "gpx").attribute(null, "version", "1.1").attribute(null, "creator", "KML to GPX Converter");
        return serializer2;
    }

    private final void writeMetadata(XmlSerializer serializer2, String documentName) {
        block0: {
            String string = documentName;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            serializer2.startTag(null, "metadata").startTag(null, TAG_NAME).text(it).endTag(null, TAG_NAME).endTag(null, "metadata");
        }
    }

    private final void endGpxDocument(XmlSerializer serializer2) {
        serializer2.endTag(null, "gpx");
        serializer2.endDocument();
    }

    private final void writePlacemarkAsGpx(XmlSerializer serializer2, String name, String desc, String coords, String parentName) {
        List<PointData> points = this.parseCoordinates(coords);
        if (points.isEmpty()) {
            return;
        }
        if (points.size() == 1) {
            String it;
            PointData point = (PointData)CollectionsKt.first(points);
            serializer2.startTag(null, "wpt").attribute(null, "lat", point.getLat()).attribute(null, "lon", point.getLon());
            String string = point.getEle();
            if (string != null) {
                String it2 = string;
                boolean bl = false;
                serializer2.startTag(null, "ele").text(it2).endTag(null, "ele");
            }
            String string2 = name;
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                serializer2.startTag(null, TAG_NAME).text(it).endTag(null, TAG_NAME);
            }
            String string3 = desc;
            if (string3 != null) {
                it = string3;
                boolean bl = false;
                serializer2.startTag(null, "desc").text(it).endTag(null, "desc");
            }
            String string4 = parentName;
            if (string4 != null) {
                it = string4;
                boolean bl = false;
                serializer2.startTag(null, "type").text(it).endTag(null, "type");
            }
            v4 = serializer2.endTag(null, "wpt");
        } else {
            serializer2.startTag(null, "trk");
            String string = name;
            if (string != null) {
                String it = string;
                boolean bl = false;
                serializer2.startTag(null, TAG_NAME).text(it).endTag(null, TAG_NAME);
            }
            serializer2.startTag(null, "trkseg");
            Iterable $this$forEach$iv = points;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PointData pt = (PointData)element$iv;
                boolean bl = false;
                serializer2.startTag(null, "trkpt").attribute(null, "lat", pt.getLat()).attribute(null, "lon", pt.getLon());
                if (pt.getEle() != null) {
                    String it;
                    boolean bl2 = false;
                    serializer2.startTag(null, "ele").text(it).endTag(null, "ele");
                }
                serializer2.endTag(null, "trkpt");
            }
            serializer2.endTag(null, "trkseg");
            v4 = serializer2.endTag(null, "trk");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeGxTrackAsGpx(XmlSerializer serializer2, String name, List<String> coords, List<String> times) {
        void $this$mapIndexedNotNullTo$iv$iv;
        Iterable $this$mapIndexedNotNull$iv = coords;
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            PointData it$iv$iv;
            void coordString;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            String string = (String)element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            String[] stringArray = new String[]{" "};
            List parts = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)((CharSequence)coordString))).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if ((parts.size() >= 2 ? new PointData((String)parts.get(0), (String)parts.get(1), (String)CollectionsKt.getOrNull((List)parts, (int)2), (String)CollectionsKt.getOrNull(times, (int)index)) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List trackPoints = (List)destination$iv$iv;
        if (trackPoints.isEmpty()) {
            return;
        }
        serializer2.startTag(null, "trk");
        String string = name;
        if (string != null) {
            String it = string;
            boolean bl = false;
            serializer2.startTag(null, TAG_NAME).text(it).endTag(null, TAG_NAME);
        }
        serializer2.startTag(null, "trkseg");
        Iterable $this$forEach$iv = trackPoints;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PointData point = (PointData)element$iv;
            boolean bl = false;
            serializer2.startTag(null, "trkpt").attribute(null, "lat", point.getLat()).attribute(null, "lon", point.getLon());
            if (point.getEle() != null) {
                String it;
                boolean bl4 = false;
                serializer2.startTag(null, "ele").text(it).endTag(null, "ele");
            }
            if (point.getTime() != null) {
                String it;
                boolean bl5 = false;
                serializer2.startTag(null, "time").text(it).endTag(null, "time");
            }
            serializer2.endTag(null, "trkpt");
        }
        serializer2.endTag(null, "trkseg");
        serializer2.endTag(null, "trk");
    }

    /*
     * WARNING - void declaration
     */
    private final List<PointData> parseCoordinates(String coords) {
        void $this$mapNotNullTo$iv$iv;
        String[] stringArray = new String[]{" "};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)coords)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PointData it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String pointString = (String)element$iv$iv;
            boolean bl2 = false;
            String[] stringArray2 = new String[]{","};
            List parts = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)pointString)).toString(), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            if ((parts.size() >= 2 ? new PointData((String)parts.get(0), (String)parts.get(1), (String)CollectionsKt.getOrNull((List)parts, (int)2), null, 8, null) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J5\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lnet/osmand/shared/gpx/helper/ImportGpx$PointData;", "", "lon", "", "lat", "ele", "time", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLon", "()Ljava/lang/String;", "getLat", "getEle", "getTime", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "OsmAnd-shared"})
    public static final class PointData {
        @NotNull
        private final String lon;
        @NotNull
        private final String lat;
        @Nullable
        private final String ele;
        @Nullable
        private final String time;

        public PointData(@NotNull String lon, @NotNull String lat, @Nullable String ele, @Nullable String time) {
            Intrinsics.checkNotNullParameter((Object)lon, (String)"lon");
            Intrinsics.checkNotNullParameter((Object)lat, (String)"lat");
            this.lon = lon;
            this.lat = lat;
            this.ele = ele;
            this.time = time;
        }

        public /* synthetic */ PointData(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            this(string, string2, string3, string4);
        }

        @NotNull
        public final String getLon() {
            return this.lon;
        }

        @NotNull
        public final String getLat() {
            return this.lat;
        }

        @Nullable
        public final String getEle() {
            return this.ele;
        }

        @Nullable
        public final String getTime() {
            return this.time;
        }

        @NotNull
        public final String component1() {
            return this.lon;
        }

        @NotNull
        public final String component2() {
            return this.lat;
        }

        @Nullable
        public final String component3() {
            return this.ele;
        }

        @Nullable
        public final String component4() {
            return this.time;
        }

        @NotNull
        public final PointData copy(@NotNull String lon, @NotNull String lat, @Nullable String ele, @Nullable String time) {
            Intrinsics.checkNotNullParameter((Object)lon, (String)"lon");
            Intrinsics.checkNotNullParameter((Object)lat, (String)"lat");
            return new PointData(lon, lat, ele, time);
        }

        public static /* synthetic */ PointData copy$default(PointData pointData, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = pointData.lon;
            }
            if ((n & 2) != 0) {
                string2 = pointData.lat;
            }
            if ((n & 4) != 0) {
                string3 = pointData.ele;
            }
            if ((n & 8) != 0) {
                string4 = pointData.time;
            }
            return pointData.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "PointData(lon=" + this.lon + ", lat=" + this.lat + ", ele=" + this.ele + ", time=" + this.time + ")";
        }

        public int hashCode() {
            int result = this.lon.hashCode();
            result = result * 31 + this.lat.hashCode();
            result = result * 31 + (this.ele == null ? 0 : this.ele.hashCode());
            result = result * 31 + (this.time == null ? 0 : this.time.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PointData)) {
                return false;
            }
            PointData pointData = (PointData)other;
            if (!Intrinsics.areEqual((Object)this.lon, (Object)pointData.lon)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lat, (Object)pointData.lat)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ele, (Object)pointData.ele)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.time, (Object)pointData.time);
        }
    }
}

