/*
 * Decompiled with CFR 0.152.
 */
package rtree;

import rtree.Element;

public class ABL
implements Cloneable {
    public Element element;
    public long minDist;

    public ABL(Element element, long minDist) {
        this.element = element;
        this.minDist = minDist;
    }

    public void mergeSort(ABL[] arrABL) {
        this.twoWayMerge(arrABL, 0, arrABL.length - 1);
    }

    private void twoWayMerge(ABL[] arrABL, int start, int finish) {
        try {
            int size = finish - start + 1;
            if (size <= 2) {
                if (size < 2) {
                    return;
                }
                if (arrABL[start].minDist > arrABL[finish].minDist) {
                    ABL temp = arrABL[start];
                    arrABL[start] = arrABL[finish];
                    arrABL[finish] = temp;
                }
                return;
            }
            Double middle = new Double(start + finish);
            middle = new Double(Math.ceil(middle / 2.0));
            this.twoWayMerge(arrABL, start, middle.intValue());
            this.twoWayMerge(arrABL, middle.intValue(), finish);
            this.simpleMerge(arrABL, start, middle.intValue(), finish);
        }
        catch (Exception e) {
            System.out.println("rtree.ABL.twoWayMerge: most probably a null value in array");
        }
    }

    private void simpleMerge(ABL[] arrABL, int first, int second, int third) throws Exception {
        int i = first;
        int j = second;
        int l = 0;
        ABL[] temp = new ABL[third - first + 1];
        while (i < second && j <= third) {
            if (arrABL[i].minDist <= arrABL[j].minDist) {
                temp[l++] = arrABL[i++];
                continue;
            }
            temp[l++] = arrABL[j++];
        }
        if (i >= second) {
            while (j <= third) {
                temp[l++] = arrABL[j++];
            }
        } else {
            while (i < second) {
                temp[l++] = arrABL[i++];
            }
        }
        System.arraycopy(temp, 0, arrABL, first, temp.length);
    }

    public Object clone() {
        return new ABL(this.element, this.minDist);
    }
}

